/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.caching;

import com.sas.tkts.caching.AbstractRowCache;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.FSPreparedStatement;
import com.sas.tkts.sql.FSRowSetMetaData;
import com.sas.tkts.sql.FSStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;

public class RowSetCache
extends AbstractRowCache
implements RowSetReader {
    private static String thisClassName = RowSetCache.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    private transient boolean isCachePopulated = false;

    public RowSetCache() {
        String method = "RowSetCache";
        if (AbstractLogger.isTrace) {
            logger.entry("RowSetCache");
        }
    }

    @Override
    public void readData(RowSetInternal rowSet) throws SQLException {
        block18: {
            String method = "readData(rowSet)";
            FSConnection connection = null;
            FSStatement pStmt = null;
            if (AbstractLogger.isTrace) {
                logger.entry("readData(rowSet)");
            }
            try {
                boolean readOnly;
                connection = (FSConnection)rowSet.getConnection();
                this.packType = connection.getPackType();
                int fetchSize = ((RowSet)((Object)rowSet)).getFetchSize();
                int maxRows = ((RowSet)((Object)rowSet)).getMaxRows();
                int maxColumnSize = ((RowSet)((Object)rowSet)).getMaxFieldSize();
                int tranIsolationLevel = ((RowSet)((Object)rowSet)).getTransactionIsolation();
                if (tranIsolationLevel != 0) {
                    connection.setTransactionIsolation(tranIsolationLevel);
                }
                if (readOnly = ((RowSet)((Object)rowSet)).isReadOnly()) {
                    connection.setReadOnly(true);
                }
                int rSetConcurrency = ((RowSet)((Object)rowSet)).getConcurrency();
                int rSetType = ((RowSet)((Object)rowSet)).getType();
                pStmt = (FSPreparedStatement)connection.prepareStatement(((RowSet)((Object)rowSet)).getCommand(), rSetType, rSetConcurrency);
                this.statementWrapper = pStmt.getStatementWrapper();
                if (maxRows != 0) {
                    pStmt.setMaxRows(maxRows);
                }
                if (maxColumnSize != 0) {
                    pStmt.setMaxFieldSize(maxColumnSize);
                }
                pStmt.setFetchSize(fetchSize);
                fetchSize = fetchSize == 0 ? pStmt.getFetchSize() : fetchSize;
                pStmt.setAttribute(27, fetchSize);
                ParameterInfo[] params = (ParameterInfo[])rowSet.getParams();
                if (params != null) {
                    this.setParameters((PreparedStatement)((Object)pStmt), params);
                }
                ((FSPreparedStatement)pStmt).setRowSetUsage(true);
                ((FSPreparedStatement)pStmt).execute();
                this._COLUMN_INFO_ARRAY = pStmt.getColumnInfoArray();
                this.fsStatement = pStmt;
                RowSetCache.clearRDC(this._ROWS_DATA_CACHE);
                boolean rowsLeft = true;
                while (rowsLeft) {
                    rowsLeft = this.fetch(0, null, 1);
                }
                FSRowSetMetaData rowSetMD = new FSRowSetMetaData(this, this.statementWrapper);
                rowSet.setMetaData(rowSetMD);
                this.close();
                this.isCachePopulated = true;
                this.rowCount = this._ROWS_DATA_CACHE.size();
                this.setCursorPosition(-1, 0);
                ((FSPreparedStatement)pStmt).close();
                connection.close();
            }
            catch (SQLException se) {
                block17: {
                    if (AbstractLogger.isError) {
                        logger.trace("readData(rowSet)", se.getMessage());
                    }
                    try {
                        if (pStmt != null && !pStmt.isClosed()) {
                            ((FSPreparedStatement)pStmt).close();
                        }
                    }
                    catch (SQLException se1) {
                        if (!AbstractLogger.isError) break block17;
                        logger.trace("readData(rowSet)", se1.getMessage());
                    }
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException se1) {
                    if (!AbstractLogger.isError) break block18;
                    logger.trace("readData(rowSet)", se1.getMessage());
                }
            }
        }
        if (AbstractLogger.isTrace) {
            logger.exit("readData(rowSet)", "Cache size = " + this.rowCount);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        return !this._ROWS_DATA_CACHE.isEmpty() && this.cacheCURSOR == this.rowCount - 1 && this.rSetCURSOR == this.rowCount;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.first();
        this.setCursorPosition(-1, 0);
        this.isValidRow = false;
    }

    @Override
    public boolean first() throws SQLException {
        if (!this._ROWS_DATA_CACHE.isEmpty()) {
            this.setCursorPosition(0, 1);
            this.isValidRow = true;
        } else {
            this.setCursorPosition(-1, 0);
            this.isValidRow = false;
        }
        return this.isValidRow;
    }

    @Override
    public boolean next() throws SQLException {
        this.isValidRow = true;
        if (this._ROWS_DATA_CACHE.isEmpty() || this.isAfterLast()) {
            this.isValidRow = false;
        } else {
            boolean isLastRowInCache;
            int rowsInCache = this._ROWS_DATA_CACHE.size();
            int lastCacheIndx = rowsInCache - 1;
            boolean bl = isLastRowInCache = this.cacheCURSOR == lastCacheIndx && this.rSetCURSOR == rowsInCache;
            if (isLastRowInCache) {
                this.isValidRow = false;
                this.setCursorPositionAfterLast(this.cacheCURSOR + 1, this.rSetCURSOR + 1);
                this.afterLast = true;
            } else {
                this.setCursorPosition(this.cacheCURSOR + 1, this.rSetCURSOR + 1);
            }
            if (isLastRowInCache) {
                this.isValidRow = false;
            }
        }
        return this.isValidRow;
    }

    @Override
    public boolean previous() throws SQLException {
        this.isValidRow = true;
        if (this._ROWS_DATA_CACHE.isEmpty() || this.isBeforeFirst()) {
            this.isValidRow = false;
        } else if (this.cacheCURSOR > 0 && this.rSetCURSOR > 1) {
            this.setCursorPosition(this.cacheCURSOR - 1, this.rSetCURSOR - 1);
        } else if (this.cacheCURSOR < 0 && this.rSetCURSOR == 0) {
            this.isValidRow = false;
        } else if (this.cacheCURSOR == 0 && this.rSetCURSOR == 1) {
            this.setCursorPosition(-1, 0);
            this.isValidRow = false;
        }
        return this.isValidRow;
    }

    @Override
    public boolean last() throws SQLException {
        this.isValidRow = true;
        if (!this._ROWS_DATA_CACHE.isEmpty()) {
            this.setCursorPosition(this.rowCount - 1, this.rowCount);
        } else {
            this.isValidRow = false;
        }
        return this.isValidRow;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.last()) {
            this.next();
        }
    }

    @Override
    public boolean absolute(int desiredRowNumber) throws SQLException {
        this.isValidRow = true;
        if (desiredRowNumber == 0) {
            this.beforeFirst();
        } else if (desiredRowNumber > 0) {
            if (desiredRowNumber > this.rowCount) {
                this.isValidRow = false;
                this.cacheCURSOR = this.rowCount;
                this.rSetCURSOR = this.rowCount + 1;
                this.afterLast = true;
            } else {
                this.setCursorPosition(desiredRowNumber - 1, desiredRowNumber);
            }
        } else if (desiredRowNumber < 0) {
            int destinationRowNumber = this.rowCount + desiredRowNumber;
            if (destinationRowNumber < 0) {
                this.setCursorPosition(-1, 0);
                this.isValidRow = false;
            } else {
                this.setCursorPosition(destinationRowNumber, destinationRowNumber + 1);
            }
        }
        return this.isValidRow;
    }

    @Override
    public boolean relative(int distance) throws SQLException {
        String method = "relative(distance)";
        if (AbstractLogger.isTrace) {
            logger.entry("relative(distance)", "distance=" + distance);
        }
        this.isValidRow = true;
        if (distance == 0) {
            if (this.isBeforeFirst() || this.isAfterLast()) {
                this.isValidRow = false;
            }
        } else if (distance == -1) {
            this.isValidRow = this.previous();
        } else if (distance == 1) {
            this.isValidRow = this.next();
        } else {
            int destinationRowNumber = this.rSetCURSOR + distance;
            if (destinationRowNumber < 1) {
                this.setCursorPosition(-1, 0);
                this.isValidRow = false;
            } else {
                this.isValidRow = this.absolute(destinationRowNumber);
            }
        }
        return this.isValidRow;
    }

    @Override
    protected boolean fetch(int fetchOffset, String[] bookmarks, int fetchOrientation) throws SQLException {
        String method = "fetch(fetchOffset,bookmarks,fetchOrientation)";
        boolean result = false;
        if (AbstractLogger.isTrace) {
            logger.trace("fetch(fetchOffset,bookmarks,fetchOrientation)", "Calling fetch.");
        }
        result = this.isCachePopulated ? false : this.commonFetch(fetchOffset, bookmarks, fetchOrientation, true);
        if (AbstractLogger.isTrace) {
            logger.exit("fetch(fetchOffset,bookmarks,fetchOrientation)", " result[" + result + "] ");
        }
        return result;
    }

    private void setParameters(PreparedStatement statement, ParameterInfo[] parameterInfoArray) throws SQLException {
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            ParameterInfo pi = parameterInfoArray[i];
            statement.setObject(i + 1, pi.getValue(), pi.getSQLType(), pi.getDecimalDigits());
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        int rowsInCache = this._ROWS_DATA_CACHE.size();
        return rowsInCache > 0 && this.cacheCURSOR >= rowsInCache;
    }

    public void close() throws SQLException {
        boolean releaseCache = false;
        super.close(releaseCache);
    }
}

