/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.caching;

import com.sas.tkts.caching.AbstractRowCache;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSStatement;
import java.sql.SQLException;

public class RowCache
extends AbstractRowCache {
    private static String thisClassName = RowCache.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);

    public RowCache(StatementWrapper stmtWapper) throws SQLException {
        this(null, stmtWapper, 0, false);
    }

    private String getEntryParms(int inColumnCount) {
        String format = "columnCount[%s] useBookmarks[%s]";
        String out = String.format("columnCount[%s] useBookmarks[%s]", inColumnCount, this.isUseBookmarks);
        return out;
    }

    protected boolean hasLongColumns() {
        for (int i = 0; i < this._COLUMN_INFO_ARRAY.length; ++i) {
            ParameterInfo ca = this._COLUMN_INFO_ARRAY[i];
            if (!RowCache.isLongVar(ca.getSQLType())) continue;
            return true;
        }
        return false;
    }

    public RowCache(FSStatement stmtObj, StatementWrapper stmtWapper, int columnCount, boolean useBookmarks) throws SQLException {
        String method = "RowCache";
        if (AbstractLogger.isTrace) {
            logger.entry(method, this.getEntryParms(columnCount));
        }
        this.statementWrapper = stmtWapper;
        this.isUseBookmarks = useBookmarks;
        this.determinePackType();
        if (stmtObj != null) {
            this.fsStatement = stmtObj;
            this.resultSetType = this.fsStatement.getResultSetType();
            this.resultSetConcurrency = this.fsStatement.getResultSetConcurrency();
            this._COLUMN_INFO_ARRAY = this.fsStatement.getColumnInfoArray();
            this.fetchSize = this.fsStatement.getFetchSize();
        } else {
            this.isMetadataCache = true;
        }
        boolean stmtPrefetch = false;
        if (!this.hasLongColumns()) {
            if (stmtObj != null) {
                stmtPrefetch = stmtObj.getPrefetch();
            } else if (stmtWapper != null) {
                stmtPrefetch = stmtWapper.getPrefetch();
            }
        }
        this.setPrefetch(stmtPrefetch);
        this.next();
        this.setCursorPosition(-1, 0);
        if (AbstractLogger.isTrace) {
            this.logCursorPosition();
            logger.exit(method);
        }
    }

    public void close() throws SQLException {
        boolean cleanCache = true;
        super.close(cleanCache);
    }
}

