/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.caching;

import com.sas.tkts.types.AbstractColumn;

public class Row
implements Cloneable {
    private transient AbstractColumn[] _COLUMNS_DATA;
    private transient String[] bookmarks;
    private transient boolean isAvailable;
    protected int status;

    public Row(int columnCount) {
        this._COLUMNS_DATA = new AbstractColumn[columnCount];
    }

    public int size() {
        return this._COLUMNS_DATA.length;
    }

    public boolean setColumnData(int column, AbstractColumn data) throws IndexOutOfBoundsException {
        this._COLUMNS_DATA[column] = data;
        return true;
    }

    public AbstractColumn getColumnData(int column) throws IndexOutOfBoundsException {
        return this._COLUMNS_DATA[column];
    }

    public int getNumberOfColumns() {
        return this._COLUMNS_DATA.length;
    }

    public boolean isInvalid() {
        return this.status == 5 || this.status == 1;
    }

    public void setBookmarks(String[] value) {
        this.bookmarks = (String[])value.clone();
    }

    public String[] getBookmarks() {
        return (String[])this.bookmarks.clone();
    }

    public int getBookmarkLength() {
        return this.bookmarks.length;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setAvailable(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public String logString() {
        String s = "[ ";
        if (this._COLUMNS_DATA == null) {
            s = s + "_COLUMNS_DATA = null";
            return s;
        }
        int m = this.size();
        for (int i = 0; i < m; ++i) {
            s = this._COLUMNS_DATA[i] == null ? s + "NULLPTR" : (this._COLUMNS_DATA[i].isNull() ? s + "NULL" : s + this._COLUMNS_DATA[i]);
            if (i + 1 >= m) continue;
            s = s + ", ";
        }
        s = s + "] \n";
        return s;
    }

    public String toString() {
        String isA = " ";
        if (this.isAvailable) {
            isA = " isAvailable ";
        }
        String outStr = this.bookmarks != null ? "bookmarks:" + this.bookmarks + isA : "bookmarks: None" + isA;
        outStr = outStr + " " + this.logString();
        return outStr;
    }

    public void copyData(Row newRow, int nCol) {
        if (this.bookmarks == null) {
            newRow.bookmarks = null;
        } else {
            int numBM = this.bookmarks.length;
            newRow.bookmarks = new String[numBM];
        }
        for (int i = 0; i < nCol; ++i) {
            newRow._COLUMNS_DATA[i] = this._COLUMNS_DATA[i] != null ? this._COLUMNS_DATA[i].clone() : null;
            if (this.bookmarks == null) continue;
            newRow.bookmarks[i] = this.bookmarks[i];
        }
        newRow.isAvailable = this.isAvailable;
    }

    public void copyData(Row newRow, int sCol, int tCol, int nCol) {
        for (int i = 0; i < nCol; ++i) {
            newRow._COLUMNS_DATA[tCol] = this._COLUMNS_DATA[sCol] != null ? this._COLUMNS_DATA[sCol].clone() : null;
            ++sCol;
            ++tCol;
        }
    }

    public final Row clone() {
        int nCol = this.getNumberOfColumns();
        Row out = new Row(nCol);
        this.copyData(out, nCol);
        return out;
    }

    public final void cleanup() {
        this.bookmarks = null;
        if (this._COLUMNS_DATA == null) {
            return;
        }
        for (int i = 0; i < this._COLUMNS_DATA.length; ++i) {
            AbstractColumn c = this._COLUMNS_DATA[i];
            this._COLUMNS_DATA[i] = null;
            if (c == null) continue;
            c.cleanup();
        }
    }
}

