/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.caching;

import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.tkts.caching.AbstractRowCache;
import com.sas.tkts.caching.PrefetchControl;
import com.sas.tkts.caching.Row;
import com.sas.tkts.util.UtilityFunctions;
import java.util.ArrayList;
import org.omg.CORBA.IntHolder;

public class PrefetchData {
    public static final int PREFETCH_MAX_FETCH_SIZE = 10000;
    public PrefetchControl control;
    public long fetchNumber;
    public byte[] bookmarkArray;
    public IntHolder rowsFetched;
    public OctetSeqHolder rowStatus;
    public OctetSeqHolder packedRowsBuffer;
    public IntHolder status;
    public Exception fetchEx;
    public ArrayList<Row> rows_data_cache;

    public PrefetchData(PrefetchControl c) {
        this.control = c;
        this.reset();
    }

    public void reset() {
        this.fetchNumber = -1L;
        this.bookmarkArray = UtilityFunctions.convertStringArrayIntoByteArray(null);
        this.rowsFetched = new IntHolder();
        this.rowStatus = new OctetSeqHolder();
        this.packedRowsBuffer = new OctetSeqHolder();
        this.status = new IntHolder();
        this.fetchEx = null;
        if (this.rows_data_cache == null) {
            this.rows_data_cache = new ArrayList(10000);
        }
    }

    public void cleanup() {
        this.fetchNumber = -1L;
        this.bookmarkArray = null;
        this.rowsFetched = null;
        this.rowStatus = null;
        this.packedRowsBuffer = null;
        this.status = null;
        this.fetchEx = null;
        AbstractRowCache.clearRDC(this.rows_data_cache);
    }

    public boolean endOfData() {
        boolean out = false;
        if (this.status != null && this.status.value == -2130708476) {
            out = true;
        }
        return out;
    }

    public String toString() {
        String outStr = null;
        if (this.fetchNumber == Long.MAX_VALUE) {
            outStr = " fetchNumber: RequestForTerminate(Long.MAX_VALUE)";
            return outStr;
        }
        outStr = " fetchNumber: " + this.fetchNumber;
        if (this.rowsFetched != null) {
            outStr = outStr + " rowsFetched: " + this.rowsFetched.value;
        }
        outStr = this.packedRowsBuffer == null ? outStr + " packedRowsBuffer==null" : (this.packedRowsBuffer.value == null ? outStr + " packedRowsBuffer.value==null" : outStr + " bytes: " + this.packedRowsBuffer.value.length);
        if (this.status != null) {
            outStr = this.status.value == -2130708476 ? outStr + " status:TKTS_NO_DATA(-2130708476)" : outStr + " status: " + this.status.value;
        }
        if (this.rows_data_cache != null) {
            outStr = outStr + " rows_data_cache rows: " + this.rows_data_cache.size();
        }
        if (this.fetchEx != null) {
            outStr = outStr + " Exception: " + this.fetchEx;
        }
        return outStr;
    }

    public IntHolder getRowsFetched() {
        return this.rowsFetched;
    }

    public OctetSeqHolder rowStatus() {
        return this.rowStatus;
    }

    public OctetSeqHolder packedRowsBuffer() {
        return this.packedRowsBuffer;
    }

    public IntHolder status() {
        return this.status;
    }

    public Exception fetchEx() {
        return this.fetchEx;
    }
}

