/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts.caching;

import com.sas.iom.SASIOMDefs.OctetSeqHelper;
import com.sas.iom.SASIOMDefs.OctetSeqHolder;
import com.sas.tkts.FSEnums;
import com.sas.tkts.FedSrvJDBC;
import com.sas.tkts.caching.PrefetchControl;
import com.sas.tkts.caching.PrefetchData;
import com.sas.tkts.caching.Row;
import com.sas.tkts.caching.UnpackInfo;
import com.sas.tkts.info.ParameterInfo;
import com.sas.tkts.iom.AbstractIOMWrapper;
import com.sas.tkts.iom.StatementWrapper;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.CommonLogger;
import com.sas.tkts.logging.ExceptionsLogger;
import com.sas.tkts.logging.LoggerFactory;
import com.sas.tkts.sql.FSConnection;
import com.sas.tkts.sql.FSStatement;
import com.sas.tkts.sql.LocalizedErrorHandler;
import com.sas.tkts.sql.LocalizedMessageHandler;
import com.sas.tkts.types.AbstractColumn;
import com.sas.tkts.types.ColumnFactory;
import com.sas.tkts.util.ByteArrayConverter;
import com.sas.tkts.util.ByteExtractor;
import com.sas.tkts.util.Counts;
import com.sas.tkts.util.TypesHelper;
import com.sas.tkts.util.UtilityFunctions;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;

public abstract class AbstractRowCache
extends FedSrvJDBC {
    private static String thisClassName = AbstractRowCache.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    protected static final int CURSOR_CACHE_BEFORE_FIRST = -1;
    protected static final int CURSOR_CACHE_FIRST = 0;
    protected static final int CURSOR_RSET_BEFORE_FIRST = 0;
    protected static final int CURSOR_RSET_FIRST = 1;
    protected static final String FMT_CURSOR = "cacheCURSOR=[%d] rSetCURSOR=[%d]";
    protected static final String FMT_CURSOR1 = "validRow[%s] cacheCURSOR=[%d] rSetCURSOR=[%d] ";
    protected static final String FMT_IS_VALID_ROW = "IsValidRow[%s]";
    protected static final String FMT_PACKED_BYTES = "--- Packeted bytes bufferSize[%s]---";
    protected static final String BAD_ROW_ERROR = "TKTSRowCache.badRowError.fmt";
    public transient ParameterInfo[] _COLUMN_INFO_ARRAY;
    private transient int tktsBindColumns;
    protected transient SQLWarning sqlWarning;
    protected transient FSStatement fsStatement;
    protected transient boolean isUseBookmarks;
    protected transient boolean isAllSchemaRowsFetched;
    protected transient StatementWrapper statementWrapper;
    protected transient int cacheCURSOR;
    protected transient int rSetCURSOR;
    protected transient int largestRSetCURSOR;
    private transient boolean positionChanged;
    protected transient int fetchSize;
    protected transient int fetchSizeUsed;
    protected transient boolean isValidRow;
    protected transient int rowCount;
    protected transient int rowBytes;
    protected transient int resultSetType;
    protected transient int resultSetConcurrency;
    protected transient boolean afterLast;
    protected transient boolean endOfDataReached;
    protected transient boolean isMetadataCache;
    private transient int topRowNumber;
    private transient int lastRowNumber;
    protected transient ArrayList<Row> _ROWS_DATA_CACHE;
    protected transient int packType;
    protected transient boolean prefetch;
    protected transient PrefetchControl prefetchControl;
    protected transient PrefetchData prefetchData;
    protected transient Counts unpackCounts;
    protected transient long applicationLast;
    protected transient long applicationDelayDuration;
    protected transient int debugRow;
    protected transient int debugCol;

    protected String getCursorPosition() {
        String out = String.format(FMT_CURSOR, this.cacheCURSOR, this.rSetCURSOR);
        return out;
    }

    protected String getCursorPosition1() {
        String out = String.format(FMT_CURSOR1, this.isValidRow, this.cacheCURSOR, this.rSetCURSOR);
        return out;
    }

    protected String getIsValidRow() {
        String out = String.format(FMT_IS_VALID_ROW, this.isValidRow);
        return out;
    }

    protected String getPacketBytes(int inBufferSize) {
        String out = String.format(FMT_PACKED_BYTES, inBufferSize);
        return out;
    }

    protected void setFetchSize(int newFetchSize) {
        this.fetchSize = newFetchSize;
        this._ROWS_DATA_CACHE.ensureCapacity(newFetchSize);
    }

    protected void setCursorPosition(int newCacheCURSOR, int newRSetCURSOR) {
        if (newCacheCURSOR != this.cacheCURSOR) {
            this.cacheCURSOR = newCacheCURSOR;
            this.positionChanged = true;
        }
        if (newRSetCURSOR != this.rSetCURSOR) {
            if (newRSetCURSOR > this.largestRSetCURSOR) {
                this.largestRSetCURSOR = newRSetCURSOR;
                if (this.largestRSetCURSOR == 501) {
                    --this.largestRSetCURSOR;
                    ++this.largestRSetCURSOR;
                }
            }
            if (newRSetCURSOR <= this.largestRSetCURSOR) {
                this.afterLast = false;
            }
            this.rSetCURSOR = newRSetCURSOR;
            this.positionChanged = true;
        }
    }

    protected void setCursorPositionAfterLast(int newCacheCURSOR, int newRSetCURSOR) {
        if (newCacheCURSOR != this.cacheCURSOR) {
            this.cacheCURSOR = newCacheCURSOR;
            this.positionChanged = true;
        }
        if (newRSetCURSOR != this.rSetCURSOR) {
            if (newRSetCURSOR <= this.largestRSetCURSOR) {
                this.afterLast = false;
            }
            this.rSetCURSOR = newRSetCURSOR;
            this.positionChanged = true;
        }
    }

    private void initFields() {
        this.tktsBindColumns = -1;
        this.largestRSetCURSOR = -1;
        this.positionChanged = false;
        this.fetchSize = -1;
        this.fetchSizeUsed = -1;
        this.rowCount = 0;
        this.rowBytes = 0;
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        this.afterLast = false;
        this.endOfDataReached = false;
        this.lastRowNumber = -1;
        this.prefetch = false;
        this.prefetchControl = null;
        this.unpackCounts = new Counts("unpackCounts:", 1000, false);
    }

    public AbstractRowCache() {
        String method = "AbstractRowCache()";
        if (AbstractLogger.isTrace) {
            logger.entry("AbstractRowCache()", "Creating AbstractRowCache.");
        }
        this.initFields();
        this._ROWS_DATA_CACHE = new ArrayList(0);
        this.rowCount = 0;
        this.positionChanged = true;
        if (AbstractLogger.isTrace) {
            this.logCursorPosition();
        }
    }

    public void setPrefetch(boolean value) throws SQLException {
        this.prefetch = value;
        if (value) {
            int newFetchSize = this.estimateRAS(this.fetchSize);
            if (this.fetchSize != newFetchSize) {
                this.fetchSize = newFetchSize;
                if (this.fsStatement == null) {
                    AbstractIOMWrapper.setIntegerAttribute(this.statementWrapper, 20400, 1, false);
                    AbstractIOMWrapper.setIntegerAttribute(this.statementWrapper, 27, newFetchSize, false);
                } else {
                    AbstractIOMWrapper.setIntegerAttribute(this.fsStatement.getStatementWrapper(), 20400, 1, false);
                    this.fsStatement.setFetchSize(this.fetchSize);
                }
            }
            this.prefetchControl = new PrefetchControl(this, this.statementWrapper);
        }
    }

    public AbstractColumn getColumnData(int columnNumber) throws SQLException {
        Row row;
        if (this.cacheCURSOR < 0 || this.cacheCURSOR > this._ROWS_DATA_CACHE.size() - 1) {
            String ei = "TKTSRowCache.invalidRowPosition.txt";
            this.throwException("TKTSRowCache.invalidRowPosition.txt", logger);
        }
        if ((row = this._ROWS_DATA_CACHE.get(this.cacheCURSOR)) == null) {
            return null;
        }
        if (row.isInvalid()) {
            String ei = "TKTSRowCache.badCellError.txt";
            this.throwException("TKTSRowCache.badCellError.txt", logger);
        }
        return row.getColumnData(columnNumber - 1);
    }

    public ParameterInfo getColumnInfo(int index) {
        return this._COLUMN_INFO_ARRAY[index - 1];
    }

    private boolean logRow(int cacheIndex, int rowIndex, int cacheColumns) {
        String method = "logRow(cacheIndex,rowIndex,cacheColumns)";
        boolean failed = false;
        try {
            Row row = this._ROWS_DATA_CACHE.get(cacheIndex);
            if (cacheColumns >= 2) {
                AbstractColumn a1 = row.getColumnData(0);
                AbstractColumn a2 = row.getColumnData(1);
                String s1 = a1.getString();
                String s2 = a2.getString();
                if (row.isInvalid()) {
                    logger.trace(method, "" + cacheIndex + " " + rowIndex + " Invalid Row");
                } else if (rowIndex == this.rSetCURSOR) {
                    logger.trace(method, "  " + cacheIndex + " " + rowIndex + " " + s1.length() + ":'" + s1 + "' " + s2.length() + ":'" + s2 + "' <<<<<<< ");
                } else {
                    logger.trace(method, "  " + cacheIndex + " " + rowIndex + " " + s1.length() + ":'" + s1 + "' " + s2.length() + ":'" + s2 + "' ");
                }
            } else if (cacheColumns >= 1) {
                AbstractColumn a1 = row.getColumnData(0);
                String s1 = a1.getString();
                if (row.isInvalid()) {
                    logger.trace(method, "  " + cacheIndex + " " + rowIndex + " Invalid Row");
                } else if (rowIndex == this.rSetCURSOR) {
                    logger.trace(method, "  " + cacheIndex + " " + rowIndex + " " + s1.length() + ":'" + s1 + "' <<<<<<< ");
                } else {
                    logger.trace(method, "  " + cacheIndex + " " + rowIndex + " " + s1.length() + ":'" + s1 + "' ");
                }
            } else if (cacheColumns == 0) {
                if (row.isInvalid()) {
                    logger.trace(method, "  " + cacheIndex + " " + rowIndex + " Invalid Row");
                } else if (rowIndex == this.rSetCURSOR) {
                    logger.trace(method, "  " + cacheIndex + " " + rowIndex + " <<<<<<< ");
                } else {
                    logger.trace(method, "  " + cacheIndex + " " + rowIndex);
                }
            }
        }
        catch (Error le) {
            logger.trace("Exception logging table java.lang.Error ");
            logger.trace(le);
            failed = true;
        }
        catch (SQLException se) {
            logger.trace("Exception logging table SQLException ");
            logger.trace(se);
            failed = true;
        }
        return failed;
    }

    protected void logCursorPosition() {
        String method = "logCursorPosition()";
        boolean failed = false;
        if (!this.positionChanged) {
            return;
        }
        int cacheColumns = 0;
        try {
            logger.trace(method, "  isMetadataCache:" + this.isMetadataCache);
            logger.trace(method, "  cacheCURSOR:" + this.cacheCURSOR + " rSetCURSOR:" + this.rSetCURSOR);
            logger.trace(method, "  isValidRow:" + this.isValidRow + " rowCount:" + this.rowCount);
            if (this._COLUMN_INFO_ARRAY != null) {
                logger.trace(method, "ColumnCount:" + this._COLUMN_INFO_ARRAY.length);
            }
            if (this.isBeforeFirst()) {
                logger.trace(method, "Position:BeforeFirst");
            }
            if (this.isFirst()) {
                logger.trace(method, "Position:First");
            }
            if (this.afterLast) {
                logger.trace(method, "Position:After Last");
            }
            if (AbstractLogger.isTrace) {
                logger.trace(method, "RowsInCache=[" + this.rowCount + "] RowNumbers[" + this.topRowNumber + " to " + this.lastRowNumber + "]");
            }
            if (this.rowCount > 0) {
                logger.trace(method, "RowNumbers[" + this.topRowNumber + " to " + this.lastRowNumber + "]");
                int cacheIndex = 0;
                int rowIndex = this.topRowNumber;
                int lastCacheIndex = this.rowCount - 1;
                if (AbstractLogger.isTrace) {
                    failed = this.logRow(cacheIndex, rowIndex, cacheColumns);
                }
                if (failed && this.cacheCURSOR > 0 && this.cacheCURSOR < lastCacheIndex) {
                    this.logRow(this.cacheCURSOR, this.topRowNumber + this.cacheCURSOR, cacheColumns);
                }
                if (failed && lastCacheIndex > 0) {
                    this.logRow(lastCacheIndex, this.topRowNumber + lastCacheIndex, cacheColumns);
                }
            } else {
                logger.trace(method, "Cache is empty!!");
            }
        }
        catch (Error le) {
            logger.trace(method, "Exception logging table java.lang.Error ");
        }
        catch (SQLException se) {
            logger.trace(method, "Exception logging table SQLException ");
        }
        this.positionChanged = false;
    }

    private void throwsMethodNotSupported() throws SQLException {
        String ei = "TKTSResultSet.MethodNotSupportedCurFwdOnly.txt";
        this.throwException("TKTSResultSet.MethodNotSupportedCurFwdOnly.txt", logger);
    }

    public int getColumnCount() {
        return this._COLUMN_INFO_ARRAY.length;
    }

    public int getRowCount() {
        return this._ROWS_DATA_CACHE.size();
    }

    public int getCurrentPosition() {
        return this.rSetCURSOR;
    }

    public int getServerCurrentCursorPosition() throws SQLException {
        return this.getFetchTopRowNumber();
    }

    public int getRow() throws SQLException {
        if (this.isValidRow) {
            return this.rSetCURSOR;
        }
        return 0;
    }

    public int getRowSetPosition() {
        return this.cacheCURSOR;
    }

    public boolean isBeforeFirst() throws SQLException {
        return !this._ROWS_DATA_CACHE.isEmpty() && this.cacheCURSOR == -1 && this.rSetCURSOR == 0;
    }

    public boolean isFirst() {
        return !this._ROWS_DATA_CACHE.isEmpty() && this.rSetCURSOR == 1;
    }

    public boolean isLast() throws SQLException {
        String method = "isLast()";
        boolean isLast = false;
        if (AbstractLogger.isTrace) {
            logger.trace("isLast()", this.getCursorPosition());
        }
        if (this.resultSetType == 1003 && this.fsStatement.getThrowException()) {
            this.throwsMethodNotSupported();
        }
        int lastCacheIndx = this.rowCount - 1;
        if (this.rowCount == 0) {
            isLast = false;
        } else if (this.endOfDataReached && this.largestRSetCURSOR == this.rSetCURSOR) {
            isLast = true;
        } else if (this.fetchSizeUsed > this.rowCount && this.cacheCURSOR == lastCacheIndx) {
            isLast = true;
        } else if (this.cacheCURSOR < lastCacheIndx || this.afterLast || this.largestRSetCURSOR > this.rSetCURSOR) {
            isLast = false;
        } else if (this.resultSetType == 1003) {
            if (AbstractLogger.isTrace) {
                logger.trace("  Warning:ResultSet.TYPE_FORWARD_ONLY forcing isLast=false");
            }
        } else if (this.fetchSizeUsed > 1) {
            this.shiftCacheAbsolute(this.rSetCURSOR);
            if (this.rowCount == 1) {
                this.endOfDataReached = true;
                isLast = true;
            }
        } else {
            isLast = !this.next();
            this.previous();
        }
        if (AbstractLogger.isTrace) {
            logger.exit("isLast()", "IsLast=[" + isLast + "]");
        }
        return isLast;
    }

    public boolean isAfterLast() throws SQLException {
        return !this._ROWS_DATA_CACHE.isEmpty() && this.afterLast;
    }

    public void beforeFirst() throws SQLException {
        String method = "beforeFirst()";
        if (AbstractLogger.isTrace) {
            logger.trace("beforeFirst()", this.getCursorPosition());
        }
        this.first();
        this.setCursorPosition(-1, 0);
        if (AbstractLogger.isTrace) {
            logger.exit("beforeFirst()", this.getCursorPosition());
        }
    }

    public boolean first() throws SQLException {
        boolean isInFirstRowSet;
        String method = "first()";
        if (AbstractLogger.isTrace) {
            logger.trace("first()", this.getCursorPosition());
        }
        this.isValidRow = true;
        int rowsInCache = this._ROWS_DATA_CACHE.size();
        boolean bl = isInFirstRowSet = rowsInCache > 0 && this.rSetCURSOR - this.cacheCURSOR == 1;
        if (isInFirstRowSet) {
            this.setCursorPosition(0, 1);
        } else if (this.fetch(0, null, 2)) {
            this.setCursorPosition(0, 1);
        } else {
            this.topRowNumber = 0;
            this.setCursorPosition(-1, 0);
            this.isValidRow = false;
        }
        if (this.isValidRow && this._ROWS_DATA_CACHE.get(this.cacheCURSOR).isInvalid()) {
            this.throwException(BAD_ROW_ERROR, logger, Integer.toString(this.cacheCURSOR));
        }
        if (AbstractLogger.isTrace) {
            logger.exit("first()", this.getCursorPosition1());
        }
        return this.isValidRow;
    }

    public boolean next() throws SQLException {
        String method = "next()";
        if (AbstractLogger.isTrace) {
            logger.trace("next()", this.getCursorPosition());
            this.logCursorPosition();
        }
        long delta = 0L;
        long start = System.nanoTime();
        if (this.applicationLast > 0L) {
            delta = start - this.applicationLast;
            this.applicationDelayDuration += delta / 1000L;
        }
        this.applicationLast = start;
        this.isValidRow = true;
        if (this.isAfterLast()) {
            this.isValidRow = false;
        } else {
            String[] bookmarks = null;
            int lastCacheIndx = this.rowCount - 1;
            if (this.rowCount > 0 && this.cacheCURSOR + 1 <= lastCacheIndx) {
                this.setCursorPosition(this.cacheCURSOR + 1, this.rSetCURSOR + 1);
            } else if (this.endOfDataReached && this.rSetCURSOR == this.largestRSetCURSOR) {
                this.setCursorPositionAfterLast(this.cacheCURSOR + 1, this.rSetCURSOR + 1);
                this.afterLast = true;
                this.isValidRow = false;
            } else {
                this.isValidRow = this.fetch(0, bookmarks, 1);
                if (this.isValidRow) {
                    this.setCursorPosition(0, this.rSetCURSOR + 1);
                } else {
                    this.setCursorPositionAfterLast(this.cacheCURSOR + 1, this.rSetCURSOR + 1);
                    this.endOfDataReached = true;
                }
                this.applicationLast = System.nanoTime();
            }
            if (this.isValidRow && !this._ROWS_DATA_CACHE.isEmpty() && this._ROWS_DATA_CACHE.get(this.cacheCURSOR).isInvalid()) {
                this.throwException(BAD_ROW_ERROR, logger, Integer.toString(this.cacheCURSOR));
            }
        }
        if (AbstractLogger.isTrace) {
            this.logCursorPosition();
            logger.exit("next()", this.getCursorPosition1());
        }
        return this.isValidRow;
    }

    public boolean previous() throws SQLException {
        String method = "previous()";
        if (AbstractLogger.isTrace) {
            logger.entry("previous()", this.getCursorPosition());
            this.logCursorPosition();
        }
        this.isValidRow = true;
        if (this.cacheCURSOR > 0 && this.rSetCURSOR > 1) {
            this.setCursorPosition(this.cacheCURSOR - 1, this.rSetCURSOR - 1);
        } else if (this.cacheCURSOR < 0 && this.rSetCURSOR == 0) {
            this.isValidRow = false;
        } else if (this.cacheCURSOR == 0 && this.rSetCURSOR == 1) {
            this.setCursorPosition(-1, 0);
            this.isValidRow = false;
        } else if (this.cacheCURSOR == 0 && this.rSetCURSOR > 1) {
            int rowsLeft = this.rSetCURSOR - 1;
            if (rowsLeft < this.fetchSize) {
                if (rowsLeft > 0) {
                    if (this.fetch(1, null, 5)) {
                        this.topRowNumber = 1;
                        this.setCursorPosition(this.rSetCURSOR - 2, this.rSetCURSOR - 1);
                    } else {
                        this.isValidRow = false;
                    }
                } else {
                    this.setCursorPosition(-1, 0);
                    this.isValidRow = false;
                }
            } else {
                int tRSetCURSOR = this.rSetCURSOR - 1;
                if (this.fetch(tRSetCURSOR, null, 5)) {
                    int tCacheCURSOR = tRSetCURSOR - this.topRowNumber;
                    this.setCursorPosition(tCacheCURSOR, tRSetCURSOR);
                } else {
                    this.isValidRow = false;
                }
            }
        } else {
            this.isValidRow = false;
        }
        if (this.isValidRow && this._ROWS_DATA_CACHE.get(this.cacheCURSOR).isInvalid()) {
            this.throwException(BAD_ROW_ERROR, logger, Integer.toString(this.cacheCURSOR));
        }
        if (AbstractLogger.isTrace) {
            this.logCursorPosition();
            logger.exit("previous()", this.getCursorPosition1());
        }
        return this.isValidRow;
    }

    public boolean last() throws SQLException {
        String method = "last()";
        if (AbstractLogger.isTrace) {
            logger.entry("last()", "Calling last().");
            this.logCursorPosition();
        }
        this.isValidRow = true;
        if (this.fetch(0, null, 3)) {
            int tCacheCURSOR = this._ROWS_DATA_CACHE.size() - 1;
            int tRSetCURSOR = this.topRowNumber + tCacheCURSOR;
            this.setCursorPosition(tCacheCURSOR, tRSetCURSOR);
        } else {
            this.topRowNumber = 0;
            this.setCursorPosition(-1, 0);
            this.isValidRow = false;
        }
        if (this.isValidRow && this._ROWS_DATA_CACHE.get(this.cacheCURSOR).isInvalid()) {
            this.throwException(BAD_ROW_ERROR, logger, Integer.toString(this.cacheCURSOR));
        }
        if (AbstractLogger.isTrace) {
            this.logCursorPosition();
            logger.exit("last()" + this.getCursorPosition1());
        }
        return this.isValidRow;
    }

    public void afterLast() throws SQLException {
        String method = "afterLast()";
        if (AbstractLogger.isTrace) {
            logger.entry("afterLast()");
            this.logCursorPosition();
        }
        if (this.last()) {
            this.setCursorPositionAfterLast(this.cacheCURSOR + 1, this.rSetCURSOR + 1);
            this.afterLast = true;
        }
        if (AbstractLogger.isTrace) {
            this.logCursorPosition();
            logger.exit("afterLast() cacheCURSOR=[" + this.cacheCURSOR + "] rSetCURSOR=[" + this.rSetCURSOR + "]");
        }
    }

    public boolean relative(int distance) throws SQLException {
        String method = "relative(distance)";
        if (AbstractLogger.isTrace) {
            logger.entry("relative(distance)", " distance[" + distance + "]");
            this.logCursorPosition();
        }
        this.isValidRow = true;
        if (distance == 0) {
            if (this.isBeforeFirst() || this.isAfterLast()) {
                this.isValidRow = false;
            }
        } else if (distance == -1) {
            this.isValidRow = this.previous();
        } else if (distance == 1) {
            this.isValidRow = this.next();
        } else {
            int destinationRowNumber = this.rSetCURSOR + distance;
            boolean isInCache = this.isRowCached(destinationRowNumber);
            if (destinationRowNumber < 1) {
                if (!isInCache && this.topRowNumber > 1) {
                    this.first();
                }
                this.setCursorPosition(-1, 0);
                this.isValidRow = false;
            } else {
                this.isValidRow = this.absolutePositive(destinationRowNumber);
            }
        }
        if (this.isValidRow && this._ROWS_DATA_CACHE.get(this.cacheCURSOR).isInvalid()) {
            this.throwException(BAD_ROW_ERROR, logger, Integer.toString(this.cacheCURSOR));
        }
        if (AbstractLogger.isTrace) {
            this.logCursorPosition();
            logger.exit("relative(distance)", this.getIsValidRow());
        }
        return this.isValidRow;
    }

    public boolean absolute(int desiredRowNumber) throws SQLException {
        String method = "absolute(desiredRowNumber)";
        if (AbstractLogger.isTrace) {
            logger.entry("absolute(desiredRowNumber)", " desiredRowNumber[" + desiredRowNumber + "]");
            this.logCursorPosition();
        }
        this.isValidRow = true;
        if (desiredRowNumber == 0) {
            this.beforeFirst();
            this.isValidRow = false;
        } else {
            this.isValidRow = desiredRowNumber == 1 ? this.first() : (desiredRowNumber == -1 ? this.last() : (desiredRowNumber > 1 ? this.absolutePositive(desiredRowNumber) : this.absoluteNegative(desiredRowNumber)));
        }
        if (this.isValidRow && this._ROWS_DATA_CACHE.get(this.cacheCURSOR).isInvalid()) {
            this.throwException(BAD_ROW_ERROR, logger, Integer.toString(this.cacheCURSOR));
        }
        if (AbstractLogger.isTrace) {
            this.logCursorPosition();
            logger.exit("absolute(desiredRowNumber)", this.getIsValidRow());
        }
        return this.isValidRow;
    }

    public void close(boolean releaseCache) throws SQLException {
        String method = "close()";
        IntHolder status = new IntHolder();
        this.unpackCounts.log();
        if (this.prefetch) {
            this.prefetchControl.logMeasurements();
            if (AbstractLogger.isDebug) {
                double d = this.applicationDelayDuration;
                double toSeconds = 1000000.0;
                String o = String.format("ApplicationDelay: %10.4f  ", d /= toSeconds);
                logger.entry("close()", o);
            }
            this.prefetchControl.cleanup();
        }
        try {
            if (this.statementWrapper != null) {
                this.statementWrapper.CloseCursor(status);
                this.checkForWarnings(status.value);
                if (this.isMetadataCache) {
                    try {
                        this.statementWrapper.Close();
                    }
                    catch (Exception exception) {
                        logger.error("AbstractRowCache:close:");
                        logger.error(exception);
                    }
                }
                this.statementWrapper = null;
            }
            this.setCursorPosition(-1, 0);
            if (releaseCache) {
                this.releaseOutgoingResources();
            }
        }
        catch (Exception te) {
            LocalizedErrorHandler.handleExceptionsInFunction("close()", te, this.statementWrapper, logger);
        }
    }

    public void releaseOutgoingResources() {
        if (this._COLUMN_INFO_ARRAY != null) {
            for (int i = 0; i < this._COLUMN_INFO_ARRAY.length; ++i) {
                if (this._COLUMN_INFO_ARRAY[i] == null) continue;
                this._COLUMN_INFO_ARRAY[i] = null;
            }
        }
        this._COLUMN_INFO_ARRAY = null;
        if (this._ROWS_DATA_CACHE != null) {
            AbstractRowCache.clearRDC(this._ROWS_DATA_CACHE);
            this._ROWS_DATA_CACHE.clear();
            this._ROWS_DATA_CACHE = null;
        }
        this.fsStatement = null;
    }

    public void setResultSetType(int type) {
        String method = "setResultSetType(type)";
        if (AbstractLogger.isTrace) {
            logger.entry("setResultSetType(type)", " type[" + TypesHelper.getResultSetTypeU(type) + "]");
        }
        this.resultSetType = type;
        if (AbstractLogger.isTrace) {
            logger.exit("setResultSetType(type)", "ResultSetType=" + this.resultSetType);
        }
    }

    public void setResultSetConcurrency(int concur) {
        String method = "setResultSetConcurrency(concurrency)";
        if (AbstractLogger.isTrace) {
            logger.entry("setResultSetConcurrency(concurrency)", " concurrency[" + TypesHelper.getResultSetConcurrencyU(concur) + "] ");
        }
        this.resultSetConcurrency = concur;
        if (AbstractLogger.isTrace) {
            logger.exit("setResultSetConcurrency(concurrency)", "ResultSetConcurrency=" + this.resultSetConcurrency);
        }
    }

    public int getColumnType(int column) {
        return this._COLUMN_INFO_ARRAY[column - 1].getSQLType();
    }

    public int getColumnLength(int column) {
        Long lValue = new Long(this._COLUMN_INFO_ARRAY[column - 1].getDisplaySizeInCharacters());
        return lValue.intValue();
    }

    public String getColumnName(int column) {
        return this._COLUMN_INFO_ARRAY[column - 1].getName();
    }

    public int getColumnIndex(String columnName) {
        for (int i = 0; i < this._COLUMN_INFO_ARRAY.length; ++i) {
            if (!this._COLUMN_INFO_ARRAY[i].getName().equalsIgnoreCase(columnName)) continue;
            return i + 1;
        }
        return -1;
    }

    public SQLWarning getWarnings() {
        return this.sqlWarning;
    }

    public void clearWarnings() {
        String method = "clearWarnings()";
        this.sqlWarning = null;
        if (AbstractLogger.isTrace) {
            logger.trace(method, "Clear all SQLWarnings");
        }
    }

    public void insertRow() throws SQLException {
        String method = "insertRow()";
        if (AbstractLogger.isTrace) {
            logger.entry("insertRow()", "Insert row.");
        }
        this.performRowInsert2();
    }

    public void updateRow() throws SQLException {
        String method = "updateRow()";
        if (AbstractLogger.isTrace) {
            logger.entry("updateRow()", "Update row.");
        }
        this.performRowUpdate2();
    }

    public void deleteRow() throws SQLException {
        String method = "deleteRow()";
        if (AbstractLogger.isTrace) {
            logger.entry("deleteRow()", "Calling delete row.");
        }
        int lockType = 0;
        OctetSeqHolder rowStatus = new OctetSeqHolder();
        IntHolder status = new IntHolder();
        int rowPosition = this.cacheCURSOR + 1;
        if (AbstractLogger.isTrace) {
            logger.trace("deleteRow()", "Deleting row at row set position [" + rowPosition + "] cacheCURSOR=[" + this.cacheCURSOR + "] rSetCURSOR=[" + this.rSetCURSOR + "] Concurrency=[" + this.fsStatement.getConcurrency() + "]");
        }
        try {
            this.statementWrapper.Delete2(rowPosition, lockType, 0, new byte[]{1}, rowStatus, status);
            this._ROWS_DATA_CACHE.get(this.cacheCURSOR).setStatus(1);
            this.checkForWarnings(status.value);
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("deleteRow()", exception, this.statementWrapper, logger);
        }
    }

    public void refreshRow() throws SQLException {
        String method = "refreshRow()";
        if (AbstractLogger.isTrace) {
            logger.entry("refreshRow()", "Calling refresh row.");
        }
        this.performRowRefresh2();
    }

    protected synchronized void checkForWarnings(int status) {
        String method = "checkForWarnings(status)";
        if (status == -2130708479) {
            SQLWarning sw = LocalizedErrorHandler.createLocalizedWarnnigs(this.statementWrapper);
            if (AbstractLogger.isTrace) {
                logger.trace(method, "Add SQLWarnings:" + sw);
            }
            if (this.sqlWarning == null) {
                this.sqlWarning = sw;
            } else {
                this.sqlWarning.setNextWarning(sw);
            }
        }
    }

    protected void bindColumns() throws SQLException {
        this.fsStatement.bindColumns();
    }

    protected synchronized boolean fetch(int fetchOffset, String[] bookmarks, int fetchOrientation) throws SQLException {
        String method = "fetch(fetchOffset,bookmarks,fetchOrientation)";
        if (this.statementWrapper == null) {
            return false;
        }
        boolean isDataLoaded = false;
        isDataLoaded = this.prefetch ? this.commonPrefetch(fetchOffset, bookmarks, fetchOrientation, false) : this.commonFetch(fetchOffset, bookmarks, fetchOrientation, false);
        if (AbstractLogger.isTrace) {
            logger.exit("fetch(fetchOffset,bookmarks,fetchOrientation)", "Fetch top row number is " + this.topRowNumber);
        }
        return isDataLoaded;
    }

    protected synchronized boolean commonFetch(int fetchOffset, String[] bookmarks, int fetchOrientation, boolean isRowCacheAppend) throws SQLException {
        String method = "commonFetch(fetchOffset,bookmarks,fetchOrientation,isRowCacheAppend)";
        if (AbstractLogger.isTrace) {
            logger.entry("commonFetch(fetchOffset,bookmarks,fetchOrientation,isRowCacheAppend)", "FetchOffset [" + fetchOffset + "]  FetchOrientation [" + TypesHelper.getFetchOrientationU(fetchOrientation) + "]");
            this.logCursorPosition();
        }
        boolean isDataLoaded = true;
        OctetSeqHolder rowStatus = new OctetSeqHolder();
        IntHolder status = new IntHolder();
        IntHolder rowsFetched = new IntHolder();
        OctetSeqHolder packedRowsBuffer = new OctetSeqHolder();
        byte[] bookmarkArray = UtilityFunctions.convertStringArrayIntoByteArray(bookmarks);
        int oldRowCount = this.rowCount;
        try {
            this.statementWrapper.FetchScroll2(fetchOrientation, fetchOffset, bookmarkArray, rowsFetched, rowStatus, packedRowsBuffer, status);
            this.fetchSizeUsed = this.fetchSize;
        }
        catch (Exception e) {
            LocalizedErrorHandler.handleExceptionsInFunction("FetchScroll2", e, this.statementWrapper, logger);
        }
        this.checkForWarnings(status.value);
        if (this.fetchSize == -1 && this.fsStatement != null) {
            this.fetchSize = AbstractIOMWrapper.getIntegerAttribute(this.statementWrapper, 27);
            if (AbstractLogger.isTrace) {
                logger.entry("commonFetch(fetchOffset,bookmarks,fetchOrientation,isRowCacheAppend)", " fetchSize=[" + this.fetchSize + "] ");
            }
        }
        if (status.value != -2130708476 && rowStatus.value.length > 0) {
            ArrayList<Row> rdc;
            if (this.fetchSize != rowStatus.value.length) {
                this.fetchSize = rowStatus.value.length;
            }
            int cacheOffset = 0;
            if (isRowCacheAppend) {
                cacheOffset = 0;
                rdc = new ArrayList(this.fetchSize);
                rdc = this.prepareToUnpackDataAndCache(packedRowsBuffer.value, rowStatus.value, cacheOffset, rdc);
                this._ROWS_DATA_CACHE.addAll(rdc);
                rdc.clear();
            } else {
                this._ROWS_DATA_CACHE.clear();
                rdc = this.prepareToUnpackDataAndCache(packedRowsBuffer.value, rowStatus.value, cacheOffset, this._ROWS_DATA_CACHE);
                this._ROWS_DATA_CACHE = rdc;
            }
            rdc = null;
            this.rowCount = this._ROWS_DATA_CACHE.size();
            if (this.rowCount == 0) {
                isDataLoaded = false;
            }
            this.afterLast = false;
        } else if (status.value == -2130708476) {
            isDataLoaded = false;
            this.afterLast = true;
        }
        if (isDataLoaded) {
            this.topRowNumber = this.isMetadataCache || this.resultSetType == 1003 ? (this.topRowNumber += oldRowCount) : this.getFetchTopRowNumber();
            this.lastRowNumber = this.topRowNumber + this.rowCount - 1;
        }
        if (AbstractLogger.isTrace) {
            this.logCursorPosition();
            logger.exit("commonFetch(fetchOffset,bookmarks,fetchOrientation,isRowCacheAppend)", "isDataLoaded=[" + isDataLoaded + "]");
        }
        return isDataLoaded;
    }

    protected synchronized boolean commonPrefetch(int fetchOffset, String[] bookmarks, int fetchOrientation, boolean isRowCacheAppend) throws SQLException {
        PrefetchData pe;
        String method = "commonPrefetch(fetchOffset,bookmarks,fetchOrientation,isRowCacheAppend)";
        if (AbstractLogger.isTrace) {
            logger.entry("commonPrefetch(fetchOffset,bookmarks,fetchOrientation,isRowCacheAppend)", "FetchOffset [" + fetchOffset + "]  FetchOrientation [" + TypesHelper.getFetchOrientationU(fetchOrientation) + "]");
            this.logCursorPosition();
        }
        boolean isDataLoaded = true;
        OctetSeqHolder rowStatus = new OctetSeqHolder();
        IntHolder status = new IntHolder();
        int oldRowCount = this.rowCount;
        if (this.prefetchData != null) {
            this.prefetchControl.putFreeEntry(this.prefetchData, null);
        }
        if ((pe = this.prefetchControl.getReadyEntry()) == null) {
            String si = "TKTSPrefetch.FailedToGetBuffer.txt";
            String et = LocalizedErrorHandler.getLocalizedError("TKTSPrefetch.FailedToGetBuffer.txt", null);
            SQLException se = new SQLException(et);
            AbstractRowCache.throwFunctionException("FetchScroll2", se, null, logger);
        }
        if (pe.fetchEx != null) {
            Exception fe = pe.fetchEx;
            pe.fetchEx = null;
            this.prefetchControl.cleanup();
            pe = null;
            AbstractRowCache.throwFunctionException("FetchScroll2", fe, null, logger);
        }
        this.prefetchData = pe;
        rowStatus = pe.rowStatus;
        status = pe.status;
        Exception fetchEx = pe.fetchEx;
        this._ROWS_DATA_CACHE = pe.rows_data_cache;
        this.rowCount = this._ROWS_DATA_CACHE.size();
        if (fetchEx != null) {
            System.err.println("TODO: " + fetchEx);
            LocalizedErrorHandler.handleExceptionsInFunction("commonPrefetch(fetchOffset,bookmarks,fetchOrientation,isRowCacheAppend)", fetchEx, this.statementWrapper, logger);
        }
        this.fetchSizeUsed = this.fetchSize;
        this.checkForWarnings(status.value);
        if (status.value != -2130708476 && rowStatus.value.length > 0) {
            this.rowCount = this._ROWS_DATA_CACHE.size();
            if (this.rowCount == 0) {
                isDataLoaded = false;
            }
            this.afterLast = false;
        } else if (status.value == -2130708476) {
            isDataLoaded = false;
            this.afterLast = true;
        }
        if (this.fetchSize == -1 && this.fsStatement != null) {
            this.fetchSize = AbstractIOMWrapper.getIntegerAttribute(this.statementWrapper, 27);
            if (AbstractLogger.isTrace) {
                logger.entry("commonPrefetch(fetchOffset,bookmarks,fetchOrientation,isRowCacheAppend)", " fetchSize=[" + this.fetchSize + "] ");
            }
        }
        if (isDataLoaded) {
            this.topRowNumber = this.isMetadataCache || this.resultSetType == 1003 ? (this.topRowNumber += oldRowCount) : this.getFetchTopRowNumber();
            this.lastRowNumber = this.topRowNumber + this.rowCount - 1;
        }
        if (AbstractLogger.isTrace) {
            this.logCursorPosition();
            logger.exit("commonPrefetch(fetchOffset,bookmarks,fetchOrientation,isRowCacheAppend)", "isDataLoaded=[" + isDataLoaded + "]");
        }
        return isDataLoaded;
    }

    private boolean absolutePositive(int desiredRowNumber) throws SQLException {
        String method = "absolutePositive(desiredRowNumber)";
        if (AbstractLogger.isTrace) {
            logger.entry("absolutePositive(desiredRowNumber)", "desiredRowNumber[" + desiredRowNumber + "]");
        }
        this.isValidRow = true;
        if (this.isRowCached(desiredRowNumber)) {
            this.setCursorPosition(desiredRowNumber - this.topRowNumber, desiredRowNumber);
        } else if (this.fetch(desiredRowNumber, null, 5)) {
            this.setCursorPosition(0, this.topRowNumber);
        } else {
            this.last();
            this.next();
            this.isValidRow = false;
        }
        if (AbstractLogger.isTrace) {
            logger.exit("absolutePositive(desiredRowNumber)", this.getIsValidRow());
        }
        return this.isValidRow;
    }

    private boolean shiftCacheAbsolute(int desiredRowNumber) throws SQLException {
        String method = "shiftCacheAbsolute(desiredRowNumber)";
        if (AbstractLogger.isTrace) {
            logger.entry("shiftCacheAbsolute(desiredRowNumber)", "desiredRowNumber[" + desiredRowNumber + "]");
        }
        this.isValidRow = true;
        if (this.fetch(desiredRowNumber, null, 5)) {
            this.setCursorPosition(0, this.topRowNumber);
        } else {
            this.isValidRow = false;
        }
        if (AbstractLogger.isTrace) {
            logger.exit("shiftCacheAbsolute(desiredRowNumber)", this.getIsValidRow());
        }
        return this.isValidRow;
    }

    private boolean absoluteNegative(int desiredRowNumber) throws SQLException {
        String method = "absoluteNegative(desiredRowNumber)";
        if (AbstractLogger.isTrace) {
            logger.entry("absoluteNegative(desiredRowNumber)", "desiredRowNumber[" + desiredRowNumber + "]");
        }
        this.isValidRow = true;
        this.isValidRow = this.last();
        if (this.isValidRow) {
            int destinationRowNumber = this.lastRowNumber + desiredRowNumber + 1;
            if (this.isRowCached(destinationRowNumber)) {
                this.setCursorPosition(destinationRowNumber - this.topRowNumber, destinationRowNumber);
            } else if (destinationRowNumber < 1) {
                this.first();
                this.setCursorPosition(-1, 0);
                this.isValidRow = false;
            } else if (this.fetch(destinationRowNumber, null, 5)) {
                this.setCursorPosition(0, this.topRowNumber);
            } else {
                this.isValidRow = false;
            }
        }
        if (AbstractLogger.isTrace) {
            logger.exit("absoluteNegative(desiredRowNumber)", this.getIsValidRow());
        }
        return this.isValidRow;
    }

    private boolean isRowCached(int rowNumber) {
        return rowNumber >= this.topRowNumber && rowNumber <= this.lastRowNumber;
    }

    public ArrayList<Row> prepareToUnpackDataAndCache(byte[] packedRowsBuffer, byte[] rowStatus, int cacheOffset, ArrayList<Row> rdc) throws SQLException {
        long bytes;
        long startTime;
        block23: {
            int rRows;
            int aRows;
            String method = "prepareToUnpackDataAndCache(packedRowsBuffer,rowStatus)";
            startTime = System.nanoTime();
            bytes = 0L;
            if (AbstractLogger.isTrace) {
                logger.entry("prepareToUnpackDataAndCache(packedRowsBuffer,rowStatus)", "cacheOffset[" + cacheOffset + "] bytes[" + packedRowsBuffer.length + "]");
            }
            if ((aRows = rowStatus.length) > (rRows = rdc.size())) {
                if (AbstractLogger.isTrace) {
                    logger.entry("prepareToUnpackDataAndCache(packedRowsBuffer,rowStatus)", "aRows > rRows");
                }
                rdc.ensureCapacity(aRows);
            }
            if (rRows > aRows) {
                int extraRows;
                if (AbstractLogger.isTrace) {
                    logger.entry("prepareToUnpackDataAndCache(packedRowsBuffer,rowStatus)", "rRows > aRows");
                }
                int s = rRows - extraRows;
                for (extraRows = rRows - aRows; extraRows > 0; --extraRows) {
                    rdc.remove(s);
                }
                s = 0;
            }
            for (int u = 0; u < rowStatus.length; ++u) {
                Row row;
                if (rowStatus[u] != 0 && rowStatus[u] != 6 && rowStatus[u] != 2) continue;
                if (u >= rdc.size()) {
                    row = new Row(this._COLUMN_INFO_ARRAY.length);
                    rdc.add(row);
                } else {
                    row = rdc.get(u);
                }
                row.setStatus(rowStatus[u]);
            }
            if (rdc.size() > 0) {
                int maxCol = this.getBoundColumns();
                for (int colIndx = 0; colIndx < maxCol; ++colIndx) {
                    int sqlType = this._COLUMN_INFO_ARRAY[colIndx].getSQLType();
                    if (!AbstractRowCache.isLongVar(sqlType)) continue;
                    int rowIndx = cacheOffset;
                    while (rowIndx - cacheOffset < this._ROWS_DATA_CACHE.size()) {
                        Row row = rdc.get(rowIndx);
                        AbstractColumn ac = ColumnFactory.createBlobColumn(this.fsStatement, colIndx + 1, rowIndx + 1, sqlType);
                        row.setColumnData(colIndx, ac);
                        if (AbstractLogger.isTrace) {
                            logger.trace("prepareToUnpackDataAndCache(packedRowsBuffer,rowStatus)", "Column " + this._COLUMN_INFO_ARRAY[colIndx].getName() + " is a BLOB column.");
                        }
                        ++rowIndx;
                    }
                }
                if (packedRowsBuffer.length > 0) {
                    try {
                        if (this.packType == 1) {
                            this.unpackFetch2Buffer1(rdc, packedRowsBuffer, rowStatus, cacheOffset);
                            break block23;
                        }
                        this.unpackFetch2Buffer0(rdc, packedRowsBuffer, rowStatus, cacheOffset);
                    }
                    catch (ArrayIndexOutOfBoundsException aio) {
                        String s = String.format("Fatal Unpack Error Information row:%d, column:%d", this.debugRow, this.debugCol);
                        if (AbstractLogger.isError) {
                            logger.trace("prepareToUnpackDataAndCache(packedRowsBuffer,rowStatus)", s);
                        }
                        ExceptionsLogger.log(aio);
                        this.logUnpackFatalError(packedRowsBuffer);
                        String ei = "AbstractCachingUnpackFatalError.txt";
                        this.throwException("AbstractCachingUnpackFatalError.txt", logger);
                    }
                    catch (Exception jle) {
                        String s = String.format("Fatal Unpack Error Information row:%d, column:%d", this.debugRow, this.debugCol);
                        logger.error(s);
                        logger.error(jle);
                    }
                } else if (AbstractLogger.isTrace) {
                    logger.trace("prepareToUnpackDataAndCache(packedRowsBuffer,rowStatus)", "Nothing to unpack. Buffer length is ZERO!");
                }
            }
        }
        bytes = packedRowsBuffer.length;
        long delta = System.nanoTime() - startTime;
        int tRowCount = rdc.size();
        StatementWrapper.apiUnpackData(delta, tRowCount, bytes);
        if (delta >= 1000000L) {
            this.unpackCounts.update(delta / 1000000L);
        }
        if (AbstractLogger.isTrace) {
            double seconds = delta / 1000L;
            double t = 1000.0;
            logger.trace("UNPACKED [" + tRowCount + "] rows in [" + (seconds /= 1000.0) + "] ms bytes[" + bytes + "]");
        }
        return rdc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] uncompressBuffer(byte[] packedRowsBuffer, int bufferSize) throws SQLException {
        String method = "uncompressBuffer";
        byte[] result = null;
        boolean inflateError = false;
        byte[] trueSizeBytes = new byte[4];
        long startTime = System.nanoTime();
        int compressBytes = bufferSize *= -1;
        if (AbstractLogger.isTrace) {
            logger.entry("uncompressBuffer", this.getPacketBytes(bufferSize));
        }
        int resultLength = 0;
        Inflater decompresser = null;
        try {
            block16: {
                decompresser = new Inflater();
                int expectedSize = 4;
                decompresser.setInput(packedRowsBuffer, expectedSize, bufferSize);
                try {
                    resultLength = decompresser.inflate(trueSizeBytes, 0, expectedSize);
                    if (resultLength != expectedSize) {
                        inflateError = true;
                    }
                    ByteExtractor byteExtractor = new ByteExtractor(trueSizeBytes, 0, resultLength);
                    bufferSize = byteExtractor.getInt();
                    result = new byte[bufferSize];
                    expectedSize = bufferSize - 4;
                    try {
                        resultLength = decompresser.inflate(result, resultLength, expectedSize);
                    }
                    catch (ArrayIndexOutOfBoundsException le) {
                        logger.error("Lang:" + le);
                    }
                    if (resultLength != expectedSize) {
                        inflateError = true;
                    }
                    result[0] = trueSizeBytes[0];
                    result[1] = trueSizeBytes[1];
                    result[2] = trueSizeBytes[2];
                    result[3] = trueSizeBytes[3];
                }
                catch (DataFormatException dfe) {
                    if (!AbstractLogger.isTrace) break block16;
                    logger.entry("uncompressBuffer", this.getPacketBytes(bufferSize));
                }
            }
            if (decompresser.finished()) {
                if (AbstractLogger.isTrace) {
                    logger.trace("uncompressBuffer", "Decompress " + compressBytes + " to " + bufferSize);
                }
            } else {
                inflateError = true;
            }
        }
        finally {
            if (decompresser != null) {
                decompresser.end();
                decompresser = null;
            }
        }
        if (inflateError && AbstractLogger.isError) {
            logger.trace("uncompressBuffer", "Decompress Error: ");
            String ei = "AbstractCachingDecompressionError.txt";
            this.throwException("AbstractCachingDecompressionError.txt", logger);
        }
        long delta = System.nanoTime() - startTime;
        if (logger != null) {
            LocalizedMessageHandler.logStatisticMessage("Compress.Inflater.txt", delta, logger);
        }
        return result;
    }

    private void unpackFetch2Buffer0(ArrayList<Row> rdc, byte[] packedRowsBuffer, byte[] rowStatus, int cacheOffset) throws IndexOutOfBoundsException, SQLException {
        String method = "unpackFetch2Buffer(ArrayList<Row>, packedRowsBuffer,rowStatus,cacheOffset)";
        int columnOrdinal = 0;
        int lastColumnOrdinal = Integer.MAX_VALUE;
        Row row = null;
        int rowIndx = cacheOffset;
        ByteExtractor byteExtractor = new ByteExtractor(packedRowsBuffer);
        int bufferSize = byteExtractor.getInt();
        if (AbstractLogger.isTrace) {
            logger.entry("unpackFetch2Buffer(ArrayList<Row>, packedRowsBuffer,rowStatus,cacheOffset)");
        }
        if (bufferSize < 0) {
            packedRowsBuffer = this.uncompressBuffer(packedRowsBuffer, bufferSize);
            byteExtractor = new ByteExtractor(packedRowsBuffer);
            bufferSize = byteExtractor.getInt();
        }
        if (AbstractLogger.isTrace) {
            logger.trace("unpackFetch2Buffer(ArrayList<Row>, packedRowsBuffer,rowStatus,cacheOffset)", this.getPacketBytes(bufferSize));
            int bytesToLog = UtilityFunctions.getFormatBytesRowSize();
            if (bytesToLog > bufferSize) {
                bytesToLog = bufferSize;
            }
            CommonLogger.logBytes(logger, packedRowsBuffer, 0, bytesToLog, false);
        }
        int position = byteExtractor.getCurrentPosition();
        int maxIndex = this._COLUMN_INFO_ARRAY.length;
        columnOrdinal = maxIndex + 1;
        while (position < bufferSize) {
            int foundIndex;
            columnOrdinal = byteExtractor.getInt();
            for (foundIndex = 0; foundIndex < this._COLUMN_INFO_ARRAY.length && this._COLUMN_INFO_ARRAY[foundIndex].getOrdinal() != columnOrdinal; ++foundIndex) {
            }
            if (foundIndex >= maxIndex) {
                if (AbstractLogger.isTrace) {
                    logger.trace("unpackFetch2Buffer(ArrayList<Row>, packedRowsBuffer,rowStatus,cacheOffset)", "columnOrdinal[ " + columnOrdinal + "] > number of Columns[" + this._COLUMN_INFO_ARRAY.length + "] ");
                    logger.trace("unpackFetch2Buffer(ArrayList<Row>, packedRowsBuffer,rowStatus,cacheOffset)", "Previous columnOrdinal[ " + lastColumnOrdinal);
                }
                String ei = "AbstractCachingDataTypeFatalColNumError.txt";
                this.throwException("AbstractCachingDataTypeFatalColNumError.txt", logger);
            }
            if (columnOrdinal <= lastColumnOrdinal) {
                lastColumnOrdinal = columnOrdinal;
                row = rdc.get(rowIndx);
                int statusRow = rowIndx - cacheOffset;
                row.setStatus(rowStatus[statusRow]);
                this.debugRow = ++rowIndx;
            }
            ParameterInfo pi = this._COLUMN_INFO_ARRAY[foundIndex];
            int sqlType = pi.getSQLType();
            int cType = pi.getCType();
            int nativeCType = pi.getNativeCType();
            Charset charset = pi.getNativeCharset();
            long indicator = ByteArrayConverter.getIndicatorValue(byteExtractor);
            AbstractColumn absColumn = null;
            this.debugCol = columnOrdinal;
            int cSqlType = sqlType;
            if (indicator != -41L) {
                cSqlType = sqlType;
                if (cType != nativeCType && sqlType != 1 && (sqlType < 91 || sqlType > 93)) {
                    FSEnums.FsSqlTypes lookupSqlType = FSEnums.FsSqlTypes.getByCType(nativeCType);
                    if (lookupSqlType != null) {
                        cSqlType = lookupSqlType.getValue();
                    } else {
                        logger.error(CommonLogger.getCTypeStringAndNumber(cType) + " versus " + CommonLogger.getCTypeStringAndNumber(nativeCType));
                    }
                }
                if ((absColumn = row.getColumnData(foundIndex)) == null) {
                    absColumn = ByteArrayConverter.extractOrdinalColumnData(byteExtractor, indicator, columnOrdinal, cSqlType, nativeCType, charset);
                    row.setColumnData(foundIndex, absColumn);
                } else {
                    ByteArrayConverter.updateColumnData(byteExtractor, absColumn, indicator, columnOrdinal, cSqlType, nativeCType, charset);
                }
            }
            position = byteExtractor.getCurrentPosition();
        }
    }

    private void unpackFetch2Buffer1(ArrayList<Row> rdc, byte[] packedRowsBuffer, byte[] rowStatus, int cacheOffset) throws IndexOutOfBoundsException, SQLException {
        String method = "unpackFetch2Buffer1(ArrayList<Row>, packedRowsBuffer,rowStatus,cacheOffset)";
        Row row = null;
        int rowIndx = cacheOffset;
        ByteExtractor byteExtractor = new ByteExtractor(packedRowsBuffer);
        int bufferSize = byteExtractor.getInt();
        if (AbstractLogger.isTrace) {
            logger.entry("unpackFetch2Buffer1(ArrayList<Row>, packedRowsBuffer,rowStatus,cacheOffset)");
        }
        if (bufferSize < 0) {
            packedRowsBuffer = this.uncompressBuffer(packedRowsBuffer, bufferSize);
            byteExtractor = new ByteExtractor(packedRowsBuffer);
            bufferSize = byteExtractor.getInt();
        }
        if (AbstractLogger.isTrace) {
            logger.trace("unpackFetch2Buffer1(ArrayList<Row>, packedRowsBuffer,rowStatus,cacheOffset)", this.getPacketBytes(bufferSize));
            int bytesToLog = UtilityFunctions.getFormatBytesRowSize();
            if (bytesToLog > bufferSize) {
                bytesToLog = bufferSize;
            }
            CommonLogger.logBytes(logger, packedRowsBuffer, 0, bytesToLog, false);
        }
        int position = byteExtractor.getCurrentPosition();
        int unpackColumnNumber = byteExtractor.getInt();
        int[] unpackColumns = new int[unpackColumnNumber];
        UnpackInfo[] unpackInfo = new UnpackInfo[unpackColumnNumber];
        for (int i = 0; i < unpackColumnNumber; ++i) {
            int j;
            unpackColumns[i] = j = byteExtractor.getInt();
            unpackInfo[i] = new UnpackInfo(this._COLUMN_INFO_ARRAY[j - 1], true);
        }
        int maxIndex = this.getBoundColumns();
        if (unpackColumnNumber < maxIndex) {
            maxIndex = unpackColumnNumber;
        }
        int columnIndex = maxIndex + 1;
        position = byteExtractor.getCurrentPosition();
        while (position < bufferSize) {
            if (columnIndex >= maxIndex) {
                columnIndex = 0;
                row = rdc.get(rowIndx);
                int statusRow = rowIndx - cacheOffset;
                row.setStatus(rowStatus[statusRow]);
                this.debugRow = ++rowIndx;
            }
            int columnOrdinal = unpackColumns[columnIndex];
            long indicator = ByteArrayConverter.getIndicatorValue(byteExtractor);
            int foundIndex = columnOrdinal - 1;
            AbstractColumn absColumn = null;
            this.debugCol = columnOrdinal;
            if (indicator != -41L) {
                UnpackInfo ui = unpackInfo[columnIndex];
                absColumn = row.getColumnData(foundIndex);
                if (absColumn == null) {
                    absColumn = ByteArrayConverter.extractOrdinalColumnDataV1(byteExtractor, indicator, columnOrdinal, ui);
                    row.setColumnData(foundIndex, absColumn);
                } else {
                    ByteArrayConverter.updateColumnDataV1(byteExtractor, absColumn, indicator, columnOrdinal, ui);
                }
            }
            position = byteExtractor.getCurrentPosition();
            ++columnIndex;
        }
    }

    private void performRowInsert2() throws SQLException {
        String method = "performRowInsert2()";
        if (AbstractLogger.isTrace) {
            logger.entry("performRowInsert2()", "Perform row insert2.");
        }
        int rowsFetched = 1;
        byte[] rowOperations = new byte[]{0};
        int lockType = 0;
        OctetSeqHolder rowStatus = new OctetSeqHolder();
        OctetSeqHolder bookmarks = new OctetSeqHolder();
        IntHolder status = new IntHolder();
        this.fsStatement.bindAbnormalColumns(12);
        Row row = this._ROWS_DATA_CACHE.get(this.cacheCURSOR);
        for (int cindx = 0; cindx < this._COLUMN_INFO_ARRAY.length; ++cindx) {
            AbstractColumn columnData = row.getColumnData(cindx);
            this._COLUMN_INFO_ARRAY[cindx].setValue(columnData.getRawData());
        }
        long startTime = System.nanoTime();
        byte[] packedBuffer = ByteArrayConverter.buildPackedBuffer(this._COLUMN_INFO_ARRAY, this.packType == 1);
        long delta = System.nanoTime() - startTime;
        StatementWrapper.apiPackData(delta, 1L, packedBuffer.length);
        if (AbstractLogger.isTrace) {
            logger.trace("performRowInsert2()", "Insert2 ResultSetPosition=" + this.rSetCURSOR + " RowSetPosition=[" + (this.cacheCURSOR + 1) + "]");
        }
        try {
            this.statementWrapper.Add2(this.cacheCURSOR + 1, lockType, rowsFetched, rowOperations, packedBuffer, bookmarks, rowStatus, status);
            this.checkForWarnings(status.value);
            if (status.value == -2130708475) {
                this.executePutData();
            }
            this.fsStatement.bindAbnormalColumns(100);
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("performRowInsert2()", exception, this.statementWrapper, logger);
        }
    }

    private void performRowUpdate2() throws SQLException {
        String method = "performRowUpdate2()";
        if (AbstractLogger.isTrace) {
            logger.entry("performRowUpdate2()", "Perform row update 2.");
        }
        int rowsFetched = 1;
        byte[] rowOperations = new byte[]{0};
        int lockType = 0;
        OctetSeqHolder rowStatus = new OctetSeqHolder();
        IntHolder status = new IntHolder();
        this.fsStatement.bindAbnormalColumns(12);
        Row row = this._ROWS_DATA_CACHE.get(this.cacheCURSOR);
        for (int cindx = 0; cindx < this._COLUMN_INFO_ARRAY.length; ++cindx) {
            AbstractColumn columnData = row.getColumnData(cindx);
            this._COLUMN_INFO_ARRAY[cindx].setValue(columnData.getRawData());
        }
        long startTime = System.nanoTime();
        byte[] packedBuffer = ByteArrayConverter.buildPackedBuffer(this._COLUMN_INFO_ARRAY, this.packType == 1);
        long delta = System.nanoTime() - startTime;
        StatementWrapper.apiPackData(delta, 1L, packedBuffer.length);
        if (AbstractLogger.isTrace) {
            logger.trace("performRowUpdate2()", "Update2 ResultSetPosition=" + this.rSetCURSOR + " RowSetPosition=[" + (this.cacheCURSOR + 1) + "] Concurrency=[" + this.fsStatement.getConcurrency() + "]");
        }
        try {
            this.statementWrapper.Update2(this.cacheCURSOR + 1, lockType, rowsFetched, rowOperations, packedBuffer, rowStatus, status);
            this.checkForWarnings(status.value);
            if (status.value == -2130708475) {
                this.executePutData();
            }
            this.fsStatement.bindAbnormalColumns(100);
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("performRowUpdate2()", exception, this.statementWrapper, logger);
        }
    }

    private void performRowRefresh2() throws SQLException {
        String method = "performRowRefresh2()";
        if (AbstractLogger.isTrace) {
            logger.entry("performRowRefresh2()", "Perform row refresh2.");
        }
        int rowsFetched = 1;
        int lockType = 0;
        OctetSeqHolder rowStatus = new OctetSeqHolder();
        OctetSeqHolder packedBuffer = new OctetSeqHolder();
        IntHolder status = new IntHolder();
        if (AbstractLogger.isTrace) {
            logger.trace("performRowRefresh2()", "ResultSetPosition=" + this.rSetCURSOR + "  RowSetPosition=" + (this.cacheCURSOR + 1));
        }
        try {
            this.statementWrapper.Refresh2(this.cacheCURSOR + 1, lockType, rowsFetched, new byte[]{5}, packedBuffer, rowStatus, status);
            this.checkForWarnings(status.value);
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("performRowRefresh2()", exception, this.statementWrapper, logger);
        }
        if (this.packType == 0) {
            this.unpackFetch2Buffer0(this._ROWS_DATA_CACHE, packedBuffer.value, rowStatus.value, this.cacheCURSOR);
        } else {
            this.unpackFetch2Buffer1(this._ROWS_DATA_CACHE, packedBuffer.value, rowStatus.value, this.cacheCURSOR);
        }
        if (AbstractLogger.isTrace) {
            logger.exit("performRowRefresh2()");
        }
    }

    private void executePutData() throws SQLException {
        String method = "executePutData()";
        if (AbstractLogger.isTrace) {
            logger.entry("executePutData()", "Execute put data.");
        }
        boolean isPutData = true;
        int cindx = 0;
        IntHolder status = new IntHolder();
        while (isPutData) {
            try {
                cindx = this.statementWrapper.ParamData(status);
            }
            catch (Exception exception) {
                LocalizedErrorHandler.handleExceptionsInFunction("executePutData()", exception, this.statementWrapper, logger);
            }
            if (status.value == -2130708475 && cindx > 0) {
                this.invokePutData(this._COLUMN_INFO_ARRAY[cindx].getValue());
                continue;
            }
            isPutData = false;
        }
    }

    private void invokePutData(Object currentParameterData) throws SQLException {
        String method = "invokePutData(currentParameterData)";
        if (AbstractLogger.isTrace) {
            logger.entry("invokePutData(currentParameterData)", "Invoke put data.");
        }
        IntHolder status = new IntHolder();
        Any parameterData = this.fsStatement.getORBHandle().create_any();
        int lenOrInd = -1;
        if (currentParameterData != null) {
            if (currentParameterData instanceof String) {
                String value = (String)currentParameterData;
                parameterData.insert_string(value);
                lenOrInd = value.length();
            } else {
                byte[] sequence = (byte[])currentParameterData;
                OctetSeqHelper.insert((Any)parameterData, (byte[])sequence);
                lenOrInd = sequence.length;
            }
        }
        try {
            this.statementWrapper.PutData(parameterData, lenOrInd, status);
        }
        catch (Exception exception) {
            LocalizedErrorHandler.handleExceptionsInFunction("invokePutData(currentParameterData)", exception, this.statementWrapper, logger);
        }
    }

    private int getFetchTopRowNumber() throws SQLException {
        int tRowNumber;
        block5: {
            String method = "getFetchTopRowNumber()";
            tRowNumber = 0;
            if (this.isMetadataCache || this.resultSetType == 1003) {
                tRowNumber = this.topRowNumber;
            } else {
                try {
                    tRowNumber = (int)AbstractIOMWrapper.getBigIntAttribute(this.statementWrapper, 14);
                    if (tRowNumber == 0 && AbstractLogger.isTrace && AbstractLogger.isTrace) {
                        logger.trace(method, "ERROR:TKTS_ATTR_ROW_NUMBER returned it 0?");
                    }
                }
                catch (Exception e) {
                    if (!AbstractLogger.isTrace) break block5;
                    logger.trace(method, e.getMessage());
                }
            }
        }
        return tRowNumber;
    }

    public int getBoundColumns() {
        int outValue = this.tktsBindColumns == -1 ? this._COLUMN_INFO_ARRAY.length : this.tktsBindColumns;
        return outValue;
    }

    protected void setBoundColumns(int inValue) {
        this.tktsBindColumns = inValue;
    }

    private void logUnpackFatalError(byte[] packedRowsBuffer) throws SQLException {
        String method = "logUnpackFatalError(packedRowsBuffer)";
        if (AbstractLogger.isTrace) {
            logger.trace(method, "Fatal Unpack Error Information  ");
        }
        logger.trace("Fatal Unpack Error Information  ");
        for (ParameterInfo pi : this._COLUMN_INFO_ARRAY) {
            int sqlType = pi.getSQLType();
            int cType = pi.getCType();
            int nativeCType = pi.getNativeCType();
            Charset charset = pi.getNativeCharset();
            if (!AbstractLogger.isTrace) continue;
            logger.trace(method, "Processing column=[" + pi.getName() + "] SQLType=[" + CommonLogger.getSQLTypeString(sqlType) + ":" + sqlType + "] CType=[" + CommonLogger.getCTypeString(cType) + ":" + cType + "] nativeCType=[" + CommonLogger.getCTypeString(nativeCType) + ":" + nativeCType + "] charset=[" + charset + "]");
        }
        ByteExtractor byteExtractor = new ByteExtractor(packedRowsBuffer);
        int bufferSize = byteExtractor.getInt();
        if (AbstractLogger.isTrace) {
            String dStr = this.getPacketBytes(bufferSize);
            logger.trace(method, dStr);
            CommonLogger.logBytes(logger, packedRowsBuffer, 0, bufferSize, true);
        }
    }

    public void populateCache(ArrayList<Row> rowList) throws SQLException {
        String method = "populateCache(rowList)";
        if (AbstractLogger.isTrace) {
            logger.entry("populateCache(rowList)", "Populating cache.");
        }
        int rowsInList = rowList.size();
        ArrayList<Row> _TEMP_ROWS_DATA_CACHE = new ArrayList<Row>();
        for (int rowIndex = 0; rowIndex < rowsInList; ++rowIndex) {
            Row tRow = rowList.get(rowIndex);
            int colMax = tRow.size();
            for (int colIndex = 0; colIndex < colMax; ++colIndex) {
                AbstractColumn tAC = tRow.getColumnData(colIndex);
                String col = tAC.getString();
                tRow.setColumnData(colIndex, ColumnFactory.createStringColunn(col));
            }
            _TEMP_ROWS_DATA_CACHE.add(tRow);
        }
        this.isAllSchemaRowsFetched = true;
        this._ROWS_DATA_CACHE = _TEMP_ROWS_DATA_CACHE;
        this.rowCount = this._ROWS_DATA_CACHE.size();
        this.beforeFirst();
        this.afterLast = false;
        if (AbstractLogger.isTrace) {
            logger.exit("populateCache(rowList)", "Rows:" + rowsInList);
        }
    }

    public void removeRow(int rowNumber) {
        this._ROWS_DATA_CACHE.remove(rowNumber);
        this.rowCount = this._ROWS_DATA_CACHE.size();
    }

    public String toString() {
        boolean tLast = false;
        String outStr = "Class: + " + thisClassName;
        outStr = outStr + "\nfetchSize: " + this.fetchSize + " fetchSizeUsed: " + this.fetchSizeUsed;
        outStr = outStr + "\npositionChanged: " + this.positionChanged + " isValidRow:" + this.isValidRow;
        outStr = outStr + "\nisMetadataCache: " + this.isMetadataCache;
        outStr = outStr + "\npackType: " + this.packType;
        outStr = this.prefetch ? outStr + "\nPrefetch:On" : outStr + "\nPrefetch:Off";
        outStr = outStr + "\nRows[" + this.topRowNumber + ":" + this.lastRowNumber + "] Count:" + this.rowCount;
        outStr = outStr + "\ncacheCURSOR: " + this.cacheCURSOR;
        outStr = outStr + "\nrSetCURSOR: " + this.rSetCURSOR;
        outStr = outStr + "\nlargestRSetCURSOR:" + this.largestRSetCURSOR;
        if (this.endOfDataReached) {
            outStr = outStr + "(Verified)";
        }
        try {
            outStr = outStr + "\nbeforeFirst: " + this.isBeforeFirst() + "  first:" + this.isFirst();
            if (this.endOfDataReached) {
                if (this.cacheCURSOR == this.largestRSetCURSOR) {
                    tLast = true;
                }
                outStr = outStr + "\nlast: " + tLast + " afterLast:" + this.afterLast;
            } else {
                outStr = outStr + "\nlast:?  afterLast:" + this.afterLast;
            }
            outStr = outStr + "\nCurrent Row:";
            if (this._ROWS_DATA_CACHE == null || this.endOfDataReached || this.isBeforeFirst() || this.afterLast) {
                outStr = outStr + "\n>>> NONE <<<<";
            } else if (this._ROWS_DATA_CACHE.size() > 0) {
                Row row = this._ROWS_DATA_CACHE.get(this.cacheCURSOR);
                outStr = outStr + row.toString();
            }
        }
        catch (SQLException se) {
            outStr = outStr + "\nbeforeFirst:? first:? last:? afterLast:? ";
            logger.error(outStr);
            logger.error(se);
        }
        return outStr;
    }

    public String toStringSummary() {
        String outStr = "";
        outStr = outStr + "\nfetchSize: " + this.fetchSize + " fetchSizeUsed: " + this.fetchSizeUsed;
        outStr = outStr + "\nRows[" + this.topRowNumber + ":" + this.lastRowNumber + "] Count:" + this.rowCount;
        Row row = this._ROWS_DATA_CACHE.get(0);
        outStr = outStr + row.toString();
        row = this._ROWS_DATA_CACHE.get(this._ROWS_DATA_CACHE.size() - 1);
        outStr = outStr + row.toString() + "\n";
        return outStr;
    }

    public long getRTT() {
        if (this.fsStatement == null) {
            return -1L;
        }
        return this.fsStatement.getRTT();
    }

    public static void clearRDC(ArrayList<Row> rdc) {
        if (rdc == null) {
            return;
        }
        for (int last = rdc.size() - 1; last >= 0; --last) {
            Row row = rdc.remove(last);
            row.cleanup();
        }
    }

    public int estimateRowBytes() {
        if (this.rowBytes > 0) {
            return this.rowBytes;
        }
        this.rowBytes = 0;
        if (this._COLUMN_INFO_ARRAY != null) {
            block14: for (int i = 0; i < this._COLUMN_INFO_ARRAY.length; ++i) {
                this.rowBytes += 4;
                if (this._COLUMN_INFO_ARRAY[i] == null) continue;
                int sqlType = this._COLUMN_INFO_ARRAY[i].getSQLType();
                switch (sqlType) {
                    case -3: 
                    case -2: 
                    case 1: 
                    case 12: {
                        int c = (int)this._COLUMN_INFO_ARRAY[i].getDisplaySizeInCharacters();
                        this.rowBytes += c;
                        if (c < 127) {
                            ++this.rowBytes;
                            continue block14;
                        }
                        if (c < Short.MAX_VALUE) {
                            this.rowBytes += 2;
                            continue block14;
                        }
                        this.rowBytes += 4;
                        continue block14;
                    }
                    case -6: {
                        ++this.rowBytes;
                        continue block14;
                    }
                    case 5: {
                        this.rowBytes += 2;
                        continue block14;
                    }
                    case 4: {
                        this.rowBytes += 4;
                        continue block14;
                    }
                    case -5: {
                        this.rowBytes += 8;
                        continue block14;
                    }
                    case 8: {
                        this.rowBytes += 8;
                        continue block14;
                    }
                    case 7: {
                        this.rowBytes += 4;
                        continue block14;
                    }
                    case 6: {
                        this.rowBytes += 8;
                        continue block14;
                    }
                    case 2: 
                    case 3: {
                        this.rowBytes += 19;
                        continue block14;
                    }
                    case 91: {
                        this.rowBytes += 6;
                        continue block14;
                    }
                    case 92: {
                        this.rowBytes += 6;
                        continue block14;
                    }
                    case 93: {
                        this.rowBytes += 16;
                        continue block14;
                    }
                }
            }
        }
        return this.rowBytes;
    }

    public int estimateRAS(int inRAS) {
        int MAX_ROWS = 5005;
        if (inRAS > 5005) {
            inRAS = 5005;
        }
        int outRAS = inRAS;
        this.estimateRowBytes();
        if (this.rowBytes > 0) {
            outRAS = 0x300000 / this.rowBytes;
            if (outRAS == 0) {
                outRAS = 1;
            }
            if (outRAS > 5005) {
                outRAS = 5005;
            }
        }
        if (this.fsStatement != null) {
            int maxStmtRows;
            try {
                maxStmtRows = this.fsStatement.getMaxRows();
            }
            catch (SQLException se) {
                logger.trace("Exception in estimateRAS calling getMaxRows ");
                logger.trace(se);
                maxStmtRows = 5005;
            }
            if (maxStmtRows > 0 && outRAS > maxStmtRows) {
                outRAS = maxStmtRows;
            }
        }
        return outRAS;
    }

    public void determinePackType() {
        FSConnection fsConn = null;
        this.packType = -1;
        if (this.fsStatement != null) {
            fsConn = this.fsStatement.getFSConnection();
            if (fsConn != null) {
                this.packType = fsConn.getPackType();
            }
        } else if (this.statementWrapper != null && (fsConn = this.statementWrapper.getFSConnection()) != null) {
            this.packType = fsConn.getPackType();
        }
        if (this.packType == -1) {
            this.packType = 0;
        }
    }
}

