/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts;

import com.sas.tkts.FedSrvJDBC;
import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TrackResource {
    private static String thisClassName = TrackResource.class.getName();
    private static AbstractLogger logger = LoggerFactory.getLogger(thisClassName);
    protected static final String[] stackSkipStrings = new String[]{"org.junit.internal", "org.junit.runners", "org.eclipse", "sun.reflect.NativeMethodAccessorImpl:invoke0", "sun.reflect.NativeMethodAccessorImpl:invoke", "sun.reflect.DelegatingMethodAccessorImpl:invoke", "org.junit.rules.TestWatchman$1:evaluate"};
    protected transient Map<Long, Resource> mapByID;
    protected transient long tracks;
    protected transient long untracks;
    protected transient long duplicates;
    protected transient long notFounds;
    protected transient long trackExceptions;
    protected transient long untrackExceptions;
    protected transient String className;
    protected transient boolean logDetails = false;

    private static void wrapperOut(String inStr) {
        System.out.println(inStr);
    }

    private static void wrapperErr(String inStr) {
        System.err.println(inStr);
    }

    public TrackResource(String inClassName) {
        this.className = inClassName;
        this.mapByID = new HashMap<Long, Resource>(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(FedSrvJDBC inRes, String desc) {
        Map<Long, Resource> map = this.mapByID;
        synchronized (map) {
            try {
                Resource tr = new Resource(inRes, desc);
                long resID = inRes.getMyID();
                Resource trOld = this.mapByID.put(resID, tr);
                if (this.logDetails) {
                    TrackResource.wrapperOut("Track Added:" + desc + " Count:" + this.mapByID.size());
                }
                if (trOld == null) {
                    ++this.tracks;
                } else {
                    if (this.logDetails) {
                        TrackResource.wrapperErr("Track Already added:" + desc);
                    }
                    ++this.duplicates;
                }
            }
            catch (Exception tEx) {
                TrackResource.wrapperErr("Exception in Track:" + tEx);
                ++this.trackExceptions;
                logger.error(tEx);
            }
            catch (Error le) {
                TrackResource.wrapperErr("javaLangError in Track:" + le);
                ++this.trackExceptions;
                logger.error(le);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void untrack(FedSrvJDBC inRes) {
        Map<Long, Resource> map = this.mapByID;
        synchronized (map) {
            try {
                long resID = inRes.getMyID();
                Resource tr = this.mapByID.remove(resID);
                if (tr == null) {
                    if (this.logDetails) {
                        TrackResource.wrapperErr("Untrack Already released ID:" + resID);
                    }
                    ++this.notFounds;
                } else {
                    if (this.logDetails) {
                        TrackResource.wrapperOut("Untrack Released:" + tr.desc + " Count:" + this.mapByID.size());
                    }
                    ++this.untracks;
                    tr.resource = null;
                    tr.desc = null;
                    tr.stackTrace = null;
                }
            }
            catch (Exception tEx) {
                TrackResource.wrapperErr("Exception in untrack:" + tEx);
                ++this.untrackExceptions;
                logger.error(tEx);
            }
            catch (Error le) {
                TrackResource.wrapperErr("javaLangError in untrack:" + le);
                ++this.untrackExceptions;
                logger.error(le);
            }
        }
    }

    public void displayHelper() {
        TrackResource.wrapperOut("");
        TrackResource.wrapperOut(this.className + " TrackResource Output:");
        TrackResource.wrapperOut("Tracks:  " + this.tracks);
        TrackResource.wrapperOut("Untracks:" + this.untracks);
        if (this.duplicates > 0L) {
            TrackResource.wrapperOut("Duplicates:" + this.duplicates);
        }
        if (this.notFounds > 0L) {
            TrackResource.wrapperOut("NotFound:" + this.notFounds);
        }
        if (this.untrackExceptions > 0L) {
            TrackResource.wrapperOut("untrackExceptions:" + this.untrackExceptions);
        }
        if (this.trackExceptions > 0L) {
            TrackResource.wrapperOut("trackExceptions:" + this.trackExceptions);
        }
        TrackResource.wrapperOut("Orphan Resources:" + this.mapByID.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displaySummary() {
        Map<Long, Resource> map = this.mapByID;
        synchronized (map) {
            this.displayHelper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display() {
        Map<Long, Resource> map = this.mapByID;
        synchronized (map) {
            this.displayHelper();
            Iterator<Map.Entry<Long, Resource>> it = this.mapByID.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Resource> pair = it.next();
                Resource tr = pair.getValue();
                TrackResource.wrapperOut(tr.toString());
                TrackResource.wrapperOut("");
                it.remove();
            }
            TrackResource.wrapperOut("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() {
        long out;
        Map<Long, Resource> map = this.mapByID;
        synchronized (map) {
            out = this.mapByID.size();
        }
        return out;
    }

    public void setLogDetails(boolean inValue) {
        this.logDetails = inValue;
    }

    public class Resource {
        transient FedSrvJDBC resource;
        transient String desc;
        transient StackTraceElement[] stackTrace;

        public Resource(FedSrvJDBC inRes, String inDesc) {
            this.resource = inRes;
            this.desc = inDesc;
            Thread myThread = Thread.currentThread();
            this.stackTrace = myThread.getStackTrace();
        }

        public String toString() {
            String outDesc = this.desc == null ? "" : ":" + this.desc;
            Class<?> myClass = this.resource.getClass();
            String out = myClass.getSimpleName() + outDesc;
            int e = this.stackTrace.length;
            for (int i = 3; i < e; ++i) {
                StackTraceElement ste = this.stackTrace[i];
                String className = ste.getClassName();
                if (FedSrvJDBC.findStrings(className, stackSkipStrings)) continue;
                out = out + "\n " + className + ":" + ste.getMethodName() + ":" + ste.getLineNumber() + ":";
            }
            return out;
        }
    }
}

