/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tkts;

import com.sas.tkts.logging.AbstractLogger;
import com.sas.tkts.sql.LocalizedMessageHandler;

public class SystemPropertiesInfo {
    public String key;
    public String originalValue;
    public String defaultValue;
    public String strValue;
    public int intValue;
    public boolean boolValue;
    public boolean boolValueDisabled;
    public boolean valid;
    public static final String PROP_MEASUREMENTS_SUMMARY = "summary";
    public static final String PROP_MEASUREMENTS_DETAILS = "details";

    public SystemPropertiesInfo(String k, String d) {
        this.key = k;
        this.defaultValue = d;
        this.originalValue = System.getProperty(this.key);
        this.strValue = this.originalValue == null ? this.defaultValue : this.originalValue.toLowerCase();
    }

    public void verifyBoolean() {
        this.valid = true;
        if (this.strValue.equalsIgnoreCase("false")) {
            this.boolValue = false;
        } else if (this.strValue.equalsIgnoreCase("true")) {
            this.boolValue = true;
        } else {
            this.valid = false;
        }
    }

    public void verifyThreshold() {
        this.valid = true;
        try {
            this.intValue = Integer.parseInt(this.strValue);
        }
        catch (NumberFormatException n) {
            this.intValue = 0;
            this.valid = false;
        }
    }

    public void log(AbstractLogger logger, String method) {
        String infoSystemPropertyFMT = "TKTSDriver.systemProperty.fmt";
        String errorSystemPropertyFMT = "TKTSDriver.systemPropertyIncorrect.fmt";
        if (this.valid) {
            String ei = "TKTSDriver.systemProperty.fmt";
            LocalizedMessageHandler.logInfoMessage(method, logger, ei, this.key, this.originalValue);
        } else {
            String ei = "TKTSDriver.systemPropertyIncorrect.fmt";
            LocalizedMessageHandler.logErrorMessage(method, logger, ei, this.key, this.originalValue);
        }
    }
}

