/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MetadataResource;
import java.rmi.RemoteException;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.StringHolder;

@SASScope
public class SecurityUtil {
    protected static MetadataResource bundle = new MetadataResource(SecurityUtil.class);
    private static final String PERMISSION_WRITEMETADATA = "WriteMetadata";
    private static final String PERMISSION_WRITEMEMBERMETADATA = "WriteMemberMetadata";
    private static final String PERMISSION_READMETADATA = "ReadMetadata";

    public static synchronized ISecurity makeISecurityConnection(MdFactory factory) throws RemoteException, MdException {
        if (factory == null) {
            throw new IllegalArgumentException(bundle.getString("SecurityUtil.InvalidFactory.txt"));
        }
        if (factory.getConnection().getCMRHandle() == null) {
            throw new IllegalStateException(bundle.getString("SecurityUtil.NoConnection.txt"));
        }
        ISecurity_1_1 iSec = factory.getConnection().MakeISecurityConnection(factory.getConnection().getCMRHandle());
        return iSec;
    }

    public static void closeISecurityConnection(MdFactory factory, ISecurity iSec) throws RemoteException, MdException {
        if (iSec != null && factory != null) {
            factory.getConnection().closeISecurityConnection(iSec);
        }
    }

    public static boolean isReadAuthorized(ISecurity isec, String metadataType, String metadataID) throws MdException {
        return SecurityUtil.isAuthorized(isec, PERMISSION_READMETADATA, metadataID, metadataType);
    }

    public static boolean isWriteAuthorized(ISecurity isec, String metadataType, String metadataID) throws MdException {
        return SecurityUtil.isAuthorized(isec, PERMISSION_WRITEMETADATA, metadataID, metadataType);
    }

    public static boolean isFolderWriteAuthorized(ISecurity isec, String folderID) throws MdException {
        return SecurityUtil.isAuthorized(isec, PERMISSION_WRITEMEMBERMETADATA, folderID, "Tree");
    }

    private static boolean isAuthorized(ISecurity isec, String permissionType, String objectID, String metadataType) throws MdException {
        if (isec == null) {
            throw new IllegalArgumentException(bundle.getString("SecurityUtil.InvalidConnection.txt"));
        }
        String resource = "OMSOBJ:" + metadataType + "/" + objectID;
        StringHolder permissionCondition = new StringHolder();
        BooleanHolder authorized = new BooleanHolder();
        try {
            isec.IsAuthorized("", resource, permissionType, permissionCondition, authorized);
            return authorized.value;
        }
        catch (Exception e) {
            throw new MdException(e);
        }
    }

    public static int getCountNoSecurity(ISecurity isec, String reposID, String xmlSelect, String metadataType) throws MdException {
        return SecurityUtil.getCountNoSecurity(isec, reposID, xmlSelect, metadataType, 0);
    }

    public static int getCountNoSecurity(ISecurity isec, String reposID, String xmlSelect, String metadataType, int flags) throws MdException {
        if (isec == null) {
            throw new IllegalArgumentException(bundle.getString("SecurityUtil.InvalidConnection.txt"));
        }
        VariableArray2dOfStringHolder result = new VariableArray2dOfStringHolder();
        flags |= 0x100;
        flags |= 0x80;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<GetMetadataObjects>");
        buffer.append("  <Reposid>" + reposID + "</Reposid>");
        buffer.append("  <Type>" + metadataType + "</Type>");
        buffer.append("  <Objects/>");
        buffer.append("  <NS>SAS</NS>");
        buffer.append("  <Flags>" + flags + "</Flags>");
        buffer.append("  <options>");
        buffer.append(xmlSelect);
        buffer.append("  </options>");
        buffer.append("</GetMetadataObjects>");
        try {
            isec.GetAuthorizations("getCountNoSecurity", "", buffer.toString(), "", result);
        }
        catch (Exception t) {
            throw new MdException(t);
        }
        if (result != null) {
            String string = result.value[0][1];
            int count = Integer.parseInt(string);
            return count;
        }
        return 0;
    }
}

