/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdUtil;
import com.sas.metadata.remote.XMLUtil;
import com.sas.net.crypto.CipherInterface;
import com.sas.net.crypto.Crypto;
import com.sas.text.SASDateTimeFormat;
import com.sas.util.Encryption;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@SASScope
public class MdUtilImpl
implements MdUtil,
Serializable {
    static final long serialVersionUID = -6336205043076462940L;
    private static final String CLIENT_BEGIN_TAG = "<Client>";
    private static final String CLIENT_END_TAG = "</Client>";
    private static final String SERVER_BEGIN_TAG = "<Server>";
    private static final String SERVER_END_TAG = "</Server>";
    private static String _defaultEncoding;
    private PrintWriter outputWriter = null;
    private PrintWriter logWriter = null;
    private OutputStream outputStream = new OutputStream(){

        @Override
        public void write(int bytes) {
        }
    };
    private OutputStream logStream = null;
    private OutputStream perfStream = null;
    private PrintWriter perfWriter = null;
    private MdFactory m_factory;
    private String cryType = "SASPROPRIETARY";
    private static boolean _useOldEncryption;

    public MdUtilImpl(MdFactory factory) throws RemoteException {
        this();
        this.m_factory = factory;
        if (this.m_factory.isRemoteEnvironment()) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    public MdUtilImpl() throws RemoteException {
        this.setOutputStream(this.outputStream);
        this.logStream = new OutputStream(){

            @Override
            public void write(int bytes) {
            }
        };
        this.setLogStream(this.logStream);
    }

    @Override
    public void dispose() throws RemoteException {
        if (this.m_factory.isRemoteEnvironment()) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        this.m_factory = null;
    }

    @Override
    public void setOutputToNull() throws RemoteException {
        this.outputStream = new OutputStream(){

            @Override
            public void write(int bytes) {
            }
        };
        this.setOutputStream(this.outputStream);
    }

    @Override
    public void setLogToNull() throws RemoteException {
        this.logStream = new OutputStream(){

            @Override
            public void write(int bytes) {
            }
        };
        this.setLogStream(this.logStream);
    }

    @Override
    public final boolean equals(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    @Override
    public final boolean equalsIgnoreCase(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equalsIgnoreCase(s2);
    }

    public static void setEncryptionTo913Technique(boolean value) {
        _useOldEncryption = value;
    }

    @Override
    public String encrypt(String input) throws RemoteException {
        if (input != null) {
            if (_useOldEncryption) {
                return this.safeEncrypt(input);
            }
            return Encryption.encrypt((String)input);
        }
        return null;
    }

    @Override
    public String decrypt(String input) throws RemoteException {
        return Encryption.decrypt((String)input);
    }

    @Override
    public String safeEncrypt(String input) throws RemoteException {
        String charset = System.getProperty("com.sas.util.encryption913.encoding");
        if (charset == null && System.getProperty("os.arch").contains("390")) {
            charset = "Cp1252";
        }
        if (charset != null) {
            if (charset.equals("default")) {
                charset = Charset.defaultCharset().name();
            }
            try {
                Properties p = new Properties();
                Crypto sssss = Crypto.getCrypto((String)this.cryType, (Properties)p);
                CipherInterface ci = sssss.openCipher();
                byte[] inbytes = input.getBytes(charset);
                ByteArrayOutputStream outstr = new ByteArrayOutputStream(ci.getCipherTextLength(inbytes.length));
                ci.encrypt(inbytes, 0, inbytes.length, (OutputStream)outstr);
                byte[] outbytes = outstr.toByteArray();
                StringBuffer enc = new StringBuffer(outbytes.length);
                for (int n : outbytes) {
                    int uvalue = n;
                    if (uvalue < 0) {
                        uvalue += 256;
                    }
                    enc.append(Character.forDigit(uvalue / 16, 16));
                    enc.append(Character.forDigit(uvalue % 16, 16));
                }
                return enc.toString().toUpperCase();
            }
            catch (Exception e) {
                System.err.println("Internal error: com.sas.metadata.remote.MdUtilImpl#safeEncrypt\n" + e);
                return null;
            }
        }
        String binaryEncrypted = this.encryptString(input);
        if (binaryEncrypted == null) {
            return null;
        }
        byte[] expandedBinary = new byte[binaryEncrypted.length()];
        for (int i = 0; i < binaryEncrypted.length(); ++i) {
            expandedBinary[i] = (byte)binaryEncrypted.charAt(i);
        }
        String safeEncryption = this.convertByteArrayToHexString(expandedBinary);
        return safeEncryption;
    }

    @Override
    public String safeDecrypt(String input) throws RemoteException {
        if (input == null) {
            return null;
        }
        String ret = "";
        String charset = System.getProperty("com.sas.util.encryption913.encoding");
        if (charset == null && System.getProperty("os.arch").contains("390")) {
            charset = "Cp1252";
        }
        if (charset != null) {
            if (charset.equals("default")) {
                charset = Charset.defaultCharset().name();
            }
            byte[] encryptedBytes = this.convertHexStringToByteArray(input);
            try {
                Properties p = new Properties();
                Crypto sssss = Crypto.getCrypto((String)this.cryType, (Properties)p);
                CipherInterface ci = sssss.openCipher();
                ByteArrayInputStream instr = new ByteArrayInputStream(encryptedBytes);
                byte[] result = new byte[ci.getMaxPlainTextLength(encryptedBytes.length)];
                int returnLength = ci.decrypt((InputStream)instr, encryptedBytes.length, result, 0);
                ret = new String(result, 0, returnLength, charset);
            }
            catch (Exception e) {
                System.err.println("Internal error: com.sas.metadata.remote.MdUtilImpl#safeDecrypt\n" + e);
                ret = null;
            }
            return ret;
        }
        byte[] expandedBinary = this.convertHexStringToByteArray(input);
        for (int i = 0; i < expandedBinary.length; ++i) {
            ret = ret + (char)expandedBinary[i];
        }
        ret = this.decryptString(ret);
        return ret;
    }

    private String encryptString(String intext) {
        String ret = null;
        try {
            Properties p = new Properties();
            Crypto sssss = Crypto.getCrypto((String)this.cryType, (Properties)p);
            CipherInterface ci = sssss.openCipher();
            byte[] inbytes = intext.getBytes();
            ByteArrayOutputStream outstr = new ByteArrayOutputStream(ci.getCipherTextLength(inbytes.length));
            ci.encrypt(inbytes, 0, inbytes.length, (OutputStream)outstr);
            byte[] outbytes = outstr.toByteArray();
            ret = "";
            for (int i = 0; i < outbytes.length; ++i) {
                ret = ret + (char)outbytes[i];
            }
        }
        catch (Exception e) {
            System.err.println("Internal error:  is netutil.jar installed?\n" + e);
        }
        return ret;
    }

    private String decryptString(String intext) throws RemoteException {
        String ret = null;
        try {
            Properties p = new Properties();
            Crypto sssss = Crypto.getCrypto((String)this.cryType, (Properties)p);
            CipherInterface ci = sssss.openCipher();
            byte[] inbytes = new byte[intext.length()];
            for (int i = 0; i < intext.length(); ++i) {
                char c = intext.charAt(i);
                inbytes[i] = (byte)c;
            }
            ByteArrayInputStream instr = new ByteArrayInputStream(inbytes);
            byte[] result = new byte[ci.getMaxPlainTextLength(inbytes.length)];
            int returnLength = ci.decrypt((InputStream)instr, inbytes.length, result, 0);
            ret = new String(result, 0, returnLength);
        }
        catch (Exception e) {
            System.err.println("Internal error:  is netutil.jar installed?\n" + e);
            ret = null;
        }
        return ret;
    }

    @Override
    public byte[] convertHexStringToByteArray(String strValue) throws RemoteException {
        byte[] byteArray = new byte[strValue.length() / 2];
        int byteIndex = 0;
        int length = strValue.length();
        if (System.getProperty("os.arch").contains("390") || System.getProperty("com.sas.util.encryption913.encoding") != null) {
            for (int index = 0; index < length - 1; index += 2) {
                byteArray[byteIndex++] = (byte)Integer.parseInt(strValue.substring(index, index + 2), 16);
            }
            return byteArray;
        }
        byte[] charArray = strValue.getBytes();
        for (int index = 0; index < length; index += 2) {
            byteArray[byteIndex++] = this.convertHexCharsToByte(charArray[index], charArray[index + 1]);
        }
        return byteArray;
    }

    @Override
    @Deprecated
    public byte convertHexCharsToByte(byte leftChar, byte rightChar) throws RemoteException {
        int result = 0;
        boolean negative = false;
        int digit = leftChar >= 65 ? leftChar - 65 + 10 : leftChar - 48;
        result = -digit;
        digit = rightChar >= 65 ? rightChar - 65 + 10 : rightChar - 48;
        result *= 16;
        result -= digit;
        if (negative) {
            return (byte)result;
        }
        return (byte)(-result);
    }

    @Override
    public String convertByteArrayToHexString(byte[] byteArray) throws RemoteException {
        String returnValue = "";
        for (int index = 0; index < byteArray.length; ++index) {
            returnValue = returnValue + this.getByteAsHexChar(byteArray[index], 1);
            returnValue = returnValue + this.getByteAsHexChar(byteArray[index], 0);
        }
        return returnValue;
    }

    @Override
    public char getByteAsHexChar(int value, int index) throws RemoteException {
        byte b = (byte)(value >> index * 4 & 0xF);
        char c = Character.forDigit(b, 16);
        if (c >= 'a' && c <= 'f') {
            c = (char)(c - 32);
        }
        return c;
    }

    @Override
    public double getSASDateTimeLongForDate(Date inDate) throws RemoteException {
        long time = inDate.getTime();
        time -= (long)(this.getRawOffset() + this.getDSTOffset(time));
        double SASDate = SASDateTimeFormat.javaDateToSASDateTime((long)time);
        return SASDate;
    }

    @Override
    public double getSASDateLongForDate(Date inDate) throws RemoteException {
        long time = inDate.getTime();
        time -= (long)(this.getRawOffset() + this.getDSTOffset(time));
        double SASDate = SASDateTimeFormat.javaDateToSASDate((long)time);
        return SASDate;
    }

    @Override
    public double getSASTimeLongForDate(Date inDate) throws RemoteException {
        long time = inDate.getTime();
        double SASDate = SASDateTimeFormat.javaDateToSASTimeWithEpoch((long)(time -= (long)this.getRawOffset()));
        return SASDate;
    }

    @Override
    public String getFormattedDateStringForDoubleSASDateTimeString(String inDouble) throws RemoteException {
        return this.getFormattedDateStringForDoubleSASDateTimeString(inDouble, TimeZone.getTimeZone("GMT"));
    }

    @Override
    public String getFormattedDateStringForDoubleSASDateTimeString(String inDouble, TimeZone timezone) throws RemoteException {
        if (inDouble.length() <= 0) {
            return inDouble;
        }
        try {
            if (timezone == null) {
                timezone = TimeZone.getTimeZone("GMT");
            }
            Date returnDate = this.getDateForDoubleSASDateTimeString(inDouble);
            DateFormat format = DateFormat.getDateTimeInstance(2, 1, Locale.getDefault());
            format.setTimeZone(timezone);
            return format.format(returnDate);
        }
        catch (NumberFormatException exp) {
            exp.printStackTrace();
            return inDouble;
        }
    }

    @Override
    public String getFormattedDateStringForDoubleSASDateString(String inDouble) throws RemoteException {
        return this.getFormattedDateStringForDoubleSASDateString(inDouble, TimeZone.getTimeZone("GMT"));
    }

    @Override
    public String getFormattedDateStringForDoubleSASDateString(String inDouble, TimeZone timezone) throws RemoteException {
        if (inDouble.length() <= 0) {
            return inDouble;
        }
        try {
            if (timezone == null) {
                timezone = TimeZone.getTimeZone("GMT");
            }
            Date returnDate = this.getDateForDoubleSASDateString(inDouble);
            DateFormat format = DateFormat.getDateTimeInstance(2, 1, Locale.getDefault());
            format.setTimeZone(timezone);
            return format.format(returnDate);
        }
        catch (NumberFormatException exp) {
            exp.printStackTrace();
            return inDouble;
        }
    }

    @Override
    public String getFormattedDateStringForDoubleSASTimeString(String inDouble) throws RemoteException {
        return this.getFormattedDateStringForDoubleSASTimeString(inDouble, TimeZone.getTimeZone("GMT"));
    }

    @Override
    public String getFormattedDateStringForDoubleSASTimeString(String inDouble, TimeZone timezone) throws RemoteException {
        if (inDouble.length() <= 0) {
            return inDouble;
        }
        try {
            if (timezone == null) {
                timezone = TimeZone.getTimeZone("GMT");
            }
            double myDate = Double.parseDouble(inDouble);
            long javadate = SASDateTimeFormat.SASTimeWithEpochToJavaDate((double)myDate);
            Date returnDate = new Date(javadate += (long)this.getRawOffset());
            DateFormat format = DateFormat.getDateTimeInstance(2, 1, Locale.getDefault());
            format.setTimeZone(timezone);
            return format.format(returnDate);
        }
        catch (NumberFormatException exp) {
            exp.printStackTrace();
            return inDouble;
        }
    }

    @Override
    public Date getDateForDoubleSASDateTimeString(String inSASDateTimeDoubleString) throws NumberFormatException, RemoteException {
        double myDate = Double.parseDouble(inSASDateTimeDoubleString);
        long javadate = SASDateTimeFormat.SASDateTimeToJavaDate((double)myDate);
        javadate += (long)(this.getRawOffset() + this.getDSTOffset(javadate));
        Date returnDate = new Date(javadate);
        return returnDate;
    }

    @Override
    public Date getDateForDoubleSASDateString(String inSASDateDoubleString) throws NumberFormatException, RemoteException {
        double myDate = Double.parseDouble(inSASDateDoubleString);
        long javadate = SASDateTimeFormat.SASDateToJavaDate((double)myDate);
        javadate += (long)(this.getRawOffset() + this.getDSTOffset(javadate));
        Date returnDate = new Date(javadate);
        return returnDate;
    }

    @Override
    public String getDoubleStringForDouble(double inValue) throws NumberFormatException, RemoteException {
        DecimalFormat numberFormat = new DecimalFormat("#.##");
        return numberFormat.format(inValue);
    }

    private int getDSTOffset(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return cal.get(16);
    }

    private int getRawOffset() {
        return TimeZone.getDefault().getRawOffset();
    }

    @Override
    public void dumpEnvironment() throws RemoteException {
        this.dumpEnvironment(System.out);
    }

    @Override
    public void dumpEnvironment(PrintStream x) {
        Properties props = System.getProperties();
        Enumeration<?> propNames = props.propertyNames();
        int i = 0;
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = props.getProperty(propName);
            x.println(propName + "=" + propValue);
            if (++i != 5) continue;
            x.println("");
            i = 0;
        }
    }

    @Override
    public String createStringForNode(Node node) throws RemoteException {
        return this.createStringForNode(node, true);
    }

    public String createStringForNode(Node node, boolean omitXMLDeclarationInOutput) throws RemoteException {
        String string = null;
        if (node != null) {
            try {
                DOMSource domSource = new DOMSource(node);
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                if (omitXMLDeclarationInOutput) {
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                }
                transformer.transform(domSource, streamResult);
                string = stringWriter.toString();
            }
            catch (Exception e) {
                string = null;
            }
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public synchronized void println(String inString, PrintWriter printer, OutputStream outStream) throws RemoteException {
        if (inString == null) {
            return;
        }
        try {
            if (outStream == null) {
                System.out.println(inString);
                return;
            }
            if (printer == null) {
                printer = new PrintWriter(outStream, true);
            }
            printer.println(inString);
            printer.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void printOutputln(String inString) throws RemoteException {
        if (this.m_factory != null && this.m_factory.getDebug()) {
            this.println(inString, this.outputWriter, this.getOutputStream());
        }
    }

    @Override
    public void printPerfln(String inString) throws RemoteException {
        if (this.m_factory != null && this.m_factory.getPerf()) {
            this.println(XMLUtil.normalize(inString), this.perfWriter, this.getPerfStream());
        }
    }

    @Override
    public void printLogln(String inString) throws RemoteException {
        if (this.m_factory != null && this.m_factory.getLoggingEnabled()) {
            this.println(inString, this.logWriter, this.getLogStream());
        }
    }

    @Override
    public void printLoglnClient(Document doc) throws RemoteException {
        if (this.m_factory != null && this.m_factory.getLoggingEnabled()) {
            Document myDoc = doc;
            this.printLoglnClientDoc(myDoc);
        }
    }

    @Override
    public void printLoglnClient(String inString) throws RemoteException {
        if (this.m_factory != null && this.m_factory.getLoggingEnabled()) {
            String myString = inString;
            StringBuilder myBuf = new StringBuilder(myString == null ? 17 : myString.length() + 17);
            myBuf.append(CLIENT_BEGIN_TAG);
            myBuf.append(myString);
            myBuf.append(CLIENT_END_TAG);
            this.printLogln(XMLUtil.formatXML(myBuf.toString()));
        }
    }

    @Override
    public void printLoglnServer(String inString) throws RemoteException {
        if (this.m_factory != null && this.m_factory.getLoggingEnabled()) {
            String myString = inString;
            StringBuilder myBuf = new StringBuilder(myString == null ? 17 : myString.length() + 17);
            myBuf.append(SERVER_BEGIN_TAG);
            myBuf.append(myString);
            myBuf.append(SERVER_END_TAG);
            this.printLogln(XMLUtil.formatXML(myBuf.toString()));
        }
    }

    @Override
    public void printLoglnServer(Document doc) throws RemoteException {
        if (this.m_factory != null && this.m_factory.getLoggingEnabled()) {
            Document myDoc = doc;
            this.printLoglnServerDoc(myDoc);
        }
    }

    public void printLoglnClientDoc(Document doc) throws RemoteException {
        StringBuilder output = new StringBuilder();
        output.append(CLIENT_BEGIN_TAG);
        output.append(this.createStringForNode(doc));
        output.append(CLIENT_END_TAG);
        this.printLogln(XMLUtil.formatXML(output.toString()));
    }

    public void printLoglnServerDoc(Document doc) throws RemoteException {
        StringBuilder output = new StringBuilder();
        output.append(SERVER_BEGIN_TAG);
        output.append(this.createStringForNode(doc));
        output.append(SERVER_END_TAG);
        this.printLogln(XMLUtil.formatXML(output.toString()));
    }

    @Override
    public void printLogln(Document doc) throws RemoteException {
        String output = this.createStringForNode(doc);
        this.printLogln(XMLUtil.formatXML(output));
    }

    @Override
    public void setDefaultEncoding(String encoding) throws RemoteException {
        _defaultEncoding = encoding;
    }

    @Override
    public void setOutputStream(OutputStream output) throws RemoteException {
        this.setOutputStream(output, null);
    }

    @Override
    public void setOutputStream(OutputStream output, String encoding) throws RemoteException {
        this.outputStream = null;
        if (output != null) {
            this.outputStream = new BufferedOutputStream(output);
            try {
                this.outputWriter = encoding != null && encoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, encoding), true) : (_defaultEncoding != null && _defaultEncoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, _defaultEncoding), true) : new PrintWriter(this.outputStream, true));
            }
            catch (UnsupportedEncodingException e) {
                this.outputWriter = new PrintWriter(this.outputStream, true);
            }
        }
    }

    @Override
    public void setPerfStream(OutputStream output) throws RemoteException {
        this.setPerfStream(output, null);
    }

    @Override
    public void setPerfStream(OutputStream output, String encoding) {
        this.perfStream = null;
        if (output != null) {
            this.perfStream = new BufferedOutputStream(output);
            try {
                this.perfWriter = encoding != null && encoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(this.perfStream, encoding), true) : (_defaultEncoding != null && _defaultEncoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(this.perfStream, _defaultEncoding), true) : new PrintWriter(this.perfStream, true));
            }
            catch (UnsupportedEncodingException e) {
                this.perfWriter = new PrintWriter(this.perfStream, true);
            }
        }
    }

    @Override
    public void setLogStream(OutputStream output) throws RemoteException {
        this.setLogStream(output, null);
    }

    @Override
    public void setLogStream(OutputStream output, String encoding) throws RemoteException {
        this.logStream = null;
        if (output != null) {
            this.logStream = new BufferedOutputStream(output);
            try {
                this.logWriter = encoding != null && encoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(this.logStream, encoding), true) : (_defaultEncoding != null && _defaultEncoding.length() > 0 ? new PrintWriter((Writer)new OutputStreamWriter(this.logStream, _defaultEncoding), true) : new PrintWriter(this.logStream, true));
            }
            catch (UnsupportedEncodingException e) {
                this.logWriter = new PrintWriter(this.logStream, true);
            }
        }
    }

    @Override
    public OutputStream getOutputStream() throws RemoteException {
        return this.outputStream;
    }

    @Override
    public OutputStream getPerfStream() throws RemoteException {
        return this.perfStream;
    }

    @Override
    public OutputStream getLogStream() throws RemoteException {
        return this.logStream;
    }

    @Override
    public void printStackTrace() {
        try {
            throw new Throwable();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
    }

    @Override
    public void printStackTrace(Throwable e) {
        try {
            if (this.m_factory != null && this.m_factory.getDebug()) {
                if (this.outputWriter == null || this.getOutputStream() == null) {
                    OutputStream output = this.getOutputStream();
                    if (output == null) {
                        e.printStackTrace();
                        return;
                    }
                    if (this.outputWriter == null) {
                        this.outputWriter = new PrintWriter(output);
                        e.printStackTrace(this.outputWriter);
                        return;
                    }
                }
                e.printStackTrace(this.outputWriter);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void printMdObjectStore(MdObjectStore instore) throws RemoteException {
        if (instore != null && instore.getDetailObjectMap() != null) {
            StringBuilder outString = new StringBuilder();
            outString.append("<MdObjectStore Address=\"");
            outString.append(instore);
            outString.append("\">");
            outString.append(instore.createXMLforStore());
            outString.append("</MdObjectStore>");
            this.printOutputln(XMLUtil.formatXML(outString.toString()));
        }
    }

    @Override
    public Constructor findValidConstructor(Class cls, Class[] aParms) throws RemoteException, NoSuchMethodException {
        try {
            return cls.getConstructor(aParms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Constructor<?>[] aConstructors = cls.getConstructors();
        int nConstructors = aConstructors.length;
        int nParms = aParms.length;
        block3: for (int iConstructor = 0; iConstructor < nConstructors; ++iConstructor) {
            Class<?>[] aFormalParms = aConstructors[iConstructor].getParameterTypes();
            if (aFormalParms.length != nParms) continue;
            boolean bMatch = true;
            for (int iParm = 0; iParm < nParms; ++iParm) {
                if (!aFormalParms[iParm].isAssignableFrom(aParms[iParm])) {
                    bMatch = false;
                    continue block3;
                }
                if (!bMatch) continue;
                return aConstructors[iConstructor];
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public Method findValidMethods(Class cls, String sMethod, Class[] aParms) throws RemoteException, NoSuchMethodException {
        try {
            return cls.getMethod(sMethod, aParms);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Method[] aMethods = cls.getMethods();
        int nMethods = aMethods.length;
        int nParms = aParms.length;
        block3: for (int iMethod = 0; iMethod < nMethods; ++iMethod) {
            Class<?>[] aFormalParms = aMethods[iMethod].getParameterTypes();
            if (!aMethods[iMethod].getName().equals(sMethod) || aFormalParms.length != nParms) continue;
            boolean bMatch = true;
            for (int iParm = 0; iParm < nParms; ++iParm) {
                if (!aFormalParms[iParm].isAssignableFrom(aParms[iParm])) {
                    bMatch = false;
                    continue block3;
                }
                if (!bMatch) continue;
                return aMethods[iMethod];
            }
        }
        throw new NoSuchMethodException();
    }

    static {
        _useOldEncryption = false;
    }
}

