/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MapPool;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdObjectStoreImpl;
import com.sas.metadata.remote.MdServerStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreIDChangeListener;
import com.sas.metadata.remote.MdStoreListener;
import java.beans.VetoableChangeListener;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.EventListenerList;

@SASScope
public class MdServerStoreImpl
implements MdServerStore {
    static final long serialVersionUID = 5311145227666408757L;
    protected Map<String, CMetadata> simpleObjectMap;
    protected EventListenerList MdStoreListenerList = new EventListenerList();
    protected EventListenerList MdObjectListenerList = new EventListenerList();
    protected EventListenerList MdStoreIDChangeListenerList = new EventListenerList();
    private MdServerStoreImpl m_MdServerStoreInstance = null;
    protected MdFactory m_factory = null;
    protected boolean goToServerForMetadata = true;
    protected List<MdStore> childStores = Collections.synchronizedList(new ArrayList(5));
    private InternalObjectStore _objectStore;

    public MdServerStoreImpl(MdFactory owningFactory) throws RemoteException {
        this(owningFactory, null);
    }

    protected MdServerStoreImpl(MdFactory owningFactory, String nullParameter) throws RemoteException {
        this.m_MdServerStoreInstance = this;
        this.m_factory = owningFactory;
        this._objectStore = new InternalObjectStore(this.m_MdServerStoreInstance, this.m_factory);
        if (this.m_factory.isRemoteEnvironment()) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    @Override
    public MdFactory getFactory() throws RemoteException {
        return this.m_factory;
    }

    @Override
    public void setOwningStore(MdStore parent) throws RemoteException {
    }

    @Override
    public int getStoreType() throws RemoteException {
        return 0;
    }

    @Override
    public void updatedMetadataAll() throws MdException, RemoteException {
        throw new MdException("Unsupported: updatedMetadataAll() on MdServerStore");
    }

    @Override
    public boolean getIsGoToServerForMetadata() throws RemoteException {
        return this.goToServerForMetadata;
    }

    @Override
    public void setIsGotToServerForMetadata(boolean goToServer) throws RemoteException {
        this.goToServerForMetadata = goToServer;
    }

    @Override
    public void setGoToServerForMetadata(boolean goToServer) {
        this.goToServerForMetadata = goToServer;
    }

    @Override
    public boolean isGoToServerForMetadata() {
        return this.goToServerForMetadata;
    }

    @Override
    public boolean isDisposed() throws RemoteException {
        return this._objectStore.getDetailObjectMap() == null && this.m_factory == null;
    }

    @Override
    public MdStore getOwningStore() throws RemoteException {
        return null;
    }

    @Override
    public Map<String, CMetadata> getDetailObjectMap() throws RemoteException {
        return this._objectStore.getDetailObjectMap();
    }

    @Override
    public Map<String, CMetadata> getSimpleObjectMap() throws RemoteException {
        if (this.simpleObjectMap == null) {
            this.simpleObjectMap = new HashMap<String, CMetadata>(100);
            this.simpleObjectMap = Collections.synchronizedMap(this.simpleObjectMap);
        }
        return this.simpleObjectMap;
    }

    @Override
    public boolean deleteObject(CMetadata inObject) throws RemoteException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjectFromStores(String strFQID) throws RemoteException {
        CMetadata object = this._objectStore.getObjectFromMap(strFQID);
        if (object != null) {
            Map<String, AssociationList> assns = object.getPopulatedAssocs();
            for (String assnName : assns.keySet()) {
                AssociationList assn = assns.get(assnName);
                if (assn == null) continue;
                assn.removeAllElements();
            }
            MapPool.returnMap(assns);
            assns = null;
            this._objectStore.removeObjectFromMap(strFQID);
            object = null;
        }
        List<MdStore> list = this.childStores;
        synchronized (list) {
            for (MdStore cStore : this.childStores) {
                if (cStore.getStoreType() != 1) continue;
                ((MdObjectStore)cStore).deleteObjectFromStore(strFQID);
            }
        }
    }

    @Override
    public String makeID(String shortID) throws RemoteException {
        return this.m_factory.makeID(shortID);
    }

    @Override
    public CMetadata restoreObject(String objectID) throws RemoteException {
        return null;
    }

    @Override
    public void deleteComplexMetadataObject(CMetadata oDelete) throws RemoteException {
    }

    @Override
    public void resetStates(List items) throws RemoteException {
    }

    @Override
    public void deleteDetailMetadataObject(String strFQID) throws RemoteException {
        CMetadata delobject = this._objectStore.getObjectFromMap(strFQID);
        if (delobject != null) {
            ArrayList<String> items = new ArrayList<String>(1);
            items.add(strFQID);
            this.fireMdObjectsRemoved(new MdEvent(delobject, this), items);
        }
        this._objectStore.removeObjectFromMap(strFQID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpDetailHashMap() throws RemoteException {
        if (this.m_factory.getDebug()) {
            Map<String, CMetadata> objectMap;
            Map<String, CMetadata> map = objectMap = this._objectStore.getDetailObjectMap();
            synchronized (map) {
                Vector<CMetadata> values = new Vector<CMetadata>(objectMap.values());
                if (values.size() == 0) {
                    this.m_factory.getUtil().printOutputln("DEBUG GOOD NEWS:  Server Store Map is empty");
                    return;
                }
                this.m_factory.getUtil().printOutputln("DEBUG BAD NEWS:  Server Store Map is not empty!");
                for (int i = 0; i < values.size(); ++i) {
                    this.m_factory.getUtil().printOutputln("  Object type=" + values.elementAt(i).getCMetadataType() + " id=" + values.elementAt(i).getFQID());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpDetailAllHashMaps() throws RemoteException {
        if (this.m_factory.getDebug()) {
            this.dumpDetailHashMap();
            List<MdStore> list = this.childStores;
            synchronized (list) {
                for (MdStore cStore : this.childStores) {
                    cStore.dumpDetailHashMap();
                }
            }
        }
    }

    @Override
    public CMetadata getObject(String strFQID, boolean hashonly) throws RemoteException {
        CMetadata meta = this._objectStore.getObjectFromMap(strFQID);
        if (meta == null) {
            meta = this.getObjectInChildStore(strFQID);
        }
        return meta;
    }

    @Override
    public CMetadata getObject(String strFQID) throws RemoteException {
        return this.getObject(strFQID, true);
    }

    @Override
    public boolean isObjectInServerStore(String objectID) throws RemoteException {
        CMetadata meta = this._objectStore.getObjectFromMap(objectID);
        return meta != null;
    }

    protected CMetadata getObjectFromServerStoreOnly(String objectID) throws RemoteException {
        return this._objectStore.getObjectFromMap(objectID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeHashKey(String strOldId, String strNewId) throws RemoteException {
        CMetadata object = this._objectStore.getObjectFromMap(strOldId);
        ArrayList<String> itemsOld = null;
        ArrayList<String> itemsNew = null;
        if (object != null) {
            itemsOld = new ArrayList<String>(1);
            itemsNew = new ArrayList<String>(1);
            this._objectStore.removeObjectFromMap(strOldId);
            itemsOld.add(strOldId);
            this.fireMdObjectsRemoved(new MdEvent(this, this), itemsOld);
            itemsNew.add(strNewId);
            this._objectStore.addObjectToMap(strNewId, (Object)object);
            this.fireMdObjectsAdded(new MdEvent(this, this), itemsNew);
            if (object.getFQID().equalsIgnoreCase(strOldId)) {
                object.setFQID(strNewId);
            }
            object.updateAssnsIds(strOldId, strNewId);
        }
        List<MdStore> list = this.childStores;
        synchronized (list) {
            for (MdStore cStore : this.childStores) {
                cStore.changeHashKey(strOldId, strNewId);
            }
        }
        if (object != null && itemsOld != null) {
            this.fireMdStoreIDChange(new MdEvent(this, this), itemsOld, itemsNew);
        }
    }

    @Override
    public void createExternalIdentityObject(CMetadata owningObject) throws RemoteException {
    }

    @Override
    public void flushUpdates(List<CMetadata> updatedItems) throws RemoteException {
        this.flushUpdates(this, updatedItems);
    }

    protected void flushUpdates(MdStore owningStore, List<CMetadata> updatedItems) throws RemoteException {
        int nItems = updatedItems.size();
        ArrayList<String> idList = new ArrayList<String>(nItems);
        LinkedHashMap<String, String> objectMap = new LinkedHashMap<String, String>(nItems);
        for (int iItem = 0; iItem < nItems; ++iItem) {
            CMetadata meta = updatedItems.get(iItem);
            String id = meta.getFQID();
            idList.add(meta.getFQID());
            objectMap.put(id, meta.getCMetadataType());
        }
        this.fireMdObjectsModified(new MdEvent(this, owningStore), idList);
        MdFactoryEvent event = new MdFactoryEvent(this.m_factory, objectMap);
        this.m_factory.fireMdObjectsModified(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() throws RemoteException {
        Map<String, CMetadata> objectMap;
        Map<String, CMetadata> map = objectMap = this._objectStore.getDetailObjectMap();
        synchronized (map) {
            Object[] objects = objectMap.keySet().toArray();
            for (int i = 0; i < objects.length; ++i) {
                String id = (String)objects[i];
                if (this.isChildUsingObject(id)) continue;
                this.deleteDetailMetadataObject(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disposeAllStoresAndExit() throws RemoteException {
        if (this.isDisposed()) {
            this.m_factory.getUtil().printOutputln("DEBUG NOTE: MdServerStore already disposed...");
            return;
        }
        Object object = this.childStores;
        synchronized (object) {
            for (int i = this.childStores.size(); i > 0; --i) {
                MdStore cStore = this.childStores.get(i - 1);
                if (cStore == null) continue;
                cStore.dispose();
            }
        }
        this._objectStore.dispose();
        this.MdObjectListenerList = null;
        this.MdStoreIDChangeListenerList = null;
        this.m_MdServerStoreInstance = null;
        if (this.simpleObjectMap != null) {
            object = this.simpleObjectMap;
            synchronized (object) {
                Object[] simples = this.simpleObjectMap.keySet().toArray();
                for (int j = 0; j < simples.length; ++j) {
                    CMetadata simpleObject = this.simpleObjectMap.get(simples[j]);
                    if (simpleObject != null) {
                        simpleObject.dispose();
                    }
                    simpleObject = null;
                }
                Object var2_4 = null;
            }
        }
        if (this.m_factory.isRemoteEnvironment()) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        this.m_factory = null;
    }

    @Override
    public void removeStore(MdStore childStore) throws RemoteException {
        this.removeChildStore(childStore);
        if (childStore.getStoreType() == 1) {
            Map<String, CMetadata> objectMap = ((MdObjectStore)childStore).getDetailObjectMap();
            if (objectMap != null) {
                Object[] detailObjects = objectMap.keySet().toArray();
                for (int i = 0; i < detailObjects.length; ++i) {
                    String id = (String)detailObjects[i];
                    if (!this.isChildUsingObject(id)) {
                        this.deleteDetailMetadataObject(id);
                    }
                    ((MdObjectStore)childStore).deleteDetailMetadataObject(id);
                }
            }
            childStore = null;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChildUsingObject(String objectID) throws RemoteException {
        List<MdStore> list = this.childStores;
        synchronized (list) {
            for (MdStore cStore : this.childStores) {
                CMetadata metaObject;
                if (cStore.getStoreType() != 1 || (metaObject = ((MdObjectStore)cStore).getObject(objectID, true)) == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMetadata getObjectInChildStore(String objectID) throws RemoteException {
        List<MdStore> list = this.childStores;
        synchronized (list) {
            for (MdStore child : this.childStores) {
                CMetadata metaObject;
                if (child.getStoreType() != 1 || (metaObject = ((MdObjectStore)child).getObject(objectID, true)) == null) continue;
                return metaObject;
            }
        }
        return null;
    }

    @Override
    public List<CMetadata> getChangedObjects() throws RemoteException {
        return Collections.emptyList();
    }

    @Override
    public void MdObjectModified(MdEvent e) throws RemoteException {
    }

    @Override
    public void MdObjectsAdded(MdEvent e, List items) throws RemoteException {
    }

    @Override
    public void MdObjectsRemoved(MdEvent e, List items) throws RemoteException {
    }

    @Override
    public void MdObjectsModified(MdEvent e, List items) throws RemoteException {
    }

    @Override
    public void addMdObjectListener(MdObjectListener l) throws RemoteException {
        this.MdObjectListenerList.add(MdObjectListener.class, l);
    }

    @Override
    public void removeMdObjectListener(MdObjectListener l) throws RemoteException {
        this.MdObjectListenerList.remove(MdObjectListener.class, l);
    }

    @Override
    public void addMdStoreIDChangeListener(MdStoreIDChangeListener l) throws RemoteException {
        this.MdStoreIDChangeListenerList.add(MdStoreIDChangeListener.class, l);
        this.MdStoreListenerList.add(MdStoreListener.class, l);
    }

    @Override
    public void removeMdStoreIDChangeListener(MdStoreIDChangeListener l) throws RemoteException {
        this.MdStoreIDChangeListenerList.remove(MdStoreIDChangeListener.class, l);
        this.MdStoreListenerList.remove(MdStoreListener.class, l);
    }

    @Override
    public void addMdStoreListener(MdStoreListener l) throws RemoteException {
        this.MdStoreListenerList.add(MdStoreListener.class, l);
    }

    @Override
    public void removeMdStoreListener(MdStoreListener l) throws RemoteException {
        this.MdStoreListenerList.remove(MdStoreListener.class, l);
    }

    @Override
    public void fireMdObjectModified(MdEvent e) throws RemoteException {
        Object[] listeners = this.MdObjectListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdObjectListener.class) continue;
            ((MdObjectListener)listeners[i + 1]).MdObjectModified(e);
        }
    }

    @Override
    public void fireMdObjectsModified(MdEvent e, List items) throws RemoteException {
        Object[] listeners = this.MdStoreListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdStoreListener.class) continue;
            ((MdStoreListener)listeners[i + 1]).MdObjectsModified(e, items);
        }
    }

    @Override
    public void fireMdStoreIDChange(MdEvent e, List idsOld, List idsNew) throws RemoteException {
        Object[] listeners = this.MdStoreIDChangeListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdStoreIDChangeListener.class) continue;
            ((MdStoreIDChangeListener)listeners[i + 1]).MdStoreIDChange(e, idsOld, idsNew);
        }
    }

    @Override
    public void fireMdObjectsAdded(MdEvent e, List ids) throws RemoteException {
        Object[] listeners = this.MdStoreListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdStoreListener.class) continue;
            ((MdStoreListener)listeners[i + 1]).MdObjectsAdded(e, ids);
        }
    }

    @Override
    public void fireMdObjectsRemoved(MdEvent e, List ids) throws RemoteException {
        Object[] listeners = this.MdStoreListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdStoreListener.class) continue;
            ((MdStoreListener)listeners[i + 1]).MdObjectsRemoved(e, ids);
        }
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener l) throws RemoteException {
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener l) throws RemoteException {
    }

    @Override
    public void updateChangeListObjectIDs(String OldReposID, String NewReposID) throws RemoteException {
    }

    @Override
    public void updateChangeListObjectIDs(String OldReposID, String NewReposID, String targetReposID) throws RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearObjectsFromStore() throws RemoteException {
        ArrayList<String> objects = new ArrayList<String>();
        Map<String, CMetadata> objectMap = this._objectStore.getDetailObjectMap();
        Map<String, CMetadata> map = objectMap;
        synchronized (map) {
            Iterator<String> keyI = objectMap.keySet().iterator();
            while (keyI.hasNext()) {
                objects.add(keyI.next());
            }
        }
        for (String id : objects) {
            if (id == null) continue;
            this.deleteDetailMetadataObject(id);
        }
    }

    @Override
    public List<CMetadata> getCreatedItemsList() throws RemoteException {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCreatedItemsList(List<String> items) throws RemoteException {
        List<MdStore> list = this.childStores;
        synchronized (list) {
            for (MdStore cStore : this.childStores) {
                cStore.updateCreatedItemsList(items);
            }
        }
    }

    @Override
    public void addChildStore(MdStore inStore) throws RemoteException {
        if (!this.childStores.contains(inStore)) {
            this.childStores.add(inStore);
        }
    }

    @Override
    public void removeChildStore(MdStore inStore) throws RemoteException {
        if (this.childStores.contains(inStore)) {
            this.childStores.remove(inStore);
        }
    }

    @Override
    public String createRefreshXMLforStore(boolean includeLocallyChangedItems, boolean getFullObjectUpdate) throws RemoteException {
        return null;
    }

    private class InternalObjectStore
    extends MdObjectStoreImpl {
        public InternalObjectStore(MdServerStore serverStore, MdFactory factory) throws RemoteException {
            super(serverStore, factory, "ServerStore");
            serverStore.removeChildStore(this);
            serverStore.removeMdStoreListener(this);
        }

        public CMetadata getObjectFromMap(String objectID) throws RemoteException {
            return (CMetadata)this.ObjectMap.get(objectID);
        }

        public void addObjectToMap(String id, Object meta) throws RemoteException {
            if (MdServerStoreImpl.this.m_factory.getDebug()) {
                this.m_Util.printOutputln("Adding object to server store map: " + meta + " (" + id + ")");
            }
            if (meta instanceof CMetadata) {
                this.ObjectMap.put(id, (CMetadata)meta);
            }
        }

        public void removeObjectFromMap(String id) throws RemoteException {
            this.ObjectMap.remove(id);
        }

        @Override
        public void addChildStore(MdStore inStore) {
            throw new UnsupportedOperationException("Cannot create child stores");
        }

        @Override
        public void updatedMetadataAll() throws MdException, RemoteException {
            throw new MdException(MdServerStoreImpl.this.m_factory.getBundle().getString("MdServerStore.NoUpdatedMetadataAll.txt"));
        }
    }
}

