/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MapPool;
import com.sas.metadata.remote.MdAuthorizationUtilImpl;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectListImpl;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdServerStore;
import com.sas.metadata.remote.MdServerStoreImpl;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreIDChangeListener;
import com.sas.metadata.remote.MdStoreListener;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.MdUtil;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.XMLUtil;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SASScope
public class MdObjectStoreImpl
implements MdObjectStore {
    private volatile boolean _write_lock = false;
    protected Map<String, CMetadata> ObjectMap;
    protected Map<String, CMetadata> deletedObjects;
    protected Set<CMetadata> changeList;
    protected Vector<CMetadata> authorizationTransContextList;
    protected Set<String> createdItemsSet;
    private MdFactory m_factory = null;
    protected EventListenerList MdStoreListenerList = new EventListenerList();
    protected EventListenerList MdObjectListenerList;
    protected EventListenerList MdStoreIDChangeListenerList;
    private MdStore OwningStore;
    private VetoableChangeSupport vetos;
    protected String projectReposID;
    protected String newObjectReposID;
    protected MdUtil m_Util = null;
    protected boolean goToServerForMetadata = true;
    protected boolean IsObjectCopiedFromParentOnCreation = true;
    protected StringBuffer writeBuffer;
    protected List<MdStore> childStores;
    protected String storeName = null;
    private boolean _refreshingObjects = false;
    private boolean _deepCopyObjects = true;
    protected String _identifier;

    public MdObjectStoreImpl(MdStore owningStore, MdFactory OwningFactory) throws RemoteException {
        this(owningStore, OwningFactory, null);
    }

    public MdObjectStoreImpl(MdStore owningStore, MdFactory OwningFactory, String NameOfStore) throws RemoteException {
        this(owningStore, OwningFactory, NameOfStore, new Random().nextInt());
    }

    public MdObjectStoreImpl(MdStore owningStore, MdFactory OwningFactory, String NameOfStore, int storeCounter) throws RemoteException {
        this();
        this.OwningStore = owningStore;
        owningStore.addMdStoreListener(this);
        owningStore.addChildStore(this);
        this.m_factory = OwningFactory;
        if (NameOfStore != null && NameOfStore.length() > 0) {
            this.storeName = NameOfStore;
        }
        this._identifier = "Store_" + storeCounter;
        this.m_Util = this.m_factory.getUtil();
        if (this.m_factory.getDebug()) {
            this.m_Util.printOutputln("DEBUG NOTE: Creating MdObjectStore..." + this.toString());
        }
        if (this.m_factory.isRemoteEnvironment()) {
            UnicastRemoteObject.exportObject(this);
        }
    }

    private MdObjectStoreImpl() throws RemoteException {
        this.ObjectMap = Collections.synchronizedMap(new LinkedHashMap(100));
    }

    @Override
    public MdFactory getFactory() throws RemoteException {
        return this.m_factory;
    }

    @Override
    public boolean getIsObjectCopiedFromParentOnCreation() throws RemoteException {
        return this.IsObjectCopiedFromParentOnCreation;
    }

    @Override
    public void setIsObjectCopiedFromParentOnCreation(boolean inValue) throws RemoteException {
        this.IsObjectCopiedFromParentOnCreation = inValue;
    }

    @Override
    public int getStoreType() throws RemoteException {
        return 1;
    }

    @Override
    public String getStoreName() throws RemoteException {
        return this.storeName;
    }

    @Override
    public String getIdentifier() throws RemoteException {
        return this._identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatedMetadataAll() throws MdException, RemoteException {
        block9: {
            block8: {
                CMetadata firstObject;
                if (this.changeList != null && this.changeList.size() > 0) {
                    Set<CMetadata> set = this.changeList;
                    synchronized (set) {
                        CMetadata firstObject2 = this.changeList.iterator().next();
                        if (firstObject2 != null) {
                            firstObject2.updateMetadataAll();
                        }
                    }
                }
                if (this.deletedObjects == null || this.deletedObjects.size() <= 0) break block8;
                Object[] keys = this.deletedObjects.keySet().toArray();
                if (keys.length <= 0) break block9;
                String firstKey = null;
                for (int i = 0; i < keys.length && firstKey == null; ++i) {
                    firstKey = (String)keys[i];
                }
                if (firstKey == null || (firstObject = this.deletedObjects.get(firstKey)) == null) break block9;
                firstObject.updateMetadataAll();
                break block9;
            }
            Vector<CMetadata> AuthorizationTransContextList = this.getAuthorizationTransContextList();
            if (AuthorizationTransContextList != null) {
                CMetadata[] objsWithAuthTransCtxt;
                for (CMetadata obj : objsWithAuthTransCtxt = AuthorizationTransContextList.toArray(new CMetadata[AuthorizationTransContextList.size()])) {
                    if (!obj.getAuthorizationUtil().getCommitOnUpdate()) continue;
                    ((MdAuthorizationUtilImpl)obj.getAuthorizationUtil()).commit();
                    this.removeObjFromAuthorizationTransContextList(obj);
                }
            }
        }
    }

    @Override
    public String getProjectRepositoryID() throws RemoteException {
        return this.projectReposID == null ? "" : this.projectReposID;
    }

    @Override
    public void setProjectRepositoryID(String projReposID) throws RemoteException {
        this.projectReposID = new String(projReposID);
    }

    @Override
    public String getNewObjectRepositoryID() throws RemoteException {
        return this.newObjectReposID == null ? "" : this.newObjectReposID;
    }

    @Override
    public void setNewObjectRepositoryID(String newObjReposID) throws RemoteException {
        this.newObjectReposID = new String(newObjReposID);
    }

    @Override
    public void setOwningStore(MdStore parent) throws RemoteException {
        this.OwningStore = parent;
    }

    @Override
    public MdStore getOwningStore() throws RemoteException {
        return this.OwningStore;
    }

    @Override
    public Map<String, CMetadata> getDeletedObjects() throws RemoteException {
        this.initializeDeletedObjects();
        return this.deletedObjects;
    }

    @Override
    public boolean isDeletedObject(String id) throws RemoteException {
        return this.deletedObjects == null ? false : this.deletedObjects.containsKey(id);
    }

    @Override
    public boolean isDeepCopyObjects() throws RemoteException {
        return this._deepCopyObjects;
    }

    @Override
    public void setDeepCopyObjects(boolean copy) throws RemoteException {
        this._deepCopyObjects = copy;
    }

    @Override
    public boolean getIsGoToServerForMetadata() throws RemoteException {
        return this.isGoToServerForMetadata();
    }

    @Override
    public void setIsGotToServerForMetadata(boolean goToServer) throws RemoteException {
        this.setGoToServerForMetadata(goToServer);
    }

    @Override
    public void setGoToServerForMetadata(boolean goToServer) throws RemoteException {
        this.goToServerForMetadata = goToServer;
    }

    @Override
    public boolean isGoToServerForMetadata() throws RemoteException {
        return this.goToServerForMetadata;
    }

    protected boolean isRefreshingObjects() throws RemoteException {
        return this._refreshingObjects;
    }

    @Override
    public boolean isDisposed() throws RemoteException {
        return this.ObjectMap == null && this.m_factory == null;
    }

    @Override
    public Map<String, CMetadata> getSimpleObjectMap() throws RemoteException {
        return this.m_factory.getSimpleObjectMap();
    }

    @Override
    public Map<String, CMetadata> getDetailObjectMap() throws RemoteException {
        return this.ObjectMap;
    }

    @Override
    public void addObjectToMap(String objectID, CMetadata meta) throws RemoteException {
        this.ObjectMap.put(objectID, meta);
    }

    @Override
    public void deleteComplexMetadataObject(CMetadata oDelete) throws RemoteException {
    }

    @Override
    public void createExternalIdentityObject(CMetadata owningObject) throws RemoteException {
        ((Root)owningObject).setChangeState("");
    }

    @Override
    public void deleteDetailMetadataObject(String strFQID) throws RemoteException {
        CMetadata delobject = this.ObjectMap.get(strFQID);
        if (delobject != null) {
            ArrayList<String> items = new ArrayList<String>(1);
            items.add(strFQID);
            this.fireMdObjectsRemoved(new MdEvent(delobject, this), items);
            delobject.dispose();
        }
        this.ObjectMap.remove(strFQID);
        delobject = null;
    }

    @Override
    public String makeID(String shortID) throws RemoteException {
        String returnString = this.m_factory.makeID(shortID);
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpDetailHashMap() throws RemoteException {
        if (this.isDisposed()) {
            return;
        }
        Map<String, CMetadata> map = this.ObjectMap;
        synchronized (map) {
            Collection<CMetadata> values = this.ObjectMap.values();
            if (values.size() == 0) {
                this.m_factory.getUtil().printOutputln("    DEBUG GOOD NEWS:  Object Store is empty, object=" + this.toString());
                return;
            }
            this.m_factory.getUtil().printOutputln("    DEBUG BAD NEWS:  Object Store is not empty! object=" + this.toString());
            for (CMetadata object : values) {
                this.m_factory.getUtil().printOutputln("      Object type=" + object.getCMetadataType() + " id=" + object.getId());
            }
            if (this.hasChildStores()) {
                List<MdStore> list = this.childStores;
                synchronized (list) {
                    for (MdStore cStore : this.childStores) {
                        cStore.dumpDetailHashMap();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() throws RemoteException {
        Object[] listeners;
        int i;
        Map<String, CMetadata> map;
        if (this.isDisposed()) {
            return;
        }
        this.m_Util.printOutputln("DEBUG NOTE: Destroying MdObjectStore..." + this.toString());
        if (this.hasChildStores()) {
            map = this.childStores;
            synchronized (map) {
                for (i = this.childStores.size(); i > 0; --i) {
                    MdStore cStore = this.childStores.get(i - 1);
                    cStore.dispose();
                }
            }
            this.childStores = null;
        }
        if (this.authorizationTransContextList != null) {
            try {
                for (CMetadata obj : this.authorizationTransContextList) {
                    ((MdAuthorizationUtilImpl)obj.getAuthorizationUtil()).discard();
                }
            }
            catch (Exception e) {
                throw new RemoteException(e.getMessage());
            }
            finally {
                this.clearAuthorizationTransContextList();
                this.authorizationTransContextList = null;
            }
        }
        if (this.deletedObjects != null) {
            this.deletedObjects.clear();
            this.deletedObjects = null;
        }
        if (this.MdObjectListenerList != null) {
            listeners = this.MdObjectListenerList.getListenerList();
            for (i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdObjectListener.class) continue;
                this.removeMdObjectListener((MdObjectListener)listeners[i + 1]);
            }
            this.MdObjectListenerList = null;
        }
        if (this.MdStoreListenerList != null) {
            listeners = this.MdStoreListenerList.getListenerList();
            for (i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdStoreListener.class) continue;
                this.removeMdStoreListener((MdStoreListener)listeners[i + 1]);
            }
            this.MdStoreListenerList = null;
        }
        if (this.MdStoreIDChangeListenerList != null) {
            listeners = this.MdStoreIDChangeListenerList.getListenerList();
            for (i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdStoreIDChangeListener.class) continue;
                this.removeMdStoreIDChangeListener((MdStoreIDChangeListener)listeners[i + 1]);
            }
            this.MdStoreIDChangeListenerList = null;
        }
        if (this.vetos != null) {
            VetoableChangeListener[] vetoLs = this.vetos.getVetoableChangeListeners();
            for (i = vetoLs.length; i > 0; --i) {
                this.vetos.removeVetoableChangeListener(vetoLs[i - 1]);
            }
            this.vetos = null;
        }
        if (this.OwningStore != null && !this.OwningStore.isDisposed()) {
            if (this.OwningStore.getStoreType() == 0) {
                ((MdServerStore)this.OwningStore).removeMdStoreListener(this);
                ((MdServerStore)this.OwningStore).removeStore(this);
            } else if (this.OwningStore.getStoreType() == 1) {
                ((MdObjectStoreImpl)this.OwningStore).removeMdStoreListener(this);
                ((MdObjectStoreImpl)this.OwningStore).removeStore(this);
            }
        }
        if (this.changeList != null && this.changeList.size() > 0) {
            this.changeList.clear();
            this.changeList = null;
        }
        if (this.createdItemsSet != null && this.createdItemsSet.size() > 0) {
            this.createdItemsSet.clear();
            this.createdItemsSet = null;
        }
        if (this.ObjectMap != null) {
            map = this.ObjectMap;
            synchronized (map) {
                for (String key : this.ObjectMap.keySet()) {
                    CMetadata object = this.ObjectMap.get(key);
                    if (object == null) continue;
                    object.dispose();
                }
            }
            this.ObjectMap = null;
        }
        this.OwningStore = null;
        this.newObjectReposID = null;
        this.projectReposID = null;
        if (this.m_factory.isRemoteEnvironment()) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
        this.m_factory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushUpdates(List<CMetadata> updatedItems) throws RemoteException {
        Map<String, CMetadata> map = this.ObjectMap;
        synchronized (map) {
            for (String objectId : this.ObjectMap.keySet()) {
                CMetadata updatedObject = this.getObject(objectId, true);
                if (updatedObject == null || this.OwningStore.getStoreType() == 0 && !this.m_factory.getStore().isObjectInServerStore(objectId)) continue;
                updatedObject.resetObject();
                MdStoreUtil.refreshMetaObject((MdStore)this, this.getOwningStore(), objectId);
            }
        }
        if (this.createdItemsSet != null && this.OwningStore.getStoreType() == 0) {
            LinkedHashMap<String, String> objectMap = new LinkedHashMap<String, String>(10);
            HashSet<String> createdObjects = new HashSet<String>(10);
            for (String objectID : this.createdItemsSet) {
                if (objectID.indexOf(36) > -1 || createdObjects.contains(objectID)) continue;
                createdObjects.add(objectID);
                CMetadata updatedObject = this.getObject(objectID, true);
                if (updatedObject == null) continue;
                objectMap.put(objectID, updatedObject.getCMetadataType());
            }
            if (createdObjects.size() > 0) {
                if (objectMap.size() > 0) {
                    this.m_factory.fireMdObjectsCreated(new MdFactoryEvent(this.m_factory, objectMap));
                }
                this.m_factory.fireMdObjectsCreated(new MdEvent(this, this), new ArrayList<String>(createdObjects));
            }
        }
        if (this.hasChildStores()) {
            MdEvent ce = new MdEvent(this, this);
            ArrayList<String> idList = new ArrayList<String>(this.ObjectMap.keySet());
            List<MdStore> list = this.childStores;
            synchronized (list) {
                for (MdStore cStore : this.childStores) {
                    cStore.fireMdObjectsModified(ce, idList);
                }
            }
            idList = null;
            map = null;
        }
        this.OwningStore.removeMdStoreListener(this);
        if (this.OwningStore.getStoreType() == 0) {
            ((MdServerStoreImpl)this.OwningStore).flushUpdates(this, updatedItems);
        } else {
            this.OwningStore.flushUpdates(updatedItems);
        }
        this.OwningStore.addMdStoreListener(this);
        if (this.createdItemsSet != null) {
            this.createdItemsSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushUpdatesToParentStore() throws RemoteException {
        this.getOwningStore().removeMdStoreListener(this);
        ArrayList<String> UpdatedIDs = new ArrayList<String>(10);
        Iterator<String> iterator = this.ObjectMap;
        synchronized (iterator) {
            for (String id : this.ObjectMap.keySet()) {
                CMetadata updatedObject = this.getObject(id, true);
                if (updatedObject == null) continue;
                MdStoreUtil.refreshMetaObject((MdStore)this, this.getOwningStore(), id);
                UpdatedIDs.add(id);
            }
        }
        if (this.changeList != null) {
            iterator = this.changeList;
            synchronized (iterator) {
                for (CMetadata changeListObject : this.changeList) {
                    String fqid = changeListObject.getId();
                    CMetadata parentObject = null;
                    if (this.OwningStore.getStoreType() == 1) {
                        parentObject = ((MdObjectStoreImpl)this.OwningStore).getObject(fqid, true);
                    } else if (this.OwningStore.getStoreType() == 0) {
                        parentObject = ((MdServerStore)this.OwningStore).getObject(fqid, true);
                    }
                    if (parentObject == null || parentObject.getChangeList().contains(parentObject)) continue;
                    parentObject.addElementToChangeList(parentObject);
                }
            }
        }
        if (this.deletedObjects != null && this.OwningStore.getStoreType() == 1) {
            for (String id : this.deletedObjects.keySet()) {
                CMetadata parentObject = ((MdObjectStoreImpl)this.OwningStore).getObject(id, true);
                if (parentObject == null) continue;
                this.OwningStore.deleteObject(parentObject);
                ((MdObjectStoreImpl)this.OwningStore).removeElementFromStore(parentObject);
            }
        }
        this.getOwningStore().fireMdObjectsModified(new MdEvent(this, this), UpdatedIDs);
        this.clearChangeList();
        this.getOwningStore().addMdStoreListener(this);
    }

    @Override
    public void removeStore(MdStore childStore) throws RemoteException {
        this.removeChildStore(childStore);
    }

    @Override
    public CMetadata getObject(String strFQID, boolean hashonly) throws RemoteException {
        if (hashonly) {
            if (this.ObjectMap == null) {
                return null;
            }
            CMetadata tempHashObject = this.ObjectMap.get(strFQID);
            if (tempHashObject != null && this.isDeletedObject(strFQID)) {
                return null;
            }
            return tempHashObject;
        }
        return this.getObject(strFQID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMetadata getObject(String strFQID) throws RemoteException {
        if (this.ObjectMap == null || this.isDeletedObject(strFQID)) {
            return null;
        }
        CMetadata tempHashObject = this.ObjectMap.get(strFQID);
        if (tempHashObject == null) {
            CMetadata parentObject = null;
            parentObject = this.OwningStore.getStoreType() == 0 ? ((MdServerStoreImpl)this.OwningStore).getObjectFromServerStoreOnly(strFQID) : this.OwningStore.getObject(strFQID);
            if (parentObject != null) {
                if (this.OwningStore.getStoreType() == 0) {
                    MdStoreUtil.copyMetaObject((MdServerStore)this.OwningStore, (MdObjectStore)this, strFQID);
                } else if (this.OwningStore.getStoreType() == 1) {
                    MdStoreUtil.copyMetaObject((MdObjectStore)((MdObjectStoreImpl)this.OwningStore), (MdObjectStore)this, strFQID);
                }
                tempHashObject = this.ObjectMap.get(strFQID);
            }
        } else {
            if (this.isDeletedObject(strFQID)) {
                return null;
            }
            if ((tempHashObject.getState() & 4) > 0 && !this._refreshingObjects && !tempHashObject.isNewObject()) {
                try {
                    this._refreshingObjects = true;
                    this.refreshObjectFromServer(tempHashObject, true, true);
                }
                catch (MdException e) {
                    this.m_Util.printOutputln("DEBUG NOTE: Error refreshing object: Object type=" + tempHashObject.getCMetadataType() + " id=" + tempHashObject.getId());
                }
                finally {
                    this._refreshingObjects = false;
                }
            }
        }
        return tempHashObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeHashKey(String strOldId, String strNewId) throws RemoteException {
        CMetadata object = this.ObjectMap.get(strOldId);
        ArrayList<String> itemsOld = new ArrayList<String>(1);
        ArrayList<String> itemsNew = new ArrayList<String>(1);
        if (object != null) {
            this.ObjectMap.remove(strOldId);
            itemsOld.add(strOldId);
            this.fireMdObjectsRemoved(new MdEvent(object, this), itemsOld);
            itemsNew.add(strNewId);
            object.setFQID(strNewId);
            this.ObjectMap.put(strNewId, object);
            this.fireMdObjectsAdded(new MdEvent(object, this), itemsNew);
            if (object.getFQID().equalsIgnoreCase(strOldId)) {
                object.setFQID(strNewId);
            }
            object.updateAssnsIds(strOldId, strNewId);
        }
        if (strOldId != null && strOldId.indexOf(36) > 0) {
            ArrayList<String> created = new ArrayList<String>(1);
            created.add(strNewId);
            this.fireMdObjectsAdded(new MdEvent(this.m_factory, this), created);
            this.initializeCreatedItems();
            this.createdItemsSet.add(strNewId);
        }
        if (this.hasChildStores()) {
            List<MdStore> list = this.childStores;
            synchronized (list) {
                for (MdStore cStore : this.childStores) {
                    if (cStore.getStoreType() != 1) continue;
                    ((MdObjectStore)cStore).changeHashKey(strOldId, strNewId);
                }
            }
        }
        if (strOldId != null && strNewId != null && object != null) {
            this.fireMdStoreIDChange(new MdEvent(this, this), itemsOld, itemsNew);
        }
    }

    @Override
    public void removeElementFromStore(CMetadata removeObject) throws RemoteException {
        this.removeElementFromStore(removeObject, this.m_factory.getRemoveDependentObjects());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeElementFromStore(CMetadata removeObject, boolean removeDependents) throws RemoteException {
        CMetadata storeRemoveObject;
        if (removeObject != null && (storeRemoveObject = this.ObjectMap.get(removeObject.getId())) != null) {
            ArrayList<CMetadata> requiredObjectsToDelete = null;
            Map<String, AssociationList> assnMap = removeObject.getPopulatedAssocs();
            for (String string : assnMap.keySet()) {
                AssociationList list = assnMap.get(string);
                if (list == null) continue;
                try {
                    if (removeDependents && removeObject.isNewObject()) {
                        Vector<String> ids = list.getObjectIDs();
                        for (int i = 0; i < ids.size(); ++i) {
                            CMetadata meta;
                            String id = (String)ids.get(i);
                            AssociationList oppositeSideAssoc = ((MdObjectListImpl)list.getInternalListObject()).getOppositeAssn(id);
                            if (oppositeSideAssoc == null || !oppositeSideAssoc.getIsRequired() || oppositeSideAssoc.size() != 1 || (meta = this.ObjectMap.get(id)) == null || !meta.isNewObject()) continue;
                            if (requiredObjectsToDelete == null) {
                                requiredObjectsToDelete = new ArrayList<CMetadata>();
                            }
                            requiredObjectsToDelete.add(meta);
                        }
                    }
                    list.removeAllElements(false);
                }
                catch (MdException e) {
                    this.m_Util.printOutputln(e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
            MapPool.returnMap(assnMap);
            assnMap = null;
            this.ObjectMap.remove(removeObject.getFQID());
            if (this.hasChildStores()) {
                List<MdStore> list = this.childStores;
                synchronized (list) {
                    for (MdStore cStore : this.childStores) {
                        if (cStore.getStoreType() != 1) continue;
                        ((MdObjectStore)cStore).removeElementFromStore(((MdObjectStore)cStore).getObject(removeObject.getFQID(), true));
                    }
                }
            }
            this.removeElementFromChangeList(storeRemoveObject);
            storeRemoveObject = null;
            if (requiredObjectsToDelete != null) {
                int n = requiredObjectsToDelete.size();
                for (int i = 0; i < n; ++i) {
                    CMetadata meta = (CMetadata)requiredObjectsToDelete.get(i);
                    this.m_Util.printOutputln("DEBUG NOTE: Removing dependent object from store - " + meta.getCMetadataType() + " (" + meta.getName() + ")");
                    this.removeElementFromStore(meta);
                }
            }
        }
    }

    @Override
    public void updateChangeListObjectIDs(String OldReposID, String NewReposID) throws RemoteException {
        this.updateChangeListObjectIDs(OldReposID, NewReposID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateChangeListObjectIDs(String OldReposID, String NewReposID, String targetReposID) throws RemoteException {
        if (this.changeList != null) {
            Set<CMetadata> set = this.changeList;
            synchronized (set) {
                for (CMetadata meta : this.changeList) {
                    String changeObjectsID = meta.getFQID();
                    String newID = null;
                    if (!changeObjectsID.startsWith(OldReposID)) continue;
                    newID = NewReposID + "." + changeObjectsID.substring(9, 17);
                    this.m_factory.changeHashKey(changeObjectsID, newID);
                }
            }
        }
    }

    @Override
    public void refreshObjects(List<String> items) throws RemoteException {
        this.refreshObjects(this.getOwningStore(), items);
    }

    protected void refreshObjects(MdStore sourceStore, List<String> items) throws RemoteException {
        if (sourceStore == null) {
            sourceStore = this.getOwningStore();
        }
        for (String objectID : items) {
            MdStoreUtil.refreshMetaObject(sourceStore, (MdStore)this, objectID);
            CMetadata changedObject = this.getObject(objectID, true);
            if (changedObject == null) continue;
            changedObject.removeMdObjectListener(this);
            changedObject.fireMdObjectModified(new MdEvent(changedObject, this));
            changedObject.addMdObjectListener(this);
        }
        this.fireMdObjectsModified(new MdEvent(this, this), items);
    }

    @Override
    public void resetStates(List<CMetadata> items) throws RemoteException {
        if (items == null) {
            return;
        }
        for (CMetadata objectUpdated : items) {
            if (objectUpdated == null) continue;
            objectUpdated.resetStates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObjectsToStale() throws RemoteException {
        Map<String, CMetadata> map = this.ObjectMap;
        synchronized (map) {
            for (String id : this.ObjectMap.keySet()) {
                CMetadata meta_object = this.ObjectMap.get(id);
                if (meta_object == null || (meta_object.getState() & 4) != 0) continue;
                meta_object.setState(4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteObjectFromStore(String strFQID) throws RemoteException {
        if (this.isDisposed()) {
            return;
        }
        CMetadata object = this.ObjectMap.get(strFQID);
        if (object == null && this.isDeletedObject(strFQID)) {
            object = this.deletedObjects.get(strFQID);
        }
        if (object != null) {
            Map<String, AssociationList> assns = object.getPopulatedAssocs();
            for (String assnName : assns.keySet()) {
                AssociationList assn = assns.get(assnName);
                if (assn == null) continue;
                try {
                    assn.removeAllElements(false);
                }
                catch (MdException exp) {
                    this.m_Util.printOutputln(exp.getLocalizedMessage());
                    exp.printStackTrace();
                }
            }
            MapPool.returnMap(assns);
            assns = null;
            this.ObjectMap.remove(strFQID);
            this.removeElementFromChangeList(object);
            object = null;
        }
        if (this.hasChildStores()) {
            List<MdStore> list = this.childStores;
            synchronized (list) {
                for (MdStore cStore : this.childStores) {
                    if (cStore.getStoreType() != 1) continue;
                    ((MdObjectStore)cStore).deleteObjectFromStore(strFQID);
                }
            }
        }
    }

    @Override
    public void MdObjectModified(MdEvent e) throws RemoteException {
    }

    @Override
    public void MdObjectsModified(MdEvent e, List items) throws RemoteException {
        if (e.getSource().equals(this)) {
            return;
        }
        boolean InList = false;
        for (String objectID : items) {
            if (this.ObjectMap.get(objectID) == null) continue;
            InList = true;
            break;
        }
        if (InList) {
            try {
                MdStore srcStore = e.getSourceStore();
                String name = "HashMap";
                if (srcStore instanceof MdObjectStore) {
                    name = ((MdObjectStore)srcStore).getStoreName();
                }
                if (this.vetos != null) {
                    this.vetos.fireVetoableChange(name, this.ObjectMap, items);
                }
                this.refreshObjects(e.getSourceStore(), items);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    @Override
    public void MdObjectsRemoved(MdEvent e, List ids) throws RemoteException {
    }

    @Override
    public void MdObjectsAdded(MdEvent e, List ids) throws RemoteException {
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener l) throws RemoteException {
        if (this.vetos == null) {
            this.vetos = new VetoableChangeSupport(this);
        }
        this.vetos.addVetoableChangeListener(l);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener l) throws RemoteException {
        if (this.vetos != null) {
            this.vetos.removeVetoableChangeListener(l);
        }
    }

    @Override
    public void addMdStoreListener(MdStoreListener l) throws RemoteException {
        if (this.MdStoreListenerList != null) {
            this.MdStoreListenerList.add(MdStoreListener.class, l);
        }
    }

    @Override
    public void removeMdStoreListener(MdStoreListener l) throws RemoteException {
        if (this.MdStoreListenerList != null) {
            this.MdStoreListenerList.remove(MdStoreListener.class, l);
        }
    }

    @Override
    public void addMdObjectListener(MdObjectListener l) throws RemoteException {
        if (this.MdObjectListenerList == null) {
            this.MdObjectListenerList = new EventListenerList();
        }
        this.MdObjectListenerList.add(MdObjectListener.class, l);
    }

    @Override
    public void removeMdObjectListener(MdObjectListener l) throws RemoteException {
        if (this.MdObjectListenerList != null) {
            this.MdObjectListenerList.remove(MdObjectListener.class, l);
        }
    }

    @Override
    public void addMdStoreIDChangeListener(MdStoreIDChangeListener l) throws RemoteException {
        if (this.MdStoreIDChangeListenerList == null) {
            this.MdStoreIDChangeListenerList = new EventListenerList();
        }
        this.MdStoreIDChangeListenerList.add(MdStoreIDChangeListener.class, l);
        if (this.MdStoreListenerList != null) {
            this.MdStoreListenerList.add(MdStoreListener.class, l);
        }
    }

    @Override
    public void removeMdStoreIDChangeListener(MdStoreIDChangeListener l) throws RemoteException {
        if (this.MdStoreIDChangeListenerList != null) {
            this.MdStoreIDChangeListenerList.remove(MdStoreIDChangeListener.class, l);
        }
        if (this.MdStoreListenerList != null) {
            this.MdStoreListenerList.remove(MdStoreListener.class, l);
        }
    }

    @Override
    public void fireMdObjectModified(MdEvent e) throws RemoteException {
        if (this.MdObjectListenerList != null) {
            Object[] listeners = this.MdObjectListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdObjectListener.class) continue;
                ((MdObjectListener)listeners[i + 1]).MdObjectModified(e);
            }
        }
    }

    @Override
    public void fireMdStoreIDChange(MdEvent e, List idsOld, List idsNew) throws RemoteException {
        if (this.MdStoreIDChangeListenerList != null) {
            Object[] listeners = this.MdStoreIDChangeListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdStoreIDChangeListener.class) continue;
                ((MdStoreIDChangeListener)listeners[i + 1]).MdStoreIDChange(e, idsOld, idsNew);
            }
        }
    }

    @Override
    public void fireMdObjectsModified(MdEvent e, List items) throws RemoteException {
        if (this.MdStoreListenerList != null) {
            Object[] listeners = this.MdStoreListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdStoreListener.class) continue;
                ((MdStoreListener)listeners[i + 1]).MdObjectsModified(e, items);
            }
        }
    }

    @Override
    public void fireMdObjectsAdded(MdEvent e, List ids) throws RemoteException {
        if (this.MdStoreListenerList != null) {
            Object[] listeners = this.MdStoreListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdStoreListener.class) continue;
                ((MdStoreListener)listeners[i + 1]).MdObjectsAdded(e, ids);
            }
        }
    }

    @Override
    public void fireMdObjectsRemoved(MdEvent e, List ids) throws RemoteException {
        if (this.MdStoreListenerList != null) {
            Object[] listeners = this.MdStoreListenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != MdStoreListener.class) continue;
                ((MdStoreListener)listeners[i + 1]).MdObjectsRemoved(e, ids);
            }
        }
    }

    @Override
    public boolean deleteObject(CMetadata inObject) throws RemoteException {
        String id;
        this.initializeDeletedObjects();
        if (inObject != null && (id = inObject.getFQID()) != null && id.length() > 0) {
            this.deletedObjects.put(id, inObject);
            return true;
        }
        return false;
    }

    @Override
    public CMetadata restoreObject(String objectID) throws RemoteException {
        if (objectID != null && this.deletedObjects != null) {
            CMetadata delobject = this.deletedObjects.get(objectID);
            this.deletedObjects.remove(objectID);
            return delobject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CMetadata> getChangedObjects() throws RemoteException {
        ArrayList<CMetadata> changedObjects = new ArrayList<CMetadata>(10);
        Map<String, CMetadata> map = this.ObjectMap;
        synchronized (map) {
            for (String id : this.ObjectMap.keySet()) {
                CMetadata obj = this.ObjectMap.get(id);
                if ((obj.getState() & 1) <= 0) continue;
                changedObjects.add(obj);
            }
        }
        return changedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CMetadata> getNewObjects() throws RemoteException {
        ArrayList<CMetadata> newObjects = new ArrayList<CMetadata>(10);
        Map<String, CMetadata> map = this.ObjectMap;
        synchronized (map) {
            for (String id : this.ObjectMap.keySet()) {
                CMetadata obj = this.ObjectMap.get(id);
                if (obj.getFQID().indexOf(36) <= -1) continue;
                newObjects.add(obj);
            }
        }
        return newObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addElementToChangeList(CMetadata object) throws RemoteException {
        this.initializeChangeList();
        Set<CMetadata> set = this.changeList;
        synchronized (set) {
            if (object != null && !this.changeList.contains(object)) {
                this.changeList.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeElementFromChangeList(CMetadata object) throws RemoteException {
        if (object != null && this.changeList != null) {
            Set<CMetadata> set = this.changeList;
            synchronized (set) {
                if (this.changeList.contains(object)) {
                    this.changeList.remove(object);
                }
            }
        }
    }

    @Override
    public void clearChangeList() throws RemoteException {
        if (this.changeList != null) {
            this.changeList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createRefreshXMLforStore(boolean includeLocallyChangedItems, boolean getFullObjectUpdate) throws RemoteException {
        StringBuffer outXML = new StringBuffer();
        Map<String, CMetadata> map = this.ObjectMap;
        synchronized (map) {
            for (String objectID : this.ObjectMap.keySet()) {
                CMetadata inObject = this.getObject(objectID, true);
                if (inObject.isNewObject()) continue;
                outXML.append(this.m_factory.getOMIUtil().createRefreshXML(inObject, false, getFullObjectUpdate));
            }
        }
        return outXML.toString();
    }

    @Override
    public String createXMLforStore() throws RemoteException {
        return this.createXMLforStore(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createXMLforStore(boolean beautifyOutput) throws RemoteException {
        StringBuilder sb = new StringBuilder();
        Map<String, CMetadata> map = this.ObjectMap;
        synchronized (map) {
            Object[] map2 = this.ObjectMap.keySet().toArray();
            for (int i = 0; i < map2.length; ++i) {
                String objectID = (String)map2[i];
                CMetadata inObject = this.getObject(objectID, true);
                sb.append(inObject.createObjectXML(inObject, beautifyOutput));
            }
        }
        if (beautifyOutput) {
            return XMLUtil.formatXML(sb.toString());
        }
        return sb.toString();
    }

    @Override
    public void refreshStoreFromServer(boolean includeLocallyChangedItems, boolean getFullObjectUpdate) throws MdException, RemoteException {
        if (this.m_factory.getParsingType() == 0) {
            this.m_factory.getOMIUtil().getOMIUtility().refreshStoreFromServer(this, includeLocallyChangedItems, getFullObjectUpdate);
            return;
        }
        String updateXML = this.createRefreshXMLforStore(includeLocallyChangedItems, getFullObjectUpdate);
        String strFQID = null;
        int flags = 2312;
        if (getFullObjectUpdate) {
            flags |= 1;
        }
        if (!this.m_factory.getUseServerFormattedDates()) {
            flags |= 0x4000000;
        }
        StringHolder outXML = new StringHolder();
        if (this.m_factory.getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(102 + updateXML.length());
            inputXML.append("<GetMetadata><Metadata>");
            inputXML.append(updateXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(this.m_factory.getOMIUtil().getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append("");
            inputXML.append("</Options></GetMetadata>");
            this.m_Util.printLoglnClient(inputXML.toString());
        }
        try {
            this.getFactory().getConnection().getCMRHandle().GetMetadata(updateXML, outXML, "", flags, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        StringBuffer outputXML = new StringBuffer(19 + outXML.value.length());
        outputXML.append("<Objects>");
        outputXML.append(outXML.value);
        outputXML.append("</Objects>");
        String xml = outputXML.toString();
        this.m_Util.printLoglnServer(xml);
        Document doc = this.m_factory.getOMIUtil().parseXML(xml);
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
            }
            if (idNode == null) {
                throw new MdException("Id node not specified, invalid object XML.");
            }
            strFQID = idNode.getNodeValue();
            CMetadata metaObject = this.getObject(strFQID);
            if (metaObject == null) continue;
            this.m_factory.getOMIUtil().populateObject(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), false);
            if (metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        doc = null;
    }

    @Override
    public CMetadata retrieveFullObject(String objectType, String objectID) throws MdException, RemoteException {
        return this.m_factory.getOMIUtil().getFullObject(this, objectType, objectID);
    }

    @Override
    public void refreshObjectFromServer(CMetadata inObject, boolean includeLocallyChangedItems, boolean getFullObjectUpdate) throws MdException, RemoteException {
        this.refreshObjectFromServer(inObject, includeLocallyChangedItems, getFullObjectUpdate, false);
    }

    @Override
    public void refreshObjectFromServer(CMetadata inObject, boolean includeLocallyChangedItems, boolean getFullObjectUpdate, boolean refreshAssocsSetByServerOnly) throws MdException, RemoteException {
        if (inObject == null || inObject.getId() == null) {
            return;
        }
        if (this.m_factory.getParsingType() == 0) {
            this.m_factory.getOMIUtil().getOMIUtility().refreshObjectFromServer(inObject, includeLocallyChangedItems, getFullObjectUpdate, refreshAssocsSetByServerOnly);
            return;
        }
        String strFQID = null;
        int flags = 264;
        if (getFullObjectUpdate && !refreshAssocsSetByServerOnly) {
            flags |= 1;
        }
        if (!this.m_factory.getUseServerFormattedDates()) {
            flags |= 0x4000000;
        }
        String refreshXML = this.m_factory.getOMIUtil().createRefreshXML(inObject, refreshAssocsSetByServerOnly, getFullObjectUpdate);
        StringHolder outXML = new StringHolder();
        if (this.getFactory().getLoggingEnabled()) {
            StringBuffer inputXML = new StringBuffer(102 + refreshXML.length());
            inputXML.append("<GetMetadata><Metadata>");
            inputXML.append(refreshXML);
            inputXML.append("</Metadata><NS>");
            inputXML.append(this.m_factory.getOMIUtil().getNamespace());
            inputXML.append("</NS><Flags>");
            inputXML.append(flags);
            inputXML.append("</Flags><Options>");
            inputXML.append("");
            inputXML.append("</Options></GetMetadata>");
            this.m_Util.printLoglnClient(inputXML.toString());
        }
        try {
            this.getFactory().getConnection().getCMRHandle().GetMetadata(refreshXML, outXML, this.m_factory.getOMIUtil().getNamespace(), flags, "");
        }
        catch (Exception e) {
            throw new MdException(e);
        }
        StringBuffer outputXML = new StringBuffer(19 + outXML.value.length());
        outputXML.append("<Objects>");
        outputXML.append(outXML.value);
        outputXML.append("</Objects>");
        String xml = outputXML.toString();
        this.m_Util.printLoglnServer(xml);
        Document doc = this.m_factory.getOMIUtil().parseXML(xml);
        Node firstNode = doc.getFirstChild();
        NodeList secondLevelList = firstNode.getChildNodes();
        int allObjects = secondLevelList.getLength();
        for (int k = 0; k < allObjects; ++k) {
            NamedNodeMap attributeMap = secondLevelList.item(k).getAttributes();
            Node idNode = attributeMap.getNamedItem("Id");
            if (idNode == null) {
                idNode = attributeMap.getNamedItem("ObjRef");
            }
            if (idNode == null) {
                throw new MdException("Id node not specified, invalid object XML.");
            }
            strFQID = idNode.getNodeValue();
            CMetadata metaObject = this.getObject(strFQID);
            this.m_factory.getOMIUtil().populateObject(metaObject, secondLevelList.item(k).getAttributes(), secondLevelList.item(k).getChildNodes(), false);
            if (metaObject.getObjectStore().getStoreType() != 0) continue;
            metaObject.resetObject();
        }
        doc = null;
    }

    @Override
    public Vector<CMetadata> getChangeList() throws RemoteException {
        this.initializeChangeList();
        return new Vector<CMetadata>(this.changeList);
    }

    @Override
    public Vector<CMetadata> getAuthorizationTransContextList() throws RemoteException {
        return this.authorizationTransContextList;
    }

    @Override
    public void addObjToAuthorizationTransContextList(CMetadata obj) throws RemoteException {
        if (this.authorizationTransContextList == null) {
            this.authorizationTransContextList = new Vector();
        }
        if (!this.authorizationTransContextList.contains(obj)) {
            this.authorizationTransContextList.add(obj);
        }
    }

    @Override
    public void removeObjFromAuthorizationTransContextList(CMetadata obj) throws RemoteException {
        if (this.authorizationTransContextList != null && this.authorizationTransContextList.contains(obj)) {
            this.authorizationTransContextList.remove(obj);
        }
    }

    @Override
    public void clearAuthorizationTransContextList() throws RemoteException {
        if (this.authorizationTransContextList != null) {
            this.authorizationTransContextList.clear();
        }
    }

    @Override
    public void removeObjectsFromStore(List<? extends CMetadata> deletedObjects) throws MdException, RemoteException {
        ArrayList<CMetadata> objectsToRemove = new ArrayList<CMetadata>(deletedObjects.size());
        if (deletedObjects != null) {
            for (CMetadata cMetadata : deletedObjects) {
                objectsToRemove.add(cMetadata);
            }
        }
        boolean removeDependents = this.m_factory.getRemoveDependentObjects();
        for (CMetadata toDeleteObject : objectsToRemove) {
            this.removeElementFromStore(toDeleteObject, removeDependents);
            this.deleteObject(toDeleteObject);
        }
    }

    @Override
    public void removeObjectFromStore(CMetadata deleteObject, String deleteTemplate) throws MdException, RemoteException {
        boolean templateExists = false;
        if (this.m_factory.getRemoveDependentObjects()) {
            templateExists = deleteTemplate != null && deleteTemplate.length() > 0;
        }
        ArrayList<CMetadata> objectsToRemove = new ArrayList<CMetadata>();
        if (templateExists) {
            Document doc = this.m_factory.getOMIUtil().parseXML(deleteTemplate);
            Node firstNode = doc.getFirstChild();
            this.removeObjects(deleteObject, firstNode.getAttributes(), firstNode.getChildNodes(), objectsToRemove);
        }
        if (!objectsToRemove.contains(deleteObject)) {
            objectsToRemove.add(deleteObject);
        }
        for (CMetadata toDeleteObject : objectsToRemove) {
            this.removeElementFromStore(toDeleteObject, !templateExists);
            this.deleteObject(toDeleteObject);
        }
    }

    private void removeObjects(CMetadata metaObject, NamedNodeMap simpleNodeMap, NodeList removeNodeList, List<CMetadata> outRemoveObjects) throws RemoteException {
        this.doRemove(metaObject, removeNodeList, outRemoveObjects);
        if (!outRemoveObjects.contains(metaObject)) {
            outRemoveObjects.add(metaObject);
        }
    }

    private void doRemove(CMetadata thisObject, NodeList thisNodeList, List<CMetadata> outRemoveObjects) throws RemoteException {
        int numChildLists = thisNodeList.getLength();
        for (int k = 0; k < numChildLists; ++k) {
            String nodeName;
            Node childnode = thisNodeList.item(k);
            if (childnode == null || (nodeName = childnode.getNodeName()) == null || nodeName.length() == 0 || nodeName.indexOf("#") > -1) continue;
            AssociationList associatedObjects = null;
            try {
                associatedObjects = thisObject.getMdObjectAssociation(nodeName);
            }
            catch (MdException mex) {
                mex.printStackTrace();
                continue;
            }
            if (associatedObjects != null) {
                for (int i = 0; i < associatedObjects.size(); ++i) {
                    CMetadata objectToRemove = (CMetadata)associatedObjects.get(i);
                    if (objectToRemove == null) continue;
                    if (childnode.hasChildNodes()) {
                        this.removeObjects(objectToRemove, childnode.getAttributes(), childnode.getChildNodes(), outRemoveObjects);
                        continue;
                    }
                    outRemoveObjects.add(objectToRemove);
                }
                continue;
            }
            if (!childnode.hasChildNodes()) continue;
            this.removeObjects(thisObject, childnode.getAttributes(), childnode.getChildNodes(), outRemoveObjects);
        }
    }

    @Override
    public void clearWriteBuffer() throws RemoteException {
        if (this.writeBuffer != null && this.writeBuffer.length() > 0) {
            this.writeBuffer = null;
            this.writeBuffer = new StringBuffer();
        }
    }

    @Override
    public String getWriteBuffer() throws RemoteException {
        return this.writeBuffer == null ? "" : this.writeBuffer.toString();
    }

    @Override
    public void appendWriteBuffer(String appendText) throws RemoteException {
        if (this.writeBuffer == null) {
            this.writeBuffer = new StringBuffer();
        }
        this.writeBuffer.append(appendText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearObjectsFromStore() throws RemoteException {
        ArrayList<String> objects = new ArrayList<String>();
        Map<String, CMetadata> map = this.ObjectMap;
        synchronized (map) {
            Set<String> keys = this.getDetailObjectMap().keySet();
            for (String key : keys) {
                objects.add(key);
            }
        }
        for (String id : objects) {
            if (id == null) continue;
            this.deleteDetailMetadataObject(id);
        }
    }

    @Override
    public List<String> getCreatedItemsList() throws RemoteException {
        if (this.createdItemsSet == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> items = new ArrayList<String>(this.createdItemsSet.size());
        items.addAll(this.createdItemsSet);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCreatedItemsList(List<String> items) throws RemoteException {
        this.initializeCreatedItems();
        for (String id : items) {
            if (!this.createdItemsSet.contains(id)) continue;
            this.createdItemsSet.remove(id);
        }
        if (this.hasChildStores()) {
            List<MdStore> list = this.childStores;
            synchronized (list) {
                for (MdStore cStore : this.childStores) {
                    cStore.updateCreatedItemsList(items);
                }
            }
        }
    }

    @Override
    public void addChildStore(MdStore inStore) throws RemoteException {
        if (this.childStores == null) {
            this.childStores = Collections.synchronizedList(new ArrayList(5));
        }
        if (!this.childStores.contains(inStore)) {
            this.childStores.add(inStore);
        }
    }

    @Override
    public void removeChildStore(MdStore inStore) throws RemoteException {
        if (this.hasChildStores() && this.childStores.contains(inStore)) {
            this.childStores.remove(inStore);
        }
    }

    public String toString() {
        if (this.storeName != null) {
            return "[" + this.storeName + "]" + super.toString();
        }
        return "[UNKNOWN]" + super.toString();
    }

    @Override
    public boolean is_write_lock() throws RemoteException {
        return this._write_lock;
    }

    @Override
    public void set_write_lock(boolean b) throws RemoteException {
        this._write_lock = b;
    }

    private boolean hasChildStores() {
        return this.childStores != null && this.childStores.size() > 0;
    }

    private void initializeDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new HashMap<String, CMetadata>();
        }
    }

    private void initializeCreatedItems() {
        if (this.createdItemsSet == null) {
            this.createdItemsSet = new HashSet<String>(20);
        }
    }

    private void initializeChangeList() {
        if (this.changeList == null) {
            this.changeList = Collections.synchronizedSet(new LinkedHashSet());
        }
    }
}

