/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.CredentialResolver;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdCredential;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdLibGenInterface;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdUtil;
import com.sas.metadata.remote.MetadataResource;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.SASLibraryConnectStatement;
import com.sas.metadata.remote.SASPassword;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SASScope
public class MdModelUtil {
    private static final String BLOTTED_PASSWORD = "********";
    protected static final char SINGLE_QUOTE = '\'';
    protected static final char DOUBLE_QUOTE = '\"';
    protected static final char BLANK_SPACE = ' ';
    protected static MetadataResource bundle = new MetadataResource(MdModelUtil.class);
    private static final Map<String, List<String>> VALID_CLIENTCONNECTION_OPTIONS;
    public static final int ENCODE_PASSWORDS = 1;
    public static final int GEN_FILENAME_FOR_XML = 2;
    public static final int IGNORE_PREASSIGNED = 4;
    public static final int GEN_AUTHDOMAIN = 8;
    public static final int READONLY_OVERRIDE = 16;

    private MdModelUtil() {
    }

    public static MdLibGenInterface getInstance(CredentialResolver resolver, String prompt, boolean encodePasswords, boolean genFileNameForXMLLibs, boolean ignorePreassigned, boolean readonlyLibname) {
        int flags = 0;
        if (encodePasswords) {
            flags |= 1;
        }
        if (genFileNameForXMLLibs) {
            flags |= 2;
        }
        if (ignorePreassigned) {
            flags |= 4;
        }
        if (readonlyLibname) {
            flags |= 0x10;
        }
        return MdModelUtil.getInstance(resolver, prompt, flags);
    }

    public static MdLibGenInterface getInstance(CredentialResolver resolver, String prompt, int flags) {
        SAS9Generator libGen = null;
        libGen = resolver == null ? new SAS9Generator(flags) : new PromptingGenerator(flags, resolver, prompt);
        return libGen;
    }

    public static MdLibGenInterface getInstance(CredentialResolver resolver, String prompt, boolean encodePasswords, boolean genFileNameForXMLLibs, boolean ignorePreassigned) {
        boolean readonlyLibname = false;
        return MdModelUtil.getInstance(resolver, prompt, encodePasswords, genFileNameForXMLLibs, ignorePreassigned, false);
    }

    public static MdLibGenInterface getInstance(CredentialResolver resolver, String prompt, boolean encodePasswords, boolean genFileNameForXMLLibs) {
        boolean ignorePreassigned = false;
        return MdModelUtil.getInstance(resolver, prompt, encodePasswords, genFileNameForXMLLibs, false);
    }

    public static MdLibGenInterface getInstance(CredentialResolver resolver, String prompt, boolean encodePasswords) {
        boolean genFileNameForXMLLibs = true;
        return MdModelUtil.getInstance(resolver, prompt, encodePasswords, true);
    }

    public static MdLibGenInterface getInstance(CredentialResolver resolver, String prompt) {
        boolean encodedPasswords = false;
        return MdModelUtil.getInstance(resolver, prompt, false);
    }

    public static MdLibGenInterface getInstance(CredentialResolver resolver) {
        return MdModelUtil.getInstance(resolver, null);
    }

    @Deprecated
    public static String accessPath(SASLibrary iMeta) throws MdException, RemoteException {
        return MdModelUtil.accessPath(iMeta, false);
    }

    @Deprecated
    public static String accessPath(SASLibrary iMeta, String sLibref) throws MdException, RemoteException {
        return MdModelUtil.accessPath(iMeta, sLibref, false);
    }

    @Deprecated
    public static String accessPath(SASLibrary iMeta, String sLibref, boolean b_encodePassword) throws MdException, RemoteException {
        return MdModelUtil.accessPath(iMeta, sLibref, b_encodePassword, true);
    }

    @Deprecated
    public static String accessPath(SASLibrary iMeta, String sLibref, boolean b_encodePassword, boolean genFileNameForXML) throws MdException, RemoteException {
        MdLibGenInterface libGen = MdModelUtil.getInstance(null, null, b_encodePassword, genFileNameForXML);
        String path = libGen.genLibnameUsing(iMeta, sLibref);
        return path;
    }

    @Deprecated
    public static String accessPath(SASLibrary iMeta, boolean b_encodePassword) throws MdException, RemoteException {
        return MdModelUtil.accessPath(iMeta, b_encodePassword, true);
    }

    @Deprecated
    public static String accessPath(SASLibrary iMeta, boolean b_encodePassword, boolean genFileNameForXML) throws MdException, RemoteException {
        return MdModelUtil.accessPath(iMeta, null, b_encodePassword, genFileNameForXML);
    }

    private static String processPath(File file) throws RemoteException {
        String path = file.getFileName();
        char quoteCharacter = MdModelUtil.getQuoteChar(path);
        String quotedPathString = MdModelUtil.genOptionValueQuoted(path, quoteCharacter);
        return quotedPathString;
    }

    protected static String processProperties(String engineName, List<Property> lProps) throws RemoteException {
        StringBuilder sb = new StringBuilder();
        for (Property iProp : lProps) {
            String optionString;
            String propertyName = iProp.getPropertyName();
            String propertyValue = iProp.getDefaultValue();
            if ("FilenameOptionString".equalsIgnoreCase(propertyName)) continue;
            if (iProp.getUseValueOnly() != 0) {
                sb.append(' ').append(propertyValue).append(' ');
                continue;
            }
            if (propertyValue == null || propertyValue.length() == 0) continue;
            String delimiter = iProp.getDelimiter();
            if ("SASSPDS".equals(engineName) && ("SERV".equalsIgnoreCase(propertyName) || "SERVICE".equalsIgnoreCase(propertyName))) {
                optionString = MdModelUtil.genOptionPairQuoted(propertyName, delimiter, propertyValue);
            } else {
                if ("FEDSVR".equals(engineName) && "NOPROMPT".equalsIgnoreCase(propertyName)) {
                    propertyName = "CONNECT_STRING";
                }
                optionString = MdModelUtil.genOptionPair(propertyName, delimiter, propertyValue);
            }
            sb.append(' ').append(optionString).append(' ');
        }
        return sb.toString();
    }

    protected static String getSESSREFValue(List<Property> lProps) throws RemoteException {
        for (Property iProp : lProps) {
            String propertyName = iProp.getPropertyName();
            String propertyValue = iProp.getDefaultValue();
            if (!"SESSREF".equalsIgnoreCase(propertyName)) continue;
            return propertyValue;
        }
        return null;
    }

    protected static String getSESSREF(SASLibrary iMeta) throws RemoteException, MdException {
        for (Property iPropCheck : iMeta.getProperties()) {
            String propertyNameCheck = iPropCheck.getPropertyName();
            String propertyValueCheck = iPropCheck.getDefaultValue();
            if (!"SESSREF".equalsIgnoreCase(propertyNameCheck)) continue;
            return propertyValueCheck;
        }
        return null;
    }

    private static char getQuoteChar(String value) {
        boolean searchWholeString = false;
        int characterNotFound = -1;
        boolean isDoubleQuoteInValue = value.indexOf(34, 0) != -1;
        char quoteCharacter = isDoubleQuoteInValue ? (char)'\'' : '\"';
        return quoteCharacter;
    }

    static String genOptionPair(String key, String delimiter, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        sb.append(delimiter);
        if (MdModelUtil.isOptionValueNeedsQuotes(key, delimiter, value)) {
            char quoteCharacter = MdModelUtil.getQuoteChar(value);
            String newValue = MdModelUtil.genOptionValueQuoted(value, quoteCharacter);
            sb.append(newValue);
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    static String genOptionPairUnquoted(String key, String delimiter, String value) {
        StringBuilder sb = new StringBuilder(key);
        sb.append(delimiter);
        sb.append(value);
        return sb.toString();
    }

    static String genOptionPairQuoted(String key, String delimiter, String value) {
        StringBuilder sb = new StringBuilder(key);
        sb.append(delimiter);
        if (MdModelUtil.isValueQuoted(value)) {
            sb.append(value);
        } else {
            char quoteCharacter = MdModelUtil.getQuoteChar(value);
            String newValue = MdModelUtil.genOptionValueQuoted(value, quoteCharacter);
            sb.append(newValue);
        }
        return sb.toString();
    }

    private static String genOptionValueString(String optionValueString, char quoteCharacter) {
        String quoteCharacterString = Character.toString(quoteCharacter);
        StringBuilder optionValue = new StringBuilder(quoteCharacterString);
        optionValue.append(optionValueString);
        optionValue.append(quoteCharacterString);
        return optionValue.toString();
    }

    private static String genOptionValueQuoted(String optionValueString, char quoteCharacter) {
        String optionValue = MdModelUtil.genOptionValueString(optionValueString, quoteCharacter);
        return optionValue;
    }

    private static boolean isOptionValueNeedsQuotes(String key, String delimiter, String value) {
        boolean isQuotingNeeded = false;
        isQuotingNeeded = MdModelUtil.isValueQuoted(value) ? false : (MdModelUtil.isStringNeedingQuotes(value) ? !MdModelUtil.isValueEnclosedInParens(value) : false);
        if (!isQuotingNeeded && "CASLIB".equalsIgnoreCase(key) && value.length() >= 1 && Character.isDigit(value.charAt(0))) {
            isQuotingNeeded = true;
        }
        return isQuotingNeeded;
    }

    private static boolean isStringNeedingQuotes(String stringValue) {
        boolean isQuotingNeeded = false;
        if (!MdModelUtil.isValueQuoted(stringValue)) {
            int underscore = 95;
            int stringValueLength = stringValue.length();
            for (int index = 0; index < stringValueLength; ++index) {
                boolean isValidCharacter;
                char currentChar = stringValue.charAt(index);
                boolean bl = isValidCharacter = Character.isLetterOrDigit(currentChar) || currentChar == '_';
                if (isValidCharacter) continue;
                isQuotingNeeded = true;
                break;
            }
        }
        return isQuotingNeeded;
    }

    private static boolean isValueQuoted(String value) {
        String minQuotedString = "''";
        int minQuotedLength = "''".length();
        int valueLength = value.length();
        boolean isQuoted = false;
        if (valueLength >= minQuotedLength) {
            boolean isWrappedInDoubleQuotes;
            String singleQuote = String.valueOf('\'');
            String doubleQuote = String.valueOf('\"');
            boolean isWrappedInSingleQuotes = value.startsWith(singleQuote) && value.endsWith(singleQuote);
            boolean bl = isWrappedInDoubleQuotes = value.startsWith(doubleQuote) && value.endsWith(doubleQuote);
            if (isWrappedInSingleQuotes || isWrappedInDoubleQuotes) {
                isQuoted = true;
            }
        }
        return isQuoted;
    }

    private static boolean isValueEnclosedInParens(String value) {
        String minString = "()";
        int minStringLength = "()".length();
        int valueLength = value.length();
        int openParen = 40;
        int closeParen = 41;
        boolean isEnclosedInParens = false;
        if (valueLength >= minStringLength) {
            String openParenString = String.valueOf('(');
            String closeParenString = String.valueOf(')');
            isEnclosedInParens = value.startsWith(openParenString) && value.endsWith(closeParenString);
        }
        return isEnclosedInParens;
    }

    private static String processPath(SASLibrary iLib, boolean quote_single_path) throws MdException, RemoteException {
        StringBuilder sb = new StringBuilder();
        AssociationList packages = iLib.getUsingPackages();
        int packagesFound = 0;
        int total_packages = packages.size();
        boolean single_path_value = total_packages == 1;
        int zero_based_count = 1;
        boolean quote_the_path = single_path_value ? quote_single_path : true;
        for (int i = 0; i < total_packages; ++i) {
            boolean last_library;
            boolean isPathNeedingQuotes;
            DeployedDataPackage iDDP = (DeployedDataPackage)packages.get(i);
            if (iDDP instanceof SASLibrary) {
                sb.append(((SASLibrary)iDDP).getLibref() + ' ');
                ++packagesFound;
                continue;
            }
            if (!(iDDP instanceof Directory)) continue;
            String path = ((Directory)iDDP).getDirectoryName();
            boolean bl = isPathNeedingQuotes = !MdModelUtil.isValueQuoted(path);
            if (quote_the_path && isPathNeedingQuotes) {
                char quoteCharacter = MdModelUtil.getQuoteChar(path);
                String quotedPath = MdModelUtil.genOptionValueQuoted(path, quoteCharacter);
                sb.append(quotedPath);
            } else {
                sb.append(path);
            }
            boolean bl2 = last_library = i + zero_based_count == total_packages;
            if (!last_library) {
                sb.append(' ');
            }
            ++packagesFound;
        }
        if (packagesFound > 1) {
            return "(" + sb.toString() + ")";
        }
        return sb.toString();
    }

    @Deprecated
    public static String getConnectionOptions(SASLibrary iMeta) throws MdException, RemoteException {
        StringBuilder retString = new StringBuilder("");
        SASClientConnection iDbms = iMeta.getLibraryConnection();
        if (iMeta.getEngine().equals("SASSPDS")) {
            DatabaseSchema iSchema = (DatabaseSchema)iMeta.getUsingPackages().get(0);
            retString.append(" schema=\"").append(iSchema.getSchemaName()).append("\"");
            Login iLogin = MdModelUtil.getBestLogin(iMeta);
            StringBuilder loginStr = new StringBuilder("");
            if (iLogin != null) {
                if (iLogin.getUserID() != null && iLogin.getUserID().length() != 0) {
                    loginStr.append(" USER=\"" + iLogin.getUserID() + "\"");
                }
                if (iLogin.getPassword() != null && iLogin.getPassword().length() != 0) {
                    String pass = iLogin.getPassword();
                    pass = MdModelUtil.encodePassword(pass);
                    loginStr.append(" PASSWORD=\"" + pass + "\" ");
                }
                retString.append((CharSequence)loginStr);
            }
        } else if (iMeta.getEngine().equalsIgnoreCase("FEDSVR")) {
            retString.append(MdModelUtil.processProperties(iMeta.getEngine(), iMeta.getProperties()));
            SAS9Generator libGen = new SAS9Generator(0);
            if (iDbms != null) {
                retString.append(libGen.processTableConnectionProperties(iDbms, iMeta));
            }
        }
        if (iDbms != null && iDbms.getProperties().size() > 0) {
            retString.append(MdModelUtil.processProperties(iMeta.getEngine(), iDbms.getProperties()));
        }
        return retString.toString();
    }

    @Deprecated
    public static Login getBestLogin(SASLibrary iMeta) throws MdException, RemoteException {
        AuthenticationDomain iDom;
        AssociationList lLogins = iMeta.getDefaultLogins(true);
        if (lLogins.size() > 0) {
            return (Login)lLogins.get(0);
        }
        SASClientConnection iDbms = iMeta.getLibraryConnection();
        if (iDbms != null && (iDom = iDbms.getDomain()) != null) {
            Login login = MdModelUtil.getLogin(iDom, iDom.getName());
            return login;
        }
        return null;
    }

    @Deprecated
    public static String getBestLoginString(Login iLogin, boolean b_encodePassword, boolean b_quotePassword) throws MdException, RemoteException {
        StringBuilder strBestLogin = new StringBuilder("");
        if (iLogin != null) {
            if (iLogin.getUserID() != null && iLogin.getUserID().length() != 0) {
                if (b_quotePassword) {
                    strBestLogin.append(" USER=\"" + iLogin.getUserID() + "\" ");
                } else {
                    strBestLogin.append(" USER=" + iLogin.getUserID() + " ");
                }
            }
            if (iLogin.getPassword() != null && iLogin.getPassword().length() != 0) {
                String pw = iLogin.getPassword();
                if (b_encodePassword) {
                    pw = MdModelUtil.encodePassword(pw);
                }
                strBestLogin.append(" PASSWORD=\"" + pw + "\" ");
            }
        }
        return strBestLogin.toString();
    }

    @Deprecated
    public static String getBestLoginString(Login iLogin, boolean b_encodePassword) throws MdException, RemoteException {
        return MdModelUtil.getBestLoginString(iLogin, b_encodePassword, false);
    }

    @Deprecated
    public static String getBestLoginString(Login iLogin) throws MdException, RemoteException {
        return MdModelUtil.getBestLoginString(iLogin, false);
    }

    public static PasswordAuthentication getPasswordAuthentication(String strUserID, String strPassword) {
        PasswordAuthentication credentials = new PasswordAuthentication(strUserID, strPassword.toCharArray());
        return credentials;
    }

    @Nullable
    public static PasswordAuthentication getCredential(MdFactory iMdFactory, String strAuthDomain, String strReposID) throws MdException, RemoteException {
        String metadataDomain;
        PasswordAuthentication credentials = null;
        MdOMRConnection iMdConn = iMdFactory.getConnection();
        Map<String, String> credMap = iMdConn.getCredentialMap();
        if (credMap != null && (metadataDomain = credMap.get("AuthenticationDomain")) != null && metadataDomain.toUpperCase().compareTo(strAuthDomain.toUpperCase()) == 0) {
            String userid = credMap.get("Username");
            String password = credMap.get("Password");
            credentials = new PasswordAuthentication(userid, password.toCharArray());
            MdModelUtil.produceLogMessage(iMdFactory, "DEBUG NOTE: Reusing cached metadata credentials - " + userid);
            return credentials;
        }
        MdObjectStore store = iMdFactory.createObjectStore(null, "Temporary Credential Store");
        Identity iIdentity = null;
        try {
            iIdentity = MdModelUtil.populateStoreWithIdentity(store);
        }
        catch (Exception e) {
            MdModelUtil.produceLogMessage(iMdFactory, "DEBUG NOTE: The following exception occurred retriving metadata. No credentials can be found.");
            MdUtil mdutil = iMdFactory.getUtil();
            mdutil.printStackTrace(e);
            return null;
        }
        AuthenticationDomain domain = null;
        if (strAuthDomain != null && strAuthDomain.length() > 0) {
            domain = MdModelUtil.getAuthDom(store, strAuthDomain, strReposID);
        }
        if (domain == null) {
            MdModelUtil.produceLogMessage(iMdFactory, "DEBUG NOTE: No AuthenticationDomain so no credentials can be found");
            return null;
        }
        AssociationList lLogins = domain.getLogins(false);
        Vector<Login> listOfLogins = new Vector<Login>();
        for (int i = 0; i < lLogins.size(); ++i) {
            Login iLogin = (Login)lLogins.get(i);
            String password = iLogin.getPassword();
            if (password != null && password.trim().compareTo("") != 0 && password.compareTo(BLOTTED_PASSWORD) != 0) {
                listOfLogins.add(iLogin);
                continue;
            }
            MdModelUtil.produceLogMessage(iMdFactory, "DEBUG NOTE: The following Login contains an invalid password: " + iLogin.getName());
        }
        if (listOfLogins.size() == 1) {
            Login iLogin = (Login)listOfLogins.get(0);
            credentials = MdModelUtil.getPasswordAuthentication(iLogin.getUserID(), iLogin.getPassword());
            MdModelUtil.produceLogMessage(iMdFactory, "DEBUG NOTE: The following Login was found in metadata: " + iLogin.getName());
        } else if (listOfLogins.size() > 1) {
            if (iIdentity == null) {
                MdModelUtil.produceLogMessage(iMdFactory, "DEBUG NOTE: More than one Login found in " + domain.getName() + " and no Identity exists, so none will be used");
            } else {
                MdModelUtil.produceLogMessage(iMdFactory, "DEBUG NOTE: More than one Login found in " + domain.getName() + " for " + iIdentity.getName() + " so none will be used");
            }
        }
        if (credentials == null) {
            MdModelUtil.produceLogMessage(iMdFactory, "DEBUG NOTE: No Login chosen in AuthDom: " + domain.getName());
        }
        store.dispose();
        return credentials;
    }

    public static String getReposID(String strObjectID) {
        return "A0000001." + strObjectID.substring(0, 8);
    }

    public static Login getLogin(Root obj, String domainName) throws MdException, RemoteException {
        String strObjID;
        String strReposID;
        MdObjectStore store = (MdObjectStore)obj.getObjectStore();
        MdFactory iMdFactory = store.getFactory();
        PasswordAuthentication pw = MdModelUtil.getCredential(iMdFactory, domainName, strReposID = MdModelUtil.getReposID(strObjID = obj.getId()));
        if (pw == null) {
            return null;
        }
        Login iLogin = (Login)iMdFactory.createComplexMetadataObject(store, null, "", "Login", strReposID.substring(strReposID.indexOf(46) + 1));
        iLogin.setUserID(pw.getUserName());
        iLogin.setPassword(new String(pw.getPassword()));
        store.removeElementFromChangeList(iLogin);
        return iLogin;
    }

    public static Login getLogin(LogicalServer ls, String domainName) throws MdException, RemoteException {
        return MdModelUtil.getLogin((Root)ls, domainName);
    }

    private static AuthenticationDomain getAuthDom(MdObjectStore store, String strAuthDomain, String strReposID) throws MdException, RemoteException {
        String strType = "AuthenticationDomain";
        int flags = 8320;
        String strXMLSelect = "<XMLSELECT search=\"AuthenticationDomain[@Name='" + strAuthDomain + "']\" />";
        MdFactory iMdFactory = store.getFactory();
        List authDomainsList = iMdFactory.getOMIUtil().getMetadataObjectsSubset(store, strReposID, strType, flags, strXMLSelect, true);
        AuthenticationDomain ad = MdModelUtil.getFirst(authDomainsList, null);
        return ad;
    }

    protected static Identity populateStoreWithIdentity(MdObjectStore store) throws MdException, RemoteException {
        MdFactory iMdFactory = store.getFactory();
        MdOMIUtil iMdUtil = iMdFactory.getOMIUtil();
        Identity iIdentity = iMdUtil.getIdentity(store);
        if (iIdentity != null) {
            String strTemplate = "<TEMPLATES><Person><IdentityGroups/><Logins/></Person><IdentityGroup><IdentityGroups/><Logins/></IdentityGroup><Login><Domain/></Login></TEMPLATES>";
            int flags = 8220;
            Vector<String> inSimpleAttr = new Vector<String>();
            Vector<String> inComplexAttr = new Vector<String>();
            iIdentity = (Identity)iMdUtil.getMetadataAllDepths(iIdentity, inSimpleAttr, inComplexAttr, strTemplate, flags);
        }
        String strOptions = "<XMLSELECT Search=\"*[@name='PUBLIC'";
        if (iIdentity != null) {
            strOptions = strOptions + " OR @name='SASUSERS'";
        }
        strOptions = strOptions + "]\"/>";
        String strTemplate = "<TEMPLATES><IdentityGroup><Logins/></IdentityGroup><Login><Domain/></Login></TEMPLATES>";
        int flags = 8588;
        iMdFactory.getOMIUtil().getMetadataObjectsSubset(store, iMdUtil.getFoundationReposID(), "IdentityGroup", flags, strOptions + strTemplate);
        return iIdentity;
    }

    private static String encodePassword(String strPassword) {
        String strNewPwString = strPassword;
        try {
            strNewPwString = SasPasswordString.encode((String)"sas002", (String)strPassword);
        }
        catch (SasPasswordEncodingException sasPasswordEncodingException) {
            // empty catch block
        }
        return strNewPwString;
    }

    private static void produceLogMessage(MdFactory iMdFactory, String message) throws RemoteException {
        MdUtil util = iMdFactory.getUtil();
        util.printOutputln(message);
    }

    private static PasswordAuthentication getDefaultLogin(SASLibrary iMeta, CredentialResolver resolver, String authDomStr) throws MdException, RemoteException {
        Login iLogin;
        String password;
        AssociationList lLogins;
        PasswordAuthentication pw = null;
        if (iMeta.getIsDBMSLibname() == 1 && (lLogins = iMeta.getDefaultLogins(true)).size() > 0 && (password = new String((pw = MdModelUtil.getPasswordAuthentication((iLogin = (Login)lLogins.get(0)).getUserID(), iLogin.getPassword())).getPassword())).contentEquals(BLOTTED_PASSWORD)) {
            pw = null;
            List<MdCredential> credentialList = resolver.requestCredentialList(authDomStr, true, null);
            int rowCount = credentialList == null ? 0 : credentialList.size();
            String username = iLogin.getUserID();
            for (int index = 0; pw == null && index < rowCount; ++index) {
                MdCredential credential = credentialList.get(index);
                String listUsername = credential.getUserid();
                if (!listUsername.equalsIgnoreCase(username)) continue;
                password = credential.getPassword();
                pw = MdModelUtil.getPasswordAuthentication(username, password);
            }
        }
        return pw;
    }

    static <T> T getFirst(Iterable<? extends T> iterable, @Nullable T defaultValue) {
        Iterator<T> i = iterable.iterator();
        T retValue = i.hasNext() ? i.next() : defaultValue;
        return retValue;
    }

    static {
        HashMap aMap = new HashMap();
        ArrayList<String> sashdat = new ArrayList<String>();
        sashdat.add("SERVER");
        sashdat.add("INSTALL");
        sashdat.add("SIGNER");
        aMap.put("SASHDAT", sashdat);
        ArrayList<String> hadoop = new ArrayList<String>();
        hadoop.add("SERVER");
        aMap.put("HADOOP", hadoop);
        VALID_CLIENTCONNECTION_OPTIONS = Collections.unmodifiableMap(aMap);
    }

    @SASScope
    public static class SAS9Generator
    extends LibnameGenerator {
        protected final boolean b_encodePassword;
        protected final boolean genFileNameForXML;
        protected final boolean ignorePreassigned;
        protected final boolean genAuthDomain;
        protected final boolean readonlyOverride;

        SAS9Generator(int flags) {
            this.b_encodePassword = (flags & 1) == 1;
            this.genFileNameForXML = (flags & 2) == 2;
            this.ignorePreassigned = (flags & 4) == 4;
            this.genAuthDomain = (flags & 8) == 8;
            this.readonlyOverride = (flags & 0x10) == 16;
        }

        @Nonnull
        public String genCredentials(SASLibrary iMeta, Connection c, boolean b_quoteUser, boolean b_quotePassword) throws MdException, RemoteException {
            Object temp;
            StringBuilder returnStr = new StringBuilder();
            Map<String, Object> map = c == null ? this.getCredentials(iMeta) : this.getCredentials(iMeta, c);
            PasswordAuthentication pw = null;
            String authD = null;
            if (map.containsKey("Domain") && (temp = map.get("Domain")) instanceof String) {
                authD = (String)temp;
            }
            if (map.containsKey("UserPass") && (temp = map.get("UserPass")) instanceof PasswordAuthentication) {
                pw = (PasswordAuthentication)temp;
            }
            boolean isIMLE = "SASIOIME".equalsIgnoreCase(iMeta.getEngine());
            if (authD != null) {
                returnStr.append(' ');
                if (isIMLE) {
                    returnStr.append("DOMAIN=");
                } else {
                    returnStr.append("AUTHDOMAIN=");
                }
                returnStr.append('\"' + authD + '\"' + ' ');
            }
            if (pw != null) {
                returnStr.append((CharSequence)this.getUserAndPassword(pw, b_quoteUser, b_quotePassword, isIMLE));
            }
            return returnStr.toString();
        }

        private StringBuilder getUserAndPassword(PasswordAuthentication pw, boolean isUserNameNeedingQuotes, boolean isPasswordNeedingQuotes, boolean isInfomapsEngine) {
            boolean isPasswordPresent;
            String userName = pw.getUserName();
            String password = new String(pw.getPassword());
            StringBuilder sb = new StringBuilder();
            boolean isUserNamePresent = userName != null && userName.length() > 0;
            boolean bl = isPasswordPresent = password != null && password.length() > 0;
            if (isUserNamePresent && isPasswordPresent) {
                if (this.b_encodePassword) {
                    password = MdModelUtil.encodePassword(password);
                }
                if (isInfomapsEngine) {
                    sb.append(' ');
                    sb.append(MdModelUtil.genOptionPairQuoted("MetaUser", "=", userName));
                    sb.append(' ');
                    sb.append(' ');
                    sb.append(MdModelUtil.genOptionPairQuoted("MetaPass", "=", password));
                    sb.append(' ');
                } else {
                    if (isUserNameNeedingQuotes) {
                        sb.append(' ');
                        sb.append(MdModelUtil.genOptionPairQuoted("USER", "=", userName));
                        sb.append(' ');
                    } else {
                        sb.append(' ');
                        sb.append(MdModelUtil.genOptionPair("USER", "=", userName));
                        sb.append(' ');
                    }
                    if (isPasswordNeedingQuotes) {
                        sb.append(' ');
                        sb.append(MdModelUtil.genOptionPairQuoted("PASSWORD", "=", password));
                        sb.append(' ');
                    } else {
                        sb.append(' ');
                        sb.append(MdModelUtil.genOptionPair("PASSWORD", "=", password));
                        sb.append(' ');
                    }
                }
            }
            return sb;
        }

        @Override
        @Nonnull
        public Map<String, Object> getCredentials(SASLibrary iMeta) throws MdException, RemoteException {
            PasswordAuthentication pw = this.getCredentials(iMeta, (Login)null);
            HashMap<String, Object> credMap = new HashMap<String, Object>(3);
            if (pw != null) {
                credMap.put("UserPass", pw);
            }
            return credMap;
        }

        @Override
        public boolean isCredentialPromptRequired(SASLibrary iMeta) throws MdException, RemoteException {
            return false;
        }

        @Nonnull
        protected Map<String, Object> getCredentials(SASLibrary iMeta, Connection iConn) throws MdException, RemoteException {
            MdObjectStore store;
            MdFactory iMdFactory;
            PasswordAuthentication pw;
            HashMap<String, Object> credMap = new HashMap<String, Object>(3);
            AuthenticationDomain iDom = iConn.getDomain();
            if (iDom != null && !this.isDB2OS390Library(iMeta) && (pw = MdModelUtil.getCredential(iMdFactory = (store = (MdObjectStore)iMeta.getObjectStore()).getFactory(), iDom.getName(), MdModelUtil.getReposID(iMeta.getId()))) != null) {
                credMap.put("UserPass", pw);
            }
            return credMap;
        }

        @Nullable
        protected PasswordAuthentication getCredentials(SASLibrary iMeta, Login iLogin) throws MdException, RemoteException {
            boolean needsCredentials;
            PasswordAuthentication pw = null;
            boolean bl = needsCredentials = !this.isDB2OS390Library(iMeta);
            if (needsCredentials) {
                String password;
                if (iLogin == null) {
                    iLogin = MdModelUtil.getBestLogin(iMeta);
                }
                if (iLogin != null && iLogin.getUserID() != null && (password = iLogin.getPassword()) != null && password.length() > 0) {
                    pw = MdModelUtil.getPasswordAuthentication(iLogin.getUserID(), password);
                }
            }
            return pw;
        }

        @Override
        protected String processInfomapProperties(SASLibrary iMeta) throws MdException, RemoteException {
            SASClientConnection iConn = iMeta.getLibraryConnection();
            String host = iConn.getRemoteAddress();
            int port = iConn.getPort();
            StringBuilder metaOptions = new StringBuilder();
            if (host != null) {
                metaOptions.append(MdModelUtil.genOptionPairQuoted("MetaServer", "=", host));
                metaOptions.append(' ');
            }
            if (port != 0) {
                metaOptions.append(MdModelUtil.genOptionPairUnquoted("MetaPort", "=", Integer.toString(port)));
                metaOptions.append(' ');
            }
            metaOptions.append(this.genCredentials(iMeta, iConn, true, true));
            return metaOptions.toString();
        }

        @Override
        protected String processContentServerPath(SASLibrary iLib, boolean genDAVOptions) throws MdException, RemoteException {
            StringBuilder sb = new StringBuilder();
            AssociationList packages = iLib.getUsingPackages();
            if (packages.size() > 1) {
                sb.append("(");
            }
            DeployedDataPackage temp = (DeployedDataPackage)iLib.getUsingPackages().get(0);
            Directory iDir = null;
            if (!(temp instanceof Directory)) {
                throw new MdException(bundle.getString("MdModelUtil.WebDAVPath.msg.txt"));
            }
            iDir = (Directory)temp;
            ServerComponent iContentServer = (ServerComponent)iDir.getDeployedComponents().get(0);
            TCPIPConnection iConn = (TCPIPConnection)iContentServer.getSourceConnections().get(0);
            String sHostName = iConn.getHostName();
            String sAppProtocol = iConn.getApplicationProtocol();
            int sPort = iConn.getPort();
            boolean supportsDAV = false;
            for (int i = 0; i < packages.size(); ++i) {
                iDir = (Directory)packages.get(i);
                AssociationList props = iDir.getProperties();
                for (int j = 0; j < props.size(); ++j) {
                    Property iProp = (Property)props.get(j);
                    if (!iProp.getPropertyName().equals("SupportsWebDAV") || !iProp.getDefaultValue().equals("1")) continue;
                    supportsDAV = true;
                }
                if (!supportsDAV) {
                    throw new MdException(bundle.getString("MdModelUtil.WebDAVPathType.msg.txt"));
                }
                String path = sAppProtocol + "://" + sHostName + ":" + sPort + iDir.getDirectoryName();
                if (MdModelUtil.isStringNeedingQuotes(path)) {
                    char quoteChar = MdModelUtil.getQuoteChar(path);
                    sb.append(quoteChar);
                    sb.append(path);
                    sb.append(quoteChar);
                    sb.append(' ');
                    continue;
                }
                sb.append(path);
                sb.append(' ');
            }
            if (packages.size() > 1) {
                sb.append(")");
            }
            if (supportsDAV && genDAVOptions) {
                this.processDAVOptions(iLib, sb, iConn);
            }
            return sb.toString();
        }

        private void processDAVOptions(SASLibrary iLib, StringBuilder returnStr, TCPIPConnection iConn) throws MdException, RemoteException {
            returnStr.append(" WEBDAV ");
            returnStr.append(this.genCredentials(iLib, iConn, true, true));
        }

        @Override
        @Nonnull
        public Map<String, String> genAssignLibrefMap(SASLibrary aLibrary, String aLibref) throws RemoteException, MdException {
            HashMap<String, String> libMap = new HashMap<String, String>(4);
            boolean isRemote = this.isRemoteEngineLibrary(aLibrary);
            boolean m_bHasContentServer = this.checkLib4ContentServer(aLibrary);
            File mapFile = null;
            String libref = this.processLibref(aLibrary, aLibref, false);
            libMap.put("Name", libref);
            String engine = aLibrary.getEngine() == null ? "" : aLibrary.getEngine();
            libMap.put("Engine", engine);
            String path = "";
            if (aLibrary.getIsDBMSLibname() == 0) {
                if (m_bHasContentServer) {
                    path = this.processContentServerPath(aLibrary, false);
                }
                if (aLibrary.getEngine().equalsIgnoreCase("XML") || aLibrary.getEngine().equalsIgnoreCase("XMLV2")) {
                    for (DeployedDataPackage iDDP : aLibrary.getUsingPackages()) {
                        if (!(iDDP instanceof File)) continue;
                        File tempfile = (File)iDDP;
                        if (tempfile.getTextRole().equalsIgnoreCase("XMLLibraryFile")) {
                            path = MdModelUtil.processPath(tempfile) + ' ';
                            continue;
                        }
                        if (!tempfile.getTextRole().equalsIgnoreCase("XMLLibraryMap")) continue;
                        mapFile = tempfile;
                    }
                } else if (aLibrary.getEngine().equalsIgnoreCase("JSON")) {
                    for (DeployedDataPackage iDDP : aLibrary.getUsingPackages()) {
                        if (!(iDDP instanceof File)) continue;
                        File tempfile = (File)iDDP;
                        if (tempfile.getTextRole().equalsIgnoreCase("JSONLibraryFile")) {
                            path = MdModelUtil.processPath(tempfile) + ' ';
                            continue;
                        }
                        if (!tempfile.getTextRole().equalsIgnoreCase("JSONLibraryMap")) continue;
                        mapFile = tempfile;
                    }
                } else {
                    path = MdModelUtil.processPath(aLibrary, false);
                }
            }
            libMap.put("Path", path);
            StringBuilder options = this.processOptions(aLibrary, isRemote, false, mapFile);
            libMap.put("Options", options.toString());
            return libMap;
        }

        @Override
        public String genConnectionOptions(SASLibrary iMeta) throws MdException, RemoteException {
            StringBuilder retString = new StringBuilder();
            SASClientConnection iDbms = iMeta.getLibraryConnection();
            SASLibraryConnectStatement engineConnection = SASLibraryConnectStatement.newInstance(this, iMeta);
            retString.append(engineConnection.getConnectionOptions(iMeta, iDbms));
            return retString.toString();
        }

        @Override
        public String genLibname(SASLibrary aLibrary) throws MdException, RemoteException {
            return this.genLibnameUsing(aLibrary, null);
        }

        @Override
        public String genLibnameUsing(SASLibrary iMeta, String aLibref) throws MdException, RemoteException {
            if (iMeta == null) {
                return "";
            }
            boolean isCas = "CAS".equalsIgnoreCase(iMeta.getEngine());
            boolean isRemote = this.isRemoteEngineLibrary(iMeta);
            StringBuilder libref = new StringBuilder();
            String m_OverrideLibref = aLibref;
            boolean hasFile = false;
            File xmlMapFile = null;
            if (!isRemote) {
                for (int i = 0; i < iMeta.getUsingPackages(true).size(); ++i) {
                    DeployedDataPackage iDDP = (DeployedDataPackage)iMeta.getUsingPackages().get(i);
                    if (iDDP instanceof SASLibrary) {
                        libref.append(this.genLibname((SASLibrary)iDDP));
                        continue;
                    }
                    if (!(iDDP instanceof File)) continue;
                    File ddpFile = (File)iDDP;
                    hasFile = true;
                    if (iMeta.getEngine().equalsIgnoreCase("XML") || iMeta.getEngine().equalsIgnoreCase("XMLV2")) {
                        if (this.genFileNameForXML && ddpFile.getTextRole().equalsIgnoreCase("XMLLibraryFile")) {
                            StringBuilder xmlFileName = this.getXmlFileNameStatement(iMeta, m_OverrideLibref, ddpFile);
                            libref.append((CharSequence)xmlFileName);
                            continue;
                        }
                        if (!ddpFile.getTextRole().equalsIgnoreCase("XMLLibraryMap")) continue;
                        xmlMapFile = ddpFile;
                        continue;
                    }
                    if (!iMeta.getEngine().equalsIgnoreCase("JSON")) continue;
                    if (ddpFile.getTextRole().equalsIgnoreCase("JSONLibraryFile")) {
                        StringBuilder jsonFileName = this.getJSONFileNameStatement(iMeta, m_OverrideLibref, ddpFile);
                        libref.append((CharSequence)jsonFileName);
                        continue;
                    }
                    if (!ddpFile.getTextRole().equalsIgnoreCase("JSONLibraryMap")) continue;
                    xmlMapFile = ddpFile;
                }
            }
            if (iMeta.getIsPreassigned() == 0 || this.ignorePreassigned) {
                StringBuilder sbCAS;
                boolean bGenCAS = false;
                if (isCas) {
                    bGenCAS = this.getGenerateCASStatement(iMeta);
                }
                if (isCas && bGenCAS && (sbCAS = this.getCASStatement(iMeta)) != null && sbCAS.length() > 0) {
                    String sessref = MdModelUtil.getSESSREF(iMeta);
                    libref.append("%macro etls_generateCASStatement(sessref); \n");
                    libref.append("  %if %sysfunc(sessfound(&sessref)) = 0 %then %do;\n");
                    libref.append((CharSequence)sbCAS);
                    libref.append("\n");
                    libref.append("  %end;\n");
                    libref.append("%mend;\n");
                    libref.append("%etls_generateCASStatement(").append(sessref).append(");\n");
                }
                libref.append("LIBNAME ");
                String temp = this.processLibref(iMeta, m_OverrideLibref, true);
                if (iMeta.getIsDBMSLibname() == 0 && !hasFile) {
                    boolean m_bHasContentServer = this.checkLib4ContentServer(iMeta);
                    temp = m_bHasContentServer ? temp + this.processContentServerPath(iMeta, true) : temp + MdModelUtil.processPath(iMeta, true);
                }
                libref.append(temp);
                StringBuilder options = this.processOptions(iMeta, isRemote, true, xmlMapFile);
                libref.append((CharSequence)options);
                if (this.readonlyOverride) {
                    libref.append(" ACCESS=READONLY");
                }
                libref.append(";\n");
            } else {
                libref.append("libname ").append(iMeta.getLibref()).append(" list;");
            }
            if (libref.toString().length() > 256) {
                String[] parts = libref.toString().split(" ");
                StringBuffer libBuffer = new StringBuffer();
                int lcount = 0;
                int x = 0;
                for (int i = 0; i < parts.length; ++i) {
                    x = parts[i].length();
                    if (x > 255) {
                        String[] sub = parts[i].split("(?<=;)");
                        if (sub.length > 0) {
                            for (int j = 0; j < sub.length; ++j) {
                                libBuffer.append(sub[j]);
                                libBuffer.append("\n");
                            }
                        }
                        lcount = 0;
                        continue;
                    }
                    if (x + lcount > 255) {
                        libBuffer.append("\n");
                        lcount = 0;
                    }
                    libBuffer.append(parts[i]);
                    if (i + 1 < parts.length) {
                        libBuffer.append(" ");
                    }
                    lcount += x + 1;
                }
                return libBuffer.toString();
            }
            return libref.toString();
        }

        private List<Property> getValidClientConnectionOptions(String engine, List<? extends Property> properties) throws RemoteException {
            ArrayList<Property> validProps = new ArrayList<Property>();
            if (VALID_CLIENTCONNECTION_OPTIONS.containsKey(engine)) {
                List connectionProps = (List)VALID_CLIENTCONNECTION_OPTIONS.get(engine);
                for (Property property : properties) {
                    if (!connectionProps.contains(property.getPropertyName())) continue;
                    validProps.add(property);
                }
                return validProps;
            }
            validProps.addAll(properties);
            return validProps;
        }

        private StringBuilder getXmlFileNameStatement(SASLibrary iMeta, String m_OverrideLibref, File xmlFile) throws RemoteException, MdException {
            StringBuilder sb = new StringBuilder();
            if (iMeta.getLibref().trim().length() <= 0) {
                throw new MdException(bundle.getString("MdModelUtil.noLibref.msg.txt"));
            }
            String libRefName = m_OverrideLibref != null ? m_OverrideLibref : iMeta.getLibref();
            sb.append("filename ");
            sb.append(' ');
            sb.append(libRefName);
            sb.append(' ');
            sb.append(MdModelUtil.processPath(xmlFile));
            sb.append(' ');
            sb.append(";");
            sb.append("\n");
            return sb;
        }

        private StringBuilder getJSONFileNameStatement(SASLibrary iMeta, String m_OverrideLibref, File jsonFile) throws RemoteException, MdException {
            StringBuilder sb = new StringBuilder();
            if (iMeta.getLibref().trim().length() > 0) {
                String libRefName = m_OverrideLibref != null ? m_OverrideLibref : iMeta.getLibref();
                sb.append("filename");
                sb.append(' ');
                sb.append(libRefName);
                sb.append(' ');
                sb.append(MdModelUtil.processPath(jsonFile));
                sb.append(' ');
                for (Property iProp : iMeta.getProperties()) {
                    String propertyName = iProp.getPropertyName();
                    String propertyValue = iProp.getDefaultValue();
                    if (!propertyName.equalsIgnoreCase("FilenameOptionString") || iProp.getUseValueOnly() == 0) continue;
                    sb.append(propertyValue);
                    sb.append(' ');
                }
            } else {
                throw new MdException(bundle.getString("MdModelUtil.noLibref.msg.txt"));
            }
            sb.append(";");
            sb.append("\n");
            return sb;
        }

        boolean getGenerateCASStatement(SASLibrary iMeta) throws RemoteException, MdException {
            String sessionRef = MdModelUtil.getSESSREF(iMeta);
            if (sessionRef == null || sessionRef.isEmpty()) {
                return false;
            }
            SASClientConnection iConn = iMeta.getLibraryConnection();
            if (iConn == null) {
                return false;
            }
            PropertySet ps = null;
            for (PropertySet pSet : (PropertySet[])iMeta.getPropertySets().toArray(new PropertySet[iMeta.getPropertySets().size()])) {
                if (pSet == null || !"CasStatement".equals(pSet.getPropertySetName())) continue;
                ps = pSet;
            }
            if (ps == null) {
                return false;
            }
            for (Property iProp : ps.getSetProperties()) {
                String propertyName = iProp.getPropertyName();
                if (!"GenerateCasStatement".equalsIgnoreCase(propertyName)) continue;
                return true;
            }
            return false;
        }

        private StringBuilder getCASStatement(SASLibrary iMeta) throws RemoteException, MdException {
            String sessionRef = MdModelUtil.getSESSREF(iMeta);
            if (sessionRef == null || sessionRef.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (iMeta.getLibref().trim().length() == 0) {
                throw new MdException(bundle.getString("MdModelUtil.noLibref.msg.txt"));
            }
            SASClientConnection iDbms = iMeta.getLibraryConnection();
            if (iDbms == null) {
                throw new MdException(bundle.getString("MdModelUtil.ConnectionRequired.msg.txt"));
            }
            sb.append("CAS ");
            for (Object iProp : iMeta.getProperties()) {
                String propertyName = iProp.getPropertyName();
                String propertyValue = iProp.getDefaultValue();
                if (!"SESSREF".equalsIgnoreCase(propertyName)) continue;
                sb.append(propertyValue).append(' ');
                break;
            }
            String authd = this.genCredentials(iMeta, null, false, true);
            sb.append(authd).append(' ');
            for (Property iProp : iDbms.getProperties()) {
                String propertyName = iProp.getPropertyName();
                String propertyValue = iProp.getDefaultValue();
                if (propertyName.equalsIgnoreCase("SERVER")) {
                    sb.append(MdModelUtil.genOptionPair("HOST", "=", propertyValue)).append(' ');
                    continue;
                }
                if (!propertyName.equalsIgnoreCase("PORT")) continue;
                sb.append(MdModelUtil.genOptionPair(propertyName, "=", propertyValue)).append(' ');
            }
            PropertySet ps = null;
            for (PropertySet pSet : (PropertySet[])iMeta.getPropertySets().toArray(new PropertySet[iMeta.getPropertySets().size()])) {
                if (pSet == null || !"CasStatement".equals(pSet.getPropertySetName())) continue;
                ps = pSet;
            }
            if (ps != null) {
                for (Property iProp : ps.getSetProperties()) {
                    String propertyName = iProp.getPropertyName();
                    String propertyValue = iProp.getDefaultValue();
                    if (!propertyName.equalsIgnoreCase("CasStatementOptions")) continue;
                    sb.append(propertyValue).append(' ');
                }
            }
            sb.append(";");
            return sb;
        }

        private StringBuilder processOptions(SASLibrary iMeta, boolean isRemote, boolean genDAVCredentials, File mapFile) throws RemoteException, MdException {
            StringBuilder builder = new StringBuilder();
            boolean isSPDS = iMeta.getEngine().equalsIgnoreCase("SASSPDS");
            boolean isTKTS = iMeta.getEngine().equalsIgnoreCase("FEDSVR");
            boolean isCas = iMeta.getEngine().equalsIgnoreCase("CAS");
            if (mapFile != null) {
                String keyword = mapFile.getTextRole().equalsIgnoreCase("JSONLibraryMap") ? "MAP" : "xmlmap";
                builder.append(' ').append(MdModelUtil.genOptionPair(keyword, "=", MdModelUtil.processPath(mapFile))).append(' ').append(' ');
            }
            if (iMeta.getProperties().size() > 0) {
                builder.append(MdModelUtil.processProperties(iMeta.getEngine(), iMeta.getProperties()));
            }
            if (iMeta.getIsDBMSLibname() > 0) {
                String pw;
                SASPassword sapw;
                boolean requiresCredentials = true;
                SASClientConnection iDbms = iMeta.getLibraryConnection();
                if (iDbms == null) {
                    throw new MdException(bundle.getString("MdModelUtil.ConnectionRequired.msg.txt"));
                }
                if (iMeta.getEngine().equalsIgnoreCase("FEDSVR")) {
                    builder.append(this.processTableConnectionProperties(iDbms, iMeta));
                } else if (iMeta.getEngine().equalsIgnoreCase("SASIOIME")) {
                    requiresCredentials = false;
                    builder.append(this.processInfomapProperties(iMeta));
                }
                if (iMeta.getEngine().equalsIgnoreCase("SASIOLA")) {
                    builder.append(this.processLasrConnectionProperties(iDbms, iMeta));
                }
                if (iMeta.getEngine().equalsIgnoreCase("HADOOP")) {
                    builder.append(this.processHadoopConnectionProperties(iDbms, iMeta));
                }
                if (iMeta.getEngine().equalsIgnoreCase("POSTGRES")) {
                    builder.append(this.processPostgresConnectionProperties(iDbms, iMeta));
                }
                if (isCas) {
                    if (iDbms.getProperties().size() > 0 && !this.getGenerateCASStatement(iMeta)) {
                        builder.append(MdModelUtil.processProperties(iMeta.getEngine(), this.getValidClientConnectionOptions(iMeta.getEngine(), iDbms.getProperties())));
                    }
                    return builder;
                }
                if (iDbms.getProperties().size() > 0) {
                    builder.append(MdModelUtil.processProperties(iMeta.getEngine(), this.getValidClientConnectionOptions(iMeta.getEngine(), iDbms.getProperties())));
                }
                DeployedDataPackage iPkg = this.getDeployedDataPackage(iMeta);
                DatabaseSchema iSchema = this.getSchema(iPkg);
                builder.append(this.getSchemaOption(isSPDS, iSchema));
                SASLibrary iServerLibrary = null;
                if (iPkg instanceof SASLibrary && isRemote) {
                    iServerLibrary = (SASLibrary)iPkg;
                }
                if (iServerLibrary == null && iSchema == null) {
                    throw new MdException(bundle.getString("MdModelUtil.InvalidDataPackageType.msg.txt"));
                }
                if (iServerLibrary != null) {
                    builder.append(MdModelUtil.genOptionPair("slibref", "=", iServerLibrary.getLibref()));
                    builder.append(" ");
                }
                if (isRemote && (sapw = iDbms.getSAPW()) != null && (pw = sapw.getPassword()) != null && !pw.isEmpty()) {
                    if (this.b_encodePassword) {
                        pw = MdModelUtil.encodePassword(pw);
                    }
                    builder.append(MdModelUtil.genOptionPairQuoted("sapw", "=", pw));
                    builder.append(" ");
                }
                if (requiresCredentials && !isTKTS && !isSPDS && !isRemote) {
                    builder.append(this.genCredentials(iMeta, null, false, true));
                } else if (requiresCredentials && (isTKTS || isSPDS || isRemote)) {
                    builder.append(this.genCredentials(iMeta, null, true, true));
                }
            }
            return builder;
        }

        String getSchemaOption(boolean isSpdsEngine, DatabaseSchema iSchema) throws RemoteException {
            String optionValue;
            StringBuilder optionPairString = new StringBuilder();
            if (iSchema != null && (optionValue = iSchema.getSchemaName()) != null && optionValue.length() > 0) {
                String optionName = " SCHEMA";
                String delimiter = "=";
                String optionString = isSpdsEngine ? MdModelUtil.genOptionPairQuoted(" SCHEMA", "=", optionValue) : MdModelUtil.genOptionPair(" SCHEMA", "=", optionValue);
                optionPairString.append(optionString);
                optionPairString.append(' ');
            }
            return optionPairString.toString();
        }

        DatabaseSchema getSchema(DeployedDataPackage iPkg) {
            DatabaseSchema iSchema = null;
            if (iPkg instanceof DatabaseSchema) {
                iSchema = (DatabaseSchema)iPkg;
            }
            return iSchema;
        }

        DeployedDataPackage getDeployedDataPackage(SASLibrary iMeta) throws RemoteException, MdException {
            DeployedDataPackage iPkg = null;
            if (iMeta.getUsingPackages().size() <= 0) {
                throw new MdException(bundle.getString("MdModelUtil.NoAssociatedDataPackages.msg.txt"));
            }
            boolean onlyPackage = false;
            iPkg = (DeployedDataPackage)iMeta.getUsingPackages().get(0);
            return iPkg;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nonnull
        private String processLibref(SASLibrary iMeta, String m_OverrideLibref, boolean genEngineName) throws RemoteException, MdException {
            StringBuilder temp = new StringBuilder();
            if (m_OverrideLibref == null) {
                if (iMeta.getLibref().trim().compareTo("") == 0) throw new MdException(bundle.getString("MdModelUtil.noLibref.msg.txt"));
                if (genEngineName) {
                    temp.append(iMeta.getLibref() + " ");
                } else {
                    temp.append(iMeta.getLibref());
                }
            } else if (genEngineName) {
                temp.append(m_OverrideLibref + " ");
            } else {
                temp.append(m_OverrideLibref);
            }
            if (iMeta.getEngine().trim().compareTo("") == 0 || !genEngineName) return temp.toString();
            temp.append(iMeta.getEngine() + " ");
            return temp.toString();
        }
    }

    @SASScope
    public static class PromptingGenerator
    extends SAS9Generator {
        public static final int NONE = -1;
        public static final int USERPASSWORD = -2;
        public static final int PROMPTFOR = -3;
        public static final int UNKNOWN = -4;
        private final CredentialResolver resolver;
        private final String prompt;

        PromptingGenerator(int flags, CredentialResolver r, String p) {
            super(flags);
            this.resolver = r;
            this.prompt = p;
        }

        private LogicalServer getLogicalServer(DeployedComponent dc, String classID) throws MdException, RemoteException {
            AssociationList usedByList = dc.getUsedByComponents();
            Iterator usedByIt = usedByList.iterator();
            LogicalServer retVal = null;
            boolean serverFound = false;
            while (usedByIt.hasNext() && !serverFound) {
                DeployedComponent usingDc = (DeployedComponent)usedByIt.next();
                if (!(usingDc instanceof LogicalServer) || !usingDc.getClassIdentifier().equalsIgnoreCase(classID)) continue;
                retVal = (LogicalServer)usingDc;
                serverFound = true;
            }
            return retVal;
        }

        public int resolveAuthType(Connection c, MdFactory factory) throws MdException, RemoteException {
            DeployedComponent dc = c.getSource();
            int authType = -4;
            if (dc.getProductName().equalsIgnoreCase("FEDSVR")) {
                LogicalServer ls = this.getLogicalServer(dc, "E803E04B-AAF0-4C74-86A6-F7008AA702DC");
                if (ls != null) {
                    String template = "<Templates><LogicalServer><Properties search=\"@PropertyName='AuthService' OR @PropertyName='SecurityPackage'\"/></LogicalServer></Templates>";
                    int flags = 268;
                    factory.getOMIUtil().getMetadataAllDepths(ls, null, null, template, flags);
                    AssociationList propList = ls.getProperties(false);
                    Iterator propIt = propList.iterator();
                    String authService = null;
                    boolean hasSecurityPackage = false;
                    while (propIt.hasNext()) {
                        Property p = (Property)propIt.next();
                        if (p.getPropertyName().equalsIgnoreCase("AuthService")) {
                            authService = p.getDefaultValue();
                            continue;
                        }
                        if (!p.getPropertyName().equalsIgnoreCase("SecurityPackage")) continue;
                        hasSecurityPackage = true;
                    }
                    authType = authService != null ? (authService.equalsIgnoreCase("Metadata") ? -1 : (authService.equalsIgnoreCase("Prompt") ? -3 : (authService.equalsIgnoreCase("Host") ? (hasSecurityPackage ? -1 : -2) : -4))) : -2;
                }
            } else {
                String cAuthType = c.getAuthenticationType();
                authType = cAuthType.equalsIgnoreCase("none") ? -1 : (cAuthType.equalsIgnoreCase("user/password") ? -2 : (cAuthType.equalsIgnoreCase("prompt") ? -3 : -4));
            }
            return authType;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @Nonnull
        public Map<String, Object> getCredentials(SASLibrary iMeta) throws MdException, RemoteException {
            Connection conn = null;
            HashMap<String, Object> credMap = new HashMap<String, Object>();
            if (iMeta.getIsDBMSLibname() == 0) {
                boolean hasContentServer = this.checkLib4ContentServer(iMeta);
                if (hasContentServer) {
                    DeployedDataPackage temp = (DeployedDataPackage)iMeta.getUsingPackages().get(0);
                    if (!(temp instanceof Directory)) throw new MdException(bundle.getString("MdModelUtil.WebDAVPath.msg.txt"));
                    Directory iDir = (Directory)temp;
                    ServerComponent iContentServer = (ServerComponent)iDir.getDeployedComponents().get(0);
                    conn = (Connection)iContentServer.getSourceConnections().get(0);
                }
            } else {
                conn = iMeta.getLibraryConnection();
            }
            if (conn == null) return credMap;
            credMap.putAll(this.getCredentials(iMeta, conn));
            return credMap;
        }

        @Override
        public boolean isCredentialPromptRequired(SASLibrary iMeta) throws MdException, RemoteException {
            boolean requiresCredentials = false;
            if (iMeta.getIsDBMSLibname() > 0) {
                requiresCredentials = true;
                SASClientConnection iDbms = iMeta.getLibraryConnection();
                if (iDbms == null) {
                    throw new MdException(bundle.getString("MdModelUtil.ConnectionRequired.msg.txt"));
                }
                if (iMeta.getEngine().equalsIgnoreCase("SASIOIME")) {
                    requiresCredentials = false;
                }
                boolean isRemote = this.isRemoteEngineLibrary(iMeta);
                boolean isSPDS = false;
                boolean isTKTS = false;
                if (iMeta.getEngine().equalsIgnoreCase("SASSPDS")) {
                    isSPDS = true;
                } else if (iMeta.getEngine().equalsIgnoreCase("FEDSVR")) {
                    isTKTS = true;
                }
                if (requiresCredentials && !isTKTS && !isSPDS && !isRemote) {
                    requiresCredentials = true;
                } else if (requiresCredentials && (isTKTS || isSPDS || isRemote)) {
                    requiresCredentials = true;
                }
            }
            if (!requiresCredentials) {
                return false;
            }
            PasswordAuthentication pw = null;
            String authDomStr = null;
            boolean needsCredentials = !this.isDB2OS390Library(iMeta);
            Connection iConn = null;
            if (iMeta.getIsDBMSLibname() == 0) {
                boolean m_bHasContentServer = this.checkLib4ContentServer(iMeta);
                if (m_bHasContentServer) {
                    DeployedDataPackage temp = (DeployedDataPackage)iMeta.getUsingPackages().get(0);
                    Directory iDir = null;
                    if (!(temp instanceof Directory)) {
                        throw new MdException(bundle.getString("MdModelUtil.WebDAVPath.msg.txt"));
                    }
                    iDir = (Directory)temp;
                    ServerComponent iContentServer = (ServerComponent)iDir.getDeployedComponents().get(0);
                    iConn = (Connection)iContentServer.getSourceConnections().get(0);
                }
            } else {
                iConn = iMeta.getLibraryConnection();
            }
            if (needsCredentials && this.isLocalTKTSLibrary(iMeta)) {
                return false;
            }
            if (needsCredentials) {
                AuthenticationDomain iDom = iConn.getDomain();
                MdObjectStore store = (MdObjectStore)iMeta.getObjectStore();
                MdFactory factory = store.getFactory();
                int authType = this.resolveAuthType(iConn, factory);
                switch (authType) {
                    case -3: 
                    case -2: {
                        if (iDom != null) {
                            authDomStr = iDom.getName();
                        }
                        if (this.genAuthDomain || (pw = MdModelUtil.getDefaultLogin(iMeta, this.resolver, authDomStr)) != null || this.resolver == null || authDomStr == null || authDomStr.length() <= 0) break;
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        @Nonnull
        protected Map<String, Object> getCredentials(SASLibrary iMeta, Connection iConn) throws MdException, RemoteException {
            boolean needsCredentials = !this.isDB2OS390Library(iMeta);
            boolean isCasLibname = "CAS".equalsIgnoreCase(iMeta.getEngine());
            HashMap<String, Object> credMap = new HashMap<String, Object>(3);
            if (needsCredentials && this.isLocalTKTSLibrary(iMeta)) {
                needsCredentials = false;
            }
            String authDomStr = null;
            PasswordAuthentication pw = null;
            if (needsCredentials) {
                AuthenticationDomain iDom = iConn.getDomain();
                MdObjectStore store = (MdObjectStore)iMeta.getObjectStore();
                MdFactory factory = store.getFactory();
                int authType = this.resolveAuthType(iConn, factory);
                switch (authType) {
                    case -1: {
                        needsCredentials = false;
                        break;
                    }
                    case -3: 
                    case -2: {
                        if (iDom != null) {
                            authDomStr = iDom.getName();
                        }
                        if (this.genAuthDomain || isCasLibname) break;
                        pw = MdModelUtil.getDefaultLogin(iMeta, this.resolver, authDomStr);
                        if (pw == null) {
                            if (this.resolver != null) {
                                MdCredential cred;
                                if (authDomStr != null && authDomStr.length() > 0 && (cred = this.resolver.requestCredentials(authDomStr, true, this.prompt)) != null) {
                                    pw = MdModelUtil.getPasswordAuthentication(cred.getUserid(), cred.getPassword());
                                }
                            } else {
                                pw = super.getCredentials(iMeta, (Login)null);
                            }
                        }
                        if (pw == null) {
                            authDomStr = null;
                            break;
                        }
                        if (iMeta.getEngine().equalsIgnoreCase("SASIOIME")) break;
                        authDomStr = null;
                        break;
                    }
                    default: {
                        pw = super.getCredentials(iMeta, (Login)null);
                    }
                }
            }
            if (needsCredentials) {
                if (this.genAuthDomain || isCasLibname) {
                    if (authDomStr != null) {
                        credMap.put("Domain", authDomStr);
                    }
                } else {
                    if (pw != null) {
                        credMap.put("UserPass", pw);
                    }
                    if (authDomStr != null) {
                        credMap.put("Domain", authDomStr);
                    }
                }
            }
            return credMap;
        }
    }

    @SASScope
    public static abstract class LibnameGenerator
    implements MdLibGenInterface {
        public static final String CLASSID_TABLESERVER = "E803E04B-AAF0-4C74-86A6-F7008AA702DC";
        public static final String USER_PASS_KEY = "UserPass";
        public static final String AUTHDOM_KEY = "Domain";
        public static final String DSN_USER_PASS_KEY = "DsnUserPass";
        public static final int CREDMAP_SIZE = 3;

        protected abstract String processInfomapProperties(SASLibrary var1) throws MdException, RemoteException;

        protected abstract String processContentServerPath(SASLibrary var1, boolean var2) throws MdException, RemoteException;

        protected String processTableConnectionProperties(SASClientConnection conn, SASLibrary iMeta) throws MdException, RemoteException {
            StringBuilder sb = new StringBuilder();
            if (!conn.getApplicationProtocol().equalsIgnoreCase("TKTS")) {
                return sb.toString();
            }
            if (conn.getCommunicationProtocol().equalsIgnoreCase("LOCAL")) {
                String optionValue = conn.getSource().getFQID();
                String tsidString = MdModelUtil.genOptionPairQuoted("TSID", "=", optionValue);
                sb.append(" ").append(tsidString);
                return sb.toString();
            }
            String optionValue = conn.getRemoteAddress();
            String serverString = MdModelUtil.genOptionPairQuoted("SERVER", "=", optionValue);
            sb.append(" ").append(serverString);
            if (conn.getCommunicationProtocol().equalsIgnoreCase("TCP")) {
                optionValue = String.valueOf(conn.getPort());
                String portString = MdModelUtil.genOptionPair("PORT", "=", optionValue);
                sb.append(" ").append(portString);
            }
            if (conn.getService().length() > 0) {
                optionValue = conn.getService();
                String serviceString = MdModelUtil.genOptionPair("SERVICE", "=", optionValue);
                sb.append(" ").append(serviceString);
            }
            return sb.toString();
        }

        protected String processHadoopConnectionProperties(SASClientConnection conn, SASLibrary iMeta) throws MdException, RemoteException {
            StringBuilder sb = new StringBuilder();
            if ("HadoopProtocol".equalsIgnoreCase(conn.getApplicationProtocol()) && "TCP".equalsIgnoreCase(conn.getCommunicationProtocol())) {
                int port = conn.getPort();
                if (port > 0) {
                    sb.append(" PORT=").append(String.valueOf(port));
                } else {
                    AssociationList props = conn.getProperties();
                    for (Property p : props) {
                        if (!"PORT".equalsIgnoreCase(p.getPropertyName())) continue;
                        sb.append(" PORT=").append(p.getDefaultValue());
                        break;
                    }
                }
            }
            return sb.toString();
        }

        protected String processPostgresConnectionProperties(SASClientConnection conn, SASLibrary iMeta) throws MdException, RemoteException {
            StringBuilder sb = new StringBuilder();
            int port = conn.getPort();
            if (port > 0) {
                sb.append(" PORT=").append(String.valueOf(port));
            }
            return sb.toString();
        }

        protected String processLasrConnectionProperties(SASClientConnection conn, SASLibrary iMeta) throws MdException, RemoteException {
            StringBuilder retString = new StringBuilder();
            if (!conn.getApplicationProtocol().equalsIgnoreCase("LASRProtocol")) {
                return retString.toString();
            }
            if (conn.getCommunicationProtocol().equalsIgnoreCase("TCP") && conn.getPort() > 0) {
                retString.append(" PORT=" + String.valueOf(conn.getPort()));
            }
            return retString.toString();
        }

        protected boolean isRemoteEngineLibrary(SASLibrary iMeta) throws RemoteException {
            boolean isRemote = false;
            if (iMeta.getEngine().toUpperCase().startsWith("REMOTE") && iMeta.getIsDBMSLibname() > 0) {
                isRemote = true;
            }
            return isRemote;
        }

        protected boolean isDB2OS390Library(SASLibrary iMeta) {
            boolean isDB2OS390 = false;
            try {
                SASClientConnection iConn;
                ServerComponent sc;
                String productName;
                if (iMeta.getIsDBMSLibname() > 0 && (productName = (sc = (ServerComponent)(iConn = iMeta.getLibraryConnection()).getSource()).getProductName()).equals("DB2OS390")) {
                    isDB2OS390 = true;
                }
            }
            catch (Exception e) {
                isDB2OS390 = false;
            }
            return isDB2OS390;
        }

        protected boolean isLocalTKTSLibrary(SASLibrary iMeta) throws RemoteException, MdException {
            SASClientConnection conn;
            boolean isLocalTKTS = false;
            if (iMeta.getIsDBMSLibname() > 0 && iMeta.getEngine().equalsIgnoreCase("FEDSVR") && (conn = iMeta.getLibraryConnection()).getApplicationProtocol().equalsIgnoreCase("TKTS") && conn.getCommunicationProtocol().equalsIgnoreCase("LOCAL")) {
                isLocalTKTS = true;
            }
            return isLocalTKTS;
        }

        protected boolean checkLib4ContentServer(SASLibrary iMeta) throws RemoteException, MdException {
            ServerComponent iContentServer;
            AssociationList lContentServers;
            boolean m_bHasContentServer = false;
            AssociationList lDDP = iMeta.getUsingPackages();
            if (lDDP.size() > 0 && (lContentServers = ((DeployedDataPackage)lDDP.get(0)).getDeployedComponents()).size() > 0 && ((iContentServer = (ServerComponent)lContentServers.get(0)).getProductName().equals("Http Server") || iContentServer.getProductName().equals("Ftp Server"))) {
                m_bHasContentServer = true;
            }
            return m_bHasContentServer;
        }
    }
}

