/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.remote;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdConnectionListener;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryCache;
import com.sas.metadata.remote.MdFactoryCacheImpl;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMIUtilImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdOMRConnectionImpl;
import com.sas.metadata.remote.MdObjectBase;
import com.sas.metadata.remote.MdObjectFactoryListener;
import com.sas.metadata.remote.MdObjectListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdObjectStoreImpl;
import com.sas.metadata.remote.MdRepositoryUtil;
import com.sas.metadata.remote.MdRepositoryUtilImpl;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.MdSecurityUtilImpl;
import com.sas.metadata.remote.MdServerStore;
import com.sas.metadata.remote.MdServerStoreImpl;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreUtil;
import com.sas.metadata.remote.MdUtil;
import com.sas.metadata.remote.MdUtilImpl;
import com.sas.metadata.remote.MetadataResource;
import com.sas.metadata.remote.Root;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.EventListenerList;

@SASScope(value="ALL")
public class MdFactoryImpl
implements MdFactory {
    static final long serialVersionUID = -2035013307081566056L;
    @SASScope
    protected static MetadataResource bundle = new MetadataResource(MdFactoryImpl.class);
    @SASScope
    protected int newID;
    @SASScope
    protected EventListenerList MdObjectFactoryListenerList = new EventListenerList();
    protected EventListenerList MdFactoryListenerList = new EventListenerList();
    private Map<MdFactoryListener, String[]> _factoryListenerCache;
    private MdFactoryImpl m_MdFactoryInstance = null;
    @SASScope
    protected MdServerStore m_MdServerStore = null;
    @SASScope
    protected String m_impl_package = "com.sas.metadata.remote.impl.";
    @SASScope
    protected String m_impl_extension = "Impl";
    @SASScope
    protected boolean m_changeManagementEnabled = false;
    @SASScope
    protected boolean m_bInDebug = false;
    @SASScope
    protected boolean m_bInPerf = false;
    @SASScope
    protected boolean m_bLoggingEnabled = false;
    private static Map<String, Class<?>> class_map = new HashMap(100);
    protected MdOMRConnection m_connection = null;
    protected MdConnectionListener m_connectionListener = null;
    protected MdOMIUtil m_OMIUtil = null;
    protected MdUtil m_Util = null;
    protected MdRepositoryUtil _reposUtil;
    protected MdSecurityUtil _securityUtil;
    protected int m_ParsingType = 0;
    protected boolean _removeDependentObjects = true;
    protected boolean _formatDates = true;
    private boolean _remoteEnvironment = true;
    private MdFactoryCache _factoryCache;
    private int _storeCounter = 0;
    private int _storeAutoCreatedCount = 0;

    public MdFactoryImpl() throws RemoteException, MdException {
        this(true);
    }

    public MdFactoryImpl(boolean remoteEnvironment) throws RemoteException, MdException {
        this._remoteEnvironment = remoteEnvironment;
        this.newID = 0;
        this.m_MdFactoryInstance = this;
        this.m_connection = new MdOMRConnectionImpl(this.m_MdFactoryInstance);
        this.m_Util = new MdUtilImpl(this);
        this.m_OMIUtil = new MdOMIUtilImpl(this.m_MdFactoryInstance, this.m_connection, this.m_Util);
        this.m_MdServerStore = new MdServerStoreImpl(this.m_MdFactoryInstance, null);
        String retVal = System.getProperty("com.sas.metadata.parser");
        if (retVal != null) {
            if (retVal.equalsIgnoreCase("SAX")) {
                this.m_ParsingType = 0;
                this.m_Util.printOutputln("JOMA Parsing Type: SAX");
            } else if (retVal.equalsIgnoreCase("DOM")) {
                this.m_Util.printOutputln("JOMA Parsing Type: DOM");
                this.m_ParsingType = 1;
            }
        }
        if (this._remoteEnvironment) {
            this.m_Util.printOutputln("JOMA - In Remote Environment");
            UnicastRemoteObject.exportObject(this);
        } else {
            this.m_Util.printOutputln("JOMA - In Local Environment");
        }
    }

    @Override
    public boolean isRemoteEnvironment() throws RemoteException {
        return this._remoteEnvironment;
    }

    @Override
    public void makeConnection(String protocol, String host, String port, String username, String password) throws MdException {
        try {
            this.m_connection.makeOMRConnection(host, port, username, password);
        }
        catch (RemoteException e) {
            throw new MdException(e);
        }
    }

    @Override
    public void makeConnection2(String host, String port, String username, String password) throws MdException {
        try {
            this.m_connection.makeOMRConnection(host, port, username, password);
        }
        catch (RemoteException e) {
            throw new MdException(e);
        }
    }

    @Override
    public void closeConnection() throws RemoteException {
        this.m_connection.closeOMRConnection();
    }

    @Override
    public void makeOMRConnection(String host, String port, String username, String password) throws MdException {
        try {
            this.m_connection.makeOMRConnection(host, port, username, password);
        }
        catch (RemoteException e) {
            throw new MdException(e);
        }
    }

    @Override
    public void closeOMRConnection() throws RemoteException {
        this.m_connection.closeOMRConnection();
    }

    @Override
    public int getMdFactoryType() {
        return 1;
    }

    @Override
    public boolean getDebug() throws RemoteException {
        return this.m_bInDebug;
    }

    @Override
    public void setDebug(boolean instate) throws RemoteException {
        this.m_bInDebug = instate;
    }

    @Override
    public boolean getLoggingEnabled() throws RemoteException {
        return this.m_bLoggingEnabled;
    }

    @Override
    public void setLoggingEnabled(boolean instate) throws RemoteException {
        this.m_bLoggingEnabled = instate;
    }

    @Override
    public boolean getPerf() throws RemoteException {
        return this.m_bInPerf;
    }

    @Override
    public void setPerf(boolean instate) throws RemoteException {
        this.m_bInPerf = instate;
    }

    @Override
    public MdUtil getUtil() {
        return this.m_Util;
    }

    @Override
    public MdRepositoryUtil getRepositoryUtil() throws RemoteException {
        if (this._reposUtil == null) {
            this._reposUtil = new MdRepositoryUtilImpl(this);
        }
        return this._reposUtil;
    }

    @Override
    public MdSecurityUtil getSecurityUtil() throws RemoteException {
        if (this._securityUtil == null) {
            this._securityUtil = new MdSecurityUtilImpl(this);
        }
        return this._securityUtil;
    }

    @Override
    @SASScope
    public MdFactoryCache getFactoryCache() throws RemoteException {
        if (this._factoryCache == null) {
            this._factoryCache = new MdFactoryCacheImpl(this);
        }
        return this._factoryCache;
    }

    @Override
    public MdFactory getInstance() {
        return this.m_MdFactoryInstance;
    }

    @Override
    public int getParsingType() throws RemoteException {
        return this.m_ParsingType;
    }

    @Override
    public void setParsingType(int parsing) throws RemoteException {
        this.m_ParsingType = parsing;
    }

    @Override
    public MdOMIUtil getOMIUtil() {
        return this.m_OMIUtil;
    }

    @Override
    public MdOMRConnection getConnection() {
        return this.m_connection;
    }

    @Override
    public boolean getChangeManagementEnabled() {
        return this.m_changeManagementEnabled;
    }

    @Override
    public void setChangeManagementEnabled(boolean enabled) throws RemoteException {
        this.m_changeManagementEnabled = enabled;
    }

    @Override
    public void setRemoveDependentObjects(boolean remove) throws RemoteException {
        this._removeDependentObjects = remove;
    }

    @Override
    public boolean getRemoveDependentObjects() throws RemoteException {
        return this._removeDependentObjects;
    }

    @Override
    public void setUseServerFormattedDates(boolean format) throws RemoteException {
        this._formatDates = format;
    }

    @Override
    public boolean getUseServerFormattedDates() throws RemoteException {
        return this._formatDates;
    }

    @Override
    public Map<String, CMetadata> getSimpleObjectMap() throws RemoteException {
        return this.m_MdServerStore.getSimpleObjectMap();
    }

    @Override
    public Map<String, CMetadata> getDetailObjectMap() throws RemoteException {
        return this.m_MdServerStore.getDetailObjectMap();
    }

    @Override
    public MdServerStore getStore() {
        return this.m_MdServerStore;
    }

    protected MdServerStore getServerStore() {
        return this.m_MdServerStore;
    }

    @Override
    public MdObjectStore createObjectStore() throws RemoteException {
        return this.createObjectStore(null, null);
    }

    @Override
    public MdObjectStore createObjectStore(MdStore parentStore) throws RemoteException {
        return this.createObjectStore(parentStore, null);
    }

    @Override
    public MdObjectStore createObjectStore(MdStore parentStore, String storeName) throws RemoteException {
        return new MdObjectStoreImpl(parentStore == null ? this.m_MdServerStore : parentStore, this.m_MdFactoryInstance, storeName, this._storeCounter++);
    }

    @Override
    public CMetadata createSimpleMetadataObject(CMetadata inObject) throws RemoteException {
        return this.createSimpleMetadataObject(inObject.getName(), inObject.getCMetadataType(), inObject.getFQID());
    }

    @Override
    public CMetadata createSimpleMetadataObject(CMetadata inObject, String lockedBy) throws RemoteException {
        Root returnObject = (Root)this.createSimpleMetadataObject(inObject);
        if (returnObject != null) {
            returnObject.setLockedBy(lockedBy);
        }
        return returnObject;
    }

    @Override
    public CMetadata createSimpleMetadataObject(String strName, String strType, String strFQID, String lockedBy) throws RemoteException {
        Root returnObject = (Root)this.createSimpleMetadataObject(strName, strType, strFQID);
        if (returnObject != null) {
            returnObject.setLockedBy(lockedBy);
        }
        return returnObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMetadata createSimpleMetadataObject(String strName, String strType, String strFQID) throws RemoteException {
        Map<String, CMetadata> objectMap = this.m_MdServerStore.getSimpleObjectMap();
        CMetadata cMetaObject = null;
        Map<String, CMetadata> map = objectMap;
        synchronized (map) {
            if (strFQID.length() < 9) {
                strFQID = this.makeID(strFQID);
            }
            try {
                cMetaObject = this.loadClassInstance("Root");
                if (cMetaObject != null) {
                    if (this._remoteEnvironment) {
                        UnicastRemoteObject.exportObject(cMetaObject);
                    }
                    cMetaObject.setCMetadataType(strType);
                    cMetaObject.setFQID(strFQID);
                    cMetaObject.setName(strName, 2);
                }
            }
            catch (Exception e) {
                this.m_Util.printOutputln(e.toString());
                return cMetaObject;
            }
            CMetadata tempHashObject = objectMap.get(strFQID);
            if (tempHashObject == null) {
                objectMap.put(strFQID, cMetaObject);
                ArrayList<String> items = new ArrayList<String>(1);
                items.add(strFQID);
            }
        }
        return cMetaObject;
    }

    @Override
    public CMetadata createComplexMetadataObject(MdObjectStore oStore, CMetadata oSimple) throws RemoteException {
        return this.createComplexMetadataObject(oStore, null, oSimple.getName(), oSimple.getCMetadataType(), oSimple.getFQID(), null);
    }

    @Override
    public CMetadata createComplexMetadataObject(MdObjectStore oStore, String strName, String strType, String strFQID) throws RemoteException {
        return this.createComplexMetadataObject(oStore, null, strName, strType, strFQID, null);
    }

    @Override
    public CMetadata createComplexMetadataObject(MdObjectStore inStore, MdStore parentStore, CMetadata oSimple) throws RemoteException {
        return this.createComplexMetadataObject(inStore, parentStore, oSimple.getName(), oSimple.getCMetadataType(), oSimple.getFQID(), null);
    }

    @Override
    public CMetadata createComplexMetadataObject(MdObjectStore inStore, MdStore parentStore, String strName, String strType, String strFQID) throws RemoteException {
        return this.createComplexMetadataObject(inStore, parentStore, strName, strType, strFQID, null);
    }

    @Override
    public CMetadata createComplexMetadataObject(MdStore inStore, MdStore parentStore, String strName, String strType, String strFQID, String strNewObjectExternalIdentityRealRepos) throws RemoteException {
        if (inStore.getStoreType() == 1) {
            return this.createComplexMetadataObject((MdObjectStore)inStore, parentStore, strName, strType, strFQID, null);
        }
        return this.createComplexMetadataObjectServerStoreOnly(strName, strType, strFQID);
    }

    @Override
    public CMetadata createComplexMetadataObject(MdObjectStore inStore, MdStore parentStore, String strName, String strType, String strFQID, String strNewObjectExternalIdentityRealRepos) throws RemoteException {
        MdStore pStore;
        boolean objectInParent = false;
        if (parentStore == null && inStore != null && (pStore = inStore.getOwningStore()) != null) {
            parentStore = pStore;
        }
        if (parentStore != null) {
            if (parentStore.getStoreType() == 0) {
                objectInParent = ((MdServerStore)parentStore).isObjectInServerStore(strFQID);
            } else {
                boolean bl = objectInParent = parentStore.getObject(strFQID) != null;
            }
        }
        if (strFQID.length() < 9) {
            strFQID = this.makeID(strFQID);
        } else {
            MdObjectBase tempHashObject = null;
            if (inStore != null) {
                tempHashObject = inStore.getObject(strFQID, true);
                if (tempHashObject != null) {
                    return tempHashObject;
                }
                if (inStore.isDeletedObject(strFQID)) {
                    return null;
                }
                tempHashObject = inStore.getObject(strFQID);
                if (objectInParent && !parentStore.equals(inStore.getOwningStore())) {
                    MdStoreUtil.copyMetaObject(parentStore, (MdStore)inStore, strFQID);
                }
                if ((tempHashObject = inStore.getObject(strFQID, true)) != null) {
                    return tempHashObject;
                }
            }
            if (tempHashObject != null && tempHashObject.getFQID().compareTo(strFQID) == 0) {
                CMetadata returnObject;
                if (inStore == null) {
                    String storeName = "AutoCreated" + this._storeAutoCreatedCount++;
                    inStore = parentStore != null ? this.createObjectStore(parentStore, storeName) : this.createObjectStore(this.m_MdServerStore, storeName);
                }
                inStore.getObject(strFQID);
                if (objectInParent && !parentStore.equals(inStore.getOwningStore())) {
                    MdStoreUtil.copyMetaObject(parentStore, (MdStore)inStore, strFQID);
                }
                if ((returnObject = inStore.getObject(strFQID, true)).isNewObject()) {
                    returnObject.setNameState(1);
                }
                if (this.getChangeManagementEnabled()) {
                    if (strNewObjectExternalIdentityRealRepos != null) {
                        ((Root)returnObject).setChangeState(":" + strNewObjectExternalIdentityRealRepos);
                    } else {
                        ((Root)returnObject).setChangeState("");
                    }
                }
                return returnObject;
            }
        }
        if (inStore == null) {
            String storeName = "AutoCreated" + this._storeAutoCreatedCount++;
            inStore = parentStore != null ? this.createObjectStore(parentStore, storeName) : this.createObjectStore(this.m_MdServerStore, storeName);
        }
        CMetadata returnObject = null;
        boolean exists = this.objectExists(inStore, strFQID);
        returnObject = !exists ? this.createObjectInParentObjectStores(inStore, strName, strType, strFQID) : inStore.getObject(strFQID);
        if (returnObject == null) {
            return returnObject;
        }
        if (objectInParent && !parentStore.equals(inStore.getOwningStore())) {
            MdStoreUtil.copyMetaObject(parentStore, (MdStore)inStore, strFQID);
        }
        if (returnObject.isNewObject()) {
            returnObject.setNameState(1);
            if (this.getChangeManagementEnabled()) {
                if (strNewObjectExternalIdentityRealRepos != null) {
                    ((Root)returnObject).setChangeState(":" + strNewObjectExternalIdentityRealRepos);
                } else {
                    ((Root)returnObject).setChangeState("");
                }
            }
        }
        return returnObject;
    }

    @Override
    @SASScope
    public CMetadata createComplexMetadataObjectServerStoreOnly(String strName, String strType, String strFQID) throws RemoteException {
        CMetadata cMetaObject = null;
        boolean createdNew = false;
        if (strFQID.length() < 9) {
            strFQID = this.makeID(strFQID);
            createdNew = true;
        } else {
            CMetadata tempHashObject = this.m_MdServerStore.getDetailObjectMap().get(strFQID);
            if (tempHashObject != null && tempHashObject.getFQID().compareTo(strFQID) == 0) {
                tempHashObject.setObjectStore(this.m_MdServerStore);
                return tempHashObject;
            }
        }
        cMetaObject = this.loadClassInstance(strType);
        if (cMetaObject != null) {
            if (this._remoteEnvironment) {
                UnicastRemoteObject.exportObject(cMetaObject);
            }
            if (createdNew) {
                cMetaObject.setName(strName, 1);
                cMetaObject.setFQID(strFQID, 1);
            } else {
                cMetaObject.setName(strName, 2);
                cMetaObject.setFQID(strFQID, 1);
            }
            cMetaObject.setCMetadataType(strType);
            Map<String, CMetadata> serverStoreMap = this.m_MdServerStore.getDetailObjectMap();
            serverStoreMap.put(strFQID, cMetaObject);
            ArrayList<String> items = new ArrayList<String>(1);
            items.add(strFQID);
            this.m_MdServerStore.fireMdObjectsAdded(new MdEvent(cMetaObject, this.m_MdServerStore), items);
            cMetaObject.setObjectStore(this.m_MdServerStore);
            cMetaObject.addMdObjectListener(this.m_MdServerStore);
        }
        return cMetaObject;
    }

    @Override
    @SASScope
    public CMetadata createComplexMetadataObjectStoreOnly(MdStore inStore, String strName, String strType, String strFQID) throws RemoteException {
        if (strFQID == null || strFQID.length() == 0) {
            return null;
        }
        if (inStore == null) {
            return null;
        }
        if (inStore.getStoreType() == 0) {
            return null;
        }
        CMetadata cMetaObject = null;
        if (strFQID.length() < 9) {
            strFQID = this.makeID(strFQID);
        } else {
            if (((MdObjectStore)inStore).isDeletedObject(strFQID)) {
                return null;
            }
            CMetadata tempHashObject = inStore.getDetailObjectMap().get(strFQID);
            if (tempHashObject != null && tempHashObject.getFQID().compareTo(strFQID) == 0) {
                tempHashObject.setObjectStore(inStore);
                return tempHashObject;
            }
        }
        cMetaObject = this.loadClassInstance(strType);
        if (cMetaObject != null) {
            if (this._remoteEnvironment) {
                UnicastRemoteObject.exportObject(cMetaObject);
            }
            if (strFQID.indexOf(36) > -1) {
                cMetaObject.setName(strName, 1);
                cMetaObject.setFQID(strFQID, 1);
            } else {
                cMetaObject.setName(strName, 2);
                cMetaObject.setFQID(strFQID, 2);
            }
            cMetaObject.setCMetadataType(strType);
            ((MdObjectStore)inStore).addObjectToMap(strFQID, cMetaObject);
            ArrayList<String> items = new ArrayList<String>(1);
            items.add(strFQID);
            inStore.fireMdObjectsAdded(new MdEvent(cMetaObject, inStore), items);
            cMetaObject.addMdObjectListener((MdObjectStore)inStore);
            cMetaObject.setObjectStore(inStore);
        }
        return cMetaObject;
    }

    private CMetadata loadClassInstance(String strType) {
        try {
            StringBuffer objectName = new StringBuffer(this.m_impl_package);
            objectName.append(strType);
            objectName.append(this.m_impl_extension);
            String classToLoad = objectName.toString();
            Class<?> LoadedClass = class_map.get(classToLoad);
            if (LoadedClass == null) {
                LoadedClass = Class.forName(classToLoad, true, this.getClass().getClassLoader());
                if (!CMetadata.class.isAssignableFrom(LoadedClass)) {
                    throw new IllegalStateException("Invalid metadata type: " + strType);
                }
                class_map.put(classToLoad, LoadedClass);
            }
            return (CMetadata)LoadedClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean objectExists(MdObjectStore inStore, String objectID) throws RemoteException {
        boolean exists = false;
        CMetadata meta = inStore.getObject(objectID, true);
        if (meta != null) {
            exists = true;
        } else if (!exists && inStore.getOwningStore().getStoreType() != 0) {
            exists = this.objectExists((MdObjectStore)inStore.getOwningStore(), objectID);
        }
        return exists;
    }

    private CMetadata createObjectInParentObjectStores(MdObjectStore inStore, String strName, String strType, String strFQID) throws RemoteException {
        CMetadata parentObject;
        CMetadata meta = this.createComplexMetadataObjectStoreOnly(inStore, strName, strType, strFQID);
        if (inStore.getOwningStore() != null && inStore.getOwningStore().getStoreType() != 0 && (parentObject = this.createObjectInParentObjectStores((MdObjectStore)inStore.getOwningStore(), strName, strType, strFQID)) == null) {
            return null;
        }
        return meta;
    }

    @Override
    public void deleteDetailMetadataObject(String strFQID) throws RemoteException {
        CMetadata meta = this.m_MdServerStore.getObjectInChildStore(strFQID);
        if (meta != null) {
            if (this.getDebug()) {
                this.m_Util.printOutputln("Deleting object: " + meta.getName() + ", Id=\"" + meta.getId() + "\"");
            }
            ArrayList<String> items = new ArrayList<String>(1);
            items.add(strFQID);
            this.m_MdServerStore.deleteObjectFromStores(strFQID);
            this.m_MdServerStore.fireMdObjectsRemoved(new MdEvent(meta, this.m_MdServerStore), items);
        }
    }

    private void createDeleteEvent(Map<String, String> objectMap) throws RemoteException {
        int size;
        int n = size = objectMap == null ? 0 : objectMap.size();
        if (size > 0) {
            boolean hasOldListeners = this.hasMdObjectFactoryListeners();
            boolean hasNewListeners = this.hasMdFactoryListeners();
            LinkedHashMap<String, String> eventMap = new LinkedHashMap<String, String>();
            for (String objectID : objectMap.keySet()) {
                if (!this.isNewObject(objectID)) {
                    eventMap.put(objectID, objectMap.get(objectID));
                }
                this.m_MdServerStore.deleteObjectFromStores(objectID);
                if (!hasOldListeners) continue;
                MdEvent deletedEvent = new MdEvent(this.m_MdFactoryInstance, this.m_MdServerStore);
                this.fireMdObjectDeleted(deletedEvent, objectID);
                deletedEvent = null;
            }
            if (hasNewListeners && eventMap.size() > 0) {
                MdFactoryEvent event = new MdFactoryEvent((MdFactory)this.m_MdFactoryInstance, eventMap);
                this.fireMdObjectsDeleted(event);
                event = null;
            }
        }
    }

    private boolean isNewObject(String objectID) {
        if (objectID == null) {
            return false;
        }
        return objectID.indexOf(36) >= 0;
    }

    private void addDeletedItemsToMap(List<String> objectIDList, Map<String, String> objectMap) {
        for (String id : objectIDList) {
            if (objectMap.containsKey(id)) continue;
            objectMap.put(id, null);
        }
    }

    @Override
    public void deleteObjectsFromStores(List<String> objectList) throws RemoteException {
        HashMap<String, String> objectMap = new HashMap<String, String>();
        for (String id : objectList) {
            objectMap.put(id, null);
        }
        this.createDeleteEvent(objectMap);
    }

    @Override
    public void deleteObjectsFromStores(Map<String, String> objectMap) throws RemoteException {
        this.createDeleteEvent(objectMap);
    }

    @Override
    public void deletePublicObject(CMetadata publicObject) throws MdException, RemoteException {
        this.deletePublicObject(publicObject, null);
    }

    @Override
    public void deletePublicObject(CMetadata publicObject, String template) throws MdException, RemoteException {
        if (publicObject != null) {
            HashMap objectMap;
            List<Object> deleteList;
            if (publicObject.isNewObject()) {
                deleteList = new ArrayList<String>(1);
                deleteList.add(publicObject.getId());
                objectMap = new HashMap(1);
                objectMap.put(publicObject.getId(), publicObject.getCMetadataType());
            } else {
                deleteList = template == null ? this.m_OMIUtil.deleteMetadataObject(publicObject) : this.m_OMIUtil.deleteMetadataObject(publicObject, template);
                objectMap = new LinkedHashMap(deleteList.size());
                objectMap.put(publicObject.getId(), publicObject.getCMetadataType());
                this.addDeletedItemsToMap(deleteList, objectMap);
            }
            this.createDeleteEvent(objectMap);
            this.m_MdServerStore.fireMdObjectsRemoved(new MdEvent(this.m_MdFactoryInstance, this.m_MdServerStore), new ArrayList<Object>(deleteList));
        }
    }

    @Override
    public void deleteMetadataObject(CMetadata delobject) throws MdException, RemoteException {
        this.deletePublicObject(delobject, null);
    }

    @Override
    public void deleteMetadataObjects(List<? extends CMetadata> objectList) throws MdException, RemoteException {
        LinkedHashMap<String, String> objectMap = new LinkedHashMap<String, String>();
        ArrayList<CMetadata> deleteFromServerList = new ArrayList<CMetadata>();
        int size = objectList.size();
        for (int i = 0; i < size; ++i) {
            CMetadata meta = objectList.get(i);
            if (!meta.isNewObject()) {
                deleteFromServerList.add(meta);
            }
            objectMap.put(meta.getId(), meta.getCMetadataType());
        }
        if (deleteFromServerList.size() > 0) {
            List<String> deletedObjects = this.m_OMIUtil.deleteMetadataObjects(deleteFromServerList);
            this.addDeletedItemsToMap(deletedObjects, objectMap);
        }
        this.createDeleteEvent(objectMap);
    }

    @Override
    public void deleteMetadataObjects(CMetadata deleteObject, String template) throws MdException, RemoteException {
        this.deleteMetadataObjects(deleteObject.getName(), deleteObject.getCMetadataType(), deleteObject.getFQID(), template);
    }

    @Override
    public void deleteMetadataObjects(String objectName, String objectType, String objectFQID, String template) throws MdException, RemoteException {
        MdObjectStore deleteStore = this.createObjectStore(null, "MdFactoryImpl::deleteMetadataObjects");
        CMetadata deleteObject = this.createComplexMetadataObject(deleteStore, null, objectName, objectType, objectFQID, null);
        if (deleteObject == null) {
            return;
        }
        if (template == null) {
            template = "";
        }
        StringBuffer SELECT = new StringBuffer(objectFQID.length() + template.length() + 26);
        SELECT.append("<XMLSelect search=\"@Id='");
        SELECT.append(objectFQID);
        SELECT.append("'\"/>");
        SELECT.append(template);
        List toDeleteListServer = this.m_OMIUtil.getMetadataObjectsSubsetList(deleteStore, "A0000001." + deleteObject.getRepositoryID(), objectType, 2436, SELECT.toString(), true);
        LinkedHashMap<String, String> deleteMap = new LinkedHashMap<String, String>(toDeleteListServer.size());
        for (CMetadata lDetailed : toDeleteListServer) {
            if (lDetailed == null) continue;
            deleteMap.put(lDetailed.getId(), lDetailed.getCMetadataType());
        }
        deleteStore.dispose();
        List<String> deletedObjects = this.m_OMIUtil.deleteMetadataObjects(deleteMap);
        this.addDeletedItemsToMap(deletedObjects, deleteMap);
        this.createDeleteEvent(deleteMap);
        deleteMap = null;
    }

    @Override
    @SASScope
    public void unlockMetadataObjects(CMetadata unlockObject, String template) throws MdException, RemoteException {
        this.unlockMetadataObjects(unlockObject.getName(), unlockObject.getCMetadataType(), unlockObject.getFQID(), template);
    }

    @Override
    @SASScope
    public void unlockMetadataObjects(String objectName, String objectType, String objectFQID, String template) throws MdException, RemoteException {
        MdObjectStore unlockStore = this.createObjectStore(null, "MdObjectFactory::unlockMetadataObjects");
        CMetadata unlockObject = this.createComplexMetadataObject(unlockStore, null, objectName, objectType, objectFQID, null);
        if (unlockObject == null) {
            return;
        }
        if (template == null) {
            template = "";
        }
        StringBuffer SELECT = new StringBuffer(objectFQID.length() + template.length() + 26);
        SELECT.append("<XMLSelect search=\"@Id='");
        SELECT.append(objectFQID);
        SELECT.append("'\"/>");
        SELECT.append(template);
        List toUnlockListServer = this.m_OMIUtil.getMetadataObjectsSubsetList(unlockStore, "A0000001." + unlockObject.getRepositoryID(), objectType, 388, SELECT.toString(), true);
        Vector<CMetadata> toUnlockList = new Vector<CMetadata>(toUnlockListServer.size());
        for (CMetadata lDetailed : toUnlockListServer) {
            CMetadata lSimple = this.createSimpleMetadataObject(lDetailed);
            toUnlockList.add(lSimple);
        }
        unlockStore.dispose();
        this.m_OMIUtil.unlockMetadataObjects(toUnlockList);
    }

    @Override
    public synchronized String makeID(String shortID) throws RemoteException {
        int zero = 48;
        StringBuffer id = new StringBuffer(String.valueOf(this.newID));
        int iLength = id.length();
        for (int i = 7; i > iLength; --i) {
            id.insert(0, '0');
        }
        id.insert(0, ".$");
        id.insert(0, shortID);
        ++this.newID;
        if (this.newID > 9999999) {
            this.newID = 0;
        }
        return id.toString();
    }

    @Override
    public void dumpDetailHashMap() throws RemoteException {
        this.m_MdServerStore.dumpDetailAllHashMaps();
    }

    @Override
    public void dispose() throws RemoteException {
        this.setDebug(false);
        this.m_MdServerStore.disposeAllStoresAndExit();
        this.m_connection.dispose();
        this.m_OMIUtil.dispose();
        this.m_Util.dispose();
        if (this._reposUtil != null) {
            this._reposUtil.dispose();
        }
        if (this._securityUtil != null) {
            this._securityUtil.dispose();
        }
        if (this._factoryCache != null) {
            this._factoryCache.dispose();
        }
        this.m_impl_extension = null;
        this.m_impl_package = null;
        this.m_MdServerStore = null;
        this.m_connectionListener = null;
        this.MdFactoryListenerList = null;
        this.MdObjectFactoryListenerList = null;
        this.m_MdFactoryInstance = null;
        if (this._remoteEnvironment) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    @Override
    public MetadataResource getBundle() throws RemoteException {
        return bundle;
    }

    @Override
    public CMetadata getObject(String strFQID) throws RemoteException {
        return this.m_MdServerStore.getObject(strFQID);
    }

    @Override
    public void changeHashKey(String strOldId, String strNewId) throws RemoteException {
        this.m_MdServerStore.changeHashKey(strOldId, strNewId);
    }

    @Override
    public void changeImplementationPackage(String newPackage) throws RemoteException {
        this.m_impl_package = new String(newPackage);
    }

    @Override
    public void changeImplementationExtension(String newExtension) throws RemoteException {
        this.m_impl_extension = new String(newExtension);
    }

    @Override
    public void removeStore(MdStore childStore) throws RemoteException {
        this.m_MdServerStore.removeStore(childStore);
    }

    @Override
    public void addMdObjectListener(MdObjectListener l) throws RemoteException {
        this.m_MdServerStore.addMdObjectListener(l);
    }

    @Override
    public void removeMdObjectListener(MdObjectListener l) throws RemoteException {
        this.m_MdServerStore.removeMdObjectListener(l);
    }

    @Override
    public void addMdObjectFactoryListener(MdObjectFactoryListener l) throws RemoteException {
        this.MdObjectFactoryListenerList.add(MdObjectFactoryListener.class, l);
    }

    @Override
    public void removeMdObjectFactoryListener(MdObjectFactoryListener l) throws RemoteException {
        this.MdObjectFactoryListenerList.remove(MdObjectFactoryListener.class, l);
    }

    @Override
    public void addMdFactoryListener(MdFactoryListener l) throws RemoteException {
        this.addMdFactoryListener(l, null);
    }

    @Override
    public void addMdFactoryListener(MdFactoryListener listener, String[] objectTypes) throws RemoteException {
        this.MdFactoryListenerList.add(MdFactoryListener.class, listener);
        if (objectTypes != null && objectTypes.length > 0) {
            if (this._factoryListenerCache == null) {
                this._factoryListenerCache = new HashMap<MdFactoryListener, String[]>();
            }
            if (!this._factoryListenerCache.containsKey(listener)) {
                this._factoryListenerCache.put(listener, objectTypes);
            }
        }
    }

    @Override
    public void removeMdFactoryListener(MdFactoryListener l) throws RemoteException {
        this.MdFactoryListenerList.remove(MdFactoryListener.class, l);
        if (this._factoryListenerCache != null && this._factoryListenerCache.containsKey(l)) {
            this._factoryListenerCache.remove(l);
        }
    }

    @Override
    @SASScope
    public void fireMdObjectCreated(MdEvent e, String id) throws RemoteException {
        Object[] listeners = this.MdObjectFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdObjectFactoryListener.class) continue;
            ((MdObjectFactoryListener)listeners[i + 1]).MdObjectCreated(e, id);
        }
    }

    @Override
    public void fireMdObjectsCreated(MdEvent e, List<String> id) throws RemoteException {
        Object[] listeners = this.MdObjectFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdObjectFactoryListener.class) continue;
            ((MdObjectFactoryListener)listeners[i + 1]).MdObjectsCreated(e, id);
        }
    }

    @Override
    @SASScope
    public void fireMdObjectDeleted(MdEvent e, String id) throws RemoteException {
        Object[] listeners = this.MdObjectFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != MdObjectFactoryListener.class) continue;
            ((MdObjectFactoryListener)listeners[i + 1]).MdObjectDeleted(e, id);
        }
    }

    @Override
    public void fireMdObjectsCreated(MdFactoryEvent e) throws RemoteException {
        Map<String, String> map = e.getObjectMap();
        if (map != null) {
            ArrayList<String> idList = new ArrayList<String>(map.keySet());
            this.m_MdServerStore.updateCreatedItemsList(idList);
        }
        Object[] listeners = this.MdFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            MdFactoryListener listener;
            MdFactoryEvent event;
            if (listeners[i] != MdFactoryListener.class || (event = this.filterObjectsInEvent(listener = (MdFactoryListener)listeners[i + 1], e)) == null || event.getObjectCount() <= 0) continue;
            listener.MdObjectsCreated(event);
        }
    }

    @Override
    public void fireMdObjectsModified(MdFactoryEvent e) throws RemoteException {
        Object[] listeners = this.MdFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            MdFactoryListener listener;
            MdFactoryEvent event;
            if (listeners[i] != MdFactoryListener.class || (event = this.filterObjectsInEvent(listener = (MdFactoryListener)listeners[i + 1], e)) == null || event.getObjectCount() <= 0) continue;
            listener.MdObjectsModified(event);
        }
    }

    @Override
    public void fireMdObjectsDeleted(MdFactoryEvent e) throws RemoteException {
        Object[] listeners = this.MdFactoryListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            MdFactoryListener listener;
            MdFactoryEvent event;
            if (listeners[i] != MdFactoryListener.class || (event = this.filterObjectsInEvent(listener = (MdFactoryListener)listeners[i + 1], e)) == null || event.getObjectCount() <= 0) continue;
            listener.MdObjectsDeleted(event);
        }
    }

    private MdFactoryEvent filterObjectsInEvent(MdFactoryListener listener, MdFactoryEvent originalEvent) {
        String[] objectTypes;
        if (this._factoryListenerCache != null && this._factoryListenerCache.containsKey(listener) && (objectTypes = this._factoryListenerCache.get(listener)) != null && objectTypes.length > 0) {
            MdFactoryEvent newEvent = (MdFactoryEvent)originalEvent.clone();
            Map<String, String> objectMap = newEvent.getObjectMap();
            Object[] keys = objectMap.keySet().toArray();
            int length = keys.length;
            for (int i = 0; i < length; ++i) {
                String key = (String)keys[i];
                String objectType = objectMap.get(key);
                if (this.isInterestedObjectType(objectType, objectTypes)) continue;
                objectMap.remove(key);
            }
            if (newEvent != null) {
                return newEvent;
            }
        }
        return originalEvent;
    }

    private boolean isInterestedObjectType(String objectType, String[] interestedTypes) {
        if (objectType == null) {
            return true;
        }
        for (String type : interestedTypes) {
            if (!objectType.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMdFactoryListeners() {
        return this.MdFactoryListenerList.getListenerCount() > 0;
    }

    private boolean hasMdObjectFactoryListeners() {
        return this.MdObjectFactoryListenerList.getListenerCount() > 0;
    }

    @Override
    public void setMdConnectionListener(MdConnectionListener listener) throws RemoteException {
        this.m_connectionListener = listener;
    }

    @Override
    public MdConnectionListener getMdConnectionListener() throws RemoteException {
        return this.m_connectionListener;
    }
}

