/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFUTFConverter;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JFVariableUpdateDialog
extends JDialog {
    private JPanel m_buttonPanel = new JPanel();
    private JButton m_cancelButton;
    private JLabel m_nameLabel;
    private JTextField m_nameText;
    private JButton m_okButton = new JButton();
    private JLabel m_valueLabel;
    private JTextField m_valueText;
    private JPanel m_variablePanel;
    public String m_varName;
    public String m_varValue;
    private static final int TEXT_FIELD_LENGTH = 20;

    public JFVariableUpdateDialog(Frame frame) {
        super(frame, true);
        this.m_cancelButton = new JButton();
        this.m_variablePanel = new JPanel();
        this.m_nameText = new JTextField();
        this.m_valueText = new JTextField();
        this.m_nameLabel = new JLabel();
        this.m_valueLabel = new JLabel();
        this.m_buttonPanel.setLayout(new FlowLayout(1));
        this.m_variablePanel.setLayout(new GridBagLayout());
        this.m_variablePanel.setPreferredSize(new Dimension(295, 90));
        this.m_variablePanel.setMinimumSize(new Dimension(295, 90));
        this.m_okButton.setEnabled(true);
        this.m_okButton.setText(JFResourceBundle.getString("BUTTON_OK"));
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFVariableUpdateDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.m_buttonPanel.add(this.m_okButton);
        this.m_cancelButton.setEnabled(true);
        this.m_cancelButton.setText(JFResourceBundle.getString("BUTTON_CANCEL"));
        this.m_cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFVariableUpdateDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.m_buttonPanel.add(this.m_cancelButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFVariableUpdateDialog.this.closeDialog(windowEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.m_nameLabel.setText(JFResourceBundle.getString("NAME_LABEL") + ":");
        this.m_variablePanel.add((Component)this.m_nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.m_nameText.setMinimumSize(new Dimension(200, 20));
        this.m_nameText.setPreferredSize(new Dimension(200, 20));
        this.m_nameText.setToolTipText(JFResourceBundle.getString("TOOLTIP_VAR_NAME"));
        this.m_variablePanel.add((Component)this.m_nameText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.m_valueLabel.setText(JFResourceBundle.getString("VALUE_LABEL") + ":");
        this.m_variablePanel.add((Component)this.m_valueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.m_valueText.setColumns(20);
        this.m_valueText.setMinimumSize(new Dimension(200, 20));
        this.m_valueText.setPreferredSize(new Dimension(200, 20));
        this.m_valueText.setToolTipText(JFResourceBundle.getString("TOOLTIP_VAR_VAL"));
        this.m_variablePanel.add((Component)this.m_valueText, gridBagConstraints);
        this.getContentPane().add((Component)this.m_variablePanel, "North");
        this.getContentPane().add((Component)this.m_buttonPanel, "South");
        this.getRootPane().setDefaultButton(this.m_okButton);
        this.setResizable(false);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.m_varName = this.m_nameText.getText();
        this.m_varValue = JFUTFConverter.toUnicodeEscape((String)this.m_valueText.getText());
        if (!JFCommon.isValidVarName((String)this.m_varName) || !JFCommon.isValidVarValue((String)this.m_varValue)) {
            this.m_varName = null;
            this.m_varValue = null;
            JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("ERRORMSG_VAR_INVALID"));
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.m_varName = null;
        this.m_varValue = null;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.m_varName = null;
        this.m_varValue = null;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new JFVariableUpdateDialog(new JFrame()).show();
    }

    public void setBorderTitle(String string) {
        this.m_variablePanel.setBorder(new TitledBorder(string));
    }

    public void setVariableName(String string) {
        this.m_nameText.setText(string);
    }

    public void setVariableValue(String string) {
        this.m_valueText.setText(string);
    }

    public String getVariableName() {
        return this.m_varName;
    }

    public String getVariableValue() {
        return this.m_varValue;
    }

    public void enableVariableName(boolean bl) {
        this.m_nameText.setEnabled(bl);
        this.m_nameText.setBackground(bl ? new Color(255, 255, 255) : new Color(212, 208, 200));
    }
}

