/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.JFCellEditorComponent;
import com.platform.LSFJobFlow.ui.JFFileTransferDialog;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.LSFJobFlow.ui.TextAreaDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public final class JFTextFieldCell
extends JPanel
implements JFCellEditorComponent {
    private boolean m_editable;
    private boolean m_dialogOpen = false;
    private int m_paramType;
    private JFileChooser m_fileChooser;
    private TextAreaDialog m_textAreaDlg;
    private String m_initialValue;
    private FocusListener m_focusListener;
    private JTextField m_textFLD;
    private JButton m_editButton;

    public JFTextFieldCell(int n) {
        this.m_paramType = n;
        this.initComponents();
        if (this.m_paramType == 5) {
            this.m_textFLD.setEditable(false);
            this.m_textFLD.setOpaque(false);
        }
        this.m_textFLD.addFocusListener(new FocusAdapter(){
            private FocusEvent m_evt;

            @Override
            public void focusLost(FocusEvent focusEvent) {
                this.m_evt = focusEvent;
                if (JFTextFieldCell.this.m_focusListener != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JFTextFieldCell.this.m_focusListener.focusLost(m_evt);
                        }
                    });
                }
            }
        });
    }

    @Override
    public void setInput(String string) {
        this.m_initialValue = string;
        this.m_textFLD.setText(this.m_initialValue);
    }

    @Override
    public String getInput() {
        return this.m_textFLD.getText();
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public void resetToInitialValue() {
        this.m_textFLD.setText(this.m_initialValue);
    }

    @Override
    public void setFocusListener(FocusListener focusListener) {
        this.m_focusListener = focusListener;
    }

    private void openFileChooser(final int n) {
        int n2;
        String string;
        if (this.m_fileChooser == null) {
            this.m_fileChooser = new JFileChooser(){

                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    if (n == 1) {
                        return file.isDirectory();
                    }
                    return true;
                }
            };
            if (n == 0) {
                this.m_fileChooser.setFileSelectionMode(0);
            } else {
                this.m_fileChooser.setFileSelectionMode(1);
            }
            this.m_fileChooser.setDialogTitle(JFResourceBundle.getString("JFTextFieldCell$TITLE_fileChooser"));
        }
        if ((string = this.m_textFLD.getText()) != null) {
            File file = new File(string);
            this.m_fileChooser.setSelectedFile(file);
        }
        if ((n2 = this.m_fileChooser.showOpenDialog(JFUtility.getMainFrame(this))) == 0) {
            this.m_textFLD.setText(this.m_fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void initComponents() {
        this.m_textFLD = new JTextField();
        this.m_editButton = new JButton();
        this.setLayout(new BorderLayout());
        this.m_textFLD.setText(" ");
        this.add((Component)this.m_textFLD, "Center");
        this.m_editButton.setText("...");
        this.m_editButton.setVerifyInputWhenFocusTarget(false);
        this.m_editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFTextFieldCell.this.m_editButtonActionPerformed(actionEvent);
            }
        });
        this.add((Component)this.m_editButton, "East");
    }

    private void m_editButtonActionPerformed(ActionEvent actionEvent) {
        switch (this.m_paramType) {
            case 3: {
                this.openFileChooser(0);
                break;
            }
            case 4: {
                this.openFileChooser(1);
                break;
            }
            case 5: {
                JFFileTransferDialog jFFileTransferDialog = new JFFileTransferDialog(JFUtility.getMainFrame(this), this.m_textFLD.getText());
                jFFileTransferDialog.setLocationRelativeTo(this);
                jFFileTransferDialog.setVisible(true);
                String string = jFFileTransferDialog.getFileTransferString();
                if (string == null) break;
                this.m_textFLD.setText(string);
                break;
            }
            default: {
                if (this.m_textAreaDlg == null) {
                    this.m_textAreaDlg = new TextAreaDialog(JFUtility.getMainFrame(this), true, true);
                    this.m_textAreaDlg.setTitle(JFResourceBundle.getString("JFTextFieldCell$TITLE_PropertyDialog"));
                    this.m_textAreaDlg.setText(this.m_textFLD.getText());
                    this.m_textAreaDlg.setLocationRelativeTo(this);
                    this.m_textAreaDlg.setSize(400, 400);
                }
                this.m_textAreaDlg.setVisible(true);
                this.m_textFLD.setText(this.m_textAreaDlg.getText());
            }
        }
        this.m_textFLD.requestFocus();
        this.m_dialogOpen = false;
    }
}

