/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.api.JFTemplateData;
import com.platform.LSFJobFlow.api.JFTemplateDef;
import com.platform.LSFJobFlow.api.JFTemplateJob;
import com.platform.LSFJobFlow.api.JFTemplateManager;
import com.platform.LSFJobFlow.api.JFTemplateParameterDefList;
import com.platform.LSFJobFlow.api.JFTemplateParameterList;
import com.platform.LSFJobFlow.ui.ImageLoader;
import com.platform.LSFJobFlow.ui.JFArrayIndexDialog;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFExceptionHandlerBean;
import com.platform.LSFJobFlow.ui.JFPropertyEditorTab;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JFTemplateJobDefinitionBean
extends JPanel {
    private JFPropertyEditorTab m_appTab = new JFPropertyEditorTab();
    private JFPropertyEditorTab m_envTab = new JFPropertyEditorTab();
    private boolean m_editable = true;
    private boolean m_isArray = false;
    private JFTemplateJob m_job;
    private JFJobArray m_jobArray;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane m_TabbedPane;
    private JPanel m_aboutPanel;
    private JFDescriptionPane m_descrFLD;
    private JLabel m_descrLabel;
    private JFExceptionHandlerBean m_exceptionHandlerBean;
    private JPanel m_exceptionPanel;
    private JPanel m_exeEnvPanel;
    private JPanel m_generalPanel;
    private JButton m_indexButton;
    private JTextField m_indexFLD;
    private JLabel m_indexLabel;
    private JTextField m_nameFLD;
    private JLabel m_nameLabel;
    private JTextArea m_templateHelpFLD;
    private JLabel m_templateIconLabel;
    private JTextArea m_templateSourceFLD;
    private JScrollPane m_templateSourceScrollPane;

    public JFTemplateJobDefinitionBean() {
        this.initComponents();
        this.m_TabbedPane.setTitleAt(0, JFResourceBundle.getString("General"));
        this.m_TabbedPane.setTitleAt(1, JFResourceBundle.getString("Execution_Environment"));
        this.m_TabbedPane.setTitleAt(2, JFResourceBundle.getString("Exception_Handling"));
        this.m_TabbedPane.setTitleAt(3, JFResourceBundle.getString("About"));
        this.setInputAccessibleInfo();
        this.setUpArrayField();
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.m_nameFLD.setEditable(this.m_editable);
        this.m_nameFLD.setEnabled(this.m_editable);
        this.m_nameFLD.setOpaque(this.m_editable);
        this.m_indexFLD.setEditable(this.m_editable);
        this.m_indexFLD.setEnabled(this.m_editable);
        this.m_indexFLD.setOpaque(this.m_editable);
        this.m_descrFLD.setEditable(this.m_editable);
        this.m_descrFLD.setEnabled(this.m_editable);
        this.m_descrFLD.setOpaque(this.m_editable);
        this.m_exceptionHandlerBean.setEditable(this.m_editable);
        this.m_envTab.setEditable(this.m_editable);
        this.m_appTab.setEditable(this.m_editable);
    }

    public void setTemplateJob(JFTemplateJob jFTemplateJob) {
        if (jFTemplateJob == null) {
            throw new NullPointerException(JFResourceBundle.getString("Parameter_job_is_null!"));
        }
        this.m_isArray = false;
        this.setUpArrayField();
        this.m_job = jFTemplateJob;
        this.m_nameFLD.setText(this.m_job.getName());
        this.m_descrFLD.setText(this.m_job.getAttribute("Description"));
        this.m_exceptionHandlerBean.setSource(this.m_job);
        this.initTemplateInfo(jFTemplateJob);
    }

    public void setTemplateJobArray(JFJobArray jFJobArray) {
        if (jFJobArray == null) {
            throw new NullPointerException(JFResourceBundle.getString("Parameter_jobArray_is_null!"));
        }
        JFJob jFJob = jFJobArray.getJobDefinition();
        if (!(jFJob instanceof JFTemplateJob)) {
            throw new IllegalArgumentException(JFResourceBundle.getString("jobArray_object_is_not_a_template!"));
        }
        this.m_isArray = true;
        this.setUpArrayField();
        this.m_jobArray = jFJobArray;
        this.m_nameFLD.setText(this.m_jobArray.getName());
        this.m_descrFLD.setText(jFJob.getAttribute("Description"));
        this.m_indexFLD.setText(this.m_jobArray.getArrayIndex());
        this.m_exceptionHandlerBean.setSource(this.m_jobArray);
        this.initTemplateInfo((JFTemplateJob)jFJob);
    }

    public JFTemplateJob getTemplateJob() throws Exception {
        try {
            this.updateDefinition();
        }
        catch (Exception exception) {
            return null;
        }
        return this.m_job;
    }

    public void updateDefinition() throws Exception {
        Object object;
        String string;
        if (!this.m_editable) {
            return;
        }
        this.validateBeanInput();
        this.m_envTab.stopCellEditing();
        this.m_appTab.stopCellEditing();
        JFTemplateJob jFTemplateJob = null;
        if (this.m_isArray) {
            if (this.m_jobArray == null) {
                return;
            }
            string = this.m_indexFLD.getText();
            this.m_jobArray.setArrayIndex(string);
            this.m_jobArray.setName(this.m_nameFLD.getText());
            jFTemplateJob = (JFTemplateJob)this.m_jobArray.getJobDefinition();
        } else {
            jFTemplateJob = this.m_job;
        }
        if (jFTemplateJob == null) {
            return;
        }
        jFTemplateJob.setName(this.m_nameFLD.getText());
        string = jFTemplateJob.getTemplateData();
        if (string != null) {
            object = this.m_appTab.getUpdatedParameterList();
            JFTemplateParameterList jFTemplateParameterList = this.m_envTab.getUpdatedParameterList();
            boolean bl = false;
            if (jFTemplateParameterList != null) {
                string.setExecutionParameters(jFTemplateParameterList);
                bl = true;
            }
            if (object != null) {
                string.setSubmissionParameters(object);
                bl = true;
            }
            if (bl) {
                jFTemplateJob.setTemplateData((JFTemplateData)string);
            }
        }
        if ((object = this.m_descrFLD.getText()) != null) {
            jFTemplateJob.setAttribute("Description", (String)object);
        }
        this.m_exceptionHandlerBean.updateHandlers();
    }

    private void validateBeanInput() throws Exception {
        String[] stringArray;
        String string = this.m_nameFLD.getText();
        if (!JFUtility.isValidJobFlowIdentity(string)) {
            throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_jobNameInvalid"));
        }
        if (this.m_isArray) {
            string = this.m_indexFLD.getText();
            if (string == null || string.equals("")) {
                throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_noIndexErr"));
            }
            JFArrayIndexDialog.checkArrayIndex(string);
        }
        if ((stringArray = this.m_envTab.getInputMissingParamList()) != null && stringArray.length > 0) {
            throw new Exception(this.showMissingParamList(JFResourceBundle.getString("JFTemplateJobDefinitionBean$ERR_missEnvParams"), stringArray));
        }
        stringArray = this.m_appTab.getInputMissingParamList();
        if (stringArray != null && stringArray.length > 0) {
            throw new Exception(this.showMissingParamList(JFResourceBundle.getString("JFTemplateJobDefinitionBean$ERR_missAppParams"), stringArray));
        }
    }

    private void initTemplateInfo(JFTemplateJob jFTemplateJob) {
        JFTemplateData jFTemplateData = jFTemplateJob.getTemplateData();
        JFTemplateDef jFTemplateDef = jFTemplateJob.getTemplateDefinition();
        JFTemplateParameterList jFTemplateParameterList = null;
        JFTemplateParameterList jFTemplateParameterList2 = null;
        JFTemplateParameterDefList jFTemplateParameterDefList = null;
        JFTemplateParameterDefList jFTemplateParameterDefList2 = null;
        if (jFTemplateData != null) {
            jFTemplateParameterList = jFTemplateData.getSubmissionParameters();
            jFTemplateParameterList2 = jFTemplateData.getExecutionParameters();
        }
        if (jFTemplateDef != null) {
            jFTemplateParameterDefList = jFTemplateDef.getSubmissionParams();
            jFTemplateParameterDefList2 = jFTemplateDef.getExecutionParams();
        }
        this.m_appTab.initTable(jFTemplateParameterList, jFTemplateParameterDefList);
        this.m_envTab.initTable(jFTemplateParameterList2, jFTemplateParameterDefList2);
        this.m_templateIconLabel.setIcon(new ImageIcon(ImageLoader.getInstance().getTemplateImage(jFTemplateDef)));
        String string = null;
        String string2 = null;
        if (jFTemplateDef != null) {
            string = jFTemplateDef.getHelp();
            string2 = JFTemplateManager.getInstance().getXMLSource(jFTemplateDef.getName());
        }
        if (string != null) {
            this.m_templateHelpFLD.setText(string);
        }
        if (string2 != null) {
            this.m_templateSourceFLD.setText(string2);
        }
    }

    private void setInputAccessibleInfo() {
        this.m_nameLabel.setLabelFor(this.m_nameFLD);
        this.m_nameFLD.getAccessibleContext().setAccessibleName(this.m_nameLabel.getText());
        this.m_nameFLD.getAccessibleContext().setAccessibleDescription(this.m_nameFLD.getToolTipText());
        this.m_indexLabel.setLabelFor(this.m_indexFLD);
        this.m_indexFLD.getAccessibleContext().setAccessibleName(this.m_indexLabel.getText());
        this.m_indexFLD.getAccessibleContext().setAccessibleDescription(this.m_indexFLD.getToolTipText());
        this.m_descrLabel.setLabelFor(this.m_descrFLD);
        this.m_descrFLD.getAccessibleContext().setAccessibleName(this.m_descrLabel.getText());
        this.m_descrFLD.getAccessibleContext().setAccessibleDescription(this.m_descrFLD.getToolTipText());
        this.jLabel2.setLabelFor(this.m_templateSourceFLD);
        this.m_templateSourceFLD.getAccessibleContext().setAccessibleName(this.jLabel2.getText());
        this.m_templateSourceFLD.getAccessibleContext().setAccessibleDescription(this.m_templateSourceFLD.getToolTipText());
    }

    private void setUpArrayField() {
        this.m_indexLabel.setVisible(this.m_isArray);
        this.m_indexFLD.setVisible(this.m_isArray);
        this.m_indexButton.setVisible(this.m_isArray);
    }

    private String showMissingParamList(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i >= 5) {
                stringBuffer.append("\n    ...");
                break;
            }
            stringBuffer.append("\n    ");
            String string2 = JFUtility.getTemplateCaption(stringArray[i]);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private void initComponents() {
        this.m_TabbedPane = new JTabbedPane();
        this.m_generalPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.m_nameLabel = new JLabel();
        this.m_nameFLD = new JTextField();
        this.m_indexLabel = new JLabel();
        this.m_indexFLD = new JTextField();
        this.m_indexButton = new JButton();
        this.m_descrLabel = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.m_descrFLD = new JFDescriptionPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane(this.m_appTab);
        this.m_exeEnvPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane(this.m_envTab);
        this.m_exceptionPanel = new JPanel();
        this.m_exceptionHandlerBean = new JFExceptionHandlerBean();
        this.m_aboutPanel = new JPanel();
        this.m_templateIconLabel = new JLabel();
        this.m_templateHelpFLD = new JTextArea();
        this.m_templateSourceScrollPane = new JScrollPane();
        this.m_templateSourceFLD = new JTextArea();
        this.jLabel2 = new JLabel();
        this.setLayout(new BorderLayout());
        this.m_generalPanel.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Identification")));
        this.m_nameLabel.setText(JFResourceBundle.getString("Name_"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_nameLabel, gridBagConstraints);
        this.m_nameFLD.setColumns(15);
        this.m_nameFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_jobNameFLD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_nameFLD, gridBagConstraints);
        this.m_indexLabel.setText(JFResourceBundle.getString("Index_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_indexLabel, gridBagConstraints);
        this.m_indexFLD.setColumns(20);
        this.m_indexFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_arrayIndexFLD"));
        this.m_indexFLD.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JFTemplateJobDefinitionBean.this.m_indexFLDFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_indexFLD, gridBagConstraints);
        this.m_indexButton.setText("...");
        this.m_indexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFTemplateJobDefinitionBean.this.m_indexButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_indexButton, gridBagConstraints);
        this.m_descrLabel.setText(JFResourceBundle.getString("Description_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_descrLabel, gridBagConstraints);
        this.jScrollPane3.setToolTipText("");
        this.jScrollPane3.setPreferredSize(new Dimension(300, 100));
        this.m_descrFLD.setToolTipText(JFResourceBundle.getString("JFTemplateDefinitionBean$TIP_descrFLD"));
        this.m_descrFLD.setPreferredSize(this.jScrollPane3.getPreferredSize());
        this.jScrollPane3.setViewportView(this.m_descrFLD);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.m_generalPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Application_Parameters")));
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jScrollPane1.setMinimumSize(new Dimension(550, 250));
        this.jScrollPane1.setPreferredSize(new Dimension(550, 250));
        this.jPanel2.add(this.jScrollPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.m_generalPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.m_TabbedPane.addTab("General", null, this.m_generalPanel, "");
        this.m_exeEnvPanel.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Environment_Parameters")));
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jScrollPane2.setViewportBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jScrollPane2.setMinimumSize(new Dimension(550, 300));
        this.jScrollPane2.setPreferredSize(new Dimension(550, 300));
        this.m_exeEnvPanel.add(this.jScrollPane2);
        this.m_TabbedPane.addTab("Execution Environment", null, this.m_exeEnvPanel, "");
        this.m_exceptionPanel.add(this.m_exceptionHandlerBean);
        this.m_TabbedPane.addTab("Exception Handling", null, this.m_exceptionPanel, "");
        this.m_aboutPanel.setLayout(new GridBagLayout());
        this.m_templateIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/platform/LSFJobFlow/ui/resources/defaultTemplate.gif")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.m_aboutPanel.add((Component)this.m_templateIconLabel, gridBagConstraints);
        this.m_templateHelpFLD.setEditable(false);
        this.m_templateHelpFLD.setRows(4);
        this.m_templateHelpFLD.setWrapStyleWord(true);
        this.m_templateHelpFLD.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.m_aboutPanel.add((Component)this.m_templateHelpFLD, gridBagConstraints);
        this.m_templateSourceScrollPane.setViewportBorder(BorderFactory.createBevelBorder(1));
        this.m_templateSourceScrollPane.setMinimumSize(new Dimension(550, 300));
        this.m_templateSourceScrollPane.setPreferredSize(new Dimension(550, 300));
        this.m_templateSourceFLD.setEditable(false);
        this.m_templateSourceFLD.setBorder(null);
        this.m_templateSourceFLD.setOpaque(false);
        this.m_templateSourceScrollPane.setViewportView(this.m_templateSourceFLD);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.m_aboutPanel.add((Component)this.m_templateSourceScrollPane, gridBagConstraints);
        this.jLabel2.setText(JFResourceBundle.getString("Template_Source"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.m_aboutPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.m_TabbedPane.addTab("About", null, this.m_aboutPanel, "");
        this.add((Component)this.m_TabbedPane, "North");
    }

    private void m_indexFLDFocusLost(FocusEvent focusEvent) {
        String string;
        if (this.m_editable && (string = this.m_indexFLD.getText().trim()) != null && string.length() > 0 && string.indexOf(91) == -1) {
            this.m_indexFLD.setText("[" + string + "]");
        }
    }

    private void m_indexButtonActionPerformed(ActionEvent actionEvent) {
        JFArrayIndexDialog jFArrayIndexDialog = new JFArrayIndexDialog((JFrame)JFUtility.getMainFrame(this));
        jFArrayIndexDialog.setEditable(this.m_editable);
        jFArrayIndexDialog.setLocationRelativeTo(this);
        jFArrayIndexDialog.setIndex(this.m_indexFLD.getText());
        jFArrayIndexDialog.show();
        if (jFArrayIndexDialog.isOkPressed()) {
            this.m_indexFLD.setText(jFArrayIndexDialog.getIndex());
        }
    }
}

