/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFAdminManager;
import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFUserGroup;
import com.platform.LSFJobFlow.ui.JFArrayIndexDialog;
import com.platform.LSFJobFlow.ui.JFDescriptionPane;
import com.platform.LSFJobFlow.ui.JFExceptionHandlerBean;
import com.platform.LSFJobFlow.ui.JFJobEnvVarsDialog;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.Format;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JFJobScriptDefinitionBean
extends JPanel {
    static final String ERR_WIN_TITLE = JFResourceBundle.getString("JobDefinitionBean$TITLE_inputErrWin");
    static JFJobEnvVarsDialog envVarsDialog = null;
    boolean editable = true;
    BeanInputVerifier beanInputVerifier = null;
    int curSeqNo = 0;
    JFJob jobDef = null;
    JFJobArray jobArrayDef = null;
    boolean isJobArray = false;
    JFArrayIndexDialog arrayIndexDialog = null;
    boolean m_isJFAdmin = false;
    private String m_currentUserName = JFLoginManager.getUserName();
    private String jobOwner = null;
    private boolean m_isGroupAdmin = false;
    private boolean m_isLimitGroupFlowOwner = false;
    private List<JFUserGroup> m_lsfUserGroups = null;
    private String m_mainFlowUser = null;
    private JTextField arrayIndexFLD;
    private JLabel arrayIndexLabel;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JTextField cmdLineFLD;
    private JLabel cmdLineLabel;
    private JFDescriptionPane descriptionPane;
    private JButton editArrayIndexButton;
    private JTextField envVarsFLD;
    private JLabel envVarsLabel;
    private ButtonGroup fileTransfterButtonGroup;
    private JPanel generalPanel;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextField jobNameFLD;
    private JLabel jobNameLabel;
    private JPanel jobPanel;
    private JPanel m_descriptionPanel;
    private JButton m_envVarsModifyButton;
    private JFExceptionHandlerBean m_exceptionHanlderPanel;
    private JTextField nonZeroCodesFLD;
    private JLabel nonZeroCodesLabel;
    private JTabbedPane tabbedPanel;
    private JTextField userNameFLD;
    private JTextField workingDirFLD;
    private JLabel workingDirLabel;

    public void setJobOwner(String string) {
        this.jobOwner = string;
    }

    public JFJobScriptDefinitionBean() {
        this.initComponents();
        this.tabbedPanel.setTitleAt(0, JFResourceBundle.getString("General"));
        this.tabbedPanel.setTitleAt(1, JFResourceBundle.getString("Exception_Handling"));
        this.tabbedPanel.setTitleAt(2, JFResourceBundle.getString("Description"));
        this.setInputAccessibleInfo();
        this.m_exceptionHanlderPanel.setSource(new JFJob("dummyJob"));
        this.beanInputVerifier = new BeanInputVerifier();
        this.nonZeroCodesFLD.setInputVerifier(this.beanInputVerifier);
        this.curSeqNo = 0;
        this.setJobArrayFlag(false);
        this.populate();
        this.reset();
    }

    JFJob getDefaultJob(String string) throws Exception {
        this.jobNameFLD.setText(string);
        this.reset();
        return this.createJob(null);
    }

    JFJob getDefaultJob() throws Exception {
        this.jobNameFLD.setText("S" + String.valueOf(++this.curSeqNo));
        this.reset();
        return this.createJob(null);
    }

    void setJobArrayFlag(boolean bl) {
        this.isJobArray = bl;
        this.arrayIndexLabel.setVisible(bl);
        this.arrayIndexFLD.setVisible(bl);
        this.editArrayIndexButton.setVisible(bl);
        this.nonZeroCodesLabel.setVisible(!bl);
        this.nonZeroCodesFLD.setVisible(!bl);
        if (bl) {
            this.jobPanel.setBorder(new TitledBorder(JFResourceBundle.getString("Define_the_Job_Array")));
            this.arrayIndexDialog = new JFArrayIndexDialog(this.getMainFrame());
        } else {
            this.jobPanel.setBorder(new TitledBorder(JFResourceBundle.getString("Define_the_Job")));
        }
    }

    public void setEditable(boolean bl) {
        boolean bl2;
        this.editable = bl;
        this.userNameFLD.setEditable(bl);
        this.userNameFLD.setEnabled(bl);
        this.userNameFLD.setOpaque(bl);
        this.jobNameFLD.setEditable(bl);
        this.jobNameFLD.setEnabled(bl);
        this.jobNameFLD.setOpaque(bl);
        this.arrayIndexFLD.setEditable(bl);
        this.arrayIndexFLD.setEnabled(bl);
        this.arrayIndexFLD.setOpaque(bl);
        this.cmdLineFLD.setEditable(bl);
        this.cmdLineFLD.setEnabled(bl);
        this.cmdLineFLD.setOpaque(bl);
        this.workingDirFLD.setEditable(bl);
        this.workingDirFLD.setEnabled(bl);
        this.workingDirFLD.setOpaque(bl);
        this.m_envVarsModifyButton.setVisible(bl);
        this.envVarsFLD.setEnabled(bl);
        this.envVarsFLD.setOpaque(bl);
        this.nonZeroCodesFLD.setEditable(bl);
        this.nonZeroCodesFLD.setEnabled(bl);
        this.nonZeroCodesFLD.setOpaque(bl);
        this.m_exceptionHanlderPanel.setEditable(bl);
        this.descriptionPane.setEditable(bl);
        this.descriptionPane.setOpaque(bl);
        boolean bl3 = bl2 = this.m_isJFAdmin || this.m_lsfUserGroups != null && this.m_lsfUserGroups.size() > 0;
        if (bl) {
            this.userNameFLD.setEditable(bl2);
            this.userNameFLD.setEnabled(bl2);
            this.userNameFLD.setOpaque(bl2);
        }
    }

    public void setJobArrayDefinition(JFJobArray jFJobArray) {
        this.jobArrayDef = jFJobArray;
        this.reset();
        this.setJobArrayFlag(true);
        if (jFJobArray == null) {
            this.jobDef = null;
            return;
        }
        this.jobDef = jFJobArray.getJobDefinition();
        this.arrayIndexFLD.setText(jFJobArray.getArrayIndex());
        if (this.jobDef == null) {
            return;
        }
        this.jobNameFLD.setText(jFJobArray.getName());
        Properties properties = this.jobDef.getAttributes();
        if (properties == null || properties.size() <= 0) {
            return;
        }
        this.setBeanField(properties);
        this.m_exceptionHanlderPanel.setSource(this.jobArrayDef);
    }

    public void setJobDefinition(JFJob jFJob) {
        this.jobDef = jFJob;
        this.reset();
        this.setJobArrayFlag(false);
        if (jFJob == null) {
            return;
        }
        this.jobNameFLD.setText(jFJob.getName());
        Properties properties = jFJob.getAttributes();
        if (properties == null || properties.size() <= 0) {
            return;
        }
        this.setBeanField(properties);
        this.m_exceptionHanlderPanel.setSource(this.jobDef);
    }

    public void reset(String string) {
        this.reset();
        if (string != null) {
            this.jobNameFLD.setText(string);
        }
    }

    public void reset() {
        this.tabbedPanel.setSelectedComponent(this.generalPanel);
        if (this.jobDef != null) {
            this.jobNameFLD.setText(this.jobDef.getName());
        }
        this.arrayIndexFLD.setText("");
        this.cmdLineFLD.setText("");
        this.envVarsFLD.setText("");
        this.workingDirFLD.setText("");
        this.envVarsFLD.setText("");
        this.nonZeroCodesFLD.setText("");
        if (this.m_mainFlowUser != null && !this.m_mainFlowUser.equals("")) {
            this.userNameFLD.setText(this.m_mainFlowUser);
        } else {
            this.userNameFLD.setText(this.m_currentUserName);
        }
        this.m_exceptionHanlderPanel.reset();
        this.descriptionPane.setText("");
    }

    public void updateDefinition() throws Exception {
        if (!this.editable) {
            throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_nonEditableErr"));
        }
        if (this.isJobArray) {
            if (this.jobArrayDef == null) {
                throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_noArrayDefErr"));
            }
            String string = this.arrayIndexFLD.getText();
            if (string == null || string.length() <= 0) {
                throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_noIndexErr"));
            }
            JFArrayIndexDialog.checkArrayIndex(string);
            this.jobDef = this.createJob(this.jobDef);
            this.jobArrayDef.setArrayIndex(string);
            this.jobArrayDef.setName(this.jobNameFLD.getText());
        } else {
            if (this.jobDef == null) {
                throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_noJobDefErr"));
            }
            this.jobDef = this.createJob(this.jobDef);
        }
    }

    public JFJob getJobDefinition() throws Exception {
        if (this.isJobArray) {
            throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_notJobErr"));
        }
        return this.createJob(null);
    }

    public JFJobArray getJobArrayDefinition() throws Exception {
        if (!this.isJobArray) {
            throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_notJobArrayErr"));
        }
        String string = this.arrayIndexFLD.getText();
        if (string == null || string.length() <= 0) {
            throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_noIndexErr"));
        }
        JFArrayIndexDialog.checkArrayIndex(string);
        JFJob jFJob = this.createJob(null);
        if (jFJob != null) {
            return new JFJobArray(jFJob.getName(), jFJob, string);
        }
        return null;
    }

    public void setJFAdmin(boolean bl) {
        boolean bl2;
        this.m_isJFAdmin = bl;
        boolean bl3 = bl2 = this.m_isJFAdmin || this.m_lsfUserGroups != null && this.m_lsfUserGroups.size() > 0;
        if (this.editable) {
            this.userNameFLD.setEditable(bl2);
            this.userNameFLD.setEnabled(bl2);
            this.userNameFLD.setOpaque(bl2);
        }
    }

    public void setLSFUserGroups(List<JFUserGroup> list) {
        boolean bl;
        this.m_lsfUserGroups = list;
        this.m_isGroupAdmin = this.m_lsfUserGroups != null && this.m_lsfUserGroups.size() > 0;
        boolean bl2 = bl = this.m_isJFAdmin || this.m_isGroupAdmin;
        if (this.editable) {
            this.userNameFLD.setEditable(bl);
            this.userNameFLD.setEnabled(bl);
            this.userNameFLD.setOpaque(bl);
        }
        JFAdminManager jFAdminManager = null;
        try {
            jFAdminManager = new JFAdminManager();
            this.m_isLimitGroupFlowOwner = jFAdminManager.isLimitGroupFlowOwnerCached();
        }
        catch (Exception exception) {
            this.m_isLimitGroupFlowOwner = false;
        }
    }

    public void setMainFlowOwner(String string) {
        this.m_mainFlowUser = string;
    }

    JFJob createJob(JFJob jFJob) throws Exception {
        String string = null;
        Object var3_3 = null;
        string = this.jobNameFLD.getText();
        if (!JFUtility.isValidJobFlowIdentity(string, !this.isJobArray)) {
            throw new Exception(JFResourceBundle.getString("JobDefinitionBean$ERR_jobNameInvalid"));
        }
        JFJob jFJob2 = null;
        Properties properties = null;
        try {
            if (jFJob == null) {
                jFJob2 = new JFJob(string, "script");
            } else {
                jFJob2 = jFJob;
                properties = jFJob.getAttributes();
                jFJob2.setName(string);
                jFJob2.removeAllAttributes();
            }
            jFJob2.setAttribute("SubmissionCmd", "bsub");
            string = this.userNameFLD.getText();
            if (string != null && string.length() > 0) {
                jFJob2.setUserName(string);
            } else {
                jFJob2.setUserName(this.m_currentUserName);
            }
            if (!this.m_isJFAdmin && this.m_isGroupAdmin) {
                Cloneable cloneable;
                Object[] objectArray;
                boolean bl = true;
                String string2 = jFJob2.getUserName();
                JFUser jFUser = new JFUser(string2);
                JFUser jFUser2 = new JFUser("all");
                int n = string2.indexOf("#{");
                if (n != -1) {
                    bl = false;
                }
                if (bl && !this.m_isLimitGroupFlowOwner && jFUser.equals((JFUser)(objectArray = new JFUser(this.m_currentUserName)))) {
                    bl = false;
                }
                if (bl) {
                    for (Object object : this.m_lsfUserGroups) {
                        cloneable = object.getGroupMembers();
                        if (cloneable != null && ((HashSet)cloneable).contains(jFUser)) {
                            bl = false;
                            break;
                        }
                        if (cloneable == null || !((HashSet)cloneable).contains(jFUser2)) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    Object object;
                    objectArray = new Object[]{string2};
                    object = JFResourceBundle.getString("JobDefinitionBean$ERR_NotAdminOrGroupAdmin");
                    cloneable = new MessageFormat((String)object);
                    throw new Exception(((Format)cloneable).format(objectArray));
                }
            }
            if ((string = this.cmdLineFLD.getText()) == null || string.trim().length() <= 0) {
                throw new Exception(JFResourceBundle.getString("JobScriptDefinitionBean$ERR_cmdLineInvalid"));
            }
            jFJob2.setAttribute("JobCmdLine", string);
            string = this.workingDirFLD.getText();
            if (string != null && string.trim().length() > 0) {
                jFJob2.setAttribute("WorkingDirectory", string);
            }
            if ((string = this.envVarsFLD.getText()) != null && string.length() > 0) {
                jFJob2.setAttribute("JobEnvVars", string);
            }
            if ((string = this.nonZeroCodesFLD.getText()) != null && string.length() > 0) {
                jFJob2.setAttribute("NonZeroSuccessExitCodes", string);
            }
            this.m_exceptionHanlderPanel.updateHandlers();
            string = this.descriptionPane.getText();
            if (string != null) {
                jFJob2.setAttribute("Description", string);
            }
        }
        catch (Exception exception) {
            if (null != properties && null != jFJob2) {
                jFJob2.setAttributes(properties);
            }
            throw exception;
        }
        jFJob2.validate();
        return jFJob2;
    }

    private String getName(String string) {
        int n = string.lastIndexOf(58);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    void setBeanField(Properties properties) {
        String string = null;
        Object var3_3 = null;
        if (properties == null || properties.size() <= 0) {
            return;
        }
        this.cmdLineFLD.setText(properties.getProperty("JobCmdLine", ""));
        if (this.editable) {
            this.userNameFLD.setText(properties.getProperty("UserName", this.m_currentUserName));
        } else if (this.jobOwner != null) {
            this.userNameFLD.setText(this.jobOwner);
        } else {
            this.userNameFLD.setText(properties.getProperty("UserName", ""));
        }
        this.workingDirFLD.setText(properties.getProperty("WorkingDirectory", ""));
        if (JFCommon.checkEnvVars((String)properties.getProperty("JobEnvVars", ""))) {
            this.envVarsFLD.setText(properties.getProperty("JobEnvVars", ""));
        } else {
            JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("JFEnvVarsDialog$ERR_badVarLoad"));
        }
        this.nonZeroCodesFLD.setText(properties.getProperty("NonZeroSuccessExitCodes", ""));
        string = properties.getProperty("Description");
        if (string != null) {
            this.descriptionPane.setText(string);
        }
    }

    JFrame getMainFrame() {
        JFrame jFrame = null;
        if (jFrame == null) {
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof JFrame)) continue;
                jFrame = (JFrame)container;
                break;
            }
        }
        return jFrame;
    }

    JDialog getParentDialog() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JDialog)) continue;
            return (JDialog)container;
        }
        return null;
    }

    private void showAppErrorMsg(String string) {
        JFUtility.showAppErrorMsg(this, string);
    }

    private void setInputAccessibleInfo() {
        this.jLabel6.setLabelFor(this.userNameFLD);
        this.userNameFLD.getAccessibleContext().setAccessibleName(this.jLabel6.getText());
        this.userNameFLD.getAccessibleContext().setAccessibleDescription(this.userNameFLD.getToolTipText());
        this.jobNameLabel.setLabelFor(this.jobNameFLD);
        this.jobNameFLD.getAccessibleContext().setAccessibleName(this.jobNameLabel.getText());
        this.jobNameFLD.getAccessibleContext().setAccessibleDescription(this.jobNameFLD.getToolTipText());
        this.arrayIndexLabel.setLabelFor(this.arrayIndexFLD);
        this.arrayIndexFLD.getAccessibleContext().setAccessibleName(this.arrayIndexLabel.getText());
        this.arrayIndexFLD.getAccessibleContext().setAccessibleDescription(this.arrayIndexFLD.getToolTipText());
        this.cmdLineLabel.setLabelFor(this.cmdLineFLD);
        this.cmdLineFLD.getAccessibleContext().setAccessibleName(this.cmdLineLabel.getText());
        this.cmdLineFLD.getAccessibleContext().setAccessibleDescription(this.cmdLineFLD.getToolTipText());
        this.workingDirLabel.setLabelFor(this.workingDirFLD);
        this.workingDirFLD.getAccessibleContext().setAccessibleName(this.workingDirLabel.getText());
        this.workingDirFLD.getAccessibleContext().setAccessibleDescription(this.workingDirFLD.getToolTipText());
        this.nonZeroCodesLabel.setLabelFor(this.nonZeroCodesFLD);
        this.nonZeroCodesFLD.getAccessibleContext().setAccessibleName(this.nonZeroCodesLabel.getText());
        this.nonZeroCodesFLD.getAccessibleContext().setAccessibleDescription(this.nonZeroCodesFLD.getToolTipText());
        this.jScrollPane1.getAccessibleContext().setAccessibleName(JFResourceBundle.getString("Enter_Description_"));
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(this.jScrollPane1.getToolTipText());
    }

    public void populate() {
    }

    private void initComponents() {
        this.fileTransfterButtonGroup = new ButtonGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.tabbedPanel = new JTabbedPane();
        this.generalPanel = new JPanel();
        this.jobPanel = new JPanel();
        this.jobNameLabel = new JLabel();
        this.cmdLineLabel = new JLabel();
        this.cmdLineFLD = new JTextField();
        this.jobNameFLD = new JTextField();
        this.arrayIndexFLD = new JTextField();
        this.arrayIndexLabel = new JLabel();
        this.editArrayIndexButton = new JButton();
        this.workingDirLabel = new JLabel();
        this.workingDirFLD = new JTextField();
        this.envVarsLabel = new JLabel();
        this.envVarsFLD = new JTextField();
        this.m_envVarsModifyButton = new JButton();
        this.nonZeroCodesLabel = new JLabel();
        this.nonZeroCodesFLD = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.userNameFLD = new JTextField();
        this.m_exceptionHanlderPanel = new JFExceptionHandlerBean();
        this.m_descriptionPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionPane = new JFDescriptionPane();
        this.setLayout(new BorderLayout());
        this.tabbedPanel.setMinimumSize(new Dimension(600, 329));
        this.tabbedPanel.setOpaque(true);
        this.tabbedPanel.setPreferredSize(new Dimension(600, 329));
        this.generalPanel.setLayout(new GridBagLayout());
        this.generalPanel.setBorder(new TitledBorder(""));
        this.generalPanel.setMinimumSize(new Dimension(550, 300));
        this.generalPanel.setPreferredSize(new Dimension(550, 300));
        this.jobPanel.setLayout(new GridBagLayout());
        this.jobPanel.setBorder(new TitledBorder(JFResourceBundle.getString("Define_the_Job")));
        this.jobPanel.setMinimumSize(new Dimension(550, 200));
        this.jobPanel.setPreferredSize(new Dimension(550, 200));
        this.jobNameLabel.setText(JFResourceBundle.getString("Name_"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.jobNameLabel, gridBagConstraints);
        this.jobNameFLD.setColumns(20);
        this.jobNameFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_jobNameFLD"));
        this.jobNameFLD.setMinimumSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.jobNameFLD, gridBagConstraints);
        this.arrayIndexLabel.setText(JFResourceBundle.getString("Index_expression_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.arrayIndexLabel, gridBagConstraints);
        this.arrayIndexFLD.setMinimumSize(new Dimension(250, 27));
        this.arrayIndexFLD.setPreferredSize(new Dimension(430, 20));
        this.arrayIndexFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_arrayIndexFLD"));
        this.arrayIndexFLD.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                JFJobScriptDefinitionBean.this.arrayIndexFLDFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.arrayIndexFLD, gridBagConstraints);
        this.editArrayIndexButton.setText(JFResourceBundle.getString("Modify..."));
        this.editArrayIndexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFJobScriptDefinitionBean.this.editArrayIndexActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.editArrayIndexButton, gridBagConstraints);
        this.cmdLineLabel.setText(JFResourceBundle.getString("File_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.cmdLineLabel, gridBagConstraints);
        this.cmdLineFLD.setColumns(20);
        this.cmdLineFLD.setToolTipText(JFResourceBundle.getString("JobScriptDefinitionBean$TIP_cmdLineFLD"));
        this.cmdLineFLD.setMinimumSize(new Dimension(300, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.cmdLineFLD, gridBagConstraints);
        this.workingDirLabel.setText(JFResourceBundle.getString("Working_directory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.workingDirLabel, gridBagConstraints);
        this.workingDirFLD.setColumns(20);
        this.workingDirFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_workingDirFLD"));
        this.workingDirFLD.setMinimumSize(new Dimension(300, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.workingDirFLD, gridBagConstraints);
        this.envVarsLabel.setText(JFResourceBundle.getString("Environment_variables"));
        this.envVarsLabel.setPreferredSize(new Dimension(120, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.envVarsLabel, gridBagConstraints);
        this.envVarsFLD.setEditable(false);
        this.envVarsFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_envVarsFLD"));
        this.envVarsFLD.setMinimumSize(new Dimension(250, 27));
        this.envVarsFLD.setPreferredSize(new Dimension(430, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.envVarsFLD, gridBagConstraints);
        this.m_envVarsModifyButton.setText(JFResourceBundle.getString("Modify..."));
        this.m_envVarsModifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFJobScriptDefinitionBean.this.m_envVarsModifyButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.m_envVarsModifyButton, gridBagConstraints);
        this.nonZeroCodesLabel.setText(JFResourceBundle.getString("Non_zero_exit_codes_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.nonZeroCodesLabel, gridBagConstraints);
        this.nonZeroCodesFLD.setColumns(20);
        this.nonZeroCodesFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_nonZeroCodesFLD"));
        this.nonZeroCodesFLD.setMinimumSize(new Dimension(300, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jobPanel.add((Component)this.nonZeroCodesFLD, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 10, 10, 10);
        this.generalPanel.add((Component)this.jobPanel, gridBagConstraints);
        this.jPanel1.setBorder(new TitledBorder(JFResourceBundle.getString("Run_As")));
        this.jPanel1.setPreferredSize(new Dimension(550, 150));
        this.jLabel6.setText(JFResourceBundle.getString("User_name_"));
        this.jPanel1.add(this.jLabel6);
        this.userNameFLD.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_usernameFLD"));
        this.userNameFLD.setPreferredSize(new Dimension(400, 21));
        this.jPanel1.add(this.userNameFLD);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.generalPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.tabbedPanel.addTab("General", null, this.generalPanel, "");
        this.tabbedPanel.addTab("Exception Handling", null, this.m_exceptionHanlderPanel, "");
        this.m_descriptionPanel.setLayout(new GridBagLayout());
        this.m_descriptionPanel.setBorder(new TitledBorder(JFResourceBundle.getString("Enter_Description_")));
        this.m_descriptionPanel.setPreferredSize(new Dimension(300, 200));
        this.jScrollPane1.setPreferredSize(new Dimension(400, 250));
        this.descriptionPane.setToolTipText(JFResourceBundle.getString("JobDefinitionBean$TIP_descriptionFLD"));
        this.descriptionPane.setPreferredSize(new Dimension(600, 400));
        this.jScrollPane1.setViewportView(this.descriptionPane);
        this.m_descriptionPanel.add((Component)this.jScrollPane1, new GridBagConstraints());
        this.tabbedPanel.addTab("Description", null, this.m_descriptionPanel, "");
        this.add((Component)this.tabbedPanel, "Center");
    }

    private void m_envVarsModifyButtonActionPerformed(ActionEvent actionEvent) {
        envVarsDialog = new JFJobEnvVarsDialog(this.getMainFrame(), true);
        envVarsDialog.setVarList(this.envVarsFLD.getText());
        envVarsDialog.setLocationRelativeTo(this);
        envVarsDialog.setTitle(JFResourceBundle.getString("JobDefinitionBean$TITLE_envVarsDialog"));
        envVarsDialog.setVisible(true);
        String string = envVarsDialog.getVarList();
        if (string != null) {
            this.envVarsFLD.setText(string);
        }
    }

    private void arrayIndexFLDFocusLost(FocusEvent focusEvent) {
        String string;
        if (this.editable && (string = this.arrayIndexFLD.getText().trim()) != null && string.length() > 0 && string.indexOf(91) == -1) {
            this.arrayIndexFLD.setText("[" + string + "]");
        }
    }

    private void editArrayIndexActionPerformed(ActionEvent actionEvent) {
        this.arrayIndexDialog.setIndex(this.arrayIndexFLD.getText());
        this.arrayIndexDialog.setEditable(this.editable);
        this.arrayIndexDialog.setLocationRelativeTo(this);
        this.arrayIndexDialog.show();
        if (this.arrayIndexDialog.isOkPressed()) {
            this.arrayIndexFLD.setText(this.arrayIndexDialog.getIndex());
        }
    }

    class BeanInputVerifier
    extends InputVerifier {
        BeanInputVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            if (jComponent == JFJobScriptDefinitionBean.this.nonZeroCodesFLD) {
                return JFUtility.verifyNonZeroCodes((JTextField)jComponent);
            }
            return true;
        }
    }
}

