/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowArray;
import com.platform.LSFJobFlow.api.JFHandler;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.ui.Debug;
import com.platform.LSFJobFlow.ui.JFExceptionHandlerDialog;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFExceptionHandlerBean
extends JPanel {
    private boolean m_editable = true;
    private boolean m_modified = false;
    private JList m_handlerList = null;
    private JDialog m_parentDialog = null;
    private DefaultListModel m_listModel = new DefaultListModel();
    private String m_name = null;
    private Object m_source = null;
    private JPanel m_handlerListPane;
    private JScrollPane m_handlerListScrollPane;
    private JButton m_addButton;
    private JButton m_removeButton;
    private JButton m_openButton;

    public JFExceptionHandlerBean() {
        this.m_handlerList = new JList(this.m_listModel);
        this.m_handlerList.setToolTipText(JFResourceBundle.getString("ExceptionHandlerBean$TIP_exceptionHandlingListFLD"));
        this.m_handlerList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setBackground(bl ? Color.blue : Color.white);
                this.setForeground(bl ? Color.white : Color.black);
                JFEvent jFEvent = ((JFHandler)object).getEvent();
                int n2 = ((JFHandler)object).getAction();
                String string = jFEvent.toString();
                string = string + "  -  ";
                string = n2 == 0 ? string + JFResourceBundle.getString("Kill") : (n2 == 1 ? string + JFResourceBundle.getString("Rerun") : string + JFResourceBundle.getString("Alarm"));
                this.setText(string);
                return this;
            }
        });
        this.m_handlerList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JFExceptionHandlerBean.this.setButtonOnSelection();
            }
        });
        this.initComponents();
        this.m_modified = false;
        this.setEditable(true);
    }

    public void setSource(Object object) throws IllegalArgumentException {
        JFHandler[] jFHandlerArray = null;
        if (object instanceof JFJobArray) {
            jFHandlerArray = ((JFJobArray)object).getJobDefinition().getHandlers();
        } else if (object instanceof JFJob) {
            jFHandlerArray = ((JFJob)object).getHandlers();
        } else if (object instanceof JFFlow) {
            jFHandlerArray = ((JFFlow)object).getHandlers();
        } else if (object instanceof JFFlowArray) {
            jFHandlerArray = ((JFFlowArray)object).getFlowDefinition().getHandlers();
        } else {
            throw new IllegalArgumentException();
        }
        for (int i = 0; jFHandlerArray != null && i < jFHandlerArray.length; ++i) {
            this.m_listModel.addElement(jFHandlerArray[i]);
        }
        this.m_source = object;
        this.setButtonOnSelection();
    }

    public boolean updateHandlers() {
        block8: {
            JFFlow jFFlow;
            JFHandler[] jFHandlerArray;
            block10: {
                block9: {
                    JFJob jFJob;
                    block7: {
                        jFHandlerArray = this.getHandlers();
                        jFJob = null;
                        jFFlow = null;
                        if (!(this.m_source instanceof JFJobArray)) break block7;
                        jFJob = ((JFJobArray)this.m_source).getJobDefinition();
                        if (jFJob == null) break block8;
                        jFJob.removeHandlers();
                        for (int i = 0; jFHandlerArray != null && i < jFHandlerArray.length; ++i) {
                            jFJob.addHandler(jFHandlerArray[i]);
                        }
                        break block8;
                    }
                    if (!(this.m_source instanceof JFJob)) break block9;
                    jFJob = (JFJob)this.m_source;
                    if (jFJob == null) break block8;
                    jFJob.removeHandlers();
                    if (jFHandlerArray != null) {
                        for (int i = 0; i < jFHandlerArray.length; ++i) {
                            jFJob.addHandler(jFHandlerArray[i]);
                        }
                    }
                    break block8;
                }
                if (!(this.m_source instanceof JFFlow)) break block10;
                jFFlow = (JFFlow)this.m_source;
                if (jFFlow == null) break block8;
                jFFlow.removeHandlers();
                if (jFHandlerArray != null) {
                    for (int i = 0; i < jFHandlerArray.length; ++i) {
                        jFFlow.addHandler(jFHandlerArray[i]);
                    }
                }
                break block8;
            }
            if (this.m_source instanceof JFFlowArray && (jFFlow = ((JFFlowArray)this.m_source).getFlowDefinition()) != null) {
                jFFlow.removeHandlers();
                for (int i = 0; jFHandlerArray != null && i < jFHandlerArray.length; ++i) {
                    jFFlow.addHandler(jFHandlerArray[i]);
                }
            }
        }
        return this.m_modified;
    }

    public JFHandler[] getHandlers() {
        if (this.m_listModel == null) {
            return null;
        }
        int n = this.m_listModel.size();
        if (n <= 0) {
            return null;
        }
        JFHandler[] jFHandlerArray = new JFHandler[n];
        for (int i = 0; i < n; ++i) {
            if (!(this.m_listModel.elementAt(i) instanceof JFHandler)) continue;
            jFHandlerArray[i] = (JFHandler)this.m_listModel.elementAt(i);
        }
        return jFHandlerArray;
    }

    public void reset() {
        this.m_listModel.removeAllElements();
        this.setButtonOnSelection();
    }

    public boolean isModified() {
        return this.m_modified;
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.m_handlerList.setOpaque(bl);
        if (this.m_editable) {
            this.m_openButton.setText(JFResourceBundle.getString("Edit..."));
            this.m_addButton.setEnabled(true);
        } else {
            this.m_openButton.setText(JFResourceBundle.getString("View..."));
            this.m_addButton.setEnabled(false);
            this.m_removeButton.setEnabled(false);
        }
    }

    JDialog getParentDialog() {
        if (this.m_parentDialog == null) {
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof JDialog)) continue;
                this.m_parentDialog = (JDialog)container;
                break;
            }
        }
        return this.m_parentDialog;
    }

    private void setButtonOnSelection() {
        boolean bl = this.m_handlerList.getSelectedIndex() != -1;
        this.m_openButton.setEnabled(bl);
        if (this.m_editable) {
            this.m_removeButton.setEnabled(bl);
        }
    }

    private void initComponents() {
        this.m_handlerListPane = new JPanel();
        this.m_handlerListScrollPane = new JScrollPane(this.m_handlerList);
        this.m_addButton = new JButton();
        this.m_removeButton = new JButton();
        this.m_openButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.m_handlerListPane.setLayout(new GridBagLayout());
        this.m_handlerListPane.setBorder(new TitledBorder(JFResourceBundle.getString("Exception_Handler_s_list")));
        this.m_handlerListPane.setToolTipText("");
        this.m_handlerListPane.setMinimumSize(new Dimension(520, 280));
        this.m_handlerListPane.setPreferredSize(new Dimension(520, 280));
        this.m_handlerListScrollPane.setMinimumSize(new Dimension(400, 200));
        this.m_handlerListScrollPane.setPreferredSize(new Dimension(400, 200));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.m_handlerListPane.add((Component)this.m_handlerListScrollPane, gridBagConstraints);
        this.m_addButton.setText(JFResourceBundle.getString("Add..."));
        this.m_addButton.setMaximumSize(new Dimension(85, 26));
        this.m_addButton.setMinimumSize(new Dimension(85, 26));
        this.m_addButton.setPreferredSize(new Dimension(85, 26));
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFExceptionHandlerBean.this.m_addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 5, 20, 5);
        this.m_handlerListPane.add((Component)this.m_addButton, gridBagConstraints);
        this.m_removeButton.setText(JFResourceBundle.getString("Remove"));
        this.m_removeButton.setMaximumSize(new Dimension(85, 26));
        this.m_removeButton.setMinimumSize(new Dimension(85, 26));
        this.m_removeButton.setPreferredSize(new Dimension(85, 26));
        this.m_removeButton.setEnabled(false);
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFExceptionHandlerBean.this.m_removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(20, 5, 20, 5);
        this.m_handlerListPane.add((Component)this.m_removeButton, gridBagConstraints);
        this.m_openButton.setText(JFResourceBundle.getString("Open..."));
        this.m_openButton.setMaximumSize(new Dimension(85, 26));
        this.m_openButton.setMinimumSize(new Dimension(85, 26));
        this.m_openButton.setPreferredSize(new Dimension(85, 26));
        this.m_openButton.setEnabled(false);
        this.m_openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFExceptionHandlerBean.this.m_openButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 5, 20, 5);
        this.m_handlerListPane.add((Component)this.m_openButton, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_handlerListPane, gridBagConstraints2);
    }

    private void m_addButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_source == null && !this.m_editable) {
            return;
        }
        JFExceptionHandlerDialog jFExceptionHandlerDialog = new JFExceptionHandlerDialog((Dialog)this.getParentDialog(), true, this.m_source);
        jFExceptionHandlerDialog.setLocationRelativeTo(this);
        JFHandler jFHandler = jFExceptionHandlerDialog.createNewHandler();
        if (jFHandler != null) {
            this.m_modified = true;
            try {
                this.m_listModel.addElement(jFHandler);
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
            }
        }
    }

    private void m_removeButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.m_editable || this.m_handlerList.isSelectionEmpty()) {
            return;
        }
        this.m_listModel.removeElementAt(this.m_handlerList.getSelectedIndex());
        this.m_modified = true;
        if (this.m_handlerList.getSelectedIndex() == -1) {
            this.setButtonOnSelection();
        }
    }

    private void m_openButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_source == null || this.m_handlerList.isSelectionEmpty()) {
            return;
        }
        int n = this.m_handlerList.getSelectedIndex();
        JFHandler jFHandler = (JFHandler)this.m_listModel.elementAt(n);
        JFExceptionHandlerDialog jFExceptionHandlerDialog = new JFExceptionHandlerDialog((Dialog)this.getParentDialog(), true, this.m_source);
        jFExceptionHandlerDialog.setLocationRelativeTo(this);
        JFHandler jFHandler2 = jFExceptionHandlerDialog.openHandler(jFHandler, this.m_editable);
        if (this.m_editable && jFHandler2 != null && !jFHandler2.equals(jFHandler)) {
            this.m_modified = true;
            try {
                this.m_listModel.insertElementAt(jFHandler2, n);
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
            }
            this.m_listModel.removeElementAt(n + 1);
        }
    }

    public String convertHandlersToXML() {
        StringBuffer stringBuffer = new StringBuffer();
        JFHandler[] jFHandlerArray = this.getHandlers();
        if (jFHandlerArray != null) {
            stringBuffer.append("<Exceptions>");
            for (int i = 0; i < jFHandlerArray.length; ++i) {
                stringBuffer.append(jFHandlerArray[i].toXML());
            }
            stringBuffer.append("\n  </Exceptions>");
            return stringBuffer.toString();
        }
        return null;
    }
}

