/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFEventInstance;
import com.platform.LSFJobFlow.ui.AbstractImageShape;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.LSFJobFlow.ui.JobFlowShapeINF;
import com.platform.LSFJobFlow.ui.LinkedEventShape;
import com.platform.LSFJobFlow.ui.PluginEventSourceShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

class EventShape
implements JobFlowShapeINF {
    public static final String JOB_EVENT = "jobEvent";
    public static final String JOBARRAY_EVENT = "jobarrayEvent";
    public static final String FLOW_EVENT = "flowEvent";
    public static final String DYNAMICFLOW_EVENT = "dynamicflowEvent";
    public static final String LINKED_EVENT = "LinkedEvent";
    public static final String FLOWARRAY_EVENT = "flowarrayEvent";
    public static final String DYNAMICFLOWARRAY_EVENT = "dynamicflowarrayEvent";
    public static final String VARIABLE_EVENT = "variableEvent";
    static final int MINI_RECT_WIDTH = 4;
    static final int MINI_RECT_HEIGHT = 4;
    JFEvent curEvent = null;
    JFEventInstance curEventInst = null;
    AbstractImageShape eventSource = null;
    AbstractImageShape eventDest = null;
    String eventType = null;
    int x0;
    int y0;
    int x1;
    int y1;
    boolean selectedFlag = true;
    boolean isErasing = false;
    boolean showExpression = true;

    public EventShape(JFEvent jFEvent, String string, AbstractImageShape abstractImageShape, AbstractImageShape abstractImageShape2) {
        this.eventSource = abstractImageShape;
        this.eventDest = abstractImageShape2;
        this.curEvent = jFEvent;
        this.eventType = string;
        this.selectedFlag = false;
    }

    public EventShape(JFEventInstance jFEventInstance, String string, AbstractImageShape abstractImageShape, AbstractImageShape abstractImageShape2) {
        this.eventSource = abstractImageShape;
        this.eventDest = abstractImageShape2;
        this.curEventInst = jFEventInstance;
        if (jFEventInstance != null) {
            this.curEvent = jFEventInstance.getEventDefinition();
        }
        this.eventType = string;
        this.selectedFlag = false;
    }

    public AbstractImageShape getSourceShape() {
        return this.eventSource;
    }

    public AbstractImageShape getDestShape() {
        return this.eventDest;
    }

    public boolean overlaps(EventShape eventShape) {
        return this.x0 == eventShape.x0 && this.y0 == eventShape.y0 && this.x1 == eventShape.x1 && this.y1 == eventShape.y1;
    }

    @Override
    public int distanceSq(int n, int n2) {
        return this.eventSource.distanceSq(n, n2) * 100 + this.eventDest.distanceSq(n, n2);
    }

    public void resetDestShape(AbstractImageShape abstractImageShape) {
        if (abstractImageShape != null) {
            this.eventDest = abstractImageShape;
        }
    }

    public JFEvent getEvent() {
        if (this.eventSource == null) {
            return null;
        }
        if (this.eventSource instanceof LinkedEventShape) {
            this.curEvent = ((LinkedEventShape)this.eventSource).getLinkEvent();
        } else if (this.eventSource instanceof PluginEventSourceShape) {
            this.curEvent = ((PluginEventSourceShape)this.eventSource).getEvent();
        }
        return this.curEvent;
    }

    public JFEventInstance getEventInst() {
        return this.curEventInst;
    }

    public void setEvent(JFEvent jFEvent) {
        this.curEvent = jFEvent;
        if (this.eventDest != null && this.eventDest instanceof LinkedEventShape) {
            ((LinkedEventShape)this.eventDest).setModified();
        }
        if (this.eventSource != null && this.eventSource instanceof PluginEventSourceShape) {
            ((PluginEventSourceShape)this.eventSource).setEvent(jFEvent);
        }
    }

    public boolean associateWith(AbstractImageShape abstractImageShape) {
        return abstractImageShape == this.eventSource || abstractImageShape == this.eventDest;
    }

    public String getEventType() {
        return this.eventType;
    }

    @Override
    public boolean contains(int n, int n2, Graphics2D graphics2D) {
        Line2D.Float float_ = new Line2D.Float(this.x0, this.y0, this.x1, this.y1);
        if (float_ == null) {
            return false;
        }
        double d = (double)n - 2.5;
        double d2 = (double)n2 - 2.5;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return float_.intersects(d, d2, 5.0, 5.0);
    }

    @Override
    public boolean intersects(JobFlowShapeINF jobFlowShapeINF, Graphics2D graphics2D) {
        Line2D.Float float_ = new Line2D.Float(this.x0, this.y0, this.x1, this.y1);
        if (float_ == null) {
            return false;
        }
        Rectangle rectangle = jobFlowShapeINF.getOutline(graphics2D);
        if (rectangle == null) {
            return false;
        }
        return float_.intersects(rectangle);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (!this.isErasing) {
            graphics2D.setColor(Color.black);
        }
        this.calculateEndPoints();
        graphics2D.drawLine(this.x0, this.y0, this.x1, this.y1);
        if (this.curEvent != null && !this.curEvent.isProxy() && this.showExpression) {
            String string = this.curEvent.getExpression();
            if (string == null) {
                string = "";
            }
            double d = this.x1 - this.x0;
            double d2 = this.y1 - this.y0;
            graphics2D.drawString(string, (float)((double)this.x0 + d / 3.0), (float)((double)this.y0 + d2 / 3.0));
        }
        int n = this.x1 - this.x0;
        int n2 = this.y1 - this.y0;
        double d = Math.atan((double)n2 / (double)n) * 180.0 / 3.141569;
        int n3 = (int)d;
        n3 = n >= 0 ? 180 - n3 : -n3;
        graphics2D.fillArc(this.x1 - 17, this.y1 - 17, 35, 35, n3 - 17, 35);
        if (this.selectedFlag && (this.x0 != this.x1 || this.y0 != this.y1)) {
            if (this.x0 <= this.x1 && this.y0 <= this.y1) {
                graphics2D.drawRect(this.x0, this.y0, 4, 4);
                graphics2D.drawRect(this.x1 - 4, this.y1 - 4, 4, 4);
            } else if (this.x0 <= this.x1 && this.y0 > this.y1) {
                graphics2D.drawRect(this.x0, this.y0 - 4, 4, 4);
                graphics2D.drawRect(this.x1 - 4, this.y1, 4, 4);
            } else if (this.x0 > this.x1 && this.y0 <= this.y1) {
                graphics2D.drawRect(this.x0 - 4, this.y0, 4, 4);
                graphics2D.drawRect(this.x1, this.y1 - 4, 4, 4);
            } else {
                graphics2D.drawRect(this.x0 - 4, this.y0 - 4, 4, 4);
                graphics2D.drawRect(this.x1, this.y1, 4, 4);
            }
        }
    }

    @Override
    public void erase(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.white);
        this.isErasing = true;
        this.selectedFlag = true;
        this.draw(graphics2D);
        this.isErasing = false;
        this.selectedFlag = false;
        graphics2D.setColor(color);
    }

    @Override
    public void drawOutline(Graphics2D graphics2D) {
        this.calculateEndPoints();
        graphics2D.drawLine(this.x0, this.y0, this.x1, this.y1);
    }

    @Override
    public Rectangle getOutline(Graphics2D graphics2D) {
        Line2D.Float float_ = new Line2D.Float(this.x0, this.y0, this.x1, this.y1);
        if (float_ == null) {
            return null;
        }
        Rectangle rectangle = float_.getBounds();
        if (rectangle == null) {
            return null;
        }
        if (rectangle.isEmpty()) {
            rectangle.grow(5, 5);
        }
        return rectangle;
    }

    public String toString() {
        return this.eventType;
    }

    @Override
    public String getTipString() {
        return this.toString();
    }

    @Override
    public void setSelected(boolean bl) {
        this.selectedFlag = bl;
    }

    @Override
    public boolean isSelected() {
        return this.selectedFlag;
    }

    public void setShowExpression(boolean bl) {
        this.showExpression = bl;
    }

    void calculateEndPoints() {
        this.x0 = this.eventSource.getX();
        this.y0 = this.eventSource.getY();
        this.x1 = this.eventDest.getX();
        this.y1 = this.eventDest.getY();
        Rectangle rectangle = this.eventSource.getImageOutline();
        Rectangle rectangle2 = this.eventDest.getImageOutline();
        if (this.x0 != this.x1 || this.y0 != this.y1) {
            if (this.x0 + rectangle.width < this.x1) {
                this.x0 += rectangle.width;
                this.y0 += rectangle.height / 2;
                this.y1 += rectangle2.height / 2;
            } else if (this.x1 + rectangle2.width < this.x0) {
                this.x1 += rectangle2.width;
                this.y1 += rectangle2.height / 2;
                this.y0 += rectangle.height / 2;
            } else if (this.y0 < this.y1) {
                this.x0 += rectangle.width / 2;
                this.y0 += rectangle.height;
                this.x1 += rectangle2.width / 2;
            } else {
                this.x1 += rectangle2.width / 2;
                this.y1 += rectangle2.height;
                this.x0 += rectangle.width / 2;
            }
        }
    }

    @Override
    public String getRuntimeAttributesStr() {
        String string = null;
        if (this.curEventInst != null) {
            String string2;
            JFEvent jFEvent;
            string = "[" + JFResourceBundle.getString("Trigger_time") + "] : ";
            String string3 = this.curEventInst.getTimeString();
            if (string3 != null) {
                string = string + string3;
                if (this.curEventInst.isCompletedManually()) {
                    string = string + " " + JFResourceBundle.getString("Completed_Manually");
                }
            }
            if ((jFEvent = this.curEventInst.getEventDefinition()) != null) {
                string2 = jFEvent.getAttribute("Description");
                if (string2 != null && !string2.equals("") && !string2.equals("null")) {
                    string = string + "\n[" + JFResourceBundle.getString("Description") + "] : " + JFUtility.decodeXML(string2);
                }
                if (string3 != null) {
                    String string4 = jFEvent.getAttribute("Source");
                    if (jFEvent.isProxy() && string4 != null && !string4.equals("") && !string4.equals("null")) {
                        string = string + "\n[" + JFResourceBundle.getString("Source") + "] :" + string4;
                    }
                }
            }
            if ((string2 = this.curEventInst.getRuntimeInfo()) != null) {
                string = string + "\n[" + JFResourceBundle.getString("Comments") + "] : " + this.curEventInst.getRuntimeInfo();
            }
        }
        return string;
    }
}

