/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.importcubes;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class ImportUtil {
    public static Cube getCube(String schemaName, String cubeName, MdObjectStore objectStore, MdFactory factory) throws MdException, RemoteException {
        OLAPSchema schema = ImportUtil.getOLAPSchema(schemaName, objectStore, factory);
        Cube cube = null;
        if (schema == null) {
            cube = ImportUtil.getCube(cubeName, objectStore, factory);
        } else {
            AssociationList alCubes = null;
            if (schema != null) {
                alCubes = ImportUtil.getCubes(schema, objectStore, factory);
            }
            boolean found = false;
            for (int i = 0; alCubes != null && !found && i < alCubes.size(); ++i) {
                cube = (Cube)alCubes.get(i);
                if (!cube.getName().equals(cubeName)) continue;
                found = true;
            }
        }
        return cube;
    }

    public static Cube getCube(String name, MdObjectStore objectStore, MdFactory factory) throws MdException, RemoteException {
        String type;
        String sOptions = "<XMLSELECT Search=\"Cube[@Name='" + name + "']\"/><TEMPLATES><Cube Id=\"\" Name=\"\" Desc=\"\"></Cube></TEMPLATES>";
        String repositoryFQID = factory.getOMIUtil().getFoundationReposID();
        List lCubes = null;
        lCubes = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, repositoryFQID, "Cube", 24972, sOptions);
        if (lCubes == null || lCubes.size() == 0) {
            return null;
        }
        Cube cube = null;
        for (int i = 0; !(i >= lCubes.size() || (cube = (Cube)lCubes.get(i)).getAssociatedOLAPSchema() == null && ((type = cube.getPublicType()) == null || type != null && type.equals(""))); ++i) {
        }
        return cube;
    }

    public static AssociationList getCubes(OLAPSchema schema, MdObjectStore objectStore, MdFactory factory) throws MdException, RemoteException {
        String sOptions = "<XMLSELECT Search=\"OLAPSchema[@Id='" + schema.getId() + "']\"/><TEMPLATES><OLAPSchema Id=\"\" Name=\"\" Desc=\"\"><Cubes/></OLAPSchema></TEMPLATES>";
        String repositoryFQID = factory.getOMIUtil().getFoundationReposID();
        List lSchemas = null;
        lSchemas = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, repositoryFQID, "OLAPSchema", 24972, sOptions);
        if (lSchemas == null || lSchemas.size() == 0) {
            return null;
        }
        OLAPSchema oSchema = (OLAPSchema)lSchemas.get(0);
        return oSchema.getCubes();
    }

    public static OLAPSchema getOLAPSchema(String schemaName, MdObjectStore objectStore, MdFactory factory) throws MdException, RemoteException {
        String sOptions = "<XMLSELECT Search=\"OLAPSchema[@Name='" + schemaName + "']\"/><TEMPLATES><OLAPSchema Id=\"\" Name=\"\" Desc=\"\"></OLAPSchema></TEMPLATES>";
        List lSchemas = null;
        lSchemas = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, factory.getOMIUtil().getFoundationReposID(), "OLAPSchema", 24972, sOptions);
        if (lSchemas == null || lSchemas.size() == 0) {
            return null;
        }
        OLAPSchema schema = (OLAPSchema)lSchemas.get(0);
        return schema;
    }
}

