/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.importcubes;

import com.sas.management.deployment.ConnectionPoint;
import com.sas.management.deployment.DeployMetadata;
import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.DeploymentMapping;
import com.sas.management.deployment.DeploymentObject;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.importcubes.CubeSubstitutions;
import com.sas.workspace.WAdminResource;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class DeployCube
extends DeployMetadata {
    private static WAdminResource bundle = new WAdminResource(DeployCube.class);
    private DeploymentObject m_deployedCube;
    private DeploymentMapping m_deployMap;
    private CubeSubstitutions m_substitutions;
    private String m_newCubeName;
    private String m_OLAPSchemaName;
    private String targetOLAPSchemaName;
    private String targetOLAPSchemaID;
    private String targetRepositoryID;
    private static final String BLANK = "";

    public DeployCube(String sFile, MdFactory mdFactory) throws DeploymentException, IOException, MdException {
        super(mdFactory);
        File fFile = new File(sFile);
        this.m_deployMap = new DeploymentMapping(mdFactory, fFile);
        this.m_substitutions = new CubeSubstitutions(this.getTopLevelCube(), this.m_deployMap);
        this.m_newCubeName = BLANK;
    }

    public void createUniqueCubeName(MdObjectStore store, Logger logger) throws RemoteException, DeploymentException, OLAPException {
        String originalName;
        String cubeName;
        boolean nameIsUnique = false;
        this.m_newCubeName = cubeName = (originalName = this.getName());
        int i = 0;
        while (!nameIsUnique) {
            if (!ModelUtilities.isCubeNameUniqueToOLAPSchema((String)cubeName, (OLAPSchema)ModelUtilities.getOLAPSchema((String)this.getTargetOLAPSchemaName(), (MdObjectStore)store))) {
                cubeName = this.m_newCubeName = originalName + "(" + (i + 1) + ")";
            } else {
                nameIsUnique = true;
            }
            ++i;
        }
        if (!this.m_newCubeName.equals(originalName)) {
            logger.warn(bundle.formatString("DeployCube.CubeHasBeenRenamed.fmt.txt", (Object)originalName, (Object)this.m_newCubeName));
        }
    }

    public boolean doesCubeExist() {
        return !this.m_substitutions.getCubeName().equals(BLANK);
    }

    public String getOLAPSchemaName() {
        if (this.m_OLAPSchemaName == null) {
            this.m_OLAPSchemaName = this.findOLAPSchemaNameFromDeployment();
        }
        return this.m_OLAPSchemaName;
    }

    public String getTargetOLAPSchemaName() {
        return this.targetOLAPSchemaName;
    }

    public DeploymentObject getTopLevelCube() throws DeploymentException {
        if (this.m_deployedCube == null) {
            DeploymentObject topObject;
            List lTop = this.m_deployMap.getTopLevelObjects();
            if (lTop.size() > 1) {
                throw new DeploymentException(bundle.getString("DeployCube.ExtractFileError.txt"));
            }
            this.m_deployedCube = topObject = (DeploymentObject)lTop.get(0);
        }
        return this.m_deployedCube;
    }

    public String getName() throws DeploymentException {
        if (this.m_deployedCube == null) {
            this.getTopLevelCube();
        }
        return this.m_deployedCube.getName();
    }

    public void setTargetCubeName(String name) {
        this.m_newCubeName = name;
    }

    public String getNewCubeName() {
        return this.m_newCubeName;
    }

    public CubeSubstitutions getCubeSubstitutions() {
        return this.m_substitutions;
    }

    public boolean prepareDeploy(Logger logger) throws DeploymentException, RemoteException, MdException {
        Map.Entry entry;
        String name;
        if (this.m_deployMap.getExtractFileVersion() != 9134) {
            throw new DeploymentException(bundle.getString("DeployCube.ExtractFileVersionError.txt"));
        }
        Map templates = this.m_deployMap.getExtractTemplates();
        Iterator it = templates.entrySet().iterator();
        if (it.hasNext() && !(name = (String)(entry = it.next()).getKey()).equals("ExtractCubeTemplateWithSecurity") && !name.equals("ExtractCubeTemplateWithoutSecurity")) {
            throw new DeploymentException(bundle.getString("DeployCube.ExtractTemplateVersionError.txt"));
        }
        this.mapAllRepositories(logger);
        this.m_substitutions.parseCubeSubstitutions();
        return true;
    }

    public void mapAllRepositories(Logger logger) throws MdException, DeploymentException, RemoteException {
        Map srcMap = this.m_deployMap.getSourceRepositoryMap();
        HashMap<String, String> reposMap = new HashMap<String, String>();
        int i = 0;
        for (Map.Entry entry : srcMap.entrySet()) {
            String repID = (String)entry.getKey();
            String repName = (String)entry.getValue();
            String targetID = this.getTargetRepositoryInfo(repName, false);
            if (targetID == null) {
                logger.warn(bundle.formatString("DeployCube.RepositoryNotFound.fmt.txt", (Object)repName));
                targetID = this._factory.getOMIUtil().getFoundationReposID();
            }
            reposMap.put(repID, targetID);
            ++i;
        }
        this.mapRepositories(reposMap);
        this.m_deployMap.setTargetRepositoryIDs(reposMap);
    }

    public void mapRepositories() throws DeploymentException, RemoteException, MdException {
        String targetRepId = null;
        targetRepId = this.targetRepositoryID.equals(BLANK) ? this._factory.getOMIUtil().getFoundationReposID() : this.targetRepositoryID;
        Map srcMap = this.m_deployMap.getSourceRepositoryMap();
        String sourceRepId = null;
        HashMap<String, String> reposMap = new HashMap<String, String>();
        int i = 0;
        for (Map.Entry entry : srcMap.entrySet()) {
            Object key = entry.getKey();
            if (key == null) {
                throw new DeploymentException(bundle.getString("DeployCube.GetSourceRepositoryError.txt"));
            }
            sourceRepId = (String)key;
            reposMap.put(sourceRepId, targetRepId);
            ++i;
        }
        this.mapRepositories(reposMap);
        this.m_deployMap.setTargetRepositoryIDs(reposMap);
    }

    public void deploy() throws DeploymentException, RemoteException {
        if (!this.getName().equalsIgnoreCase(this.m_newCubeName)) {
            this.m_substitutions.updateNameSubstitutions(this.m_newCubeName);
        }
        this.m_substitutions.updateDeployMapWithSubstitutions();
        String updatedExtract = this.m_deployMap.getUpdatedExtractString();
        this.deploy(updatedExtract, 2);
    }

    private String findOLAPSchemaNameFromDeployment() {
        List lConnections = this.m_deployMap.getConnectionPoints();
        for (int i = 0; i < lConnections.size(); ++i) {
            ConnectionPoint conn = (ConnectionPoint)lConnections.get(i);
            if (!conn.getType().equals("OLAPSchema")) continue;
            return conn.getName();
        }
        return null;
    }

    public void setTargetOLAPSchema(String name, String id) {
        this.targetOLAPSchemaName = name;
        this.targetOLAPSchemaID = id;
    }

    public void setTargetRepositoryId(String id) {
        this.targetRepositoryID = id;
    }

    public void makeConnections(Logger logger) throws DeploymentException {
        boolean connectionFailure = false;
        List lConnections = this.m_deployMap.getConnectionPoints();
        for (int i = 0; i < lConnections.size(); ++i) {
            ConnectionPoint conn = (ConnectionPoint)lConnections.get(i);
            String type = conn.getType();
            if ("Person".equals(type)) {
                conn.setConnectionAction('W');
            }
            StringBuffer connErr = new StringBuffer();
            connErr.append(bundle.formatString("DeployCube.ConnectionFailure.fmt.txt", (Object)conn.getType(), (Object)conn.getName()));
            conn.setConnectionMessage(connErr.toString());
            this.m_deployMap.updateConnectionPoint(conn);
            if (conn.getType().equals("OLAPSchema") && this.targetOLAPSchemaID != null) {
                conn.setTargetObjectID(this.targetOLAPSchemaID);
                this.m_deployMap.updateConnectionPoint(conn);
                continue;
            }
            try {
                this.m_deployMap.autoMapConnectionPoint(conn);
            }
            catch (DeploymentException depEx) {
                logger.error(conn.getConnectionMessage());
                connectionFailure = true;
            }
            if (conn.getConnectionAction() == 'W' && !conn.hasConnectionBeenSet()) {
                logger.warn(conn.getConnectionMessage());
            }
            if (!conn.getType().equals("OLAPSchema") || !conn.hasConnectionBeenSet()) continue;
            this.targetOLAPSchemaName = conn.getName();
        }
        if (connectionFailure) {
            throw new DeploymentException(bundle.formatString("DeployCube.ConnectionCubeName.fmt.txt", (Object)this.getName()));
        }
    }
}

