/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.importcubes;

import com.sas.management.deployment.DeploymentException;
import com.sas.management.deployment.DeploymentMapping;
import com.sas.management.deployment.DeploymentObject;
import com.sas.management.deployment.Substitution;
import com.sas.olapadmin.importcubes.CubeSubstitution;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CubeSubstitutions {
    private static WAdminResource bundle = new WAdminResource(CubeSubstitutions.class);
    private static final String CLASS = "CLASS";
    private static final String VERSION = "Version";
    private static final String NO_NWAY = "NO_NWAY";
    private static final String ALLMEMBERCAPTION = "AllMemberCaption";
    private static final String WORKPATH = "WORKPATH";
    private static final String DATAPATH = "DATAPATH";
    private static final String INDEXPATH = "INDEXPATH";
    private DeploymentObject m_deployedCube;
    private List m_substitutions;
    private DeploymentMapping m_deployMap;
    private List m_aggregationSubs;
    private CubeSubstitution m_cubePath;
    private CubeSubstitution m_cubeName;
    private CubeSubstitution m_workPath;
    private CubeSubstitution m_indexPath;
    private CubeSubstitution m_dataPath;
    private static final String CUBENAME = "CubeName";
    private static final String NAME = "Name";
    private static final String DESC = "Desc";
    private static final String FILENAME = "FileName";
    private static final String UNDERSCOREFILE = "_File";

    public CubeSubstitutions(DeploymentObject cube, DeploymentMapping deployMapping) throws DeploymentException {
        this.m_deployedCube = cube;
        this.m_deployMap = deployMapping;
        this.m_substitutions = this.initializeCubeSubstitutions();
        this.m_aggregationSubs = new ArrayList();
    }

    public String getCubePath() {
        return this.m_cubePath.getAttributeValue();
    }

    public void setCubePath(String path) {
        if (this.m_cubePath != null) {
            this.m_cubePath.setAttributeValue(path);
        }
    }

    public String getCubeName() {
        return this.m_cubeName.getAttributeValue();
    }

    public void setCubeName(String name) {
        this.m_cubeName.setAttributeValue(name);
    }

    public String getWorkPath() {
        if (this.m_workPath != null) {
            return this.m_workPath.getAttributeValue();
        }
        return "";
    }

    public void setWorkPath(String path) {
        if (this.m_workPath != null) {
            this.m_workPath.setAttributeValue(path);
        }
    }

    public String getIndexPath() {
        if (this.m_indexPath != null) {
            return this.m_indexPath.getAttributeValue();
        }
        return "";
    }

    public void setIndexPath(String path) {
        if (this.m_indexPath != null) {
            this.m_indexPath.setAttributeValue(path);
        }
    }

    public String getDataPath() {
        if (this.m_dataPath != null) {
            return this.m_dataPath.getAttributeValue();
        }
        return "";
    }

    public void setDataPath(String path) {
        if (this.m_dataPath != null) {
            this.m_dataPath.setAttributeValue(path);
        }
    }

    public List getAggrSubstitutions() {
        return this.m_aggregationSubs;
    }

    private List initializeCubeSubstitutions() throws DeploymentException {
        if (this.m_substitutions == null) {
            List lSub = this.m_deployMap.getSubstitutions();
            this.m_substitutions = new ArrayList();
            for (int i = 0; i < lSub.size(); ++i) {
                Substitution sub = (Substitution)lSub.get(i);
                if (sub.getName().equals(CLASS) || sub.getName().equals(NO_NWAY) || sub.getName().equals(ALLMEMBERCAPTION)) continue;
                if (sub.getName().equals(VERSION)) {
                    int MAX_CUBE_VERSION;
                    String cubeVersion = sub.getAttributeValue();
                    int iCubeVersion = Integer.parseInt(cubeVersion);
                    if (iCubeVersion <= (MAX_CUBE_VERSION = 3)) continue;
                    throw new DeploymentException(bundle.getString("DeployCube.CubeVersionError.txt"));
                }
                this.m_substitutions.add(new CubeSubstitution(sub));
            }
        }
        return this.m_substitutions;
    }

    public void parseCubeSubstitutions() throws DeploymentException {
        this.m_cubeName = this.findObjectInSubstitutionsById(this.m_deployedCube.getObjectID(), CUBENAME);
        this.m_cubePath = this.findObjectInSubstitutionsByType("Directory");
        Map topMap = this.m_deployMap.getAssociationsForObject(this.m_deployedCube, CubeSubstitutions.getDeploySearchTemplate());
        Map assocMap = (Map)topMap.get(this.m_deployedCube.getObjectID());
        List lProperties = (List)assocMap.get("Properties");
        for (int i = 0; i < lProperties.size(); ++i) {
            Map mProp = (Map)lProperties.get(i);
            String id = (String)mProp.get("Id");
            CubeSubstitution cubeProp = this.findObjectInSubstitutions(id);
            if (cubeProp == null) continue;
            if (cubeProp.getName().equals(WORKPATH)) {
                this.m_workPath = cubeProp;
                continue;
            }
            if (cubeProp.getName().equals(INDEXPATH)) {
                this.m_indexPath = cubeProp;
                continue;
            }
            if (!cubeProp.getName().equals(DATAPATH)) continue;
            this.m_dataPath = cubeProp;
        }
        List lAggrs = (List)assocMap.get("Aggregations");
        for (int i = 0; i < lAggrs.size(); ++i) {
            Map mAggrs = (Map)lAggrs.get(i);
            String aggrName = (String)mAggrs.get(NAME);
            List lProps = (List)mAggrs.get("Properties");
            for (int j = 0; j < lProps.size(); ++j) {
                Map mProp = (Map)lProps.get(j);
                String id = (String)mProp.get("Id");
                CubeSubstitution cubeProp = this.findObjectInSubstitutions(id);
                if (cubeProp == null || !cubeProp.getName().equals(DATAPATH) && !cubeProp.getName().equals(INDEXPATH)) continue;
                cubeProp.setAggregationName(aggrName);
                this.m_aggregationSubs.add(cubeProp);
            }
        }
    }

    public static String getDeploySearchTemplate() {
        String sTemplate = "<Template> \t<Cube>\t\t<Properties>\t  \t\t<Property DefaultValue=\"\"/>       </Properties>      \t<AssociatedFile>\t\t\t<File>\t\t\t\t<Directories>\t\t\t\t\t<Directory DirectoryName=\"\"/> \t\t\t\t</Directories>\t\t\t</File>\t\t</AssociatedFile>\t\t<Aggregations>\t\t\t<Aggregation>\t\t\t\t<Properties>\t\t\t\t\t<Property DefaultValue=\"\"/>\t\t\t\t</Properties>\t\t\t</Aggregation>\t\t</Aggregations>\t</Cube></Template>";
        return sTemplate;
    }

    public boolean supportsNameSubstitution() {
        String cubeObjectID = this.m_deployedCube.getObjectID();
        CubeSubstitution sub = this.findObjectInSubstitutionsById(cubeObjectID, NAME);
        return sub != null;
    }

    public void updateNameSubstitutions(String newCubeName) {
        String cubeObjectID = this.m_deployedCube.getObjectID();
        CubeSubstitution sub = this.findObjectInSubstitutionsById(cubeObjectID, NAME);
        sub.setAttributeValue(newCubeName);
        sub = this.findObjectInSubstitutionsById(cubeObjectID, DESC);
        if (sub.getAttributeValue().equals(this.m_deployedCube.getName())) {
            sub.setAttributeValue(newCubeName);
        }
        sub = this.findObjectInSubstitutionsByType("File", NAME);
        sub.setAttributeValue(newCubeName + UNDERSCOREFILE);
        sub = this.findObjectInSubstitutionsByType("File", FILENAME);
        sub.setAttributeValue(newCubeName);
        sub = this.findObjectInSubstitutionsByType("Job");
        if (sub.getAttributeValue().equals(this.m_deployedCube.getName())) {
            sub.setAttributeValue(newCubeName);
        }
        sub = this.findObjectInSubstitutionsByType("TransformationActivity");
        sub.setAttributeValue(newCubeName);
        sub = this.findObjectInSubstitutionsByType("TransformationStep");
        sub.setAttributeValue(newCubeName);
    }

    public CubeSubstitution findObjectInSubstitutions(String id) {
        for (int i = 0; i < this.m_substitutions.size(); ++i) {
            CubeSubstitution sub = (CubeSubstitution)this.m_substitutions.get(i);
            if (!sub.getObjectID().equals(id)) continue;
            return sub;
        }
        return null;
    }

    private CubeSubstitution findObjectInSubstitutionsById(String id, String attributeName) {
        for (int i = 0; i < this.m_substitutions.size(); ++i) {
            CubeSubstitution sub = (CubeSubstitution)this.m_substitutions.get(i);
            if (!sub.getObjectID().equals(id) || !sub.getAttribute().equals(attributeName)) continue;
            return sub;
        }
        return null;
    }

    public CubeSubstitution findObjectInSubstitutionsByType(String type) {
        for (int i = 0; i < this.m_substitutions.size(); ++i) {
            CubeSubstitution sub = (CubeSubstitution)this.m_substitutions.get(i);
            if (!sub.getType().equals(type)) continue;
            return sub;
        }
        return null;
    }

    private CubeSubstitution findObjectInSubstitutionsByType(String type, String attributeName) {
        for (int i = 0; i < this.m_substitutions.size(); ++i) {
            CubeSubstitution sub = (CubeSubstitution)this.m_substitutions.get(i);
            if (!sub.getType().equals(type) || !sub.getAttribute().equals(attributeName)) continue;
            return sub;
        }
        return null;
    }

    public void updateDeployMapWithSubstitutions() {
        for (int i = 0; i < this.m_substitutions.size(); ++i) {
            CubeSubstitution cubeSub = (CubeSubstitution)this.m_substitutions.get(i);
            Substitution sub = cubeSub.getBaseSubstitution();
            Workspace.getDefaultLogger().debug((Object)("name=" + sub.getName() + "value=" + sub.getAttributeValue()));
            if (!sub.hasAttributeBeenModified()) continue;
            this.m_deployMap.updateSubstitution(sub);
        }
    }
}

