/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPTable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

abstract class TableClassifierMap
extends OLAPTable {
    static final String AGGREGATE_FEATUREMAP_ONETOONE_ROLE = "ONETOONE";
    static final String AGGREGATE_TRANSFORM_ROLE = "AGGREGATE";
    static final String STAR_DIMENSION_TRANSFORM_ROLE = "STARDIM";
    static final String BASE_TRANSFORM_ROLE = "BASE";
    static final String NWAY_TRANSFROM_ROLE = "NWAY";
    static final String STAR_FACT_TRANSFORM_ROLE = "STARFACT";
    static final String STAR_SHARED_DIM_TRANSFORM_ROLE = "STARDIM";
    static final String LOAD_MAP_NAME = "Load Map";
    ClassifierMap classifierMap;
    AssociationList maps;
    AssociationList sources;

    TableClassifierMap() {
    }

    ClassifierMap createClassifierMap() throws OLAPException {
        if (this.classifierMap == null) {
            List classifierMaps = this.tableSet.getClassifierMaps();
            OLAPCube owningCube = this.tableSet.getOwningCube();
            this.classifierMap = (ClassifierMap)MetadataTemplate.createMetadata(owningCube.getObjectStore(), "ClassifierMap", owningCube.getRepositoryShortFQID());
            try {
                this.classifierMap.setName(LOAD_MAP_NAME);
                this.classifierMap.setTransformRole(BASE_TRANSFORM_ROLE);
                this.classifierMap.setIsActive(1);
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            classifierMaps.add(this.classifierMap);
            this.sources.add((Object)this.classifierMap);
            this.maps.add((Object)this.classifierMap);
        }
        return this.classifierMap;
    }

    void deleteClassifierMap() throws OLAPException {
        this.getClassifierMap();
        if (this.classifierMap != null) {
            OLAPCube owningCube = this.tableSet.getOwningCube();
            MetadataTemplate.deleteMetadata(owningCube.getObjectStore(), (CMetadata)this.classifierMap, "<Templates><SourceCode/><FeatureMaps/></Templates>", bundle.getString("MdException.GenericError.txt"));
            this.sources.remove((Object)this);
            this.maps.remove((Object)this);
        }
    }

    ClassifierMap getClassifierMap() throws OLAPException {
        if (this.classifierMap == null) {
            int i = this.maps.size() - 1;
            while (i >= 0 & this.classifierMap == null) {
                ClassifierMap map = (ClassifierMap)this.maps.get(i);
                if (this.sources.indexOf((Object)map) >= 0) {
                    this.classifierMap = map;
                }
                --i;
            }
        }
        return this.classifierMap;
    }

    @Override
    void setMapToTable(PhysicalTable inputTable, Map inputColumns) throws OLAPException {
        super.setMapToTable(inputTable, inputColumns);
    }
}

