/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPProperty;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.designer.model.AbstractInputTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.OLAPTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class SharedDimensionTable
extends AbstractInputTable {
    private OLAPSharedDimension olapDim;
    private PhysicalTable mappedTable;
    private Map mappedTableColumns;
    private boolean isMapChanged;
    private List removeUnmappedMessages;

    SharedDimensionTable(TableSet inputTableSet, PhysicalTable inputTable) throws OLAPException {
        this.tableSet = inputTableSet;
        this.olapDim = this.tableSet.getOwningSharedDimension();
        this.table = inputTable;
        List tables = this.tableSet.getTables();
        tables.add(this);
    }

    @Override
    ClassifierMap createClassifierMap() throws OLAPException {
        if (this.classifierMap == null) {
            this.classifierMap = (ClassifierMap)MetadataTemplate.createMetadata(this.olapDim.getObjectStore(), "ClassifierMap", this.olapDim.getRepositoryShortFQID());
            try {
                StringBuffer name = new StringBuffer();
                name.append(this.olapDim.getName()).append("_").append(this.table.getSASTableName()).append("_").append("ClassifierMap");
                this.classifierMap.setName(name.toString());
                this.classifierMap.setTransformRole("STARDIM");
                this.classifierMap.setIsActive(1);
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        }
        return this.classifierMap;
    }

    public void clearMap() throws OLAPException {
        this.mappedTable = null;
        if (this.mappedTableColumns != null) {
            this.mappedTableColumns.clear();
            this.mappedTableColumns = null;
        }
        this.olapDim.getOLAPMemberPropertySet().clearMapTable();
        this.removeUnmappedMessages = null;
    }

    @Override
    void deleteClassifierMap() throws OLAPException {
        this.getClassifierMap();
        if (this.classifierMap != null) {
            MetadataTemplate.deleteMetadata(this.olapDim.getObjectStore(), (CMetadata)this.classifierMap, "<Templates><SourceCode/><FeatureMaps/></Templates>", bundle.getString("MdException.GenericError.txt"));
        }
    }

    public boolean isPerfectMap() {
        boolean perfectMap = true;
        try {
            OLAPMemberPropertySet propertySet = this.olapDim.getOLAPMemberPropertySet();
            OLAPList unMappedLevels = this.olapDim.getUnmappedLevels();
            OLAPList unMappedProperties = propertySet.getUnmappedOLAPMemberProperties();
            if (unMappedLevels != null) {
                boolean bl = perfectMap = perfectMap && unMappedLevels.isEmpty();
            }
            if (unMappedProperties != null) {
                perfectMap = perfectMap && unMappedProperties.isEmpty();
            }
        }
        catch (OLAPException error) {
            perfectMap = false;
        }
        return perfectMap;
    }

    public boolean isMapChanged() {
        return this.isMapChanged;
    }

    public StringBuffer getMappedMessage() throws OLAPException {
        StringBuffer message = new StringBuffer();
        if (this.mappedTable != null) {
            this.olapDim.clearVerifyMessage();
            this.mapTable(this.mappedTable);
            if (!this.isPerfectMap() || this.isMapChanged()) {
                OLAPMemberPropertySet propertySet = this.olapDim.getOLAPMemberPropertySet();
                message.append(bundle.getString("OLAPSharedDimension.MappingInformation.intro.txt"));
                message.append(ModelUtilities.newline).append(ModelUtilities.newline);
                message.append(this.olapDim.getMappedRatio());
                message.append(propertySet.getMappedRatio());
                message.append(ModelUtilities.newline);
            }
        }
        return message;
    }

    public List getMappedTableStructureChanges() throws OLAPException {
        List changes = this.olapDim.getUnMappedMessage();
        changes.clear();
        OLAPList tempLevels = this.olapDim.getUnmappedLevels();
        if (tempLevels != null) {
            for (int i = tempLevels.size() - 1; i >= 0; --i) {
                OLAPLevel level = (OLAPLevel)tempLevels.get(i);
                OLAPSharedDimension dimension = level.getOwningSharedDimension();
                try {
                    changes.add(bundle.formatString("LoadTable.LevelWillBeRemoved.fmt.txt", (Object)level.getName(), (Object)this.mappedTable.getName(), (Object)dimension.getName()));
                    continue;
                }
                catch (RemoteException e) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                }
            }
        }
        OLAPList hierarchies = this.olapDim.getHierarchies();
        int hierarchyCount = 0;
        for (int j = hierarchies.size() - 1; j >= 0; --j) {
            OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(j);
            OLAPList hierarchyLevels = hierarchy.getLevels();
            int hierarchyLevelCount = 0;
            for (int k = hierarchyLevels.size() - 1; k >= 0; --k) {
                OLAPLevel hierarchyLevel = (OLAPLevel)hierarchyLevels.get(k);
                if (tempLevels.indexOf(hierarchyLevel) < 0) continue;
                ++hierarchyLevelCount;
            }
            if (hierarchyLevelCount != hierarchyLevels.size()) continue;
            try {
                ++hierarchyCount;
                changes.add(bundle.formatString("OLAPHierarchy.HierarchyWillBeRemoved.fmt.txt", (Object)hierarchy.getName(), (Object)this.mappedTable.getName(), (Object)this.olapDim.getName()));
                continue;
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        }
        OLAPMemberPropertySet propertySet = this.olapDim.getOLAPMemberPropertySet();
        OLAPList tempMemberProperties = propertySet.getUnmappedOLAPMemberProperties();
        if (tempMemberProperties != null) {
            for (int i = tempMemberProperties.size() - 1; i >= 0; --i) {
                OLAPMemberProperty property = (OLAPMemberProperty)tempMemberProperties.get(i);
                try {
                    changes.add(bundle.formatString("OLAPSharedDimension.OLAPPropertyWillBeRemoved.fmt.txt", (Object)property.getName(), (Object)this.mappedTable.getName()));
                    continue;
                }
                catch (RemoteException e) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                }
            }
        }
        return changes;
    }

    @Override
    public boolean equals(OLAPTable inputTable) {
        boolean returnEquals;
        boolean bl = returnEquals = this == inputTable;
        if (!returnEquals && inputTable != null && this.table != null) {
            returnEquals = this.table.equals((Object)inputTable.getTable());
        }
        return returnEquals;
    }

    @Override
    ClassifierMap getClassifierMap() throws OLAPException {
        if (this.classifierMap == null) {
            try {
                SharedDimension jomaDim = (SharedDimension)this.tableSet.getOwningSharedDimension().metadataObject;
                if (jomaDim != null) {
                    AssociationList listOfMaps = jomaDim.getTargetTransformations();
                    if (!listOfMaps.isEmpty()) {
                        this.classifierMap = (ClassifierMap)listOfMaps.get(0);
                    }
                } else {
                    this.createClassifierMap();
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return this.classifierMap;
    }

    public PhysicalTable getMappedTable() {
        return this.mappedTable;
    }

    public void mapTable(PhysicalTable inputTable) throws OLAPException {
        if (this.mappedTable != null && this.mappedTable != inputTable) {
            this.clearMap();
        }
        OLAPMemberPropertySet memberPropertySet = this.olapDim.getOLAPMemberPropertySet();
        if (this.mappedTable == null) {
            this.mappedTable = inputTable;
            this.mappedTableColumns = this.getColumnMap(this.mappedTable);
            this.olapDim.mapTable(this.mappedTableColumns);
            memberPropertySet.mapTable(this.mappedTableColumns);
        }
    }

    void setIsMapChanged(boolean mapChanged) {
        this.isMapChanged = mapChanged;
    }

    @Override
    void setMapToTable(PhysicalTable inputTable, Map inputColumns) throws OLAPException {
        super.setMapToTable(inputTable, inputColumns);
    }

    public void setTable(PhysicalTable inputTable) throws OLAPException {
        if (this.mappedTable != null) {
            this.olapDim.setErrorLevel(-1);
            StringBuffer message = this.getMappedMessage();
            this.olapDim.clearVerifyMessage();
            StringBuffer cubeMessage = this.olapDim.getVerifyMessage();
            cubeMessage.append(message);
            this.setMapToTable(this.mappedTable, this.mappedTableColumns);
            this.olapDim.removeUnmappedSharedDimLevelStructure();
            this.olapDim.getOLAPMemberPropertySet().removeUnmappedStructure();
            this.olapDim.setMapToStructure();
            this.table = inputTable;
        } else {
            this.reset(inputTable, this.isSimilar(this.olapDim, inputTable));
        }
        this.getClassifierMap();
        try {
            if (this.classifierMap != null) {
                StringBuffer name = new StringBuffer();
                name.append(this.olapDim.getName()).append("_").append(inputTable.getSASTableName()).append("_").append("ClassifierMap");
                this.classifierMap.setName(name.toString());
            }
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    public boolean isSimilar(OLAPSharedDimension dimension, PhysicalTable inputTable) throws OLAPException {
        boolean similar;
        if (dimension == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The OLAPDimension parameter cannot be null, and must be an OLAPDimension that has not been deleted.");
            }
            throw new IllegalArgumentException("Illegal argument passed to the isSimilar method.");
        }
        boolean bl = similar = inputTable != null && this.table != null;
        if (similar && !(similar = this.equals(inputTable))) {
            similar = true;
            OLAPList levels = dimension.getLevels();
            if (levels.isEmpty()) {
                similar = super.isSimilar(inputTable);
            } else {
                similar = true;
                Map inputColumnMap = this.getColumnMap(inputTable);
                for (int i = levels.size() - 1; i >= 0 && similar; --i) {
                    OLAPLevel olapLevel = (OLAPLevel)levels.get(i);
                    OLAPColumn olapColumn = olapLevel.getColumn();
                    String olapColumnName = olapColumn.getSASColumnName().toUpperCase();
                    Column column = (Column)inputColumnMap.get(olapColumnName);
                    boolean bl2 = similar = column != null;
                    if (!similar) continue;
                    OLAPList olapProperties = olapLevel.getOLAPProperties();
                    for (int j = olapProperties.size() - 1; j >= 0 && similar; --j) {
                        OLAPMemberProperty property = (OLAPMemberProperty)olapProperties.get(j);
                        OLAPColumn propertyColumn = property.getColumn();
                        String propertyColumnName = propertyColumn.getSASColumnName().toUpperCase();
                        Column inputPropertyColumn = (Column)inputColumnMap.get(propertyColumnName);
                        similar = inputPropertyColumn != null;
                    }
                }
            }
        }
        return similar;
    }

    public void updateMetadata() throws OLAPException {
        try {
            this.getClassifierMap();
            if (this.classifierMap == null) {
                this.classifierMap = this.createClassifierMap();
            } else {
                AssociationList featureMaps = this.classifierMap.getFeatureMaps();
                for (int i = featureMaps.size() - 1; i >= 0; --i) {
                    OLAPMemberPropertySet propertySet;
                    OLAPMemberProperty property;
                    FeatureMap featureMap = (FeatureMap)featureMaps.get(i);
                    AssociationList featureSources = featureMap.getTransformationSources();
                    AssociationList featureTargets = featureMap.getTransformationTargets();
                    if (featureTargets.isEmpty()) continue;
                    CMetadata metadataObject = (CMetadata)featureTargets.get(0);
                    OLAPColumn olapColumn = null;
                    if (metadataObject instanceof Level) {
                        DimensionSet dimensionSet = this.olapDim.getDimensionSet();
                        OLAPLevel level = (OLAPLevel)dimensionSet.metaLevelLevel.get((Level)metadataObject);
                        if (level != null) {
                            olapColumn = level.getColumn();
                        }
                    } else if (metadataObject instanceof OLAPProperty && (property = (propertySet = this.olapDim.getOLAPMemberPropertySet()).getOLAPMemberProperty((OLAPProperty)metadataObject)) != null) {
                        olapColumn = property.getColumn();
                    }
                    if (olapColumn == null) continue;
                    featureSources.clear();
                    featureSources.add((Object)olapColumn.metadataObject);
                }
            }
            if (this.classifierMap != null) {
                SharedDimension jomaDim = (SharedDimension)this.olapDim.metadataObject;
                AssociationList assocList = jomaDim.getTargetTransformations();
                assocList.clear();
                assocList.add((Object)this.classifierMap);
                AssociationList tranSources = this.classifierMap.getTransformationSources();
                tranSources.clear();
                tranSources.add((Object)this.table);
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }
}

