/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPTable;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class ReachThruTable
extends OLAPTable {
    private boolean loadTable;
    private OLAPCube owningCube;

    ReachThruTable(TableSet inputOLAPTableSet, PhysicalTable inputTable) throws OLAPException {
        this.tableSet = inputOLAPTableSet;
        this.owningCube = this.tableSet.getOwningCube();
        LoadTable tempLoadTable = this.tableSet.getLoadTable();
        if (tempLoadTable == null) {
            throw new IllegalStateException("Load table must be set before creating a reachthru table.");
        }
        this.table = inputTable;
        ReachThruTable reachthruTable = this.tableSet.getReachThruTable();
        List tables = this.tableSet.getTables();
        if (reachthruTable != null) {
            OptionSet optionSet = this.owningCube.getOptionsSet();
            Option option = optionSet.getOption(this.owningCube, "ReachthruTable_options", "OLAP Table Options");
            if (option != null) {
                option.setDefaultValue("");
            }
            tables.remove(reachthruTable);
        }
        tables.add(this);
        this.loadTable = tempLoadTable.equals(inputTable);
    }

    public String getTableOptions() throws OLAPException {
        String options = null;
        options = this.owningCube.getReachThruTableOptions();
        return options;
    }

    void setTable(PhysicalTable inputTable) throws OLAPException {
        LoadTable tempLoadTable = this.tableSet.getLoadTable();
        this.loadTable = inputTable == null ? false : tempLoadTable.equals(inputTable);
        this.table = inputTable;
        this.setTableOptions("");
        this.columns = null;
    }

    public void setTableOptions(String inputOption) throws OLAPException {
        this.owningCube.setReachThruTableOptions(inputOption);
    }

    @Override
    public boolean isLoadTable() {
        return this.loadTable;
    }

    void updateMetadata() throws OLAPException {
        Cube jomaCube = (Cube)this.owningCube.metadataObject;
        AssociationList reachthruTables = null;
        try {
            reachthruTables = jomaCube.getReachThruTables(false);
            reachthruTables.clear();
            if (this.table != null) {
                reachthruTables.add((Object)this.table);
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        OptionSet optionSet = this.owningCube.getOptionsSet();
        Option tableOptions = optionSet.getOption(this.owningCube, "ReachthruTable_options", "OLAP Table Options");
        if (tableOptions != null) {
            tableOptions.updateMetadata();
        }
    }
}

