/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASMDX.IMDXAdmin_1_1;
import com.sas.iom.SASMDX.IMDXAdmin_1_1Helper;
import com.sas.iom.SASMDX.ResultSetType;
import com.sas.iom.orb.UUIDConverter;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.designer.model.Session;
import com.sas.services.connection.ConnectionInterface;
import com.sas.workspace.WAdminResource;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;

public class Query {
    private static WAdminResource bundle = new WAdminResource(Query.class);
    private UUID queryid;
    private String displayableId;
    private String mdxString;
    private ResultSetType resultsType;
    private int sizeInCells;
    private int sizeInBytes;
    private OlapServer server;
    private int percentComplete;
    private Session owningSession;
    private String cubeNames;

    public Query(OlapServer inServer, Session session, UUID id, String string, ResultSetType type, int insize) {
        this.queryid = id;
        this.displayableId = this.queryid == null ? bundle.formatString("Query.UnknownId.fmt.txt", (java.lang.Object)String.valueOf(insize)) : UUIDConverter.uuidToString((UUID)this.queryid);
        this.mdxString = string;
        this.resultsType = type;
        this.sizeInBytes = -1;
        this.sizeInCells = insize;
        this.server = inServer;
        this.percentComplete = -1;
        this.owningSession = session;
    }

    public Query(OlapServer inServer, Session session, UUID id, String string, ResultSetType type, int insize, int total, int read) {
        this.queryid = id;
        this.displayableId = this.queryid == null ? bundle.formatString("Query.UnknownId.fmt.txt", (java.lang.Object)String.valueOf(insize)) : UUIDConverter.uuidToString((UUID)this.queryid);
        this.mdxString = string;
        this.resultsType = type;
        this.sizeInBytes = insize;
        this.sizeInCells = -1;
        this.server = inServer;
        this.percentComplete = total > 0 ? read / total * 100 : 0;
        this.owningSession = session;
    }

    public void close() throws OLAPException {
        if (this.queryid != null) {
            if (!this.server.isConnected()) {
                throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
            }
            try {
                ConnectionInterface connection = this.server.getConnection();
                Object obj = connection.getObject();
                IMDXAdmin_1_1 mdxAdmin = IMDXAdmin_1_1Helper.narrow((Object)obj);
                mdxAdmin.CancelMDXResultSet(this.owningSession.getId(), this.queryid);
            }
            catch (Exception e) {
                if (e instanceof COMM_FAILURE) {
                    this.server.disconnect();
                }
                throw new OLAPException(e.getLocalizedMessage(), e, 0);
            }
        }
    }

    public String getCubeNames() {
        if (ModelUtilities.isBlank(this.cubeNames) && !ModelUtilities.isBlank(this.mdxString)) {
            String temp = this.mdxString.trim().toUpperCase();
            String[] tokens = temp.trim().split("\\s++");
            if (tokens.length > 0 && (tokens[0].equals("CREATE") || tokens[0].equals("DROP"))) {
                temp = temp.substring(tokens[0].length()).trim();
                temp = temp.substring(tokens[1].length()).trim();
                if (tokens[1].equals("SESSION") || tokens[1].equals("GLOBAL")) {
                    temp = temp.substring(tokens[2].length()).trim();
                }
                if (temp.startsWith("[")) {
                    int pos = temp.indexOf("]");
                    if (pos > 1) {
                        this.cubeNames = temp.substring(1, pos);
                    }
                } else {
                    int pos = temp.indexOf(".");
                    if (pos > 0) {
                        this.cubeNames = temp.substring(0, pos);
                    }
                }
            } else {
                int pos = temp.indexOf("FROM");
                if (pos > -1) {
                    temp = temp.substring(pos + 4);
                    temp = temp.trim();
                    int lastchar = -1;
                    if (temp.startsWith("[")) {
                        lastchar = temp.indexOf("]");
                        if (lastchar > 1) {
                            this.cubeNames = temp.substring(1, lastchar);
                        }
                    } else {
                        lastchar = temp.indexOf(" ");
                        if (lastchar > 0) {
                            this.cubeNames = temp.substring(0, lastchar);
                        }
                    }
                }
            }
        }
        if (this.cubeNames == null) {
            this.cubeNames = "";
        }
        return this.cubeNames;
    }

    public String getDisplayableId() {
        return this.displayableId;
    }

    public UUID getId() {
        return this.queryid;
    }

    public String getMdxString() {
        return this.mdxString;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public ResultSetType getResultsType() {
        return this.resultsType;
    }

    public OlapServer getServer() {
        return this.server;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int getSizeInCells() {
        return this.sizeInCells;
    }
}

