/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPProperty;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractInputTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OLAPMemberPropertySet {
    static WAdminResource bundle = new WAdminResource(OLAPMemberPropertySet.class);
    private OLAPList olapProperties;
    private OLAPCube owningCube;
    private OLAPSharedDimension owningSharedDimension;
    private DimensionSet dimensionSet;
    private List olapMemberPropertyDeleteList;
    static final int maximumOlapPropertiesPerCube = 256;
    private Map mappedProperties;
    private OLAPList unmappedProperties;
    private boolean isShared;

    OLAPMemberPropertySet(OLAPCube inputOwningCube) {
        this.owningCube = inputOwningCube;
        this.dimensionSet = this.owningCube.getDimensionSet();
    }

    OLAPMemberPropertySet(OLAPSharedDimension inputOwningDimension) {
        this.owningSharedDimension = inputOwningDimension;
        this.dimensionSet = this.owningSharedDimension.getDimensionSet();
        this.isShared = true;
    }

    void clearMapTable() {
        if (this.mappedProperties != null) {
            this.mappedProperties.clear();
            this.mappedProperties = null;
        }
        if (this.unmappedProperties != null) {
            this.unmappedProperties.getTheList().clear();
            this.unmappedProperties = null;
        }
    }

    public OLAPMemberProperty createOLAPMemberProperty() throws OLAPException {
        OLAPMemberProperty memberProperty = null;
        this.verifyMaximumOlapPropertiesPerCube();
        memberProperty = new OLAPMemberProperty();
        memberProperty.setOLAPMemberPropertySet(this);
        if (!this.isShared) {
            memberProperty.setOwningCube(this.owningCube);
            memberProperty.setTableSet(this.owningCube.getTableSet());
            memberProperty.setDimensionSet(this.owningCube.getDimensionSet());
            memberProperty.setOptionSet(this.owningCube.getOptionsSet());
        } else {
            memberProperty.setOwningSharedDimension(this.owningSharedDimension);
            memberProperty.setTableSet(this.owningSharedDimension.getTableSet());
            memberProperty.setDimensionSet(this.owningSharedDimension.getDimensionSet());
            memberProperty.setOptionSet(this.owningSharedDimension.getOptionSet());
        }
        this.getOLAPProperties().getTheList().add(memberProperty);
        return memberProperty;
    }

    OLAPMemberProperty createOLAPMemberProperty(OLAPProperty inputMemberProperty) throws OLAPException {
        OLAPMemberProperty memberProperty = new OLAPMemberProperty(inputMemberProperty);
        memberProperty.setOLAPMemberPropertySet(this);
        if (!this.isShared) {
            memberProperty.setOwningCube(this.owningCube);
            memberProperty.setTableSet(this.owningCube.getTableSet());
            memberProperty.setDimensionSet(this.owningCube.getDimensionSet());
            memberProperty.setOptionSet(this.owningCube.getOptionsSet());
        } else {
            memberProperty.setOwningSharedDimension(this.owningSharedDimension);
            memberProperty.setTableSet(this.owningSharedDimension.getTableSet());
            memberProperty.setDimensionSet(this.owningSharedDimension.getDimensionSet());
            memberProperty.setOptionSet(this.owningSharedDimension.getOptionSet());
        }
        return memberProperty;
    }

    public OLAPList getOLAPProperties() throws OLAPException {
        if (this.olapProperties == null) {
            this.olapProperties = new OLAPList(OLAPMemberProperty.class);
            Map levels = null;
            levels = this.dimensionSet.getLevels();
            for (List listOfLevels : levels.values()) {
                int size = listOfLevels.size();
                for (int t = 0; t < size; ++t) {
                    OLAPLevel level = (OLAPLevel)listOfLevels.get(t);
                    try {
                        if (level.metadataObject == null) continue;
                        Level jomaObject = (Level)level.metadataObject;
                        AssociationList properties = jomaObject.getOLAPProperties(false);
                        int jSize = properties.size();
                        for (int j = 0; j < jSize; ++j) {
                            OLAPProperty metadataObject = (OLAPProperty)properties.elementAt(j);
                            this.olapProperties.getTheList().add(this.createOLAPMemberProperty(metadataObject));
                        }
                        continue;
                    }
                    catch (MdException mdError) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                }
            }
        }
        this.olapProperties.sort();
        return this.olapProperties;
    }

    List getOLAPProperties(OLAPLevel inputLevel) throws OLAPException {
        if (this.olapProperties == null) {
            this.getOLAPProperties();
        }
        OLAPList levelProperties = new OLAPList(OLAPMemberProperty.class);
        String levelName = inputLevel.getName();
        int jSize = this.olapProperties.size();
        for (int j = 0; j < jSize; ++j) {
            OLAPMemberProperty memberProperty = (OLAPMemberProperty)this.olapProperties.get(j);
            String name = memberProperty.getAssociatedLevel().getName();
            if (!levelName.equalsIgnoreCase(name)) continue;
            levelProperties.add(memberProperty);
        }
        return levelProperties;
    }

    List getOLAPPropertiesByTable(AbstractInputTable inputTable) throws OLAPException {
        if (this.olapProperties == null) {
            this.getOLAPProperties();
        }
        ArrayList<OLAPMemberProperty> tableProperties = new ArrayList<OLAPMemberProperty>();
        OLAPList allColumns = inputTable.getColumns();
        int jSize = this.olapProperties.size();
        for (int j = 0; j < jSize; ++j) {
            OLAPMemberProperty memberProperty = (OLAPMemberProperty)this.olapProperties.get(j);
            OLAPColumn column = memberProperty.getColumn();
            if (!allColumns.contains(column)) continue;
            tableProperties.add(memberProperty);
        }
        return tableProperties;
    }

    public StringBuffer generateCode() throws OLAPException {
        StringBuffer allOlapPropertyStatement = new StringBuffer();
        String newline = System.getProperty("line.separator");
        this.getOLAPProperties();
        int size = this.olapProperties.size();
        for (int j = 0; j < size; ++j) {
            OLAPLevel level;
            OLAPMemberProperty nextProperty = (OLAPMemberProperty)this.olapProperties.get(j);
            boolean okToGenerate = true;
            if (this.owningCube != null && (level = nextProperty.getAssociatedLevel()) != null) {
                OLAPDimension dim = level.getDimension();
                boolean bl = okToGenerate = dim != null && !dim.isShared();
            }
            if (!okToGenerate) continue;
            allOlapPropertyStatement.append(nextProperty.generateCode().append(newline));
        }
        return allOlapPropertyStatement;
    }

    int getMapTableSize() {
        int size = 0;
        if (this.mappedProperties != null) {
            size = this.mappedProperties.size();
        }
        return size;
    }

    public OLAPMemberProperty getOLAPMemberProperty(String name) throws OLAPException {
        OLAPMemberProperty property = null;
        this.getOLAPProperties();
        for (int i = this.olapProperties.size() - 1; i >= 0 && property == null; --i) {
            property = (OLAPMemberProperty)this.olapProperties.get(i);
            if (property.getName().equalsIgnoreCase(name)) continue;
            property = null;
        }
        return property;
    }

    OLAPMemberProperty getOLAPMemberProperty(OLAPProperty inputProperty) throws OLAPException {
        OLAPMemberProperty property = null;
        this.getOLAPProperties();
        for (int i = this.olapProperties.size() - 1; i >= 0 && property == null; --i) {
            property = (OLAPMemberProperty)this.olapProperties.get(i);
            if (property == inputProperty) continue;
            property = null;
        }
        return property;
    }

    public Column getMappedMemberProperty(OLAPMemberProperty inputMemberProperty) {
        Column mappedColumn = null;
        if (this.mappedProperties != null && inputMemberProperty != null) {
            mappedColumn = (Column)this.mappedProperties.get(inputMemberProperty);
        }
        return mappedColumn;
    }

    StringBuffer getMappedRatio() {
        StringBuffer message = new StringBuffer();
        if (this.mappedProperties != null) {
            message.append("\n");
            int mappedSize = this.mappedProperties.size();
            int totalSize = mappedSize + this.unmappedProperties.size();
            if (totalSize > 0) {
                message.append(bundle.formatString("OLAPMemberProperty.MappedMemberPropertyRatio.fmt.txt", (Object)String.valueOf(mappedSize), (Object)String.valueOf(totalSize)));
            }
        }
        return message;
    }

    public List getOLAPMemberPropertyDeleteList() {
        if (this.olapMemberPropertyDeleteList == null) {
            this.olapMemberPropertyDeleteList = new ArrayList();
        }
        return this.olapMemberPropertyDeleteList;
    }

    public OLAPCube getOwningCube() {
        return this.owningCube;
    }

    public OLAPSharedDimension getOwningSharedDimension() {
        return this.owningSharedDimension;
    }

    public OLAPList getStarSchemaProperties() throws OLAPException {
        this.getOLAPProperties();
        TableSet tableSet = null;
        if (this.owningCube != null) {
            tableSet = this.owningCube.getTableSet();
        } else if (this.owningSharedDimension != null) {
            tableSet = this.owningSharedDimension.getTableSet();
        }
        boolean starSchemacube = tableSet.isLoadStarSchema();
        OLAPList starSchemaProperties = new OLAPList(OLAPMemberProperty.class);
        if (starSchemacube) {
            int size = this.olapProperties.size();
            for (int i = 0; i < size; ++i) {
                OLAPMemberProperty memberProperty = (OLAPMemberProperty)this.olapProperties.get(i);
                OLAPLevel level = memberProperty.getAssociatedLevel();
                if (this.owningCube == null) continue;
                OLAPDimension dimension = null;
                if (level != null) {
                    dimension = level.getDimension();
                } else {
                    OLAPList hiers = memberProperty.getHierarchies();
                    if (!hiers.isEmpty()) {
                        dimension = ((OLAPHierarchy)hiers.get(0)).getDimension();
                    }
                }
                if (dimension == null || !dimension.isStarDimension()) continue;
                starSchemaProperties.add(memberProperty);
            }
        }
        return starSchemaProperties;
    }

    public OLAPList getUnmappedOLAPMemberProperties() throws OLAPException {
        if (this.olapProperties != null && this.mappedProperties != null && this.unmappedProperties == null) {
            this.unmappedProperties = new OLAPList(OLAPMemberProperty.class);
            OLAPList starSchemaProperties = this.getStarSchemaProperties();
            for (int i = this.olapProperties.size() - 1; i >= 0; --i) {
                OLAPMemberProperty property = (OLAPMemberProperty)this.olapProperties.get(i);
                if (starSchemaProperties.contains(property) && (this.owningSharedDimension == null || !this.owningSharedDimension.isOnlyShared()) || this.mappedProperties.containsKey(property)) continue;
                this.unmappedProperties.add(property);
            }
            this.unmappedProperties.sort();
            this.unmappedProperties.setModifiable(false);
        }
        return this.unmappedProperties;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void mapMemberProperty(OLAPMemberProperty inputMemberProperty, Column inputColumn) {
        if (this.mappedProperties == null) {
            this.mappedProperties = new HashMap();
        }
        try {
            Column mappedColumn = (Column)this.mappedProperties.get(inputMemberProperty);
            if (mappedColumn != null && mappedColumn != inputColumn) {
                if (this.owningSharedDimension != null && this.owningSharedDimension.isOnlyShared()) {
                    SharedDimensionTable dimTable = this.owningSharedDimension.getSharedDimensionTable();
                    dimTable.setIsMapChanged(true);
                } else {
                    TableSet tableSet = this.owningCube.getTableSet();
                    LoadTable loadTable = tableSet.getLoadTable();
                    loadTable.setIsMapChanged(true);
                }
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        this.mappedProperties.put(inputMemberProperty, inputColumn);
        this.unmappedProperties.getTheList().remove(inputMemberProperty);
    }

    void mapTable(Map mappedTable) throws OLAPException {
        this.getOLAPProperties();
        OLAPList starSchemaProperties = this.getStarSchemaProperties();
        if (this.mappedProperties == null) {
            this.mappedProperties = new HashMap();
        }
        for (int i = this.olapProperties.size() - 1; i >= 0; --i) {
            String columnName;
            Column newColumn;
            OLAPColumn column;
            OLAPMemberProperty memberProperty = (OLAPMemberProperty)this.olapProperties.get(i);
            if (starSchemaProperties.contains(memberProperty) && (this.owningSharedDimension == null || !this.owningSharedDimension.isOnlyShared()) || (column = memberProperty.getColumn()) == null || (newColumn = (Column)mappedTable.get(columnName = column.getSASColumnName().toUpperCase())) == null) continue;
            this.mappedProperties.put(memberProperty, newColumn);
        }
        this.getUnmappedOLAPMemberProperties();
    }

    void removeUnmappedStructure() throws OLAPException {
        block8: {
            if (this.unmappedProperties == null) break block8;
            if (this.owningSharedDimension != null && this.owningSharedDimension.isOnlyShared()) {
                List messages = this.owningSharedDimension.getUnMappedMessage();
                PhysicalTable mappedTable = this.owningSharedDimension.getSharedDimensionTable().getMappedTable();
                for (int i = this.unmappedProperties.size() - 1; i >= 0; --i) {
                    OLAPMemberProperty memberProperty = (OLAPMemberProperty)this.unmappedProperties.get(i);
                    try {
                        messages.add(bundle.formatString("OLAPMemberProperty.OLAPPropertyRemoved..SharedDimension.fmt.txt", (Object)memberProperty.getName(), (Object)mappedTable.getName()));
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(bundle.getString(""), e, 12);
                    }
                    memberProperty.delete();
                    this.unmappedProperties.getTheList().remove(memberProperty);
                }
            } else {
                TableSet tableSet = this.owningCube.getTableSet();
                LoadTable loadTable = tableSet.getLoadTable();
                PhysicalTable mappedTable = loadTable.getMappedTable();
                List messages = this.owningCube.getCubeMessage();
                for (int i = this.unmappedProperties.size() - 1; i >= 0; --i) {
                    OLAPMemberProperty memberProperty = (OLAPMemberProperty)this.unmappedProperties.get(i);
                    try {
                        messages.add(bundle.formatString("OLAPMemberProperty.OLAPPropertyRemoved.fmt.txt", (Object)memberProperty.getName(), (Object)mappedTable.getName()));
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(bundle.getString(""), e, 12);
                    }
                    memberProperty.delete();
                    this.unmappedProperties.getTheList().remove(memberProperty);
                }
            }
        }
    }

    public void reset() throws OLAPException {
        if (this.olapProperties == null) {
            this.getOLAPProperties();
        }
        int size = this.olapProperties.size();
        for (int i = 0; i < size; ++i) {
            OLAPLevel level;
            OLAPMemberProperty olapProperty = (OLAPMemberProperty)this.olapProperties.get(i);
            boolean okToDelete = true;
            if (this.owningCube != null && (level = olapProperty.getAssociatedLevel()) != null) {
                OLAPDimension dim = level.getDimension();
                boolean bl = okToDelete = dim != null && !dim.isShared();
            }
            if (!okToDelete) continue;
            olapProperty.delete();
        }
        this.olapProperties.getTheList().clear();
    }

    void setMapToStructure() throws OLAPException {
        for (int i = this.olapProperties.size() - 1; i >= 0; --i) {
            Column jomaColumn;
            OLAPMemberProperty property = (OLAPMemberProperty)this.olapProperties.get(i);
            if (this.mappedProperties == null || (jomaColumn = (Column)this.mappedProperties.get(property)) == null) continue;
            if (this.owningSharedDimension != null && this.owningSharedDimension.isOnlyShared()) {
                SharedDimensionTable dimTable = this.owningSharedDimension.getSharedDimensionTable();
                OLAPColumn olapColumn = dimTable.getColumn(jomaColumn);
                property.setColumn(olapColumn);
                continue;
            }
            TableSet tableSet = this.owningCube.getTableSet();
            LoadTable loadTable = tableSet.getLoadTable();
            OLAPColumn olapColumn = loadTable.getColumn(jomaColumn);
            property.setColumn(olapColumn);
        }
        if (this.mappedProperties != null) {
            this.mappedProperties.clear();
            this.mappedProperties = null;
        }
        if (this.unmappedProperties != null) {
            this.unmappedProperties.getTheList().clear();
            this.unmappedProperties = null;
        }
    }

    public void updateMetadata() throws OLAPException {
        OLAPMemberProperty olapProperty;
        int i;
        int size = this.getOLAPProperties().size();
        for (i = 0; i < size; ++i) {
            OLAPLevel level;
            olapProperty = (OLAPMemberProperty)this.olapProperties.get(i);
            boolean okToUpdate = true;
            OLAPDimension dim = null;
            if (this.owningCube != null && (level = olapProperty.getAssociatedLevel()) != null) {
                dim = level.getDimension();
                boolean bl = okToUpdate = dim != null && !dim.isShared();
            }
            if (!okToUpdate || !olapProperty.isMetadataUpdated() && !olapProperty.changedSASFormat && !olapProperty.isHierarchiesUpdated() && (dim == null || !dim.wasTime || dim.isTime())) continue;
            olapProperty.updateMetadata();
        }
        if (this.olapMemberPropertyDeleteList != null) {
            size = this.olapMemberPropertyDeleteList.size();
            for (i = 0; i < size; ++i) {
                olapProperty = (OLAPMemberProperty)this.olapMemberPropertyDeleteList.get(i);
                OLAPProperty jomaProperty = (OLAPProperty)olapProperty.metadataObject;
                if (jomaProperty == null) continue;
                if (this.isShared) {
                    MetadataTemplate.deleteMetadata(this.owningSharedDimension.getObjectStore(), (CMetadata)jomaProperty, "<Templates><TargetFeatureMaps/><Properties/></Templates>", "");
                    continue;
                }
                MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)jomaProperty, "<Templates><TargetFeatureMaps/><Properties/></Templates>", "");
            }
        }
    }

    public void verifyMaximumOlapPropertiesPerCube() throws OLAPException {
        this.getOLAPProperties();
        if (this.olapProperties.size() + 1 > 256) {
            throw new OLAPException(bundle.getString("OLAPMemberProperty.TooManyMemberPropertiesPerCube.txt"), 0);
        }
    }

    StringBuffer verifyMetadata() throws OLAPException {
        StringBuffer olapPropertyMessage = new StringBuffer();
        this.getOLAPProperties();
        for (int i = this.olapProperties.size() - 1; i >= 0; --i) {
            OLAPMemberProperty olapProperty = (OLAPMemberProperty)this.olapProperties.get(i);
            StringBuffer propertyMessage = olapProperty.verifyMetadata();
            if (ModelUtilities.isBlank(propertyMessage.toString())) continue;
            olapPropertyMessage.append(propertyMessage);
        }
        return olapPropertyMessage;
    }
}

