/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.LogicalColumn;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Transformation;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.olapadmin.designer.model.Statistic;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OLAPMeasure
extends AbstractOLAPModel {
    static WAdminResource bundle = new WAdminResource(OLAPMeasure.class);
    public static final String MEASURE_DIMENSION_TYPE = "MEASURES";
    static final String MOLAP = "MOLAP";
    static final String ROLAP = "ROLAP";
    static final String BEST12_SAS_FORMAT = "Best12.";
    public static final String DEFAULT_FORMAT = "12.0";
    Map aggregateColumns;
    private Boolean storedStatistic;
    private Boolean nuniqueStatistic;
    private boolean verifiedName;
    private boolean verifiedStatistic;
    private boolean verifiedAggregates;
    private OLAPColumn column;
    private String sasFormat;
    private Statistic statistic;
    private String units;
    private String groupName;
    private OLAPLevel level;
    private OLAPHierarchy hierarchy;
    private Option includeCalc;
    private boolean deleteIncludeCalcOption;
    private Statistic originalStatistic;
    private String originalName;
    private String originalDescription;
    private String originalNotes;
    private String originalSASFormat;
    private String originalUnits;
    private String originalGroupName;
    private OLAPLevel originalLevel;
    private OLAPHierarchy originalHierarchy;
    private static final String MEASURE = "   MEASURE ";
    private static final String STAT_EQUALS = "      STAT        = ";
    private static final String ANALYSIS_EQUALS = "      ANALYSIS    = ";
    private static final String AGGR_COLUMN_EQUALS = "      AGGR_COLUMN = ";
    private static final String COLUMN_EQUALS = "      COLUMN      = ";
    private static final String CAPTION_EQUALS = "      CAPTION     = ";
    private static final String DESC_EQUALS = "      DESC        = ";
    private static final String UNITS_EQUALS = "      UNITS       = ";
    private static final String FORMAT_EQUALS = "      FORMAT      = ";
    private static final String MEASURE_MLSID = "      MLSID       = ";
    private static final String HIERARCHY_EQUALS = "      HIERARCHY   = ";
    private static final String LEVEL_EQUALS = "      LEVEL       = ";
    private static final String INCLUDE_CALC = "      INCLUDE_CALCULATED_MEMBERS";
    private static final String DEFAULT = "      DEFAULT";

    OLAPMeasure(Measure inputMetadataObject, MeasureSet inputMeasureSet) throws OLAPException {
        this.measureSet = inputMeasureSet;
        this.owningCube = this.measureSet.getOwningCube();
        this.optionSet = this.owningCube.getOptionsSet();
        this.metadataObject = inputMetadataObject;
        this.verifiedName = true;
        this.verifiedStatistic = true;
        this.getStatistic();
        this.getName();
        this.getDesc();
        this.getSASFormat();
        this.getUnits();
        if (!this.isNunique().booleanValue()) {
            this.getGroupName();
            this.getInputColumn();
        }
        this.originalLevel = this.getLevel();
        this.originalHierarchy = this.getHierarchy();
        this.originalStatistic = this.statistic;
        this.originalName = this.name;
        this.originalDescription = this.description;
        this.originalNotes = this.getNotes();
        this.originalSASFormat = this.sasFormat;
        this.originalUnits = this.units;
        if (!this.isNunique().booleanValue()) {
            this.originalGroupName = this.groupName;
            if (this.column != null) {
                OLAPList measuresByColumn = this.measureSet.getMeasuresByColumn(this.column);
                measuresByColumn.getTheList().add(this);
            }
        }
        this.setAggregateColumns();
    }

    OLAPMeasure(OLAPColumn inputColumn, MeasureSet inputMeasureSet) throws OLAPException {
        this.measureSet = inputMeasureSet;
        this.owningCube = this.measureSet.getOwningCube();
        this.optionSet = this.owningCube.getOptionsSet();
        this.measureSet.verifyMaximumMeasures();
        this.column = inputColumn;
        this.tableSet = this.owningCube.getTableSet();
        if (this.tableSet.isLoadClassicSAS() && this.column != null) {
            this.verifyUniqueColumn();
        }
        this.verifiedName = false;
        this.verifiedStatistic = false;
        this.aggregationSet = this.owningCube.getAggregationSet();
        Boolean storedAggregations = this.aggregationSet.hasStoredAggregations();
        if (this.tableSet.isLoadClassicSAS()) {
            if (inputColumn != null) {
                this.setAggregateColumnForce(this.aggregationSet.getTables(), inputColumn.getSASColumnName());
                this.measureSet.setVerifiedAggregates(true);
            }
        } else if (storedAggregations != null && storedAggregations.booleanValue()) {
            this.measureSet.setVerifiedAggregates(false);
        }
        if (this.column != null) {
            OLAPList measuresByColumn = this.measureSet.getMeasuresByColumn(this.column);
            measuresByColumn.getTheList().add(this);
        }
    }

    OLAPMeasure(OLAPLevel inputLevel, OLAPHierarchy inputHierarchy, MeasureSet inputMeasureSet) throws OLAPException {
        this.level = inputLevel;
        this.hierarchy = inputHierarchy;
        this.measureSet = inputMeasureSet;
        this.owningCube = this.measureSet.getOwningCube();
        this.optionSet = this.owningCube.getOptionsSet();
        this.measureSet.verifyMaximumMeasures();
        this.verifiedName = false;
        this.verifiedStatistic = false;
        this.setStatistic(Statistic.getNunique());
    }

    public void add() throws OLAPException {
        if (!this.deleted) {
            throw new IllegalStateException("The measure is not added.  An existing measure cannot be added.");
        }
        try {
            this.deleted = false;
            this.measureSet.getMeasures().add(this);
        }
        catch (OLAPException error) {
            this.deleted = true;
            throw error;
        }
    }

    @Override
    public void clear() throws OLAPException {
        Boolean storedAggregations;
        this.verifyDeleted();
        this.measureSet.clear(this);
        this.name = this.originalName;
        if (this.name == null) {
            this.getName();
        }
        this.description = this.originalDescription;
        this.setNotes(this.originalNotes);
        this.sasFormat = this.originalSASFormat;
        this.units = this.originalUnits;
        this.groupName = this.originalGroupName;
        this.statistic = this.originalStatistic;
        this.level = this.originalLevel;
        this.hierarchy = this.originalHierarchy;
        if (!this.isNunique().booleanValue()) {
            OLAPList groupNames = this.measureSet.getGroupNames();
            if (!ModelUtilities.isBlank(this.groupName) && groupNames.indexOf(this.groupName) < 0) {
                groupNames.add(this.groupName);
            }
            OLAPList derived = this.measureSet.getDerivedMeasures();
            OLAPList stored = this.measureSet.getStoredMeasures();
            OLAPList newStoredByGroup = null;
            OLAPList newDerivedByGroup = null;
            if (!ModelUtilities.isBlank(this.groupName)) {
                newStoredByGroup = this.measureSet.getStoredMeasuresByGroupName(this.groupName);
                newDerivedByGroup = this.measureSet.getDerivedMeasuresByGroupName(this.groupName);
            }
            if (this.statistic != null & this.groupName != null) {
                if (this.statistic.isDerived()) {
                    derived.getTheList().add(this);
                    newDerivedByGroup.getTheList().add(this);
                } else {
                    stored.getTheList().add(this);
                    newStoredByGroup.getTheList().add(this);
                }
            }
        }
        this.measureSet.synchRolap();
        this.verifiedName = false;
        this.verifiedStatistic = false;
        if (!this.isNunique().booleanValue() && (storedAggregations = this.owningCube.getAggregationSet().hasStoredAggregations()) != null && storedAggregations.booleanValue()) {
            this.measureSet.setVerifiedAggregates(false);
        }
    }

    public void delete() throws OLAPException {
        this.verifyDeleted();
        this.measureSet.delete(this);
        this.deleted = true;
    }

    private OLAPColumn getMolapAggregateColumn(AggregationTable inputTable) throws OLAPException {
        OLAPColumn aggregateColumn = null;
        this.setAggregateColumns();
        aggregateColumn = (OLAPColumn)this.aggregateColumns.get(inputTable);
        if (aggregateColumn == null) {
            aggregateColumn = this.getAggregateColumnFromTable(inputTable);
        }
        if (aggregateColumn != null) {
            this.setAggregateColumn(inputTable, aggregateColumn);
        }
        return aggregateColumn;
    }

    private OLAPColumn getAggregateColumnFromTable(AggregationTable inputTable) throws OLAPException {
        OLAPColumn aggregateColumn = null;
        if (this.aggregationSet == null) {
            this.aggregationSet = this.owningCube.getAggregationSet();
        }
        OLAPList tables = this.aggregationSet.getTables();
        int i = tables.size() - 1;
        while (i >= 0 & aggregateColumn == null) {
            AggregationTable table = (AggregationTable)tables.get(i);
            OLAPColumn tableColumn = (OLAPColumn)this.aggregateColumns.get(table);
            if (tableColumn != null) {
                aggregateColumn = inputTable.getColumn(tableColumn.getSASColumnName());
            }
            --i;
        }
        if (aggregateColumn != null) {
            this.setAggregateColumn(inputTable, aggregateColumn);
        }
        return aggregateColumn;
    }

    private OLAPColumn getRolapAggregateColumn(AggregationTable inputTable) throws OLAPException {
        OLAPColumn aggregateColumn = null;
        if (this.metadataObject != null) {
            try {
                Measure jomaMeasure = (Measure)this.metadataObject;
                List featureMaps = this.getFeatureMaps(jomaMeasure);
                for (int i = featureMaps.size() - 1; i >= 0 && aggregateColumn == null; --i) {
                    LoadTable loadTable;
                    CMetadata object = (CMetadata)featureMaps.get(i);
                    if (!object.getCMetadataType().equalsIgnoreCase("FeatureMap")) continue;
                    FeatureMap featureMap = (FeatureMap)object;
                    AssociationList sources = featureMap.getFeatureSources();
                    if (sources.isEmpty()) {
                        featureMap.getTransformationSources();
                    }
                    if (sources.size() <= 0) continue;
                    Column jomaColumn = (Column)sources.get(0);
                    if (this.tableSet == null) {
                        this.tableSet = this.owningCube.getTableSet();
                    }
                    if ((loadTable = this.tableSet.getLoadTable()) == null) continue;
                    this.column = loadTable.getTable() == null ? inputTable.getColumn(jomaColumn) : loadTable.getColumn(jomaColumn.getSASColumnName());
                }
                if (this.column != null) {
                    aggregateColumn = inputTable.getColumn(this.column.getSASColumnName());
                }
            }
            catch (MdException mdError) {
                throw new OLAPException("MdException.GenericError.txt", mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
            }
        }
        if (aggregateColumn == null) {
            aggregateColumn = this.getAggregateColumnFromTable(inputTable);
        } else {
            this.setAggregateColumn(inputTable, aggregateColumn);
        }
        return aggregateColumn;
    }

    StringBuffer generateCode() throws OLAPException {
        OLAPList measures;
        Integer number;
        StringBuffer measureStatement = new StringBuffer();
        measureStatement.append(MEASURE).append(ModelUtilities.getSasName(this.getName())).append(ModelUtilities.newline);
        measureStatement.append(STAT_EQUALS).append(this.getStatistic().getName()).append(ModelUtilities.newline);
        if (this.isNunique().booleanValue()) {
            measureStatement.append(LEVEL_EQUALS).append(ModelUtilities.getSasName(this.getLevel().getName())).append(ModelUtilities.newline);
            measureStatement.append(HIERARCHY_EQUALS).append(ModelUtilities.getSasName(this.getHierarchy().getName())).append(ModelUtilities.newline);
        } else {
            OLAPList aggregationTables;
            if (this.column == null) {
                this.getInputColumn();
            }
            StringBuffer sasColumnName = new StringBuffer();
            if (this.column != null) {
                sasColumnName.append(ModelUtilities.getSasName(this.column.getSASColumnName()));
            }
            if (!this.owningCube.getTableSet().isLoadClassicSAS()) {
                measureStatement.append(COLUMN_EQUALS).append(sasColumnName).append(ModelUtilities.newline);
            } else {
                measureStatement.append(ANALYSIS_EQUALS).append(this.getGroupName()).append(ModelUtilities.newline);
            }
            if (this.aggregationSet == null) {
                this.aggregationSet = this.owningCube.getAggregationSet();
            }
            if (!(aggregationTables = this.aggregationSet.getTables()).isEmpty()) {
                OLAPColumn aggregateColumn;
                AggregationTable aggregationTable = (AggregationTable)aggregationTables.get(0);
                if (!this.statistic.isDerived() && (aggregateColumn = this.getAggregateColumn(aggregationTable)) != null) {
                    measureStatement.append(AGGR_COLUMN_EQUALS).append(ModelUtilities.getSasName(aggregateColumn.getSASColumnName())).append(ModelUtilities.newline);
                }
            }
        }
        StringBuffer caption = new StringBuffer(ModelUtilities.internalQuote(this.getDesc()));
        StringBuffer desc = new StringBuffer(ModelUtilities.internalQuote(this.getNotes()));
        StringBuffer unit = new StringBuffer(this.getUnits());
        StringBuffer format = new StringBuffer(this.getSASFormat());
        if (caption.length() > 0) {
            measureStatement.append(CAPTION_EQUALS).append("'").append(caption).append("'");
        }
        if (desc.length() > 0) {
            measureStatement.append(ModelUtilities.newline).append(DESC_EQUALS).append("'").append(desc).append("'");
        }
        if (this.units.length() > 0) {
            measureStatement.append(ModelUtilities.newline).append(UNITS_EQUALS).append("'").append(unit).append("'");
        }
        if (format.length() > 0) {
            measureStatement.append(ModelUtilities.newline).append(FORMAT_EQUALS).append(format);
        }
        if ((number = this.getMLSID()) != null) {
            measureStatement.append(ModelUtilities.newline).append(MEASURE_MLSID).append(number.toString()).append(ModelUtilities.newline);
        }
        if (this.isNunique().booleanValue() && this.isIncludeCalculatedMembers()) {
            measureStatement.append(ModelUtilities.newline).append(INCLUDE_CALC);
        }
        if ((measures = this.measureSet.getMeasures()).indexOf(this) == 0) {
            measureStatement.append(ModelUtilities.newline).append(DEFAULT);
        }
        measureStatement.append(";").append(ModelUtilities.newline);
        return measureStatement;
    }

    String getAggregateColumn() throws OLAPException {
        AggregationTable table;
        OLAPColumn tempColumn;
        OLAPList tables;
        String columnName = "";
        if (this.aggregationSet == null) {
            this.aggregationSet = this.owningCube.getAggregationSet();
        }
        if ((tables = this.aggregationSet.getTables()).size() > 0 && (tempColumn = this.getAggregateColumn(table = (AggregationTable)tables.get(0))) != null) {
            columnName = tempColumn.getSASColumnName();
        }
        return columnName;
    }

    public OLAPColumn getAggregateColumn(AggregationTable inputTable) throws OLAPException {
        this.verifyDeleted();
        if (inputTable == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Aggregation table cannot be null.");
            }
            throw new IllegalArgumentException("Illegal argument is passed to the getAggregateColumn method.");
        }
        OLAPColumn aggregateColumn = null;
        if (this.aggregateColumns == null) {
            this.aggregateColumns = new HashMap();
        }
        if ((aggregateColumn = (OLAPColumn)this.aggregateColumns.get(inputTable)) == null) {
            if (this.tableSet == null) {
                this.tableSet = this.owningCube.getTableSet();
            }
            aggregateColumn = this.tableSet.isLoadClassicSAS() ? this.getRolapAggregateColumn(inputTable) : this.getMolapAggregateColumn(inputTable);
        }
        return aggregateColumn;
    }

    private String getDefaultMolapGroupName() throws OLAPException {
        this.getInputColumn();
        return this.column != null ? (this.groupName = this.column.getSASColumnName()) : "";
    }

    private String getDefaultRolapGroupName() throws OLAPException {
        String rolapGroupName = "";
        Measure jomaMeasure = (Measure)this.metadataObject;
        try {
            AssociationList targetTransformations = jomaMeasure.getTargetTransformations();
            int i = targetTransformations.size() - 1;
            while (i >= 0 & ModelUtilities.isBlank(rolapGroupName)) {
                CMetadata tempColumn;
                String metadataType;
                FeatureMap featureMap = (FeatureMap)targetTransformations.elementAt(i);
                AssociationList transformationSources = featureMap.getTransformationSources();
                if (transformationSources.size() > 0 && (metadataType = (tempColumn = (CMetadata)transformationSources.elementAt(0)).getCMetadataType()).equals("LogicalColumn")) {
                    LogicalColumn logicalColumn = (LogicalColumn)tempColumn;
                    rolapGroupName = logicalColumn.getColumnName();
                }
                --i;
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        return rolapGroupName;
    }

    private String getDefaultGroupName() throws OLAPException {
        if (this.tableSet == null) {
            this.tableSet = this.owningCube.getTableSet();
        }
        this.groupName = !this.tableSet.isLoadClassicSAS() ? this.getDefaultMolapGroupName() : (this.metadataObject != null ? this.getDefaultRolapGroupName() : "");
        return this.groupName;
    }

    public String getDefaultName() {
        StringBuffer columnStatisticName = new StringBuffer(32);
        StringBuffer columnName = new StringBuffer();
        StringBuffer statisticName = new StringBuffer();
        this.getStatistic();
        if (this.statistic != null) {
            if (this.column != null) {
                columnName.append(this.column.getSASColumnName());
            }
            statisticName.append(this.statistic.getName());
        }
        if (columnName.length() > 32 - statisticName.length()) {
            columnName.replace(0, columnName.length(), columnName.substring(0, 32 - statisticName.length()));
        }
        columnStatisticName.append(columnName);
        columnStatisticName.append(statisticName);
        return columnStatisticName.toString();
    }

    public String getDefaultDesc() {
        StringBuffer caption = new StringBuffer(32);
        if (this.getStatistic() != null) {
            if (this.column != null) {
                caption.append(this.statistic.getDefaultMeasureCaption(this.column.getSASColumnName()));
            } else if (this.groupName != null) {
                caption.append(this.statistic.getDefaultMeasureCaption(this.groupName));
            }
        }
        return caption.toString();
    }

    public String getDefaultSASFormat() throws OLAPException {
        String defaultSASFormat = null;
        if (this.getStatistic() != null) {
            defaultSASFormat = this.statistic.getStandardFormat();
        }
        if (defaultSASFormat == null || ModelUtilities.isBlank(defaultSASFormat)) {
            if (this.tableSet == null) {
                this.tableSet = this.owningCube.getTableSet();
            }
            defaultSASFormat = !this.tableSet.isLoadClassicSAS() && this.column != null ? this.column.getSASFormat() : BEST12_SAS_FORMAT;
        }
        return defaultSASFormat != null || !ModelUtilities.isBlank(defaultSASFormat) ? defaultSASFormat : DEFAULT_FORMAT;
    }

    @Override
    public String getDesc() {
        this.verifyDeleted();
        return ModelUtilities.isBlank(super.getDesc()) ? this.getDefaultDesc().toString() : super.getDesc();
    }

    public String getGroupName() throws OLAPException {
        this.verifyDeleted();
        return this.groupName == null || ModelUtilities.isBlank(this.groupName) ? this.getDefaultGroupName() : this.groupName;
    }

    @Override
    public String getName() {
        return ModelUtilities.isBlank(super.getName()) ? this.getDefaultName() : super.getName();
    }

    public OLAPLevel getLevel() throws OLAPException {
        if (this.statistic == Statistic.getNunique() && this.level == null & this.metadataObject != null && !this.isNewObject()) {
            try {
                AssociationList transformationTargets = this.metadataObject.getTargetTransformations();
                Transformation transformation = (Transformation)transformationTargets.elementAt(0);
                AssociationList transformationSources = transformation.getTransformationSources();
                for (int i = 0; i < transformationSources.size(); ++i) {
                    CMetadata transformationSource = (CMetadata)transformationSources.get(i);
                    if (!transformationSource.getCMetadataType().equals("Level")) continue;
                    Level jomaLevel = (Level)transformationSource;
                    if (this.dimensionSet == null) {
                        this.dimensionSet = this.owningCube.getDimensionSet();
                    }
                    this.level = this.dimensionSet.getLevel(jomaLevel.getName());
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
            }
        }
        return this.level;
    }

    public OLAPHierarchy getHierarchy() throws OLAPException {
        if (this.statistic == Statistic.getNunique() && this.hierarchy == null & this.metadataObject != null && !this.isNewObject()) {
            try {
                AssociationList transformationTargets = this.metadataObject.getTargetTransformations();
                Transformation transformation = (Transformation)transformationTargets.elementAt(0);
                AssociationList transformationSources = transformation.getTransformationSources();
                for (int i = 0; i < transformationSources.size(); ++i) {
                    CMetadata transformationSource = (CMetadata)transformationSources.get(i);
                    if (!transformationSource.getCMetadataType().equals("Hierarchy")) continue;
                    Hierarchy jomaHierarchy = (Hierarchy)transformationSource;
                    if (this.dimensionSet == null) {
                        this.dimensionSet = this.owningCube.getDimensionSet();
                    }
                    this.hierarchy = this.dimensionSet.getHierarchy(jomaHierarchy.getName());
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
            }
        }
        return this.hierarchy;
    }

    public boolean getIncludeCalculatedMembers() throws OLAPException {
        boolean returnValue = false;
        if (this.includeCalc == null & this.metadataObject != null & !this.deleteIncludeCalcOption) {
            this.includeCalc = this.optionSet.getOption(this, "INCLUDE_CALCULATED_MEMBERS", "OLAPOption");
        }
        if (this.includeCalc != null && this.includeCalc.getDefaultValue().equals("1") && !this.deleteIncludeCalcOption) {
            returnValue = true;
        }
        return returnValue;
    }

    public OLAPColumn getInputColumn() throws OLAPException {
        this.verifyDeleted();
        if (this.tableSet == null) {
            this.tableSet = this.owningCube.getTableSet();
        }
        LoadTable loadTable = this.tableSet.getLoadTable();
        PhysicalTable table = loadTable.getTable();
        if (this.column == null & this.metadataObject != null && !this.isNewObject() && table != null) {
            if (this.tableSet.isLoadClassicSAS() && !this.statistic.isDerived()) {
                AggregationTable aggregationTable = this.tableSet.getAggregationTable(table);
                this.column = this.getAggregateColumn(aggregationTable);
            } else {
                try {
                    Measure jomaMeasure = (Measure)this.metadataObject;
                    ClassifierMap loadMap = loadTable.getClassifierMap();
                    AssociationList featureMaps = jomaMeasure.getTargetFeatureMaps();
                    int i = featureMaps.size() - 1;
                    while (i >= 0 & this.column == null) {
                        AssociationList columns;
                        FeatureMap featureMap = (FeatureMap)featureMaps.elementAt(i);
                        ClassifierMap tempMap = featureMap.getAssociatedClassifierMap();
                        if (tempMap == loadMap && (columns = featureMap.getFeatureSources()).size() > 0) {
                            Column tempColumn = (Column)columns.elementAt(0);
                            this.column = loadTable.getColumn(tempColumn);
                        }
                        --i;
                    }
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
                }
            }
        }
        return this.column;
    }

    public String getSASFormat() throws OLAPException {
        this.verifyDeleted();
        try {
            if (this.sasFormat == null && this.metadataObject != null && !this.isNewObject()) {
                Measure jomaMeasure = (Measure)this.metadataObject;
                this.sasFormat = jomaMeasure.getSASFormat();
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return ModelUtilities.isBlank(this.sasFormat) ? this.getDefaultSASFormat() : this.sasFormat;
    }

    public Statistic getStatistic() {
        this.verifyDeleted();
        try {
            if (this.statistic == null && this.metadataObject != null && !this.isNewObject()) {
                Measure jomaMeasure = (Measure)this.metadataObject;
                this.statistic = Statistic.getStatistic(jomaMeasure.getStatistic());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.statistic;
    }

    public String getUniqueName() throws OLAPException {
        this.verifyDeleted();
        String measureDimName = this.measureSet.getMeasuresDimensionName();
        return "[" + measureDimName + "].[" + this.getName() + "]";
    }

    public String getUnits() {
        this.verifyDeleted();
        try {
            if (this.units == null && this.metadataObject != null && !this.isNewObject()) {
                Measure jomaMeasure = (Measure)this.metadataObject;
                this.units = jomaMeasure.getUnits();
            }
            if (this.units == null) {
                this.units = "";
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.units;
    }

    public Boolean isStoredStatistic() {
        this.verifyDeleted();
        try {
            if (this.metadataObject != null & this.storedStatistic == null) {
                Measure jomaMeasure = (Measure)this.metadataObject;
                this.storedStatistic = jomaMeasure.getIsStoredStatistic() == 1;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.storedStatistic;
    }

    public boolean isIncludeCalculatedMembers() throws OLAPException {
        boolean included = false;
        if (this.includeCalc == null) {
            this.getIncludeCalculatedMembers();
        }
        if (this.includeCalc != null && !this.deleteIncludeCalcOption) {
            included = true;
        }
        return included;
    }

    public Boolean isNunique() {
        if (this.statistic == null) {
            this.getStatistic();
        }
        this.nuniqueStatistic = this.statistic == null ? Boolean.valueOf(false) : Boolean.valueOf(this.getStatistic().getName().equals("NUNIQUE"));
        return this.nuniqueStatistic;
    }

    private void isVerified() throws OLAPException {
        if (!this.verifiedName) {
            this.verifyName();
        }
        if (!this.verifiedStatistic) {
            this.verifyStatistic();
        }
        if (!this.verifiedAggregates & this.isNunique() == false) {
            this.verifyAggregates();
        }
    }

    public void setAggregateColumn(String inputAggregateColumnName) throws OLAPException {
        this.verifyDeleted();
        if (ModelUtilities.isBlank(inputAggregateColumnName)) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The aggregate column cannot be null.");
            }
            throw new IllegalArgumentException("Illegal argument is passed to the setAggregateColumn method.");
        }
        OLAPList tables = this.owningCube.getAggregationSet().getTables();
        if (tables.isEmpty()) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Cannot set an aggregate column for a measure when there are no aggregation tables.");
            }
            throw new IllegalStateException("An illegal use of the setAggregateColumn method was encountered.");
        }
        if (this.tableSet == null) {
            this.tableSet = this.owningCube.getTableSet();
        }
        if (!this.tableSet.isLoadClassicSAS()) {
            this.setAggregateColumnForce(tables, inputAggregateColumnName);
        }
        this.measureSet.setVerifiedAggregates(false);
        this.setUpChanges("undoAggregateColumn", String.class, inputAggregateColumnName);
    }

    private void setAggregateColumnForce(OLAPList tables, String inputAggregateColumnName) throws OLAPException {
        for (int i = tables.size() - 1; i >= 0; --i) {
            AggregationTable table = (AggregationTable)tables.get(i);
            OLAPColumn aggregateColumn = table.getColumn(inputAggregateColumnName);
            if (aggregateColumn == null) {
                if (Workspace.isDebug()) {
                    Workspace.getDefaultLogger().debug((Object)"The given column name doesn't have respective column in aggregation tables.");
                }
                throw new IllegalStateException("An illegal use of the setAggregateColumn method was encountered.");
            }
            this.setAggregateColumn(table, aggregateColumn);
        }
    }

    void setAggregateColumn(AggregationTable inputTable, OLAPColumn inputColumn) {
        if (this.aggregateColumns == null) {
            this.aggregateColumns = new HashMap();
        }
        this.aggregateColumns.put(inputTable, inputColumn);
    }

    void setAggregateColumns() throws OLAPException {
        if (this.metadataObject != null) {
            Measure jomaMeasure = (Measure)this.metadataObject;
            try {
                List featureMaps = this.getFeatureMaps(jomaMeasure);
                if (featureMaps.size() > 0) {
                    for (int i = featureMaps.size() - 1; i >= 0; --i) {
                        AssociationList sources;
                        String aggregate;
                        FeatureMap featureMap;
                        ClassifierMap classifierMap;
                        CMetadata object = (CMetadata)featureMaps.get(i);
                        if (!object.getCMetadataType().equalsIgnoreCase("FeatureMap") || (classifierMap = (featureMap = (FeatureMap)object).getAssociatedClassifierMap()) == null || !(aggregate = classifierMap.getTransformRole()).equalsIgnoreCase("AGGREGATE") && !aggregate.equals("NWAY")) continue;
                        AssociationList transformationSources = classifierMap.getTransformationSources(false);
                        if (transformationSources.isEmpty()) {
                            transformationSources = classifierMap.getClassifierSources(false);
                        }
                        AggregationTable table = null;
                        if (transformationSources.size() > 0) {
                            PhysicalTable physicalTable = (PhysicalTable)transformationSources.get(0);
                            if (this.tableSet == null) {
                                this.tableSet = this.owningCube.getTableSet();
                            }
                            table = this.tableSet.getAggregationTable(physicalTable);
                        }
                        if ((sources = featureMap.getFeatureSources()).isEmpty()) {
                            sources = featureMap.getTransformationSources();
                        }
                        if (sources.size() <= 0) continue;
                        OLAPColumn olapColumn = table.getColumn((Column)sources.get(0));
                        this.setAggregateColumn(table, olapColumn);
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException("MdException.GenericError.txt", mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public void setIncludeCalculatedMembers(String inputIncludeCalc) throws OLAPException {
        if (this.isNunique().booleanValue()) {
            if (inputIncludeCalc != null && inputIncludeCalc.equals("1")) {
                this.getIncludeCalculatedMembers();
                if (this.includeCalc == null) {
                    this.includeCalc = new Option(this.optionSet, this);
                    this.includeCalc.setName("INCLUDE_CALCULATED_MEMBERS");
                    this.includeCalc.setDesc("INCLUDE_CALCULATED_MEMBERS");
                    this.includeCalc.setPropertyName("INCLUDE_CALCULATED_MEMBERS");
                    this.includeCalc.setPropertyRole("OLAPOption");
                    this.includeCalc.setOwningType(OptionSet.OWNING_TYPE_BOOLEAN);
                    this.deleteIncludeCalcOption = false;
                }
                this.includeCalc.setDefaultValue("1");
            } else if (this.includeCalc != null) {
                List objectOptions = this.optionSet.getOptions(this);
                if (objectOptions.indexOf(this.includeCalc) >= 0) {
                    objectOptions.remove(this.includeCalc);
                }
                this.includeCalc = null;
                this.deleteIncludeCalcOption = true;
            }
            this.setUpChanges("setIncludeCalculatedMembers", String.class, inputIncludeCalc);
        }
    }

    @Override
    public void setName(String inputName) {
        this.verifyDeleted();
        super.setName(inputName);
        this.verifiedName = false;
        this.setUpChanges("setName", String.class, inputName);
    }

    @Override
    public void setNotes(String inputNotes) {
        super.setNotes(inputNotes);
        this.setUpChanges("setNotes", String.class, inputNotes);
    }

    void setColumn(OLAPColumn inputColumn) throws OLAPException {
        this.column = inputColumn;
        this.verifiedAggregates = false;
        String inputColumnName = inputColumn.getSASColumnName();
        if (!this.tableSet.isLoadClassicSAS()) {
            String columnGroupName = this.getGroupName();
            if (this.isStoredStatistic().booleanValue()) {
                OLAPList columnStoredMeasuresByGroupName = this.measureSet.getStoredMeasuresByGroupName(columnGroupName);
                OLAPList inputColumnStoredMeasuresByGroupName = this.measureSet.getStoredMeasuresByGroupName(inputColumnName);
                columnStoredMeasuresByGroupName.getTheList().remove(this);
                inputColumnStoredMeasuresByGroupName.getTheList().add(this);
            } else {
                OLAPList columnDerivedMeasuresByGroupName = this.measureSet.getDerivedMeasuresByGroupName(columnGroupName);
                OLAPList inputColumnDerivedMeasuresByGroupName = this.measureSet.getDerivedMeasuresByGroupName(inputColumnName);
                columnDerivedMeasuresByGroupName.getTheList().remove(this);
                inputColumnDerivedMeasuresByGroupName.getTheList().add(this);
            }
        } else {
            if (this.aggregationSet == null) {
                this.aggregationSet = this.owningCube.getAggregationSet();
            }
            this.setAggregateColumnForce(this.aggregationSet.getTables(), inputColumnName);
            LoadTable loadTable = this.tableSet.getLoadTable();
            OLAPList availableNumericColumns = loadTable.getAvailableNumericColumns();
            availableNumericColumns.getTheList().remove(inputColumn);
        }
        OLAPList measuresByColumn = this.measureSet.getMeasuresByColumn(this.column);
        measuresByColumn.getTheList().remove(this);
        this.measureSet.clearMeasuresByColumn(this);
        this.measureSet.getMeasuresByColumn(inputColumn).getTheList().add(this);
    }

    @Override
    public void setDesc(String inputDesc) {
        super.setDesc(inputDesc);
        this.setUpChanges("setDesc", String.class, inputDesc);
    }

    void undoGroupName(String inputGroupName) throws OLAPException {
        if (!ModelUtilities.isBlank(inputGroupName)) {
            this.setGroupName(inputGroupName);
        } else {
            List storedByGroup = this.measureSet.getStoredMeasuresByGroupName(this.groupName).getTheList();
            List derivedByGroup = this.measureSet.getDerivedMeasuresByGroupName(this.groupName).getTheList();
            storedByGroup.remove(this);
            derivedByGroup.remove(this);
            this.groupName = this.getDefaultGroupName();
            this.measureSet.synchRolap();
        }
    }

    public void setGroupName(String inputGroupName) throws OLAPException {
        OLAPList groupNames;
        this.verifyDeleted();
        if (this.tableSet == null) {
            this.tableSet = this.owningCube.getTableSet();
        }
        if (this.tableSet.isLoadClassicSAS()) {
            this.measureSet.verifyGroupName(this, inputGroupName);
            if (ModelUtilities.isBlank(inputGroupName)) {
                if (Workspace.isDebug()) {
                    Workspace.getDefaultLogger().debug((Object)"The groupname must not be null.");
                }
                throw new IllegalArgumentException("Illegal argument is passed to the setGroupName method.");
            }
            String oldGroupName = this.groupName;
            this.groupName = inputGroupName;
            if (this.statistic != null) {
                if (!ModelUtilities.isBlank(oldGroupName)) {
                    OLAPList oldStored = this.measureSet.getStoredMeasuresByGroupName(oldGroupName);
                    OLAPList oldDerived = this.measureSet.getDerivedMeasuresByGroupName(oldGroupName);
                    oldStored.getTheList().remove(this);
                    oldDerived.getTheList().remove(this);
                }
                OLAPList measures = null;
                this.isStoredStatistic();
                measures = this.storedStatistic != null && this.storedStatistic != false ? this.measureSet.getStoredMeasuresByGroupName(inputGroupName) : this.measureSet.getDerivedMeasuresByGroupName(inputGroupName);
                measures.getTheList().add(this);
                this.measureSet.synchRolap();
            }
        }
        if ((groupNames = this.measureSet.getGroupNames()).indexOf(this.groupName) < 0) {
            groupNames.add(this.groupName);
        }
        this.setUpChanges("undoGroupName", String.class, inputGroupName);
    }

    void setGroupNameForce(String inputGroupName) {
        this.groupName = inputGroupName;
    }

    public void setSASFormat(String inputSASFormat) {
        this.verifyDeleted();
        this.sasFormat = inputSASFormat;
        this.setUpChanges("setSASFormat", String.class, inputSASFormat);
    }

    void undoStatistic(Statistic inputStatistic) throws OLAPException {
        if (inputStatistic != null) {
            this.setStatistic(inputStatistic);
        } else {
            this.units = null;
            this.sasFormat = null;
            this.statistic = null;
            this.getStatistic();
            this.measureSet.clear(this);
            this.measureSet.getMeasures().getTheList().add(this);
            if (this.statistic != null) {
                this.setStatisticForce();
            }
        }
    }

    private void setStatisticForce() throws OLAPException {
        OLAPList derived;
        Object stored;
        this.storedStatistic = !this.statistic.isDerived();
        if (this.storedStatistic != null && this.storedStatistic.booleanValue()) {
            stored = this.measureSet.getStoredMeasures();
            if (!((OLAPList)stored).contains(this)) {
                ((OLAPList)stored).getTheList().add(this);
            }
        } else if (!this.isNunique().booleanValue() && !(derived = this.measureSet.getDerivedMeasures()).contains(this)) {
            derived.getTheList().add(this);
        }
        if (!this.isNunique().booleanValue()) {
            stored = this.isStoredStatistic();
            this.aggregationSet = this.owningCube.getAggregationSet();
            Boolean hasAggregations = this.aggregationSet.hasStoredAggregations();
            if ((hasAggregations != null && hasAggregations != false) & !ModelUtilities.isBlank(this.getGroupName()) & !ModelUtilities.isBlank(this.getName())) {
                OLAPList measures = null;
                measures = stored != null && !((Boolean)stored).booleanValue() ? this.measureSet.getDerivedMeasuresByGroupName(this.groupName) : this.measureSet.getStoredMeasuresByGroupName(this.groupName);
                if (!measures.contains(this)) {
                    measures.getTheList().add(this);
                }
            }
        }
    }

    public void setStatistic(Statistic inputStatistic) throws OLAPException {
        this.verifyDeleted();
        this.verifyStatistic(inputStatistic);
        if (this.statistic != null) {
            this.measureSet.clear(this);
        }
        this.statistic = inputStatistic;
        this.setStatisticForce();
        if (!this.changedName & this.name != null) {
            this.setName(null);
            this.changedName = false;
        }
        if (!this.changedDescription & this.description != null) {
            this.description = null;
            this.setDesc(this.getDesc());
            this.changedDescription = false;
        }
        if (this.units != null) {
            this.setUnits(null);
        }
        if (this.sasFormat != null) {
            this.setSASFormat(null);
        }
        if (inputStatistic != Statistic.getNunique()) {
            OLAPList groupNames = this.measureSet.getGroupNames();
            this.getGroupName();
            if (groupNames.indexOf(this.groupName) < 0) {
                groupNames.getTheList().add(this.groupName);
            }
            if (!ModelUtilities.isBlank(this.getGroupName())) {
                List storedMeasures = this.measureSet.getStoredMeasures().getTheList();
                List storedMeasuresByGroup = this.measureSet.getStoredMeasuresByGroupName(this.groupName).getTheList();
                List derivedMeasures = this.measureSet.getDerivedMeasures().getTheList();
                List derivedMeasuresByGroup = this.measureSet.getDerivedMeasuresByGroupName(this.groupName).getTheList();
                storedMeasures.remove(this);
                storedMeasuresByGroup.remove(this);
                derivedMeasures.remove(this);
                derivedMeasuresByGroup.remove(this);
                if (inputStatistic.isDerived()) {
                    derivedMeasures.add(this);
                    derivedMeasuresByGroup.add(this);
                } else {
                    storedMeasures.add(this);
                    storedMeasuresByGroup.add(this);
                }
                this.measureSet.synchRolap();
            }
        }
        this.setUpChanges("undoStatistic", Statistic.class, inputStatistic);
    }

    public void setUnits(String inputUnits) {
        this.verifyDeleted();
        this.units = inputUnits;
        this.setUpChanges("setUnits", String.class, inputUnits);
    }

    void setVerifiedAggregates(boolean inputVerifiedAggregates) {
        this.verifiedAggregates = inputVerifiedAggregates;
    }

    void undoAggregateColumn(String inputColumnName) throws OLAPException {
        if (ModelUtilities.isBlank(inputColumnName)) {
            this.aggregateColumns.clear();
        } else {
            if (this.aggregationSet == null) {
                this.aggregationSet = this.owningCube.getAggregationSet();
            }
            OLAPList tables = this.aggregationSet.getTables();
            this.setAggregateColumnForce(tables, inputColumnName);
        }
    }

    private void updateMetadataCube(Measure jomaMeasure) throws OLAPException {
        try {
            Cube jomaCube = (Cube)this.owningCube.metadataObject;
            AssociationList jomaCubeMeasures = jomaCube.getMeasures(false);
            if (jomaCubeMeasures.indexOf((Object)jomaMeasure) < 0) {
                jomaCubeMeasures.addElement((Object)jomaMeasure);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private void updateMetadataDimension(Measure jomaMeasure) throws OLAPException {
        try {
            Dimension measureDimension = this.measureSet.getMeasuresDimension();
            AssociationList jomaDimensionMeasures = measureDimension.getMeasures(false);
            if (jomaDimensionMeasures.indexOf((Object)jomaMeasure) < 0) {
                jomaDimensionMeasures.addElement((Object)jomaMeasure);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException("MdException.GenericError.txt", mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public void updateMetadata() throws OLAPException {
        this.verifyDeleted();
        this.isVerified();
        this.setName(this.getName());
        this.setDesc(this.getDesc());
        if (this.metadataObject == null) {
            this.metadataObject = (Measure)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Measure", this.owningCube.getRepositoryShortFQID());
        }
        super.updateMetadata();
        Measure jomaMeasure = (Measure)this.metadataObject;
        try {
            jomaMeasure.setPublicType("Measure");
            UsageVersion usageVersion = new UsageVersion(Integer.parseInt("4"), Integer.parseInt("0"), Integer.parseInt("0"));
            jomaMeasure.setUsageVersion(usageVersion.encode());
            jomaMeasure.setSASFormat(Strings.removeWhitespace((String)this.getSASFormat()));
            jomaMeasure.setStatistic(this.getStatistic().getName());
            jomaMeasure.setUniqueName(this.getUniqueName());
            jomaMeasure.setUnits(this.getUnits());
            boolean isStored = this.isStoredStatistic();
            if (isStored) {
                jomaMeasure.setIsStoredStatistic(1);
            } else {
                jomaMeasure.setIsStoredStatistic(0);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        this.updateMetadataCube(jomaMeasure);
        this.updateMetadataDimension(jomaMeasure);
        if (!this.isNunique().booleanValue()) {
            this.updateMetadataMolap(jomaMeasure);
            this.updateMetadataRolap(jomaMeasure);
        } else {
            this.updateMetadataNunique(jomaMeasure);
        }
        this.updateMetadataOptions();
    }

    private void updateMetadataNunique(Measure jomaMeasure) throws OLAPException {
        try {
            AssociationList transformationTargets = jomaMeasure.getTargetTransformations();
            Transformation transformation = transformationTargets.isEmpty() ? (Transformation)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Transformation", this.owningCube.getRepositoryShortFQID()) : (Transformation)transformationTargets.elementAt(0);
            this.updateMetadataTransformation(transformation, jomaMeasure, "OLAPNUnique");
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private void updateMetadataTransformation(Transformation transformation, Measure measure, String role) throws MdException, RemoteException {
        transformation.setName(measure.getName() + "_transformation");
        transformation.setDesc(measure.getName() + "_transformation");
        transformation.setTransformRole(role);
        AssociationList transformationSources = transformation.getTransformationSources();
        AssociationList transformationTargets = transformation.getTransformationTargets();
        transformationSources.clear();
        transformationSources.addElement((Object)this.level.metadataObject);
        transformationSources.addElement((Object)this.hierarchy.metadataObject);
        transformationTargets.clear();
        transformationTargets.addElement((Object)measure);
    }

    private void updateMetadataMolap(Measure jomaMeasure) throws OLAPException {
        this.verifyDeleted();
        try {
            if (this.tableSet == null) {
                this.tableSet = this.owningCube.getTableSet();
            }
            if (!this.tableSet.isLoadClassicSAS()) {
                LoadTable loadTable = this.tableSet.getLoadTable();
                ClassifierMap classifierMap = loadTable.getClassifierMap();
                if (classifierMap == null) {
                    classifierMap = loadTable.createClassifierMap();
                }
                FeatureMap featureMap = null;
                AssociationList featureMaps = jomaMeasure.getTargetFeatureMaps();
                int i = featureMaps.size() - 1;
                while (i >= 0 & featureMap == null) {
                    Measure tempMeasure;
                    FeatureMap tempFeatureMap = (FeatureMap)featureMaps.elementAt(i);
                    AssociationList targets = tempFeatureMap.getFeatureTargets();
                    if (!targets.isEmpty() && (tempMeasure = (Measure)targets.elementAt(0)) == jomaMeasure) {
                        featureMap = tempFeatureMap;
                    }
                    --i;
                }
                if (featureMap == null) {
                    featureMap = (FeatureMap)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "FeatureMap", this.owningCube.getRepositoryShortFQID());
                    featureMap.setName(this.getName() + "_FeatureMap");
                    featureMap.setTransformRole("TRNSFORM");
                    featureMap.getFeatureTargets().addElement((Object)jomaMeasure);
                    featureMap.getFeatureSources().addElement((Object)this.column.metadataObject);
                    featureMap.setAssociatedClassifierMap(classifierMap);
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException("MdException.GenericError.txt", mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException("MdException.GenericError.txt", re, 12);
        }
    }

    private List updateMetadataRolapGetAggregateColumns() throws OLAPException {
        ArrayList<Column> aggregates = new ArrayList<Column>();
        OLAPList tables = this.owningCube.getAggregationSet().getTables();
        for (int i = tables.size() - 1; i >= 0; --i) {
            AggregationTable table = (AggregationTable)tables.get(i);
            if (table.isLoadTable()) continue;
            OLAPColumn aggregateColumn = this.getAggregateColumn(table);
            aggregates.add(aggregateColumn.metadataObject);
        }
        return aggregates;
    }

    private FeatureMap updateMetadataRolapGetLogicalColumnFeatureMap(Measure jomaMeasure) throws OLAPException {
        AssociationList featureMaps = null;
        FeatureMap featureMap = null;
        try {
            featureMaps = jomaMeasure.getTargetTransformations();
            if (featureMaps.isEmpty()) {
                featureMap = (FeatureMap)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "FeatureMap", this.owningCube.getRepositoryShortFQID());
                featureMap.setName(this.getName() + "_FeatureMap");
                featureMaps.add((Object)featureMap);
            } else {
                featureMap = (FeatureMap)featureMaps.elementAt(0);
            }
            featureMap.setTransformRole("TRNSFORM  ");
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 0);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
        }
        return featureMap;
    }

    private void updateMetadataRolapLogicalColumn(FeatureMap featureMap) throws OLAPException {
        OLAPList groupNames = this.measureSet.getGroupNames();
        try {
            LogicalColumn logicalColumn = null;
            AssociationList logicalColumns = featureMap.getTransformationSources();
            for (int i = logicalColumns.size() - 1; i >= 0 && logicalColumn == null; --i) {
                CMetadata column = (CMetadata)logicalColumns.get(i);
                if (!column.getCMetadataType().equals("LogicalColumn")) continue;
                logicalColumn = (LogicalColumn)column;
            }
            if (logicalColumn != null) {
                if (!logicalColumn.getName().equals(this.groupName)) {
                    logicalColumns.remove(logicalColumn);
                }
                if (groupNames.contains(logicalColumn.getName())) {
                    this.measureSet.setLogicalColumn(logicalColumn.getName(), logicalColumn);
                } else {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)logicalColumn, "", bundle.getString("MdException.GenericError.txt"));
                }
            }
            if (logicalColumns.isEmpty()) {
                logicalColumns.add((Object)this.measureSet.getLogicalColumn(this.groupName));
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private void updateMetadataRolapDeleteInvalidAggregateFeatureMaps(List inputAggregateColumns, AssociationList featureMaps) throws OLAPException {
        if (this.tableSet == null) {
            this.tableSet = this.owningCube.getTableSet();
        }
        for (int i = featureMaps.size() - 1; i >= 0; --i) {
            FeatureMap featureMap = (FeatureMap)featureMaps.get(i);
            ClassifierMap classifierMap = null;
            try {
                CMetadata object;
                classifierMap = featureMap.getAssociatedClassifierMap();
                if (!(this.tableSet.isLoadClassicSAS() | !this.tableSet.isLoadClassicSAS() & (classifierMap != null && !classifierMap.getName().equals("Load Map")))) continue;
                List sources = null;
                try {
                    sources = this.getSources(featureMap);
                }
                catch (MdException error) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                }
                boolean removeFromMetadata = sources.isEmpty();
                Column jomaColumn = null;
                if (!removeFromMetadata && (object = (CMetadata)sources.get(0)).getCMetadataType().equalsIgnoreCase("Column")) {
                    jomaColumn = (Column)object;
                    boolean bl = removeFromMetadata = !inputAggregateColumns.contains(jomaColumn);
                }
                if (removeFromMetadata) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)featureMap, "", bundle.getString("MdException.GenericError.txt"));
                    continue;
                }
                inputAggregateColumns.remove(jomaColumn);
                continue;
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
    }

    private void updateMetadataRolapCreateAggregateFeatureMaps(List aggregates, AssociationList featureMaps) throws OLAPException {
        for (int i = aggregates.size() - 1; i >= 0; --i) {
            Column aggregateColumn = (Column)aggregates.get(i);
            if (this.tableSet == null) {
                this.tableSet = this.owningCube.getTableSet();
            }
            PhysicalTable columnTable = null;
            try {
                columnTable = (PhysicalTable)aggregateColumn.getTable();
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
            AggregationTable table = this.tableSet.getAggregationTable(columnTable);
            ClassifierMap classifierMap = table.getClassifierMap();
            if (classifierMap == null) {
                classifierMap = table.createClassifierMap();
            }
            FeatureMap featureMap = (FeatureMap)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "FeatureMap", this.owningCube.getRepositoryShortFQID());
            featureMaps.add((Object)featureMap);
            AssociationList sources = null;
            try {
                featureMap.setName(this.getName() + "_FeatureMap");
                featureMap.setTransformRole("ONETOONE  ");
                featureMap.setAssociatedClassifierMap(classifierMap);
                sources = featureMap.getTransformationSources();
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
            sources.add((Object)aggregateColumn);
        }
    }

    private AssociationList updateMetadataGetTransformations(Measure jomaMeasure) throws MdException, RemoteException, OLAPException {
        if (this.tableSet == null) {
            this.tableSet = this.owningCube.getTableSet();
        }
        LoadTable loadTable = this.tableSet.getLoadTable();
        AssociationList featureMaps = jomaMeasure.getTargetFeatureMaps();
        AssociationList transformations = jomaMeasure.getTargetTransformations();
        for (int i = featureMaps.size() - 1; i >= 0; --i) {
            Column column;
            PhysicalTable table;
            FeatureMap map = (FeatureMap)featureMaps.get(i);
            AssociationList sources = map.getFeatureSources();
            AssociationList targets = map.getFeatureTargets();
            if (sources.isEmpty() || loadTable.equals(table = (PhysicalTable)(column = (Column)sources.get(0)).getTable())) continue;
            if (!sources.isEmpty()) {
                map.getTransformationSources().add(sources.get(0));
                sources.clear();
            }
            if (!targets.isEmpty()) {
                map.getTransformationTargets().add(targets.get(0));
                targets.clear();
            }
            featureMaps.remove((Object)map);
            if (transformations.indexOf((Object)map) >= 0) continue;
            transformations.add((Object)map);
        }
        return transformations;
    }

    private void updateMetadataRolapLoadTableFeatureMaps(Measure jomaMeasure) throws MdException, RemoteException, OLAPException {
        FeatureMap featureMap = null;
        AssociationList featureMaps = jomaMeasure.getTargetFeatureMaps();
        int i = featureMaps.size() - 1;
        while (i >= 0 & featureMap == null) {
            Measure tempMeasure;
            FeatureMap tempFeatureMap = (FeatureMap)featureMaps.elementAt(i);
            AssociationList targets = tempFeatureMap.getFeatureTargets();
            if (!targets.isEmpty() && (tempMeasure = (Measure)targets.elementAt(0)) == jomaMeasure) {
                featureMap = tempFeatureMap;
            }
            --i;
        }
        if (featureMap == null) {
            TableSet tableSet = this.owningCube.getTableSet();
            LoadTable loadTable = tableSet.getLoadTable();
            ClassifierMap classifierMap = loadTable.getClassifierMap();
            if (classifierMap == null) {
                classifierMap = loadTable.createClassifierMap();
            }
            featureMap = (FeatureMap)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "FeatureMap", this.owningCube.getRepositoryShortFQID());
            featureMaps.add((Object)featureMap);
            featureMap.setName(this.getName() + "_FeatureMap");
            featureMap.setTransformRole("ONETOONE  ");
            featureMap.setAssociatedClassifierMap(classifierMap);
            featureMap.getFeatureSources().add((Object)this.column.metadataObject);
        }
    }

    private void updateMetadataRolapFeatureMaps(Measure jomaMeasure) throws OLAPException {
        AssociationList featureMaps = null;
        try {
            featureMaps = this.updateMetadataGetTransformations(jomaMeasure);
            List aggregates = this.updateMetadataRolapGetAggregateColumns();
            this.updateMetadataRolapDeleteInvalidAggregateFeatureMaps(aggregates, featureMaps);
            this.updateMetadataRolapCreateAggregateFeatureMaps(aggregates, featureMaps);
            this.updateMetadataRolapLoadTableFeatureMaps(jomaMeasure);
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private void updateMetadataOptions() throws OLAPException {
        if (this.optionSet != null) {
            try {
                Property property;
                int i;
                List options = this.optionSet.getOptions(this);
                HashMap<String, Property> metadataOptions = new HashMap<String, Property>();
                AssociationList properties = this.metadataObject.getProperties(false);
                int size = options.size();
                for (i = 0; i < size; ++i) {
                    Option option = (Option)options.get(i);
                    option.updateMetadata();
                }
                size = properties.size();
                for (i = 0; i < size; ++i) {
                    Property property2 = (Property)properties.elementAt(i);
                    metadataOptions.put(property2.getPropertyName(), property2);
                }
                if (this.deleteIncludeCalcOption & this.includeCalc == null && (property = (Property)metadataOptions.get("INCLUDE_CALCULATED_MEMBERS")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
            }
        }
    }

    private void updateMetadataRolap(Measure jomaMeasure) throws OLAPException {
        if (this.owningCube.getTableSet().isLoadClassicSAS()) {
            this.updateMetadataRolapLogicalColumn(this.updateMetadataRolapGetLogicalColumnFeatureMap(jomaMeasure));
        }
        Boolean storedAggregations = this.owningCube.getAggregationSet().hasStoredAggregations();
        if (!this.statistic.isDerived() & (storedAggregations != null && storedAggregations != false)) {
            this.updateMetadataRolapFeatureMaps(jomaMeasure);
        }
    }

    private void verifyStatisticRolap(Statistic inputStatistic) throws OLAPException {
        Boolean hasStoredAggregations;
        if (this.aggregationSet == null) {
            this.aggregationSet = this.owningCube.getAggregationSet();
        }
        if ((hasStoredAggregations = this.aggregationSet.hasStoredAggregations()) != null && hasStoredAggregations.booleanValue()) {
            OLAPList derivedStatistics;
            if (ModelUtilities.isBlank(this.groupName) & inputStatistic.isDerived()) {
                throw new OLAPException(bundle.getString("OLAPMeasure.GroupNameNoStatistic.txt"), 0);
            }
            if (inputStatistic.isDerived() && (derivedStatistics = this.measureSet.getPossibleDerivedStatisticsByGroupName(this.groupName)).indexOf(inputStatistic) < 0) {
                OLAPList existingStored = this.measureSet.getStoredMeasuresByGroupName(this.groupName);
                OLAPList existingStatistics = new OLAPList(Statistic.class);
                for (int i = existingStored.size() - 1; i >= 0; --i) {
                    OLAPMeasure storedMeasure = (OLAPMeasure)existingStored.get(i);
                    existingStatistics.add(storedMeasure.getStatistic());
                }
                OLAPList inputStatistics = new OLAPList(Statistic.class);
                inputStatistics.add(inputStatistic);
                OLAPList derivedStored = Statistic.getRequiredStoredStatistics(inputStatistics);
                StringBuffer missingStored = new StringBuffer();
                for (int i = derivedStored.size() - 1; i >= 0; --i) {
                    Statistic stored = (Statistic)derivedStored.get(i);
                    if (existingStatistics.contains(stored)) continue;
                    if (missingStored.length() > 0) {
                        missingStored.append(", ");
                    }
                    missingStored.append(stored.getLabel());
                }
                throw new OLAPException(bundle.formatString("OLAPMeasure.MeasureDerivedStatNotPossible.fmt.txt", (Object)this.getGroupName(), (Object)missingStored.toString(), (Object)inputStatistic.getLabel()), 0);
            }
        }
    }

    public void verifyAggregates() throws OLAPException {
        this.verifyDeleted();
        this.verifiedAggregates = false;
        this.measureSet.verifyAggregates(this);
        this.verifiedAggregates = true;
    }

    public void verifyGroupName() throws OLAPException {
        this.tableSet = this.owningCube.getTableSet();
        if (this.tableSet.isLoadClassicSAS()) {
            this.getGroupName();
            if (ModelUtilities.isBlank(this.groupName)) {
                throw new OLAPException(bundle.getString("OLAPMeasure.BlankGroupName.txt"), 0);
            }
        }
    }

    void verifyInputColumn() throws OLAPException {
        this.measureSet.verifyInputColumn(this);
    }

    private void verifyUniqueColumn() throws OLAPException {
        this.measureSet.verifyUniqueColumn(this);
    }

    private void verifyUniqueStatistic(Statistic inputStatistic) throws OLAPException {
        if (!ModelUtilities.isBlank(this.groupName)) {
            ArrayList<Statistic> statistics = new ArrayList<Statistic>();
            statistics.clear();
            OLAPList storedByGroupName = this.measureSet.getStoredMeasuresByGroupName(this.groupName);
            for (int i = storedByGroupName.size() - 1; i >= 0; --i) {
                Statistic tempStatistic;
                OLAPMeasure measure = (OLAPMeasure)storedByGroupName.get(i);
                if (measure.equals(this) || (tempStatistic = measure.getStatistic()) == null) continue;
                statistics.add(tempStatistic);
            }
            if (statistics.indexOf(inputStatistic) >= 0) {
                throw new OLAPException(bundle.formatString("OLAPMeasure.DuplicateStatistic.fmt.txt", (Object)inputStatistic.getName(), (Object)this.groupName), 0);
            }
        }
    }

    public void verifyStatistic() throws OLAPException {
        this.verifiedStatistic = false;
        if (this.statistic == null) {
            throw new OLAPException(bundle.getString("OLAPMeasure.StatisticNull.txt"), 0);
        }
        this.verifiedStatistic = true;
    }

    private void verifyStatistic(Statistic inputStatistic) throws OLAPException {
        this.verifiedStatistic = false;
        if (inputStatistic == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The statistic cannot be null.");
            }
            throw new IllegalArgumentException("Illegal argument is passed to the verifyStatistic method.");
        }
        if (inputStatistic != Statistic.getNunique()) {
            if (this.groupName == null) {
                this.getGroupName();
            }
            this.verifyStatisticRolap(inputStatistic);
            this.verifyUniqueStatistic(inputStatistic);
        }
        this.verifiedStatistic = true;
    }

    private List getFeatureMaps(Measure measureObject) throws MdException, RemoteException {
        int i;
        ArrayList<Object> featureMaps = new ArrayList<Object>();
        AssociationList targetFeatureMaps = measureObject.getTargetFeatureMaps();
        AssociationList targetTransformations = measureObject.getTargetTransformations();
        for (i = targetFeatureMaps.size() - 1; i >= 0; --i) {
            featureMaps.add(targetFeatureMaps.get(i));
        }
        for (i = targetTransformations.size() - 1; i >= 0; --i) {
            featureMaps.add(targetTransformations.get(i));
        }
        return featureMaps;
    }

    private List getSources(FeatureMap featureMap) throws MdException, RemoteException {
        int i;
        ArrayList<Object> sources = new ArrayList<Object>();
        AssociationList featureSources = featureMap.getFeatureSources();
        AssociationList transformationSources = featureMap.getTransformationSources();
        for (i = featureSources.size() - 1; i >= 0; --i) {
            sources.add(featureSources.get(i));
        }
        for (i = transformationSources.size() - 1; i >= 0; --i) {
            sources.add(transformationSources.get(i));
        }
        return sources;
    }

    private StringBuffer verifyMetadataColumns(Measure jomaMeasure) throws OLAPException {
        StringBuffer errorMessage = new StringBuffer();
        if (!this.isNunique().booleanValue()) {
            try {
                List featureMaps = this.getFeatureMaps(jomaMeasure);
                for (int j = 0; j < featureMaps.size(); ++j) {
                    FeatureMap featureMap = (FeatureMap)featureMaps.get(j);
                    ClassifierMap classifierMap = featureMap.getAssociatedClassifierMap();
                    if (classifierMap == null) continue;
                    List sources = this.getSources(featureMap);
                    AssociationList tableSources = null;
                    if (!sources.isEmpty()) continue;
                    tableSources = classifierMap.getClassifierSources(false);
                    if (tableSources.isEmpty() && (tableSources = classifierMap.getTransformationSources(false)).isEmpty() && !classifierMap.getName().equals("Load Map")) {
                        errorMessage.append(bundle.formatString("OLAPMeasure.MissingAggregationTable.fmt.txt", (Object)this.getName()));
                    }
                    if (tableSources.isEmpty()) continue;
                    PhysicalTable table = (PhysicalTable)tableSources.get(0);
                    StringBuffer libTable = new StringBuffer();
                    libTable.append(LibraryUtil.getLibrary((DataTable)table, null)).append(".").append(table.getName());
                    this.getStatistic();
                    if (classifierMap.getName().equals("Load Map")) {
                        errorMessage.append(bundle.formatString("OLAPMeasure.MissingLoadTableColumn.fmt.txt", (Object)this.getName(), (Object)libTable.toString()));
                        this.delete();
                        continue;
                    }
                    errorMessage.append(bundle.formatString("OLAPMeasure.MissingAggregateTableColumn.fmt.txt", (Object)this.getName(), (Object)libTable.toString()));
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return errorMessage;
    }

    private void verifyMetadataConvert(Measure jomaMeasure) throws OLAPException {
        try {
            AssociationList targetFeatureMaps = jomaMeasure.getTargetFeatureMaps();
            AssociationList targetTransformations = jomaMeasure.getTargetTransformations();
            for (int i = targetFeatureMaps.size() - 1; i >= 0; --i) {
                Column column;
                PhysicalTable table;
                LoadTable loadTable;
                FeatureMap featureMap = (FeatureMap)targetFeatureMaps.elementAt(i);
                AssociationList featureSources = featureMap.getFeatureSources();
                AssociationList transformationSources = featureMap.getTransformationSources();
                if (featureSources.size() <= 0) continue;
                CMetadata tempColumn = (CMetadata)featureSources.elementAt(0);
                String metadataType = tempColumn.getCMetadataType();
                if (metadataType.equals("LogicalColumn")) {
                    LogicalColumn logicalColumn = (LogicalColumn)tempColumn;
                    targetFeatureMaps.remove((Object)featureMap);
                    targetTransformations.addElement((Object)featureMap);
                    featureSources.remove((Object)logicalColumn);
                    transformationSources.addElement((Object)logicalColumn);
                    continue;
                }
                if (this.tableSet == null) {
                    this.tableSet = this.owningCube.getTableSet();
                }
                if ((loadTable = this.tableSet.getLoadTable()).equals(table = (PhysicalTable)(column = (Column)tempColumn).getTable())) continue;
                targetFeatureMaps.remove((Object)featureMap);
                featureMap.getTransformationSources().add(featureSources.get(0));
                featureSources.clear();
                if (targetTransformations.indexOf((Object)featureMap) >= 0) continue;
                targetTransformations.add((Object)featureMap);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    StringBuffer verifyMetadata() throws OLAPException {
        StringBuffer errorMessage = null;
        if (this.metadataObject != null) {
            Measure jomaMeasure = (Measure)this.metadataObject;
            this.verifyMetadataConvert(jomaMeasure);
            errorMessage = this.verifyMetadataColumns(jomaMeasure);
            if (errorMessage.length() > 0) {
                this.currentChanges = null;
                this.allChanges = null;
            }
        }
        return errorMessage;
    }

    @Override
    public void verifyName() throws OLAPException {
        this.verifyDeleted();
        this.name = this.getName();
        this.verifiedName = false;
        super.verifyName();
        super.verifySASName();
        this.measureSet.verifyUniqueName(this);
        this.verifiedName = true;
    }
}

