/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.DefinedMemberSet;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.OLAPTable;
import com.sas.olapadmin.designer.model.Statistic;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class OLAPList
extends AbstractList {
    static WAdminResource bundle = new WAdminResource(OLAPList.class);
    private final String OLAPHierarchy = "OLAPHierarchy";
    private final String OLAPMemberProperty = "OLAPMemberProperty";
    private final String OLAPDimension = "OLAPDimension";
    private final String OLAPSharedDimension = "OLAPSharedDimension";
    private final String OLAPAggregation = "OLAPAggregation";
    private final String OLAPLevel = "OLAPLevel";
    List olapList;
    Object parentObject;
    private Class classType;
    private boolean modifiable;
    boolean allowUndoSetup;
    boolean add;
    boolean remove;

    public OLAPList(Class inputClassType) {
        if (inputClassType == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"An OLAPList must be created with a type.");
            }
            throw new IllegalArgumentException("Illegal argument is passed to the OLAPList constructor.");
        }
        this.olapList = new ArrayList();
        this.classType = inputClassType;
        this.modifiable = true;
        this.allowUndoSetup = true;
        this.add = true;
    }

    @Override
    public int size() {
        return this.olapList.size();
    }

    public Object getParentObject() {
        return this.parentObject;
    }

    List getTheList() {
        return this.olapList;
    }

    @Override
    public Object get(int location) {
        return this.olapList.get(location);
    }

    public Object get(String name) {
        Object objectByName = null;
        for (int i = this.olapList.size() - 1; i >= 0 && objectByName == null; --i) {
            Object olapModel;
            objectByName = this.olapList.get(i);
            if (objectByName instanceof AbstractOLAPModel) {
                olapModel = objectByName;
                if (((AbstractOLAPModel)olapModel).getName().equalsIgnoreCase(name)) continue;
                objectByName = null;
                continue;
            }
            if (objectByName instanceof OLAPTable) {
                olapModel = objectByName;
                if (((OLAPTable)olapModel).getSASTableName().equalsIgnoreCase(name)) continue;
                objectByName = null;
                continue;
            }
            if (!(objectByName instanceof Statistic) || ((Statistic)(olapModel = (Statistic)objectByName)).getName().equalsIgnoreCase(name)) continue;
            objectByName = null;
        }
        return objectByName;
    }

    private void addAggregationTable(AggregationTable table) {
        try {
            AggregationSet aggregationSet = table.getTableSet().getOwningCube().getAggregationSet();
            aggregationSet.setHasStoredAggregations(true);
        }
        catch (OLAPException olapError) {
            throw new IllegalStateException("The application encountered an error adding an aggregation table to the list.");
        }
    }

    private void addOLAPAggregationStored(OLAPAggregation aggregation, AggregationSet aggregationSet, AggregationTable table, boolean dropList) throws OLAPException {
        if (!dropList && table != null) {
            List storedAggregations = aggregationSet.getStoredAggregations().getTheList();
            List aggregationsByTable = aggregationSet.getAggregationsByTable(table).getTheList();
            if (aggregation.isNway()) {
                storedAggregations.add(0, aggregation);
                aggregationsByTable.add(0, aggregation);
            } else {
                storedAggregations.add(aggregation);
                aggregationsByTable.add(aggregation);
            }
        }
    }

    private boolean addOLAPAggregationGenerated(OLAPAggregation aggregation, AggregationSet aggregationSet, AggregationTable table, boolean dropList) throws OLAPException {
        boolean returned = false;
        if (!dropList && table == null) {
            List generatedAggregations = aggregationSet.getGeneratedAggregations().getTheList();
            if (aggregation.isNway()) {
                generatedAggregations.add(0, aggregation);
                this.olapList.add(0, aggregation);
                returned = true;
            } else {
                generatedAggregations.add(aggregation);
            }
        }
        return returned;
    }

    private void addOLAPAggregationPerformance(OLAPAggregation aggregation, AggregationSet aggregationSet, boolean dropList) throws OLAPException {
        if (!dropList && aggregation.hasPerformanceOptions()) {
            List performanceAggregations = aggregationSet.getPerformanceAggregations().getTheList();
            if (aggregation.isNway()) {
                performanceAggregations.add(0, aggregation);
            } else {
                performanceAggregations.add(aggregation);
            }
        }
    }

    private boolean addOLAPAggregation(OLAPAggregation aggregation) {
        boolean returned = false;
        boolean isDeleted = aggregation.isDeleted();
        if (this.olapList.contains(aggregation)) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Aggregation must exist only once in the aggregations list.");
            }
            throw new IllegalStateException("An invalid use of the add method was encountered.");
        }
        try {
            OLAPCube owningCube = aggregation.getOwningCube();
            AggregationSet aggregationSet = owningCube.getAggregationSet();
            boolean addList = aggregationSet.isAddAggregationList(this);
            boolean dropList = aggregationSet.isDropAggregationList(this);
            if ((addList || dropList) && aggregation.isNway()) {
                if (Workspace.isDebug()) {
                    Workspace.getDefaultLogger().debug((Object)"The NWAY aggregation cannot be used with the add or drop aggregation lists.");
                }
                throw new IllegalStateException("An invalid use of the add method was encountered.");
            }
            if (addList || dropList) {
                aggregationSet.setIsAggregationTuning(true);
            }
            AggregationTable table = aggregation.getAggregationTable();
            this.addOLAPAggregationStored(aggregation, aggregationSet, table, dropList);
            this.addOLAPAggregationGenerated(aggregation, aggregationSet, table, dropList);
            this.addOLAPAggregationPerformance(aggregation, aggregationSet, dropList);
        }
        catch (OLAPException error) {
            aggregation.setDeleted(isDeleted);
            throw new IllegalStateException("The application encountered an error adding an aggregation to the list.");
        }
        return returned;
    }

    private boolean addOLAPDefinedMember(OLAPDefinedMember member) {
        member.setDeleted(false);
        DefinedMemberSet memberSet = member.getOwningSet();
        if (member.metadataObject != null) {
            memberSet.getDeleteList().remove(member);
        }
        try {
            List list;
            List list2;
            List list3;
            String type = member.getType();
            OLAPList calculatedMeasures = memberSet.getCalculatedMeasures();
            if (type.equals("Calculated Measure") && !(list3 = calculatedMeasures.getTheList()).contains(member)) {
                list3.add(member);
            }
            OLAPList calculatedMembers = memberSet.getCalculatedMembers();
            if ((type.equals("Calculated Measure") || type.equals("Calculated Member")) && !(list2 = calculatedMembers.getTheList()).contains(member)) {
                list2.add(member);
            }
            OLAPList namedSets = memberSet.getNamedSets();
            if (type.equals("Named Set") && !(list = namedSets.getTheList()).contains(member)) {
                list.add(member);
            }
        }
        catch (OLAPException e) {
            throw new IllegalStateException("The application encountered an error adding an defined member to the list.");
        }
        return true;
    }

    public void addDefaultHierarchy(OLAPHierarchy defaultHierarchy) {
        if (defaultHierarchy == null) {
            throw new UnsupportedOperationException("A hierarchy must be specified.");
        }
        List listOfHierarchies = this.getTheList();
        int whereIsHierarchy = listOfHierarchies.indexOf(defaultHierarchy);
        if (whereIsHierarchy > 0) {
            listOfHierarchies.remove(whereIsHierarchy);
            listOfHierarchies.add(0, defaultHierarchy);
        }
    }

    private boolean addOLAPDimension(OLAPDimension dimension) {
        dimension.setDeleted(false);
        DimensionSet dimensionSet = dimension.getDimensionSet();
        if (dimension.metadataObject != null) {
            dimensionSet.getDimensionDeleteList().remove(dimension);
        }
        dimensionSet.setDimensionChanged(true);
        return true;
    }

    private boolean addOLAPDimension(OLAPSharedDimension dimension) {
        dimension.setDeleted(false);
        DimensionSet dimensionSet = dimension.getDimensionSet();
        if (dimension.metadataObject != null) {
            dimensionSet.getSharedDimensionDeleteList().remove(dimension);
        }
        dimensionSet.setDimensionChanged(true);
        return true;
    }

    private boolean addOLAPHierarchy(OLAPHierarchy hierarchy) {
        hierarchy.setDeleted(false);
        if (this.parentObject != null) {
            Class<?> className = this.getParentObject().getClass();
            String thisString = className.toString();
            DimensionSet dimensionSet = hierarchy.getDimensionSet();
            if (thisString.indexOf("OLAPMemberProperty") > 0) {
                try {
                    hierarchy.getOLAPProperties().getTheList().add(this.getParentObject());
                }
                catch (OLAPException oError) {
                    throw new IllegalStateException("The application encountered an error adding a hierarchy to the list.");
                }
            } else if (thisString.indexOf("OLAPDimension") > 0) {
                OLAPDimension dimension = (OLAPDimension)this.parentObject;
                if (hierarchy.metadataObject != null) {
                    dimensionSet.getHierarchyDeleteList().remove(hierarchy);
                }
                dimension.setUpListChanges("remove", hierarchy, this, -1);
                dimensionSet.setDimensionChanged(true);
            } else if (thisString.indexOf("OLAPSharedDimension") > 0) {
                OLAPSharedDimension dimension = (OLAPSharedDimension)this.parentObject;
                if (hierarchy.metadataObject != null) {
                    dimensionSet.getHierarchyDeleteList().remove(hierarchy);
                }
                dimension.setUpListChanges("remove", hierarchy, this, -1);
                dimensionSet.setDimensionChanged(true);
            } else if (thisString.indexOf("OLAPLevel") > 0) {
                OLAPLevel level = (OLAPLevel)this.parentObject;
                level.setUpListChanges("remove", hierarchy, this, -1);
                dimensionSet.setDimensionChanged(true);
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addOLAPLevel(OLAPLevel level) {
        level.setDeleted(false);
        if (this.parentObject == null) return true;
        DimensionSet dimensionSet = level.getDimensionSet();
        Class<?> className = this.getParentObject().getClass();
        String thisString = className.toString();
        if (thisString.indexOf("OLAPHierarchy") > 0) {
            try {
                OLAPHierarchy hierarchy = (OLAPHierarchy)this.parentObject;
                OLAPList listOfHierarchies = level.getHierarchies();
                dimensionSet.setDimensionChanged(true);
                if (!listOfHierarchies.contains(this.getParentObject())) {
                    level.getHierarchies().getTheList().add(this.getParentObject());
                }
                hierarchy.setUpListChanges("remove", level, this, -1);
                return true;
            }
            catch (OLAPException error) {
                throw new IllegalStateException("The application encountered an error adding a level to the list.");
            }
        }
        if (thisString.indexOf("OLAPDimension") > 0) {
            try {
                OLAPDimension dimension = level.getDimension();
                dimension.setUpListChanges("remove", level, this, -1);
                dimensionSet.setDimensionChanged(true);
                OLAPColumn tempOlapColumn = level.getColumn();
                dimensionSet.levelNames.add(level.getName());
                if (tempOlapColumn != null) {
                    ArrayList<OLAPLevel> listOfLevels = (ArrayList<OLAPLevel>)dimensionSet.levels.get(tempOlapColumn);
                    if (listOfLevels != null) {
                        listOfLevels.add(level);
                    } else {
                        listOfLevels = new ArrayList<OLAPLevel>();
                        listOfLevels.add(level);
                        dimensionSet.levels.put(tempOlapColumn, listOfLevels);
                    }
                } else {
                    ArrayList<OLAPLevel> listOfLevels = (ArrayList<OLAPLevel>)dimensionSet.levels.get(level.getName());
                    if (listOfLevels != null) {
                        listOfLevels.add(level);
                    } else {
                        listOfLevels = new ArrayList<OLAPLevel>();
                        listOfLevels.add(level);
                        dimensionSet.levels.put(level.getName(), listOfLevels);
                    }
                }
                if (level.metadataObject == null) return true;
                dimensionSet.getLevelDeleteList().remove(level);
                dimensionSet.metaLevelLevel.put(level.metadataObject, level);
                return true;
            }
            catch (OLAPException error) {
                throw new IllegalStateException("The application encountered an error adding a level to the list.");
            }
        }
        if (thisString.indexOf("OLAPSharedDimension") > 0) {
            try {
                OLAPDimension dimension = level.getDimension();
                dimension.setUpListChanges("remove", level, this, -1);
                dimensionSet.setDimensionChanged(true);
                OLAPColumn tempOlapColumn = level.getColumn();
                dimensionSet.levelNames.add(level.getName());
                if (tempOlapColumn != null) {
                    ArrayList<OLAPLevel> listOfLevels = (ArrayList<OLAPLevel>)dimensionSet.levels.get(tempOlapColumn);
                    if (listOfLevels != null) {
                        listOfLevels.add(level);
                    } else {
                        listOfLevels = new ArrayList<OLAPLevel>();
                        listOfLevels.add(level);
                        dimensionSet.levels.put(tempOlapColumn, listOfLevels);
                    }
                } else {
                    ArrayList<OLAPLevel> listOfLevels = (ArrayList<OLAPLevel>)dimensionSet.levels.get(level.getName());
                    if (listOfLevels != null) {
                        listOfLevels.add(level);
                    } else {
                        listOfLevels = new ArrayList<OLAPLevel>();
                        listOfLevels.add(level);
                        dimensionSet.levels.put(level.getName(), listOfLevels);
                    }
                }
                if (level.metadataObject == null) return true;
                dimensionSet.getLevelDeleteList().remove(level);
                dimensionSet.metaLevelLevel.put(level.metadataObject, level);
                return true;
            }
            catch (OLAPException error) {
                throw new IllegalStateException("The application encountered an error adding a level to the list.");
            }
        }
        if (thisString.indexOf("OLAPAggregation") <= 0) return true;
        this.olapList.add(level);
        dimensionSet.setDimensionChanged(true);
        OLAPAggregation aggregation = (OLAPAggregation)this.parentObject;
        try {
            aggregation.resetHierarchyLevels();
            return true;
        }
        catch (OLAPException error) {
            throw new IllegalStateException("The application encountered an error adding a level to the list.");
        }
    }

    private boolean addOLAPMeasure(OLAPMeasure measure) {
        boolean returned = false;
        boolean isDeleted = measure.isDeleted();
        if (isDeleted) {
            measure.setDeleted(false);
        }
        AggregationSet aggregationSet = measure.getOwningCube().getAggregationSet();
        if (this.olapList.contains(measure)) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The measures list already contains the given measure.");
            }
            throw new IllegalStateException("An illegal use of the addOLAPMeasure method was encountered.");
        }
        try {
            String groupName;
            OLAPList measuresByColumn;
            OLAPCube owningCube = measure.getOwningCube();
            MeasureSet measureSet = owningCube.getMeasureSet();
            TableSet tableSet = owningCube.getTableSet();
            if (tableSet.isLoadClassicSAS()) {
                LoadTable loadTable = tableSet.getLoadTable();
                OLAPList availableNumericColumns = loadTable.getAvailableNumericColumns();
                OLAPColumn column = measure.getInputColumn();
                if (column != null) {
                    availableNumericColumns.getTheList().remove(column);
                }
            }
            OLAPList storedMeasures = measureSet.getStoredMeasures();
            OLAPList derivedMeasures = measureSet.getDerivedMeasures();
            OLAPList nuniqueMeasures = measureSet.getNUniqueMeasures();
            OLAPList storedMeasuresByGroupName = null;
            OLAPList derivedMeasuresByGroupName = null;
            OLAPList groupNames = measureSet.getGroupNames();
            OLAPColumn olapColumn = measure.getInputColumn();
            if (olapColumn != null && !(measuresByColumn = measureSet.getMeasuresByColumn(olapColumn)).contains(measure)) {
                measuresByColumn.getTheList().add(measure);
            }
            if (!groupNames.contains(groupName = measure.getGroupName())) {
                groupNames.add(groupName);
            }
            if (!ModelUtilities.isBlank(groupName)) {
                storedMeasuresByGroupName = measureSet.getStoredMeasuresByGroupName(groupName);
                derivedMeasuresByGroupName = measureSet.getDerivedMeasuresByGroupName(groupName);
            }
            if (this.olapList.contains(measure)) {
                measure.setDeleted(isDeleted);
                if (Workspace.isDebug()) {
                    Workspace.getDefaultLogger().debug((Object)"The measures list already contains the given measure.");
                }
                throw new IllegalArgumentException("An illegal use of the addOLAPMeasure method was encountered.");
            }
            measureSet.verifyUniqueName(measure);
            measure.verifyStatistic();
            measure.verifyInputColumn();
            measure.verifyAggregates();
            List deleteList = measureSet.getDeleteList();
            if (measure.metadataObject != null) {
                deleteList.remove(measure.metadataObject);
            }
            returned = this.olapList.add(measure);
            Boolean storedStatistic = measure.isStoredStatistic();
            if (storedStatistic != null) {
                if (storedStatistic.booleanValue()) {
                    storedMeasures.getTheList().add(measure);
                    if (storedMeasuresByGroupName != null) {
                        storedMeasuresByGroupName.getTheList().add(measure);
                    }
                    measureSet.autoAdd(groupName);
                } else {
                    derivedMeasures.getTheList().add(measure);
                    if (measure.isNunique().booleanValue()) {
                        nuniqueMeasures.getTheList().add(measure);
                    }
                    if (derivedMeasuresByGroupName != null) {
                        derivedMeasuresByGroupName.getTheList().add(measure);
                    }
                    OLAPList autoDeleted = measureSet.getAutoDeletedByGroupName(groupName);
                    autoDeleted.getTheList().remove(measure);
                }
            }
            if (measure.metadataObject != null && deleteList.contains(measure.metadataObject)) {
                deleteList.remove(measure.metadataObject);
            }
            measureSet.synchRolap();
        }
        catch (OLAPException error) {
            measure.setDeleted(isDeleted);
        }
        try {
            aggregationSet.resetAggregationTables();
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return returned;
    }

    private boolean addOLAPMemberProperty(OLAPMemberProperty property) {
        property.setDeleted(false);
        property.getOLAPMemberPropertySet().getOLAPMemberPropertyDeleteList().remove(property);
        return true;
    }

    @Override
    public synchronized boolean add(Object olapObject) {
        this.add = true;
        boolean returned = false;
        if (olapObject == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Cannot add null objects to an OLAPList.");
            }
            throw new IllegalArgumentException("Illegal argument is passed to the add method.");
        }
        if (!this.modifiable) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The list is not modifiable.");
            }
            throw new IllegalStateException("An illegal use of the add method was encountered.");
        }
        if (!olapObject.getClass().equals(this.classType) && !(olapObject instanceof OLAPSharedDimension)) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)("Can only add " + this.classType + " to this list."));
            }
            throw new IllegalArgumentException("Illegal argument is passed to the add method.");
        }
        if (this.olapList.contains(olapObject)) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Cannot add objects that are already on the list.");
            }
            throw new IllegalStateException("An illegal use of the add method was encountered.");
        }
        if (olapObject instanceof AggregationTable) {
            this.addAggregationTable((AggregationTable)olapObject);
        } else if (olapObject instanceof OLAPMeasure) {
            returned = this.addOLAPMeasure((OLAPMeasure)olapObject);
        } else if (olapObject instanceof OLAPAggregation) {
            returned = this.addOLAPAggregation((OLAPAggregation)olapObject);
        } else if (olapObject instanceof OLAPLevel) {
            returned = this.addOLAPLevel((OLAPLevel)olapObject);
        } else if (olapObject instanceof OLAPHierarchy) {
            returned = this.addOLAPHierarchy((OLAPHierarchy)olapObject);
        } else if (olapObject instanceof OLAPSharedDimension) {
            this.addOLAPDimension((OLAPSharedDimension)olapObject);
        } else if (olapObject instanceof OLAPDimension) {
            returned = this.addOLAPDimension((OLAPDimension)olapObject);
        } else if (olapObject instanceof OLAPMemberProperty) {
            returned = this.addOLAPMemberProperty((OLAPMemberProperty)olapObject);
        } else if (olapObject instanceof OLAPDefinedMember) {
            this.addOLAPDefinedMember((OLAPDefinedMember)olapObject);
        }
        if (this.add && !this.olapList.contains(olapObject)) {
            returned = this.olapList.add(olapObject);
        }
        return returned;
    }

    @Override
    public synchronized void add(int location, Object olapObject) {
        if (olapObject == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Cannot add null objects to an OLAPList.");
            }
            throw new IllegalArgumentException("Illegal argument is passed to the add method.");
        }
        if (!this.modifiable) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The list is not modifiable.");
            }
            throw new IllegalStateException("An illegal use of the add method was encountered.");
        }
        if (!olapObject.getClass().equals(this.classType)) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)("Can only add " + this.classType + " to this list."));
            }
            throw new IllegalArgumentException("Illegal argument is passed to the add method.");
        }
        if (this.olapList.contains(olapObject)) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Cannot add objects that are already on the list.");
            }
            throw new IllegalStateException("An illegal use of the add method was encountered.");
        }
        if (olapObject instanceof OLAPLevel) {
            this.addOLAPLevel((OLAPLevel)olapObject);
            this.olapList.remove(olapObject);
        } else if (olapObject instanceof OLAPHierarchy) {
            this.addOLAPHierarchy((OLAPHierarchy)olapObject);
        } else if (olapObject instanceof OLAPSharedDimension) {
            this.addOLAPDimension((OLAPSharedDimension)olapObject);
        } else if (olapObject instanceof OLAPDimension) {
            this.addOLAPDimension((OLAPDimension)olapObject);
        } else if (olapObject instanceof OLAPDefinedMember) {
            this.addOLAPDefinedMember((OLAPDefinedMember)olapObject);
        } else if (olapObject instanceof OLAPMemberProperty) {
            this.addOLAPMemberProperty((OLAPMemberProperty)olapObject);
        }
        this.olapList.add(location, olapObject);
    }

    @Override
    public synchronized boolean addAll(Collection c) {
        if (!this.modifiable) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The list is not modifiable.");
            }
            throw new IllegalStateException("An illegal use of the addAll method was encountered.");
        }
        boolean ret = false;
        for (Object olapObject : c) {
            if (olapObject == null || !olapObject.getClass().equals(this.classType)) continue;
            if (olapObject instanceof OLAPLevel) {
                this.addOLAPLevel((OLAPLevel)olapObject);
            } else if (olapObject instanceof OLAPHierarchy) {
                this.addOLAPHierarchy((OLAPHierarchy)olapObject);
            } else if (olapObject instanceof OLAPSharedDimension) {
                this.addOLAPDimension((OLAPSharedDimension)olapObject);
            } else if (olapObject instanceof OLAPDimension) {
                this.addOLAPDimension((OLAPDimension)olapObject);
            } else if (olapObject instanceof OLAPMemberProperty) {
                this.addOLAPMemberProperty((OLAPMemberProperty)olapObject);
            } else if (olapObject instanceof OLAPDefinedMember) {
                this.addOLAPDefinedMember((OLAPDefinedMember)olapObject);
            }
            if (this.olapList.contains(olapObject)) continue;
            ret = this.olapList.add(olapObject);
        }
        return ret;
    }

    @Override
    public synchronized boolean addAll(int index, Collection c) {
        if (!this.modifiable) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The list is not modifiable.");
            }
            throw new IllegalStateException("An illegal use of the addAll method was encountered.");
        }
        int numnew = c.size();
        int incrementer = 0;
        for (Object olapObject : c) {
            if (olapObject == null || !olapObject.getClass().equals(this.classType)) continue;
            if (olapObject instanceof OLAPLevel) {
                this.addOLAPLevel((OLAPLevel)olapObject);
                this.olapList.remove(olapObject);
            } else if (olapObject instanceof OLAPHierarchy) {
                this.addOLAPHierarchy((OLAPHierarchy)olapObject);
            } else if (olapObject instanceof OLAPSharedDimension) {
                this.addOLAPDimension((OLAPSharedDimension)olapObject);
            } else if (olapObject instanceof OLAPDimension) {
                this.addOLAPDimension((OLAPDimension)olapObject);
            } else if (olapObject instanceof OLAPMemberProperty) {
                this.addOLAPMemberProperty((OLAPMemberProperty)olapObject);
            } else if (olapObject instanceof OLAPDefinedMember) {
                this.addOLAPDefinedMember((OLAPDefinedMember)olapObject);
            }
            if (!this.olapList.contains(olapObject)) {
                this.olapList.add(index + incrementer, olapObject);
            }
            ++incrementer;
        }
        return numnew != 0;
    }

    @Override
    public synchronized void clear() {
        if (!this.modifiable) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The list is not modifiable.");
            }
            throw new IllegalStateException("An illegal use of the clear method was encountered.");
        }
        if (this.olapList.size() > 0 && this.olapList.get(0) != null && (this.olapList.get(0) instanceof OLAPHierarchy || this.olapList.get(0) instanceof OLAPLevel)) {
            for (int i = this.olapList.size() - 1; i >= 0; --i) {
                AbstractOLAPModel object = (AbstractOLAPModel)this.olapList.get(i);
                if (object instanceof OLAPLevel && !object.deleted) {
                    this.removeOLAPLevel((OLAPLevel)object);
                    continue;
                }
                if (!(object instanceof OLAPHierarchy) || object.deleted) continue;
                this.removeOLAPHierarchy((OLAPHierarchy)object);
            }
        }
        this.olapList.clear();
    }

    @Override
    public synchronized boolean contains(Object obj) {
        return this.olapList.contains(obj);
    }

    @Override
    public synchronized boolean containsAll(Collection c) {
        return this.olapList.containsAll(c);
    }

    @Override
    public synchronized boolean equals(Object inputObject) {
        boolean ret = true;
        if (!(inputObject instanceof OLAPList)) {
            ret = false;
        } else {
            OLAPList inputList = (OLAPList)inputObject;
            ret = this.olapList.equals(inputList.olapList);
        }
        return ret;
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    public synchronized int indexOf(Object elem) {
        return this.olapList.indexOf(elem);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.olapList.isEmpty();
    }

    @Override
    public synchronized Iterator iterator() {
        return this.olapList.iterator();
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        return this.olapList.lastIndexOf(object);
    }

    @Override
    public ListIterator listIterator() {
        return this.olapList.listIterator();
    }

    @Override
    public ListIterator listIterator(int location) {
        return this.olapList.listIterator(location);
    }

    @Override
    public synchronized Object remove(int location) {
        if (!this.modifiable) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The list is not modifiable.");
            }
            throw new IllegalStateException("An illegal use of the remove method was encountered.");
        }
        Object olapObject = this.get(location);
        Object removed = this.olapList.remove(location);
        if (olapObject instanceof OLAPMeasure) {
            this.removeOLAPMeasure((OLAPMeasure)olapObject);
        } else if (olapObject instanceof OLAPLevel) {
            OLAPDimension dimension;
            Class<?> className = this.getParentObject().getClass();
            String thisString = className.toString();
            if (thisString.indexOf("OLAPSharedDimension") > 0 && !(dimension = ((OLAPLevel)olapObject).getDimension()).isOnlyShared()) {
                this.remove = false;
            }
            this.removeOLAPLevel((OLAPLevel)olapObject);
        } else if (olapObject instanceof OLAPHierarchy) {
            this.removeOLAPHierarchy((OLAPHierarchy)olapObject);
        } else if (olapObject instanceof OLAPSharedDimension) {
            this.removeOLAPDimension((OLAPSharedDimension)olapObject);
        } else if (olapObject instanceof OLAPDimension) {
            this.removeOLAPDimension((OLAPDimension)olapObject);
        } else if (olapObject instanceof OLAPMemberProperty) {
            this.removeOLAPMemberProperty((OLAPMemberProperty)olapObject);
        } else if (olapObject instanceof OLAPDefinedMember) {
            this.removeOLAPDefinedMember((OLAPDefinedMember)olapObject);
        }
        return removed;
    }

    private void removeOLAPDefinedMember(OLAPDefinedMember member) {
        DefinedMemberSet memberSet = member.getOwningSet();
        try {
            List deleteList;
            OLAPList calculatedMeasures = memberSet.getCalculatedMeasures();
            calculatedMeasures.getTheList().remove(member);
            OLAPList calculatedMembers = memberSet.getCalculatedMembers();
            calculatedMembers.getTheList().remove(member);
            OLAPList namedSets = memberSet.getNamedSets();
            namedSets.getTheList().remove(member);
            if (member.metadataObject != null && !(deleteList = memberSet.getDeleteList()).contains(member.metadataObject)) {
                deleteList.add(member.metadataObject);
            }
        }
        catch (OLAPException error) {
            throw new IllegalStateException("The application encountered an error removing a defined member from the list.");
        }
    }

    private void removeOLAPMeasure(OLAPMeasure measure) {
        try {
            List deleteList;
            OLAPCube owningCube = measure.getOwningCube();
            MeasureSet measureSet = owningCube.getMeasureSet();
            if (!measure.isNunique().booleanValue()) {
                OLAPColumn olapColumn;
                TableSet tableSet = owningCube.getTableSet();
                if (tableSet.isLoadClassicSAS()) {
                    LoadTable loadTable = tableSet.getLoadTable();
                    OLAPList availableNumericColumns = loadTable.getAvailableNumericColumns();
                    OLAPColumn column = measure.getInputColumn();
                    if (column != null) {
                        availableNumericColumns.getTheList().add(column);
                        availableNumericColumns.sort();
                    }
                }
                if ((olapColumn = measure.getInputColumn()) != null) {
                    OLAPList measuresByColumn = measureSet.getMeasuresByColumn(olapColumn);
                    measuresByColumn.getTheList().remove(measure);
                }
                OLAPList groupNames = measureSet.getGroupNames();
                String groupName = measure.getGroupName();
                measureSet.getStoredMeasures().getTheList().remove(measure);
                measureSet.getDerivedMeasures().getTheList().remove(measure);
                if (!ModelUtilities.isBlank(groupName)) {
                    OLAPList stored = measureSet.getStoredMeasuresByGroupName(groupName);
                    stored.getTheList().remove(measure);
                    OLAPList derived = measureSet.getDerivedMeasuresByGroupName(groupName);
                    derived.getTheList().remove(measure);
                    if (stored.isEmpty() & derived.isEmpty()) {
                        groupNames.remove(groupName);
                    }
                }
                measureSet.synchRolap();
            } else {
                measureSet.getNUniqueMeasures().getTheList().remove(measure);
                measureSet.getDerivedMeasures().getTheList().remove(measure);
            }
            if (measure.metadataObject != null && (deleteList = measureSet.getDeleteList()).indexOf(measure.metadataObject) < 0) {
                deleteList.add(measure.metadataObject);
            }
            measure = null;
        }
        catch (OLAPException error) {
            throw new IllegalStateException("The application encountered an error removing a measure from the list.");
        }
    }

    private boolean removeOLAPAggregation(OLAPAggregation aggregation) {
        boolean remove = true;
        try {
            OLAPCube owningCube = aggregation.getOwningCube();
            AggregationSet aggregationSet = owningCube.getAggregationSet();
            boolean dropList = aggregationSet.isDropAggregationList(this);
            AggregationTable table = aggregation.getAggregationTable();
            if (aggregation.isNway()) {
                aggregationSet.setNwayGenerated(false);
            } else if (!dropList) {
                if (aggregationSet.isAggregationTuning()) {
                    OLAPList addedAggregations = aggregationSet.getAddedAggregations();
                    addedAggregations.getTheList().remove(aggregation);
                }
                aggregationSet.getStoredAggregations().getTheList().remove(aggregation);
                aggregationSet.getGeneratedAggregations().getTheList().remove(aggregation);
                aggregationSet.getPerformanceAggregations().getTheList().remove(aggregation);
                if (table != null) {
                    aggregationSet.getAggregationsByTable(table).getTheList().remove(aggregation);
                }
                if (aggregationSet.isAggregationTuning() && !aggregation.isNewObject()) {
                    OLAPList droppedList = aggregationSet.getDroppedAggregations();
                    droppedList.getTheList().add(aggregation);
                }
                aggregation.setDeleted(true);
            } else {
                List aggregations = aggregationSet.getAggregations().getTheList();
                aggregations.add(aggregation);
                this.addOLAPAggregationStored(aggregation, aggregationSet, table, false);
                this.addOLAPAggregationGenerated(aggregation, aggregationSet, table, false);
                this.addOLAPAggregationPerformance(aggregation, aggregationSet, false);
                if (aggregation.isAggregationTuningChanges() && aggregationSet.isAggregationTuning() && !aggregation.isNewObject()) {
                    aggregation.addTuningLists();
                }
            }
        }
        catch (OLAPException error) {
            throw new IllegalStateException("The application encountered an error removing an aggregation from the list.");
        }
        return remove;
    }

    private boolean removeOLAPDimension(OLAPDimension dimension) {
        try {
            DimensionSet dimensionSet = dimension.getDimensionSet();
            if (dimension.metadataObject != null) {
                dimensionSet.getDimensionDeleteList().add(dimension);
            }
            OLAPList levels = dimension.getLevels();
            dimensionSet.getCubeDimensions().getTheList().remove(dimension);
            for (int i = levels.size() - 1; i > -1; --i) {
                OLAPLevel level = (OLAPLevel)levels.get(i);
                dimension.getLevels().remove(level);
            }
            dimension.setDeleted(true);
            dimensionSet.setDimensionChanged(true);
        }
        catch (OLAPException error) {
            throw new IllegalStateException("The application encountered an error removing a dimension from the list.");
        }
        return true;
    }

    private boolean removeOLAPDimension(OLAPSharedDimension dimension) {
        try {
            DimensionSet dimensionSet = dimension.getDimensionSet();
            if (dimension.metadataObject != null) {
                dimensionSet.getSharedDimensionDeleteList().add(dimension);
            }
            OLAPList levels = dimension.getLevels();
            for (int i = levels.size() - 1; i > -1; --i) {
                OLAPLevel level = (OLAPLevel)levels.get(i);
                dimension.getLevels().remove(level);
            }
            dimension.setDeleted(true);
            dimensionSet.setDimensionChanged(true);
        }
        catch (OLAPException error) {
            throw new IllegalStateException("The application encountered an error removing a dimension from the list.");
        }
        return true;
    }

    private boolean removeOLAPHierarchy(OLAPHierarchy hierarchy) {
        try {
            if (this.parentObject != null) {
                Class<?> className = this.getParentObject().getClass();
                String thisString = className.toString();
                int location = -1;
                if (thisString.indexOf("OLAPMemberProperty") > 0) {
                    OLAPMemberProperty property = (OLAPMemberProperty)this.getParentObject();
                    hierarchy.getOLAPProperties().getTheList().remove(property);
                    if (hierarchy.isUndo()) {
                        hierarchy.setUpListChanges("add", property, hierarchy.getOLAPProperties(), location);
                    }
                    if (property.isUndo()) {
                        property.setUpListChanges("add", hierarchy, property.getHierarchies(), -1);
                    }
                } else if (thisString.indexOf("OLAPDimension") > 0) {
                    DimensionSet dimensionSet = hierarchy.getDimensionSet();
                    dimensionSet.setDimensionChanged(true);
                    MeasureSet measureSet = hierarchy.getOwningCube().getMeasureSet();
                    if (hierarchy.metadataObject != null) {
                        dimensionSet.getHierarchyDeleteList().add(hierarchy);
                    }
                    dimensionSet.getHierarchies().getTheList().remove(hierarchy);
                    OLAPDimension dimension = hierarchy.getDimension();
                    OLAPList listOfHiers = dimension.getHierarchies();
                    location = listOfHiers.indexOf(hierarchy);
                    if (dimension.isUndo()) {
                        dimension.setUpListChanges("add", hierarchy, this, location);
                    }
                    listOfHiers.getTheList().remove(hierarchy);
                    OLAPList memberProperties = hierarchy.getOLAPProperties();
                    for (int t = memberProperties.size() - 1; t > -1; --t) {
                        OLAPMemberProperty member = (OLAPMemberProperty)memberProperties.get(t);
                        member.getHierarchies().getTheList().remove(hierarchy);
                        if (!member.isUndo()) continue;
                        member.setUpListChanges("add", hierarchy, member.getHierarchies(), -1);
                    }
                    OLAPList levels = hierarchy.getLevels();
                    for (int t = levels.size() - 1; t > -1; --t) {
                        OLAPLevel level = (OLAPLevel)levels.get(t);
                        List listOfLevels = levels.getTheList();
                        location = listOfLevels.indexOf(level);
                        if (hierarchy.isUndo()) {
                            hierarchy.setUpListChanges("add", level, levels, location);
                        }
                        levels.getTheList().remove(level);
                        level.getHierarchies().getTheList().remove(hierarchy);
                    }
                    hierarchy.setDeleted(true);
                } else if (thisString.indexOf("OLAPSharedDimension") > 0) {
                    DimensionSet dimensionSet = hierarchy.getDimensionSet();
                    dimensionSet.setDimensionChanged(true);
                    if (hierarchy.metadataObject != null) {
                        dimensionSet.getHierarchyDeleteList().add(hierarchy);
                    }
                    dimensionSet.getHierarchies().getTheList().remove(hierarchy);
                    OLAPDimension dimension = hierarchy.getDimension();
                    OLAPList listOfHiers = dimension.getHierarchies();
                    location = listOfHiers.indexOf(hierarchy);
                    dimension.setUpListChanges("add", hierarchy, this, location);
                    listOfHiers.getTheList().remove(hierarchy);
                    OLAPList memberProperties = hierarchy.getOLAPProperties();
                    for (int t = memberProperties.size() - 1; t > -1; --t) {
                        OLAPMemberProperty member = (OLAPMemberProperty)memberProperties.get(t);
                        member.getHierarchies().getTheList().remove(hierarchy);
                        member.setUpListChanges("add", hierarchy, member.getHierarchies(), -1);
                    }
                    OLAPList levels = hierarchy.getLevels();
                    for (int t = levels.size() - 1; t > -1; --t) {
                        OLAPLevel level = (OLAPLevel)levels.get(t);
                        List listOfLevels = levels.getTheList();
                        location = listOfLevels.indexOf(level);
                        hierarchy.setUpListChanges("add", level, levels, location);
                        levels.getTheList().remove(level);
                        level.getHierarchies().getTheList().remove(hierarchy);
                    }
                    hierarchy.setDeleted(true);
                } else if (thisString.indexOf("OLAPLevel") > 0) {
                    OLAPLevel level = (OLAPLevel)this.parentObject;
                    DimensionSet dimensionSet = hierarchy.getDimensionSet();
                    if (level.isUndo()) {
                        level.setUpListChanges("add", hierarchy, this, -1);
                    }
                    dimensionSet.setDimensionChanged(true);
                }
            }
        }
        catch (OLAPException error) {
            throw new IllegalStateException("The application encountered an error removing a hierarchy from the list.");
        }
        return true;
    }

    private boolean removeOLAPLevel(OLAPLevel level) {
        block32: {
            try {
                OLAPMemberProperty property;
                int j;
                OLAPList listOfHierarchies;
                OLAPList dimensionHierarchies;
                List listOfLevels;
                Iterator i;
                OLAPList listOfLevelsLoc;
                OLAPDimension dimension;
                Map levels;
                DimensionSet dimensionSet;
                if (this.parentObject == null) break block32;
                Class<?> className = this.getParentObject().getClass();
                String thisString = className.toString();
                int location = -1;
                if (thisString.indexOf("OLAPHierarchy") > 0) {
                    level.getHierarchies().getTheList().remove(this.parentObject);
                    OLAPHierarchy hierarchy = (OLAPHierarchy)this.parentObject;
                    OLAPList listOfLevels2 = hierarchy.getLevels();
                    location = listOfLevels2.indexOf(level);
                    if (hierarchy.isUndo()) {
                        hierarchy.setUpListChanges("add", level, this, location);
                    }
                    OLAPDimension dimension2 = level.getDimension();
                    Object aggregationSet = null;
                    OLAPCube cube = level.getOwningCube();
                    if (cube != null) {
                        level.getOwningCube().getAggregationSet().setResetLevels(true);
                    }
                    level.getDimensionSet().setDimensionChanged(true);
                    OLAPList olapProperties = level.getOLAPProperties();
                    OLAPMemberPropertySet propertySet = level.propertySet;
                    for (int j2 = olapProperties.size() - 1; j2 >= 0; --j2) {
                        OLAPMemberProperty property2 = (OLAPMemberProperty)olapProperties.get(j2);
                        OLAPList listOfhierarchies = property2.getHierarchies();
                        if (listOfhierarchies.contains(hierarchy)) {
                            int locationHierarchy = listOfhierarchies.indexOf(hierarchy);
                            listOfhierarchies.remove(hierarchy);
                            if (level.isUndo()) {
                                level.setUpListChanges("add", hierarchy, listOfhierarchies, locationHierarchy);
                            }
                        }
                        if (listOfhierarchies.size() != 0) continue;
                        olapProperties.getTheList().remove(property2);
                        property2.delete();
                        if (!level.isUndo()) continue;
                        level.setUpListChanges("add", property2, propertySet.getOLAPProperties(), -1);
                        level.setUpListChanges("add", property2, olapProperties, -1);
                    }
                }
                if (thisString.indexOf("OLAPDimension") > 0) {
                    dimensionSet = level.getDimensionSet();
                    levels = dimensionSet.getLevels();
                    boolean found = false;
                    dimension = level.getDimension();
                    listOfLevelsLoc = dimension.getLevels();
                    location = listOfLevelsLoc.indexOf(level);
                    if (dimension.isUndo()) {
                        dimension.setUpListChanges("add", level, this, location);
                    }
                    dimensionSet.levelNames.remove(level.getName());
                    i = levels.values().iterator();
                    while (i.hasNext() & !found) {
                        listOfLevels = (List)i.next();
                        if (!listOfLevels.contains(level)) continue;
                        found = true;
                        OLAPColumn tempOlapColumn = level.getColumn();
                        if (tempOlapColumn != null) {
                            listOfLevels.remove(level);
                            if (listOfLevels.isEmpty()) {
                                levels.remove(tempOlapColumn);
                            }
                        } else {
                            levels.remove(level.getName());
                        }
                        dimensionHierarchies = dimension.getHierarchies();
                        for (int j3 = dimensionHierarchies.size() - 1; j3 >= 0; --j3) {
                            OLAPHierarchy hierarchy = (OLAPHierarchy)dimensionHierarchies.get(j3);
                            OLAPList hierarchyLevels = hierarchy.getLevels();
                            if (!hierarchyLevels.contains(level)) continue;
                            hierarchyLevels.remove(level);
                            if (hierarchyLevels.size() != 0) continue;
                            if (hierarchy.metadataObject != null) {
                                dimensionSet.getHierarchyDeleteList().add(hierarchy);
                            }
                            dimensionSet.getHierarchies().getTheList().remove(hierarchy);
                            listOfHierarchies = dimension.getHierarchies();
                            location = listOfHierarchies.indexOf(hierarchy);
                            if (dimension.isUndo()) {
                                dimension.setUpListChanges("add", hierarchy, listOfHierarchies, location);
                            }
                            listOfHierarchies.getTheList().remove(hierarchy);
                            hierarchy.setDeleted(true);
                        }
                        OLAPList olapProperties = level.getOLAPProperties();
                        OLAPMemberPropertySet propertySet = level.propertySet;
                        for (j = olapProperties.size() - 1; j >= 0; --j) {
                            property = (OLAPMemberProperty)olapProperties.get(j);
                            if (level.isUndo()) {
                                level.setUpListChanges("add", property, propertySet.getOLAPProperties(), -1);
                            }
                            olapProperties.getTheList().remove(property);
                            if (level.isUndo()) {
                                level.setUpListChanges("add", property, olapProperties, -1);
                            }
                            property.delete();
                        }
                    }
                    level.getOwningCube().getAggregationSet().setResetLevels(true);
                    level.setDeleted(true);
                    if (level.metadataObject != null) {
                        dimensionSet.getLevelDeleteList().add(level);
                        dimensionSet.metaLevelLevel.remove(level.metadataObject);
                    }
                    dimensionSet.setDimensionChanged(true);
                }
                if (thisString.indexOf("OLAPSharedDimension") > 0) {
                    dimensionSet = level.getDimensionSet();
                    levels = dimensionSet.getLevels();
                    boolean found = false;
                    dimension = level.getDimension();
                    listOfLevelsLoc = dimension.getLevels();
                    location = listOfLevelsLoc.indexOf(level);
                    dimension.setUpListChanges("add", level, this, location);
                    dimensionSet.levelNames.remove(level.getName());
                    i = levels.values().iterator();
                    while (i.hasNext() & !found) {
                        OLAPHierarchy hierarchy;
                        listOfLevels = (List)i.next();
                        if (!listOfLevels.contains(level)) continue;
                        found = true;
                        OLAPColumn tempOlapColumn = level.getColumn();
                        if (tempOlapColumn != null) {
                            listOfLevels.remove(level);
                            if (listOfLevels.isEmpty()) {
                                levels.remove(tempOlapColumn);
                            }
                        } else {
                            levels.remove(level.getName());
                        }
                        if (dimension.isOnlyShared()) {
                            dimensionHierarchies = dimension.getHierarchies();
                            for (int j4 = dimensionHierarchies.size() - 1; j4 >= 0; --j4) {
                                hierarchy = (OLAPHierarchy)dimensionHierarchies.get(j4);
                                OLAPList hierarchyLevels = hierarchy.getLevels();
                                if (!hierarchyLevels.contains(level)) continue;
                                hierarchyLevels.remove(level);
                                if (hierarchyLevels.size() != 0) continue;
                                dimensionSet.getHierarchies().getTheList().remove(hierarchy);
                                listOfHierarchies = dimension.getHierarchies();
                                location = listOfHierarchies.indexOf(hierarchy);
                                dimension.setUpListChanges("add", hierarchy, listOfHierarchies, location);
                                listOfHierarchies.getTheList().remove(hierarchy);
                                if (hierarchy.metadataObject == null) continue;
                                dimensionSet.getHierarchyDeleteList().add(hierarchy);
                            }
                            OLAPList olapProperties = level.getOLAPProperties();
                            OLAPMemberPropertySet propertySet = level.propertySet;
                            for (j = olapProperties.size() - 1; j >= 0; --j) {
                                property = (OLAPMemberProperty)olapProperties.get(j);
                                level.setUpListChanges("add", property, propertySet.getOLAPProperties(), -1);
                                olapProperties.getTheList().remove(property);
                                level.setUpListChanges("add", property, olapProperties, -1);
                            }
                            level.setDeleted(true);
                            if (level.metadataObject == null) continue;
                            dimensionSet.metaLevelLevel.remove(level.metadataObject);
                            dimensionSet.getLevelDeleteList().add(level);
                            continue;
                        }
                        dimensionHierarchies = dimension.getHierarchies();
                        for (int j5 = dimensionHierarchies.size() - 1; j5 >= 0; --j5) {
                            hierarchy = (OLAPHierarchy)dimensionHierarchies.get(j5);
                            dimensionSet.getHierarchies().getTheList().remove(hierarchy);
                        }
                        if (level.metadataObject == null) continue;
                        dimensionSet.metaLevelLevel.remove(level.metadataObject);
                    }
                    dimensionSet.setDimensionChanged(true);
                    break block32;
                }
                if (thisString.indexOf("OLAPAggregation") <= 0) break block32;
                this.olapList.remove(level);
                OLAPAggregation aggregation = (OLAPAggregation)this.parentObject;
                try {
                    aggregation.resetHierarchyLevels();
                }
                catch (OLAPException error) {
                    throw new IllegalStateException("The application encountered an error removing a level from the list.");
                }
            }
            catch (OLAPException error) {
                throw new IllegalStateException("The application encountered an error removing a level from the list.");
            }
        }
        return true;
    }

    private boolean removeOLAPMemberProperty(OLAPMemberProperty property) {
        try {
            OLAPMemberPropertySet propertySet = property.getOLAPMemberPropertySet();
            OLAPList hierarchies = property.getHierarchies();
            for (int t = hierarchies.size() - 1; t > -1; --t) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(t);
                hierarchies.remove(hierarchy);
                if (hierarchy.isUndo()) {
                    hierarchy.setUpListChanges("add", hierarchy, hierarchies, -1);
                }
                OLAPList listOfProperties = hierarchy.getOLAPProperties();
                listOfProperties.getTheList().remove(property);
            }
            OLAPLevel associatedLevel = property.getAssociatedLevel();
            if (associatedLevel != null) {
                OLAPList list = associatedLevel.getOLAPProperties();
                List list2 = list.getTheList();
                list2.remove(property);
                if (associatedLevel.isUndo()) {
                    associatedLevel.setUpListChanges("add", property, associatedLevel.getOLAPProperties(), -1);
                }
            }
            property.setDeleted(true);
            if (property.isUndo()) {
                property.setUpListChanges("add", property, propertySet.getOLAPProperties(), -1);
            }
            Boolean setToFalse = new Boolean(false);
            if (property.isUndo()) {
                property.setUpChanges("setDeleted", Boolean.TYPE, setToFalse);
            }
            if (property.metadataObject != null) {
                propertySet.getOLAPMemberPropertyDeleteList().add(property);
            }
        }
        catch (OLAPException error) {
            throw new IllegalStateException("The application encountered an error removing a member property from the list.");
        }
        return true;
    }

    public void reOrderLevels(List orderedLevels) {
        if (orderedLevels == null) {
            throw new UnsupportedOperationException("The list cannot be null.");
        }
        List listOfLevels = this.getTheList();
        listOfLevels.clear();
        int size = orderedLevels.size();
        for (int i = 0; i < size; ++i) {
            listOfLevels.add(orderedLevels.get(i));
        }
    }

    @Override
    public synchronized boolean remove(Object olapObject) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("The list is not modifiable.");
        }
        boolean removed = false;
        boolean remove = true;
        if (olapObject instanceof OLAPMeasure) {
            this.removeOLAPMeasure((OLAPMeasure)olapObject);
        } else if (olapObject instanceof OLAPAggregation) {
            remove = this.removeOLAPAggregation((OLAPAggregation)olapObject);
        } else if (olapObject instanceof OLAPLevel) {
            OLAPDimension dimension;
            Class<?> className = this.getParentObject().getClass();
            String thisString = className.toString();
            if (thisString.indexOf("OLAPSharedDimension") > 0 && !(dimension = ((OLAPLevel)olapObject).getDimension()).isOnlyShared()) {
                remove = false;
            }
            this.removeOLAPLevel((OLAPLevel)olapObject);
        } else if (olapObject instanceof OLAPHierarchy) {
            this.removeOLAPHierarchy((OLAPHierarchy)olapObject);
        } else if (olapObject instanceof OLAPSharedDimension) {
            this.removeOLAPDimension((OLAPSharedDimension)olapObject);
        } else if (olapObject instanceof OLAPDimension) {
            this.removeOLAPDimension((OLAPDimension)olapObject);
        } else if (olapObject instanceof OLAPMemberProperty) {
            this.removeOLAPMemberProperty((OLAPMemberProperty)olapObject);
        } else if (olapObject instanceof OLAPDefinedMember) {
            this.removeOLAPDefinedMember((OLAPDefinedMember)olapObject);
        }
        removed = remove ? this.olapList.remove(olapObject) : true;
        return removed;
    }

    @Override
    public synchronized boolean removeAll(Collection c) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("The list is not modifiable.");
        }
        for (Object olapObject : c) {
            if (olapObject instanceof OLAPMeasure) {
                this.removeOLAPMeasure((OLAPMeasure)olapObject);
            } else if (olapObject instanceof OLAPLevel) {
                OLAPDimension dimension;
                Class<?> className = this.getParentObject().getClass();
                String thisString = className.toString();
                if (thisString.indexOf("OLAPSharedDimension") > 0 && !(dimension = ((OLAPLevel)olapObject).getDimension()).isOnlyShared()) {
                    this.remove = false;
                }
                this.removeOLAPLevel((OLAPLevel)olapObject);
            } else if (olapObject instanceof OLAPHierarchy) {
                this.removeOLAPHierarchy((OLAPHierarchy)olapObject);
            } else if (olapObject instanceof OLAPSharedDimension) {
                this.removeOLAPDimension((OLAPSharedDimension)olapObject);
            } else if (olapObject instanceof OLAPDimension) {
                this.removeOLAPDimension((OLAPDimension)olapObject);
            } else if (olapObject instanceof OLAPMemberProperty) {
                this.removeOLAPMemberProperty((OLAPMemberProperty)olapObject);
            } else if (olapObject instanceof OLAPDefinedMember) {
                this.removeOLAPDefinedMember((OLAPDefinedMember)olapObject);
            }
            this.remove(olapObject);
        }
        return true;
    }

    @Override
    public synchronized Object set(int location, Object object) {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("The list is not modifiable.");
        }
        return this.olapList.set(location, object);
    }

    public void setParentObject(Object inputParentObject) {
        if (inputParentObject instanceof AbstractOLAPModel) {
            AbstractOLAPModel olapModel = (AbstractOLAPModel)inputParentObject;
            olapModel.verifyDeleted();
        }
        this.parentObject = inputParentObject;
    }

    void setTheList(List inputList) {
        this.olapList = inputList;
    }

    @Override
    public synchronized List subList(int fromIndex, int toIndex) {
        return this.olapList.subList(fromIndex, toIndex);
    }

    public void setAllowUndoSetup(boolean input) {
        this.allowUndoSetup = input;
    }

    void setModifiable(boolean inputModifiable) {
        this.modifiable = inputModifiable;
    }

    @Override
    public synchronized Object[] toArray() {
        return this.olapList.toArray();
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        if (a.length < this.olapList.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.olapList.size());
        }
        int index = 0;
        Iterator it = this.olapList.iterator();
        while (it.hasNext()) {
            a[index] = it.next();
            ++index;
        }
        if (a.length > this.olapList.size()) {
            a[this.olapList.size()] = null;
        }
        return a;
    }

    public void sort() {
        int i;
        ArrayList<ComparableObject> sortList = new ArrayList<ComparableObject>();
        int size = this.size();
        for (i = 0; i < size; ++i) {
            sortList.add(new ComparableObject(this.get(i)));
        }
        Collections.sort(sortList);
        this.getTheList().clear();
        size = sortList.size();
        for (i = 0; i < size; ++i) {
            ComparableObject sortedObject = (ComparableObject)sortList.get(i);
            this.getTheList().add(sortedObject.getObject());
        }
    }

    @Override
    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        Object[] objects = this.olapList.toArray();
        buf.append("[");
        int maxIndex = this.olapList.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            buf.append(String.valueOf(objects[i]));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    private class ComparableObject
    implements Comparable {
        Object compareObject;

        ComparableObject(Object inputCompareObject) {
            this.compareObject = inputCompareObject;
        }

        Object getObject() {
            return this.compareObject;
        }

        public int compareTo(Object obj) {
            int compnum = this.toString().compareToIgnoreCase(obj.toString());
            return compnum;
        }

        public String toString() {
            return this.compareObject.toString();
        }
    }
}

