/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPProperty;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SharedDimension;
import com.sas.metadata.remote.TableCollection;
import com.sas.olapadmin.designer.model.AbstractInputTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.DimensionTable;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OLAPLevel
extends AbstractOLAPModel {
    static WAdminResource bundle = new WAdminResource(OLAPLevel.class);
    private OLAPColumn column;
    private int cardinality;
    private OLAPDimension dimension;
    private String sortOrder;
    private String format;
    private int type;
    private Option ignoreEmpty;
    private Option empty;
    private boolean deleteEmpty;
    private boolean deleteIgnoreEmpty;
    private OLAPList hierarchies;
    private OLAPList olapProperties;
    private OLAPColumn mapLayer;
    private Property mapFieldId;
    private OLAPColumn mapOLAPPropertyField;
    private OLAPList includeCalculatedMembers;
    private static final String LEVEL = "      LEVEL ";
    private static final String ESRI_MAP_LAYER = "         ESRI_MAP_LAYER =  '";
    private static final String COLUMN = "         COLUMN         =  ";
    private static final String FORMAT = "         FORMAT         =  ";
    private static final String TYPE = "         TYPE           =  ";
    private static final String CAPTION = "         CAPTION        =  '";
    private static final String LEVEL_MLSID = "         MLSID          =  ";
    private static final String DESC = "         DESC           =  '";
    private static final String SORT_ORDER = "         SORT_ORDER     =  ";
    private static final String EMPTY = "         EMPTY          = '";
    private static final String IGNORE_EMPTY = "         IGNORE_EMPTY";
    static final String YEAR = "YEAR";
    static final String HALF_YEARS = "HALF_YEARS";
    static final String QUARTERS = "QUARTERS";
    static final String MONTHS = "MONTHS";
    static final String WEEKS = "WEEKS";
    static final String DAYS = "DAYS";
    static final String HOURS = "HOURS";
    static final String MINUTES = "MINUTES";
    static final String SECONDS = "SECONDS";

    OLAPLevel(Level inputMetadataObject) {
        this.metadataObject = inputMetadataObject;
        this.currentChanges = new HashMap();
    }

    OLAPLevel(OLAPColumn inputColumn) {
        this.column = inputColumn;
    }

    public void createMapOLAPMemberProperty() throws OLAPException {
        OLAPMemberProperty olapprop = this.getMapOLAPProperty();
        if (this.getOwningCube() != null) {
            this.propertySet = this.getOwningCube().getOLAPMemberPropertySet();
        } else if (this.getOwningSharedDimension() != null) {
            this.propertySet = this.getOwningSharedDimension().getOLAPMemberPropertySet();
        }
        if (olapprop == null) {
            olapprop = this.propertySet.createOLAPMemberProperty();
        }
        this.getHierarchies();
        olapprop.setAssociatedLevel(this);
        olapprop.setColumn(this.getMapOLAPPropertyField());
        OLAPList listOfHierarchies = olapprop.getHierarchies();
        listOfHierarchies.clear();
        int size = this.hierarchies.size();
        for (int i = 0; i < size; ++i) {
            listOfHierarchies.add(this.hierarchies.get(i));
        }
        olapprop.setName("SAS_SPATIAL_ID");
        try {
            Property fieldId = this.getMapFieldId();
            if (fieldId != null) {
                String fieldName = fieldId.getName();
                olapprop.setDesc(fieldName);
                Option olapPropId = this.optionSet.getOption(olapprop, fieldName, "ESRI Map Field");
                if (olapPropId == null) {
                    olapPropId = new Option(this.optionSet, olapprop);
                }
                olapPropId.setName(fieldName);
                olapPropId.setDesc(fieldId.getDesc());
                olapPropId.setPropertyName(fieldId.getPropertyName());
                olapPropId.setPropertyRole("ESRI Map Field");
                olapPropId.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    public void delete() throws OLAPException {
        this.getDimension();
        OLAPList listOfLevels = null;
        listOfLevels = this.dimension.getLevels();
        listOfLevels.remove(this);
    }

    public void deleteMapInformation() throws OLAPException {
        if (this.metadataObject != null) {
            OLAPMemberProperty olapProperty;
            FeatureMap featureMap = this.getMapFeatureMap();
            MdObjectStore objectStore = null;
            if (!this.dimension.isShared()) {
                objectStore = this.owningCube.getObjectStore();
            } else if (this.owningSharedDimension != null) {
                objectStore = this.owningSharedDimension.getObjectStore();
            }
            if (featureMap != null) {
                MetadataTemplate.deleteMetadata(objectStore, (CMetadata)featureMap, "", bundle.getString("MdException.GenericError.txt"));
            }
            if ((olapProperty = this.getMapOLAPProperty()) != null) {
                olapProperty.delete();
            }
        }
        this.setMapFieldId(null);
        this.setMapLayer(null);
        this.setMapOLAPPropertyField(null);
    }

    StringBuffer generateCode() throws OLAPException {
        Integer number;
        StringBuffer levelStatement = new StringBuffer();
        levelStatement.append(ModelUtilities.newline).append(ModelUtilities.newline).append(LEVEL).append(ModelUtilities.getSasName(this.getName()));
        String levelName = this.getName();
        String levelColumnName = this.getColumn().getSASColumnName();
        String format = this.getFormat();
        OLAPColumn column = this.getMapLayer();
        String mapName = null;
        if (column != null) {
            mapName = column.getSASColumnName();
        }
        String typeValue = null;
        String caption = ModelUtilities.internalQuote(ModelUtilities.trim(this.getDesc()));
        String desc = ModelUtilities.internalQuote(ModelUtilities.trim(this.getNotes()));
        this.getSortOrder();
        String emptyValue = ModelUtilities.internalQuote(this.getEmpty());
        String emptyIgnore = this.getIgnoreEmpty();
        int levelType = this.getType();
        switch (levelType) {
            case 16: {
                typeValue = YEAR;
                break;
            }
            case 32: {
                typeValue = HALF_YEARS;
                break;
            }
            case 64: {
                typeValue = QUARTERS;
                break;
            }
            case 128: {
                typeValue = MONTHS;
                break;
            }
            case 256: {
                typeValue = WEEKS;
                break;
            }
            case 512: {
                typeValue = DAYS;
                break;
            }
            case 1024: {
                typeValue = HOURS;
                break;
            }
            case 2048: {
                typeValue = MINUTES;
                break;
            }
            case 4096: {
                typeValue = SECONDS;
            }
        }
        if (!levelName.equalsIgnoreCase(levelColumnName)) {
            levelStatement.append(ModelUtilities.newline).append(COLUMN).append(ModelUtilities.getSasName(levelColumnName));
        }
        if (!ModelUtilities.isBlank(format)) {
            levelStatement.append(ModelUtilities.newline).append(FORMAT).append(format);
        }
        if (typeValue != null) {
            levelStatement.append(ModelUtilities.newline).append(TYPE).append(typeValue);
        }
        if (!ModelUtilities.isBlank(caption)) {
            levelStatement.append(ModelUtilities.newline).append(CAPTION).append(caption).append("'");
        }
        if (!ModelUtilities.isBlank(desc)) {
            levelStatement.append(ModelUtilities.newline).append(DESC).append(desc).append("'");
        }
        levelStatement.append(ModelUtilities.newline).append(SORT_ORDER).append(this.sortOrder);
        if (mapName != null) {
            levelStatement.append(ModelUtilities.newline).append(ESRI_MAP_LAYER).append(mapName).append("'");
        }
        if (emptyValue != null && emptyValue.length() > 0) {
            levelStatement.append(ModelUtilities.newline).append(EMPTY).append(emptyValue).append("'");
        } else if (emptyValue != null) {
            levelStatement.append(ModelUtilities.newline).append(EMPTY).append(" '");
        }
        if (!ModelUtilities.isBlank(emptyIgnore) && emptyIgnore.equals("1")) {
            levelStatement.append(ModelUtilities.newline).append(IGNORE_EMPTY);
        }
        if ((number = this.getMLSID()) != null) {
            levelStatement.append(ModelUtilities.newline).append(LEVEL_MLSID).append(number.toString());
        }
        levelStatement.append(";");
        return levelStatement;
    }

    public int getCardinality() throws OLAPException {
        try {
            if (this.cardinality == 0 & this.metadataObject != null) {
                Level levelObject = (Level)this.metadataObject;
                this.cardinality = levelObject.getCardinality();
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return this.cardinality;
    }

    private List getFeatureMaps(Level levelObject) throws MdException, RemoteException {
        int i;
        ArrayList<Object> featureMaps = new ArrayList<Object>();
        AssociationList targetFeatureMaps = levelObject.getTargetFeatureMaps();
        AssociationList targetTransformations = levelObject.getTargetTransformations();
        for (i = targetFeatureMaps.size() - 1; i >= 0; --i) {
            featureMaps.add(targetFeatureMaps.get(i));
        }
        for (i = targetTransformations.size() - 1; i >= 0; --i) {
            featureMaps.add(targetTransformations.get(i));
        }
        return featureMaps;
    }

    public OLAPColumn getColumn() throws OLAPException {
        if (this.column == null & this.metadataObject != null) {
            Column jomaColumn = null;
            try {
                Level levelObject = (Level)this.metadataObject;
                List targetFeatureMaps = this.getFeatureMaps(levelObject);
                boolean foundFM = false;
                FeatureMap featureMap = null;
                for (int kk = 0; kk < targetFeatureMaps.size() && !foundFM; ++kk) {
                    featureMap = (FeatureMap)targetFeatureMaps.get(kk);
                    if (!featureMap.getTransformRole().equalsIgnoreCase("ONETOONE")) continue;
                    foundFM = true;
                }
                if (featureMap == null) {
                    return this.column;
                }
                AssociationList featureSources = featureMap.getFeatureSources();
                if (featureSources.isEmpty()) {
                    featureSources = featureMap.getTransformationSources();
                }
                if (!featureSources.isEmpty()) {
                    jomaColumn = (Column)featureSources.elementAt(0);
                }
                this.getDimension();
                if (!this.dimension.isShared()) {
                    DimensionTable dimTable = this.dimension.getTable();
                    if (dimTable != null) {
                        PhysicalTable physicalTable = dimTable.getTable();
                        if (jomaColumn != null && physicalTable != null) {
                            this.column = dimTable.getColumn(jomaColumn.getName());
                        }
                    }
                } else {
                    SharedDimensionTable sharedTable = ((OLAPSharedDimension)this.dimension).getSharedDimensionTable();
                    if (sharedTable != null) {
                        PhysicalTable physicalTable = sharedTable.getTable();
                        if (jomaColumn != null && physicalTable != null) {
                            this.column = sharedTable.getColumn(jomaColumn.getName());
                        }
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return this.column;
    }

    public OLAPDimension getDimension() {
        return this.dimension;
    }

    public DimensionSet getDimensionSet() {
        return this.dimensionSet;
    }

    public String getEmpty() throws OLAPException {
        String returnValue = null;
        if (this.empty == null & this.metadataObject != null & !this.deleteEmpty) {
            this.empty = this.optionSet.getOption(this, "EMPTY", "OLAPOption");
        }
        if (this.empty != null) {
            returnValue = this.empty.getDefaultValue();
        }
        return returnValue;
    }

    public String getFormat() {
        try {
            if (this.format == null & this.metadataObject != null) {
                Level levelObject = (Level)this.metadataObject;
                this.format = levelObject.getSASFormat();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.format;
    }

    public Property getMapFieldId() throws OLAPException {
        if (this.mapFieldId == null) {
            this.getMapLayer();
            if (this.mapLayer != null && this.mapLayer.metadataObject != null) {
                try {
                    Column jomaMapLayer = this.mapLayer.metadataObject;
                    OLAPMemberProperty olapMemberProperty = this.getMapOLAPProperty();
                    if (olapMemberProperty != null && olapMemberProperty.metadataObject != null) {
                        OLAPProperty olapProperty = (OLAPProperty)olapMemberProperty.metadataObject;
                        AssociationList layerProperties = jomaMapLayer.getProperties();
                        Object fieldId = null;
                        AssociationList opProps = olapProperty.getProperties();
                        for (int k = 0; k < opProps.size() && fieldId == null; ++k) {
                            Property prop = (Property)opProps.elementAt(k);
                            if (!prop.getPropertyRole().startsWith("ESRI")) continue;
                            for (int ii = 0; ii < layerProperties.size(); ++ii) {
                                Property layerProperty = (Property)layerProperties.elementAt(ii);
                                if (!layerProperty.getPropertyName().equals(prop.getPropertyName())) continue;
                                this.mapFieldId = layerProperty;
                            }
                        }
                    }
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        return this.mapFieldId;
    }

    public OLAPList getHierarchies() throws OLAPException {
        if (this.hierarchies == null) {
            this.hierarchies = new OLAPList(OLAPHierarchy.class);
            this.hierarchies.setParentObject(this);
            this.hierarchies.setModifiable(false);
            if (this.metadataObject != null) {
                this.getDimension();
                OLAPList dimensionHierarchies = null;
                dimensionHierarchies = this.dimension.getHierarchies();
                Level levelObject = (Level)this.metadataObject;
                AssociationList jomaHierarchies = null;
                try {
                    jomaHierarchies = levelObject.getHierarchies(false);
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                for (int j = jomaHierarchies.size() - 1; j >= 0; --j) {
                    Hierarchy jomaHierarchy = (Hierarchy)jomaHierarchies.elementAt(j);
                    for (int i = dimensionHierarchies.size() - 1; i >= 0; --i) {
                        OLAPHierarchy hierarchy = (OLAPHierarchy)dimensionHierarchies.get(i);
                        if (hierarchy.metadataObject == null || !hierarchy.metadataObject.equals((Object)jomaHierarchy)) continue;
                        this.hierarchies.getTheList().add(hierarchy);
                    }
                }
            }
        }
        return this.hierarchies;
    }

    public String getIgnoreEmpty() throws OLAPException {
        String returnValue = null;
        if (this.ignoreEmpty == null & this.metadataObject != null & !this.deleteIgnoreEmpty) {
            this.ignoreEmpty = this.optionSet.getOption(this, "IGNORE_EMPTY", "OLAPOption");
        }
        if (this.ignoreEmpty != null) {
            returnValue = this.ignoreEmpty.getDefaultValue();
        }
        return returnValue;
    }

    public OLAPList getIncludeCalculatedMembers() {
        if (this.includeCalculatedMembers == null) {
            this.includeCalculatedMembers = new OLAPList(OLAPHierarchy.class);
            this.includeCalculatedMembers.setParentObject(this);
        }
        return this.includeCalculatedMembers;
    }

    private FeatureMap getMapFeatureMap() throws OLAPException {
        FeatureMap featureMap = null;
        if (this.metadataObject != null) {
            try {
                Level jomaObject = (Level)this.metadataObject;
                List featureMaps = this.getFeatureMaps(jomaObject);
                for (int i = 0; i < featureMaps.size() && featureMap == null; ++i) {
                    featureMap = (FeatureMap)featureMaps.get(i);
                    if (featureMap.getTransformRole().startsWith("ESRI")) continue;
                    featureMap = null;
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return featureMap;
    }

    public OLAPColumn getMapLayer() throws OLAPException {
        if (this.mapLayer == null & this.metadataObject != null) {
            try {
                FeatureMap featureMap = this.getMapFeatureMap();
                if (featureMap != null) {
                    AssociationList sources = featureMap.getFeatureSources();
                    if (sources.isEmpty()) {
                        sources = featureMap.getTransformationSources();
                    }
                    if (!sources.isEmpty()) {
                        Column assignedLayer = (Column)sources.elementAt(0);
                        TableCollection physicalTable = (TableCollection)assignedLayer.getTable();
                        List listOfColumns = this.dimensionSet.getMapServiceColumns(physicalTable);
                        String nameColumn = assignedLayer.getColumnName();
                        if (ModelUtilities.isBlank(nameColumn)) {
                            nameColumn = assignedLayer.getName();
                        }
                        int i = 0;
                        int size = listOfColumns.size();
                        while (i < size & this.mapLayer == null) {
                            OLAPColumn nextColumn = (OLAPColumn)listOfColumns.get(i);
                            if (nameColumn.equalsIgnoreCase(nextColumn.getSASColumnName())) {
                                this.mapLayer = nextColumn;
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.mapLayer;
    }

    public OLAPMemberProperty getMapOLAPProperty() throws OLAPException {
        OLAPMemberProperty olapProperty = null;
        this.getOLAPProperties();
        for (int i = 0; i < this.olapProperties.size() && olapProperty == null; ++i) {
            olapProperty = (OLAPMemberProperty)this.olapProperties.get(i);
            if (olapProperty.getName().equalsIgnoreCase("SAS_SPATIAL_ID")) continue;
            olapProperty = null;
        }
        return olapProperty;
    }

    public OLAPColumn getMapOLAPPropertyField() throws OLAPException {
        OLAPMemberProperty memberProperty;
        if (this.mapOLAPPropertyField == null && (memberProperty = this.getMapOLAPProperty()) != null) {
            this.mapOLAPPropertyField = memberProperty.getColumn();
        }
        return this.mapOLAPPropertyField;
    }

    public OLAPList getOLAPProperties() throws OLAPException {
        if (this.olapProperties == null) {
            this.propertySet = !this.dimension.isShared() ? this.owningCube.getOLAPMemberPropertySet() : ((OLAPSharedDimension)this.dimension).getOLAPMemberPropertySet();
            this.olapProperties = (OLAPList)this.propertySet.getOLAPProperties(this);
        }
        return this.olapProperties;
    }

    public boolean isCalculatedMembersIncluded(OLAPHierarchy hierarchy) {
        boolean includeCalc = false;
        this.getIncludeCalculatedMembers();
        if (this.includeCalculatedMembers.contains(hierarchy)) {
            includeCalc = true;
        }
        return includeCalc;
    }

    public boolean needsReorganizing() throws OLAPException {
        boolean needsReorg = false;
        Option needsReorgOption = this.optionSet.getOption(this, "REORGANIZE_REQUIRED", "OLAPOption");
        if (needsReorgOption != null) {
            String returnValue = needsReorgOption.getDefaultValue();
            needsReorg = !ModelUtilities.isBlank(returnValue) && returnValue.equals("1");
        }
        return needsReorg;
    }

    public void setIgnoreEmpty(String optionValue) {
        if (optionValue != null && !optionValue.equals("0")) {
            this.deleteIgnoreEmpty = false;
            if (this.ignoreEmpty == null) {
                this.ignoreEmpty = new Option(this.optionSet, this);
                this.ignoreEmpty.setName("IGNORE_EMPTY");
                this.ignoreEmpty.setDesc("IGNORE_EMPTY");
                this.ignoreEmpty.setPropertyName("IGNORE_EMPTY");
                this.ignoreEmpty.setPropertyRole("OLAPOption");
                this.ignoreEmpty.setOwningType(OptionSet.OWNING_TYPE_BOOLEAN);
            }
            this.ignoreEmpty.setDefaultValue(optionValue);
        } else if (this.ignoreEmpty != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.ignoreEmpty) >= 0) {
                objectOptions.remove(this.ignoreEmpty);
            }
            this.ignoreEmpty = null;
            this.deleteIgnoreEmpty = true;
        }
        this.setUpChanges("setIgnoreEmpty", String.class, optionValue);
    }

    public void setEmpty(String optionValue) {
        if (optionValue != null) {
            this.deleteEmpty = false;
            if (this.empty == null) {
                this.empty = new Option(this.optionSet, this);
                this.empty.setName("EMPTY");
                this.empty.setDesc("EMPTY");
                this.empty.setPropertyName("EMPTY");
                this.empty.setPropertyRole("OLAPOption");
                this.empty.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.empty.setDefaultValue(optionValue);
        } else if (this.empty != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.empty) >= 0) {
                objectOptions.remove(this.empty);
            }
            this.empty = null;
            this.deleteEmpty = true;
        }
        this.setUpChanges("setEmpty", String.class, optionValue);
    }

    void setColumn(OLAPColumn inputColumn) {
        this.column = inputColumn;
    }

    public void setMapFieldId(Property property) {
        this.mapFieldId = property;
        this.setUpChanges("setMapFieldId", Property.class, property);
    }

    public void setMapLayer(OLAPColumn column) {
        this.mapLayer = column;
        this.setUpChanges("setMapLayer", OLAPColumn.class, column);
    }

    public void setMapOLAPPropertyField(OLAPColumn column) {
        this.mapOLAPPropertyField = column;
        this.setUpChanges("setMapOLAPProperty", OLAPColumn.class, column);
    }

    @Override
    public void setName(String inputName) {
        String oldName = this.getName();
        if (inputName != null && !inputName.equalsIgnoreCase(oldName)) {
            List listOfDimensionNames = this.dimensionSet.getLevelNames();
            listOfDimensionNames.remove(oldName);
            listOfDimensionNames.add(inputName);
        }
        super.setName(inputName);
        if (this.isUndo()) {
            this.setUpChanges("setName", String.class, inputName);
        }
    }

    @Override
    public void setNotes(String inputNotes) {
        super.setNotes(inputNotes);
        this.setUpChanges("setNotes", String.class, inputNotes);
    }

    public String getSortOrder() {
        try {
            if (ModelUtilities.isBlank(this.sortOrder) & this.metadataObject != null) {
                Level levelObject = (Level)this.metadataObject;
                this.sortOrder = levelObject.getSortOrder();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.sortOrder;
    }

    public int getType() {
        try {
            if (this.type == 0 & this.metadataObject != null) {
                Level levelObject = (Level)this.metadataObject;
                this.type = levelObject.getLevelType();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.type;
    }

    public String getUniqueName() {
        return "[" + this.dimension.getName() + "].[" + this.getName() + "]";
    }

    @Override
    public void setDesc(String inputDesc) {
        super.setDesc(inputDesc);
        this.setUpChanges("setDesc", String.class, inputDesc);
    }

    void setDimension(OLAPDimension inputDimension) {
        this.dimension = inputDimension;
    }

    public void setFormat(String inputFormat) {
        this.format = inputFormat;
        this.setUpChanges("setFormat", String.class, inputFormat);
    }

    public void setSortOrder(String inputSortOrder) {
        this.sortOrder = inputSortOrder;
        this.setUpChanges("setSortOrder", String.class, inputSortOrder);
    }

    public void setType(int inputType) {
        this.type = inputType;
        Integer convertType = new Integer(this.type);
        this.setUpChanges("setType", Integer.class, convertType);
    }

    void updateLevelMetadata() throws OLAPException {
        if (this.metadataObject == null) {
            this.metadataObject = !this.dimension.isShared() ? (Level)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Level", this.owningCube.getRepositoryShortFQID()) : (Level)MetadataTemplate.createMetadata(((OLAPSharedDimension)this.dimension).getObjectStore(), "Level", ((OLAPSharedDimension)this.dimension).getRepositoryShortFQID());
        }
        this.updateMetadata();
        Level levelObject = (Level)this.metadataObject;
        try {
            levelObject.setPublicType("Level");
            UsageVersion usageVersion = new UsageVersion(Integer.parseInt("4"), Integer.parseInt("0"), Integer.parseInt("0"));
            levelObject.setUsageVersion(usageVersion.encode());
            if (!this.dimension.isShared()) {
                levelObject.setUniqueName("[" + this.dimension.getName() + "].[" + this.getName() + "]");
            } else {
                levelObject.setUniqueName("[" + this.dimension.getName() + "].[All]");
            }
            if (this.getSortOrder() == null || ModelUtilities.isBlank(this.sortOrder)) {
                this.sortOrder = "ASCENDING";
            }
            levelObject.setSortOrder(this.sortOrder);
            int levelType = this.getType();
            if (levelType < 1) {
                this.type = this.dimension.getType().equals("STANDARD") ? 1 : 8192;
            }
            levelObject.setLevelType(this.type);
            if (this.getFormat() != null) {
                levelObject.setSASFormat(Strings.removeWhitespace((String)this.format));
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        FeatureMap featureMap = null;
        try {
            Dimension jomaDimension;
            AbstractInputTable inputTable;
            AbstractInputTable dimTable = null;
            ClassifierMap classifierMap = null;
            if (!this.dimension.isShared()) {
                inputTable = this.dimension.getTable();
                classifierMap = ((DimensionTable)inputTable).getClassifierMap();
                if (classifierMap == null) {
                    classifierMap = ((DimensionTable)inputTable).createClassifierMap();
                }
                dimTable = inputTable;
            } else {
                inputTable = ((OLAPSharedDimension)this.dimension).getSharedDimensionTable();
                classifierMap = ((SharedDimensionTable)inputTable).getClassifierMap();
                if (classifierMap == null) {
                    classifierMap = ((SharedDimensionTable)inputTable).createClassifierMap();
                }
            }
            boolean found = false;
            List targetFeatureMaps = this.getFeatureMaps(levelObject);
            int i = 0;
            int size = targetFeatureMaps.size();
            while (i < size & !found) {
                Column levelSource = null;
                featureMap = (FeatureMap)targetFeatureMaps.get(i);
                AssociationList columnList = featureMap.getFeatureSources();
                if (columnList.isEmpty()) {
                    columnList = featureMap.getTransformationSources();
                }
                if (!columnList.isEmpty()) {
                    levelSource = (Column)columnList.get(0);
                }
                if (levelSource != null && levelSource.equals((Object)this.column.metadataObject)) {
                    found = true;
                }
                ++i;
            }
            if (!found) {
                featureMap = !this.dimension.isShared() ? (FeatureMap)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "FeatureMap", this.owningCube.getRepositoryShortFQID()) : (FeatureMap)MetadataTemplate.createMetadata(((OLAPSharedDimension)this.dimension).getObjectStore(), "FeatureMap", ((OLAPSharedDimension)this.dimension).getRepositoryShortFQID());
                featureMap.setName(levelObject.getName() + "_FeatureMap");
                featureMap.setTransformRole("ONETOONE");
                featureMap.getFeatureSources().addElement((Object)this.column.metadataObject);
                featureMap.setAssociatedClassifierMap(classifierMap);
            }
            AssociationList dimensionLevels = null;
            if (!this.dimension.isShared()) {
                jomaDimension = (Dimension)this.dimension.metadataObject;
                dimensionLevels = jomaDimension.getLevels();
            } else {
                jomaDimension = (SharedDimension)this.dimension.metadataObject;
                dimensionLevels = jomaDimension.getLevels();
            }
            if (dimensionLevels.indexOf((Object)levelObject) < 0) {
                dimensionLevels.add((Object)levelObject);
            }
            AssociationList featureMaps = levelObject.getTargetFeatureMaps();
            AssociationList transformations = levelObject.getTargetTransformations();
            featureMaps.remove((Object)featureMap);
            transformations.remove((Object)featureMap);
            if (this.tableSet == null) {
                this.tableSet = !this.dimension.isShared() ? this.owningCube.getTableSet() : ((OLAPSharedDimension)this.dimension).getTableSet();
            }
            if (!this.tableSet.isLoadStarSchema() || !this.dimension.isShared() && this.tableSet.isLoadStarSchema() && dimTable.isLoadTable()) {
                featureMaps.add((Object)featureMap);
            } else {
                transformations.add((Object)featureMap);
                AssociationList featureSources = featureMap.getFeatureSources();
                if (!featureSources.isEmpty()) {
                    Object object = featureSources.get(0);
                    featureSources.clear();
                    AssociationList transformationSources = featureMap.getTransformationSources();
                    transformationSources.clear();
                    transformationSources.add(object);
                }
            }
        }
        catch (MdException MdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), MdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        this.updateOptionsMetadata();
        if (this.dimension != null && this.dimension.isGeography()) {
            this.updateMapInfo();
        }
    }

    private void updateMapInfo() throws OLAPException {
        if (this.getMapLayer() != null) {
            Level jomaLevel = (Level)this.metadataObject;
            FeatureMap featureMap = this.getMapFeatureMap();
            try {
                AssociationList targetTransformations = jomaLevel.getTargetTransformations();
                AssociationList targetFeatureMaps = jomaLevel.getTargetFeatureMaps();
                if (featureMap == null) {
                    if (!this.dimension.isShared()) {
                        featureMap = (FeatureMap)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "FeatureMap", this.owningCube.getRepositoryShortFQID());
                    } else if (this.owningSharedDimension != null) {
                        featureMap = (FeatureMap)MetadataTemplate.createMetadata(this.owningSharedDimension.getObjectStore(), "FeatureMap", this.owningSharedDimension.getRepositoryShortFQID());
                    }
                    AssociationList targetMaps = jomaLevel.getTargetTransformations();
                    targetMaps.add((Object)featureMap);
                }
                featureMap.setName(this.mapLayer.getSASColumnName());
                featureMap.setDesc(this.mapLayer.getDescription());
                featureMap.setTransformRole("ESRI Map Layer");
                featureMap.setIsActive(0);
                featureMap.setIsUserDefined(0);
                AssociationList featureSources = featureMap.getFeatureSources();
                AssociationList transformationSources = featureMap.getTransformationSources();
                featureSources.clear();
                transformationSources.clear();
                transformationSources.add((Object)this.mapLayer.metadataObject);
                AssociationList featureTargets = featureMap.getFeatureTargets();
                if (!featureTargets.isEmpty()) {
                    Object object;
                    AssociationList transformationTargets = featureMap.getTransformationTargets();
                    if (transformationTargets.indexOf(object = featureTargets.get(0)) < 0) {
                        transformationTargets.add(featureTargets.get(0));
                    }
                    featureTargets.clear();
                }
                featureMap.setAssociatedClassifierMap(this.dimension.getMapClassifierMap());
                targetFeatureMaps.remove((Object)featureMap);
                if (targetTransformations.indexOf((Object)featureMap) < 0) {
                    targetTransformations.add((Object)featureMap);
                }
            }
            catch (MdException oError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), oError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
    }

    private void updateOptionsMetadata() throws OLAPException {
        if (this.optionSet != null) {
            try {
                Property property;
                int i;
                List options = this.optionSet.getOptions(this);
                HashMap<String, Property> metadataOptions = new HashMap<String, Property>();
                AssociationList properties = this.metadataObject.getProperties(false);
                int size = options.size();
                for (i = 0; i < size; ++i) {
                    Option option = (Option)options.get(i);
                    option.updateMetadata();
                }
                size = properties.size();
                for (i = 0; i < size; ++i) {
                    Property property2 = (Property)properties.elementAt(i);
                    metadataOptions.put(property2.getPropertyName(), property2);
                }
                MdObjectStore objectStore = null;
                if (!this.dimension.isShared()) {
                    objectStore = this.owningCube.getObjectStore();
                } else if (this.owningSharedDimension != null) {
                    objectStore = this.owningSharedDimension.getObjectStore();
                }
                if (this.deleteIgnoreEmpty & this.ignoreEmpty == null && (property = (Property)metadataOptions.get("IGNORE_EMPTY")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(objectStore, (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteEmpty & this.empty == null && (property = (Property)metadataOptions.get("EMPTY")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(objectStore, (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("DimDesigner.Error.Options"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    StringBuffer verifyMapInfo() throws OLAPException {
        FeatureMap featureMap;
        StringBuffer mapInfo = new StringBuffer();
        if (this.metadataObject != null && (featureMap = this.getMapFeatureMap()) != null) {
            try {
                OLAPMemberProperty olapProperty = this.getMapOLAPProperty();
                AssociationList sources = featureMap.getFeatureSources();
                if (sources.isEmpty()) {
                    sources = featureMap.getTransformationSources();
                }
                ClassifierMap owningMap = featureMap.getAssociatedClassifierMap();
                if (sources.isEmpty() || olapProperty == null || owningMap == null) {
                    this.deleteMapInformation();
                    mapInfo.append(bundle.formatString("OLAPLevel.DeleteLevelMapInfo.fmt.txt", (Object)this.getName()));
                } else {
                    this.mapLayer = this.getMapLayer();
                    Property id = this.getMapFieldId();
                    if (id == null) {
                        this.deleteMapInformation();
                        mapInfo.append(bundle.formatString("OLAPLevel.DeleteLevelMapInfo.fmt.txt", (Object)this.getName()));
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return mapInfo;
    }

    private List getSources(FeatureMap featureMap) throws MdException, RemoteException {
        int i;
        ArrayList<Object> sources = new ArrayList<Object>();
        AssociationList featureSources = featureMap.getFeatureSources();
        AssociationList transformationSources = featureMap.getTransformationSources();
        for (i = featureSources.size() - 1; i >= 0; --i) {
            sources.add(featureSources.get(i));
        }
        for (i = transformationSources.size() - 1; i >= 0; --i) {
            sources.add(transformationSources.get(i));
        }
        return sources;
    }

    StringBuffer verifyMetadata() throws OLAPException {
        StringBuffer levelMessage = new StringBuffer();
        if (this.tableSet == null) {
            this.tableSet = this.owningCube.getTableSet();
        }
        LoadTable loadTable = this.tableSet.getLoadTable();
        boolean isStarDim = this.dimension.isStarDimension();
        if (this.metadataObject != null && (isStarDim || !isStarDim && loadTable.getTable() != null)) {
            Level jomaLevel = (Level)this.metadataObject;
            try {
                StringBuffer mapInfo;
                List featureMaps = this.getFeatureMaps(jomaLevel);
                boolean loadTableFound = false;
                this.aggregationSet = this.owningCube.getAggregationSet();
                int t = featureMaps.size() - 1;
                while (t >= 0 & !loadTableFound) {
                    FeatureMap featureMap = (FeatureMap)featureMaps.get(t);
                    if (featureMap.getTransformRole().equalsIgnoreCase("ONETOONE")) {
                        List sources = this.getSources(featureMap);
                        if (sources.isEmpty()) {
                            featureMap.delete();
                        } else {
                            Column jomaColumn = (Column)sources.get(0);
                            PhysicalTable jomaTable = (PhysicalTable)jomaColumn.getTable();
                            DimensionTable inputTable = this.dimension.getTable();
                            if (jomaTable.equals((Object)inputTable.table)) {
                                loadTableFound = true;
                            }
                        }
                    }
                    --t;
                }
                if (!loadTableFound) {
                    this.dimensionSet.resetAggregations = true;
                    OLAPList properties = this.getOLAPProperties();
                    this.owningCube.getObjectStore().removeObjectFromStore((CMetadata)jomaLevel, "<Templates><Notes/><OLAPProperties><TargetFeatureMaps/></OLAPProperties><TargetFeatureMaps/></Templates>");
                    for (int pn = 0; pn < properties.size(); ++pn) {
                        OLAPMemberProperty property = (OLAPMemberProperty)properties.get(pn);
                        this.propertySet.getOLAPProperties().getTheList().remove(property);
                    }
                    DimensionTable dimTable = null;
                    if (this.dimension != null) {
                        dimTable = this.dimension.getTable();
                    }
                    levelMessage.append(bundle.formatString("OLAPLevel.LevelRemoved.fmt.txt", (Object)jomaLevel.getName(), (Object)dimTable.getTable().getName(), (Object)this.dimension.getName()));
                    OLAPList allHierarchies = this.dimension.getHierarchies();
                    for (int i = allHierarchies.size() - 1; i >= 0; --i) {
                        OLAPHierarchy hierarchy = (OLAPHierarchy)allHierarchies.get(i);
                        OLAPList levelsInHierarchy = hierarchy.getLevels();
                        levelsInHierarchy.getTheList().remove(this);
                        if (levelsInHierarchy.size() != 0) continue;
                        allHierarchies.setAllowUndoSetup(false);
                        allHierarchies.remove(hierarchy);
                        allHierarchies.setAllowUndoSetup(true);
                        levelMessage.append(bundle.formatString("OLAPHierarchy.HierarchyRemoved.fmt.txt", (Object)hierarchy.getName(), (Object)this.dimension.getName()));
                        this.dimensionSet.getHierarchies().getTheList().remove(hierarchy);
                    }
                    this.dimensionSet.metaLevelLevel.remove(jomaLevel);
                    String levelName = this.getName();
                    List listByColumn = (List)this.dimensionSet.levels.get(levelName);
                    if (listByColumn != null) {
                        listByColumn.remove(this);
                    }
                    this.dimension.getLevels().getTheList().remove(this);
                    this.dimensionSet.getLevelNames().remove(this.getName());
                    if (this.dimension.getLevels().isEmpty()) {
                        this.dimensionSet.getCubeDimensions().remove(this.dimension);
                        levelMessage.append(bundle.formatString("OLAPDimension.DimensionRemoved.fmt.txt", (Object)this.dimension.getName()));
                    }
                } else if (this.dimension.isGeography() && !ModelUtilities.isBlank((mapInfo = this.verifyMapInfo()).toString())) {
                    levelMessage.append(bundle.formatString("OLAPLevel.DeleteLevelMapInfo.fmt.txt", (Object)this.getName()));
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return levelMessage;
    }

    StringBuffer verifySharedLevelMetadata() throws OLAPException {
        StringBuffer levelMessage = new StringBuffer();
        OLAPSharedDimension sharedDimension = (OLAPSharedDimension)this.dimension;
        PhysicalTable inputTable = sharedDimension.getSharedDimensionTable().getTable();
        if (this.metadataObject != null && inputTable != null) {
            Level jomaLevel = (Level)this.metadataObject;
            try {
                StringBuffer mapInfo;
                List featureMaps = this.getFeatureMaps(jomaLevel);
                boolean tableFound = false;
                int t = featureMaps.size() - 1;
                while (t >= 0 & !tableFound) {
                    FeatureMap featureMap = (FeatureMap)featureMaps.get(t);
                    if (featureMap.getTransformRole().equalsIgnoreCase("ONETOONE")) {
                        List sources = this.getSources(featureMap);
                        if (sources.isEmpty()) {
                            featureMap.delete();
                        } else {
                            Column jomaColumn = (Column)sources.get(0);
                            PhysicalTable jomaTable = (PhysicalTable)jomaColumn.getTable();
                            if (jomaTable.equals((Object)inputTable)) {
                                tableFound = true;
                            }
                        }
                    }
                    --t;
                }
                if (!tableFound) {
                    OLAPList properties = this.getOLAPProperties();
                    sharedDimension.getObjectStore().removeObjectFromStore((CMetadata)jomaLevel, "<Templates><Notes/><OLAPProperties><TargetFeatureMaps/></OLAPProperties><TargetFeatureMaps/></Templates>");
                    for (int pn = 0; pn < properties.size(); ++pn) {
                        OLAPMemberProperty property = (OLAPMemberProperty)properties.get(pn);
                        this.propertySet.getOLAPProperties().getTheList().remove(property);
                    }
                    levelMessage.append(bundle.formatString("OLAPLevel.LevelRemoved.fmt.txt", (Object)jomaLevel.getName(), (Object)inputTable.getName(), (Object)sharedDimension.getName()));
                    OLAPList allHierarchies = sharedDimension.getHierarchies();
                    for (int i = allHierarchies.size() - 1; i >= 0; --i) {
                        OLAPHierarchy hierarchy = (OLAPHierarchy)allHierarchies.get(i);
                        OLAPList levelsInHierarchy = hierarchy.getLevels();
                        levelsInHierarchy.getTheList().remove(this);
                        if (levelsInHierarchy.size() != 0) continue;
                        allHierarchies.setAllowUndoSetup(false);
                        allHierarchies.remove(hierarchy);
                        allHierarchies.setAllowUndoSetup(true);
                        levelMessage.append(bundle.formatString("OLAPHierarchy.HierarchyRemoved.fmt.txt", (Object)hierarchy.getName(), (Object)sharedDimension.getName()));
                        this.dimensionSet.getHierarchies().getTheList().remove(hierarchy);
                    }
                    this.dimensionSet.metaLevelLevel.remove(jomaLevel);
                    String levelName = this.getName();
                    List listByColumn = (List)this.dimensionSet.levels.get(levelName);
                    if (listByColumn != null) {
                        listByColumn.remove(this);
                    }
                    sharedDimension.getLevels().getTheList().remove(this);
                    this.dimensionSet.getLevelNames().remove(this.getName());
                } else if (sharedDimension.isGeography() && !ModelUtilities.isBlank((mapInfo = this.verifyMapInfo()).toString())) {
                    levelMessage.append(bundle.formatString("OLAPLevel.DeleteLevelMapInfo.fmt.txt", (Object)this.getName()));
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return levelMessage;
    }
}

