/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPJobInfoI;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class OLAPJobCube {
    static WAdminResource bundle = new WAdminResource(OLAPJobCube.class);
    public final String ROOT = "Root";
    private final String sType;
    private final String sFQID;
    private final String sName;
    private final String sPublicType;
    private final UserContextInterface userContext;
    private Job job = null;
    private JFJob jfJob = null;
    private Cube cube = null;
    private ServerContext appServer = null;
    private MdObjectStore store = null;
    private OLAPCube olapCube = null;
    private Tree folder = null;

    private OLAPJobCube() {
        throw new UnsupportedOperationException("Usage of Default constructor is not supported");
    }

    public OLAPJobCube(String sPublicType, String sType, String sFQID, String sName) {
        if ("Job.CubeBuild".equals(sPublicType) || "DeployedJob".equals(sPublicType)) {
            this.sPublicType = sPublicType;
            this.sType = sType;
            this.sFQID = sFQID;
            this.sName = sName;
            try {
                this.store = Workspace.getMdFactory().createObjectStore(null, "OLAP job cube store: " + this.hashCode());
                this.userContext = Workspace.getWorkspace().getUserContext();
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        } else {
            throw new IllegalArgumentException(sPublicType);
        }
    }

    private void resetTransientObjects() {
        this.setJob(null);
        this.setJFJob(null);
        this.setCube(null);
        this.setAppServer(null);
        this.setStore(null);
        this.setOLAPCube(null);
        this.setFolder(null);
    }

    public synchronized void cleanup() throws OLAPException {
        try {
            if (this.store != null) {
                this.store.dispose();
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        finally {
            this.resetTransientObjects();
        }
    }

    public String getMetadataType() {
        return this.sType;
    }

    public String getID() {
        return this.sFQID;
    }

    public String getName() {
        return this.sName;
    }

    public String getPublicType() {
        return this.sPublicType;
    }

    private Cube getCube() {
        return this.cube;
    }

    private OLAPCube getOLAPCube() {
        return this.olapCube;
    }

    public Object getRoot() throws OLAPException {
        Root root = null;
        try {
            root = this.fetchFromOMR();
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        if (root == null) {
            String message = bundle.formatString("OLAPJobCube.MissingResource.fmt.txt", (Object)this.ROOT);
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), new IllegalStateException(message), 12);
        }
        return root;
    }

    public Object getAppServer() {
        return this.appServer;
    }

    public Object getUserContext() {
        return this.userContext;
    }

    public Object getFolder() {
        return this.folder;
    }

    private void setFolder() throws OLAPException {
        try {
            if (this.jfJob == null) {
                this.setFolder(this.job.getTrees().get(0));
            } else {
                this.setFolder(this.jfJob.getTrees().get(0));
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        if (this.folder == null) {
            String message = bundle.formatString("OLAPJobCube.MissingResource.fmt.txt", (Object)"Tree");
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), new IllegalStateException(message), 12);
        }
    }

    private void setFolder(Object folder) {
        if (folder != null && !(folder instanceof Tree)) {
            throw new IllegalArgumentException(folder.toString());
        }
        this.folder = (Tree)folder;
    }

    public Object getStore() {
        return this.store;
    }

    private void setStore(Object store) {
        if (store != null && !(store instanceof MdObjectStore)) {
            throw new IllegalArgumentException(store.toString());
        }
        this.store = (MdObjectStore)store;
    }

    private void setCube(Object cube) {
        if (cube != null && !(cube instanceof Cube)) {
            throw new IllegalArgumentException(cube.toString());
        }
        this.cube = (Cube)cube;
    }

    private void setCube() throws OLAPException {
        Object mdo = this.getRoot();
        if (mdo instanceof JFJob) {
            if (this.jfJob == null) {
                this.setJFJob(mdo);
            }
            this.setCube(OLAPJobCube.getAssociatedCube(this.jfJob));
        } else if (mdo instanceof Job) {
            if (this.job == null) {
                this.setJob(mdo);
            }
            this.setCube(OLAPJobCube.getAssociatedCube(this.job));
        } else {
            String message = bundle.formatString("OLAPJobCube.MissingResource.fmt.txt", (Object)"Cube");
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), new IllegalStateException(message), 12);
        }
    }

    private void setJob(Object job) {
        if (job != null && !(job instanceof Job)) {
            throw new IllegalArgumentException(job.toString());
        }
        this.job = (Job)job;
    }

    private void setJFJob(Object job) {
        if (job != null && !(job instanceof JFJob)) {
            throw new IllegalArgumentException(job.toString());
        }
        this.jfJob = (JFJob)job;
    }

    private void setOLAPCube(Object cube) {
        if (cube != null && !(cube instanceof OLAPCube)) {
            throw new IllegalArgumentException(cube.toString());
        }
        this.olapCube = (OLAPCube)cube;
    }

    private void setOLAPCube() throws OLAPException {
        if (this.getCube() == null) {
            this.setCube();
        }
        this.setOLAPCube(new OLAPCube(this.cube));
    }

    public boolean isUsingJob(Object job) {
        boolean ret_val = false;
        if (job != null && job instanceof Job && this.job.equals(job)) {
            ret_val = true;
        }
        return ret_val;
    }

    public void setAppServer(Object appServer) {
        if (appServer != null && !(appServer instanceof ServerContext)) {
            throw new IllegalArgumentException(appServer.toString());
        }
        this.appServer = (ServerContext)appServer;
    }

    public boolean isDeployedForScheduling() throws OLAPException {
        boolean ret_val = false;
        ServerInterface m_server = null;
        try {
            m_server = this.userContext.getAuthServer();
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><Job><JFJobs/><TransformationSources/></Job><ClassifierMap PublicType=\"\"/></Templates>");
            filter.setOMRFlags(-2147483644);
            String sKey = this.getID() + "/" + this.getMetadataType();
            BrowseMetadataInterface deployedJob = m_server.browseFetch(sKey, (FilterInterface)filter);
            List lJFJobs = (List)deployedJob.get("JFJobs");
            if (lJFJobs != null && !lJFJobs.isEmpty()) {
                ret_val = true;
            }
        }
        catch (ServiceException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException(e);
        }
        return ret_val;
    }

    private AssociationList getJFJobs() throws MdException, RemoteException {
        AssociationList jfJobs = null;
        if (this.job != null) {
            jfJobs = this.job.getJFJobs();
        } else {
            Root mdo = this.fetchFromOMR();
            if (mdo instanceof Job) {
                jfJobs = this.job.getJFJobs();
            }
        }
        return jfJobs;
    }

    public List getDeployedJobs() throws OLAPException {
        ArrayList<OLAPJobInfo> deployed = null;
        AssociationList jfJobs = null;
        if ("Job.CubeBuild".equals(this.sPublicType)) {
            try {
                jfJobs = this.getJFJobs();
                if (jfJobs != null) {
                    deployed = new ArrayList<OLAPJobInfo>(jfJobs.size());
                    for (Object object : jfJobs) {
                        JFJob jfJob;
                        if (!(object instanceof JFJob) || !(jfJob = (JFJob)object).getPublicType().equalsIgnoreCase("DeployedJob")) continue;
                        OLAPJobInfo jobinfo = new OLAPJobInfo(this, jfJob);
                        deployed.add(jobinfo);
                    }
                }
            }
            catch (MdException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            catch (IllegalArgumentException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            finally {
                if (deployed != null && deployed.size() <= 0) {
                    deployed = null;
                }
            }
        }
        return deployed;
    }

    public String generateSource() throws OLAPException {
        StringBuilder code;
        block10: {
            code = new StringBuilder(300);
            try {
                if (this.job != null) {
                    if (this.job.getIsActive() == 0) {
                        code.append(bundle.getString("OLAPJobCube.JobIsInactive.txt"));
                    } else {
                        WsAppServer appserver = WsAppServer.createAppServer((ServerContext)this.appServer);
                        CodegenRequest cgReq = new CodegenRequest((CMetadata)this.job, appserver, 1, true);
                        cgReq.genReturnCodeSetup();
                        code.append(cgReq.getSource()).append(ModelUtilities.newline);
                        cgReq.clearSourceCode(true);
                        String newcode = this.generatePrePostProcessingCode(this.job, cgReq, "PreProcess");
                        if (newcode != null) {
                            code.append(ModelUtilities.newline).append(newcode).append(ModelUtilities.newline);
                        }
                        cgReq.clearSourceCode(true);
                        if (this.job.getIsUserDefined() > 0) {
                            cgReq.genUWC((AbstractTransformation)this.job);
                            code.append(cgReq.getSource());
                        } else {
                            code.append(this.generateDeletePhysical(this.olapCube)).append(ModelUtilities.newline);
                            code.append(ModelUtilities.newline).append(this.generateShortFormCubeBuild(this.olapCube));
                        }
                        newcode = null;
                        cgReq.clearSourceCode(true);
                        newcode = this.generatePrePostProcessingCode(this.job, cgReq, "PostProcess");
                        if (newcode != null) {
                            code.append(ModelUtilities.newline).append(newcode);
                        }
                    }
                    break block10;
                }
                throw new OLAPException(bundle.getString("OLAPJobCube.CodegenFailed.NoJob.txt"), 0);
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            catch (MdException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        }
        return code.toString();
    }

    private static Cube getAssociatedCube(Job job) throws OLAPException {
        Cube aCube = null;
        try {
            MdObjectStore oStore = (MdObjectStore)job.getObjectStore();
            String template = "<Templates><Job><JobActivities/></Job><TransformationActivity><Steps/></TransformationActivity><TransformationStep><Transformations/></TransformationStep><ClassifierMap><ClassifierTargets/></ClassifierMap></Templates>";
            int iOptions = 8588;
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)job, null, null, template, iOptions);
            AssociationList activities = job.getJobActivities();
            if (activities == null || activities.size() <= 0) {
                String message = bundle.formatString("OLAPJobCube.MissingResource.fmt.txt", (Object)"TransformationActivity");
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), new IllegalStateException(message), 12);
            }
            TransformationActivity omrActivity = (TransformationActivity)activities.get(0);
            AssociationList steps = omrActivity.getSteps();
            if (steps == null || steps.size() <= 0) {
                String message = bundle.formatString("OLAPJobCube.MissingResource.fmt.txt", (Object)"TransformationStep");
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), new IllegalStateException(message), 12);
            }
            TransformationStep omrStep = (TransformationStep)steps.get(0);
            AssociationList transformations = omrStep.getTransformations();
            if (transformations == null || transformations.size() <= 0) {
                String message = bundle.formatString("OLAPJobCube.MissingResource.fmt.txt", (Object)"ClassifierMap");
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), new IllegalStateException(message), 12);
            }
            ClassifierMap omrClassifierMap = (ClassifierMap)transformations.get(0);
            AssociationList cubes = omrClassifierMap.getClassifierTargets();
            if (cubes == null || cubes.size() <= 0) {
                String message = bundle.formatString("OLAPJobCube.MissingResource.fmt.txt", (Object)"Cube");
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), new IllegalStateException(message), 12);
            }
            Object obj = cubes.get(0);
            if (obj instanceof Cube) {
                aCube = (Cube)cubes.get(0);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        if (aCube == null) {
            String message = bundle.formatString("OLAPJobCube.MissingResource.fmt.txt", (Object)"Cube");
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), new IllegalStateException(message), 12);
        }
        return aCube;
    }

    private static Cube getAssociatedCube(JFJob jfJob) throws OLAPException {
        Cube aCube = null;
        Job associatedJob = null;
        try {
            associatedJob = jfJob.getAssociatedJob();
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        finally {
            if (associatedJob == null) {
                String message = bundle.formatString("OLAPJobCube.MissingResource.fmt.txt", (Object)"Job");
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), new IllegalStateException(message), 12);
            }
            aCube = OLAPJobCube.getAssociatedCube(associatedJob);
        }
        return aCube;
    }

    private String generateDeletePhysical(OLAPCube olapCube) throws OLAPException {
        String codeGen = null;
        codeGen = olapCube.generateCodeDeletePhysical(true).toString();
        return codeGen;
    }

    private String generatePrePostProcessingCode(Job job, CodegenRequest cgReq, String type) throws RemoteException, MdException {
        String code = "";
        AssociationList transList = null;
        if (type.equals("PreProcess")) {
            transList = job.getTransformationSources();
        } else if (type.equals("PostProcess")) {
            transList = job.getTransformationTargets();
        } else {
            return code;
        }
        for (int i = 0; i < transList.size(); ++i) {
            Transformation step;
            Root root = (Root)transList.get(i);
            if (!(root instanceof Transformation) || !(step = (Transformation)root).getTransformRole().equalsIgnoreCase(type)) continue;
            if (step.getIsActive() != 1) break;
            cgReq.genUWC((AbstractTransformation)step, true);
            break;
        }
        code = cgReq.getSource();
        return code;
    }

    private String generateShortFormCubeBuild(OLAPCube olapCube) throws OLAPException {
        String generatedCode = null;
        int flags = 0;
        flags = OLAPCube.setCodegenFlag(flags, 1, true);
        flags = OLAPCube.setCodegenFlag(flags, 2, true);
        flags = OLAPCube.setCodegenFlag(flags, 8, true);
        generatedCode = olapCube.generateCodeShortForm(flags).toString();
        return generatedCode;
    }

    private synchronized Root fetchFromOMR() throws MdException, RemoteException {
        JFJob mdo = null;
        if (this.store == null || this.store.isDisposed()) {
            this.resetTransientObjects();
            this.store = Workspace.getMdFactory().createObjectStore(null, "OLAP job cube store: " + this.hashCode());
        }
        if ("DeployedJob".equals(this.sPublicType) && this.jfJob != null) {
            mdo = this.jfJob;
        } else if ("Job.CubeBuild".equals(this.sPublicType) && this.job != null) {
            mdo = this.job;
        } else {
            String sType = this.getMetadataType();
            String sFQID = this.getID();
            String sName = this.getName();
            mdo = (Root)Workspace.getMdFactory().createComplexMetadataObject(this.store, sName, sType, sFQID);
            if (mdo != null) {
                if (!mdo.isNewObject()) {
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)mdo, null, null, "", 8);
                }
                if (mdo instanceof Job) {
                    this.job = (Job)mdo;
                    this.jfJob = null;
                } else if (mdo instanceof JFJob) {
                    this.jfJob = mdo;
                    this.job = this.jfJob.getAssociatedJob();
                }
            }
        }
        return mdo;
    }

    public void prepareForDeployment() throws OLAPException {
        if (this.getOLAPCube() == null) {
            this.setOLAPCube();
        }
        if (this.olapCube.getErrorLevel() != -1) {
            String message = this.olapCube.getCubeVerifyMessage().toString();
            throw new OLAPException(bundle.getString("OLAPJobCube.MetadataChanges.txt"), new IllegalStateException(message), 0);
        }
        if (this.getFolder() == null) {
            this.setFolder();
        }
    }

    private class OLAPJobInfo
    implements OLAPJobInfoI {
        private OLAPJobCube jobcube;
        private String metaType;
        private String metaID;
        private String jobName;
        private String publicType;

        public String getMetadataType() {
            return this.metaType;
        }

        public String getID() {
            return this.metaID;
        }

        public String getName() {
            return this.jobName;
        }

        public String getPublicType() {
            return this.publicType;
        }

        public boolean isPublicObject() {
            return true;
        }

        public boolean isNew() {
            return false;
        }

        @Override
        public OLAPJobCube getJobCube() {
            return this.jobcube;
        }

        private void initOLAPJobInfo(JFJob mdo) throws RemoteException {
            this.metaID = mdo.getFQID();
            this.jobName = mdo.getName();
            this.metaType = mdo.getCMetadataType();
            this.publicType = mdo.getPublicType();
            if (this.jobName.length() == 0) {
                throw new IllegalArgumentException("Name in JOMA object is not populated=" + mdo);
            }
            if (this.publicType.length() == 0 || !"DeployedJob".equals(this.publicType)) {
                throw new IllegalArgumentException("PublicType in JOMA object is invalid=" + mdo);
            }
        }

        public OLAPJobInfo(OLAPJobCube a, JFJob job) throws RemoteException {
            this.jobcube = a;
            this.initOLAPJobInfo(job);
        }
    }
}

