/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SharedDimension;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.util.UsageVersion;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class OLAPHierarchy
extends AbstractOLAPModel {
    static WAdminResource bundle = new WAdminResource(OLAPHierarchy.class);
    private OLAPList levels;
    private OLAPDimension dimension;
    private Option allMember;
    private List backUpLevels;
    private OLAPList olapProperties;
    boolean changedMetadata;
    private boolean checkVerifyName;
    private final int MaximumLevelsPerHierarchy = 19;
    private Option defaultMember;
    private Option allMemberMLSId;
    private boolean deleteAllMemberMLSId;
    private static final String HIERARCHY = "      HIERARCHY ";
    private static final String ALL_MEMBER = "         ALL_MEMBER = '";
    private static final String ALL_MLSID = "         ALL_MLSID  =  ";
    private static final String CAPTION = "         CAPTION    = '";
    private static final String DESC = "         DESC       = '";
    private static final String HIER_MLSID = "         MLSID      = ";
    private static final String LEVELS = "         LEVELS     = (";
    private static final String LEVELS_INDENT = "            ";
    private static final String LEVELS_END = "            ) /* LEVELS */";
    private static final String DEFAULT = "         DEFAULT";
    private static SASStringComparator stringCompare = SASCollatorFactory.createComparatorIgnoreCase();

    OLAPHierarchy(Hierarchy inputMetadataObject) {
        this.metadataObject = inputMetadataObject;
    }

    OLAPHierarchy() {
        this.changedMetadata = true;
    }

    public void delete() throws OLAPException {
        this.getDimension();
        OLAPList listOfHierarchies = null;
        listOfHierarchies = this.dimension.getHierarchies();
        listOfHierarchies.remove(this);
    }

    StringBuffer generateCode() throws OLAPException {
        StringBuffer hierarchyStatement = new StringBuffer();
        hierarchyStatement.append(ModelUtilities.newline).append(ModelUtilities.newline).append(HIERARCHY).append(ModelUtilities.getSasName(this.getName()).append(" "));
        OLAPList listOfLevels = this.getLevels();
        hierarchyStatement.append(ModelUtilities.newline).append(ALL_MEMBER).append(ModelUtilities.internalQuote(this.getAllMember())).append("'");
        Integer allNumber = this.getAllMemberMLSID();
        if (allNumber != null) {
            hierarchyStatement.append(ModelUtilities.newline).append(ALL_MLSID).append(allNumber.toString()).append(ModelUtilities.newline);
        }
        String caption = ModelUtilities.internalQuote(this.getDesc());
        String desc = ModelUtilities.internalQuote(this.getNotes());
        if (!ModelUtilities.isBlank(caption)) {
            hierarchyStatement.append(ModelUtilities.newline).append(CAPTION).append(ModelUtilities.trim(caption)).append("'");
        }
        if (!ModelUtilities.isBlank(desc)) {
            hierarchyStatement.append(ModelUtilities.newline).append(DESC).append(ModelUtilities.trim(desc)).append("'");
        }
        hierarchyStatement.append(ModelUtilities.newline).append(LEVELS);
        hierarchyStatement.append(ModelUtilities.listFormatter(listOfLevels, LEVELS_INDENT, " "));
        hierarchyStatement.append(LEVELS_END);
        this.getDimension();
        Integer number = this.getMLSID();
        if (number != null) {
            hierarchyStatement.append(ModelUtilities.newline).append(HIER_MLSID).append(number.toString()).append(ModelUtilities.newline);
        }
        OLAPList hierarchies = null;
        hierarchies = this.dimension.getHierarchies();
        if (hierarchies.indexOf(this) == 0) {
            hierarchyStatement.append(ModelUtilities.newline).append(DEFAULT);
        }
        hierarchyStatement.append(";");
        return hierarchyStatement;
    }

    public String getAllMember() throws OLAPException {
        String returnValue = null;
        if (this.allMember == null & this.metadataObject != null) {
            this.allMember = this.optionSet.getOption(this, "AllMemberCaption", "OLAPAllMemberCaption");
        }
        if (this.allMember != null) {
            returnValue = this.allMember.getDefaultValue();
        }
        return returnValue;
    }

    public Integer getAllMemberMLSID() throws OLAPException {
        Integer returnOption = null;
        if (this.allMemberMLSId == null && this.metadataObject != null && !this.deleteAllMemberMLSId) {
            this.allMemberMLSId = this.optionSet.getOption(this, "All Member MLSID", "OLAP UDT");
        }
        if (this.allMemberMLSId != null) {
            this.allMemberMLSId.setPropertyOption(true);
            returnOption = Integer.valueOf(this.allMemberMLSId.getDefaultValue());
        }
        return returnOption;
    }

    public String getDefaultMember() throws OLAPException {
        String returnValue = null;
        if (this.defaultMember == null && this.metadataObject != null) {
            this.defaultMember = this.optionSet.getOption(this, "Default Member", "OLAPOption");
        }
        if (this.defaultMember != null) {
            returnValue = this.defaultMember.getDefaultValue();
        }
        if (ModelUtilities.isBlank(returnValue)) {
            OLAPList hierarchies = null;
            hierarchies = this.dimension.getHierarchies();
            returnValue = hierarchies.size() == 1 ? "[" + this.getName() + "].[" + this.getAllMember() + "]" : this.getUniqueName() + ".[" + this.getAllMember() + "]";
        }
        return returnValue;
    }

    public String getUserDefaultMember() throws OLAPException {
        String returnValue = null;
        if (this.defaultMember == null && this.metadataObject != null) {
            this.defaultMember = this.optionSet.getOption(this, "Default Member", "OLAPOption");
        }
        if (this.defaultMember != null) {
            returnValue = this.defaultMember.getDefaultValue();
        }
        return returnValue;
    }

    public OLAPDimension getDimension() {
        return this.dimension;
    }

    public DimensionSet getDimensionSet() {
        return this.dimensionSet;
    }

    public OLAPList getLevels() throws OLAPException {
        if (this.levels == null) {
            if (this.dimensionSet.metaLevelLevel == null) {
                this.dimensionSet.getLevels();
            }
            try {
                this.levels = new OLAPList(OLAPLevel.class);
                this.levels.setParentObject(this);
                if (this.metadataObject != null) {
                    this.levels.allowUndoSetup = false;
                    Hierarchy hierarchyObject = (Hierarchy)this.metadataObject;
                    AssociationList hierarchyLevels = null;
                    hierarchyLevels = hierarchyObject.getLevels();
                    this.backUpLevels = new ArrayList();
                    int size = hierarchyLevels.size();
                    for (int i = 0; i < size; ++i) {
                        Level level = (Level)hierarchyLevels.elementAt(i);
                        OLAPLevel oLevel = (OLAPLevel)this.dimensionSet.metaLevelLevel.get(level);
                        if (oLevel == null) continue;
                        this.levels.add(oLevel);
                        this.backUpLevels.add(oLevel);
                    }
                }
                this.levels.allowUndoSetup = true;
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.levels;
    }

    public OLAPList getOLAPProperties() throws OLAPException {
        if (this.olapProperties == null) {
            this.olapProperties = new OLAPList(OLAPMemberProperty.class);
            this.olapProperties.setModifiable(false);
            this.olapProperties.setParentObject(this);
        }
        return this.olapProperties;
    }

    public String getUniqueName() {
        return "[" + this.dimension.getName() + "].[" + this.getName() + "]";
    }

    @Override
    public boolean isMetadataUpdated() {
        if (!this.changedMetadata) {
            this.changedMetadata = super.isMetadataUpdated();
        }
        return this.changedMetadata;
    }

    public boolean isLevelsUpdated() {
        return this.levels != null && !this.levels.equals(this.backUpLevels);
    }

    public void orderTimeLevels() throws OLAPException {
        int i;
        this.getLevels();
        int lastType = 0;
        ArrayList<OLAPLevel> orderedList = new ArrayList<OLAPLevel>();
        boolean found = false;
        int size = this.levels.size();
        for (i = 0; i < size; ++i) {
            found = false;
            OLAPLevel level = (OLAPLevel)this.levels.get(i);
            int typeLevel = level.getType();
            if (lastType <= typeLevel) {
                orderedList.add(level);
                lastType = typeLevel;
                continue;
            }
            int t = 0;
            int sizeT = orderedList.size();
            while (t < sizeT & !found) {
                OLAPLevel nextLevel = (OLAPLevel)orderedList.get(t);
                int nextType = nextLevel.getType();
                if (typeLevel < nextType) {
                    int whereisit = orderedList.indexOf(nextLevel);
                    orderedList.add(whereisit, level);
                    found = true;
                }
                ++t;
            }
        }
        this.levels.getTheList().clear();
        size = orderedList.size();
        for (i = 0; i < size; ++i) {
            this.levels.add((OLAPLevel)orderedList.get(i));
        }
    }

    public void setAllMember(String inAllMember) {
        if (inAllMember != null) {
            if (this.allMember == null) {
                this.allMember = new Option(this.optionSet, this);
                this.allMember.setName("AllMemberCaption");
                this.allMember.setDesc("AllMemberCaption");
                this.allMember.setPropertyName("AllMemberCaption");
                this.allMember.setPropertyRole("OLAPAllMemberCaption");
                this.allMember.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.allMember.setDefaultValue(inAllMember);
            this.changedMetadata = true;
            this.setUpChanges("setAllMember", String.class, inAllMember);
        }
    }

    public void setAllMemberMLSID(Integer inputMlsId) throws OLAPException {
        this.allMemberMLSId = this.optionSet.getOption(this, "All Member MLSID", "OLAP UDT");
        if (inputMlsId != null) {
            this.verifyMLSId(inputMlsId);
            this.deleteAllMemberMLSId = false;
            if (this.allMemberMLSId == null) {
                this.allMemberMLSId = new Option(this.optionSet, this);
                this.allMemberMLSId.setName("All Member MLSID");
                this.allMemberMLSId.setDesc("All Member MLSID");
                this.allMemberMLSId.setPropertyRole("OLAP UDT");
                this.allMemberMLSId.setPropertyName("All Member MLSID");
                this.allMemberMLSId.setOwningType(OptionSet.OWNING_TYPE_INTEGER);
                this.allMemberMLSId.setPropertyOption(true);
            }
            this.allMemberMLSId.setDefaultValue(inputMlsId.toString());
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.allMemberMLSId) >= 0) {
                objectOptions.remove(this.allMemberMLSId);
            }
            this.allMemberMLSId = null;
            this.deleteAllMemberMLSId = true;
        }
    }

    void setDimension(OLAPDimension inputDimension) {
        this.dimension = inputDimension;
    }

    @Override
    public void setName(String inputName) {
        super.setName(inputName);
        this.checkVerifyName = false;
        if (this.isUndo()) {
            this.setUpChanges("setName", String.class, inputName);
        }
    }

    @Override
    public void setNotes(String inputNotes) {
        super.setNotes(inputNotes);
        this.setUpChanges("setNotes", String.class, inputNotes);
    }

    @Override
    public void setDesc(String inputDesc) {
        super.setDesc(inputDesc);
        this.setUpChanges("setDesc", String.class, inputDesc);
    }

    void updateHierarchyMetadata() throws OLAPException {
        this.getLevels();
        if (!this.checkVerifyName) {
            this.verifyName();
        }
        this.verifyHierarchyLevelsList();
        if (this.dimension != null && this.dimension.getType().equals("TIME") || this.dimension.isShared() && this.dimension.getType().equals("TIME")) {
            this.verifyHierarchyTimeDrillOrder();
        }
        boolean newObject = false;
        if (this.metadataObject == null) {
            newObject = true;
            this.metadataObject = !this.dimension.isShared() ? (Hierarchy)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Hierarchy", this.owningCube.getRepositoryShortFQID()) : (Hierarchy)MetadataTemplate.createMetadata(((OLAPSharedDimension)this.dimension).getObjectStore(), "Hierarchy", ((OLAPSharedDimension)this.dimension).getRepositoryShortFQID());
        }
        Hierarchy hierarchyObject = (Hierarchy)this.metadataObject;
        try {
            AssociationList hierarchies;
            hierarchyObject.setPublicType("Hierarchy");
            UsageVersion usageVersion = new UsageVersion(Integer.parseInt("4"), Integer.parseInt("0"), Integer.parseInt("0"));
            hierarchyObject.setUsageVersion(usageVersion.encode());
            if (!this.dimension.isShared()) {
                hierarchyObject.setUniqueName("[" + this.dimension.getName() + "].[" + this.getName() + "]");
            } else {
                hierarchyObject.setUniqueName("[" + this.dimension.getName() + "].[" + this.getName() + "]");
            }
            this.updateMetadata();
            if (newObject && !this.dimension.isShared()) {
                Cube jomaCube = (Cube)this.owningCube.metadataObject;
                hierarchies = jomaCube.getHierarchies();
                hierarchies.addElement((Object)hierarchyObject);
                Dimension jomaDimension = (Dimension)this.dimension.metadataObject;
                jomaDimension.getHierarchies().add((Object)hierarchyObject);
            } else if (newObject && this.dimension.isShared()) {
                SharedDimension jomaDim = (SharedDimension)this.dimension.metadataObject;
                hierarchies = jomaDim.getHierarchies();
                hierarchies.addElement((Object)hierarchyObject);
            }
            AssociationList listOfHierarchies = hierarchyObject.getLevels();
            listOfHierarchies.clear();
            int size = this.levels.size();
            for (int i = 0; i < size; ++i) {
                OLAPLevel olapLevel = (OLAPLevel)this.levels.get(i);
                listOfHierarchies.addElement((Object)olapLevel.metadataObject);
            }
            this.updateOptionsMetadata();
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private void updateOptionsMetadata() throws OLAPException {
        if (this.optionSet != null) {
            try {
                List options = this.optionSet.getOptions(this);
                Hierarchy hierarchyObject = (Hierarchy)this.metadataObject;
                AssociationList properties = hierarchyObject.getProperties(false);
                int size = options.size();
                for (int i = 0; i < size; ++i) {
                    Option option = (Option)options.get(i);
                    option.updateMetadata();
                }
                for (int t = properties.size() - 1; t > -1; --t) {
                    Property property = (Property)properties.elementAt(t);
                    if (property.getName().equals("EMPTY_CHAR") | property.getName().equals("EMPTY_NUM") | property.getName().equals("IGNORE_EMPTY")) {
                        MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                    }
                    if (!property.getName().equals("All Member MLSID") || !this.deleteAllMemberMLSId) continue;
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public void verifyHierarchyTimeDrillOrder() throws OLAPException {
        if (this.levels.size() > 0) {
            int currentDrillOrder = 0;
            boolean blank = false;
            OLAPLevel firstHierarchyLevel = (OLAPLevel)this.levels.get(0);
            int hierarchyDrillOrder = firstHierarchyLevel.getType();
            if (hierarchyDrillOrder == 8192) {
                blank = true;
            }
            int size = this.levels.size();
            for (int i = 0; i < size; ++i) {
                OLAPLevel hierarchyLevel = (OLAPLevel)this.levels.get(i);
                hierarchyDrillOrder = hierarchyLevel.getType();
                if (i == 0) {
                    currentDrillOrder = hierarchyDrillOrder;
                } else if (blank) {
                    if (hierarchyDrillOrder != 8192) {
                        throw new OLAPException(bundle.formatString("OLAPHierarchy.TimeMixTypesBlank.Incorrect.fmt.txt", (Object)hierarchyLevel.getName(), (Object)firstHierarchyLevel.getName(), (Object)this.name), 0);
                    }
                } else {
                    if (hierarchyDrillOrder == 256 & currentDrillOrder != 16) {
                        throw new OLAPException(bundle.getString("OLAPHierarchy.WeekNotAllowed.fmt.txt"), 0);
                    }
                    if (currentDrillOrder >= hierarchyDrillOrder) {
                        throw new OLAPException(bundle.formatString("OLAPHierarchy.TimeDrillOrder.Incorrect.fmt.txt", (Object)this.dimensionSet.getTimeType(hierarchyDrillOrder), (Object)hierarchyLevel.getName(), (Object)this.getName()), 0);
                    }
                    if (hierarchyDrillOrder == 8192) {
                        throw new OLAPException(bundle.formatString("OLAPHierarchy.TimeMixTypesNotBlank.Incorrect.fmt.txt", (Object)hierarchyLevel.getName(), (Object)firstHierarchyLevel.getName(), (Object)this.name), 0);
                    }
                }
                currentDrillOrder = hierarchyDrillOrder;
            }
        }
    }

    public void verifyAllMember(String inAllMember) throws OLAPException {
        String allString;
        String trimString = inAllMember.trim();
        if (stringCompare.compare(trimString, allString = bundle.getString("OLAPHierarchy.AllMemberCaption.static.txt")) == 0) {
            throw new OLAPException(bundle.formatString("OLAPHierarchy.AllMemberCaption.NotAll.txt", (Object)allString), 2);
        }
        this.getLevels();
        int size = this.levels.size();
        for (int i = 0; i < size; ++i) {
            OLAPLevel level = (OLAPLevel)this.levels.get(i);
            String levelName = level.getName();
            if (stringCompare.compare(trimString, levelName) == 0) {
                throw new OLAPException(bundle.formatString("OLAPHierarchy.AllMemberCaption.NotAll.txt", (Object)levelName), 2);
            }
            if (stringCompare.compare(bundle.getString("OLAPHierarchy.AllMemberCaption.static.txt"), levelName) != 0) continue;
            throw new OLAPException(bundle.formatString("OLAPHierarchy.AllMemberCaption.AllCannotBeLevel.txt", (Object)levelName), 2);
        }
    }

    public void verifyHierarchyLevelsList() throws OLAPException {
        if (this.getLevels() == null || this.levels.size() < 1) {
            throw new OLAPException(bundle.formatString("OLAPHierarchy.NoSelectedLevels.fmt.txt", (Object)this.name), 0);
        }
    }

    public void verifyMaximumLevelsPerHierarchy() throws OLAPException {
        this.getLevels();
        if (this.levels.size() > 19) {
            throw new OLAPException(bundle.getString("OLAPLevel.TooManyLevelsPerHierarchy.txt"), 0);
        }
    }

    public void verifyMaximumLevelsPerDefaultHierarchy() throws OLAPException {
        this.getLevels();
        if (this.levels.size() > 19) {
            throw new OLAPException(bundle.getString("OLAPLevel.DefaultTooManyLevelsPerHierarchy.txt"), 0);
        }
    }

    @Override
    public void verifyName() throws OLAPException {
        super.verifyName();
        this.verifySASName();
        List dimensionLevels = this.dimensionSet.getLevelNames();
        String hierarchyName = this.getName();
        for (int i = 0; i < dimensionLevels.size(); ++i) {
            String levelName = (String)dimensionLevels.get(i);
            if (!hierarchyName.equalsIgnoreCase(levelName)) continue;
            throw new OLAPException(bundle.formatString("OLAPHierarchy.HierarchyNameisLevelName.fmt.txt", (Object)levelName), 12);
        }
        OLAPList allHierarchies = this.dimension.getHierarchies();
        int size = allHierarchies.size();
        for (int i = 0; i < size; ++i) {
            String existingHierarchyName;
            OLAPHierarchy hierarchy = (OLAPHierarchy)allHierarchies.get(i);
            if (hierarchy == this || !hierarchyName.equalsIgnoreCase(existingHierarchyName = hierarchy.getName())) continue;
            throw new OLAPException(bundle.getString("OLAPHierarchy.DuplicateHierarchyName.txt"), 0);
        }
        this.checkVerifyName = true;
    }

    StringBuffer verifyMetadata() throws OLAPException {
        StringBuffer hierarchyMessage = new StringBuffer();
        try {
            Hierarchy hierarchyObject = (Hierarchy)this.metadataObject;
            boolean found = false;
            if (hierarchyObject != null) {
                AssociationList properties = hierarchyObject.getProperties(false);
                int j = 0;
                int jSize = properties.size();
                while (j < jSize & !found) {
                    Property property = (Property)properties.elementAt(j);
                    if (property.getPropertyName().equalsIgnoreCase("AllMemberCaption")) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    this.setAllMember(bundle.formatString("OLAPHierarchy.AllMember.fmt.txt", (Object)this.getName()));
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return hierarchyMessage;
    }
}

