/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TableCollection;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.UniqueKey;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DefinedMemberSet;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.DimensionTable;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MLSCaptionTable;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.util.UsageVersion;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OLAPDimension
extends AbstractOLAPModel {
    static WAdminResource bundle = new WAdminResource(OLAPDimension.class);
    OLAPList levels;
    protected Option tableOptions;
    DimensionTable inputTable;
    protected DimensionTable previousInputTable;
    protected Option captionPref;
    protected OLAPColumn factKey;
    protected LoadTable factTable;
    OLAPList hierarchies;
    protected OLAPHierarchy defaultHierarchy;
    protected OLAPColumn dimensionKey;
    protected String type;
    protected String sortOrder;
    protected UniqueKey dimensionUniqueKey;
    protected Option emptyChar;
    protected Option emptyNum;
    protected Option ignoreEmpty;
    protected Option MLSOption;
    protected MLSCaptionTable mlsCaptionTable;
    protected boolean shared;
    protected TableCollection mapService;
    protected ServerComponent mapServer;
    protected Boolean isStarDimension;
    protected boolean deleteIgnoreEmpty;
    protected boolean deleteEmptyChar;
    protected boolean deleteEmptyNum;
    protected boolean deleteMLS;
    protected boolean deleteCaptionTable;
    protected boolean deleteCaptionPref;
    protected boolean deleteTableOptions;
    protected boolean convertKeyObjects;
    protected Transformation foundKeyObjectTransformation;
    protected StringBuffer dimensionVerifyMessage;
    protected boolean changedMetadata;
    protected boolean checkVerifyName;
    protected boolean checkDimensionKey;
    protected boolean checkDimensionTable;
    protected boolean checkDimensionFactKey;
    protected boolean checkDimensionType;
    protected ClassifierMap mapInfoClassifierMap;
    protected String updateOption;
    protected String addDataTableName;
    protected String addDataTableOptions;
    protected PhysicalTable addDataTable;
    protected Option updateableDimension;
    protected boolean deleteUpdateableDimension;
    protected boolean onlyShared;
    protected boolean wasTime;
    static final String DIMENSION = "   DIMENSION ";
    static final String UPDATE_DIMENSION = "      UPDATE_DIMENSION = ";
    public static final String MEMBERS = "MEMBERS";
    public static final String MEMBERSANDPROPERTIES = "MEMBERS_AND_PROPERTIES";
    public static final String OFF = "OFF";
    static final String MAP_SERVICE = "      MAP_SERVICE      = '";
    static final String CAPTION = "      CAPTION          = '";
    static final String DESC = "      DESC             = '";
    static final String TYPE = "      TYPE             = ";
    static final String SORT_ORDER = "      SORT_ORDER       = ";
    static final String HIERARCHIES = "      HIERARCHIES      = (";
    static final String HIERARCHIES_INDENT = "         ";
    static final String HIERARCHIES_END = "         ) /* HIERARCHIES */";
    static final String DIMTABLELIBREF = "      DIMTABLELIBREF   = ";
    static final String DIMTABLEMEMPREF = "      DIMTABLEMEMPREF  = ";
    static final String DIMTABLECAPPREF = "      DIMTABLECAPPREF  = ";
    static final String MLSID = "      MLSID            = ";
    static final String MEMPREFOPTS = "      MEMPREFOPTS      = ";
    static final String DIMKEY = "      DIMKEY           = ";
    static final String FACTKEY = "      FACTKEY          = ";
    static final String DIMTBL = "      DIMTBL           = ";
    static final String EMPTY_CHAR = "      EMPTY_CHAR       = ";
    static final String EMPTY_NUM = "      EMPTY_NUM        = ";
    static final String IGNORE_EMPTY = "      IGNORE_EMPTY";
    static final String DIMKEYDIMENSION = "DimKeyDimension";
    static final String FACTKEYDIMENSION = "FactKeyDimension";
    static final String DIMKEYCA = "DimKey";
    static final String FACTKEYCA = "FactKey";
    public static final String TIME = "TIME";
    public static final String STANDARD = "STANDARD";
    public static final String GEO = "GEO";
    public static final String MEASURES = "MEASURES";

    OLAPDimension(Dimension inputMetadataObject) {
        this.metadataObject = inputMetadataObject;
        this.getType();
        if (this.type == null) {
            this.setType(STANDARD);
        } else {
            this.setType(this.type);
        }
        if (this.type.equalsIgnoreCase(TIME)) {
            this.wasTime = true;
        }
        this.shared = false;
        this.onlyShared = false;
    }

    OLAPDimension() {
        this.changedMetadata = true;
        this.setType(STANDARD);
        this.setSortOrder("ASCENDING");
        this.shared = false;
        this.onlyShared = false;
    }

    OLAPLevel createOLAPLevel(Level inputMetadataObject) throws OLAPException {
        String levelEmptyChar;
        OLAPLevel olapLevel = new OLAPLevel(inputMetadataObject);
        olapLevel.setDimension(this);
        olapLevel.setDimensionSet(this.getDimensionSet());
        olapLevel.setOwningCube(this.getOwningCube());
        olapLevel.setOptionSet(this.owningCube.getOptionsSet());
        String levelIgnoreEmpty = olapLevel.getIgnoreEmpty();
        if (levelIgnoreEmpty != null) {
            olapLevel.setUpChanges("setIgnoreEmpty", String.class, levelIgnoreEmpty);
        }
        if ((levelEmptyChar = olapLevel.getEmpty()) != null) {
            olapLevel.setUpChanges("setEmpty", String.class, levelEmptyChar);
        }
        olapLevel.apply();
        return olapLevel;
    }

    public OLAPLevel createOLAPLevel(OLAPColumn column) throws OLAPException {
        String levelName;
        this.dimensionSet.verifyMaximumLevelsPerCube();
        this.aggregationSet = this.owningCube.getAggregationSet();
        this.aggregationSet.setResetLevels(true);
        OLAPLevel olapLevel = new OLAPLevel(column);
        olapLevel.setDimensionSet(this.getDimensionSet());
        olapLevel.setOwningCube(this.getOwningCube());
        olapLevel.setDimension(this);
        olapLevel.setOptionSet(this.owningCube.getOptionsSet());
        olapLevel.name = levelName = this.getUniqueLevelName(olapLevel.getColumn().getSASColumnName());
        olapLevel.changedName = true;
        this.getLevels().add(olapLevel);
        return olapLevel;
    }

    public OLAPLevel createOLAPSuppliedTimeLevel(OLAPColumn column, String suppliedLevelName) throws OLAPException {
        String levelName;
        this.dimensionSet.verifyMaximumLevelsPerCube();
        this.aggregationSet = this.owningCube.getAggregationSet();
        this.aggregationSet.setResetLevels(true);
        OLAPLevel olapLevel = new OLAPLevel(column);
        olapLevel.setDimensionSet(this.getDimensionSet());
        olapLevel.setOwningCube(this.getOwningCube());
        olapLevel.setDimension(this);
        olapLevel.setOptionSet(this.owningCube.getOptionsSet());
        olapLevel.name = levelName = this.getUniqueLevelName(suppliedLevelName);
        olapLevel.changedName = true;
        this.getLevels().add(olapLevel);
        return olapLevel;
    }

    OLAPHierarchy createOLAPHierarchy(Hierarchy inputMetadataObject) {
        OLAPHierarchy olapHierarchy = new OLAPHierarchy(inputMetadataObject);
        olapHierarchy.setDimensionSet(this.getDimensionSet());
        olapHierarchy.setDimension(this);
        olapHierarchy.setOwningCube(this.getOwningCube());
        olapHierarchy.setOptionSet(this.owningCube.getOptionsSet());
        return olapHierarchy;
    }

    public OLAPHierarchy createOLAPHierarchy() throws OLAPException {
        OLAPHierarchy olapHierarchy = new OLAPHierarchy();
        olapHierarchy.setDimensionSet(this.getDimensionSet());
        olapHierarchy.setOwningCube(this.getOwningCube());
        olapHierarchy.setDimension(this);
        olapHierarchy.setOptionSet(this.owningCube.getOptionsSet());
        this.dimensionSet.verifyMaximumHierarchiesPerCube();
        this.dimensionSet.getHierarchies().getTheList().add(olapHierarchy);
        int numberOfHierarchies = this.getHierarchies().size();
        if (numberOfHierarchies < 0) {
            olapHierarchy.setName(this.getName());
        }
        olapHierarchy.setName(this.getUniqueHierarchyName(this.getName()));
        this.getHierarchies().add(olapHierarchy);
        return olapHierarchy;
    }

    public DimensionSet getDimensionSet() {
        return this.dimensionSet;
    }

    public String getUpdateable() throws OLAPException {
        String returnValue = null;
        if (this.updateableDimension == null & this.metadataObject != null & !this.deleteUpdateableDimension) {
            this.updateableDimension = this.optionSet.getOption(this, "NONUPDATEABLE", "OLAPOption");
        }
        if (this.updateableDimension != null) {
            returnValue = this.updateableDimension.getDefaultValue();
        }
        return returnValue;
    }

    public String getUpdateOption() {
        return this.updateOption;
    }

    ClassifierMap getMapClassifierMap() throws OLAPException {
        if (this.mapInfoClassifierMap == null & this.metadataObject != null) {
            try {
                Dimension jomaDimension = (Dimension)this.metadataObject;
                AssociationList classifierMaps = jomaDimension.getTargetClassifierMaps();
                if (classifierMaps.isEmpty()) {
                    classifierMaps = jomaDimension.getTargetTransformations(false);
                }
                if (!classifierMaps.isEmpty()) {
                    for (int i = classifierMaps.size() - 1; i >= 0 && this.mapInfoClassifierMap == null; --i) {
                        Object temp = classifierMaps.elementAt(i);
                        if (temp instanceof ClassifierMap) {
                            this.mapInfoClassifierMap = (ClassifierMap)temp;
                            String transformRole = this.mapInfoClassifierMap.getTransformRole();
                            if (ModelUtilities.trim(transformRole).equalsIgnoreCase("ESRI Map File")) continue;
                            this.mapInfoClassifierMap = null;
                            continue;
                        }
                        this.mapInfoClassifierMap = null;
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 0);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
            }
        }
        return this.mapInfoClassifierMap;
    }

    public OLAPList getLevels() throws OLAPException {
        if (this.levels == null) {
            this.levels = new OLAPList(OLAPLevel.class);
            this.levels.setParentObject(this);
            this.dimensionSet.getLevels();
        }
        return this.levels;
    }

    Option getMLS() throws OLAPException {
        String mlsName = this.getName() + "_mempref";
        if (this.metadataObject != null) {
            this.MLSOption = this.optionSet.getOption(this, mlsName, "OLAP UDT");
        }
        return this.MLSOption;
    }

    public MLSCaptionTable getMLSCaptionTable() throws OLAPException {
        if (this.mlsCaptionTable == null && this.metadataObject != null && !this.deleteCaptionTable) {
            try {
                Dimension jomaDim = (Dimension)this.metadataObject;
                CustomAssociation custom = null;
                AssociationList customs = jomaDim.getCustomAssociations();
                if (!customs.isEmpty()) {
                    int i = 0;
                    int size = customs.size();
                    while (i < size & custom == null) {
                        CustomAssociation nextCustom;
                        CMetadata object = (CMetadata)customs.elementAt(i);
                        if (object.getCMetadataType().equalsIgnoreCase("CustomAssociation") && (nextCustom = (CustomAssociation)object).getPartnerName().equals("CaptionTableObject")) {
                            custom = nextCustom;
                        }
                        ++i;
                    }
                    if (custom != null) {
                        AssociationList associatedObjects = custom.getAssociatedObjects();
                        int t = 0;
                        int aosize = associatedObjects.size();
                        while (t < aosize & this.mlsCaptionTable == null) {
                            CMetadata object = (CMetadata)associatedObjects.elementAt(t);
                            if (object.getCMetadataType().equalsIgnoreCase("PhysicalTable")) {
                                this.mlsCaptionTable = new MLSCaptionTable(this.owningCube.getTableSet(), (PhysicalTable)object, this);
                            }
                            ++t;
                        }
                        if (this.mlsCaptionTable != null) {
                            this.getCaptionTableMemPref();
                        }
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.mlsCaptionTable;
    }

    public OLAPList getHierarchies() throws OLAPException {
        if (this.hierarchies == null) {
            this.hierarchies = new OLAPList(OLAPHierarchy.class);
            this.hierarchies.setParentObject(this);
            this.dimensionSet.getHierarchies();
        }
        return this.hierarchies;
    }

    public String getType() {
        try {
            if (this.type == null & this.metadataObject != null) {
                Dimension dimensionObject = (Dimension)this.metadataObject;
                this.type = dimensionObject.getDimensionType();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.type;
    }

    public String getUniqueName() {
        return "[" + this.getName() + "]";
    }

    public String getUniqueLevelName(String currentName) {
        List listOfLevelNames = this.dimensionSet.getLevelNames();
        boolean found = false;
        int count = 0;
        String currentNameCompare = currentName.toUpperCase();
        Pattern id = Pattern.compile("_[0-9]+");
        Matcher matchId = id.matcher(currentNameCompare);
        currentNameCompare = matchId.replaceAll("");
        int size = listOfLevelNames.size();
        for (int i = 0; i < size; ++i) {
            String name = (String)listOfLevelNames.get(i);
            String nextNameCompare = name.toUpperCase();
            Pattern nextId = Pattern.compile("_[0-9]+");
            Matcher nextMatchId = nextId.matcher(nextNameCompare);
            nextNameCompare = nextMatchId.replaceAll("");
            if (!nextNameCompare.equals(currentNameCompare)) continue;
            ++count;
        }
        int lengthOfCompare = currentNameCompare.length();
        String newName = currentName.substring(0, lengthOfCompare);
        int countIncremented = count;
        do {
            String newNameConcat = newName + "_" + count;
            countIncremented = count;
            int size2 = listOfLevelNames.size();
            for (int i = 0; i < size2 && count == countIncremented; ++i) {
                String nextName = (String)listOfLevelNames.get(i);
                if (!nextName.equalsIgnoreCase(newNameConcat)) continue;
                ++count;
            }
            if (count != countIncremented) continue;
            found = true;
        } while (!found);
        if (count > 0) {
            return newName + "_" + count;
        }
        return currentName;
    }

    public String getUniqueHierarchyName(String currentName) throws OLAPException {
        OLAPList listOfHierarchies = this.dimensionSet.getHierarchies();
        boolean found = false;
        int count = 0;
        String currentNameCompare = currentName.toUpperCase();
        Pattern id = Pattern.compile("_[0-9]+");
        Matcher matchId = id.matcher(currentNameCompare);
        currentNameCompare = matchId.replaceAll("");
        int size = listOfHierarchies.size();
        for (int i = 0; i < size; ++i) {
            OLAPHierarchy hierarchy = (OLAPHierarchy)listOfHierarchies.get(i);
            String nameCompare = hierarchy.getName().toUpperCase();
            if (nameCompare.indexOf(currentNameCompare) != 0) continue;
            ++count;
        }
        int lengthOfCompare = currentNameCompare.length();
        String newName = currentName.substring(0, lengthOfCompare);
        int countIncremented = count;
        do {
            String newNameConcat = newName + "_" + count;
            countIncremented = count;
            int size2 = listOfHierarchies.size();
            for (int i = 0; i < size2 && count == countIncremented; ++i) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)listOfHierarchies.get(i);
                String nextName = hierarchy.getName();
                if (!nextName.equalsIgnoreCase(newNameConcat)) continue;
                ++count;
            }
            if (count != countIncremented) continue;
            found = true;
        } while (!found);
        if (count > 0) {
            return newName + "_" + count;
        }
        return currentName;
    }

    public String getSortOrder() {
        try {
            if (this.sortOrder == null & this.metadataObject != null) {
                Dimension dimensionObject = (Dimension)this.metadataObject;
                this.sortOrder = dimensionObject.getSortOrder();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.sortOrder;
    }

    StringBuffer generateCode() throws OLAPException {
        Integer mlsidValue;
        String desc;
        StringBuffer dimensionStatement = new StringBuffer();
        dimensionStatement.append(ModelUtilities.newline).append(DIMENSION).append(ModelUtilities.getSasName(this.getName()));
        OLAPList listOfDimensionLevels = this.getLevels();
        OLAPList listOfHierarchies = this.getHierarchies();
        if (this.isGeography()) {
            TableCollection collection = this.getMapService();
            String serviceName = null;
            try {
                if (collection != null) {
                    serviceName = collection.getName();
                }
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
            if (serviceName != null) {
                dimensionStatement.append(ModelUtilities.newline).append(MAP_SERVICE).append(serviceName).append("'");
            }
        }
        StringBuffer allHierarchies = new StringBuffer();
        int size = listOfHierarchies.size();
        for (int j = 0; j < size; ++j) {
            OLAPHierarchy hierarchy = (OLAPHierarchy)listOfHierarchies.get(j);
            StringBuffer hierarchyStatement = hierarchy.generateCode();
            allHierarchies.append(hierarchyStatement);
        }
        String caption = this.getDesc();
        if (!ModelUtilities.isBlank(caption)) {
            caption = ModelUtilities.internalQuote(ModelUtilities.trim(caption));
        }
        if (!ModelUtilities.isBlank(desc = this.getNotes())) {
            desc = ModelUtilities.internalQuote(ModelUtilities.trim(desc));
        }
        if (caption.length() > 0) {
            dimensionStatement.append(ModelUtilities.newline).append(CAPTION).append(caption).append("'");
        }
        if (desc.length() > 0) {
            dimensionStatement.append(ModelUtilities.newline).append(DESC).append(desc).append("'");
        }
        String dimType = this.getType();
        String updateable = this.getUpdateable();
        String cubeUpdateable = this.getOwningCube().getUpdateableDimensions();
        if (updateable != null && updateable.equals("1") && (cubeUpdateable == null || cubeUpdateable.equals("0"))) {
            dimensionStatement.append(ModelUtilities.newline).append("   ").append("   NONUPDATEABLE");
        }
        if (!dimType.equals(STANDARD)) {
            dimensionStatement.append(ModelUtilities.newline).append(TYPE).append(dimType);
        }
        dimensionStatement.append(ModelUtilities.newline).append(SORT_ORDER).append(this.getSortOrder());
        if (this.tableSet.isLoadStarSchema()) {
            DimensionTable dimTable = this.getTable();
            SASLibrary libname = dimTable.getSASLibrary();
            StringBuffer dimensionTableName = new StringBuffer();
            try {
                dimensionTableName.append(libname.getLibref()).append(".").append(ModelUtilities.getSasName(dimTable.getSASTableName()));
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            this.getDimensionKey();
            this.getFactKey();
            if (this.dimensionKey != null & this.factKey != null) {
                CharSequence datasetOptions;
                LanguageSet MLS = this.owningCube.getLanguageSet();
                if (MLS.isCubeMultipleLanguageSupported()) {
                    try {
                        datasetOptions = ModelUtilities.internalQuote(this.getTableOptions());
                        dimensionStatement.append(ModelUtilities.newline).append(DIMTABLELIBREF).append(libname.getLibref());
                        dimensionStatement.append(ModelUtilities.newline).append(DIMTABLEMEMPREF).append(ModelUtilities.getSasName(dimTable.getSASTableName()));
                        if (!ModelUtilities.isBlank((String)datasetOptions)) {
                            dimensionStatement.append(ModelUtilities.newline).append(MEMPREFOPTS).append("'").append((String)datasetOptions).append("'");
                        }
                        dimensionStatement.append(ModelUtilities.newline).append(DIMKEY).append(ModelUtilities.getSasName(this.dimensionKey.getSASColumnName()));
                        dimensionStatement.append(ModelUtilities.newline).append(FACTKEY).append(ModelUtilities.getSasName(this.factKey.getSASColumnName()));
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                    }
                } else {
                    datasetOptions = new StringBuffer(this.getTableOptions());
                    if (((StringBuffer)datasetOptions).length() > 0) {
                        ((StringBuffer)datasetOptions).insert(0, "(").append(")");
                    }
                    dimensionTableName.append((StringBuffer)datasetOptions);
                    dimensionStatement.append(ModelUtilities.newline).append(DIMTBL).append(dimensionTableName);
                    dimensionStatement.append(ModelUtilities.newline).append(DIMKEY).append(ModelUtilities.getSasName(this.dimensionKey.getSASColumnName()));
                    dimensionStatement.append(ModelUtilities.newline).append(FACTKEY).append(ModelUtilities.getSasName(this.factKey.getSASColumnName()));
                }
            }
        }
        String emptyCharValue = ModelUtilities.internalQuote(this.getEmptyChar());
        String emptyNumValue = ModelUtilities.internalQuote(this.getEmptyNum());
        String emptyIgnore = this.getIgnoreEmpty();
        if (!ModelUtilities.isBlank(emptyCharValue)) {
            dimensionStatement.append(ModelUtilities.newline).append(EMPTY_CHAR).append("'").append(emptyCharValue).append("'");
        } else if (emptyCharValue != null) {
            dimensionStatement.append(ModelUtilities.newline).append(EMPTY_CHAR).append("' '");
        }
        if (!ModelUtilities.isBlank(emptyNumValue)) {
            dimensionStatement.append(ModelUtilities.newline).append(EMPTY_NUM).append("'").append(emptyNumValue).append("'");
        } else if (emptyNumValue != null) {
            dimensionStatement.append(ModelUtilities.newline).append(EMPTY_NUM).append("' '");
        }
        String captionTableMemPref = this.getCaptionTableMemPref();
        if (!ModelUtilities.isBlank(captionTableMemPref)) {
            dimensionStatement.append(ModelUtilities.newline);
            dimensionStatement.append(DIMTABLECAPPREF).append(ModelUtilities.getSasName(captionTableMemPref));
        }
        if ((mlsidValue = this.getMLSID()) != null) {
            dimensionStatement.append(ModelUtilities.newline);
            dimensionStatement.append(MLSID).append(mlsidValue.toString()).append(ModelUtilities.newline);
        }
        dimensionStatement.append(ModelUtilities.newline).append(HIERARCHIES);
        dimensionStatement.append(ModelUtilities.listFormatter(listOfHierarchies, HIERARCHIES_INDENT, " "));
        dimensionStatement.append(HIERARCHIES_END);
        if (emptyIgnore != null && emptyIgnore.equals("1")) {
            dimensionStatement.append(ModelUtilities.newline).append(IGNORE_EMPTY);
        }
        dimensionStatement.append(";");
        dimensionStatement.append(allHierarchies);
        int size2 = listOfDimensionLevels.size();
        for (int j = 0; j < size2; ++j) {
            OLAPLevel level = (OLAPLevel)listOfDimensionLevels.get(j);
            StringBuffer levelStatement = level.generateCode();
            dimensionStatement.append(levelStatement);
        }
        return dimensionStatement;
    }

    public DimensionTable getTable() throws OLAPException {
        if (this.inputTable == null && this.metadataObject != null) {
            Dimension jomaDimension = (Dimension)this.metadataObject;
            try {
                Column jomaColumn = null;
                AssociationList jomaLevels = jomaDimension.getLevels();
                if (jomaLevels != null && !jomaLevels.isEmpty()) {
                    int i = 0;
                    int iSize = jomaLevels.size();
                    while (i < iSize & jomaColumn == null) {
                        int j;
                        Level levelObject = (Level)jomaLevels.get(i);
                        AssociationList targetFeatureMaps = levelObject.getTargetFeatureMaps();
                        AssociationList targetTransformations = levelObject.getTargetTransformations();
                        ArrayList<Object> featureMaps = new ArrayList<Object>();
                        for (j = targetFeatureMaps.size() - 1; j >= 0; --j) {
                            featureMaps.add(targetFeatureMaps.get(j));
                        }
                        for (j = targetTransformations.size() - 1; j >= 0; --j) {
                            featureMaps.add(targetTransformations.get(j));
                        }
                        j = 0;
                        int size = featureMaps.size();
                        while (j < size & jomaColumn == null) {
                            FeatureMap featureMap = (FeatureMap)featureMaps.get(j);
                            ClassifierMap classifierMap = featureMap.getAssociatedClassifierMap();
                            if (classifierMap.getTransformRole().equalsIgnoreCase("STARDIM") | classifierMap.getName().equalsIgnoreCase("Load Map")) {
                                AssociationList sources = featureMap.getFeatureSources();
                                if (sources.isEmpty()) {
                                    sources = featureMap.getTransformationSources();
                                }
                                if (!sources.isEmpty()) {
                                    jomaColumn = (Column)sources.elementAt(0);
                                }
                            }
                            if (jomaColumn != null) {
                                PhysicalTable jomaTable = (PhysicalTable)jomaColumn.getTable();
                                this.inputTable = this.tableSet.getDimensionTable(jomaTable);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        if (this.inputTable == null && !this.isStarDimension()) {
            LoadTable loadTable = this.tableSet.getLoadTable();
            if (loadTable.table != null) {
                this.inputTable = this.tableSet.getDimensionTable(loadTable.table);
            } else {
                this.inputTable = new DimensionTable(this.tableSet, null);
                this.inputTable.setLoadTable(true);
            }
        }
        return this.inputTable;
    }

    void resetKeyColumns(LoadTable loadTable, PhysicalTable inputTable) throws OLAPException {
        this.dimensionUniqueKey = null;
        if (this.factKey != null) {
            try {
                AssociationList uniqueKeys;
                Column jomaColumn = this.factKey.metadataObject;
                String name = jomaColumn.getColumnName();
                OLAPColumn newFactKey = loadTable.getColumn(name);
                Column jomaFactKey = newFactKey.metadataObject;
                this.setFactKey(newFactKey);
                if (!this.owningCube.isNewObject() && !(uniqueKeys = inputTable.getUniqueKeys(false)).isEmpty()) {
                    UniqueKey uniqueKey = null;
                    for (int i = uniqueKeys.size() - 1; i >= 0 && uniqueKey == null; --i) {
                        OLAPColumn column;
                        AssociationList listOfColumns;
                        boolean keyedColumnMatch;
                        ForeignKey foreignKey;
                        AssociationList keyedColumns;
                        uniqueKey = (UniqueKey)uniqueKeys.get(i);
                        AssociationList foreignKeys = uniqueKey.getForeignKeys(false);
                        if (foreignKeys.isEmpty() || (keyedColumns = (foreignKey = (ForeignKey)foreignKeys.get(0)).getKeyedColumns(false)).isEmpty()) continue;
                        Column keyedColumn = (Column)keyedColumns.get(0);
                        boolean bl = keyedColumnMatch = keyedColumn == jomaFactKey;
                        if (!keyedColumnMatch || (listOfColumns = uniqueKey.getKeyedColumns(false)).isEmpty()) continue;
                        DimensionTable inTable = this.tableSet.getDimensionTable(inputTable);
                        this.dimensionKey = column = inTable.getColumn((Column)listOfColumns.elementAt(0));
                    }
                }
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            catch (MdException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        }
    }

    public void removeDimensionIds() throws OLAPException {
        this.setMLSID(null);
        OLAPList hiers = this.getHierarchies();
        for (int hierNum = 0; hierNum < hiers.size(); ++hierNum) {
            OLAPHierarchy hier = (OLAPHierarchy)hiers.get(hierNum);
            hier.setMLSID(null);
            hier.setAllMemberMLSID(null);
        }
        OLAPList levels = this.getLevels();
        for (int levNum = 0; levNum < levels.size(); ++levNum) {
            OLAPLevel level = (OLAPLevel)levels.get(levNum);
            level.setMLSID(null);
            OLAPList mbrProps = level.getOLAPProperties();
            for (int propNum = 0; propNum < mbrProps.size(); ++propNum) {
                OLAPMemberProperty prop = (OLAPMemberProperty)mbrProps.get(propNum);
                prop.setMLSID(null);
            }
        }
        DefinedMemberSet definedMembers = this.getOwningCube().getDefinedMemberSet();
        OLAPList dimsDefinedMbrs = definedMembers.getCalculatedMembersByDimension(this);
        for (int defNum = 0; defNum < dimsDefinedMbrs.size(); ++defNum) {
            OLAPDefinedMember mbr = (OLAPDefinedMember)dimsDefinedMbrs.get(defNum);
            mbr.setMLSID(null);
        }
    }

    public OLAPColumn getFactKey() throws OLAPException {
        this.getTable();
        if (this.inputTable != null && this.inputTable.getTable() != null) {
            if (!this.inputTable.metadataRetrieved) {
                this.inputTable.getMetadata();
            }
            this.factTable = this.tableSet.getLoadTable();
            if (!this.inputTable.equals(this.factTable) & this.factKey == null & this.metadataObject != null) {
                try {
                    CustomAssociation factCustom = null;
                    Dimension dimensionObject = (Dimension)this.metadataObject;
                    AssociationList customs = dimensionObject.getCustomAssociations(false);
                    if (!customs.isEmpty()) {
                        int i = 0;
                        int size = customs.size();
                        while (i < size & factCustom == null) {
                            CustomAssociation nextCustom;
                            CMetadata object = (CMetadata)customs.elementAt(i);
                            if (object.getCMetadataType().equalsIgnoreCase("CustomAssociation") && (nextCustom = (CustomAssociation)object).getPartnerName().equals(FACTKEYDIMENSION)) {
                                factCustom = nextCustom;
                            }
                            ++i;
                        }
                        AssociationList associatedObjects = factCustom.getAssociatedObjects(false);
                        int t = 0;
                        int aosize = associatedObjects.size();
                        while (t < aosize & this.factKey == null) {
                            CMetadata column = (CMetadata)associatedObjects.elementAt(t);
                            if (column.getCMetadataType().equalsIgnoreCase("Column")) {
                                this.factKey = this.factTable.getColumn((Column)column);
                            }
                            ++t;
                        }
                    } else {
                        Column metaColumn = null;
                        if (this.dimensionUniqueKey == null) {
                            this.getDimensionKey();
                        }
                        LoadTable loadTable = this.tableSet.getLoadTable();
                        if (this.dimensionUniqueKey != null && loadTable.table != null) {
                            AssociationList foreignKeys = this.tableSet.getLoadTable().getForeignKeys();
                            int j = 0;
                            int size = foreignKeys.size();
                            while (j < size & metaColumn == null) {
                                UniqueKey uniqueKey;
                                ForeignKey foreignKey = (ForeignKey)foreignKeys.elementAt(j);
                                if (foreignKey != null && (uniqueKey = foreignKey.getPartnerUniqueKey()) != null && uniqueKey.equals((Object)this.dimensionUniqueKey)) {
                                    metaColumn = (Column)foreignKey.getKeyedColumns(false).elementAt(0);
                                }
                                ++j;
                            }
                            if (metaColumn == null) {
                                this.dimensionVerifyMessage = this.verifyStarSchemaKeys();
                            } else {
                                this.tableSet.getLoadTable();
                                this.factKey = this.factTable.getColumn(metaColumn);
                            }
                        }
                    }
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        return this.factKey;
    }

    public PhysicalTable getAddDataTable() throws OLAPException {
        DimensionTable dimTable;
        if (this.addDataTable == null && (dimTable = this.getTable()) != null) {
            this.addDataTable = dimTable.getTable();
            this.setAddDataTableName(ModelUtilities.generateTableName(this.addDataTable));
        }
        return this.addDataTable;
    }

    public String getAddDataTableName() {
        if (this.addDataTableName == null) {
            return "";
        }
        return this.addDataTableName;
    }

    public String getAddDataTableOptions() {
        if (this.addDataTableOptions == null) {
            return "";
        }
        return this.addDataTableOptions;
    }

    public String getCaptionTableMemPref() throws OLAPException {
        String returnValue = null;
        if (this.optionSet == null) {
            this.owningCube.getOptionsSet();
        }
        if (this.captionPref == null && this.metadataObject != null && !this.deleteCaptionPref) {
            this.captionPref = this.optionSet.getOption(this, this.getName() + "_cappref", "OLAP UDT");
        }
        if (this.captionPref != null) {
            returnValue = this.captionPref.getDefaultValue();
        }
        return returnValue;
    }

    public OLAPHierarchy getDefault() throws OLAPException {
        OLAPList allHierarchies;
        if (this.defaultHierarchy == null && (allHierarchies = this.getHierarchies()) != null && allHierarchies.size() > 0) {
            this.defaultHierarchy = (OLAPHierarchy)allHierarchies.get(0);
        }
        return this.defaultHierarchy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OLAPColumn getDimensionKey() throws OLAPException {
        this.getTable();
        if (this.inputTable == null) {
            if (!Workspace.isDebug()) throw new IllegalStateException("Illegal use of the getDimensionKey method was encountered.");
            Workspace.getDefaultLogger().debug((Object)"Cannot get the dimension key without a dimension table.");
            throw new IllegalStateException("Illegal use of the getDimensionKey method was encountered.");
        }
        if (!this.inputTable.metadataRetrieved) {
            this.inputTable.getMetadata();
        }
        this.factTable = this.tableSet.getLoadTable();
        if (this.inputTable.equals(this.factTable)) return this.dimensionKey;
        if (this.dimensionKey == null && this.metadataObject != null) {
            Dimension dimensionObject = (Dimension)this.metadataObject;
            try {
                CustomAssociation custom = null;
                AssociationList customs = dimensionObject.getCustomAssociations(false);
                if (!customs.isEmpty()) {
                    int i = 0;
                    int size = customs.size();
                    while (i < size & custom == null) {
                        CustomAssociation nextCustom;
                        CMetadata object = (CMetadata)customs.elementAt(i);
                        if (object.getCMetadataType().equalsIgnoreCase("CustomAssociation") && (nextCustom = (CustomAssociation)object).getPartnerName().equals(DIMKEYDIMENSION)) {
                            custom = nextCustom;
                        }
                        ++i;
                    }
                    AssociationList associatedObjects = custom.getAssociatedObjects(false);
                    int t = 0;
                    int aosize = associatedObjects.size();
                    while (t < aosize & this.dimensionKey == null) {
                        CMetadata column = (CMetadata)associatedObjects.elementAt(t);
                        if (column.getCMetadataType().equalsIgnoreCase("Column")) {
                            this.dimensionKey = this.inputTable.getColumn((Column)column);
                        }
                        ++t;
                    }
                } else {
                    AssociationList transformations = dimensionObject.getTargetTransformations(false);
                    Column key = null;
                    int i = transformations.size() - 1;
                    while (i >= 0 & this.foundKeyObjectTransformation == null) {
                        CMetadata object = (CMetadata)transformations.elementAt(i);
                        if (object.getCMetadataType().equalsIgnoreCase("Transformation")) {
                            this.foundKeyObjectTransformation = (Transformation)object;
                            AssociationList transformationSources = this.foundKeyObjectTransformation.getTransformationSources(false);
                            if (transformationSources.size() == 1) {
                                this.dimensionUniqueKey = (UniqueKey)transformationSources.elementAt(0);
                                AssociationList keyedColumns = this.dimensionUniqueKey.getKeyedColumns(false);
                                if (keyedColumns.size() == 1) {
                                    key = (Column)keyedColumns.elementAt(0);
                                    this.dimensionKey = this.inputTable.getColumn(key);
                                    this.convertKeyObjects = true;
                                }
                            }
                        }
                        --i;
                    }
                }
                if (this.dimensionKey != null) return this.dimensionKey;
                this.dimensionVerifyMessage = this.verifyStarSchemaKeys();
                return this.dimensionKey;
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
                return this.dimensionKey;
            }
        }
        if (this.dimensionKey != null && (this.previousInputTable == null || this.previousInputTable.equals(this.inputTable))) return this.dimensionKey;
        this.calculateStarSchemaKeys();
        return this.dimensionKey;
    }

    public String getEmptyChar() throws OLAPException {
        String returnValue = null;
        if (this.emptyChar == null & this.metadataObject != null & !this.deleteEmptyChar) {
            this.emptyChar = this.optionSet.getOption(this, "EMPTY_CHAR", "OLAPOption");
        }
        if (this.emptyChar != null) {
            returnValue = this.emptyChar.getDefaultValue();
        }
        return returnValue;
    }

    public String getEmptyNum() throws OLAPException {
        String returnValue = null;
        if (this.emptyNum == null & this.metadataObject != null & !this.deleteEmptyNum) {
            this.emptyNum = this.optionSet.getOption(this, "EMPTY_NUM", "OLAPOption");
        }
        if (this.emptyNum != null) {
            returnValue = this.emptyNum.getDefaultValue();
        }
        return returnValue;
    }

    public String getIgnoreEmpty() throws OLAPException {
        String returnValue = null;
        if (this.ignoreEmpty == null & this.metadataObject != null & !this.deleteIgnoreEmpty) {
            this.ignoreEmpty = this.optionSet.getOption(this, "IGNORE_EMPTY", "OLAPOption");
        }
        if (this.ignoreEmpty != null) {
            returnValue = this.ignoreEmpty.getDefaultValue();
        }
        return returnValue;
    }

    public String getTableOptions() throws OLAPException {
        String returnValue = "";
        if (this.tableOptions == null & this.metadataObject != null & !this.deleteTableOptions) {
            this.tableOptions = this.optionSet.getOption(this, "DimensionTable_options", "OLAP Table Options");
            if (this.tableOptions == null) {
                this.tableOptions = this.optionSet.getOption(this, this.getName() + "_options", "OLAP Table Options");
            }
        }
        if (this.tableOptions != null) {
            returnValue = this.tableOptions.getDefaultValue();
        }
        return returnValue;
    }

    private void calculateStarSchemaKeys() throws OLAPException {
        if (this.factTable != null && !this.inputTable.equals(this.factTable)) {
            try {
                PhysicalTable physicalTable = this.factTable.getTable();
                PhysicalTable dimPhysicalTable = this.inputTable.getTable();
                AssociationList foreignKeys = physicalTable.getForeignKeys(false);
                boolean found = false;
                int i = 0;
                int size = foreignKeys.size();
                while (i < size & !found) {
                    PhysicalTable uniqueTable;
                    ForeignKey foreignKey = (ForeignKey)foreignKeys.get(i);
                    UniqueKey uniqueKey = foreignKey.getPartnerUniqueKey();
                    if (uniqueKey != null && (uniqueTable = (PhysicalTable)uniqueKey.getTable()) != null && uniqueTable.equals((Object)dimPhysicalTable)) {
                        found = true;
                        this.dimensionKey = this.inputTable.getColumn((Column)uniqueKey.getKeyedColumns(false).elementAt(0));
                        this.factKey = this.factTable.getColumn((Column)foreignKey.getKeyedColumns(false).elementAt(0));
                    }
                    ++i;
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            if (this.dimensionKey == null || this.factKey == null) {
                OLAPList dimensionColumns = this.inputTable.getColumns();
                OLAPList factColumns = this.factTable.getColumns();
                boolean found = false;
                int i = 0;
                int size = dimensionColumns.size();
                while (i < size & !found) {
                    OLAPColumn column = (OLAPColumn)dimensionColumns.get(i);
                    String columnName = column.getSASColumnName();
                    found = false;
                    int t = 0;
                    int sizeFact = factColumns.size();
                    while (t < sizeFact & !found) {
                        OLAPColumn factColumn = (OLAPColumn)factColumns.get(t);
                        if (columnName.equalsIgnoreCase(factColumn.getSASColumnName())) {
                            found = true;
                            this.dimensionKey = column;
                            this.factKey = factColumn;
                        }
                        ++t;
                    }
                    ++i;
                }
            }
        }
    }

    public boolean isStandard() {
        return this.type == null || this.type.equals(STANDARD);
    }

    public boolean isTime() {
        return this.type != null && this.type.equals(TIME);
    }

    public boolean isMeasure() {
        return this.type != null && this.type.equals(MEASURES);
    }

    public boolean isGeography() {
        return this.type != null && this.type.equals(GEO);
    }

    public boolean isUpdateable() throws OLAPException {
        String updateOption = this.getUpdateable();
        return updateOption == null || updateOption.equals("0");
    }

    public boolean isOnlyShared() {
        return this.onlyShared;
    }

    public boolean isShared() {
        return this.shared;
    }

    public boolean isSimilar(PhysicalTable table) throws OLAPException {
        boolean similar;
        boolean bl = similar = this.getTable() != null;
        if (similar) {
            similar = this.inputTable.isSimilar(this, table);
        }
        return similar;
    }

    public boolean isStarDimension() throws OLAPException {
        if (this.isStarDimension == null) {
            this.isStarDimension = Boolean.FALSE;
            if (this.tableSet.isLoadStarSchema() && this.metadataObject != null) {
                try {
                    AssociationList customs = this.metadataObject.getCustomAssociations(false);
                    boolean found = false;
                    int size = customs.size();
                    for (int i = 0; i < size && !found; ++i) {
                        CMetadata object = (CMetadata)customs.elementAt(i);
                        if (!object.getCMetadataType().equalsIgnoreCase("CustomAssociation")) continue;
                        CustomAssociation nextCustom = (CustomAssociation)object;
                        String partnerName = nextCustom.getPartnerName();
                        found = partnerName.equalsIgnoreCase(DIMKEYDIMENSION) || partnerName.equalsIgnoreCase(FACTKEYDIMENSION);
                    }
                    this.isStarDimension = found;
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        return this.isStarDimension;
    }

    @Override
    public boolean isMetadataUpdated() {
        if (!this.changedMetadata) {
            this.changedMetadata = super.isMetadataUpdated();
        }
        return this.changedMetadata;
    }

    public void setIgnoreEmpty(String optionValue) throws OLAPException {
        if (optionValue != null && optionValue.equals("1")) {
            this.deleteIgnoreEmpty = false;
            this.getIgnoreEmpty();
            if (this.ignoreEmpty == null) {
                this.ignoreEmpty = new Option(this.optionSet, this);
                this.ignoreEmpty.setName("IGNORE_EMPTY");
                this.ignoreEmpty.setDesc("IGNORE_EMPTY");
                this.ignoreEmpty.setPropertyName("IGNORE_EMPTY");
                this.ignoreEmpty.setPropertyRole("OLAPOption");
                this.ignoreEmpty.setOwningType(OptionSet.OWNING_TYPE_BOOLEAN);
            }
            this.ignoreEmpty.setDefaultValue(optionValue);
        } else if (this.ignoreEmpty != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.ignoreEmpty) >= 0) {
                objectOptions.remove(this.ignoreEmpty);
            }
            this.ignoreEmpty = null;
            this.deleteIgnoreEmpty = true;
        }
        this.changedMetadata = true;
        this.setUpChanges("setIgnoreEmpty", String.class, optionValue);
    }

    void setMLS(String optionValue) {
        if (optionValue != null) {
            this.deleteMLS = false;
            if (this.MLSOption == null) {
                this.MLSOption = new Option(this.optionSet, this);
                String languageName = this.getName() + "_mempref";
                this.MLSOption.setName(languageName);
                this.MLSOption.setPropertyName(languageName);
                this.MLSOption.setPropertyRole("OLAP UDT");
                this.MLSOption.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.MLSOption.setDefaultValue(optionValue);
        } else if (this.MLSOption != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.MLSOption) >= 0) {
                objectOptions.remove(this.MLSOption);
            }
            this.MLSOption = null;
            this.deleteMLS = true;
        }
        this.setUpChanges("setMLS", String.class, optionValue);
    }

    public void setMLSCaptionTable(MLSCaptionTable table) {
        this.mlsCaptionTable = table;
        this.changedMetadata = true;
        if (table != null) {
            this.setCaptionTableMemPref(table.getSASTableName());
            this.deleteCaptionTable = false;
        } else {
            this.setCaptionTableMemPref(null);
            this.deleteCaptionTable = true;
        }
        this.setUpChanges("setMLSCaptionTable", MLSCaptionTable.class, table);
    }

    public void setEmptyChar(String optionValue) throws OLAPException {
        if (optionValue != null) {
            this.deleteEmptyChar = false;
            if (this.emptyChar == null) {
                this.emptyChar = new Option(this.optionSet, this);
                this.emptyChar.setName("EMPTY_CHAR");
                this.emptyChar.setDesc("EMPTY_CHAR");
                this.emptyChar.setPropertyName("EMPTY_CHAR");
                this.emptyChar.setPropertyRole("OLAPOption");
                this.emptyChar.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.emptyChar.setDefaultValue(optionValue);
        } else if (this.emptyChar != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.emptyChar) >= 0) {
                objectOptions.remove(this.emptyChar);
            }
            this.emptyChar = null;
            this.deleteEmptyChar = true;
        }
        this.changedMetadata = true;
        this.setUpChanges("setEmptyChar", String.class, optionValue);
    }

    public void setEmptyNum(String optionValue) throws OLAPException {
        if (optionValue != null) {
            this.deleteEmptyNum = false;
            if (this.emptyNum == null) {
                this.emptyNum = new Option(this.optionSet, this);
                this.emptyNum.setName("EMPTY_NUM");
                this.emptyNum.setDesc("EMPTY_NUM");
                this.emptyNum.setPropertyName("EMPTY_NUM");
                this.emptyNum.setPropertyRole("OLAPOption");
                this.emptyNum.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.emptyNum.setDefaultValue(optionValue);
        } else if (this.emptyNum != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.emptyNum) >= 0) {
                objectOptions.remove(this.emptyNum);
            }
            this.emptyNum = null;
            this.deleteEmptyNum = true;
        }
        this.changedMetadata = true;
        this.setUpChanges("setEmptyNum", String.class, optionValue);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.checkVerifyName = false;
        if (this.isUndo()) {
            this.setUpChanges("setName", String.class, name);
        }
    }

    @Override
    public void setNotes(String notes) {
        super.setNotes(notes);
        this.setUpChanges("setNotes", String.class, notes);
    }

    public void setType(String inputType) {
        this.type = inputType;
        this.changedMetadata = true;
        this.checkDimensionType = this.type.equals(STANDARD);
        this.setUpChanges("setType", String.class, inputType);
    }

    public void setSortOrder(String inputSortOrder) {
        this.sortOrder = inputSortOrder;
        this.changedMetadata = true;
        this.setUpChanges("setSortOrder", String.class, inputSortOrder);
    }

    public void setTable(DimensionTable table) {
        this.previousInputTable = this.inputTable;
        this.inputTable = table;
        this.changedMetadata = true;
        this.checkDimensionTable = false;
        this.setUpChanges("setTable", DimensionTable.class, table);
    }

    public void setFactKey(OLAPColumn inputFactKey) {
        this.isStarDimension = inputFactKey != null ? Boolean.TRUE : Boolean.FALSE;
        this.factKey = inputFactKey;
        this.changedMetadata = true;
        this.checkDimensionFactKey = false;
        this.setUpChanges("setFactKey", OLAPColumn.class, inputFactKey);
    }

    @Override
    public void setDesc(String inputDesc) {
        super.setDesc(inputDesc);
        this.setUpChanges("setDesc", String.class, inputDesc);
    }

    public void setUpdateOption(String typeOfUpdateOption) {
        this.updateOption = typeOfUpdateOption;
    }

    public void setAddDataTable(PhysicalTable inputTable) throws OLAPException {
        this.addDataTable = inputTable;
        this.setAddDataTableName(ModelUtilities.generateTableName(this.addDataTable));
    }

    void setAddDataTableName(String inputTable) {
        this.addDataTableName = inputTable;
    }

    public void setAddDataTableOptions(String inputOptions) {
        this.addDataTableOptions = inputOptions;
    }

    public void setCaptionTableMemPref(String optionValue) {
        if (optionValue != null) {
            if (this.optionSet == null) {
                this.owningCube.getOptionsSet();
            }
            this.deleteCaptionPref = false;
            if (this.captionPref == null) {
                this.captionPref = new Option(this.optionSet, this);
                this.captionPref.setName(this.getName() + "_cappref");
                this.captionPref.setDesc(this.getName() + "_cappref");
                this.captionPref.setPropertyName(this.getName() + "_cappref");
                this.captionPref.setPropertyRole("OLAP UDT");
                this.captionPref.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.captionPref.setDefaultValue(optionValue);
        } else if (this.captionPref != null) {
            List objectOptions = this.optionSet.getOptions(this);
            objectOptions.remove(this.captionPref);
            this.captionPref = null;
            this.deleteCaptionPref = true;
        }
    }

    public void setDefault(OLAPHierarchy inHierarchy) {
        this.defaultHierarchy = inHierarchy;
        this.changedMetadata = true;
        this.setUpChanges("setDefault", OLAPHierarchy.class, inHierarchy);
    }

    public void setDimensionKey(OLAPColumn inputKey) {
        this.isStarDimension = inputKey != null ? Boolean.TRUE : Boolean.FALSE;
        this.dimensionKey = inputKey;
        this.changedMetadata = true;
        this.checkDimensionKey = false;
        this.setUpChanges("setDimensionKey", OLAPColumn.class, inputKey);
    }

    public void setTableOptions(String optionValue) throws OLAPException {
        if (optionValue != null & !ModelUtilities.isBlank(optionValue)) {
            this.deleteTableOptions = false;
            this.getTableOptions();
            if (this.tableOptions == null) {
                this.tableOptions = new Option(this.optionSet, this);
                this.tableOptions.setName("DimensionTable_options");
                this.tableOptions.setDesc("OLAP Table Options");
                this.tableOptions.setPropertyName("DimensionTable_options");
                this.tableOptions.setPropertyRole("OLAP Table Options");
                this.tableOptions.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.tableOptions.setDefaultValue(optionValue);
        } else if (this.tableOptions != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.tableOptions) >= 0) {
                objectOptions.remove(this.tableOptions);
            }
            this.tableOptions = null;
            this.deleteTableOptions = true;
        }
        this.changedMetadata = true;
        this.setUpChanges("setTableOptions", String.class, optionValue);
    }

    public void setUpdateable(String optionValue) throws OLAPException {
        if (optionValue != null && optionValue.equals("1")) {
            this.deleteUpdateableDimension = false;
            this.getUpdateable();
            if (this.updateableDimension == null) {
                this.updateableDimension = new Option(this.optionSet, this);
                this.updateableDimension.setName("NONUPDATEABLE");
                this.updateableDimension.setDesc("NONUPDATEABLE");
                this.updateableDimension.setPropertyName("NONUPDATEABLE");
                this.updateableDimension.setPropertyRole("OLAPOption");
                this.updateableDimension.setOwningType(OptionSet.OWNING_TYPE_BOOLEAN);
            }
            this.updateableDimension.setDefaultValue(optionValue);
        } else if (this.updateableDimension != null && optionValue.equals("0")) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.updateableDimension) >= 0) {
                objectOptions.remove(this.updateableDimension);
            }
            this.updateableDimension = null;
            this.deleteUpdateableDimension = true;
        }
        this.changedMetadata = true;
        this.setUpChanges("setDimensionUpdateable", String.class, optionValue);
    }

    private StringBuffer verifyStarSchemaKeys() throws OLAPException {
        if (!this.factTable.equals(this.inputTable)) {
            if (this.dimensionKey == null || this.factKey == null) {
                this.calculateStarSchemaKeys();
            }
            if (this.dimensionKey == null || this.factKey == null) {
                this.dimensionVerifyMessage.append(bundle.formatString("OLAPDimension.MissingKey.fmt.txt", (Object)this.getName()));
            }
        }
        return this.dimensionVerifyMessage;
    }

    public void delete() throws OLAPException {
        this.dimensionSet.getCubeDimensions().remove(this);
        this.getLevels();
        for (int i = this.levels.size() - 1; i > -1; --i) {
            OLAPLevel level = (OLAPLevel)this.levels.get(i);
            level.delete();
        }
        this.setDeleted(true);
    }

    void updateDimensionMetadata() throws OLAPException {
        boolean newObject = false;
        if (!this.checkVerifyName) {
            this.verifyName();
        }
        if (this.isStarDimension()) {
            if (!this.checkDimensionTable) {
                this.verifyStarSchemaTable();
            }
            if (!this.inputTable.table.equals((Object)this.tableSet.getLoadTable().table)) {
                if (!this.checkDimensionKey) {
                    this.verifyStarSchemaKey();
                }
                if (!this.checkDimensionFactKey) {
                    this.verifyFactKey();
                }
            }
        }
        this.verifyLevelsList();
        this.verifyHierarchyList();
        this.verifyAllLevelsUsed();
        if (!this.checkDimensionType) {
            if (this.isTime()) {
                this.verifyUniqueTimeDimension();
            } else {
                this.verifyUniqueGeoDimension();
            }
        }
        if (this.metadataObject == null) {
            newObject = true;
            this.metadataObject = (Dimension)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Dimension", this.owningCube.getRepositoryShortFQID());
        }
        Dimension dimensionObject = (Dimension)this.metadataObject;
        try {
            OLAPHierarchy defaultHierarchy;
            int whereIsHierarchy;
            dimensionObject.setPublicType("Dimension");
            UsageVersion usageVersion = new UsageVersion(Integer.parseInt("4"), Integer.parseInt("0"), Integer.parseInt("0"));
            dimensionObject.setUsageVersion(usageVersion.encode());
            dimensionObject.setUniqueName("[" + this.getName() + "]");
            this.updateMetadata();
            this.getSortOrder();
            if (ModelUtilities.isBlank(this.sortOrder)) {
                this.sortOrder = "ASCENDING";
            }
            dimensionObject.setSortOrder(this.sortOrder);
            if (this.getType() == null || ModelUtilities.isBlank(this.type)) {
                this.type = STANDARD;
            }
            dimensionObject.setDimensionType(this.type);
            if (this.hierarchies.size() > 1 && (whereIsHierarchy = this.hierarchies.indexOf(defaultHierarchy = this.getDefault())) > 0) {
                this.hierarchies.getTheList().remove(whereIsHierarchy);
                this.hierarchies.getTheList().add(0, defaultHierarchy);
            }
            if (this.isStarDimension()) {
                this.updateStarDimension();
            }
            this.updateOptionsMetadata();
            if (this.isGeography()) {
                this.updateMapInfo();
            }
            Cube jomaCube = (Cube)this.owningCube.metadataObject;
            AssociationList dimensions = jomaCube.getDimensions();
            if (newObject) {
                dimensions.addElement((Object)this.metadataObject);
            }
            if (newObject && jomaCube.getAggregations().size() > 0) {
                this.aggregationSet = this.owningCube.getAggregationSet();
                this.aggregationSet.resetLevels();
            }
            this.getMLSCaptionTable();
            if (this.mlsCaptionTable != null) {
                this.mlsCaptionTable.updateMetadata();
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    void updateOptionsMetadata() throws OLAPException {
        if (this.optionSet != null) {
            try {
                Property property;
                int i;
                List options = this.optionSet.getOptions(this);
                HashMap<String, Object> metadataOptions = new HashMap<String, Object>();
                AssociationList properties = this.metadataObject.getProperties(false);
                int size = options.size();
                for (i = 0; i < size; ++i) {
                    Option option = (Option)options.get(i);
                    option.updateMetadata();
                }
                size = properties.size();
                for (i = 0; i < size; ++i) {
                    Property property2 = (Property)properties.elementAt(i);
                    metadataOptions.put(property2.getPropertyName(), property2);
                }
                int metadataVersion = Workspace.getMetadataServerVersionNumber();
                if (metadataVersion >= 9200) {
                    AssociationList customs = this.metadataObject.getCustomAssociations(false);
                    int size2 = customs.size();
                    for (int i2 = 0; i2 < size2; ++i2) {
                        CustomAssociation custom = (CustomAssociation)customs.elementAt(i2);
                        metadataOptions.put(custom.getPartnerName(), custom);
                    }
                }
                if (this.deleteIgnoreEmpty & this.ignoreEmpty == null && (property = (Property)metadataOptions.get("IGNORE_EMPTY")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteEmptyChar & this.emptyChar == null && (property = (Property)metadataOptions.get("EMPTY_CHAR")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteEmptyNum & this.emptyNum == null && (property = (Property)metadataOptions.get("EMPTY_NUM")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteTableOptions & this.tableOptions == null) {
                    property = (Property)metadataOptions.get(this.getName() + "_options");
                    if (property == null) {
                        property = (Property)metadataOptions.get("DimensionTable_options");
                    }
                    if (property != null && property.getPropertyRole().equals("OLAP Table Options")) {
                        MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                    }
                }
                if (this.deleteMLS & this.MLSOption == null && (property = (Property)metadataOptions.get(this.getName() + "_mempref")) != null && property.getPropertyRole().equals("OLAP UDT")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteUpdateableDimension & this.updateableDimension == null && (property = (Property)metadataOptions.get("NONUPDATEABLE")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteCaptionTable & this.mlsCaptionTable == null) {
                    Property property3;
                    CMetadata custom = (CMetadata)metadataOptions.get("CaptionTableObject");
                    if (custom != null) {
                        MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), custom, "", bundle.getString("MdException.GenericError.txt"));
                    }
                    if ((property3 = (Property)metadataOptions.get(this.getName() + "_cappref")) == null && custom != null) {
                        boolean found = false;
                        Iterator i3 = metadataOptions.keySet().iterator();
                        while (i3.hasNext() && !found) {
                            String optionName = (String)i3.next();
                            if (optionName.indexOf("_cappref") <= 0) continue;
                            found = true;
                            property3 = (Property)metadataOptions.get(optionName);
                        }
                    }
                    if (property3 != null) {
                        MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property3, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
    }

    private void updateStarDimension() throws OLAPException {
        try {
            if (this.dimensionKey != null) {
                ClassifierMap classifierMap;
                Dimension dimensionObject = (Dimension)this.metadataObject;
                if (this.foundKeyObjectTransformation != null & this.convertKeyObjects) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)this.foundKeyObjectTransformation, "", bundle.getString("MdException.GenericError.txt"));
                }
                if ((classifierMap = this.inputTable.getClassifierMap()) == null) {
                    classifierMap = this.inputTable.createClassifierMap();
                }
                CustomAssociation dimCustom = null;
                CustomAssociation factCustom = null;
                AssociationList listOfCustomAssociations = dimensionObject.getCustomAssociations(false);
                int size = listOfCustomAssociations.size();
                for (int i = 0; i < size; ++i) {
                    CMetadata object = (CMetadata)listOfCustomAssociations.elementAt(i);
                    if (!object.getCMetadataType().equalsIgnoreCase("CustomAssociation")) continue;
                    CustomAssociation nextCustom = (CustomAssociation)object;
                    if (nextCustom.getPartnerName().equals(DIMKEYDIMENSION)) {
                        dimCustom = nextCustom;
                        continue;
                    }
                    if (!nextCustom.getPartnerName().equals(FACTKEYDIMENSION)) continue;
                    factCustom = nextCustom;
                }
                if (dimCustom == null) {
                    dimCustom = (CustomAssociation)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "CustomAssociation", this.getRepositoryShortFQID());
                    dimCustom.setName(this.getName() + "_" + DIMKEYCA);
                    dimCustom.setisOwned(0);
                    dimCustom.setPartnerName(DIMKEYDIMENSION);
                    listOfCustomAssociations.add((Object)dimCustom);
                }
                if (factCustom == null) {
                    factCustom = (CustomAssociation)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "CustomAssociation", this.getRepositoryShortFQID());
                    factCustom.setName(this.getName() + "_" + FACTKEYCA);
                    factCustom.setisOwned(0);
                    factCustom.setPartnerName(FACTKEYDIMENSION);
                    listOfCustomAssociations.add((Object)factCustom);
                }
                AssociationList dimAssociatedObjects = dimCustom.getAssociatedObjects(false);
                for (int t = dimAssociatedObjects.size() - 1; t > -1; --t) {
                    CMetadata nextItem = (CMetadata)dimAssociatedObjects.elementAt(t);
                    if (nextItem.getCMetadataType().equalsIgnoreCase("Column")) {
                        Column nextColumn = (Column)nextItem;
                        dimAssociatedObjects.remove((Object)nextColumn);
                    }
                    if (!nextItem.getCMetadataType().equalsIgnoreCase("PhysicalTable")) continue;
                    PhysicalTable nextTable = (PhysicalTable)nextItem;
                    dimAssociatedObjects.remove((Object)nextTable);
                }
                this.getTable();
                dimAssociatedObjects.add((Object)this.dimensionKey.metadataObject);
                dimAssociatedObjects.add((Object)this.inputTable.getTable());
                AssociationList factAssociatedObjects = factCustom.getAssociatedObjects(false);
                for (int t = factAssociatedObjects.size() - 1; t > -1; --t) {
                    CMetadata nextItem = (CMetadata)factAssociatedObjects.elementAt(t);
                    if (!nextItem.getCMetadataType().equalsIgnoreCase("Column")) continue;
                    Column nextColumn = (Column)nextItem;
                    factAssociatedObjects.remove((Object)nextColumn);
                }
                factAssociatedObjects.add((Object)this.factKey.metadataObject);
            }
            LanguageSet languageSet = this.owningCube.getLanguageSet();
            this.MLSOption = this.getMLS();
            if (languageSet.isCubeMultipleLanguageSupported() && this.MLSOption == null) {
                this.setMLS(this.getTable().getSASTableName());
            } else if (!languageSet.isCubeMultipleLanguageSupported() && this.MLSOption != null) {
                this.setMLS(null);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    void updateMapInfo() throws OLAPException {
        if (this.mapServer == null) {
            this.getMapServer();
        }
        if (this.mapService == null) {
            this.getMapService();
        }
        if (this.mapServer != null && this.mapService != null) {
            try {
                this.getMapClassifierMap();
                Dimension jomaDimension = (Dimension)this.metadataObject;
                AssociationList targetClassifierMaps = jomaDimension.getTargetClassifierMaps();
                AssociationList targetTransformations = jomaDimension.getTargetTransformations();
                if (this.mapInfoClassifierMap == null) {
                    this.mapInfoClassifierMap = !this.isShared() ? (ClassifierMap)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "ClassifierMap", this.owningCube.getRepositoryShortFQID()) : (ClassifierMap)MetadataTemplate.createMetadata(this.owningSharedDimension.getObjectStore(), "ClassifierMap", this.owningSharedDimension.getRepositoryShortFQID());
                }
                targetClassifierMaps.remove((Object)this.mapInfoClassifierMap);
                if (targetTransformations.indexOf((Object)this.mapInfoClassifierMap) < 0) {
                    targetTransformations.add((Object)this.mapInfoClassifierMap);
                }
                TableCollection newService = this.getMapService();
                this.mapInfoClassifierMap.setName(newService.getName());
                this.mapInfoClassifierMap.setTransformRole("ESRI Map File");
                this.mapInfoClassifierMap.setIsActive(0);
                this.mapInfoClassifierMap.setIsUserDefined(0);
                this.mapInfoClassifierMap.setDesc(newService.getDesc());
                AssociationList classifierSources = this.mapInfoClassifierMap.getClassifierSources();
                AssociationList transformationSources = this.mapInfoClassifierMap.getTransformationSources();
                classifierSources.clear();
                transformationSources.clear();
                transformationSources.add((Object)newService);
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 0);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
            }
        }
    }

    StringBuffer verifyMetadata() throws OLAPException {
        this.dimensionVerifyMessage = new StringBuffer();
        DimensionTable dimensionTable = this.getTable();
        boolean deletedDimension = false;
        if (dimensionTable == null) {
            this.dimensionVerifyMessage.append(bundle.formatString("OLAPDimension.DimensionTable.Removed.fmt.txt", (Object)this.getName()));
            this.dimensionSet.getCubeDimensions().remove(this);
            deletedDimension = true;
            this.dimensionSet.resetAggregations = true;
            if (this.metadataObject != null) {
                Dimension jomaDimension = (Dimension)this.metadataObject;
                try {
                    this.owningCube.getObjectStore().removeObjectFromStore((CMetadata)jomaDimension, "<Templates><Notes/><Hierarchies><Hierarchy><Notes/><Properties/></Hierarchy></Hierarchies><Levels><Level><Notes/><TargetFeatureMaps/><Properties/><OLAPProperties/></Level></Levels><Properties><Property><StoredConfiguration/></Property></Properties><TargetClassifierMaps/><TargetTransformations/><CustomAssociations/></Templates>");
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                }
            }
        } else {
            PhysicalTable table = dimensionTable.getTable();
            if (table != null) {
                SASLibrary sasLibrary = null;
                try {
                    sasLibrary = LibraryUtil.getLibrary((DataTable)table, null);
                    if (sasLibrary == null) {
                        this.dimensionVerifyMessage.append(bundle.formatString("OLAPDimension.DimensionTableLibrary.Removed.fmt.txt", (Object)table.getName(), (Object)this.getName()));
                        this.dimensionSet.getCubeDimensions().remove(this);
                        this.dimensionSet.resetAggregations = true;
                        deletedDimension = true;
                        if (this.metadataObject != null) {
                            Dimension jomaDimension = (Dimension)this.metadataObject;
                            this.owningCube.getObjectStore().removeObjectFromStore((CMetadata)jomaDimension, "<Templates><Notes/><Hierarchies><Hierarchy><Notes/><Properties/></Hierarchy></Hierarchies><Levels><Level><Notes/><TargetFeatureMaps/><Properties/><OLAPProperties/></Level></Levels><Properties><Property><StoredConfiguration/></Property></Properties><TargetClassifierMaps/><TargetTransformations/><CustomAssociations/></Templates>");
                        }
                    }
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.formatString("MdException.GenericError.txt", (Object)sasLibrary), 0);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        if (!deletedDimension) {
            StringBuffer raggedProblems;
            OLAPCube olapCube;
            OptionSet optionSet;
            Option tableOptions;
            StringBuffer mapInfo;
            if (this.isGeography() && !ModelUtilities.isBlank((mapInfo = this.verifyMapInfo()).toString())) {
                this.dimensionVerifyMessage.append(mapInfo);
            }
            if ((tableOptions = (optionSet = (olapCube = this.getDimensionSet().getOwningCube()).getOptionsSet()).getOption(this, olapCube.getName() + "_options", "OLAP Table Options")) != null) {
                tableOptions.setName("DimensionTable_options");
                tableOptions.setPropertyName("DimensionTable_options");
                tableOptions.setPropertyRole("OLAP Table Options");
            }
            if (!ModelUtilities.isBlank((raggedProblems = this.verifyRaggedHierarchies()).toString())) {
                this.dimensionVerifyMessage.append(raggedProblems);
            }
            if (this.isStarDimension()) {
                this.getDimensionKey();
                this.getFactKey();
                StringBuffer UDTTables = this.verifyUDTTables();
                if (!ModelUtilities.isBlank(UDTTables.toString())) {
                    this.dimensionVerifyMessage.append(UDTTables);
                }
            }
        }
        return this.dimensionVerifyMessage;
    }

    StringBuffer verifyRaggedHierarchies() throws OLAPException {
        StringBuffer raggedVerifyMessage = new StringBuffer();
        if (!this.isNewObject()) {
            try {
                OLAPList verifyHierarchies = this.getHierarchies();
                OLAPHierarchy hierarchy = null;
                int sizeOfHierarchies = verifyHierarchies.size();
                boolean raggedFoundOnHierarchy = false;
                String defaultEmptyChar = bundle.getString("OLAPDimension.None.txt");
                String defaultEmptyNum = bundle.getString("OLAPDimension.None.txt");
                String defaultIgnoreEmpty = "0";
                for (int i = 0; i < sizeOfHierarchies; ++i) {
                    hierarchy = (OLAPHierarchy)verifyHierarchies.get(i);
                    StringBuffer hierarchyMessage = hierarchy.verifyMetadata();
                    if (!ModelUtilities.isBlank(hierarchyMessage.toString())) {
                        raggedVerifyMessage.append(hierarchyMessage);
                    }
                    Hierarchy jomaHierarchy = (Hierarchy)hierarchy.metadataObject;
                    AssociationList properties = jomaHierarchy.getProperties(false);
                    raggedFoundOnHierarchy = false;
                    int propertiesSize = properties.size();
                    for (int k = 0; k < propertiesSize; ++k) {
                        Property property = (Property)properties.elementAt(k);
                        if (property.getName().equals("EMPTY_CHAR")) {
                            String emptyChar2 = property.getDefaultValue().trim();
                            raggedFoundOnHierarchy = true;
                            if (!emptyChar2.equals(this.emptyChar)) {
                                defaultEmptyChar = property.getDefaultValue().trim();
                                this.setEmptyChar(defaultEmptyChar);
                            }
                        }
                        if (property.getName().equals("EMPTY_NUM")) {
                            String emptyNum2 = property.getDefaultValue().trim();
                            raggedFoundOnHierarchy = true;
                            if (!emptyNum2.equals(this.emptyNum)) {
                                defaultEmptyNum = property.getDefaultValue().trim();
                                this.setEmptyNum(defaultEmptyNum);
                            }
                        }
                        if (!property.getName().equals("IGNORE_EMPTY")) continue;
                        String ignoreEmpty2 = property.getDefaultValue().trim();
                        raggedFoundOnHierarchy = true;
                        if (ignoreEmpty2.equals(this.ignoreEmpty)) continue;
                        defaultIgnoreEmpty = property.getDefaultValue().trim();
                        this.setIgnoreEmpty(defaultIgnoreEmpty);
                    }
                    if (!raggedFoundOnHierarchy) continue;
                    raggedVerifyMessage.append(bundle.formatString("OLAPDimension.RaggedOptionsFoundOnHierarchy.fmt.txt", (Object)hierarchy.getName(), (Object)defaultEmptyChar, (Object)defaultEmptyNum, (Object)defaultIgnoreEmpty));
                    hierarchy.changedMetadata = true;
                }
                if (defaultEmptyChar != bundle.getString("OLAPDimension.None.txt") || defaultEmptyNum != bundle.getString("OLAPDimension.None.txt") || defaultIgnoreEmpty != "0") {
                    raggedVerifyMessage.append(bundle.formatString("OLAPDimension.RaggedOptionsFoundOnHierarchyLast.fmt.txt", (Object)this.name, (Object)defaultEmptyChar, (Object)defaultEmptyNum, (Object)defaultIgnoreEmpty));
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (OLAPException OLAPError) {
                throw OLAPError;
            }
        }
        return raggedVerifyMessage;
    }

    StringBuffer verifyUDTTables() throws OLAPException {
        StringBuffer udtTables = new StringBuffer();
        LanguageSet language = this.getOwningCube().getLanguageSet();
        try {
            PhysicalTable physicalTable;
            AssociationList tablePackage;
            if (language.isCubeMultipleLanguageSupported() && !(tablePackage = (physicalTable = this.inputTable.getTable()).getTablePackages()).isEmpty()) {
                List listOfTables = null;
                String libraryId = null;
                CMetadata object = (CMetadata)tablePackage.get(0);
                if (object instanceof SASLibrary) {
                    SASLibrary sasLibrary = (SASLibrary)object;
                    libraryId = sasLibrary.getId();
                    listOfTables = this.tableSet.getPhysicalTablesByLibraries(libraryId, 0, "");
                } else if (object instanceof DatabaseSchema) {
                    DatabaseSchema databaseSchema = (DatabaseSchema)object;
                    String databaseId = databaseSchema.getId();
                    SASLibrary sasLibrary = LibraryUtil.getLibrary((DataTable)physicalTable, null);
                    libraryId = sasLibrary.getId();
                    listOfTables = this.tableSet.getPhysicalTablesByLibraries(libraryId, 1, databaseId);
                }
                List languages = language.getSelectedLocales();
                boolean found = false;
                int i = 1;
                int size = languages.size();
                while (i < size & !found) {
                    found = false;
                    String nameOfTable = this.inputTable.getTable().getName() + (String)languages.get(i);
                    int t = 0;
                    int tableSize = listOfTables.size();
                    while (t < tableSize & !found) {
                        HashMap mapOfTables = (HashMap)listOfTables.get(t);
                        String tableName = (String)mapOfTables.get("Name");
                        if (nameOfTable.equalsIgnoreCase(tableName)) {
                            found = true;
                        }
                        ++t;
                    }
                    if (!found) {
                        udtTables.append(bundle.formatString("OLAPDimension.DimensionPanel.NoUDTTable.fmt.txt", (Object)nameOfTable, (Object)this.name));
                    }
                    ++i;
                }
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        if (!ModelUtilities.isBlank(udtTables.toString())) {
            this.dimensionSet.getCubeDimensions().remove(this);
            this.dimensionSet.resetAggregations = true;
            this.dimensionSet.getTables().remove(this.inputTable);
            if (this.metadataObject != null) {
                Dimension jomaDimension = (Dimension)this.metadataObject;
                try {
                    this.owningCube.getObjectStore().removeObjectFromStore((CMetadata)jomaDimension, "<Templates><Notes/><Hierarchies><Hierarchy><Notes/><Properties/></Hierarchy></Hierarchies><Levels><Level><Notes/><TargetFeatureMaps/><Properties/><OLAPProperties/></Level></Levels><Properties><Property><StoredConfiguration/></Property></Properties><TargetClassifierMaps/><TargetTransformations/><CustomAssociations/></Templates>");
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                }
            }
        }
        return udtTables;
    }

    public void verifyStarSchemaTable() throws OLAPException {
        if (this.getTable() == null) {
            throw new OLAPException(bundle.formatString("OLAPDimension.NoDimDefined.fmt.txt", (Object)this.name), 0);
        }
        this.checkDimensionTable = true;
    }

    public void verifyStarSchemaKey() throws OLAPException {
        if (this.getDimensionKey() == null) {
            throw new OLAPException(bundle.formatString("OLAPDimension.NoDimkeyDefined.fmt.txt", (Object)this.name), 0);
        }
        this.checkDimensionKey = true;
    }

    public void verifyAllLevelsUsed() throws OLAPException {
        int size = this.levels.size();
        for (int i = 0; i < size; ++i) {
            boolean found = false;
            OLAPLevel level = (OLAPLevel)this.levels.get(i);
            String levelName = level.getName();
            OLAPList listOfHierarchies = this.getHierarchies();
            int hierarchySize = listOfHierarchies.size();
            for (int t = 0; t < hierarchySize; ++t) {
                OLAPHierarchy nextHierarchy = (OLAPHierarchy)listOfHierarchies.get(t);
                OLAPList hierarchyLevels = nextHierarchy.getLevels();
                int k = 0;
                int levelSize = hierarchyLevels.size();
                while (k < levelSize & !found) {
                    OLAPLevel hierarchyLevel = (OLAPLevel)hierarchyLevels.get(k);
                    if (levelName.equalsIgnoreCase(hierarchyLevel.getName())) {
                        found = true;
                    }
                    ++k;
                }
            }
            if (found) continue;
            throw new OLAPException(bundle.formatString("OLAPLevel.LevelNotinHierarchy.fmt.txt", (Object)levelName.trim()), 0);
        }
    }

    public void verifyFactKey() throws OLAPException {
        if (this.factKey == null) {
            throw new OLAPException(bundle.formatString("OLAPDimension.NoFactkeyDefined.fmt.txt", (Object)this.name), 0);
        }
        this.checkDimensionFactKey = true;
    }

    public void verifyHierarchyList() throws OLAPException {
        OLAPList listOfHierarchies = this.getHierarchies();
        if (listOfHierarchies.size() < 1) {
            throw new OLAPException(bundle.formatString("OLAPDimension.NoHierarchyDefined.fmt.txt", (Object)this.name), 0);
        }
    }

    public void verifyLevelsList() throws OLAPException {
        OLAPList listOfLevels = this.getLevels();
        if (listOfLevels == null) {
            throw new OLAPException(bundle.formatString("OLAPDimension.NoLevelsDefined.fmt.txt", (Object)this.name), 0);
        }
        if (listOfLevels.size() < 1) {
            throw new OLAPException(bundle.formatString("OLAPDimension.NoLevelsDefined.fmt.txt", (Object)this.name), 0);
        }
    }

    @Override
    public void verifyName() throws OLAPException {
        super.verifyName();
        this.verifySASName();
        String checkName = this.getName();
        List listOfDimensions = this.dimensionSet.getAllCubeDimensions();
        int size = listOfDimensions.size();
        for (int i = 0; i < size; ++i) {
            OLAPDimension dimension = (OLAPDimension)listOfDimensions.get(i);
            if (dimension == this || !checkName.equalsIgnoreCase(dimension.getName())) continue;
            throw new OLAPException(bundle.getString("OLAPDimension.DuplicateDimensionName.txt"), 0);
        }
        this.checkVerifyName = true;
    }

    public void verifyUniqueTimeDimension() throws OLAPException {
        String timeDimension = TIME;
        String dimensionType = this.getType().toUpperCase();
        if (dimensionType.equals(timeDimension)) {
            boolean found = false;
            List listOfDimensions = this.dimensionSet.getAllCubeDimensions();
            int i = 0;
            int size = listOfDimensions.size();
            while (i < size & !found) {
                OLAPDimension dimension = (OLAPDimension)listOfDimensions.get(i);
                if (dimension.getType().equals(timeDimension) && this != dimension) {
                    found = true;
                }
                ++i;
            }
            if (found) {
                throw new OLAPException(bundle.getString("OLAPDimension.DuplicateTimeDimension.txt"), 0);
            }
        }
        this.checkDimensionType = true;
    }

    public void verifyUniqueGeoDimension() throws OLAPException {
        String geoDimension = GEO;
        String dimensionType = this.getType().toUpperCase();
        if (dimensionType.equals(geoDimension)) {
            boolean found = false;
            List listOfDimensions = this.dimensionSet.getAllCubeDimensions();
            int i = 0;
            int size = listOfDimensions.size();
            while (i < size & !found) {
                OLAPDimension dimension = (OLAPDimension)listOfDimensions.get(i);
                if (dimension.getType().equals(geoDimension) && this != dimension) {
                    found = true;
                }
                ++i;
            }
            if (found) {
                throw new OLAPException(bundle.getString("OLAPDimension.DuplicateGeoDimension.txt"), 0);
            }
        }
        this.checkDimensionType = true;
    }

    public TableCollection getMapService() throws OLAPException {
        ClassifierMap classifierMap;
        if (this.mapService == null && (classifierMap = this.getMapClassifierMap()) != null) {
            try {
                AssociationList sources = classifierMap.getClassifierSources();
                if (sources.isEmpty()) {
                    sources = classifierMap.getTransformationSources(false);
                }
                if (!sources.isEmpty()) {
                    this.mapService = (TableCollection)sources.elementAt(0);
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), 0);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return this.mapService;
    }

    public ServerComponent getMapServer() throws OLAPException {
        if (this.mapServer == null) {
            this.getMapService();
            if (this.mapService != null) {
                try {
                    File sourceFile;
                    AssociationList components;
                    AssociationList locations = this.mapService.getCollectionLocations();
                    if (!locations.isEmpty() && !(components = (sourceFile = (File)locations.elementAt(0)).getDeployedComponents()).isEmpty()) {
                        ServerComponent currentServer = (ServerComponent)components.elementAt(0);
                        String nameOfServer = currentServer.getName();
                        List listOfServers = this.dimensionSet.getMapServers();
                        int size = listOfServers.size();
                        for (int i = 0; i < size; ++i) {
                            ServerComponent nextServer = (ServerComponent)listOfServers.get(i);
                            if (!nextServer.getName().equals(nameOfServer)) continue;
                            this.mapServer = nextServer;
                        }
                    }
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 0);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
        }
        return this.mapServer;
    }

    public void deleteMapInformation() throws OLAPException {
        ClassifierMap classifierMap = this.getMapClassifierMap();
        if (classifierMap != null) {
            MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)classifierMap, "", bundle.getString("MdException.GenericError.txt"));
        }
        this.mapInfoClassifierMap = null;
        this.getLevels();
        for (int i = 0; i < this.levels.size(); ++i) {
            OLAPLevel level = (OLAPLevel)this.levels.get(i);
            level.deleteMapInformation();
        }
        this.setMapServer(null);
        this.setMapService(null);
    }

    public void setMapService(TableCollection newService) throws OLAPException {
        this.mapService = newService;
        this.changedMetadata = true;
        this.dimensionSet.setMapServiceColumns(newService);
        this.setUpChanges("setMapService", TableCollection.class, newService);
    }

    public void setMapServer(ServerComponent newServer) throws OLAPException {
        this.mapServer = newServer;
        this.changedMetadata = true;
        this.setUpChanges("setMapServer", ServerComponent.class, newServer);
    }

    StringBuffer verifyMapInfo() throws OLAPException {
        StringBuffer mapInfo = new StringBuffer();
        if (this.metadataObject != null) {
            this.mapService = this.getMapService();
            ClassifierMap classifierMap = this.getMapClassifierMap();
            if (classifierMap != null & this.mapService == null) {
                this.deleteMapInformation();
                mapInfo.append(bundle.formatString("OLAPDimension.DeleteDimensionMapInfo.fmt.txt", (Object)this.getName()));
            }
        }
        return mapInfo;
    }

    public String verifyMapLayersExist() throws OLAPException {
        String message = "";
        this.mapService = this.getMapService();
        if (this.mapService != null) {
            this.getLevels();
            boolean found = false;
            int size = this.levels.size();
            for (int i = 0; i < size && !found; ++i) {
                OLAPLevel level = (OLAPLevel)this.levels.get(i);
                OLAPColumn layer = level.getMapLayer();
                found = layer != null;
            }
            if (!found) {
                message = bundle.formatString("OLAPDimension.DeleteDimensionMapInfo.fmt.txt", (Object)this.getName());
                this.deleteMapInformation();
            }
        }
        return message;
    }
}

