/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CalculatedMeasure;
import com.sas.metadata.remote.CalculatedMember;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.GlobalFormula;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.NamedSet;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DefinedMemberSet;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.StringHolder;

public class OLAPDefinedMember
extends AbstractOLAPModel {
    static WAdminResource bundle = new WAdminResource(OLAPDefinedMember.class);
    private DefinedMemberSet memberSet;
    private boolean canWrite;
    private boolean verifiedName;
    private int solveOrder;
    private OLAPDimension dimension;
    private OLAPHierarchy parentHierarchy;
    private OLAPLevel parentLevel;
    private OLAPList parentHierarchies;
    private String type;
    private String formula;
    private String format;
    private String parentMember;
    private String measuresDimensionName;
    private String uniqueName;
    private Map parentMemberInfo;
    private Integer currentMlsid;
    private Option solveOrderOption;
    private String expression;
    private boolean verifiedExpression;
    private boolean verifiedDimension;
    private boolean deleteSolveOrderOption;
    public static final String CALCULATEDMEMBER = "Calculated Member";
    public static final String CALCULATEDMEASURE = "Calculated Measure";
    public static final String NAMEDSET = "Named Set";
    private static final String DEFINE = "   DEFINE ";
    private static final String CREATE = "CREATE ";
    private static final String MEMBER = "Member ";
    private static final String SET = "Set ";
    private static final String AS = " AS ";
    private static final String MLSID = ", MLSID= ";
    private static final String FORMAT_STRING = ", FORMAT_STRING=";
    private static final String SOLVE_ORDER = ", SOLVE_ORDER=";

    OLAPDefinedMember(DefinedMemberSet set) throws OLAPException {
        this.memberSet = set;
        this.owningCube = this.memberSet.getOwningCube();
        this.dimensionSet = this.owningCube.getDimensionSet();
        this.optionSet = this.owningCube.getOptionsSet();
        this.setType(CALCULATEDMEMBER);
    }

    OLAPDefinedMember(TextStore inputMetadataObject, DefinedMemberSet set) {
        this.memberSet = set;
        this.owningCube = this.memberSet.getOwningCube();
        this.dimensionSet = this.owningCube.getDimensionSet();
        this.optionSet = this.owningCube.getOptionsSet();
        this.metadataObject = inputMetadataObject;
        this.verifiedName = true;
        this.verifiedExpression = true;
        this.verifiedDimension = true;
        this.getType();
        this.getExpressionFromMetadata();
    }

    public OLAPDefinedMember(GlobalFormula formula2, DefinedMemberSet set2) {
        this.memberSet = set2;
        this.owningCube = this.memberSet.getOwningCube();
        this.dimensionSet = this.owningCube.getDimensionSet();
        this.optionSet = this.owningCube.getOptionsSet();
        this.metadataObject = formula2;
        this.verifiedName = true;
        this.verifiedExpression = true;
        this.verifiedDimension = true;
        this.getType();
        this.getExpressionFromMetadata();
    }

    public OLAPDefinedMember(CalculatedMeasure measure, DefinedMemberSet set2) {
        this.memberSet = set2;
        this.owningCube = this.memberSet.getOwningCube();
        this.dimensionSet = this.owningCube.getDimensionSet();
        this.optionSet = this.owningCube.getOptionsSet();
        this.metadataObject = measure;
        this.verifiedName = true;
        this.verifiedExpression = true;
        this.verifiedDimension = true;
        this.getType();
        this.getExpressionFromMetadata();
    }

    public void delete() throws OLAPException {
        this.verifyDeleted();
        this.memberSet.delete(this);
        this.deleted = true;
    }

    public StringBuffer generateCode() throws OLAPException {
        int howManySingle;
        StringBuffer statement = new StringBuffer();
        String role = this.getType();
        String nameQuoteChar = "'";
        String mdxQuoteChar = "'";
        String MDXString = this.expression;
        String name = this.getFullName();
        int howManyDouble = name.indexOf("\"");
        if (howManyDouble > 0 & (howManySingle = name.indexOf("'")) > 0) {
            nameQuoteChar = " ";
        } else if (howManySingle > 0) {
            nameQuoteChar = "\"";
        }
        howManyDouble = MDXString.indexOf("\"");
        howManySingle = MDXString.indexOf("'");
        if (howManyDouble > 0 & howManySingle > 0) {
            mdxQuoteChar = " ";
        } else if (howManySingle > 0) {
            mdxQuoteChar = "\"";
        }
        statement.append(DEFINE);
        if (role.equals(CALCULATEDMEMBER) || role.equals(CALCULATEDMEASURE)) {
            statement.append(MEMBER);
        } else {
            statement.append(SET);
        }
        statement.append(nameQuoteChar).append(name).append(nameQuoteChar).append(AS).append(ModelUtilities.newline);
        statement.append("         ").append(mdxQuoteChar).append(MDXString).append(mdxQuoteChar);
        statement.append(";");
        return statement;
    }

    public String generateCreateClause() {
        String oldname;
        StringBuffer statement = new StringBuffer();
        String tempName = oldname = this.getName();
        if (this.metadataObject != null) {
            tempName = this.getTemporaryName();
            this.setName(tempName);
        }
        String memberName = this.getDesc();
        String cubeName = this.owningCube.getName();
        String role = this.getType();
        statement.append(CREATE);
        if (role.equals(SET)) {
            statement.append(SET);
        } else {
            statement.append(MEMBER);
        }
        statement.append("[").append(cubeName).append("].").append(memberName);
        statement.append(AS);
        this.setName(oldname);
        return statement.toString();
    }

    public String generateCreateStatement() {
        StringBuffer statement = new StringBuffer();
        statement.append(this.generateCreateClause());
        statement.append(this.expression);
        return statement.toString();
    }

    public String generatePropertiesClause() {
        StringBuffer buffer = new StringBuffer();
        if (!this.type.equals(NAMEDSET)) {
            if (this.format != null && !ModelUtilities.isBlank(this.format)) {
                buffer.append(FORMAT_STRING).append('\"').append(this.format).append('\"');
            }
            if (this.solveOrder != 0) {
                buffer.append(SOLVE_ORDER).append(String.valueOf(this.solveOrder));
            }
            if (this.currentMlsid != null) {
                buffer.append(MLSID).append(String.valueOf(this.currentMlsid));
            }
        }
        return buffer.toString();
    }

    public OLAPDimension getDimension() throws OLAPException {
        this.getType();
        if (this.type.equals(CALCULATEDMEMBER) && this.dimension == null) {
            this.dimension = this.parentHierarchy == null ? this.dimensionSet.getDimension(this.getDimensionName()) : this.parentHierarchy.getDimension();
        }
        return this.dimension;
    }

    public String getDimensionName() {
        String dimensionName = "";
        if (this.type.equals(CALCULATEDMEASURE)) {
            dimensionName = this.memberSet.getMeasuresDimensionName();
        } else if (this.type.equals(CALCULATEDMEMBER)) {
            if (this.dimension != null) {
                dimensionName = this.dimension.getName();
            } else if (this.parentHierarchy != null) {
                dimensionName = this.parentHierarchy.getDimension().getName();
            } else {
                this.getUniqueName();
                if (!ModelUtilities.isBlank(this.uniqueName)) {
                    int firstBracket = this.uniqueName.indexOf(91);
                    String search = new String("].[");
                    int ending = this.uniqueName.indexOf(search);
                    if (firstBracket > -1 && ending > -1) {
                        dimensionName = this.uniqueName.substring(firstBracket + 1, ending);
                    }
                }
            }
        }
        return dimensionName;
    }

    public String getExpression() {
        return this.expression;
    }

    private void getExpressionFromMetadata() {
        try {
            if (this.metadataObject != null) {
                if (this.metadataObject instanceof TextStore) {
                    this.expression = ((TextStore)this.metadataObject).getStoredText();
                } else if (this.metadataObject instanceof GlobalFormula) {
                    this.expression = ((GlobalFormula)this.metadataObject).getExpression();
                } else if (this.metadataObject instanceof CalculatedMeasure) {
                    this.expression = ((CalculatedMeasure)this.metadataObject).getExpression();
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public String buildExpression() {
        String newExpression = "";
        String properties = this.generatePropertiesClause();
        if (!ModelUtilities.isBlank(this.formula) || !ModelUtilities.isBlank(properties)) {
            StringBuffer buffer = new StringBuffer(500);
            buffer.append(this.formula);
            buffer.append(properties);
            newExpression = buffer.toString();
        }
        return newExpression;
    }

    public String getFormat() {
        return this.format;
    }

    public String getFormula() {
        return this.formula;
    }

    public String getFullName() {
        return "[" + this.owningCube.getName() + "]." + this.getUniqueName();
    }

    @Override
    public Integer getMLSID() throws OLAPException {
        if (this.currentMlsid == null && this.metadataObject != null && !this.deleteMLSId) {
            String noSpaces = Strings.removeWhitespace((String)this.expression);
            String[] tokens = noSpaces.split(",");
            for (int i = 0; i < tokens.length && this.currentMlsid == null; ++i) {
                if (!tokens[i].toUpperCase().startsWith("MLSID=") && !tokens[i].toUpperCase().startsWith("MLS_ID=")) continue;
                String temp = tokens[i].replaceAll("_", "");
                this.currentMlsid = Integer.valueOf(temp.substring(6));
            }
        }
        return this.currentMlsid;
    }

    @Override
    public void setMLSID(Integer inputMlsId) throws OLAPException {
        this.verifyMLSId(inputMlsId);
        this.changedMLSID = true;
        if (inputMlsId != null) {
            this.currentMlsid = inputMlsId;
            this.deleteMLSId = false;
        } else {
            this.currentMlsid = null;
            this.deleteMLSId = true;
        }
        if (this.metadataObject != null) {
            String[] tokens = this.expression.split(",");
            boolean found = false;
            this.expression = "";
            for (int i = 0; i < tokens.length && !found; ++i) {
                String nospace = Strings.removeWhitespace((String)tokens[i]);
                if (nospace.startsWith("MLSID=") || nospace.startsWith("MLS_ID=")) {
                    found = true;
                    tokens[i] = this.currentMlsid == null ? "" : "MLSID=" + this.currentMlsid.toString();
                }
                if (this.expression.length() > 0 & tokens[i].length() > 0) {
                    this.expression = this.expression + ",";
                }
                if (tokens[i].length() <= 0) continue;
                this.expression = this.expression + tokens[i];
            }
            if (!found && this.currentMlsid != null && this.currentMlsid > 0) {
                this.expression = this.expression + ", MLSID=" + this.currentMlsid.toString();
            }
        }
    }

    public String getUniqueName() {
        try {
            if (ModelUtilities.isBlank(this.uniqueName) && this.metadataObject != null) {
                if (this.metadataObject instanceof TextStore) {
                    this.uniqueName = this.metadataObject.getDesc();
                } else if (this.metadataObject instanceof GlobalFormula) {
                    this.uniqueName = ((GlobalFormula)this.metadataObject).getUniqueName();
                } else if (this.metadataObject instanceof CalculatedMeasure) {
                    this.uniqueName = ((CalculatedMeasure)this.metadataObject).getUniqueName();
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.uniqueName;
    }

    public DefinedMemberSet getOwningSet() {
        return this.memberSet;
    }

    public OLAPHierarchy getParentHierarchy() {
        return this.parentHierarchy;
    }

    public OLAPList getParentHierarchies() {
        return this.parentHierarchies;
    }

    public OLAPLevel getParentLevel() {
        return this.parentLevel;
    }

    public String getParentMember() {
        if (this.metadataObject != null && ModelUtilities.isBlank(this.parentMember)) {
            int pos;
            this.parentMember = this.getUniqueName();
            int lastBracket = this.parentMember.lastIndexOf(91);
            if (lastBracket > 0) {
                this.parentMember = this.parentMember.substring(0, lastBracket);
            }
            if ((pos = this.parentMember.indexOf(".")) == this.parentMember.length() - 1) {
                this.parentMember = "";
            }
            if (this.parentMember.endsWith(".")) {
                this.parentMember = this.parentMember.substring(0, this.parentMember.length() - 1);
            }
        }
        return this.parentMember;
    }

    public int getSolveOrder() throws OLAPException {
        if (this.solveOrderOption == null && this.metadataObject != null && !this.deleteSolveOrderOption) {
            this.solveOrderOption = this.optionSet.getOption(this, "SOLVE_ORDER", "OLAPCalculationProperty");
            if (this.solveOrderOption == null) {
                this.solveOrder = 0;
                this.getSolveOrderFromExpression();
                if (this.solveOrder != 0) {
                    this.setSolveOrder(this.solveOrder);
                } else {
                    this.setSolveOrder(null);
                }
            }
        }
        return this.solveOrder;
    }

    public int getSolveOrderFromExpression() {
        String noSpaces = Strings.removeWhitespace((String)this.expression);
        String[] tokens = noSpaces.split(",");
        Integer currentSolveOrder = null;
        for (int i = 0; i < tokens.length && currentSolveOrder == null; ++i) {
            if (!tokens[i].toUpperCase().startsWith("SOLVEORDER=") && !tokens[i].toUpperCase().startsWith("SOLVE_ORDER=")) continue;
            String temp = tokens[i].replaceAll("_", "");
            currentSolveOrder = Integer.valueOf(temp.substring(11));
        }
        if (currentSolveOrder != null) {
            this.solveOrder = currentSolveOrder;
        }
        return this.solveOrder;
    }

    public String getType() {
        try {
            if (ModelUtilities.isBlank(this.type) && this.metadataObject != null) {
                if (this.metadataObject instanceof TextStore) {
                    this.type = ((TextStore)this.metadataObject).getTextRole();
                    if (this.type.equals(CALCULATEDMEMBER)) {
                        String dimensionName;
                        if (ModelUtilities.isBlank(this.measuresDimensionName)) {
                            this.measuresDimensionName = this.memberSet.getMeasuresDimensionName();
                        }
                        if ((dimensionName = this.getDimensionName()).equals(this.measuresDimensionName)) {
                            this.type = CALCULATEDMEASURE;
                        }
                    }
                } else if (this.metadataObject instanceof CalculatedMeasure) {
                    this.type = CALCULATEDMEASURE;
                } else if (this.metadataObject instanceof GlobalFormula) {
                    this.type = ((GlobalFormula)this.metadataObject).getGlobalFormulaRole();
                    if (this.metadataObject instanceof CalculatedMember) {
                        Level metalevel;
                        Hierarchy metahier = ((CalculatedMember)this.metadataObject).getOwningHierarchy();
                        if (metahier != null) {
                            this.parentHierarchy = this.dimensionSet.getHierarchy(metahier.getName());
                        }
                        if ((metalevel = ((CalculatedMember)this.metadataObject).getAssociatedLevel()) != null) {
                            this.parentLevel = this.dimensionSet.getLevel(metalevel.getName());
                        }
                    }
                    if (this.metadataObject instanceof NamedSet) {
                        AssociationList hierarchies = ((NamedSet)this.metadataObject).getAssociatedHierarchies();
                        this.parentHierarchies = new OLAPList(OLAPHierarchy.class);
                        for (int i = 0; i < hierarchies.size(); ++i) {
                            Hierarchy hier = (Hierarchy)hierarchies.get(i);
                            OLAPHierarchy olapHier = this.dimensionSet.getHierarchy(hier.getName());
                            this.parentHierarchies.add(olapHier);
                        }
                    }
                }
            }
        }
        catch (RemoteException e) {
            this.type = CALCULATEDMEMBER;
        }
        catch (MdException e) {
            this.type = CALCULATEDMEMBER;
        }
        catch (OLAPException e) {
            this.type = CALCULATEDMEMBER;
        }
        return this.type;
    }

    private String getTemporaryName() {
        String tempName = null;
        String oldName = this.getName();
        int cnt = 1;
        while (tempName == null) {
            tempName = oldName.concat(String.valueOf(cnt).trim());
            this.setName(tempName);
            try {
                this.memberSet.verifyUniqueName(this);
            }
            catch (OLAPException e) {
                this.setName(oldName);
                ++cnt;
                tempName = null;
            }
        }
        this.setName(oldName);
        return tempName;
    }

    @Override
    public boolean isMetadataUpdated() {
        if (this.metadataObject instanceof TextStore) {
            return true;
        }
        if (this.owningCube.getVersionNumber().getMajorVersion() >= 5 && (this.type.equals(CALCULATEDMEMBER) && !(this.metadataObject instanceof CalculatedMember) || this.type.equals(NAMEDSET) && !(this.metadataObject instanceof NamedSet))) {
            return true;
        }
        return super.isMetadataUpdated();
    }

    private void isVerified() throws OLAPException {
        if (!this.verifiedName) {
            this.verifyName();
        }
        if (!this.verifiedExpression) {
            this.verifyExpression();
        }
        if (!this.verifiedDimension) {
            this.verifyDimension();
        }
    }

    public boolean isWriteAllowed() throws OLAPException {
        this.canWrite = true;
        if (this.metadataObject != null) {
            Workspace workspace = Workspace.getWorkspace();
            IOMI omiHandle = workspace.getCMRHandle();
            try {
                ISecurity_1_1 security = Workspace.getMdFactory().getConnection().MakeISecurityConnection(omiHandle);
                String credential = "";
                String resource = "OMSOBJ:" + this.metadataObject.getCMetadataType() + "/" + this.metadataObject.getFQID();
                String permission = "WriteMetadata";
                StringHolder permissionCondition = new StringHolder();
                BooleanHolder authorized = new BooleanHolder();
                security.IsAuthorized(credential, resource, permission, permissionCondition, authorized);
                this.canWrite = authorized.value;
            }
            catch (Exception e) {
                this.canWrite = false;
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 0);
            }
        }
        return this.canWrite;
    }

    public void setExpression(String newExpression) {
        this.expression = newExpression;
    }

    @Override
    public void setDesc(String newDesc) {
    }

    public void setDimension(OLAPDimension newDimension) throws OLAPException {
        if (newDimension == null && this.dimension != null || newDimension != null && !newDimension.equals(this.dimension)) {
            this.dimension = newDimension;
            if (this.dimension == null) {
                this.setParentMember("");
            } else {
                String newParent = newDimension.getUniqueName();
                OLAPHierarchy defaultHier = newDimension.getDefault();
                if (defaultHier != null) {
                    newParent = newParent + ".[" + defaultHier.getAllMember() + "]";
                }
                this.setParentMember(newParent);
            }
        }
    }

    public void setFormat(String newFormat) {
        this.format = newFormat;
    }

    public void setFormula(String newFormula) {
        this.formula = newFormula;
    }

    @Override
    public void setName(String inputName) {
        super.setName(inputName);
        StringBuffer buffer = new StringBuffer(150);
        if (this.type.equals(CALCULATEDMEASURE) || this.type.equals(CALCULATEDMEMBER)) {
            String parent = this.getParentMember();
            if (ModelUtilities.isBlank(parent)) {
                buffer.append("[").append(this.getDimensionName()).append("].[").append(this.getName()).append("]");
            } else {
                buffer.append(parent).append(".[").append(this.getName()).append("]");
            }
        } else {
            buffer.append(inputName);
        }
        this.setUniqueName(buffer.toString());
    }

    public void setParentHierarchy(OLAPHierarchy parentHierarchy) {
        this.parentHierarchy = parentHierarchy;
    }

    public void setParentLevel(OLAPLevel parentLevel) {
        this.parentLevel = parentLevel;
    }

    public void setParentMember(String newParent) {
        this.parentMember = newParent;
        StringBuffer buffer = new StringBuffer(150);
        if (ModelUtilities.isBlank(this.parentMember)) {
            buffer.append("[").append(this.getDimensionName()).append("].[").append(this.getName()).append("]");
        } else {
            buffer.append(this.parentMember).append(".[").append(this.getName()).append("]");
        }
        this.setUniqueName(buffer.toString());
    }

    public void setParentMemberInfo(Map selectedMemberInfo) {
        this.parentMemberInfo = selectedMemberInfo;
    }

    public void setSolveOrder(Integer newSolveOrder) throws OLAPException {
        this.solveOrderOption = this.optionSet.getOption(this, "SOLVE_ORDER", "OLAPCalculationProperty");
        if (newSolveOrder != null) {
            this.solveOrder = newSolveOrder;
            if (this.solveOrderOption == null) {
                this.solveOrderOption = new Option(this.optionSet, this);
                this.solveOrderOption.setName("SOLVE_ORDER");
                this.solveOrderOption.setDesc("SOLVE_ORDER");
                this.solveOrderOption.setPropertyRole("OLAPCalculationProperty");
                this.solveOrderOption.setPropertyName("SOLVE_ORDER");
                this.solveOrderOption.setOwningType(OptionSet.OWNING_TYPE_INTEGER);
                this.solveOrderOption.setPropertyOption(true);
            }
            this.solveOrderOption.setDefaultValue(newSolveOrder.toString());
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.solveOrderOption) >= 0) {
                objectOptions.remove(this.solveOrderOption);
            }
            this.solveOrderOption = null;
            this.deleteSolveOrderOption = true;
        }
    }

    public void setType(String newType) throws OLAPException {
        OLAPList calculatedMembers;
        this.type = newType;
        if (this.type.equals(CALCULATEDMEASURE)) {
            OLAPList calculatedMembers2;
            this.dimension = null;
            this.parentMember = "";
            OLAPList namedSets = this.memberSet.getNamedSets();
            namedSets.getTheList().remove(this);
            OLAPList calculatedMeasures = this.memberSet.getCalculatedMeasures();
            List list = calculatedMeasures.getTheList();
            if (!list.contains(this)) {
                list.add(this);
            }
            if (!(list = (calculatedMembers2 = this.memberSet.getCalculatedMembers()).getTheList()).contains(this)) {
                list.add(this);
            }
        } else if (this.type.equals(CALCULATEDMEMBER)) {
            calculatedMembers = this.memberSet.getCalculatedMembers();
            List list = calculatedMembers.getTheList();
            if (!list.contains(this)) {
                list.add(this);
            }
            OLAPList namedSets = this.memberSet.getNamedSets();
            namedSets.getTheList().remove(this);
            OLAPList calculatedMeasures = this.memberSet.getCalculatedMeasures();
            calculatedMeasures.getTheList().remove(this);
        } else if (this.type.equals(NAMEDSET)) {
            this.dimension = null;
            this.parentMember = "";
            calculatedMembers = this.memberSet.getCalculatedMembers();
            calculatedMembers.getTheList().remove(this);
            OLAPList namedSets = this.memberSet.getNamedSets();
            namedSets.getTheList().add(this);
            OLAPList calculatedMeasures = this.memberSet.getCalculatedMeasures();
            calculatedMeasures.getTheList().remove(this);
        }
        StringBuffer buffer = new StringBuffer(150);
        if (this.type.equals(CALCULATEDMEASURE) || this.type.equals(CALCULATEDMEMBER)) {
            if (ModelUtilities.isBlank(this.parentMember)) {
                buffer.append("[").append(this.getDimensionName()).append("].[").append(this.getName()).append("]");
            } else {
                buffer.append(this.parentMember).append(".[").append(this.getName()).append("]");
            }
        } else {
            buffer.append(this.getName());
        }
        this.setUniqueName(buffer.toString());
    }

    public void setUniqueName(String string) {
        this.uniqueName = string;
        super.setDesc(this.uniqueName);
    }

    @Override
    public String toString() {
        String displayName = this.getName();
        if (!this.getType().equals(NAMEDSET)) {
            String parent = this.getParentMember();
            if (ModelUtilities.isBlank(parent)) {
                parent = this.getDimensionName();
            }
            displayName = displayName + "   (" + parent + ")";
        }
        return displayName;
    }

    @Override
    public void updateMetadata() throws OLAPException {
        try {
            this.isVerified();
            this.setName(this.getName());
            this.getType();
            this.getUniqueName();
            if (this.metadataObject != null && (this.metadataObject instanceof TextStore || this.owningCube.getVersionNumber().getMajorVersion() >= 5 && (this.type.equals(CALCULATEDMEMBER) && !(this.metadataObject instanceof CalculatedMember) || this.type.equals(NAMEDSET) && !(this.metadataObject instanceof NamedSet)))) {
                this.metadataObject.delete();
                this.metadataObject = null;
            }
            if (this.metadataObject == null) {
                if (this.type.equals(CALCULATEDMEASURE)) {
                    this.metadataObject = (Root)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "CalculatedMeasure", this.owningCube.getRepositoryShortFQID());
                } else if (this.type.equals(CALCULATEDMEMBER)) {
                    this.metadataObject = this.owningCube.getVersionNumber().getMajorVersion() < 5 ? (Root)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "GlobalFormula", this.owningCube.getRepositoryShortFQID()) : (Root)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "CalculatedMember", this.owningCube.getRepositoryShortFQID());
                } else if (this.type.equals(NAMEDSET)) {
                    this.metadataObject = this.owningCube.getVersionNumber().getMajorVersion() < 5 ? (Root)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "GlobalFormula", this.owningCube.getRepositoryShortFQID()) : (Root)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "NamedSet", this.owningCube.getRepositoryShortFQID());
                }
            }
            super.updateMetadata();
            Cube jomaCube = (Cube)this.owningCube.metadataObject;
            this.measureSet = this.owningCube.getMeasureSet();
            if (this.metadataObject instanceof CalculatedMember) {
                AssociationList formulas;
                CalculatedMember calcMember = (CalculatedMember)this.metadataObject;
                calcMember.setGlobalFormulaRole(this.type);
                calcMember.setExpression(this.expression);
                calcMember.setUniqueName(this.uniqueName);
                if (this.parentMemberInfo != null) {
                    String levelName;
                    OLAPLevel level;
                    String hierarchyName = (String)this.parentMemberInfo.get("hierarchyName");
                    OLAPHierarchy hier = this.dimensionSet.getHierarchy(hierarchyName);
                    if (hier != null) {
                        calcMember.setOwningHierarchy((Hierarchy)hier.metadataObject);
                    }
                    if ((level = this.dimensionSet.getLevel(levelName = (String)this.parentMemberInfo.get("levelName"))) != null) {
                        calcMember.setAssociatedLevel((Level)level.metadataObject);
                    }
                }
                if (!(formulas = jomaCube.getFormulas(false)).contains((Object)calcMember)) {
                    formulas.add((Object)calcMember);
                }
            } else if (this.metadataObject instanceof GlobalFormula) {
                GlobalFormula globalFormula = (GlobalFormula)this.metadataObject;
                globalFormula.setGlobalFormulaRole(this.type);
                globalFormula.setExpression(this.expression);
                globalFormula.setUniqueName(this.uniqueName);
                AssociationList formulas = jomaCube.getFormulas(false);
                if (!formulas.contains((Object)globalFormula)) {
                    formulas.add((Object)globalFormula);
                }
            } else if (this.metadataObject instanceof CalculatedMeasure) {
                AssociationList measures;
                CalculatedMeasure measure = (CalculatedMeasure)this.metadataObject;
                measure.setPublicType("CalculatedMeasure");
                UsageVersion usageVersion = new UsageVersion(Integer.parseInt("4"), Integer.parseInt("0"), Integer.parseInt("0"));
                measure.setUsageVersion(usageVersion.encode());
                measure.setExpression(this.expression);
                measure.setUniqueName(this.uniqueName);
                Dimension measureDimension = this.measureSet.getMeasuresDimension();
                AssociationList jomaDimensionMeasures = measureDimension.getMeasures(false);
                if (!jomaDimensionMeasures.contains((Object)measure)) {
                    jomaDimensionMeasures.add((Object)measure);
                }
                if (!(measures = jomaCube.getMeasures(false)).contains((Object)measure)) {
                    measures.add((Object)measure);
                }
            }
            this.updateMetadataOptions();
        }
        catch (MdException e) {
            throw new OLAPException("MdException.GenericError.txt", e, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException("MdException.GenericError.txt", re, 12);
        }
    }

    private void updateMetadataOptions() throws OLAPException {
        if (this.optionSet != null) {
            try {
                Property property;
                int i;
                this.getSolveOrder();
                List options = this.optionSet.getOptions(this);
                HashMap<String, Property> metadataOptions = new HashMap<String, Property>();
                AssociationList properties = this.metadataObject.getProperties(false);
                int size = options.size();
                for (i = 0; i < size; ++i) {
                    Option option = (Option)options.get(i);
                    option.updateMetadata();
                }
                size = properties.size();
                for (i = 0; i < size; ++i) {
                    Property property2 = (Property)properties.elementAt(i);
                    metadataOptions.put(property2.getPropertyName(), property2);
                }
                if (this.deleteSolveOrderOption && this.solveOrderOption == null && (property = (Property)metadataOptions.get("SOLVE_ORDER")) != null && property.getPropertyName().equals("SOLVE_ORDER")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 0);
            }
        }
    }

    public void verifyDimension() throws OLAPException {
        String type1 = this.getType();
        OLAPDimension dim = this.getDimension();
        if ((type1.equals(CALCULATEDMEASURE) || type1.equals(NAMEDSET)) && dim != null) {
            throw new OLAPException(bundle.getString("OLAPDefinedMember.NoDimension.txt"), 0);
        }
        if (type1.equals(CALCULATEDMEMBER) && dim == null) {
            throw new OLAPException(bundle.getString("OLAPDefinedMember.DimensionRequired.txt"), 0);
        }
        this.verifiedDimension = true;
    }

    public void verifyExpression() throws OLAPException {
        if (ModelUtilities.isBlank(this.getExpression())) {
            throw new OLAPException(bundle.getString("OLAPDefinedMember.NoFormula.txt"), 0);
        }
        this.verifiedExpression = true;
    }

    @Override
    public void verifyName() throws OLAPException {
        this.verifyDeleted();
        this.verifiedName = false;
        this.name = this.getName();
        if (ModelUtilities.isBlank(this.name)) {
            throw new OLAPException(bundle.getString("OLAPDefinedMember.BlankName.txt"), null, 0);
        }
        char[] invalidChars = new char[]{'[', ']'};
        boolean found = false;
        int i = 0;
        while (i < invalidChars.length & !found) {
            char invalidChar = invalidChars[i];
            found = this.name.indexOf(invalidChar) > -1;
            ++i;
        }
        if (found) {
            throw new OLAPException(bundle.getString("OLAPDefinedMember.InvalidChar.txt"), null, 0);
        }
        this.memberSet.verifyUniqueName(this);
        this.verifiedName = true;
    }

    public void verifySyntax(OlapServer server) throws OLAPException {
        this.verifyExpression();
        if (server != null) {
            if (!server.isConnected()) {
                throw new OLAPException(bundle.getString("OLAPDefinedMember.NoServerConnection.txt"), 0);
            }
        } else {
            throw new OLAPException(bundle.getString("OLAPDefinedMember.NoServerConnection.txt"), 0);
        }
        server.verifyMdx(this.generateCreateStatement());
    }
}

