/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.DefinedMemberSet;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MLSCaptionTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPMemberPropertySet;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.olapadmin.designer.model.ReachThruTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OLAPCube
extends AbstractOLAPModel {
    static WAdminResource bundle = new WAdminResource(OLAPCube.class);
    public static final boolean generateLoadTableLibname = true;
    private UsageVersion usageVersion;
    private String originalName;
    private MdObjectStore objectStore;
    private String type;
    private StringBuffer cubeVerifyMessage;
    private List cubeMessage;
    private List schemaList;
    private String physicalName;
    private String path;
    private Option workPath;
    private Option compact;
    private Option missingKeys;
    private Option emptyChar;
    private Option emptyNum;
    private Option securitySubset;
    private Option dtMemPRef;
    private int errorLevel;
    private boolean errorLevelChecked;
    private MLSCaptionTable mlsCaptionTable;
    private OLAPSchema schema;
    private OLAPSchema originalSchema;
    private boolean deleteCompact;
    private boolean deleteMissingKeys;
    private boolean deleteEmptyChar;
    private boolean deleteEmptyNum;
    private boolean deleteWorkPath;
    private String sasCode;
    private String formatSearchOptions;
    private String esriServerName;
    private LanguageSet languageSet;
    private Option tableOptions;
    private Option reachThruTableOptions;
    private Option updateableDimensions;
    private Option collation;
    private Option locale;
    private Option captionPref;
    private Tree folder;
    private Tree originalFolder;
    private boolean deleteTableOptions;
    private boolean deleteReachThruTableOptions;
    private boolean deletePerformanceOptionCompress;
    private boolean deletePerformanceOptionDatapath;
    private boolean deletePerformanceOptionIndex;
    private boolean deletePerformanceOptionIndexpath;
    private boolean deletePerformanceOptionPartsize;
    private boolean deletePerformanceOptionSegsize;
    private boolean deletePerformanceOptionConcurrent;
    private boolean deletePerformanceOptionIndexSortSize;
    private boolean deletePerformanceOptionMaxThreads;
    private boolean deletePerformanceOptionAsyncIndexLimit;
    private boolean deleteUpdateableDimensions;
    private boolean deleteSecuritySubset;
    private boolean deleteDtMemPref;
    private boolean deleteCollation;
    private boolean deleteLocale;
    private boolean deleteCaptionPref;
    private boolean deleteMLSCaptionTable;
    private boolean languagedChanged;
    boolean changedPerformanceIndexSortSize;
    boolean changedPerformanceMaxThreads;
    boolean changedPerformanceAsyncIndexLimit;
    boolean changedPerformanceConcurrent;
    private Option performanceOptionCompress;
    private Option performanceOptionDatapath;
    private Option performanceOptionIndex;
    private Option performanceOptionIndexpath;
    private Option performanceOptionPartsize;
    private Option performanceOptionSegsize;
    private Option performanceOptionConcurrent;
    private Option performanceOptionIndexSortSize;
    private Option performanceOptionMaxThreads;
    private Option performanceOptionAsyncIndexLimit;
    public static final int PERFORMANCE_OPTION_INDEXSORTSIZE_MIN = 32;
    public static final int PERFORMANCE_OPTION_INDEXSORTSIZE_MAX = Integer.MAX_VALUE;
    public static final int PERFORMANCE_OPTION_MAXTHREADS_MIN = 0;
    public static final int PERFORMANCE_OPTION_MAXTHREADS_MAX = 65536;
    public static final int PERFORMANCE_OPTION_CONCURRENT_MIN = 0;
    public static final int PERFORMANCE_OPTION_PARTSIZE_MIN = 16;
    public static final int PERFORMANCE_OPTION_SEGSIZE_MIN = 1;
    public static final int PERFORMANCE_OPTION_ASYNCINDEXLIMIT_MIN = 0;
    private Map reachthruMap;
    public static final int NO_ERROR = -1;
    public static final int ERROR_MISSING_LOADTABLE = 1;
    public static final int ERROR_MISSING_LOADTABLE_LIBRARY = 2;
    public static final int WARNING_OLAPCUBE = 3;
    public static final int SEVERE_METADATA_EXCEPTION = 4;
    public static final int VALIDVARNAME_V7 = 1;
    public static final int VALIDVARNAME_UPCASE = 2;
    public static final int VALIDVARNAME_ANY = 3;
    public static final int CODEGEN_LOADTABLE_LIBREFS = 1;
    public static final int CODEGEN_EXPORT_CODE = 2;
    public static final int CODEGEN_SETUP_RC_CAPTURE = 4;
    public static final int CODEGEN_RC_CAPTURE = 8;
    public static final int CODEGEN_NOPROMPT = 16;
    private static final int CODEGEN_MIN = 0;
    private static final int CODEGEN_MAX = 31;
    private String UPPERVALIDVARNAME = "VALIDVARNAME";
    private String LOWERVALIDVARNAME = "validvarname";
    private boolean testing;
    private boolean internalStore;
    private boolean resetSASCode;
    private boolean resetFormatSearchOptions;
    private boolean resetRaggedHierarchyOptions;
    private boolean resetDimensionTableTranslations;
    private boolean resetCompactNwayOption;
    private boolean addData;
    private boolean missingOLAPSchema;
    static final String CUBE_DIRECTORY_ROLE = "OLAPPath";
    private static final String DIMENSION_GEN_FOLDER = "DimensionGenFolder";
    private static final String READ_MEASURE_TEMPLATE = "<Templates><FeatureMap><AssociatedClassifierMap/><FeatureSources/><TransformationSources/></FeatureMap></Templates>";

    public OLAPCube() throws OLAPException {
        try {
            this.objectStore = Workspace.getMdFactory().createObjectStore(null, "OLAPCubeNewObject");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.internalStore = true;
        this.owningCube = this;
        this.errorLevelChecked = true;
        this.errorLevel = -1;
        this.resetSASCode = true;
        this.resetFormatSearchOptions = true;
        this.resetRaggedHierarchyOptions = true;
        this.addData = false;
        this.usageVersion = new UsageVersion(Integer.parseInt("4"), Integer.parseInt("0"), Integer.parseInt("0"));
    }

    public OLAPCube(MdObjectStore inputObjectStore) throws OLAPException {
        this.errorLevelChecked = true;
        this.errorLevel = -1;
        this.objectStore = inputObjectStore;
        this.owningCube = this;
        this.internalStore = false;
        this.resetSASCode = true;
        this.resetFormatSearchOptions = true;
        this.resetRaggedHierarchyOptions = true;
        this.addData = false;
        this.usageVersion = new UsageVersion(Integer.parseInt("4"), Integer.parseInt("0"), Integer.parseInt("0"));
    }

    public OLAPCube(Cube inputMetadataObject) throws OLAPException {
        this.metadataObject = inputMetadataObject;
        this.owningCube = this;
        this.internalStore = false;
        this.errorLevelChecked = true;
        this.errorLevel = -1;
        this.resetSASCode = true;
        this.resetFormatSearchOptions = true;
        this.resetRaggedHierarchyOptions = true;
        this.addData = false;
        try {
            this.usageVersion = UsageVersion.decode((double)this.metadataObject.getUsageVersion());
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)inputMetadataObject, null, MetadataTemplate.getCubeAssociations(), "<Templates><Aggregation><Levels/><CustomAssociations/><AggregationTables/><Properties/></Aggregation><CustomAssociation><AssociatedObjects/></CustomAssociation><File><Directories/><DeployedComponents/></File><OLAPSchema><DeployedComponents/></OLAPSchema><Dimension><Hierarchies/><Levels/><Measures/><TargetClassifierMaps/><TargetTransformations/><Properties/><Notes/><CustomAssociations/></Dimension><Hierarchy><Levels/><OLAPProperties/><Notes/><Properties/></Hierarchy><Measure><Notes/><Properties/></Measure><CalculatedMeasure><Properties/></CalculatedMeasure><CalculatedMember><Properties/></CalculatedMember><GlobalFormula><Properties/></GlobalFormula><OLAPProperty><Properties/><Notes/></OLAPProperty><Property><DefaultValue/><StoredConfiguration/><OwningType/></Property><ClassifierMap><ClassifierSources/><ClassifierTargets/><TransformationSources/><TransformationTargets/><SourceCode/><Steps/></ClassifierMap><Level><Notes/><Properties/><OLAPProperties/></Level><PropertySet><SetProperties/></PropertySet><Transformation><TransformationSources/></Transformation><TableCollection><CollectionLocations/></TableCollection></Templates>", 524300);
            ArrayList<String> levelAssociations = new ArrayList<String>();
            levelAssociations.add("TargetFeatureMaps");
            levelAssociations.add("TargetTransformations");
            levelAssociations.add("OLAPProperties");
            ArrayList<String> measureAssociations = new ArrayList<String>();
            measureAssociations.add("TargetFeatureMaps");
            measureAssociations.add("TargetTransformations");
            AssociationList dimensions = inputMetadataObject.getDimensions();
            for (int j = dimensions.size() - 1; j >= 0; --j) {
                Dimension dimension = (Dimension)dimensions.get(j);
                AssociationList levels = dimension.getLevels();
                for (int k = levels.size() - 1; k >= 0; --k) {
                    Level level = (Level)levels.get(k);
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)level, null, levelAssociations, "<Templates><FeatureMap><AssociatedClassifierMap/><FeatureSources/><TransformationSources/></FeatureMap><OLAPProperty><TargetFeatureMaps/><TargetTransformations/></OLAPProperty></Templates>", 524300);
                }
                AssociationList measures = dimension.getMeasures();
                for (int k = measures.size() - 1; k >= 0; --k) {
                    Measure measure = (Measure)measures.get(k);
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)measure, null, measureAssociations, READ_MEASURE_TEMPLATE, 524300);
                }
            }
            this.verifyMetadata();
            if (!this.deleted) {
                this.originalSchema = this.getAssociatedOLAPSchema();
                this.originalFolder = this.getOriginalFolder();
                this.originalName = this.getName();
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    public boolean canRead() {
        boolean read = false;
        if (this.metadataObject != null) {
            read = ModelUtilities.canRead("Cube", (CMetadata)this.metadataObject);
        }
        return read;
    }

    public boolean canReadMetadata() {
        boolean read = false;
        if (this.metadataObject != null) {
            read = ModelUtilities.canReadAllCubeMetadata((CMetadata)this.metadataObject);
        }
        return read;
    }

    public boolean canWrite() {
        boolean write = false;
        if (this.metadataObject != null) {
            write = ModelUtilities.canReadAllCubeMetadata((CMetadata)this.metadataObject);
        }
        return write;
    }

    public boolean canWriteMetadata() {
        boolean write = false;
        if (this.metadataObject != null) {
            write = ModelUtilities.canReadAllCubeMetadata((CMetadata)this.metadataObject);
        }
        return write;
    }

    public StringBuffer generateCodeDelete() throws OLAPException {
        return this.generateCodeDelete(false);
    }

    public StringBuffer generateCodeDelete(boolean saveProcCode) throws OLAPException {
        StringBuffer delete = new StringBuffer();
        delete.append(this.generateCodeValidVarNameOption(3));
        Tree folderToUse = this.getOriginalFolder();
        if (folderToUse == null) {
            folderToUse = this.getFolder();
        }
        delete.append(this.generateCodeProcOlapCubeEquals(folderToUse, true)).append(ModelUtilities.newline).append("   DELETE");
        delete.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        delete.append(this.generateCodeMetasrvStatement(this.getOriginalSchema(), saveProcCode));
        delete.append(this.generateCodeRunStatement());
        return delete;
    }

    public StringBuffer generateCodeReorganizeAll() throws OLAPException {
        StringBuffer proc = new StringBuffer();
        proc.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
        proc.append(this.generateCodeProcOlapCubeEquals(this.getFolder(), false));
        proc.append(ModelUtilities.newline).append("   REORGANIZE_LEVELS ");
        proc.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        proc.append(this.generateCodeMetasrvStatement(this.getOriginalSchema(), false));
        proc.append(this.generateCodeRunStatement());
        return proc;
    }

    public StringBuffer generateCodeReorganizeLevels(List levels) throws RemoteException, OLAPException, MdException {
        StringBuffer proc = new StringBuffer();
        proc.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
        proc.append(this.generateCodeProcOlapCubeEquals(this.getFolder(), false));
        proc.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        proc.append(this.generateCodeMetasrvStatement(this.getOriginalSchema(), false));
        for (int i = 0; i < levels.size(); ++i) {
            OLAPLevel level = (OLAPLevel)levels.get(i);
            String name = level.getName();
            proc.append("   REORGANIZE_LEVEL ").append(name).append(";");
            proc.append(ModelUtilities.newline);
        }
        proc.append(this.generateCodeRunStatement());
        return proc;
    }

    public StringBuffer generateCodeSynchronize() throws OLAPException {
        this.verifyErrorLevelChecked();
        StringBuffer delete = new StringBuffer();
        if (this.metadataObject != null) {
            delete.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
            delete.append(this.generateCodeProcOlapCubeEquals(this.getFolder(), false)).append(ModelUtilities.newline).append("   SYNCHRONIZE_LEVELS");
            delete.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
            delete.append(this.generateCodeMetasrvStatement(this.getOriginalSchema(), false));
            delete.append(this.generateCodeRunStatement());
        }
        return delete;
    }

    public StringBuffer generateCodeUpdateDisplayNames(HashMap newCaptions, HashMap newDesc, HashMap memberChanges, HashMap optionsMap, HashMap countOptionsMap) throws OLAPException {
        String checkBoxValue;
        StringBuffer proc = new StringBuffer();
        PhysicalTable physicalTable = (PhysicalTable)optionsMap.get("New DrillTable");
        HashMap statColVal = (HashMap)countOptionsMap.get("Statistic Value");
        String libnameStatement = null;
        if (physicalTable != null) {
            try {
                libnameStatement = this.tableSet.getLibnameCode(physicalTable);
                if (libnameStatement != null) {
                    proc.append(libnameStatement).append(ModelUtilities.newline);
                }
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            catch (MdException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        }
        proc.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
        proc.append(this.generateCodeProcOlapCubeEquals(this.getFolder(), false));
        proc.append(ModelUtilities.newline).append("   UPDATE_DISPLAY_NAMES");
        if (newDesc.containsKey(this)) {
            String newDescription = (String)newDesc.get(this);
            proc.append(ModelUtilities.newline);
            proc.append("   DESCRIPTION            = ");
            StringBuffer tempDesc = new StringBuffer(ModelUtilities.internalQuote(newDescription));
            tempDesc.insert(0, "'").append("'");
            proc.append(tempDesc);
        }
        if (physicalTable != null) {
            SASLibrary reachthruLibrary = null;
            String reachThruLibRef = "";
            StringBuffer reachthruName = new StringBuffer();
            String drillThruOptions = (String)optionsMap.get("DrillThruTableOptions");
            Boolean isMLSDrillThru = (Boolean)optionsMap.get("DrillThruMLSSupport");
            try {
                reachthruLibrary = LibraryUtil.getLibrary((DataTable)physicalTable, null);
                if (reachthruLibrary != null) {
                    reachThruLibRef = reachthruLibrary.getLibref();
                }
                StringBuffer reachThruMemPref = ModelUtilities.getSasName(physicalTable.getSASTableName());
                if (isMLSDrillThru.booleanValue()) {
                    proc.append(ModelUtilities.newline).append("   DTMEMPREF              = ").append(reachThruMemPref).append(ModelUtilities.newline);
                    if (!ModelUtilities.isBlank(reachThruLibRef)) {
                        proc.append("   DTLIBREF               = ").append(reachThruLibRef).append(ModelUtilities.newline);
                    }
                    if (!ModelUtilities.isBlank(drillThruOptions)) {
                        proc.append("   DTMEMPREFOPTS          = ").append("'").append(drillThruOptions.trim()).append("'");
                    }
                } else {
                    reachthruName.append(reachthruLibrary.getLibref()).append(".").append(ModelUtilities.getSasName(physicalTable.getSASTableName()));
                    if (reachthruLibrary != null) {
                        if (!ModelUtilities.isBlank(drillThruOptions)) {
                            reachthruName.append("(").append(drillThruOptions.trim()).append(")");
                        }
                        proc.append(ModelUtilities.newline).append("   DRILLTHROUGH_TABLE     = ").append(reachthruName);
                    }
                }
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        if ((checkBoxValue = this.getSecuritySubset()).equals("NO")) {
            proc.append(ModelUtilities.newline).append("   SECURITY_SUBSET        = NO");
        } else if (checkBoxValue.equals("YES")) {
            proc.append(ModelUtilities.newline).append("   SECURITY_SUBSET        = YES");
        }
        proc.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        proc.append(this.generateCodeMetasrvStatement(this.getOriginalSchema(), false));
        OLAPList dims = this.dimensionSet.getCubeDimensions();
        for (int dimNum = 0; dimNum < dims.size(); ++dimNum) {
            OLAPDimension dim = (OLAPDimension)dims.get(dimNum);
            if (newCaptions.containsKey(dim) || newDesc.containsKey(dim)) {
                proc.append("   DIMENSION ").append(ModelUtilities.getSasName(dim.getName()));
                this.generateCaptionChanges(newCaptions, newDesc, proc, dim);
                proc.append(";").append(ModelUtilities.newline);
            }
            OLAPList hierarchies = dim.getHierarchies();
            for (int hierNum = 0; hierNum < hierarchies.size(); ++hierNum) {
                OLAPHierarchy hier = (OLAPHierarchy)hierarchies.get(hierNum);
                if (!newCaptions.containsKey(hier) && !newDesc.containsKey(hier) && !memberChanges.containsKey(hier)) continue;
                proc.append("   HIERARCHY ").append(ModelUtilities.getSasName(hier.getName()));
                if (memberChanges.containsKey(hier)) {
                    proc.append("     DEFAULT_MEMBER = ");
                    String member = (String)memberChanges.get(hier);
                    String memberQuoted = Strings.quoteForSAS((String)member);
                    proc.append(memberQuoted).append(ModelUtilities.newline);
                }
                this.generateCaptionChanges(newCaptions, newDesc, proc, hier);
                proc.append(";").append(ModelUtilities.newline);
            }
            OLAPList levels = dim.getLevels();
            for (int levNum = 0; levNum < levels.size(); ++levNum) {
                OLAPLevel level = (OLAPLevel)levels.get(levNum);
                if (newCaptions.containsKey(level) || newDesc.containsKey(level)) {
                    proc.append("   LEVEL ").append(ModelUtilities.getSasName(level.getName()));
                    this.generateCaptionChanges(newCaptions, newDesc, proc, level);
                    proc.append(";").append(ModelUtilities.newline);
                }
                OLAPList properties = level.getOLAPProperties();
                for (int propNum = 0; propNum < properties.size(); ++propNum) {
                    OLAPMemberProperty property = (OLAPMemberProperty)properties.get(propNum);
                    if (!newCaptions.containsKey(property) && !newDesc.containsKey(property)) continue;
                    proc.append("   PROPERTY ").append(ModelUtilities.getSasName(property.getName()));
                    proc.append("   LEVEL ").append("=").append(ModelUtilities.getSasName(level.getName()));
                    this.generateCaptionChanges(newCaptions, newDesc, proc, property);
                    proc.append(";").append(ModelUtilities.newline);
                }
            }
        }
        OLAPList measures = this.measureSet.getMeasures();
        for (int measureNum = 0; measureNum < measures.size(); ++measureNum) {
            OLAPMeasure measure = (OLAPMeasure)measures.get(measureNum);
            if (!newCaptions.containsKey(measure) && !newDesc.containsKey(measure) && !statColVal.containsKey(measure)) continue;
            proc.append("   MEASURE ").append(ModelUtilities.getSasName(measure.getName()));
            this.generateCaptionChanges(newCaptions, newDesc, proc, measure);
            if (statColVal != null && statColVal.containsKey(measure)) {
                String includeValue = (String)statColVal.get(measure);
                if (includeValue.equals(bundle.getString("OLAPMeasure.Nunique.txt"))) {
                    proc.append(ModelUtilities.newline).append("INCLUDE_CALCULATED_MEMBERS");
                } else {
                    proc.append(ModelUtilities.newline).append("NOINCLUDE_CALCULATED_MEMBERS");
                }
            }
            proc.append(";").append(ModelUtilities.newline);
        }
        proc.append(this.generateCodeRunStatement());
        return proc;
    }

    private void generateCaptionChanges(HashMap newCaptions, HashMap newDesc, StringBuffer proc, AbstractOLAPModel olapobj) {
        if (newCaptions.containsKey(olapobj)) {
            String caption = (String)newCaptions.get(olapobj);
            proc.append("     CAPTION = '").append(caption).append("'");
        }
        if (newDesc.containsKey(olapobj)) {
            String desc = (String)newDesc.get(olapobj);
            proc.append(ModelUtilities.newline);
            proc.append("     DESCRIPTION = '").append(desc).append("'");
        }
    }

    StringBuffer generateCodeProcOlapCubeEquals(Tree inputFolder, boolean useOriginalName) throws OLAPException {
        StringBuffer proc = new StringBuffer();
        String pathFolder = null;
        String nameToUse = null;
        nameToUse = useOriginalName && !ModelUtilities.isBlank(this.originalName) ? this.originalName : this.getName();
        proc.append("PROC OLAP").append(ModelUtilities.newline);
        try {
            CMetadata repository;
            MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
            if (inputFolder != null) {
                pathFolder = mdUtil.getObjectPath((MdObjectStore)inputFolder.getObjectStore(), (PrimaryType)inputFolder, false);
            }
            if (ModelUtilities.isBlank(pathFolder)) {
                proc.append("   CUBE                   = ").append("\"").append(nameToUse).append("\"");
            } else {
                proc.append("   CUBE                   = ").append("\"").append(pathFolder).append("/").append(nameToUse).append("\"");
            }
            if (Workspace.getWorkspace().isChangeManagementOn() && (repository = Workspace.getWorkspace().getProjectRepository()) != null) {
                proc.append(ModelUtilities.newline).append("   PROJECT                = ").append("\"").append(repository.getName()).append("\"");
            }
            proc.append(ModelUtilities.getReconnectionString());
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(re.getLocalizedMessage(), 12);
        }
        return proc;
    }

    public StringBuffer generateCodeDeletePhysical() throws OLAPException {
        return this.generateCodeDeletePhysical(false);
    }

    public StringBuffer generateCodeDeletePhysical(boolean saveProcCode) throws OLAPException {
        this.verifyErrorLevelChecked();
        StringBuffer deletePhysical = new StringBuffer();
        if (this.metadataObject != null || this.metadataObject == null && saveProcCode) {
            deletePhysical.append(this.generateCodeValidVarNameOption(3));
            Tree folderToUse = this.getOriginalFolder();
            if (folderToUse == null) {
                folderToUse = this.getFolder();
            }
            deletePhysical.append(this.generateCodeProcOlapCubeEquals(folderToUse, true)).append(ModelUtilities.newline).append("   DELETE_PHYSICAL");
            deletePhysical.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
            deletePhysical.append(this.generateCodeMetasrvStatement(this.getOriginalSchema(), saveProcCode));
            deletePhysical.append(this.generateCodeRunStatement());
        }
        return deletePhysical;
    }

    void clearCubeVerifyMessage() {
        this.errorLevelChecked = true;
        this.cubeVerifyMessage = null;
    }

    void clearCubeMessage() {
        this.errorLevelChecked = true;
        this.cubeMessage = null;
    }

    public StringBuffer generateCodeCreate() throws OLAPException {
        this.verifyErrorLevelChecked();
        StringBuffer codeCreate = new StringBuffer();
        if (this.metadataObject != null) {
            codeCreate.append(this.generateCodeShortForm(true, false, true));
        }
        return codeCreate;
    }

    private StringBuffer generateCodeDefaultMembers() throws OLAPException {
        this.getDimensionSet();
        StringBuffer defaultMembers = this.dimensionSet.generateCodeDefaultMembers();
        StringBuffer updateStatement = new StringBuffer();
        if (defaultMembers.length() > 0) {
            updateStatement.append(ModelUtilities.newline).append(ModelUtilities.newline);
            updateStatement.append(this.generateCodeProcOlapCubeEquals(this.getFolder(), false));
            updateStatement.append(ModelUtilities.newline).append("   UPDATE_DISPLAY_NAMES");
            updateStatement.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
            updateStatement.append(this.generateCodeMetasrvStatement(this.getAssociatedOLAPSchema(), false));
            updateStatement.append(ModelUtilities.newline).append(ModelUtilities.newline);
            updateStatement.append(defaultMembers);
            updateStatement.append(ModelUtilities.newline);
            updateStatement.append(this.generateCodeRunStatement());
        }
        return updateStatement;
    }

    StringBuffer generateCodeExecuteUtility() throws OLAPException, MdException, RemoteException {
        StringBuffer executeUtility = new StringBuffer();
        try {
            if (this.metadataObject != null) {
                Cube cube = (Cube)this.metadataObject;
                if (!ModelUtilities.isBlank(cube.getCubeName())) {
                    executeUtility.append(this.generateCodeDeletePhysical());
                }
                executeUtility.append(this.generateCodeShortForm(false, false, true));
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return executeUtility;
    }

    private StringBuffer generateCodeProcStatement() throws OLAPException {
        String tempCompact;
        StringBuffer threads;
        StringBuffer procStatement = new StringBuffer();
        procStatement.append(this.generateCodeProcOlapCubeEquals(this.getFolder(), false));
        if (this.tableSet == null) {
            this.getTableSet();
        }
        LoadTable loadTable = this.tableSet.getLoadTable();
        SASLibrary libname = null;
        StringBuffer tableName = null;
        try {
            libname = LibraryUtil.getLibrary((DataTable)loadTable.getTable(), null);
            tableName = new StringBuffer();
            tableName.append(libname.getLibref()).append(".").append(ModelUtilities.getSasName(loadTable.getSASTableName()));
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        StringBuffer datasetOptions = new StringBuffer(this.getTableOptions());
        if (datasetOptions.length() > 0) {
            datasetOptions.insert(0, "(").append(")");
        }
        tableName.append(datasetOptions);
        if (this.tableSet.isLoadDetailTable()) {
            procStatement.append(ModelUtilities.newline).append("   DATA                   = ").append(tableName);
        }
        try {
            SASLibrary mlsCaptionLibrary;
            PhysicalTable captionPhysicalTable;
            ReachThruTable reachthruTable = this.tableSet.getReachThruTable();
            if (reachthruTable != null) {
                SASLibrary reachthruLibrary = null;
                StringBuffer reachthruName = new StringBuffer();
                PhysicalTable table = reachthruTable.getTable();
                if (table != null) {
                    reachthruLibrary = LibraryUtil.getLibrary((DataTable)reachthruTable.getTable(), null);
                }
                if (reachthruLibrary != null) {
                    String libref = reachthruLibrary.getLibref();
                    this.getDrillThruMemPref();
                    if (this.dtMemPRef == null) {
                        reachthruName.append(libref).append(".").append(ModelUtilities.getSasName(reachthruTable.getSASTableName()));
                        StringBuffer reachthruOptions = new StringBuffer(this.getReachThruTableOptions());
                        if (reachthruOptions.length() > 0) {
                            reachthruOptions.insert(0, "(").append(")");
                        }
                        reachthruName.append(reachthruOptions);
                        procStatement.append(ModelUtilities.newline).append("   DRILLTHROUGH_TABLE     = ").append(reachthruName);
                    } else {
                        procStatement.append(ModelUtilities.newline);
                        procStatement.append("   DTLIBREF               = ");
                        procStatement.append(libref);
                        procStatement.append(ModelUtilities.newline);
                        procStatement.append("   DTMEMPREF              = ");
                        procStatement.append(ModelUtilities.getSasName(this.dtMemPRef.getDefaultValue()));
                        procStatement.append(ModelUtilities.newline);
                        String reachThruOptions = ModelUtilities.internalQuote(this.getReachThruTableOptions());
                        if (!ModelUtilities.isBlank(reachThruOptions)) {
                            procStatement.append("   DTMEMPREFOPTS          = ").append("'").append(reachThruOptions).append("'");
                        }
                    }
                }
            }
            PropertySet linguisticPropertySet = null;
            AssociationList listOfPropertySets = null;
            if (this.metadataObject != null) {
                listOfPropertySets = this.metadataObject.getPropertySets();
                int iSize = listOfPropertySets.size();
                for (int i = 0; i < iSize; ++i) {
                    PropertySet propertySet = (PropertySet)listOfPropertySets.elementAt(i);
                    String name = propertySet.getName();
                    if (!name.equals("Linguistic")) continue;
                    linguisticPropertySet = propertySet;
                }
            }
            String collationValue = this.getCollation();
            String localeValue = this.getLocale();
            if (linguisticPropertySet != null || collationValue != null || localeValue != null) {
                procStatement.append(ModelUtilities.newline);
                procStatement.append("   SORTSEQ = LINGUISTIC").append(ModelUtilities.newline);
                if (collationValue != null || localeValue != null) {
                    procStatement.append("                       (").append(ModelUtilities.newline);
                    if (collationValue != null) {
                        procStatement.append("                         COLLATION = ").append(collationValue).append(ModelUtilities.newline);
                    }
                    if (localeValue != null) {
                        procStatement.append("                         LOCALE = ").append(localeValue).append(ModelUtilities.newline);
                    }
                    procStatement.append("                       )");
                }
            }
            this.getMLSCaptionTable();
            if (this.mlsCaptionTable != null && (captionPhysicalTable = this.mlsCaptionTable.getTable()) != null && (mlsCaptionLibrary = LibraryUtil.getLibrary((DataTable)captionPhysicalTable, null)) != null) {
                String MLSLibref = mlsCaptionLibrary.getLibref();
                procStatement.append(ModelUtilities.newline);
                procStatement.append("   CUBETABLELIBREF        = ").append(MLSLibref);
                procStatement.append(ModelUtilities.newline);
                procStatement.append("   CUBETABLECAPPREF       = ").append(ModelUtilities.getSasName(this.getCaptionTableMemPref()));
                procStatement.append(ModelUtilities.newline);
                Integer mlsId = this.getMLSID();
                if (mlsId != null) {
                    procStatement.append("   MLSID                  = ").append(mlsId.toString()).append(ModelUtilities.newline);
                }
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        procStatement.append(ModelUtilities.newline).append("   PATH                   = ").append(ModelUtilities.quotePath(this.getPath()));
        String workpath = this.getWorkPath();
        if (!ModelUtilities.isBlank(workpath)) {
            procStatement.append(ModelUtilities.newline).append("   WORKPATH               = ").append(ModelUtilities.quotePath(workpath));
        }
        StringBuffer tempDesc = new StringBuffer(ModelUtilities.internalQuote(this.getDesc()));
        tempDesc.insert(0, "'").append("'");
        procStatement.append(ModelUtilities.newline).append("   DESCRIPTION            = ").append(tempDesc);
        if (this.tableSet.isLoadStarSchema()) {
            procStatement.append(ModelUtilities.newline).append("   FACT                   = ").append(tableName);
            String tempMissingKeys = this.getMissingDimensionKeys();
            if (!ModelUtilities.isBlank(tempMissingKeys) && tempMissingKeys.equals("TERSE") | tempMissingKeys.equals("VERBOSE")) {
                procStatement.append(ModelUtilities.newline).append("   IGNORE_MISSING_DIMKEYS = ").append(tempMissingKeys);
            }
        }
        if (this.getUpdateableDimensions() != null) {
            procStatement.append(ModelUtilities.newline).append("   NONUPDATEABLE");
        }
        if (this.getPerformanceOptionConcurrent() != null) {
            StringBuffer tempConcurrent = new StringBuffer(this.performanceOptionConcurrent.getDefaultValue());
            procStatement.append(ModelUtilities.newline).append("   CONCURRENT             = ").append(tempConcurrent);
        }
        if (this.getPerformanceOptionMaxThreads() != null) {
            threads = new StringBuffer(this.performanceOptionMaxThreads.getDefaultValue());
            procStatement.append(ModelUtilities.newline).append("   MAXTHREADS             = ").append(threads);
        }
        if (this.getPerformanceOptionAsyncIndexLimit() != null) {
            threads = new StringBuffer(this.performanceOptionAsyncIndexLimit.getDefaultValue());
            procStatement.append(ModelUtilities.newline).append("   ASYNCINDEXLIMIT        = ").append(threads);
        }
        if (this.getPerformanceOptionIndexSortSize() != null) {
            StringBuffer sortSize = new StringBuffer(this.performanceOptionIndexSortSize.getDefaultValue());
            procStatement.append(ModelUtilities.newline).append("   INDEXSORTSIZE          = ").append(sortSize);
        }
        if (this.getPerformanceOptionPartsize() != null) {
            StringBuffer tempPartSize = new StringBuffer(this.performanceOptionPartsize.getDefaultValue());
            procStatement.append(ModelUtilities.newline).append("   PARTSIZE               = ").append(tempPartSize);
        }
        if (this.getPerformanceOptionSegsize() != null) {
            StringBuffer tempSegsize = new StringBuffer(this.performanceOptionSegsize.getDefaultValue());
            procStatement.append(ModelUtilities.newline).append("   SEGSIZE                = ").append(tempSegsize);
        }
        if (this.getPerformanceOptionDatapath() != null) {
            String tempDatapath = this.performanceOptionDatapath.getDefaultValue();
            tempDatapath = ModelUtilities.formatPath(tempDatapath);
            procStatement.append(ModelUtilities.newline).append("   DATAPATH               = ").append(tempDatapath);
        }
        if (this.getPerformanceOptionIndexpath() != null) {
            String tempIndexpath = this.performanceOptionIndexpath.getDefaultValue();
            tempIndexpath = ModelUtilities.formatPath(tempIndexpath);
            procStatement.append(ModelUtilities.newline).append("   INDEXPATH              = ").append(tempIndexpath);
        }
        if (this.getPerformanceOptionCompress() != null) {
            if (this.performanceOptionCompress.getDefaultValue().equals("1")) {
                procStatement.append(ModelUtilities.newline).append("   COMPRESS");
            } else {
                procStatement.append(ModelUtilities.newline).append("   NOCOMPRESS");
            }
        }
        if (this.getPerformanceOptionIndex() != null) {
            if (this.performanceOptionIndex.getDefaultValue().equals("1")) {
                procStatement.append(ModelUtilities.newline).append("   INDEX");
            } else {
                procStatement.append(ModelUtilities.newline).append("   NOINDEX");
            }
        }
        if (this.getSecuritySubset().equals("YES")) {
            procStatement.append(ModelUtilities.newline).append("   SECURITY_SUBSET        = YES");
        }
        if (this.tableSet.isLoadStarSchema() && !ModelUtilities.isBlank(tempCompact = this.getCompact()) && tempCompact.equals("1")) {
            procStatement.append(ModelUtilities.newline).append("   COMPACT_NWAY");
        }
        this.getEmptyChar();
        if (this.emptyChar != null) {
            String emptyCharValue = ModelUtilities.internalQuote(this.emptyChar.getDefaultValue());
            if (ModelUtilities.isBlank(emptyCharValue)) {
                procStatement.append(ModelUtilities.newline).append("   EMPTY_CHAR             = ").append("' '");
            } else {
                procStatement.append(ModelUtilities.newline).append("   EMPTY_CHAR             = ").append("'").append(emptyCharValue).append("'");
            }
        }
        this.getEmptyNum();
        if (this.emptyNum != null) {
            StringBuffer tempEmptyNum = new StringBuffer(ModelUtilities.internalQuote(this.emptyNum.getDefaultValue()));
            tempEmptyNum.insert(0, "'").append("'");
            procStatement.append(ModelUtilities.newline).append("   EMPTY_NUM              = ").append(tempEmptyNum);
        }
        if (!this.getAggregationSet().isNWAYGenerated()) {
            procStatement.append(ModelUtilities.newline).append("   NO_NWAY");
        }
        if (this.isESRI() && this.esriServerName != null) {
            procStatement.append(ModelUtilities.newline).append("   ESRI_MAP_SERVER        = '").append(this.esriServerName).append("'");
        }
        procStatement.append(ModelUtilities.newline).append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        return procStatement;
    }

    private StringBuffer generateCodeUserDefinedTranslations() throws OLAPException {
        StringBuffer userDefinedTranslations = new StringBuffer();
        if (this.languageSet == null) {
            this.getLanguageSet();
        }
        List locales = this.languageSet.getSelectedLocales();
        int size = locales.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                userDefinedTranslations.append(ModelUtilities.newline).append("   USER_DEFINED_TRANSLATIONS");
            }
            userDefinedTranslations.append(" ").append(locales.get(i));
        }
        if (userDefinedTranslations.length() > 0) {
            userDefinedTranslations.append(";").append(ModelUtilities.newline);
        }
        return userDefinedTranslations;
    }

    public StringBuffer generateCodeLongForm() throws OLAPException {
        this.verifyErrorLevelChecked();
        StringBuffer longForm = new StringBuffer();
        longForm.append(this.generateCodeSasCode());
        longForm.append(this.generateCodeFormatSearchOptions());
        if (this.tableSet == null) {
            this.getTableSet();
        }
        longForm.append(this.tableSet.generateCode());
        longForm.append(ModelUtilities.newline);
        longForm.append(this.generateCodeProcStatement());
        longForm.append(this.generateCodeMetasrvStatement(this.getAssociatedOLAPSchema(), true));
        this.getDimensionSet();
        longForm.append(this.dimensionSet.generateCode());
        longForm.append(ModelUtilities.newline);
        this.getOLAPMemberPropertySet();
        longForm.append(this.propertySet.generateCode());
        longForm.append(ModelUtilities.newline);
        this.getMeasureSet();
        longForm.append(this.measureSet.generateCode());
        this.getAggregationSet();
        longForm.append(this.aggregationSet.generateCode());
        longForm.append(this.generateCodeUserDefinedTranslations());
        this.getDefinedMemberSet();
        longForm.append(this.definedMemberSet.generateCode());
        longForm.append(this.generateCodeFormats());
        longForm.append(this.generateCodeRunStatement());
        longForm.append(this.generateCodeDefaultMembers());
        return longForm;
    }

    StringBuffer generateCodeSasCode() throws OLAPException {
        StringBuffer code = new StringBuffer();
        String sasCode = this.getSASCode();
        if (sasCode.indexOf(this.UPPERVALIDVARNAME) < 0 && sasCode.indexOf(this.LOWERVALIDVARNAME) < 0) {
            code.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
        }
        code.append(sasCode);
        if (code.length() > 0) {
            code.append(ModelUtilities.newline).append(ModelUtilities.newline);
        }
        return code;
    }

    StringBuffer generateCodeFormatSearchOptions() throws OLAPException {
        StringBuffer sasFormats = new StringBuffer();
        this.getFormatSearchOptions();
        if (!ModelUtilities.isBlank(this.formatSearchOptions)) {
            sasFormats.append("OPTIONS FMTSEARCH = (").append(this.formatSearchOptions).append(");").append(ModelUtilities.newline).append(ModelUtilities.newline);
        }
        return sasFormats;
    }

    private StringBuffer generateCodeFormats() throws OLAPException {
        StringBuffer formats = new StringBuffer();
        this.getDimensionSet();
        this.getOLAPMemberPropertySet();
        OLAPList allDimensions = this.dimensionSet.getCubeDimensions();
        int size = allDimensions.size();
        for (int i = 0; i < size; ++i) {
            OLAPDimension nextDimension = (OLAPDimension)allDimensions.get(i);
            OLAPList listOfDimensionLevels = nextDimension.getLevels();
            int sizeLevels = listOfDimensionLevels.size();
            for (int j = 0; j < sizeLevels; ++j) {
                OLAPLevel nextLevel = (OLAPLevel)listOfDimensionLevels.get(j);
                List listOfProperties = this.propertySet.getOLAPProperties(nextLevel);
                int sizeProperties = listOfProperties.size();
                for (int s = 0; s < sizeProperties; ++s) {
                    OLAPMemberProperty nextProperty = (OLAPMemberProperty)listOfProperties.get(s);
                    String memberName = nextProperty.getColumn().getSASColumnName();
                    String memberFormat = nextProperty.getSASFormat();
                    if (memberFormat == null || ModelUtilities.isBlank(memberFormat.trim())) continue;
                    if (formats.length() == 0) {
                        formats.append(ModelUtilities.newline);
                    }
                    formats.append("   FORMAT ").append(memberName).append(" ").append(memberFormat).append(";").append(ModelUtilities.newline);
                }
            }
        }
        return formats;
    }

    public StringBuffer generateCodeShortForm(int codegenFlags) throws OLAPException {
        StringBuffer shortForm = new StringBuffer();
        boolean saveProcCode = OLAPCube.getCodegenFlag(codegenFlags, 2);
        if (!saveProcCode) {
            shortForm.append(this.generateCodeValidVarNameOption(3));
            this.genLibnames(codegenFlags, shortForm);
            shortForm.append(this.generateCodeSasCode());
            shortForm.append(this.generateCodeFormatSearchOptions());
        } else {
            shortForm.append(this.generateCodeSasCode());
            shortForm.append(this.generateCodeFormatSearchOptions());
            this.genLibnames(codegenFlags, shortForm);
        }
        this.addSharedProcOlapCode(codegenFlags, shortForm);
        return shortForm;
    }

    private StringBuffer generateCodeShortForm(boolean inputGenerateLoadTableLibrefs, boolean saveProcCode, boolean initializeCodeGen) throws OLAPException {
        int flags = 0;
        flags = OLAPCube.setCodegenFlag(flags, 1, inputGenerateLoadTableLibrefs);
        flags = OLAPCube.setCodegenFlag(flags, 4, initializeCodeGen);
        flags = OLAPCube.setCodegenFlag(flags, 8, initializeCodeGen);
        flags = OLAPCube.setCodegenFlag(flags, 2, saveProcCode);
        return this.generateCodeShortForm(flags);
    }

    public StringBuffer generateCodeManualTuning(boolean saveProcCode) throws OLAPException {
        this.verifyErrorLevelChecked();
        int flags = 0;
        flags = OLAPCube.setCodegenFlag(flags, 2, saveProcCode);
        if (!saveProcCode) {
            flags = OLAPCube.setCodegenFlag(flags, 4, true);
            flags = OLAPCube.setCodegenFlag(flags, 8, true);
            flags = OLAPCube.setCodegenFlag(flags, 1, true);
        } else {
            flags = OLAPCube.setCodegenFlag(flags, 16, true);
        }
        return this.generateCodeShortForm(flags);
    }

    private void addSharedProcOlapCode(int flags, StringBuffer code) throws OLAPException {
        code.append(ModelUtilities.newline);
        code.append(this.generateCodeProcOlapCubeEquals(this.getFolder(), false));
        code.append(this.generateCodeManualTuneOptions());
        code.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        boolean saveProcCode = OLAPCube.getCodegenFlag(flags, 2);
        code.append(this.generateCodeMetasrvStatement(this.getAssociatedOLAPSchema(), saveProcCode));
        StringBuffer manualTune = this.generateCodeManualTuningHidden();
        if (manualTune.length() > 0) {
            code.append(manualTune);
        }
        code.append(this.generateCodeRunStatement());
        boolean genRCSetCalls = OLAPCube.getCodegenFlag(flags, 8);
        if (genRCSetCalls) {
            code.append(this.generateRCMacro());
        }
    }

    private StringBuffer generateCodeManualTuningHidden() throws OLAPException {
        StringBuffer manualTuning = new StringBuffer();
        if (this.physicallyExists()) {
            OLAPAggregation aggregation;
            int i;
            if (this.aggregationSet == null) {
                this.getAggregationSet();
            }
            OLAPList dropAggregations = this.aggregationSet.getDroppedAggregations();
            OLAPList addAggregations = this.aggregationSet.getAddedAggregations();
            int iSize = dropAggregations.size();
            for (i = 0; i < iSize; ++i) {
                if (i == 0) {
                    manualTuning.append(ModelUtilities.newline);
                }
                manualTuning.append("   DROP_AGGREGATION");
                aggregation = (OLAPAggregation)dropAggregations.get(i);
                boolean isDeleted = aggregation.isDeleted();
                aggregation.setDeleted(false);
                OLAPList aggregationLevels = aggregation.getLevels();
                int jSize = aggregationLevels.size();
                for (int j = 0; j < jSize; ++j) {
                    OLAPLevel level = (OLAPLevel)aggregationLevels.get(j);
                    manualTuning.append(ModelUtilities.newline).append("      ").append(ModelUtilities.getSasName(level.getName()));
                }
                aggregation.setDeleted(isDeleted);
                manualTuning.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
            }
            iSize = addAggregations.size();
            for (i = 0; i < iSize; ++i) {
                aggregation = (OLAPAggregation)addAggregations.get(i);
                manualTuning.append(aggregation.generateCode());
            }
        }
        return manualTuning;
    }

    private StringBuffer generateCodeManualTuneOptions() throws OLAPException {
        StringBuffer tuneOptions = new StringBuffer();
        if (this.physicallyExists()) {
            OLAPList addAggregations;
            if (this.aggregationSet == null) {
                this.getAggregationSet();
            }
            if (!(addAggregations = this.aggregationSet.getAddedAggregations()).isEmpty()) {
                Integer value = this.getPerformanceOptionIndexSortSize();
                if (this.changedPerformanceIndexSortSize && value != null) {
                    tuneOptions.append(ModelUtilities.newline).append("   INDEXSORTSIZE          = ");
                    tuneOptions.append(value.toString());
                }
                value = this.getPerformanceOptionConcurrent();
                if (this.changedPerformanceConcurrent && value != null) {
                    tuneOptions.append(ModelUtilities.newline).append("   CONCURRENT             = ");
                    tuneOptions.append(value.toString());
                }
                value = this.getPerformanceOptionMaxThreads();
                if (this.changedPerformanceMaxThreads && value != null) {
                    tuneOptions.append(ModelUtilities.newline).append("   MAXTHREADS             = ");
                    tuneOptions.append(value.toString());
                }
                value = this.getPerformanceOptionAsyncIndexLimit();
                if (this.changedPerformanceAsyncIndexLimit && value != null) {
                    tuneOptions.append(ModelUtilities.newline).append("   ASYNCINDEXLIMIT        = ");
                    tuneOptions.append(value.toString());
                }
            }
        }
        return tuneOptions;
    }

    StringBuffer generateCodeMetasrvStatement(OLAPSchema inputSchema, boolean saveProcCode) throws OLAPException {
        StringBuffer procOlapMetasrv = new StringBuffer();
        String schemaName = null;
        try {
            schemaName = inputSchema.getName();
            procOlapMetasrv.append(ModelUtilities.newline).append("   METASVR").append(ModelUtilities.newline);
            if (saveProcCode) {
                OMIServer metaServer = Workspace.getWorkspace().getMetadataServer();
                String host = metaServer.getHost();
                int port = metaServer.getPort();
                procOlapMetasrv.append("      HOST        = ").append("\"").append(host).append("\"").append(ModelUtilities.newline);
                procOlapMetasrv.append("      PORT        = ").append(port).append(ModelUtilities.newline);
            }
            procOlapMetasrv.append("      OLAP_SCHEMA = ").append("\"").append(schemaName).append("\"");
            procOlapMetasrv.append(";").append(ModelUtilities.newline);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (ServiceException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return procOlapMetasrv;
    }

    private StringBuffer generateRCMacro() {
        StringBuffer shortForm = new StringBuffer();
        shortForm.append(ModelUtilities.newline).append("%rcSet(&syserr);").append(ModelUtilities.newline);
        return shortForm;
    }

    StringBuffer generateCodeRunStatement() {
        StringBuffer procOlapRun = new StringBuffer();
        return procOlapRun.append(ModelUtilities.newline).append("   RUN;");
    }

    Tree getOriginalFolder() throws OLAPException {
        if (this.originalFolder == null && this.metadataObject != null) {
            try {
                Cube cube = (Cube)this.metadataObject;
                AssociationList trees = cube.getTrees(false);
                if (!trees.isEmpty()) {
                    this.originalFolder = (Tree)trees.get(0);
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return this.originalFolder;
    }

    String getOriginalName() {
        String tempName = this.originalName;
        if (tempName == null) {
            tempName = this.name;
        }
        return tempName;
    }

    private OLAPSchema getOriginalSchema() {
        OLAPSchema tempSchema = this.originalSchema;
        if (tempSchema == null) {
            tempSchema = this.schema;
        }
        return tempSchema;
    }

    public AggregationSet getAggregationSet() {
        this.verifyErrorLevelChecked();
        if (this.aggregationSet == null) {
            this.aggregationSet = new AggregationSet(this);
        }
        return this.aggregationSet;
    }

    public List getAllMLSIds() throws OLAPException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Integer id = this.getMLSID();
        if (id != null) {
            ids.add(id);
        }
        OLAPList measures = this.getMeasureSet().getMeasures();
        for (int mNum = 0; mNum < measures.size(); ++mNum) {
            OLAPMeasure measure = (OLAPMeasure)measures.get(mNum);
            id = measure.getMLSID();
            if (id == null) continue;
            ids.add(id);
        }
        DefinedMemberSet definedMembers = this.getDefinedMemberSet();
        OLAPList calcMbrs = definedMembers.getDefinedMembers();
        for (int calcNum = 0; calcNum < calcMbrs.size(); ++calcNum) {
            OLAPDefinedMember calcMbr = (OLAPDefinedMember)calcMbrs.get(calcNum);
            id = calcMbr.getMLSID();
            if (id == null) continue;
            ids.add(id);
        }
        OLAPList dims = this.getDimensionSet().getCubeDimensions();
        for (int dimNum = 0; dimNum < dims.size(); ++dimNum) {
            OLAPDimension dim = (OLAPDimension)dims.get(dimNum);
            MLSCaptionTable dimTable = dim.getMLSCaptionTable();
            if (dimTable != null) continue;
            id = dim.getMLSID();
            if (id != null) {
                ids.add(id);
            }
            OLAPList hiers = dim.getHierarchies();
            for (int hierNum = 0; hierNum < hiers.size(); ++hierNum) {
                OLAPHierarchy hier = (OLAPHierarchy)hiers.get(hierNum);
                id = hier.getAllMemberMLSID();
                if (id != null) {
                    ids.add(id);
                }
                if ((id = hier.getMLSID()) == null) continue;
                ids.add(id);
            }
            OLAPList levels = dim.getLevels();
            for (int levNum = 0; levNum < levels.size(); ++levNum) {
                OLAPLevel level = (OLAPLevel)levels.get(levNum);
                id = level.getMLSID();
                if (id != null) {
                    ids.add(id);
                }
                OLAPList props = level.getOLAPProperties();
                for (int propNum = 0; propNum < props.size(); ++propNum) {
                    OLAPMemberProperty prop = (OLAPMemberProperty)props.get(propNum);
                    id = prop.getMLSID();
                    if (id == null) continue;
                    ids.add(id);
                }
            }
        }
        return ids;
    }

    public OLAPSchema getAssociatedOLAPSchema() throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.schema == null && this.metadataObject != null) {
            Cube jomaCube = (Cube)this.metadataObject;
            try {
                OLAPSchema tempSchema = jomaCube.getAssociatedOLAPSchema();
                if (tempSchema != null) {
                    this.schema = ModelUtilities.getOLAPSchema(tempSchema.getName(), this.getObjectStore());
                }
            }
            catch (MdException oError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), oError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return this.schema;
    }

    @Override
    public String getDesc() {
        this.verifyErrorLevelChecked();
        if (ModelUtilities.isBlank(this.description) && this.metadataObject != null) {
            Cube cube = (Cube)this.metadataObject;
            try {
                AssociationList descriptions = cube.getNotes(false);
                boolean found = false;
                int i = descriptions.size() - 1;
                while (i >= 0 & !found) {
                    TextStore textStore = (TextStore)descriptions.get(i);
                    if (textStore.getTextRole().equalsIgnoreCase("OLAP Description")) {
                        this.description = textStore.getStoredText();
                        found = true;
                    }
                    --i;
                }
            }
            catch (MdException mdError) {
                throw new UnsupportedOperationException(mdError.getLocalizedMessage());
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            if (ModelUtilities.isBlank(this.description)) {
                super.getDesc();
            }
        }
        return this.description;
    }

    public DefinedMemberSet getDefinedMemberSet() throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.definedMemberSet == null) {
            this.definedMemberSet = new DefinedMemberSet(this);
        }
        return this.definedMemberSet;
    }

    public DimensionSet getDimensionSet() {
        this.verifyErrorLevelChecked();
        if (this.dimensionSet == null) {
            this.dimensionSet = new DimensionSet(this);
        }
        return this.dimensionSet;
    }

    public String getDrillThruMemPref() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnValue = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.dtMemPRef == null && this.metadataObject != null && !this.deleteDtMemPref) {
            this.dtMemPRef = this.getOptionsSet().getOption(this, "DTMEMPREF", "OLAP UDT");
        }
        if (this.dtMemPRef != null) {
            returnValue = this.dtMemPRef.getDefaultValue();
        }
        return returnValue;
    }

    public String getEmptyChar() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnValue = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.emptyChar == null && this.metadataObject != null && !this.deleteEmptyChar) {
            this.emptyChar = this.getOptionsSet().getOption(this, "EMPTY_CHAR", "OLAPOption");
        }
        if (this.emptyChar != null) {
            returnValue = this.emptyChar.getDefaultValue();
        }
        return returnValue;
    }

    public String getEmptyNum() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnValue = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.emptyNum == null && this.metadataObject != null && !this.deleteEmptyNum) {
            this.emptyNum = this.getOptionsSet().getOption(this, "EMPTY_NUM", "OLAPOption");
        }
        if (this.emptyNum != null) {
            returnValue = this.emptyNum.getDefaultValue();
        }
        return returnValue;
    }

    public int getErrorLevel() {
        this.errorLevelChecked = true;
        return this.errorLevel;
    }

    public Tree getFolder() throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.folder == null) {
            AssociationList trees = null;
            if (!this.isNewObject()) {
                try {
                    Cube cube = (Cube)this.metadataObject;
                    trees = cube.getTrees(false);
                    if (!trees.isEmpty()) {
                        this.folder = (Tree)trees.get(0);
                    }
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                }
            }
            if (this.folder == null) {
                this.folder = ModelUtilities.getDefaultFolder(this.objectStore);
            }
            if (this.folder == null) {
                this.getAssociatedOLAPSchema();
                if (this.schema != null) {
                    this.folder = ModelUtilities.getDefaultFolder(this.schema, this.objectStore);
                }
            }
        }
        if (this.folder != null) {
            try {
                Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.folder, null, null, "", 8);
            }
            catch (MdException e) {
                this.folder = null;
            }
            catch (RemoteException e) {
                this.folder = null;
            }
        }
        return this.folder;
    }

    public List getGenerations() throws OLAPException {
        ArrayList allGenerations = new ArrayList();
        ArrayList<Cube> generations = new ArrayList<Cube>();
        try {
            if (this.metadataObject != null) {
                Cube selectedJomaCube = (Cube)this.metadataObject;
                ArrayList<String> cubeAssociations = new ArrayList<String>();
                cubeAssociations.add("PreviousGeneration");
                AssociationList listOfCubes = selectedJomaCube.getPreviousGenerations(false);
                Cube jomaCube = null;
                do {
                    if (listOfCubes.isEmpty()) continue;
                    jomaCube = (Cube)listOfCubes.get(0);
                    generations.add(jomaCube);
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)jomaCube, null, cubeAssociations, null, 8);
                    listOfCubes = jomaCube.getPreviousGenerations(false);
                } while (!listOfCubes.isEmpty());
                for (int i = generations.size() - 1; i > -1; --i) {
                    allGenerations.add(generations.get(i));
                }
                allGenerations.add(selectedJomaCube);
                cubeAssociations.clear();
                cubeAssociations.add("NextGeneration");
                listOfCubes = selectedJomaCube.getNextGenerations(false);
                do {
                    if (listOfCubes.isEmpty()) continue;
                    jomaCube = (Cube)listOfCubes.get(0);
                    allGenerations.add(jomaCube);
                    Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)jomaCube, null, cubeAssociations, null, 8);
                    listOfCubes = jomaCube.getNextGenerations(false);
                } while (!listOfCubes.isEmpty());
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(mdError.getLocalizedMessage(), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return allGenerations;
    }

    public String getFormatSearchOptions() throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.formatSearchOptions == null && !this.isNewObject()) {
            try {
                TextStore storedFormatSearchOption = null;
                Cube cube = (Cube)this.metadataObject;
                AssociationList cubeNotes = cube.getNotes(false);
                boolean found = false;
                int i = 0;
                int size = cubeNotes.size();
                while (i < size & !found) {
                    TextStore note = (TextStore)cubeNotes.elementAt(i);
                    if (note.getName().equals("OLAPFMTSEARCH")) {
                        found = true;
                        storedFormatSearchOption = note;
                    }
                    ++i;
                }
                if (storedFormatSearchOption != null) {
                    this.formatSearchOptions = storedFormatSearchOption.getStoredText();
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        if (this.formatSearchOptions == null) {
            this.formatSearchOptions = "";
        }
        return this.formatSearchOptions;
    }

    public MeasureSet getMeasureSet() throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.measureSet == null) {
            this.measureSet = new MeasureSet(this);
        }
        return this.measureSet;
    }

    public LanguageSet getLanguageSet() throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.languageSet == null) {
            this.languageSet = new LanguageSet(this);
        }
        return this.languageSet;
    }

    public String getLocale() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.locale == null && this.metadataObject != null && !this.deleteLocale) {
            this.locale = this.optionSet.getOption(this, "Locale", "OLAP Linguistic");
        }
        if (this.locale != null) {
            this.locale.setPropertyOption(true);
            this.locale.setPropertySetOption(true);
            returnOption = this.locale.getDefaultValue();
        }
        return returnOption;
    }

    public String getCaptionTableMemPref() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnValue = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.captionPref == null && this.metadataObject != null && !this.deleteCaptionPref) {
            this.captionPref = this.getOptionsSet().getOption(this, this.getName() + "_cappref", "OLAP UDT");
        }
        if (this.captionPref != null) {
            returnValue = this.captionPref.getDefaultValue();
        }
        return returnValue;
    }

    public String getCollation() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.collation == null && this.metadataObject != null && !this.deleteCollation) {
            this.collation = this.optionSet.getOption(this, "Collation", "OLAP Linguistic");
        }
        if (this.collation != null) {
            this.collation.setPropertyOption(true);
            this.collation.setPropertySetOption(true);
            returnOption = this.collation.getDefaultValue();
        }
        return returnOption;
    }

    public String getMissingDimensionKeys() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnValue = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.missingKeys == null && this.metadataObject != null && !this.deleteMissingKeys) {
            this.missingKeys = this.optionSet.getOption(this, "IGNORE_MISSING_DIMKEYS", "OLAPOption");
        }
        if (this.missingKeys != null) {
            returnValue = this.missingKeys.getDefaultValue();
        }
        return returnValue;
    }

    public MLSCaptionTable getMLSCaptionTable() throws OLAPException {
        if (this.mlsCaptionTable == null && this.metadataObject != null && !this.deleteMLSCaptionTable) {
            try {
                Cube jomaCube = (Cube)this.metadataObject;
                CustomAssociation custom = null;
                AssociationList customs = jomaCube.getCustomAssociations();
                if (!customs.isEmpty()) {
                    int i = 0;
                    int size = customs.size();
                    while (i < size & custom == null) {
                        CustomAssociation nextCustom;
                        CMetadata object = (CMetadata)customs.elementAt(i);
                        if (object.getCMetadataType().equalsIgnoreCase("CustomAssociation") && (nextCustom = (CustomAssociation)object).getPartnerName().equals("CaptionTableObject")) {
                            custom = nextCustom;
                        }
                        ++i;
                    }
                    if (custom != null) {
                        AssociationList associatedObjects = custom.getAssociatedObjects();
                        int t = 0;
                        int aosize = associatedObjects.size();
                        while (t < aosize & this.mlsCaptionTable == null) {
                            CMetadata object = (CMetadata)associatedObjects.elementAt(t);
                            if (object.getCMetadataType().equalsIgnoreCase("PhysicalTable")) {
                                this.mlsCaptionTable = new MLSCaptionTable(this.getTableSet(), (PhysicalTable)object);
                            }
                            ++t;
                        }
                        if (this.mlsCaptionTable != null) {
                            this.getCaptionTableMemPref();
                        }
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.mlsCaptionTable;
    }

    public OLAPMemberPropertySet getOLAPMemberPropertySet() {
        this.verifyErrorLevelChecked();
        if (this.propertySet == null) {
            this.propertySet = new OLAPMemberPropertySet(this);
        }
        return this.propertySet;
    }

    public String getCompact() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnValue = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.compact == null && this.metadataObject != null && !this.deleteCompact) {
            this.compact = this.optionSet.getOption(this, "COMPACT_NWAY", "OLAPOption");
        }
        if (this.compact != null) {
            returnValue = this.compact.getDefaultValue();
        }
        return returnValue;
    }

    public String getCreateDate() throws OLAPException {
        String returnValue = " ";
        try {
            if (this.metadataObject != null) {
                returnValue = this.metadataObject.getMetadataCreated();
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return returnValue;
    }

    public StringBuffer getCubeVerifyMessage() {
        if (this.cubeVerifyMessage == null) {
            this.cubeVerifyMessage = new StringBuffer();
        }
        this.errorLevelChecked = true;
        return this.cubeVerifyMessage;
    }

    public String getCubeFolder() throws OLAPException {
        String returnValue = "";
        Option cubeFolder = this.optionSet.getOption(this, "CUBEFOLDER", "OLAPOption");
        if (cubeFolder != null) {
            returnValue = cubeFolder.getDefaultValue();
        }
        return returnValue;
    }

    public List getCubeMessage() {
        if (this.cubeMessage == null) {
            this.cubeMessage = new ArrayList();
        }
        return this.cubeMessage;
    }

    public MdObjectStore getObjectStore() {
        this.verifyErrorLevelChecked();
        try {
            if (this.objectStore == null && this.metadataObject != null) {
                this.objectStore = (MdObjectStore)this.metadataObject.getObjectStore();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.objectStore;
    }

    public TableSet getTableSet() {
        this.verifyDeleted();
        if (this.tableSet == null) {
            this.tableSet = new TableSet(this);
        }
        return this.tableSet;
    }

    public OptionSet getOptionsSet() {
        this.verifyErrorLevelChecked();
        if (this.optionSet == null) {
            this.optionSet = new OptionSet(this);
        }
        return this.optionSet;
    }

    public String getPath() throws OLAPException {
        this.verifyErrorLevelChecked();
        try {
            if (this.path == null && !this.isNewObject()) {
                File file;
                AssociationList directories;
                Cube jomaCube = (Cube)this.metadataObject;
                Directory directory = null;
                AssociationList files = jomaCube.getAssociatedFiles(false);
                if (!files.isEmpty() && !(directories = (file = (File)files.get(0)).getDirectories(false)).isEmpty()) {
                    directory = (Directory)directories.get(0);
                }
                if (directory != null) {
                    this.path = directory.getDirectoryName();
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        return this.path;
    }

    String getPerformanceOptions() throws OLAPException {
        String options = "";
        options = options + "COMPRESS=" + this.getPerformanceOptionCompress() + " ";
        options = options + "CONCURRENT=" + this.getPerformanceOptionConcurrent() + " ";
        options = options + "DATAPATH=" + this.getPerformanceOptionDatapath() + " ";
        options = options + "INDEX=" + this.getPerformanceOptionIndex() + " ";
        options = options + "INDEXPATH=" + this.getPerformanceOptionIndexpath() + " ";
        options = options + "INDEXSORTSIZE=" + this.getPerformanceOptionIndexSortSize() + " ";
        options = options + "MAXTHREADS=" + this.getPerformanceOptionMaxThreads() + " ";
        options = options + "ASYNCINDEXLIMIT=" + this.getPerformanceOptionAsyncIndexLimit() + " ";
        options = options + "PARTSIZE=" + this.getPerformanceOptionPartsize() + " ";
        options = options + "SEGSIZE=" + this.getPerformanceOptionSegsize();
        return options;
    }

    public Boolean getPerformanceOptionCompress() throws OLAPException {
        this.verifyErrorLevelChecked();
        Boolean returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.performanceOptionCompress == null && this.metadataObject != null && !this.deletePerformanceOptionCompress) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionCompress = this.optionSet.getOption(this, "COMPRESS", "OLAPOption");
        }
        if (this.performanceOptionCompress != null) {
            this.performanceOptionCompress.setPropertyOption(true);
            returnOption = this.performanceOptionCompress.getDefaultValue().equals("1");
        }
        return returnOption;
    }

    public Integer getPerformanceOptionConcurrent() throws OLAPException {
        this.verifyErrorLevelChecked();
        Integer returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.performanceOptionConcurrent == null && this.metadataObject != null && !this.deletePerformanceOptionConcurrent) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionConcurrent = this.optionSet.getOption(this, "CONCURRENT", "OLAPOption");
        }
        if (this.performanceOptionConcurrent != null) {
            this.performanceOptionConcurrent.setPropertyOption(true);
            returnOption = Integer.valueOf(this.performanceOptionConcurrent.getDefaultValue());
        }
        return returnOption;
    }

    public String getPerformanceOptionDatapath() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.performanceOptionDatapath == null && this.metadataObject != null && !this.deletePerformanceOptionDatapath) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionDatapath = this.optionSet.getOption(this, "DATAPATH", "OLAPOption");
        }
        if (this.performanceOptionDatapath != null) {
            int metadataVersion = Workspace.getMetadataServerVersionNumber();
            if (metadataVersion >= 9200) {
                this.performanceOptionDatapath.setPropertyOption(false);
            } else {
                this.performanceOptionDatapath.setPropertyOption(true);
            }
            returnOption = this.performanceOptionDatapath.getDefaultValue();
        }
        return returnOption;
    }

    public Boolean getPerformanceOptionIndex() throws OLAPException {
        this.verifyErrorLevelChecked();
        Boolean returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.performanceOptionIndex == null && this.metadataObject != null && !this.deletePerformanceOptionIndex) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionIndex = this.optionSet.getOption(this, "INDEX", "OLAPOption");
        }
        if (this.performanceOptionIndex != null) {
            this.performanceOptionIndex.setPropertyOption(true);
            returnOption = this.performanceOptionIndex.getDefaultValue().equals("1");
        }
        return returnOption;
    }

    public String getPerformanceOptionIndexpath() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.performanceOptionIndexpath == null && this.metadataObject != null && !this.deletePerformanceOptionIndexpath) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionIndexpath = this.optionSet.getOption(this, "INDEXPATH", "OLAPOption");
        }
        if (this.performanceOptionIndexpath != null) {
            int metadataVersion = Workspace.getMetadataServerVersionNumber();
            if (metadataVersion >= 9200) {
                this.performanceOptionIndexpath.setPropertyOption(false);
            } else {
                this.performanceOptionIndexpath.setPropertyOption(true);
            }
            returnOption = this.performanceOptionIndexpath.getDefaultValue();
        }
        return returnOption;
    }

    public Integer getPerformanceOptionIndexSortSize() throws OLAPException {
        this.verifyErrorLevelChecked();
        Integer returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.performanceOptionIndexSortSize == null && this.metadataObject != null && !this.deletePerformanceOptionIndexSortSize) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionIndexSortSize = this.optionSet.getOption(this, "INDEXSORTSIZE", "OLAPOption");
        }
        if (this.performanceOptionIndexSortSize != null) {
            this.performanceOptionIndexSortSize.setPropertyOption(true);
            returnOption = Integer.valueOf(this.performanceOptionIndexSortSize.getDefaultValue());
        }
        return returnOption;
    }

    public Integer getPerformanceOptionMaxThreads() throws OLAPException {
        this.verifyErrorLevelChecked();
        Integer returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.performanceOptionMaxThreads == null && this.metadataObject != null && !this.deletePerformanceOptionMaxThreads) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionMaxThreads = this.optionSet.getOption(this, "MAXTHREADS", "OLAPOption");
        }
        if (this.performanceOptionMaxThreads != null) {
            this.performanceOptionMaxThreads.setPropertyOption(true);
            returnOption = Integer.valueOf(this.performanceOptionMaxThreads.getDefaultValue());
        }
        return returnOption;
    }

    public Integer getPerformanceOptionAsyncIndexLimit() throws OLAPException {
        this.verifyErrorLevelChecked();
        Integer returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.performanceOptionAsyncIndexLimit == null && this.metadataObject != null && !this.deletePerformanceOptionAsyncIndexLimit) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionAsyncIndexLimit = this.optionSet.getOption(this, "ASYNCINDEXLIMIT", "OLAPOption");
        }
        if (this.performanceOptionAsyncIndexLimit != null) {
            this.performanceOptionAsyncIndexLimit.setPropertyOption(true);
            returnOption = Integer.valueOf(this.performanceOptionAsyncIndexLimit.getDefaultValue());
        }
        return returnOption;
    }

    public Integer getPerformanceOptionPartsize() throws OLAPException {
        this.verifyErrorLevelChecked();
        Integer returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.performanceOptionPartsize == null && this.metadataObject != null && !this.deletePerformanceOptionPartsize) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionPartsize = this.optionSet.getOption(this, "PARTSIZE", "OLAPOption");
        }
        if (this.performanceOptionPartsize != null) {
            this.performanceOptionPartsize.setPropertyOption(true);
            returnOption = Integer.valueOf(this.performanceOptionPartsize.getDefaultValue());
        }
        return returnOption;
    }

    public Integer getPerformanceOptionSegsize() throws OLAPException {
        this.verifyErrorLevelChecked();
        Integer returnOption = null;
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.performanceOptionSegsize == null && this.metadataObject != null && !this.deletePerformanceOptionSegsize) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionSegsize = this.optionSet.getOption(this, "SEGSIZE", "OLAPOption");
        }
        if (this.performanceOptionSegsize != null) {
            this.performanceOptionSegsize.setPropertyOption(true);
            returnOption = Integer.valueOf(this.performanceOptionSegsize.getDefaultValue());
        }
        return returnOption;
    }

    public List getPerformanceOptionTypes() {
        this.verifyErrorLevelChecked();
        this.getOptionsSet();
        return this.optionSet.getPerformanceTypes();
    }

    public String getUpdatedDate() throws OLAPException {
        String returnValue = " ";
        try {
            if (this.metadataObject != null) {
                returnValue = this.metadataObject.getMetadataUpdated();
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        return returnValue;
    }

    public String getPhysicalName() {
        try {
            if (this.physicalName == null) {
                this.physicalName = "";
                if (this.metadataObject != null) {
                    Cube jomaCube = (Cube)this.metadataObject;
                    this.physicalName = jomaCube.getCubeName();
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.physicalName;
    }

    public String getType() {
        this.verifyErrorLevelChecked();
        try {
            if (this.type == null) {
                this.type = "MOLAP";
                if (this.metadataObject != null) {
                    Cube jomaCube = (Cube)this.metadataObject;
                    this.type = jomaCube.getCubeType();
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.type;
    }

    public String getUpdateableDimensions() throws OLAPException {
        String returnValue = null;
        if (this.updateableDimensions == null && this.metadataObject != null && !this.deleteUpdateableDimensions) {
            this.updateableDimensions = this.optionSet.getOption(this, "NONUPDATEABLE", "OLAPOption");
        }
        if (this.updateableDimensions != null) {
            return this.updateableDimensions.getDefaultValue();
        }
        return returnValue;
    }

    public String getSASCode() throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.sasCode == null && this.metadataObject != null) {
            TextStore storedSASCode = null;
            try {
                Cube cube = (Cube)this.metadataObject;
                AssociationList cubeNotes = cube.getNotes(false);
                boolean found = false;
                int i = cubeNotes.size() - 1;
                while (i >= 0 & !found) {
                    TextStore note = (TextStore)cubeNotes.elementAt(i);
                    if (note.getName().equals("OLAPSASCode")) {
                        storedSASCode = note;
                        found = true;
                    }
                    --i;
                }
                if (storedSASCode != null) {
                    this.sasCode = storedSASCode.getStoredText();
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        if (this.sasCode == null) {
            this.sasCode = "";
        }
        return this.sasCode;
    }

    public String getSecuritySubset() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnValue = "NO";
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.securitySubset == null && this.metadataObject != null && !this.deleteSecuritySubset) {
            this.securitySubset = this.optionSet.getOption(this, "SECURITY_SUBSET", "OLAPOption");
        }
        if (this.securitySubset != null && this.securitySubset.getDefaultValue().equalsIgnoreCase("YES")) {
            returnValue = "YES";
        }
        return returnValue;
    }

    public String getTableOptions() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnValue = "";
        if (this.optionSet == null) {
            this.getOptionsSet();
        }
        if (this.tableOptions == null && this.metadataObject != null && !this.deleteTableOptions) {
            if (this.getTableSet().getLoadType().equals(TableSet.FULLY_SUMMARIZED)) {
                OLAPAggregation defaultAggregation = this.getAggregationSet().getDefaultAggregation();
                this.tableOptions = this.optionSet.getOption(defaultAggregation, "AggregationTable_options", "OLAP Table Options");
            } else {
                this.tableOptions = this.optionSet.getOption(this, "LoadTable_options", "OLAP Table Options");
            }
        }
        if (this.tableOptions != null) {
            returnValue = this.tableOptions.getDefaultValue();
        }
        return returnValue;
    }

    String getReachThruTableOptions() throws OLAPException {
        ReachThruTable reachthruTable = this.tableSet.getReachThruTable();
        String returnValue = "";
        if (reachthruTable != null) {
            PhysicalTable jomaTable = reachthruTable.getTable();
            if (this.optionSet == null) {
                this.getOptionsSet();
            }
            if (this.reachThruTableOptions == null && this.metadataObject != null && !this.deleteReachThruTableOptions) {
                this.reachThruTableOptions = this.optionSet.getOption(this, "ReachthruTable_options", "OLAP Table Options");
            }
            if (this.reachThruTableOptions != null) {
                returnValue = this.reachThruTableOptions.getDefaultValue();
            }
            if (this.reachthruMap == null) {
                this.reachthruMap = new HashMap();
            }
            if (ModelUtilities.isBlank(returnValue)) {
                String mapOptions = (String)this.reachthruMap.get(jomaTable);
                if (!ModelUtilities.isBlank(mapOptions)) {
                    returnValue = mapOptions;
                }
            } else {
                this.reachthruMap.put(jomaTable, returnValue);
            }
        }
        return returnValue;
    }

    public String getWorkPath() throws OLAPException {
        this.verifyErrorLevelChecked();
        String returnValue = "";
        if (this.workPath == null && this.metadataObject != null && !this.deleteWorkPath) {
            this.workPath = this.getOptionsSet().getOption(this, "WORKPATH", "OLAPOption");
        }
        if (this.workPath != null) {
            int metadataVersion = Workspace.getMetadataServerVersionNumber();
            if (metadataVersion >= 9200) {
                this.workPath.setPropertyOption(false);
            } else {
                this.workPath.setPropertyOption(true);
            }
            returnValue = this.workPath.getDefaultValue();
        }
        return returnValue;
    }

    public String getMinorNumber() {
        return "0";
    }

    public String getMicroNumber() {
        return "0";
    }

    public UsageVersion getVersionNumber() {
        return this.usageVersion;
    }

    boolean hasPerformanceOptions() throws OLAPException {
        return this.getPerformanceOptionCompress() != null || this.getPerformanceOptionDatapath() != null || this.getPerformanceOptionIndex() != null || this.getPerformanceOptionIndexpath() != null || this.getPerformanceOptionPartsize() != null || this.getPerformanceOptionSegsize() != null;
    }

    public boolean hasStructure() throws OLAPException {
        boolean structure = true;
        List dimensions = this.dimensionSet.getAllCubeDimensions();
        OLAPList measures = this.measureSet.getMeasures();
        structure = dimensions.size() + measures.size() > 0;
        return structure;
    }

    public boolean hasValidStructure() throws OLAPException {
        boolean structure = true;
        List dimensions = this.dimensionSet.getAllCubeDimensions();
        OLAPList measures = this.measureSet.getMeasures();
        structure = dimensions.size() > 0 || measures.size() > 0;
        return structure;
    }

    public boolean isAddData() {
        return this.addData;
    }

    public boolean isLanguageChanged() {
        return this.languagedChanged;
    }

    public boolean isMissingOLAPSchema() {
        return this.missingOLAPSchema;
    }

    public boolean isESRI() throws OLAPException {
        this.getDimensionSet();
        boolean esri = false;
        List listOfDimensions = this.dimensionSet.getAllCubeDimensions();
        int i = 0;
        int size = listOfDimensions.size();
        while (i < size & !esri) {
            OLAPDimension dimension = (OLAPDimension)listOfDimensions.get(i);
            if (dimension.isGeography()) {
                esri = true;
                ServerComponent esriServerComponent = dimension.getMapServer();
                try {
                    if (esriServerComponent != null) {
                        this.esriServerName = esriServerComponent.getName();
                    }
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                }
            }
            ++i;
        }
        return esri;
    }

    public boolean isSpecialCharactersName() {
        boolean hasSpecialCharacters = false;
        char[] invalidChars = new char[]{'*', '/', '\'', '\"', ':', ';', '?', '<', '>'};
        boolean found = false;
        int i = 0;
        while (i < invalidChars.length & !found) {
            char invalidChar = invalidChars[i];
            found = this.name.indexOf(invalidChar) > -1;
            ++i;
        }
        if (found) {
            hasSpecialCharacters = true;
        }
        return hasSpecialCharacters;
    }

    public boolean needsReorganizing() throws OLAPException {
        this.getDimensionSet();
        OLAPList dims = this.dimensionSet.getCubeDimensions();
        boolean needsReorg = false;
        for (int dimNum = 0; dimNum < dims.size() && !needsReorg; ++dimNum) {
            OLAPDimension dim = (OLAPDimension)dims.get(dimNum);
            OLAPList levels = dim.getLevels();
            for (int levNum = 0; levNum < levels.size() && !needsReorg; ++levNum) {
                OLAPLevel level = (OLAPLevel)levels.get(levNum);
                needsReorg = level.needsReorganizing();
            }
        }
        return needsReorg;
    }

    public void reset() throws OLAPException {
        this.verifyErrorLevelChecked();
        List listOfDimensions = this.dimensionSet.getAllCubeDimensions();
        OLAPList listOfDimensionTables = this.dimensionSet.getTables();
        OLAPList listOfMeasures = this.getMeasureSet().getMeasures();
        this.getLanguageSet();
        if (listOfDimensions != null && !listOfDimensions.isEmpty() || listOfDimensionTables != null && !listOfDimensionTables.isEmpty() || listOfMeasures != null && !listOfMeasures.isEmpty() || !ModelUtilities.isBlank(this.getSASCode()) || !ModelUtilities.isBlank(this.getFormatSearchOptions()) || this.getEmptyChar() != null || this.getEmptyNum() != null || this.languageSet.getSelectedLocales().size() > 0 || this.getCompact() != null) {
            this.setMissingDimensionKeys(null);
            if (this.dimensionSet != null) {
                this.dimensionSet.reset();
            }
            if (this.propertySet != null) {
                this.propertySet.reset();
            }
            if (this.measureSet != null) {
                this.measureSet.reset();
            }
            this.getDefinedMemberSet();
            if (this.definedMemberSet != null) {
                this.definedMemberSet.reset();
            }
            if (this.aggregationSet != null) {
                this.aggregationSet.reset();
            }
            if (this.tableSet != null) {
                this.tableSet.reset();
            }
            this.resetOptions();
        }
    }

    public void resetOptions() throws OLAPException {
        if (this.resetCompactNwayOption) {
            this.setCompact(null);
        }
        if (this.resetDimensionTableTranslations) {
            if (this.languageSet == null) {
                this.getLanguageSet();
            }
            this.languageSet.reset();
        }
        if (this.resetSASCode) {
            this.setSASCode("");
        }
        if (this.resetFormatSearchOptions) {
            this.setFormatSearchOptions("");
        }
        if (this.resetRaggedHierarchyOptions) {
            this.setEmptyChar(null);
            this.setEmptyNum(null);
        }
    }

    public void setAddData(boolean inputAddData) {
        this.addData = inputAddData;
    }

    public void setAssociatedOLAPSchema(OLAPSchema inputSchema) {
        this.verifyErrorLevelChecked();
        this.schema = inputSchema;
        this.getOriginalSchema();
    }

    public boolean physicallyExists() {
        boolean exists = false;
        try {
            if (this.metadataObject != null) {
                Cube cube = (Cube)this.metadataObject;
                exists = !ModelUtilities.isBlank(cube.getCubeName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return exists;
    }

    public void removeAllIds() throws OLAPException {
        OLAPList dims = this.getDimensionSet().getCubeDimensions();
        for (int dimNum = 0; dimNum < dims.size(); ++dimNum) {
            OLAPDimension dim = (OLAPDimension)dims.get(dimNum);
            dim.removeDimensionIds();
        }
        this.removeOnlyCubeIds();
    }

    public void removeOnlyCubeIds() throws OLAPException {
        this.setMLSID(null);
        OLAPList measures = this.getMeasureSet().getMeasures();
        for (int mNum = 0; mNum < measures.size(); ++mNum) {
            OLAPMeasure measure = (OLAPMeasure)measures.get(mNum);
            measure.setMLSID(null);
        }
        DefinedMemberSet definedMembers = this.getDefinedMemberSet();
        OLAPList calcMeasures = definedMembers.getCalculatedMeasures();
        for (int calcNum = 0; calcNum < calcMeasures.size(); ++calcNum) {
            OLAPDefinedMember calcMeasure = (OLAPDefinedMember)calcMeasures.get(calcNum);
            calcMeasure.setMLSID(null);
        }
    }

    public void setCaptionTableMemPref(String optionValue) {
        this.verifyErrorLevelChecked();
        if (optionValue != null) {
            if (this.optionSet == null) {
                this.getOptionsSet();
            }
            this.deleteCaptionPref = false;
            if (this.captionPref == null) {
                this.captionPref = new Option(this.optionSet, this);
                this.captionPref.setName(this.getName() + "_cappref");
                this.captionPref.setDesc(this.getName() + "_cappref");
                this.captionPref.setPropertyName(this.getName() + "_cappref");
                this.captionPref.setPropertyRole("OLAP UDT");
                this.captionPref.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.captionPref.setDefaultValue(optionValue);
        } else if (this.captionPref != null) {
            List objectOptions = this.optionSet.getOptions(this);
            objectOptions.remove(this.captionPref);
            this.captionPref = null;
            this.deleteCaptionPref = true;
        }
    }

    public void setCollation(String inputCollation) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        this.collation = this.optionSet.getOption(this, "Collation", "OLAP Linguistic");
        if (inputCollation != null) {
            this.deleteCollation = false;
            if (this.collation == null) {
                this.collation = new Option(this.optionSet, this);
                this.collation.setName("Collation");
                this.collation.setDesc("Collation");
                this.collation.setPropertyRole("OLAP Linguistic");
                this.collation.setPropertyName("Collation");
                this.collation.setOwningType(OptionSet.OWNING_TYPE_STRING);
                this.collation.setPropertyOption(true);
                this.collation.setPropertySetOption(true);
            }
            this.collation.setDefaultValue(inputCollation);
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.collation) >= 0) {
                objectOptions.remove(this.collation);
            }
            this.collation = null;
            this.deleteCollation = true;
        }
    }

    @Override
    public void setDesc(String inputDescription) {
        this.verifyErrorLevelChecked();
        super.setDesc(inputDescription);
    }

    public void setDrillThruMemPref(String optionValue) throws OLAPException {
        this.verifyErrorLevelChecked();
        this.getDrillThruMemPref();
        if (optionValue != null) {
            if (this.optionSet == null) {
                this.getOptionsSet();
            }
            this.deleteDtMemPref = false;
            if (this.dtMemPRef == null) {
                this.dtMemPRef = new Option(this.optionSet, this);
                this.dtMemPRef.setName("DTMEMPREF");
                this.dtMemPRef.setDesc("DTMEMPREF");
                this.dtMemPRef.setPropertyName("DTMEMPREF");
                this.dtMemPRef.setPropertyRole("OLAP UDT");
                this.dtMemPRef.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.dtMemPRef.setDefaultValue(optionValue);
        } else if (this.dtMemPRef != null) {
            List objectOptions = this.optionSet.getOptions(this);
            objectOptions.remove(this.dtMemPRef);
            this.dtMemPRef = null;
            this.deleteDtMemPref = true;
        }
    }

    public void setEmptyChar(String optionValue) {
        this.verifyErrorLevelChecked();
        if (optionValue != null) {
            if (this.optionSet == null) {
                this.getOptionsSet();
            }
            this.deleteEmptyChar = false;
            if (this.emptyChar == null) {
                this.emptyChar = new Option(this.optionSet, this);
                this.emptyChar.setName("EMPTY_CHAR");
                this.emptyChar.setDesc("EMPTY_CHAR");
                this.emptyChar.setPropertyName("EMPTY_CHAR");
                this.emptyChar.setPropertyRole("OLAPOption");
                this.emptyChar.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.emptyChar.setDefaultValue(optionValue);
        } else if (this.emptyChar != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.emptyChar) >= 0) {
                objectOptions.remove(this.emptyChar);
            }
            this.emptyChar = null;
            this.deleteEmptyChar = true;
        }
    }

    public void setEmptyNum(String optionValue) {
        this.verifyErrorLevelChecked();
        if (optionValue != null) {
            this.deleteEmptyNum = false;
            if (this.optionSet == null) {
                this.getOptionsSet();
            }
            if (this.emptyNum == null) {
                this.emptyNum = new Option(this.optionSet, this);
                this.emptyNum.setName("EMPTY_NUM");
                this.emptyNum.setDesc("EMPTY_NUM");
                this.emptyNum.setPropertyName("EMPTY_NUM");
                this.emptyNum.setPropertyRole("OLAPOption");
                this.emptyNum.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.emptyNum.setDefaultValue(optionValue);
        } else if (this.emptyNum != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.emptyNum) >= 0) {
                objectOptions.remove(this.emptyNum);
            }
            this.emptyNum = null;
            this.deleteEmptyNum = true;
        }
    }

    public void setErrorLevel(int inputErrorLevel) {
        this.errorLevel = inputErrorLevel;
        if (this.errorLevel == -1) {
            this.errorLevelChecked = true;
        }
    }

    public void setFolder(Tree inputFolder) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (inputFolder == null) {
            throw new IllegalArgumentException("The folder cannot be null");
        }
        if (!this.isNewObject()) {
            this.getFolder();
            if (this.folder != null) {
                String repositoryFQID = ModelUtilities.getRepositoryShortFQID(this.folder);
                String fqid = ModelUtilities.getRepositoryShortFQID(inputFolder);
                if (!fqid.equals(repositoryFQID)) {
                    try {
                        throw new OLAPException(bundle.formatString("OLAPCube.ChangeFolderRepository.fmt.txt", (Object)inputFolder.getName(), (Object)ModelUtilities.getRepositoryName(inputFolder)), 0);
                    }
                    catch (RemoteException e) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                    }
                }
            }
            this.folder = inputFolder;
        } else {
            this.folder = inputFolder;
        }
    }

    public void setFormatSearchOptions(String inputOptions) {
        this.verifyErrorLevelChecked();
        this.formatSearchOptions = inputOptions;
    }

    public void setLanguageChanged(boolean changed) {
        this.languagedChanged = changed;
    }

    public void setLocale(String inputLocale) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        this.locale = this.optionSet.getOption(this, "Locale", "OLAP Linguistic");
        if (inputLocale != null) {
            this.deleteLocale = false;
            if (this.locale == null) {
                this.locale = new Option(this.optionSet, this);
                this.locale.setName("Locale");
                this.locale.setDesc("Locale");
                this.locale.setPropertyRole("OLAP Linguistic");
                this.locale.setPropertyName("Locale");
                this.locale.setOwningType(OptionSet.OWNING_TYPE_STRING);
                this.locale.setPropertyOption(true);
                this.locale.setPropertySetOption(true);
            }
            String[] parts = inputLocale.split("_");
            String localeToStore = inputLocale;
            if (parts.length > 0) {
                localeToStore = parts[0].toLowerCase() + "_" + parts[1];
            }
            this.locale.setDefaultValue(localeToStore);
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.locale) >= 0) {
                objectOptions.remove(this.locale);
            }
            this.locale = null;
            this.deleteLocale = true;
        }
    }

    public void setMissingDimensionKeys(String optionValue) {
        this.verifyErrorLevelChecked();
        if (optionValue != null && !optionValue.equals("ERROR")) {
            this.deleteMissingKeys = false;
            if (this.optionSet == null) {
                this.getOptionsSet();
            }
            if (this.missingKeys == null) {
                this.missingKeys = new Option(this.optionSet, this);
                this.missingKeys.setName("IGNORE_MISSING_DIMKEYS");
                this.missingKeys.setDesc("IGNORE_MISSING_DIMKEYS");
                this.missingKeys.setPropertyName("IGNORE_MISSING_DIMKEYS");
                this.missingKeys.setPropertyRole("OLAPOption");
                this.missingKeys.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.missingKeys.setDefaultValue(optionValue);
        } else if (this.missingKeys != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.missingKeys) >= 0) {
                objectOptions.remove(this.missingKeys);
            }
            this.missingKeys = null;
            this.deleteMissingKeys = true;
        }
    }

    public void setMLSCaptionTable(MLSCaptionTable table) {
        this.mlsCaptionTable = table;
        if (table != null) {
            this.setCaptionTableMemPref(table.getSASTableName());
            this.deleteMLSCaptionTable = false;
        } else {
            this.setCaptionTableMemPref(null);
            this.deleteMLSCaptionTable = true;
        }
        this.setUpChanges("setMLSCaptionTable", MLSCaptionTable.class, table);
    }

    @Override
    public void setName(String inputName) {
        this.verifyErrorLevelChecked();
        super.setDesc(inputName);
        super.setName(inputName);
    }

    public void setCompact(String optionValue) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (optionValue != null && optionValue.equals("1")) {
            this.getCompact();
            if (this.optionSet == null) {
                this.getOptionsSet();
            }
            if (this.compact == null) {
                this.compact = new Option(this.optionSet, this);
                this.compact.setName("COMPACT_NWAY");
                this.compact.setDesc("COMPACT_NWAY");
                this.compact.setPropertyName("COMPACT_NWAY");
                this.compact.setPropertyRole("OLAPOption");
                this.compact.setOwningType(OptionSet.OWNING_TYPE_BOOLEAN);
            }
            this.compact.setDefaultValue(optionValue);
        } else if (this.compact != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.compact) >= 0) {
                objectOptions.remove(this.compact);
            }
            this.compact = null;
            this.deleteCompact = true;
        }
    }

    void setTesting(boolean inputTesting) {
        this.testing = inputTesting;
    }

    public void setType(String inputType) {
        this.verifyErrorLevelChecked();
        this.type = inputType;
    }

    public void setUpdateableDimensions(String optionValue) throws OLAPException {
        if (optionValue != null && optionValue.equals("1")) {
            this.deleteUpdateableDimensions = false;
            this.getUpdateableDimensions();
            if (this.updateableDimensions == null) {
                this.updateableDimensions = new Option(this.optionSet, this);
                this.updateableDimensions.setName("NONUPDATEABLE");
                this.updateableDimensions.setDesc("NONUPDATEABLE");
                this.updateableDimensions.setPropertyName("NONUPDATEABLE");
                this.updateableDimensions.setPropertyRole("OLAPOption");
                this.updateableDimensions.setOwningType(OptionSet.OWNING_TYPE_BOOLEAN);
            }
            this.updateableDimensions.setDefaultValue(optionValue);
        } else if (this.updateableDimensions != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.updateableDimensions) >= 0) {
                objectOptions.remove(this.updateableDimensions);
            }
            this.updateableDimensions = null;
            this.deleteUpdateableDimensions = true;
        }
        this.setUpChanges("setUpdateableDimensions", String.class, optionValue);
    }

    public void setPath(String inputPath) {
        this.verifyErrorLevelChecked();
        this.path = inputPath;
    }

    public void setPerformanceOptionCompress(Boolean inputCompress) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (inputCompress != null && !inputCompress.booleanValue()) {
            inputCompress = null;
        }
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        if (this.performanceOptionCompress == null) {
            this.performanceOptionCompress = this.optionSet.getOption(this, "COMPRESS", "OLAPOption");
        }
        List objectOptions = this.optionSet.getOptions(this);
        if (inputCompress != null) {
            String value = "0";
            if (inputCompress.booleanValue()) {
                value = "1";
            }
            if (this.performanceOptionCompress == null) {
                this.performanceOptionCompress = new Option(this.optionSet, this);
                this.performanceOptionCompress.setName("COMPRESS");
                this.performanceOptionCompress.setDesc("COMPRESS");
                this.performanceOptionCompress.setPropertyRole("OLAPOption");
                this.performanceOptionCompress.setPropertyName("COMPRESS");
                this.performanceOptionCompress.setOwningType(OptionSet.OWNING_TYPE_BOOLEAN);
                this.performanceOptionCompress.setPropertyOption(true);
            }
            this.performanceOptionCompress.setDefaultValue(value);
        } else {
            if (objectOptions.indexOf(this.performanceOptionCompress) >= 0) {
                objectOptions.remove(this.performanceOptionCompress);
            }
            this.performanceOptionCompress = null;
            this.deletePerformanceOptionCompress = true;
        }
    }

    public void setPerformanceOptionConcurrent(Integer inputConcurrent) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        this.performanceOptionConcurrent = this.optionSet.getOption(this, "CONCURRENT", "OLAPOption");
        if (inputConcurrent != null) {
            this.verifyPerformanceOptionConcurrent(inputConcurrent);
            if (this.performanceOptionConcurrent == null) {
                this.performanceOptionConcurrent = new Option(this.optionSet, this);
                this.performanceOptionConcurrent.setName("CONCURRENT");
                this.performanceOptionConcurrent.setDesc("CONCURRENT");
                this.performanceOptionConcurrent.setPropertyRole("OLAPOption");
                this.performanceOptionConcurrent.setPropertyName("CONCURRENT");
                this.performanceOptionConcurrent.setOwningType(OptionSet.OWNING_TYPE_INTEGER);
                this.performanceOptionConcurrent.setPropertyOption(true);
            }
            this.performanceOptionConcurrent.setDefaultValue(inputConcurrent.toString());
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionConcurrent) >= 0) {
                objectOptions.remove(this.performanceOptionConcurrent);
            }
            this.performanceOptionConcurrent = null;
            this.deletePerformanceOptionConcurrent = true;
        }
        this.changedPerformanceConcurrent = true;
    }

    public void setPerformanceOptionDatapath(String inputDatapath) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        this.performanceOptionDatapath = this.optionSet.getOption(this, "DATAPATH", "OLAPOption");
        if (inputDatapath != null) {
            if (this.performanceOptionDatapath == null) {
                this.performanceOptionDatapath = new Option(this.optionSet, this);
                this.performanceOptionDatapath.setName("DATAPATH");
                this.performanceOptionDatapath.setDesc("DATAPATH");
                this.performanceOptionDatapath.setPropertyRole("OLAPOption");
                this.performanceOptionDatapath.setPropertyName("DATAPATH");
                this.performanceOptionDatapath.setOwningType(OptionSet.OWNING_TYPE_STRING);
                int metadataVersion = Workspace.getMetadataServerVersionNumber();
                if (metadataVersion >= 9200) {
                    this.performanceOptionDatapath.setPropertyOption(false);
                } else {
                    this.performanceOptionDatapath.setPropertyOption(true);
                }
            }
            this.performanceOptionDatapath.setDefaultValue(inputDatapath);
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionDatapath) >= 0) {
                objectOptions.remove(this.performanceOptionDatapath);
            }
            this.performanceOptionDatapath = null;
            this.deletePerformanceOptionDatapath = true;
        }
    }

    public void setPerformanceOptionIndex(Boolean inputIndex) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (inputIndex != null && inputIndex.booleanValue()) {
            inputIndex = null;
        }
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        this.performanceOptionIndex = this.optionSet.getOption(this, "INDEX", "OLAPOption");
        if (inputIndex != null) {
            String value = "0";
            if (inputIndex.booleanValue()) {
                value = "1";
            }
            if (this.performanceOptionIndex == null) {
                this.performanceOptionIndex = new Option(this.optionSet, this);
                this.performanceOptionIndex.setName("INDEX");
                this.performanceOptionIndex.setDesc("INDEX");
                this.performanceOptionIndex.setPropertyRole("OLAPOption");
                this.performanceOptionIndex.setPropertyName("INDEX");
                this.performanceOptionIndex.setOwningType(OptionSet.OWNING_TYPE_BOOLEAN);
                this.performanceOptionIndex.setPropertyOption(true);
            }
            this.performanceOptionIndex.setDefaultValue(value);
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionIndex) >= 0) {
                objectOptions.remove(this.performanceOptionIndex);
            }
            this.performanceOptionIndex = null;
            this.deletePerformanceOptionIndex = true;
        }
    }

    public void setPerformanceOptionIndexpath(String inputIndexpath) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        this.performanceOptionIndexpath = this.optionSet.getOption(this, "INDEXPATH", "OLAPOption");
        if (inputIndexpath != null) {
            if (this.performanceOptionIndexpath == null) {
                this.performanceOptionIndexpath = new Option(this.optionSet, this);
                this.performanceOptionIndexpath.setName("INDEXPATH");
                this.performanceOptionIndexpath.setDesc("INDEXPATH");
                this.performanceOptionIndexpath.setPropertyRole("OLAPOption");
                this.performanceOptionIndexpath.setPropertyName("INDEXPATH");
                this.performanceOptionIndexpath.setOwningType(OptionSet.OWNING_TYPE_STRING);
                int metadataVersion = Workspace.getMetadataServerVersionNumber();
                if (metadataVersion >= 9200) {
                    this.performanceOptionIndexpath.setPropertyOption(false);
                } else {
                    this.performanceOptionIndexpath.setPropertyOption(true);
                }
            }
            this.performanceOptionIndexpath.setDefaultValue(inputIndexpath);
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionIndexpath) >= 0) {
                objectOptions.remove(this.performanceOptionIndexpath);
            }
            this.performanceOptionIndexpath = null;
            this.deletePerformanceOptionIndexpath = true;
        }
    }

    public void setPerformanceOptionIndexSortSize(Integer inputIndexSortSize) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        this.performanceOptionIndexSortSize = this.optionSet.getOption(this, "INDEXSORTSIZE", "OLAPOption");
        if (inputIndexSortSize != null) {
            this.verifyPerformanceOptionIndexsortsize(inputIndexSortSize);
            if (this.performanceOptionIndexSortSize == null) {
                this.performanceOptionIndexSortSize = new Option(this.optionSet, this);
                this.performanceOptionIndexSortSize.setName("INDEXSORTSIZE");
                this.performanceOptionIndexSortSize.setDesc("INDEXSORTSIZE");
                this.performanceOptionIndexSortSize.setPropertyRole("OLAPOption");
                this.performanceOptionIndexSortSize.setPropertyName("INDEXSORTSIZE");
                this.performanceOptionIndexSortSize.setOwningType(OptionSet.OWNING_TYPE_INTEGER);
                this.performanceOptionIndexSortSize.setPropertyOption(true);
            }
            this.performanceOptionIndexSortSize.setDefaultValue(inputIndexSortSize.toString());
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionIndexSortSize) >= 0) {
                objectOptions.remove(this.performanceOptionIndexSortSize);
            }
            this.performanceOptionIndexSortSize = null;
            this.deletePerformanceOptionIndexSortSize = true;
        }
        this.changedPerformanceIndexSortSize = true;
    }

    public void setPerformanceOptionMaxThreads(Integer inputMaxThreads) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        this.performanceOptionMaxThreads = this.optionSet.getOption(this, "MAXTHREADS", "OLAPOption");
        if (inputMaxThreads != null) {
            this.verifyPerformanceOptionMaxthreads(inputMaxThreads);
            if (this.performanceOptionMaxThreads == null) {
                this.performanceOptionMaxThreads = new Option(this.optionSet, this);
                this.performanceOptionMaxThreads.setName("MAXTHREADS");
                this.performanceOptionMaxThreads.setDesc("MAXTHREADS");
                this.performanceOptionMaxThreads.setPropertyRole("OLAPOption");
                this.performanceOptionMaxThreads.setPropertyName("MAXTHREADS");
                this.performanceOptionMaxThreads.setOwningType(OptionSet.OWNING_TYPE_INTEGER);
                this.performanceOptionMaxThreads.setPropertyOption(true);
            }
            this.performanceOptionMaxThreads.setDefaultValue(inputMaxThreads.toString());
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionMaxThreads) >= 0) {
                objectOptions.remove(this.performanceOptionMaxThreads);
            }
            this.performanceOptionMaxThreads = null;
            this.deletePerformanceOptionMaxThreads = true;
        }
        this.changedPerformanceMaxThreads = true;
    }

    public void setPerformanceOptionAsyncIndexLimit(Integer inputIndexLimit) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        this.performanceOptionAsyncIndexLimit = this.optionSet.getOption(this, "ASYNCINDEXLIMIT", "OLAPOption");
        if (inputIndexLimit != null) {
            this.verifyPerformanceOptionAsyncIndexLimit(inputIndexLimit);
            if (this.performanceOptionAsyncIndexLimit == null) {
                this.performanceOptionAsyncIndexLimit = new Option(this.optionSet, this);
                this.performanceOptionAsyncIndexLimit.setName("ASYNCINDEXLIMIT");
                this.performanceOptionAsyncIndexLimit.setDesc("ASYNCINDEXLIMIT");
                this.performanceOptionAsyncIndexLimit.setPropertyRole("OLAPOption");
                this.performanceOptionAsyncIndexLimit.setPropertyName("ASYNCINDEXLIMIT");
                this.performanceOptionAsyncIndexLimit.setOwningType(OptionSet.OWNING_TYPE_INTEGER);
                this.performanceOptionAsyncIndexLimit.setPropertyOption(true);
            }
            this.performanceOptionAsyncIndexLimit.setDefaultValue(inputIndexLimit.toString());
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionAsyncIndexLimit) >= 0) {
                objectOptions.remove(this.performanceOptionAsyncIndexLimit);
            }
            this.performanceOptionAsyncIndexLimit = null;
            this.deletePerformanceOptionAsyncIndexLimit = true;
        }
        this.changedPerformanceAsyncIndexLimit = true;
    }

    public void setPerformanceOptionPartsize(Integer inputPartsize) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        this.performanceOptionPartsize = this.optionSet.getOption(this, "PARTSIZE", "OLAPOption");
        if (inputPartsize != null) {
            this.verifyPerformanceOptionPartsize(inputPartsize);
            if (this.performanceOptionPartsize == null) {
                this.performanceOptionPartsize = new Option(this.optionSet, this);
                this.performanceOptionPartsize.setName("PARTSIZE");
                this.performanceOptionPartsize.setDesc("PARTSIZE");
                this.performanceOptionPartsize.setPropertyRole("OLAPOption");
                this.performanceOptionPartsize.setPropertyName("PARTSIZE");
                this.performanceOptionPartsize.setOwningType(OptionSet.OWNING_TYPE_INTEGER);
                this.performanceOptionPartsize.setPropertyOption(true);
            }
            this.performanceOptionPartsize.setDefaultValue(inputPartsize.toString());
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionPartsize) >= 0) {
                objectOptions.remove(this.performanceOptionPartsize);
            }
            this.performanceOptionPartsize = null;
            this.deletePerformanceOptionPartsize = true;
        }
    }

    public void setPerformanceOptionSegsize(Integer inputSegsize) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.optionSet == null) {
            this.optionSet = this.getOptionsSet();
        }
        this.performanceOptionSegsize = this.optionSet.getOption(this, "SEGSIZE", "OLAPOption");
        if (inputSegsize != null) {
            this.verifyPerformanceOptionSegsize(inputSegsize);
            if (this.performanceOptionSegsize == null) {
                this.performanceOptionSegsize = new Option(this.optionSet, this);
                this.performanceOptionSegsize.setName("SEGSIZE");
                this.performanceOptionSegsize.setDesc("SEGSIZE");
                this.performanceOptionSegsize.setPropertyRole("OLAPOption");
                this.performanceOptionSegsize.setPropertyName("SEGSIZE");
                this.performanceOptionSegsize.setOwningType(OptionSet.OWNING_TYPE_INTEGER);
                this.performanceOptionSegsize.setPropertyOption(true);
            }
            this.performanceOptionSegsize.setDefaultValue(inputSegsize.toString());
        } else {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionSegsize) >= 0) {
                objectOptions.remove(this.performanceOptionSegsize);
            }
            this.performanceOptionSegsize = null;
            this.deletePerformanceOptionSegsize = true;
        }
    }

    public void setSASCode(String inputCode) {
        this.verifyErrorLevelChecked();
        this.sasCode = inputCode;
    }

    public void setSecuritySubset(String optionValue) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (optionValue != null && optionValue.equals("YES")) {
            this.deleteSecuritySubset = false;
            this.getSecuritySubset();
            if (this.optionSet == null) {
                this.getOptionsSet();
            }
            if (this.securitySubset == null) {
                this.securitySubset = new Option(this.optionSet, this);
                this.securitySubset.setName("SECURITY_SUBSET");
                this.securitySubset.setDesc("SECURITY_SUBSET");
                this.securitySubset.setPropertyName("SECURITY_SUBSET");
                this.securitySubset.setPropertyRole("OLAPOption");
                this.securitySubset.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.securitySubset.setDefaultValue(optionValue);
        } else if (this.securitySubset != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.securitySubset) >= 0) {
                objectOptions.remove(this.securitySubset);
            }
            this.deleteSecuritySubset = true;
            this.securitySubset = null;
        }
    }

    public void setResetDimensionTableTranslations(boolean inputResetDimensionTableTranslations) {
        this.resetDimensionTableTranslations = inputResetDimensionTableTranslations;
    }

    public void setResetCompactNwayOption(boolean inputResetCompactNwayOption) {
        this.resetCompactNwayOption = inputResetCompactNwayOption;
    }

    public void setResetRaggedHierarchyOptions(boolean inputResetRaggedHierarchyOptions) {
        this.resetRaggedHierarchyOptions = inputResetRaggedHierarchyOptions;
    }

    public void setResetSasCode(boolean inputResetSASCode) {
        this.resetSASCode = inputResetSASCode;
    }

    public void setResetFormatSearchOptions(boolean inputResetFormatSearchOptions) {
        this.resetFormatSearchOptions = inputResetFormatSearchOptions;
    }

    public void setTableOptions(String optionValue) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (optionValue != null & !ModelUtilities.isBlank(optionValue)) {
            this.deleteTableOptions = false;
            if (this.optionSet == null) {
                this.getOptionsSet();
            }
            this.getTableOptions();
            if (this.tableOptions == null) {
                if (this.getTableSet().getLoadType().equals(TableSet.FULLY_SUMMARIZED)) {
                    OLAPAggregation defaultAggregation = this.getAggregationSet().getDefaultAggregation();
                    defaultAggregation.setTableOptions(optionValue);
                } else {
                    this.tableOptions = new Option(this.optionSet, this);
                    this.tableOptions.setName("LoadTable_options");
                    this.tableOptions.setDesc("LoadTable_options");
                    this.tableOptions.setPropertyName("LoadTable_options");
                    this.tableOptions.setPropertyRole("OLAP Table Options");
                    this.tableOptions.setOwningType(OptionSet.OWNING_TYPE_STRING);
                    this.tableOptions.setDefaultValue(optionValue);
                }
            } else if (this.tableOptions != null) {
                if (this.getTableSet().getLoadType().equals(TableSet.FULLY_SUMMARIZED)) {
                    OLAPAggregation defaultAggregation = this.getAggregationSet().getDefaultAggregation();
                    defaultAggregation.setTableOptions(optionValue);
                } else {
                    this.tableOptions.setDefaultValue(optionValue);
                }
            }
        } else if (this.tableOptions != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.tableOptions) >= 0) {
                objectOptions.remove(this.tableOptions);
            }
            this.tableOptions = null;
            this.deleteTableOptions = true;
        }
    }

    void setReachThruTableOptions(String optionValue) throws OLAPException {
        ReachThruTable reachthruTable = this.tableSet.getReachThruTable();
        if (reachthruTable != null && reachthruTable.getTable() != null) {
            PhysicalTable jomaTable = reachthruTable.getTable();
            if (optionValue != null & !ModelUtilities.isBlank(optionValue)) {
                this.deleteReachThruTableOptions = false;
                if (this.optionSet == null) {
                    this.getOptionsSet();
                }
                if (ModelUtilities.isBlank(this.getReachThruTableOptions())) {
                    this.reachThruTableOptions = new Option(this.optionSet, this);
                    this.reachThruTableOptions.setName("ReachthruTable_options");
                    this.reachThruTableOptions.setDesc("ReachthruTable_options");
                    this.reachThruTableOptions.setPropertyName("ReachthruTable_options");
                    this.reachThruTableOptions.setPropertyRole("OLAP Table Options");
                    this.reachThruTableOptions.setOwningType(OptionSet.OWNING_TYPE_STRING);
                }
                this.reachThruTableOptions.setDefaultValue(optionValue);
                if (this.reachthruMap == null) {
                    this.reachthruMap = new HashMap();
                }
                this.reachthruMap.put(jomaTable, optionValue);
            } else if (this.reachThruTableOptions != null) {
                List objectOptions = this.optionSet.getOptions(this);
                if (objectOptions.indexOf(this.tableOptions) >= 0) {
                    objectOptions.remove(this.tableOptions);
                }
                this.reachThruTableOptions = null;
                this.deleteReachThruTableOptions = true;
            }
        }
    }

    public void setWorkPath(String optionValue) throws OLAPException {
        this.verifyErrorLevelChecked();
        if (optionValue != null && !ModelUtilities.isBlank(optionValue)) {
            int metadataVersion;
            this.getOptionsSet();
            this.deleteWorkPath = false;
            this.getWorkPath();
            if (this.workPath == null) {
                this.workPath = new Option(this.optionSet, this);
                this.workPath.setName("WORKPATH");
                this.workPath.setDesc("WORKPATH");
                this.workPath.setPropertyName("WORKPATH");
                this.workPath.setPropertyRole("OLAPOption");
                this.workPath.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            if ((metadataVersion = Workspace.getMetadataServerVersionNumber()) >= 9200) {
                this.workPath.setPropertyOption(false);
            } else {
                this.workPath.setPropertyOption(false);
            }
            this.workPath.setDefaultValue(optionValue);
        } else {
            if (this.optionSet == null) {
                this.getOptionsSet();
            }
            List objectOptions = this.optionSet.getOptions(this);
            for (int i = objectOptions.size() - 1; i >= 0; --i) {
                Option option = (Option)objectOptions.get(i);
                if (!option.getName().equalsIgnoreCase("WORKPATH")) continue;
                objectOptions.remove(option);
            }
            this.workPath = null;
            this.deleteWorkPath = true;
        }
    }

    Directory getDirectory(String directoryName) throws MdException, RemoteException, OLAPException {
        Directory directory = (Directory)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Directory", this.getRepositoryShortFQID());
        directory.setDirectoryName(directoryName);
        directory.setIsRelative(0);
        directory.setName(directoryName);
        directory.setDirectoryRole(CUBE_DIRECTORY_ROLE);
        return directory;
    }

    void updatePathFile() throws OLAPException {
        try {
            this.getPath();
            Cube cube = (Cube)this.metadataObject;
            AssociationList files = cube.getAssociatedFiles(false);
            File file = null;
            if (files.size() > 0) {
                file = (File)files.elementAt(0);
            } else {
                file = (File)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "File", this.owningCube.getRepositoryShortFQID());
                file.setFileExtension("cube");
                file.setTextRole("metadatautility");
                file.setTextType("Plain Text");
                file.setIsARelativeName(1);
                files.addElement((Object)file);
            }
            file.setName(cube.getName() + "_File");
            AssociationList directories = file.getDirectories(false);
            Directory directory = null;
            if (!directories.isEmpty()) {
                directory = (Directory)directories.get(0);
            }
            boolean getNewDirectory = false;
            if (directory == null || !directory.getDirectoryRole().equalsIgnoreCase(CUBE_DIRECTORY_ROLE)) {
                getNewDirectory = true;
            } else {
                String oldPath = directory.getDirectoryName();
                if (!oldPath.equals(this.path)) {
                    getNewDirectory = true;
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)directory, "", bundle.getString("MdException.GenericError.txt"));
                }
            }
            if (getNewDirectory) {
                directory = this.getDirectory(this.path);
                directories.clear();
                directories.add((Object)directory);
            }
            file.setFileName(cube.getName());
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private void updateDescriptionMetadata() throws OLAPException {
        Cube cube = (Cube)this.metadataObject;
        try {
            AssociationList descriptions = cube.getNotes(false);
            boolean found = false;
            int i = descriptions.size() - 1;
            while (i >= 0 & !found) {
                TextStore textStore = (TextStore)descriptions.get(i);
                if (textStore.getTextRole().equalsIgnoreCase("OLAP Description")) {
                    textStore.setStoredText(this.getDesc());
                    textStore.setDesc(textStore.getName());
                    found = true;
                }
                --i;
            }
            if (!found && this.getDesc().length() > 200) {
                TextStore textStore = (TextStore)MetadataTemplate.createMetadata(this.getObjectStore(), "TextStore", this.getRepositoryShortFQID());
                textStore.setName(this.getName() + "_Description");
                textStore.setDesc(textStore.getName());
                textStore.setStoredText(this.getDesc());
                textStore.setTextRole("OLAP Description");
                textStore.setTextType("Plain Text");
                descriptions.add((Object)textStore);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private void updateFolderMetadata() throws OLAPException {
        Cube cube = (Cube)this.metadataObject;
        try {
            AssociationList listOfFolders = cube.getTrees(false);
            listOfFolders.clear();
            this.getFolder();
            if (this.folder != null) {
                listOfFolders.add((Object)this.folder);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    @Override
    public void updateMetadata() throws OLAPException {
        this.verifyErrorLevelChecked();
        this.getFolder();
        if (this.folder == null) {
            throw new OLAPException(bundle.getString("OLAPCube.NoFolder.txt"), 0);
        }
        if (this.metadataObject == null) {
            this.metadataObject = (Cube)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Cube", this.owningCube.getRepositoryShortFQID());
        }
        Cube cube = (Cube)this.metadataObject;
        super.updateMetadata();
        try {
            OLAPSchema newSchema = this.getAssociatedOLAPSchema();
            if (newSchema != this.originalSchema) {
                AssociationList schemas = cube.getAssociatedOLAPSchemas(false);
                schemas.clear();
                schemas.add((Object)this.getAssociatedOLAPSchema());
            }
            cube.setCubeName("");
            cube.setPublicType("Cube");
            int currentVersion = this.usageVersion.getMajorVersion();
            if (currentVersion < 5) {
                OLAPList listOfSharedDims = this.dimensionSet.getSharedDimensions();
                if (listOfSharedDims.size() > 0) {
                    this.usageVersion = new UsageVersion(Integer.parseInt("5"), Integer.parseInt("0"), Integer.parseInt("0"));
                } else if (this.getMLSCaptionTable() != null || this.dimensionSet.hasMLSCaptionTable() || this.getDrillThruMemPref() != null) {
                    this.usageVersion = new UsageVersion(Integer.parseInt("4"), Integer.parseInt("1"), Integer.parseInt("0"));
                }
            }
            cube.setUsageVersion(this.usageVersion.encode());
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        this.getMLSCaptionTable();
        if (this.mlsCaptionTable != null) {
            this.mlsCaptionTable.updateMetadata();
        }
        if (this.folder != this.originalFolder) {
            this.updateFolderMetadata();
        }
        this.updatePathFile();
        this.updateDescriptionMetadata();
        this.getTableSet();
        this.tableSet.updateMetadata();
        this.updateOptionsMetadata();
        this.updateNotesMetadata();
        this.getDimensionSet();
        this.dimensionSet.updateMetadata();
        this.getMeasureSet();
        this.measureSet.updateMetadata();
        this.getAggregationSet();
        this.aggregationSet.updateMetadata();
        try {
            cube.setCubeType(this.getType());
            this.getLanguageSet();
            this.languageSet.updateMetadata();
            this.getOLAPMemberPropertySet();
            this.propertySet.updateMetadata();
            this.getDefinedMemberSet();
            this.definedMemberSet.updateMetadata();
            if (!this.testing) {
                cube.touch();
                Job jomaJob = ModelUtilities.getJobCube(cube);
                jomaJob.touch();
                cube.updateMetadataAll();
                if (this.internalStore) {
                    this.objectStore.dispose();
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(mdError.getMessage(), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(re.getMessage(), re, 12);
        }
    }

    public void updateMetadataOlapSchemaOnly() throws OLAPException {
        if (this.metadataObject != null) {
            Cube cube = (Cube)this.metadataObject;
            try {
                AssociationList schemas = cube.getAssociatedOLAPSchemas(false);
                schemas.clear();
                schemas.add((Object)this.getAssociatedOLAPSchema());
                AssociationList classifierMaps = cube.getTargetClassifierMaps();
                if (!classifierMaps.isEmpty()) {
                    ClassifierMap loadMap = (ClassifierMap)classifierMaps.get(0);
                    AssociationList properties = loadMap.getProperties();
                    for (int i = 0; i < properties.size(); ++i) {
                        Property property = (Property)properties.get(i);
                        if (!property.getPropertyName().equals("OLAPCubeConnection")) continue;
                        property.setDefaultValue(cube.getName() + "/" + this.getAssociatedOLAPSchema().getName());
                    }
                }
                if (!this.testing) {
                    cube.touch();
                    Job jomaJob = ModelUtilities.getJobCube(cube);
                    jomaJob.touch();
                    cube.updateMetadataAll();
                    if (this.internalStore) {
                        this.objectStore.dispose();
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
    }

    public void updateMetadataDefinedMembersOnly() throws OLAPException {
        if (this.metadataObject != null) {
            Cube cube = (Cube)this.metadataObject;
            this.getDefinedMemberSet().updateMetadata();
            try {
                if (!this.testing) {
                    cube.touch();
                    Job jobCube = ModelUtilities.getJobCube(cube);
                    if (jobCube != null) {
                        jobCube.touch();
                    }
                    cube.updateMetadataAll();
                    if (this.internalStore) {
                        this.objectStore.dispose();
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(mdError.getMessage(), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(re.getMessage(), re, 12);
            }
        }
    }

    void updateNotesMetadata() throws OLAPException {
        this.getFormatSearchOptions();
        this.getSASCode();
        TextStore storedFormatSearchOption = null;
        TextStore storedSASCode = null;
        Cube cube = (Cube)this.metadataObject;
        try {
            AssociationList cubeNotes = cube.getNotes(false);
            for (int i = 0; i < cubeNotes.size(); ++i) {
                TextStore note = (TextStore)cubeNotes.elementAt(i);
                if (note.getName().equals("OLAPFMTSEARCH")) {
                    storedFormatSearchOption = note;
                    continue;
                }
                if (!note.getName().equals("OLAPSASCode")) continue;
                storedSASCode = note;
            }
            if (storedFormatSearchOption != null) {
                if (!ModelUtilities.isBlank(this.formatSearchOptions)) {
                    storedFormatSearchOption.setStoredText(this.formatSearchOptions);
                } else {
                    storedFormatSearchOption.delete();
                }
            } else if (!ModelUtilities.isBlank(this.formatSearchOptions)) {
                storedFormatSearchOption = (TextStore)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "TextStore", this.owningCube.getRepositoryShortFQID());
                storedFormatSearchOption.setName("OLAPFMTSEARCH");
                storedFormatSearchOption.setTextRole("Olap FORMAT Description");
                storedFormatSearchOption.setTextType("Plain Text");
                storedFormatSearchOption.setStoredText(this.formatSearchOptions);
                cubeNotes.addElement((Object)storedFormatSearchOption);
            }
            if (storedSASCode != null) {
                if (!ModelUtilities.isBlank(this.sasCode)) {
                    storedSASCode.setStoredText(this.sasCode);
                } else {
                    storedSASCode.delete();
                }
            } else if (!ModelUtilities.isBlank(this.sasCode)) {
                storedSASCode = (TextStore)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "TextStore", this.owningCube.getRepositoryShortFQID());
                storedSASCode.setName("OLAPSASCode");
                storedSASCode.setTextRole("Olap SASCODE Description");
                storedSASCode.setTextType("Plain Text");
                storedSASCode.setStoredText(this.sasCode);
                cubeNotes.addElement((Object)storedSASCode);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    private void updateOptionsMetadata() throws OLAPException {
        this.getOptionsSet();
        if (this.optionSet != null) {
            try {
                Property property;
                CMetadata custom;
                int i;
                int metadataVersion = Workspace.getMetadataServerVersionNumber();
                if (metadataVersion >= 9200) {
                    Option cubeFolder = this.optionSet.getOption(this, "CUBEFOLDER", "OLAPOption");
                    if (cubeFolder == null) {
                        cubeFolder = new Option(this.optionSet, this);
                        cubeFolder.setName("CUBEFOLDER");
                        cubeFolder.setPropertyName("CUBEFOLDER");
                        cubeFolder.setPropertyRole("OLAPOption");
                        cubeFolder.setOwningType(OptionSet.OWNING_TYPE_STRING);
                    }
                    Cube jomaCube = (Cube)this.metadataObject;
                    if (!this.physicallyExists() && jomaCube.getPreviousGeneration() == null) {
                        cubeFolder.setDefaultValue(this.name);
                    }
                    cubeFolder.setPropertyOption(true);
                }
                this.getWorkPath();
                this.getPerformanceOptionCompress();
                this.getPerformanceOptionConcurrent();
                this.getPerformanceOptionDatapath();
                this.getPerformanceOptionIndex();
                this.getPerformanceOptionIndexpath();
                this.getPerformanceOptionIndexSortSize();
                this.getPerformanceOptionMaxThreads();
                this.getPerformanceOptionAsyncIndexLimit();
                this.getPerformanceOptionPartsize();
                this.getPerformanceOptionSegsize();
                this.getCollation();
                this.getLocale();
                AssociationList properties = this.metadataObject.getProperties(false);
                for (int i2 = properties.size() - 1; i2 >= 0; --i2) {
                    Property property2 = (Property)properties.get(i2);
                    if (!property2.getName().equalsIgnoreCase("GENFOLDER") && !property2.getName().equalsIgnoreCase("Version")) continue;
                    PropertyType propertyType = property2.getOwningType();
                    if (propertyType != null) {
                        propertyType.delete();
                    }
                    property2.delete();
                }
                AssociationList customAssoc = this.metadataObject.getCustomAssociations();
                for (int i3 = customAssoc.size() - 1; i3 >= 0; --i3) {
                    CustomAssociation custom2 = (CustomAssociation)customAssoc.get(i3);
                    if (!custom2.getName().equalsIgnoreCase(DIMENSION_GEN_FOLDER)) continue;
                    custom2.delete();
                }
                List options = this.optionSet.getOptions(this);
                HashMap<String, Object> metadataOptions = new HashMap<String, Object>();
                int size = options.size();
                for (i = 0; i < size; ++i) {
                    Option option = (Option)options.get(i);
                    option.updateMetadata();
                }
                size = properties.size();
                for (i = 0; i < size; ++i) {
                    Property property3 = (Property)properties.elementAt(i);
                    metadataOptions.put(property3.getPropertyName(), property3);
                }
                if (metadataVersion >= 9200) {
                    AssociationList customs = this.metadataObject.getCustomAssociations(false);
                    int size2 = customs.size();
                    for (int i4 = 0; i4 < size2; ++i4) {
                        CustomAssociation custom3 = (CustomAssociation)customs.elementAt(i4);
                        metadataOptions.put(custom3.getPartnerName(), custom3);
                    }
                }
                if (this.deleteWorkPath & this.workPath == null && (custom = (CMetadata)metadataOptions.get("WORKPATH")) != null && custom.getName().equalsIgnoreCase("WORKPATH")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), custom, "<Templates><AssociatedObjects/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteCompact & this.compact == null && (property = (Property)metadataOptions.get("COMPACT_NWAY")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteMissingKeys & this.missingKeys == null && (property = (Property)metadataOptions.get("IGNORE_MISSING_DIMKEYS")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteEmptyChar & this.emptyChar == null && (property = (Property)metadataOptions.get("EMPTY_CHAR")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteEmptyNum & this.emptyNum == null && (property = (Property)metadataOptions.get("EMPTY_NUM")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteReachThruTableOptions & this.reachThruTableOptions == null && (property = (Property)metadataOptions.get("ReachthruTable_options")) != null && property.getPropertyRole().equals("OLAP Table Options")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteTableOptions & this.tableOptions == null && (property = (Property)metadataOptions.get("LoadTable_options")) != null && property.getPropertyRole().equals("OLAP Table Options")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deletePerformanceOptionCompress & this.performanceOptionCompress == null && (property = (Property)metadataOptions.get("COMPRESS")) != null && property.getPropertyName().equals("COMPRESS")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deletePerformanceOptionConcurrent & this.performanceOptionConcurrent == null && (property = (Property)metadataOptions.get("CONCURRENT")) != null && property.getPropertyName().equals("CONCURRENT")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deletePerformanceOptionDatapath & this.performanceOptionDatapath == null && (custom = (CMetadata)metadataOptions.get("DATAPATH")) != null && custom.getName().equalsIgnoreCase("DATAPATH")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), custom, "<Templates><AssociatedObjects/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deletePerformanceOptionIndex & this.performanceOptionIndex == null && (property = (Property)metadataOptions.get("INDEX")) != null && property.getPropertyName().equals("INDEX")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deletePerformanceOptionIndexpath & this.performanceOptionIndexpath == null && (custom = (CMetadata)metadataOptions.get("INDEXPATH")) != null && custom.getName().equalsIgnoreCase("INDEXPATH")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), custom, "<Templates><AssociatedObjects/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deletePerformanceOptionIndexSortSize & this.performanceOptionIndexSortSize == null && (property = (Property)metadataOptions.get("INDEXSORTSIZE")) != null && property.getPropertyName().equals("INDEXSORTSIZE")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deletePerformanceOptionPartsize & this.performanceOptionPartsize == null && (property = (Property)metadataOptions.get("PARTSIZE")) != null && property.getPropertyName().equals("PARTSIZE")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deletePerformanceOptionMaxThreads & this.performanceOptionMaxThreads == null && (property = (Property)metadataOptions.get("MAXTHREADS")) != null && property.getPropertyName().equals("MAXTHREADS")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deletePerformanceOptionAsyncIndexLimit & this.performanceOptionAsyncIndexLimit == null && (property = (Property)metadataOptions.get("ASYNCINDEXLIMIT")) != null && property.getPropertyName().equals("ASYNCINDEXLIMIT")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deletePerformanceOptionSegsize & this.performanceOptionSegsize == null && (property = (Property)metadataOptions.get("SEGSIZE")) != null && property.getPropertyName().equals("SEGSIZE")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteUpdateableDimensions & this.updateableDimensions == null && (property = (Property)metadataOptions.get("NONUPDATEABLE")) != null && property.getPropertyName().equals("NONUPDATEABLE")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteSecuritySubset & this.securitySubset == null && (property = (Property)metadataOptions.get("SECURITY_SUBSET")) != null && property.getPropertyName().equals("SECURITY_SUBSET")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteCollation & this.collation == null || this.deleteLocale & this.locale == null) {
                    AssociationList listOfPropertySets = this.metadataObject.getPropertySets();
                    PropertySet linguisticPropertySet = null;
                    int iSize = listOfPropertySets.size();
                    for (int i5 = 0; i5 < iSize; ++i5) {
                        PropertySet propertySet = (PropertySet)listOfPropertySets.elementAt(i5);
                        String name = propertySet.getName();
                        if (!name.equals("Linguistic")) continue;
                        linguisticPropertySet = propertySet;
                    }
                    if (linguisticPropertySet != null) {
                        Property collationProperty = null;
                        Property localeProperty = null;
                        AssociationList propSetProps = linguisticPropertySet.getSetProperties();
                        for (int propNum = 0; propNum < propSetProps.size(); ++propNum) {
                            Property prop = (Property)propSetProps.get(propNum);
                            if ("Collation".equalsIgnoreCase(prop.getName())) {
                                collationProperty = prop;
                                continue;
                            }
                            if (!"Locale".equalsIgnoreCase(prop.getName())) continue;
                            localeProperty = prop;
                        }
                        if (this.collation == null && collationProperty != null) {
                            MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)collationProperty, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                        }
                        if (this.locale == null && localeProperty != null) {
                            MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)localeProperty, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                        }
                    }
                }
                if (this.deleteDtMemPref & this.dtMemPRef == null && (property = (Property)metadataOptions.get("DTMEMPREF")) != null && property.getPropertyName().equals("DTMEMPREF")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.deleteMLSCaptionTable & this.mlsCaptionTable == null) {
                    Property property4;
                    custom = (CMetadata)metadataOptions.get("CaptionTableObject");
                    if (custom != null) {
                        MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), custom, "", bundle.getString("MdException.GenericError.txt"));
                    }
                    if ((property4 = (Property)metadataOptions.get(this.getName() + "_cappref")) == null && custom != null) {
                        boolean found = false;
                        Iterator i6 = metadataOptions.keySet().iterator();
                        while (i6.hasNext() && !found) {
                            String optionName = (String)i6.next();
                            if (optionName.indexOf("_cappref") <= 0) continue;
                            found = true;
                            property4 = (Property)metadataOptions.get(optionName);
                        }
                    }
                    if (property4 != null) {
                        MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property4, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                    }
                }
                if (metadataVersion >= 9200) {
                    size = properties.size();
                    for (int i7 = 0; i7 < size; ++i7) {
                        Property property5 = (Property)properties.elementAt(i7);
                        PropertyType propertyType = property5.getOwningType();
                        if (propertyType == null) continue;
                        property5.setSQLType(propertyType.getSQLType());
                        propertyType.delete();
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
    }

    private void verifyMetadataPath() throws OLAPException {
        try {
            Cube jomaCube = (Cube)this.metadataObject;
            if (jomaCube != null) {
                Directory directory = null;
                File file = null;
                AssociationList files = jomaCube.getAssociatedFiles(false);
                if (!files.isEmpty()) {
                    file = (File)files.get(0);
                    AssociationList directories = file.getDirectories(false);
                    if (!directories.isEmpty()) {
                        directory = (Directory)directories.get(0);
                    }
                    if (directory != null) {
                        this.path = directory.getDirectoryName();
                    }
                }
                if (file == null || ModelUtilities.isBlank(this.path)) {
                    this.getCubeVerifyMessage().append(bundle.getString("OLAPCube.PathMissing.txt"));
                    this.errorLevel = 3;
                }
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    public void verifyCubePath() throws OLAPException {
        this.verifyErrorLevelChecked();
        if (ModelUtilities.isBlank(this.path)) {
            throw new OLAPException(bundle.getString("OLAPCube.SpecifyPath.txt"), 0);
        }
    }

    void verifyErrorLevelChecked() {
        if (!this.errorLevelChecked) {
            throw new IllegalStateException("There is a problem with the cube.  Use getCubeVerifyMessage() to view the details.");
        }
    }

    public void verifyFolder() throws OLAPException {
        this.verifyErrorLevelChecked();
        this.getFolder();
        if (this.folder == null) {
            throw new OLAPException(bundle.getString("OLAPCube.MissingFolder.txt"), 0);
        }
        try {
            MdFactory factory;
            MdSecurityUtil securityUtil;
            if (this.folder != this.originalFolder && !(securityUtil = (factory = this.objectStore.getFactory()).getSecurityUtil()).isFolderWriteAuthorized(this.folder.getId())) {
                throw new OLAPException(bundle.formatString("OLAPCube.NoWriteFolder.fmt.txt", (Object)this.folder.getName()), 0);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    private void verifyMetadataOLAPSchema() throws OLAPException {
        try {
            this.missingOLAPSchema = false;
            Cube jomaCube = (Cube)this.metadataObject;
            AssociationList schemas = jomaCube.getAssociatedOLAPSchemas(false);
            if (schemas.isEmpty()) {
                this.cubeVerifyMessage.append(bundle.getString("OLAPCube.NoSchemaSelected.txt"));
                this.errorLevel = 3;
                this.missingOLAPSchema = true;
            }
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    StringBuffer verifyMetadata() throws OLAPException {
        this.getCubeVerifyMessage();
        this.verifyVersionNumber();
        this.getTableSet();
        StringBuffer tableSetMessage = this.tableSet.verifyMetadata();
        this.cubeVerifyMessage.append(tableSetMessage);
        if (tableSetMessage.length() == 0 || tableSetMessage.length() > 0 && this.owningCube.getErrorLevel() == 1) {
            this.verifyMetadataOLAPSchema();
            this.verifyMetadataPath();
            this.getDimensionSet();
            StringBuffer dimensionMessage = this.dimensionSet.verifyMetadata();
            if (!ModelUtilities.isBlank(dimensionMessage.toString())) {
                this.cubeVerifyMessage.append(dimensionMessage);
            }
            this.cubeVerifyMessage.append(this.getMeasureSet().verifyMetadata());
            this.cubeVerifyMessage.append(this.getOLAPMemberPropertySet().verifyMetadata());
            this.cubeVerifyMessage.append(this.getAggregationSet().verifyMetadata());
            if (this.errorLevel == -1 && this.cubeVerifyMessage.length() > 0) {
                this.errorLevel = 3;
            }
        }
        return this.cubeVerifyMessage;
    }

    @Override
    public void verifyName() throws OLAPException {
        this.verifyErrorLevelChecked();
        this.getName();
        super.verifyName();
        this.verifySASName();
        ModelUtilities.verifyPublicTypeName(this.name);
        OLAPSchema newSchema = this.getAssociatedOLAPSchema();
        Tree newFolder = this.getFolder();
        String newName = this.getName();
        if (this.originalName == null || !this.originalName.equalsIgnoreCase(newName)) {
            if (!ModelUtilities.isCubeNameUniqueToFolder(newName, newFolder)) {
                throw new OLAPException(bundle.getString("OLAPCube.CubenameUniqueToFolder.txt"), 0);
            }
            if (!ModelUtilities.isCubeNameUniqueToOLAPSchema(newName, newSchema)) {
                throw new OLAPException(bundle.getString("OLAPCube.CubenameUniqueToSchema.txt"), 0);
            }
            if (!ModelUtilities.isJobNameUniqueToFolder(newName, newFolder)) {
                throw new OLAPException(bundle.formatString("OLAPCube.JobnameUniqueToSchema.fmt", (Object)newName), 0);
            }
        }
        if (this.originalSchema != newSchema && !ModelUtilities.isCubeNameUniqueToOLAPSchema(newName, newSchema)) {
            throw new OLAPException(bundle.getString("OLAPCube.CubenameUniqueToSchema.txt"), 0);
        }
        if (this.originalFolder != newFolder) {
            if (!ModelUtilities.isCubeNameUniqueToFolder(newName, newFolder)) {
                throw new OLAPException(bundle.getString("OLAPCube.CubenameUniqueToFolder.txt"), 0);
            }
            if (!ModelUtilities.isJobNameUniqueToFolder(newName, newFolder)) {
                throw new OLAPException(bundle.formatString("OLAPCube.JobnameUniqueToSchema.fmt", (Object)newName), 0);
            }
        }
    }

    public void verifyOLAPSchema() throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.schema == null) {
            throw new OLAPException(bundle.getString("OLAPCube.NoSchemaSelected.txt"), 0);
        }
        try {
            MdFactory factory;
            MdSecurityUtil securityUtil;
            if (this.schema != this.originalSchema && !(securityUtil = (factory = this.objectStore.getFactory()).getSecurityUtil()).isWriteAuthorized(this.schema.getCMetadataType(), this.schema.getId())) {
                throw new OLAPException(bundle.formatString("OLAPcube.NoWriteSchema.fmt.txt", (Object)this.schema.getName()), 0);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        catch (MdException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    public void verifySchemaList() throws OLAPException {
        this.verifyErrorLevelChecked();
        if (this.schemaList == null) {
            this.schemaList = ModelUtilities.getOLAPSchemas(this.getObjectStore());
        }
        if (this.schemaList.size() == 0) {
            throw new OLAPException(bundle.getString("OLAPCube.noSchemas.txt"), 0);
        }
    }

    private void verifyVersionNumber() throws OLAPException {
        Cube cube = (Cube)this.metadataObject;
        try {
            UsageVersion usageVersion = UsageVersion.decode((double)cube.getUsageVersion());
            if (!usageVersion.isCompatible(new UsageVersion(4, 0, 0), new UsageVersion(5, 0, 0))) {
                throw new OLAPException(bundle.formatString("OLAPCube.WrongVersion.fmt.txt", (Object)String.valueOf(usageVersion.getMajorVersion())), 0);
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    public void verifyPerformanceOptionConcurrent(Integer inputConcurrent) {
        if (inputConcurrent < 0) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)("(CONCURRENT) The number of aggregations to create in parallel must be an integer greater than or equal to " + Integer.toString(0) + "."));
            }
            throw new IllegalArgumentException(bundle.formatString("OLAPCube.Concurrent.fmt.txt", (Object)"(CONCURRENT) ", (Object)Integer.toString(0)));
        }
    }

    public void verifyPerformanceOptionIndexsortsize(Integer inputIndexSortSize) {
        if (inputIndexSortSize < 32 | inputIndexSortSize > Integer.MAX_VALUE) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)("(INDEXSORTSIZE) The amount of memory (in megabytes) available for aggregation creation must be between " + Integer.toString(32) + " and " + Integer.toString(Integer.MAX_VALUE) + "."));
            }
            throw new IllegalArgumentException(bundle.formatString("OLAPCube.IndexSortSize.fmt.txt", (Object)"(INDEXSORTSIZE) ", (Object)Integer.toString(32), (Object)Integer.toString(Integer.MAX_VALUE)));
        }
    }

    public void verifyPerformanceOptionMaxthreads(Integer inputMaxThreads) {
        if (inputMaxThreads < 0 | inputMaxThreads > 65536) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)("(MAXTHREADS) The maximum number of threads used to create aggregation index must be between " + Integer.toString(0) + " and " + Integer.toString(65536) + "."));
            }
            throw new IllegalArgumentException(bundle.formatString("OLAPCube.MaxThreads.fmt.txt", (Object)"(MAXTHREADS) ", (Object)Integer.toString(0), (Object)Integer.toString(65536)));
        }
    }

    public void verifyPerformanceOptionAsyncIndexLimit(Integer inputIndexLimit) throws OLAPException {
        if (inputIndexLimit < 0) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)("(ASYNCINDEXLIMIT) The minimum number of indexes to create at one time must be greater than " + Integer.toString(0) + "."));
            }
            throw new IllegalArgumentException(bundle.formatString("OLAPCube.AsyncIndexLimit.fmt.txt", (Object)"(ASYNCINDEXLIMIT) ", (Object)Integer.toString(0)));
        }
    }

    public void verifyPerformanceOptionPartsize(Integer inputPartsize) {
        if (inputPartsize < 16) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)("(PARTSIZE) The number of aggregations to create in parallel must be " + Integer.toString(16) + " or more."));
            }
            throw new IllegalArgumentException(bundle.formatString("OLAPCube.PartSize.fmt.txt", (Object)"(PARTSIZE) ", (Object)Integer.toString(16)));
        }
    }

    public void verifyPerformanceOptionSegsize(Integer inputSegsize) {
        if (inputSegsize < 1) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)("(SEGSIZE) The number of observations (in kilobytes) to include in the index component file segment must be " + Integer.toString(1) + " or more."));
            }
            throw new IllegalArgumentException(bundle.formatString("OLAPCube.SegSize.fmt.txt", (Object)"(SEGSIZE) ", (Object)Integer.toString(1)));
        }
    }

    String generateCodeValidVarNameOption(int value) {
        StringBuilder code = new StringBuilder(32);
        switch (value) {
            case 1: {
                code.append("OPTIONS VALIDVARNAME=V7;");
                break;
            }
            case 2: {
                code.append("OPTIONS VALIDVARNAME=UPCASE;");
                break;
            }
            case 3: {
                code.append("OPTIONS VALIDVARNAME=ANY;");
                break;
            }
            default: {
                Integer v = value;
                throw new IllegalArgumentException(v.toString() + " does not represent a VALIDVARNAME value");
            }
        }
        code.append(ModelUtilities.newline);
        code.append(ModelUtilities.newline);
        code.append(ModelUtilities.newline);
        return code.toString();
    }

    private static boolean isValidCodegenFlag(int flagName) {
        boolean retVal = false;
        if (flagName == 1 || flagName == 2 || flagName == 4 || flagName == 8 || flagName == 16) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean isValidCodegenFlagSet(int flags) {
        boolean retVal = false;
        if (flags >= 0 && flags <= 31) {
            retVal = true;
        }
        return retVal;
    }

    private static boolean isCodegenFlagEnabled(int flags, int flagName) {
        boolean retVal = false;
        int bitMask = flagName;
        if ((flags & flagName) == bitMask) {
            retVal = true;
        }
        return retVal;
    }

    public static int setCodegenFlag(int curFlags, int flagName, boolean flagValue) {
        int flags = curFlags;
        if (!OLAPCube.isValidCodegenFlag(flagName)) {
            Integer v = flagName;
            throw new IllegalArgumentException(v.toString() + " is not a valid OLAPCube codegen flag");
        }
        if (!OLAPCube.isValidCodegenFlagSet(curFlags)) {
            Integer v = curFlags;
            throw new IllegalArgumentException(v.toString() + " is not a valid OLAPCube flagSet value");
        }
        if (flagValue) {
            flags |= flagName;
        } else if (flagName <= flags && OLAPCube.isCodegenFlagEnabled(flags, flagName)) {
            flags ^= flagName;
        }
        return flags;
    }

    public static boolean getCodegenFlag(int curFlags, int flagName) {
        boolean flagValue = false;
        if (!OLAPCube.isValidCodegenFlag(flagName)) {
            Integer v = flagName;
            throw new IllegalArgumentException(v.toString() + " is not a valid OLAPCube codegen flag");
        }
        if (!OLAPCube.isValidCodegenFlagSet(curFlags)) {
            Integer v = curFlags;
            throw new IllegalArgumentException(v.toString() + " is not a valid OLAPCube flagSet value");
        }
        if ((curFlags & flagName) == flagName) {
            flagValue = true;
        }
        return flagValue;
    }

    private void genLibnames(int flags, StringBuffer code) throws OLAPException {
        boolean noPrompt = OLAPCube.getCodegenFlag(flags, 16);
        if (this.tableSet == null) {
            this.getTableSet();
        }
        if (noPrompt) {
            code.append(this.tableSet.generateCode());
        } else {
            try {
                code.append(this.tableSet.getLibnameCode(flags));
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }
}

