/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class OLAPColumn
implements Comparable {
    private static WAdminResource bundle = new WAdminResource(OLAPColumn.class);
    Column metadataObject;
    private String name;
    private String description;
    private String format;
    private String inFormat;
    private List properties;
    private boolean changed;

    OLAPColumn(Column inputMetadataObject) {
        try {
            this.metadataObject = inputMetadataObject;
            this.name = this.metadataObject.getSASColumnName();
            if (ModelUtilities.isBlank(this.name)) {
                this.name = this.metadataObject.getColumnName();
                if (ModelUtilities.isBlank(this.name)) {
                    this.name = this.metadataObject.getName();
                }
            }
            this.description = this.metadataObject.getDesc();
            this.changed = false;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int compareTo(Object obj) {
        int compnum = this.toString().compareTo(obj.toString());
        return compnum;
    }

    public String getSASColumnName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List getProperties() throws OLAPException {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        if (this.properties.isEmpty() && this.metadataObject != null) {
            this.properties = new ArrayList();
            try {
                AssociationList listOfProperties = this.metadataObject.getProperties();
                int size = listOfProperties.size();
                for (int i = 0; i < size; ++i) {
                    this.properties.add(listOfProperties.elementAt(i));
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), 0);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.properties;
    }

    public String getSASColumnType() {
        String tempType = "";
        try {
            tempType = this.metadataObject.getSASColumnType();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return tempType;
    }

    public String getSASFormat() {
        try {
            if (this.format == null & this.metadataObject != null) {
                this.format = this.metadataObject.getSASFormat();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.format;
    }

    public String getSASInFormat() {
        try {
            if (this.inFormat == null & this.metadataObject != null) {
                this.inFormat = this.metadataObject.getSASInformat();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.inFormat;
    }

    public PhysicalTable getTable() throws OLAPException {
        PhysicalTable table = null;
        try {
            table = (PhysicalTable)this.metadataObject.getTable();
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return table;
    }

    public boolean isChanged() {
        return this.changed;
    }

    void setColumn(Column inputColumn) throws OLAPException {
        try {
            this.metadataObject = inputColumn;
            if (this.inFormat != null) {
                this.inFormat = null;
                this.getSASInFormat();
            }
            if (this.format != null) {
                this.format = null;
                this.getSASFormat();
            }
            if (this.properties != null) {
                this.properties.clear();
                this.getProperties();
            }
            this.name = this.metadataObject.getSASColumnName();
            if (ModelUtilities.isBlank(this.name)) {
                this.name = this.metadataObject.getColumnName();
                if (ModelUtilities.isBlank(this.name)) {
                    this.name = this.metadataObject.getName();
                }
            }
            this.description = this.metadataObject.getDesc();
            this.changed = true;
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
    }

    public String toString() {
        return this.name;
    }
}

