/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.Aggregation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.SASLibrary;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.Option;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OLAPAggregation
extends AbstractOLAPModel {
    static WAdminResource bundle = new WAdminResource(OLAPAggregation.class);
    static final String MOLAP = "MOLAP";
    static final String ROLAP = "ROLAP";
    public static final String NWAY = "NWAY";
    private final int PERFORMANCE_OPTION_PARTSIZE_MIN = 16;
    private final int PERFORMANCE_OPTION_SEGSIZE_MIN = 1;
    private boolean changedTable;
    private boolean changedTableOptions;
    private OLAPList levels;
    private OLAPList levelsBackup;
    private Boolean nway;
    private Option performanceOptionCompress;
    private Option performanceOptionDatapath;
    private Option performanceOptionIndex;
    private Option performanceOptionIndexpath;
    private Option performanceOptionPartsize;
    private Option performanceOptionSegsize;
    private AggregationTable table;
    private Option tableOption;
    private Map tableOptions;
    private boolean tableOptionsRetrieved;
    private String type;
    private boolean verifiedDrillPath;
    private boolean verifiedDuplicated;
    private boolean verifiedName;
    private OLAPList verifiedLevels;
    OLAPList hierarchies;
    Map levelsByHierarchy;
    private static final String AGGREGATION = "   AGGREGATION /* ";
    private static final String LEVELS = "      /* levels */";
    private static final String OPTIONS = "      / /* options */";
    private static final String TABLE_EQUALS = "      TABLE     = ";
    private static final String NAME_EQUALS = "      NAME      = ";
    private static final String COMPRESS = "      COMPRESS";
    private static final String NOCOMPRESS = "      NOCOMPRESS";
    private static final String INDEX = "      INDEX";
    private static final String NOINDEX = "      NOINDEX";
    private static final String PARTSIZE_EQUALS = "      PARTSIZE  = ";
    private static final String SEGSIZE_EQUALS = "      SEGSIZE   = ";
    private Integer count;
    private Double time;
    private String originalName;
    private Boolean originalCompress;
    private String originalDatapath;
    private Boolean originalIndex;
    private String originalIndexpath;
    private Integer originalPartsize;
    private Integer originalSegsize;
    private Boolean compress;
    private String datapath;
    private Boolean index;
    private String indexpath;
    private Integer partsize;
    private Integer segsize;

    OLAPAggregation(Aggregation inputMetadataObject, OLAPCube inputOwningCube) throws OLAPException {
        if (inputMetadataObject != null) {
            Integer segsize;
            Integer partsize;
            String indexpath;
            Boolean index;
            String datapath;
            this.owningCube = inputOwningCube;
            this.metadataObject = inputMetadataObject;
            this.verifiedName = true;
            this.verifiedDrillPath = true;
            this.verifiedDuplicated = true;
            try {
                this.originalName = inputMetadataObject.getName();
            }
            catch (RemoteException e) {
                this.originalName = "";
            }
            Boolean compress = this.getPerformanceOptionCompress();
            if (compress != null) {
                this.originalCompress = (boolean)compress;
            }
            if (compress != null) {
                this.setUpChanges("setPerformanceOptionCompress", Boolean.class, compress);
            }
            if ((datapath = this.getPerformanceOptionDatapath()) != null) {
                this.originalDatapath = datapath;
            }
            if (datapath != null) {
                this.setUpChanges("setPerformanceOptionDatapath", String.class, datapath);
            }
            if ((index = this.getPerformanceOptionIndex()) != null) {
                this.originalIndex = (boolean)index;
            }
            if (index != null) {
                this.setUpChanges("setPerformanceOptionIndex", Boolean.class, index);
            }
            if ((indexpath = this.getPerformanceOptionIndexpath()) != null) {
                this.originalIndexpath = indexpath;
            }
            if (indexpath != null) {
                this.setUpChanges("setPerformanceOptionIndexpath", Boolean.class, indexpath);
            }
            if ((partsize = this.getPerformanceOptionPartsize()) != null) {
                this.originalPartsize = (int)partsize;
            }
            if (partsize != null) {
                this.setUpChanges("setPerformanceOptionPartsize", Integer.class, partsize);
            }
            if ((segsize = this.getPerformanceOptionSegsize()) != null) {
                this.originalSegsize = (int)segsize;
            }
            if (segsize != null) {
                this.setUpChanges("setPerformanceOptionSegsize", Integer.class, segsize);
            }
            this.apply();
        }
    }

    OLAPAggregation() {
        this.verifiedDrillPath = false;
        this.verifiedDuplicated = false;
        this.verifiedName = false;
        this.originalName = "";
        this.originalDatapath = "";
        this.originalIndexpath = "";
    }

    public void add() throws OLAPException {
        if (!this.deleted) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The aggregation is not added.  An existing aggregation cannot be added.");
            }
            throw new IllegalStateException("An invalid use of the add method was encountered.");
        }
        try {
            if (this.hiddenIsNway()) {
                this.aggregationSet.setNwayGenerated(true);
            } else {
                this.deleted = false;
                this.aggregationSet.getAggregations().add(this);
            }
        }
        catch (OLAPException error) {
            this.deleted = true;
            throw error;
        }
    }

    @Override
    public void clear() throws OLAPException {
        int i;
        this.verifyDeleted();
        this.verifyDropped();
        super.clear();
        this.performanceOptionCompress = null;
        this.performanceOptionDatapath = null;
        this.performanceOptionIndex = null;
        this.performanceOptionIndexpath = null;
        this.performanceOptionPartsize = null;
        this.performanceOptionSegsize = null;
        if (this.levels != null) {
            this.levels.clear();
            if (this.levelsBackup != null) {
                int size = this.levelsBackup.size();
                for (i = 0; i < size; ++i) {
                    this.levels.add(this.levelsBackup.get(i));
                }
            }
        }
        this.table = null;
        this.type = MOLAP;
        if (this.tableOptions != null) {
            this.tableOptions.clear();
        }
        this.changedTable = false;
        this.changedTableOptions = false;
        this.tableOptionsRetrieved = false;
        if (this.isNewObject()) {
            this.verifiedDrillPath = false;
            this.verifiedDuplicated = false;
            this.verifiedLevels.clear();
            this.verifiedName = false;
        } else {
            this.verifiedDrillPath = true;
            this.verifiedDuplicated = true;
            this.verifiedLevels.clear();
            if (this.levels != null) {
                for (i = this.levels.size() - 1; i >= 0; --i) {
                    this.verifiedLevels.add(0, this.levels.get(i));
                }
            }
            this.verifiedName = true;
        }
    }

    public void delete() throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (this.isNway()) {
            this.aggregationSet.setNwayGenerated(false);
        } else {
            if (this.metadataObject != null) {
                this.aggregationSet.getDeleteList().add(this.metadataObject);
            }
            this.aggregationSet.delete(this);
        }
    }

    private OLAPList getAllHierarchies(boolean newList) throws OLAPException {
        OLAPList tempHierarchies = null;
        tempHierarchies = newList ? new OLAPList(OLAPLevel.class) : this.hierarchies;
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            OLAPLevel level = (OLAPLevel)this.levels.get(i);
            OLAPList levelHierarchies = level.getHierarchies();
            for (int j = levelHierarchies.size() - 1; j >= 0; --j) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)levelHierarchies.get(j);
                if (this.hierarchies.indexOf(hierarchy) >= 0) continue;
                this.hierarchies.getTheList().add(hierarchy);
            }
        }
        return tempHierarchies;
    }

    public boolean isDropped() {
        boolean dropped = false;
        OLAPList droppedAggregations = this.aggregationSet.getDroppedAggregations();
        if (!this.isNewObject()) {
            dropped = droppedAggregations.contains(this);
        }
        return dropped;
    }

    private boolean isHierarchySubset(OLAPHierarchy inputHierarchy) throws OLAPException {
        boolean isSubset = false;
        for (int i = this.hierarchies.size() - 1; i >= 0 && !isSubset; --i) {
            int levelCount = 0;
            OLAPHierarchy hierarchy = (OLAPHierarchy)this.hierarchies.get(i);
            if (inputHierarchy.equals(hierarchy)) continue;
            OLAPList inputHierarchyLevels = inputHierarchy.getLevels();
            ArrayList<OLAPLevel> usedLevels = new ArrayList<OLAPLevel>();
            for (int j = inputHierarchyLevels.size() - 1; j >= 0; --j) {
                OLAPLevel level = (OLAPLevel)inputHierarchyLevels.get(j);
                if (this.levels.indexOf(level) < 0) continue;
                usedLevels.add(level);
            }
            OLAPList hierarchyLevels = hierarchy.getLevels();
            for (int j = usedLevels.size() - 1; j >= 0; --j) {
                OLAPLevel level = (OLAPLevel)usedLevels.get(j);
                if (hierarchyLevels.indexOf(level) < 0) continue;
                ++levelCount;
            }
            if (levelCount != usedLevels.size()) continue;
            isSubset = true;
        }
        return isSubset;
    }

    private void filterInvalidHierarchies() throws OLAPException {
        if (this.hierarchies.size() > 1) {
            this.hierarchies.setModifiable(true);
            for (int i = this.hierarchies.size() - 1; i >= 0; --i) {
                OLAPLevel level;
                int breakPoint;
                OLAPHierarchy hierarchy = (OLAPHierarchy)this.hierarchies.get(i);
                OLAPList hierarchyLevels = hierarchy.getLevels();
                OLAPLevel firstLevel = (OLAPLevel)hierarchyLevels.get(0);
                if (this.levels.indexOf(firstLevel) < 0) {
                    this.hierarchies.remove(hierarchy);
                    continue;
                }
                int jSize = hierarchyLevels.size();
                boolean breakFound = false;
                for (breakPoint = 0; breakPoint < jSize && !breakFound; ++breakPoint) {
                    level = (OLAPLevel)hierarchyLevels.get(breakPoint);
                    breakFound = this.levels.indexOf(level) < 0;
                }
                if (!breakFound) continue;
                while (breakPoint < jSize && breakFound) {
                    level = (OLAPLevel)hierarchyLevels.get(breakPoint);
                    breakFound = this.levels.indexOf(level) < 0;
                    ++breakPoint;
                }
                if (breakFound) continue;
                this.hierarchies.getTheList().remove(hierarchy);
            }
            this.hierarchies.setModifiable(false);
        }
    }

    private void filterSubsetHierarchies() throws OLAPException {
        for (int i = this.hierarchies.size() - 1; i >= 0; --i) {
            OLAPHierarchy hierarchy = (OLAPHierarchy)this.hierarchies.get(i);
            if (!this.isHierarchySubset(hierarchy)) continue;
            this.hierarchies.getTheList().remove(hierarchy);
        }
    }

    private OLAPList getHierarchiesFromLevels() throws OLAPException {
        if (this.hierarchies == null) {
            this.hierarchies = new OLAPList(OLAPHierarchy.class);
            this.hierarchies.setParentObject(this);
        }
        this.getLevels();
        this.getAllHierarchies(false);
        this.filterInvalidHierarchies();
        this.filterSubsetHierarchies();
        return this.hierarchies;
    }

    public Integer getCount() {
        return this.count;
    }

    public OLAPList getHierarchies() throws OLAPException {
        this.hierarchies = this.getHierarchiesFromLevels();
        this.hierarchies.setModifiable(true);
        this.hierarchies.sort();
        this.hierarchies.setModifiable(false);
        return this.hierarchies;
    }

    OLAPList getLevelsForce() throws OLAPException {
        if (this.levels == null) {
            boolean tempDeleted = this.isDeleted();
            this.deleted = false;
            this.getLevels();
            this.deleted = tempDeleted;
        }
        return this.levels;
    }

    public OLAPList getLevels() throws OLAPException {
        this.verifyDeleted();
        if (this.levels == null & this.metadataObject != null & !this.isNewObject() & !this.isNway()) {
            try {
                this.levels = new OLAPList(OLAPLevel.class);
                this.levels.setParentObject(this);
                Aggregation aggregation = (Aggregation)this.metadataObject;
                AssociationList aggregationLevels = aggregation.getLevels(false);
                for (int i = aggregationLevels.size() - 1; i >= 0; --i) {
                    OLAPLevel olapLevel;
                    Level aggregationLevel = (Level)aggregationLevels.elementAt(i);
                    if (this.dimensionSet == null) {
                        this.dimensionSet = this.owningCube.getDimensionSet();
                    }
                    if ((olapLevel = this.dimensionSet.getLevel(aggregationLevel.getName())) == null) {
                        Object[] dimensionSetLevels = this.dimensionSet.getLevels().values().toArray();
                        int j = dimensionSetLevels.length - 1;
                        while (j >= 0 & olapLevel == null) {
                            List listOfLevels = (List)dimensionSetLevels[j];
                            int t = 0;
                            int tSize = listOfLevels.size();
                            while (t < tSize & olapLevel == null) {
                                OLAPLevel tempLevel = (OLAPLevel)listOfLevels.get(t);
                                if (tempLevel.getName().equalsIgnoreCase(aggregationLevel.getName())) {
                                    olapLevel = tempLevel;
                                }
                                ++t;
                            }
                            --j;
                        }
                    }
                    if (olapLevel == null) continue;
                    this.levels.getTheList().add(0, olapLevel);
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        if (this.levels == null) {
            this.levels = new OLAPList(OLAPLevel.class);
            this.levels.setParentObject(this);
        }
        if (this.isNway()) {
            if (this.levels.isEmpty()) {
                List javaLevels = this.levels.getTheList();
                if (this.dimensionSet == null) {
                    this.dimensionSet = this.owningCube.getDimensionSet();
                }
                Object[] dimensionSetLevels = this.dimensionSet.getLevels().values().toArray();
                for (int j = dimensionSetLevels.length - 1; j >= 0; --j) {
                    List listOfLevels = (List)dimensionSetLevels[j];
                    int tSize = listOfLevels.size();
                    for (int t = 0; t < tSize; ++t) {
                        javaLevels.add(listOfLevels.get(t));
                    }
                }
            }
            this.levels.setModifiable(false);
            this.levels.sort();
        }
        if (this.levelsBackup == null) {
            this.levelsBackup = new OLAPList(OLAPLevel.class);
            this.levelsBackup.setParentObject(this);
            this.verifiedLevels = new OLAPList(OLAPLevel.class);
            this.verifiedLevels.setParentObject(this);
            for (int i = this.levels.size() - 1; i >= 0; --i) {
                this.levelsBackup.getTheList().add(0, this.levels.get(i));
                this.verifiedLevels.getTheList().add(0, this.levels.get(i));
            }
        }
        return this.levels;
    }

    public OLAPList getLevelsByHierarchy(OLAPHierarchy inputHierarchy) throws OLAPException {
        OLAPList mappedLevels;
        this.getHierarchies();
        if (this.levelsByHierarchy == null) {
            this.levelsByHierarchy = new HashMap();
        }
        if ((mappedLevels = (OLAPList)this.levelsByHierarchy.get(inputHierarchy)) == null) {
            mappedLevels = new OLAPList(OLAPLevel.class);
            mappedLevels.setParentObject(this);
            this.levelsByHierarchy.put(inputHierarchy, mappedLevels);
        }
        mappedLevels.setModifiable(false);
        if (this.hierarchies.indexOf(inputHierarchy) >= 0) {
            mappedLevels.getTheList().clear();
            OLAPList hierarchyLevels = inputHierarchy.getLevels();
            int size = hierarchyLevels.size() - 1;
            for (int i = 0; i <= size; ++i) {
                OLAPLevel level = (OLAPLevel)hierarchyLevels.get(i);
                if (this.levels.indexOf(level) < 0) continue;
                mappedLevels.getTheList().add(level);
            }
        } else {
            mappedLevels.getTheList().clear();
        }
        mappedLevels.setModifiable(true);
        return mappedLevels;
    }

    public Integer getNumberOfRacks() throws OLAPException {
        this.verifyDeleted();
        Option racks = null;
        Integer returnOption = null;
        if (this.metadataObject != null & !this.isNewObject()) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            racks = this.optionSet.getOption(this, "NRACKS", "OLAPOption");
        }
        if (racks != null) {
            racks.setPropertyOption(true);
            returnOption = Integer.valueOf(racks.getDefaultValue());
        }
        return returnOption;
    }

    public Boolean getPerformanceOptionCompress() throws OLAPException {
        this.verifyDeleted();
        Boolean returnValue = null;
        if (!this.isNewObject() && this.metadataObject != null && !this.isCompressChanged()) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionCompress = this.optionSet.getOption(this, "COMPRESS", "OLAPOption");
        }
        if (this.performanceOptionCompress != null) {
            this.performanceOptionCompress.setPropertyOption(true);
            returnValue = this.performanceOptionCompress.getDefaultValue().equals("1");
        }
        return returnValue;
    }

    public String getPerformanceOptionDatapath() throws OLAPException {
        this.verifyDeleted();
        String returnOption = null;
        if (!this.isDatapathChanged() & this.metadataObject != null & !this.isNewObject()) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionDatapath = this.optionSet.getOption(this, "DATAPATH", "OLAPOption");
        }
        if (this.performanceOptionDatapath != null) {
            int metadataVersion = Workspace.getMetadataServerVersionNumber();
            if (metadataVersion >= 9200) {
                this.performanceOptionDatapath.setPropertyOption(false);
            } else {
                this.performanceOptionDatapath.setPropertyOption(true);
            }
            returnOption = this.performanceOptionDatapath.getDefaultValue();
        }
        return returnOption;
    }

    public Boolean getPerformanceOptionIndex() throws OLAPException {
        this.verifyDeleted();
        Boolean returnOption = null;
        if (!this.isIndexChanged() & this.metadataObject != null & !this.isNewObject()) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionIndex = this.optionSet.getOption(this, "INDEX", "OLAPOption");
        }
        if (this.performanceOptionIndex != null) {
            this.performanceOptionIndex.setPropertyOption(true);
            returnOption = this.performanceOptionIndex.getDefaultValue().equals("1");
        }
        return returnOption;
    }

    public String getPerformanceOptionIndexpath() throws OLAPException {
        this.verifyDeleted();
        String returnOption = null;
        if (!this.isIndexpathChanged() && this.metadataObject != null && !this.isNewObject()) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionIndexpath = this.optionSet.getOption(this, "INDEXPATH", "OLAPOption");
        }
        if (this.performanceOptionIndexpath != null) {
            int metadataVersion = Workspace.getMetadataServerVersionNumber();
            if (metadataVersion >= 9200) {
                this.performanceOptionIndexpath.setPropertyOption(false);
            } else {
                this.performanceOptionIndexpath.setPropertyOption(true);
            }
            returnOption = this.performanceOptionIndexpath.getDefaultValue();
        }
        return returnOption;
    }

    public Integer getPerformanceOptionPartsize() throws OLAPException {
        this.verifyDeleted();
        Integer returnOption = null;
        if (!this.isPartsizeChanged() && this.metadataObject != null && !this.isNewObject()) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionPartsize = this.optionSet.getOption(this, "PARTSIZE", "OLAPOption");
        }
        if (this.performanceOptionPartsize != null) {
            this.performanceOptionPartsize.setPropertyOption(true);
            returnOption = Integer.valueOf(this.performanceOptionPartsize.getDefaultValue());
        }
        return returnOption;
    }

    public Integer getPerformanceOptionSegsize() throws OLAPException {
        this.verifyDeleted();
        Integer returnOption = null;
        if (!this.isSegsizeChanged() & this.metadataObject != null & !this.isNewObject()) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.performanceOptionSegsize = this.optionSet.getOption(this, "SEGSIZE", "OLAPOption");
        }
        if (this.performanceOptionSegsize != null) {
            this.performanceOptionSegsize.setPropertyOption(true);
            returnOption = Integer.valueOf(this.performanceOptionSegsize.getDefaultValue());
        }
        return returnOption;
    }

    public String getTableOptions() throws OLAPException {
        this.verifyDeleted();
        if (this.table == null) {
            this.getAggregationTable();
        }
        if (this.tableOptions == null & this.table != null) {
            this.tableOptions = new HashMap();
            this.tableOptions.put(this.table, "");
        }
        if (!this.changedTableOptions & this.metadataObject != null & !this.isNewObject()) {
            if (this.optionSet == null) {
                this.optionSet = this.owningCube.getOptionsSet();
            }
            this.tableOption = this.optionSet.getOption(this, "AggregationTable_options", "OLAP Table Options");
            this.tableOptionsRetrieved = true;
            if (this.tableOption != null && this.tableOptions != null) {
                this.tableOptions.put(this.table, this.tableOption.getDefaultValue());
            }
        }
        String options = null;
        if (this.table != null) {
            options = (String)this.tableOptions.get(this.table);
        }
        if (options == null & this.table != null) {
            options = "";
            this.tableOptions.put(this.table, options);
        }
        return options;
    }

    public Double getTime() {
        return this.time;
    }

    public String getType() {
        this.verifyDeleted();
        if (this.type == null & this.metadataObject != null & !this.isNewObject()) {
            Aggregation aggregation = (Aggregation)this.metadataObject;
            try {
                this.type = aggregation.getType();
            }
            catch (RemoteException e) {
                this.type = MOLAP;
            }
        }
        if (this.type == null) {
            this.type = MOLAP;
        }
        return this.type;
    }

    StringBuffer generateCode() throws OLAPException {
        StringBuffer aggregationStatement = new StringBuffer();
        aggregationStatement.append(AGGREGATION).append(this.getName()).append(" */").append(ModelUtilities.newline).append(LEVELS);
        if (this.levels == null) {
            this.getLevels();
        }
        aggregationStatement.append(ModelUtilities.listFormatter(this.levels, "      ", " "));
        aggregationStatement.append(OPTIONS);
        StringBuffer tempName = new StringBuffer(NAME_EQUALS);
        if (this.getAggregationTable() != null) {
            SASLibrary libname = null;
            try {
                libname = LibraryUtil.getLibrary((DataTable)this.table.getTable(), null);
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
            StringBuffer tableName = new StringBuffer();
            try {
                tableName.append(libname.getLibref()).append(".").append(ModelUtilities.getSasName(this.table.getSASTableName()));
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            StringBuffer datasetOptions = new StringBuffer(this.getTableOptions());
            if (datasetOptions.length() > 0) {
                datasetOptions.insert(0, "(").append(")");
            }
            aggregationStatement.append(ModelUtilities.newline).append(TABLE_EQUALS).append(tableName).append(datasetOptions);
        }
        aggregationStatement.append(ModelUtilities.newline).append(tempName).append("'").append(ModelUtilities.internalQuote(this.getName())).append("'");
        if (this.getPerformanceOptionDatapath() != null) {
            String datapath = this.performanceOptionDatapath.getDefaultValue();
            datapath = ModelUtilities.formatPath(datapath);
            aggregationStatement.append(ModelUtilities.newline).append("   DATAPATH               = ").append(datapath);
        }
        if (this.getPerformanceOptionIndexpath() != null) {
            String indexpath = this.performanceOptionIndexpath.getDefaultValue();
            indexpath = ModelUtilities.formatPath(indexpath);
            aggregationStatement.append(ModelUtilities.newline).append("   INDEXPATH              = ").append(indexpath);
        }
        if (this.getPerformanceOptionPartsize() != null) {
            StringBuffer partsize = new StringBuffer(this.performanceOptionPartsize.getDefaultValue());
            aggregationStatement.append(ModelUtilities.newline).append(PARTSIZE_EQUALS).append(partsize);
        }
        if (this.getPerformanceOptionSegsize() != null) {
            StringBuffer segsize = new StringBuffer(this.performanceOptionSegsize.getDefaultValue());
            aggregationStatement.append(ModelUtilities.newline).append(SEGSIZE_EQUALS).append(segsize);
        }
        if (this.getPerformanceOptionCompress() != null) {
            if (this.performanceOptionCompress.getDefaultValue().equals("1")) {
                aggregationStatement.append(ModelUtilities.newline).append(COMPRESS);
            } else {
                aggregationStatement.append(ModelUtilities.newline).append(NOCOMPRESS);
            }
        }
        if (this.getPerformanceOptionIndex() != null) {
            if (this.performanceOptionIndex.getDefaultValue().equals("1")) {
                aggregationStatement.append(ModelUtilities.newline).append(INDEX);
            } else {
                aggregationStatement.append(ModelUtilities.newline).append(NOINDEX);
            }
        }
        aggregationStatement.append(";").append(ModelUtilities.newline);
        return aggregationStatement;
    }

    public AggregationTable getAggregationTable() throws OLAPException {
        this.verifyDeleted();
        if (this.tableSet == null) {
            this.tableSet = this.owningCube.getTableSet();
        }
        if (!this.changedTable && this.table == null && this.metadataObject != null) {
            Aggregation aggregation = (Aggregation)this.metadataObject;
            AssociationList tables = null;
            try {
                tables = aggregation.getAggregationTables();
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            if (tables.size() > 0) {
                PhysicalTable jomaTable = (PhysicalTable)tables.elementAt(0);
                this.table = this.tableSet.getAggregationTable(jomaTable);
                if (this.table == null) {
                    this.table = new AggregationTable(this.tableSet, jomaTable);
                }
            }
        }
        if (this.isNway() && this.tableSet.isLoadClassicSAS() && this.table == null) {
            this.table = new AggregationTable(this.tableSet, null);
            this.table.setLoadTable(true);
        }
        return this.table;
    }

    public boolean hasPerformanceOptions() throws OLAPException {
        return this.getPerformanceOptionCompress() != null || this.getPerformanceOptionDatapath() != null || this.getPerformanceOptionIndex() != null || this.getPerformanceOptionIndexpath() != null || this.getPerformanceOptionPartsize() != null || this.getPerformanceOptionSegsize() != null;
    }

    public boolean havePerformanceOptionsChanged() {
        boolean returnValue = false;
        try {
            returnValue = this.isCompressChanged() || this.isDatapathChanged() || this.isIndexChanged() || this.isIndexpathChanged() || this.isPartsizeChanged() || this.isSegsizeChanged();
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return returnValue;
    }

    AggregationTable hiddenGetAggregationTable() throws OLAPException {
        boolean tempDeleted = this.deleted;
        this.deleted = false;
        AggregationTable tempTable = this.getAggregationTable();
        this.deleted = tempDeleted;
        return tempTable;
    }

    boolean hiddenIsNway() {
        boolean tempDeleted = this.deleted;
        this.deleted = false;
        boolean tempNway = this.isNway();
        this.deleted = tempDeleted;
        return tempNway;
    }

    boolean hiddenIsNewObject() {
        boolean tempDeleted = this.deleted;
        this.deleted = false;
        boolean tempNewObject = this.isNewObject();
        this.deleted = tempDeleted;
        return tempNewObject;
    }

    public boolean isSimilar(PhysicalTable inputTable) throws OLAPException {
        boolean similar;
        boolean bl = similar = this.getAggregationTable() != null;
        if (similar) {
            similar = this.table.isSimilar(this, inputTable);
        }
        return similar;
    }

    public boolean isNway() {
        if (this.nway == null & !this.hiddenIsNewObject()) {
            Aggregation aggregation = (Aggregation)this.metadataObject;
            try {
                this.nway = aggregation.getNway() == 1;
            }
            catch (RemoteException e) {
                this.nway = false;
            }
        }
        if (this.nway == null) {
            this.nway = false;
        }
        return this.nway;
    }

    private boolean isVerified() throws OLAPException {
        boolean verified = this.getLevels().equals(this.verifiedLevels);
        if (!verified) {
            this.verifiedDuplicated = false;
            this.verifiedDrillPath = false;
        } else {
            verified = this.verifiedName;
        }
        return verified;
    }

    private void resetLevelsBackup() {
        if (this.levelsBackup != null) {
            this.levelsBackup.clear();
            for (int i = this.levels.size() - 1; i >= 0; --i) {
                this.levelsBackup.add(0, this.levels.get(i));
            }
        }
    }

    public void setAggregationTable(AggregationTable inputTable) throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        OLAPList tables = this.aggregationSet.getTables();
        OLAPList storedAggregations = this.aggregationSet.getStoredAggregations();
        OLAPList generatedAggregations = this.aggregationSet.getGeneratedAggregations();
        this.aggregationSet.removeFromAggregationByTables(this, inputTable);
        if (!this.tableOptionsRetrieved & this.metadataObject != null) {
            this.getTableOptions();
        }
        if (inputTable != null) {
            this.aggregationSet.setHasStoredAggregations(true);
            this.aggregationSet.addAggregationByTable(this, inputTable);
            if (tables.indexOf(inputTable) < 0) {
                tables.add(inputTable);
            }
            if (storedAggregations.indexOf(this) < 0) {
                storedAggregations.getTheList().add(this);
            }
            if (generatedAggregations.indexOf(this) >= 0) {
                generatedAggregations.getTheList().remove(this);
            }
            if (this.type == null || this.type.equals(MOLAP)) {
                this.type = ROLAP;
                this.setUpChanges("setType", String.class, this.type);
            }
        } else {
            this.setTableOptions(null);
            if (storedAggregations.indexOf(this) >= 0) {
                storedAggregations.getTheList().remove(this);
            }
            if (storedAggregations.size() == 0) {
                this.aggregationSet.setHasStoredAggregations(false);
            }
            if (generatedAggregations.indexOf(this) < 0) {
                generatedAggregations.getTheList().add(this);
            }
            if (this.type == null || this.type.equals(ROLAP)) {
                this.type = MOLAP;
                this.setUpChanges("setType", String.class, this.type);
            }
        }
        this.table = inputTable;
        this.changedTable = true;
        this.setUpChanges("setAggregationTable", AggregationTable.class, this.table);
    }

    private boolean isCompressChanged() throws OLAPException {
        boolean changed = this.compress != this.originalCompress;
        return changed;
    }

    private boolean isDatapathChanged() throws OLAPException {
        boolean changed = this.datapath != this.originalDatapath;
        return changed;
    }

    private boolean isNameChanged() {
        return !this.originalName.equalsIgnoreCase(this.name);
    }

    private boolean isIndexChanged() throws OLAPException {
        boolean changed = this.index != this.originalIndex;
        return changed;
    }

    private boolean isIndexpathChanged() throws OLAPException {
        boolean changed = this.indexpath != this.originalIndexpath;
        return changed;
    }

    private boolean isPartsizeChanged() throws OLAPException {
        boolean changed = this.partsize != this.originalPartsize;
        return changed;
    }

    private boolean isSegsizeChanged() throws OLAPException {
        boolean changed = this.segsize != this.originalSegsize;
        return changed;
    }

    boolean isAggregationTuningChanges() {
        boolean aggregationTuningChanges = false;
        try {
            aggregationTuningChanges = this.isNameChanged() || this.isCompressChanged() || this.isDatapathChanged() || this.isIndexChanged() || this.isIndexpathChanged() || this.isPartsizeChanged() || this.isSegsizeChanged();
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return aggregationTuningChanges;
    }

    @Override
    public void setName(String inputName) {
        this.verifyDeleted();
        super.setName(inputName);
        if (this.aggregationSet.isAggregationTuning() && !this.isNewObject()) {
            List dropped = this.aggregationSet.getDroppedAggregations().getTheList();
            List added = this.aggregationSet.getAddedAggregations().getTheList();
            if (!this.isAggregationTuningChanges()) {
                dropped.remove(this);
                added.remove(this);
            } else {
                if (dropped.indexOf(this) < 0) {
                    dropped.add(this);
                }
                if (added.indexOf(this) < 0) {
                    added.add(this);
                }
            }
        }
        this.setUpChanges("setName", String.class, inputName);
    }

    @Override
    public void setNotes(String inputNotes) {
        this.verifyDeleted();
        super.setNotes(inputNotes);
        this.setUpChanges("setNotes", String.class, inputNotes);
    }

    String getPerformanceOptions() throws OLAPException {
        String options = "";
        options = options + "COMPRESS=" + this.getPerformanceOptionCompress() + " ";
        options = options + "DATAPATH=" + this.getPerformanceOptionDatapath() + " ";
        options = options + "INDEX=" + this.getPerformanceOptionIndex() + " ";
        options = options + "INDEXPATH=" + this.getPerformanceOptionIndexpath() + " ";
        options = options + "PARTSIZE=" + this.getPerformanceOptionPartsize() + " ";
        options = options + "SEGSIZE=" + this.getPerformanceOptionSegsize();
        return options;
    }

    public void tuningAdd() throws OLAPException {
        AggregationTable table = this.getAggregationTable();
        List aggregations = this.aggregationSet.getAggregations().getTheList();
        List addedAggregations = this.aggregationSet.getAddedAggregations().getTheList();
        List droppedAggregations = this.aggregationSet.getDroppedAggregations().getTheList();
        List storedAggregations = this.aggregationSet.getStoredAggregations().getTheList();
        List generatedAggregations = this.aggregationSet.getGeneratedAggregations().getTheList();
        List performanceAggregations = this.aggregationSet.getPerformanceAggregations().getTheList();
        if (!aggregations.contains(this)) {
            aggregations.add(this);
        }
        if (!addedAggregations.contains(this) && (this.isNewObject() || !this.isNewObject() && this.isAggregationTuningChanges())) {
            addedAggregations.add(this);
        }
        if (table == null) {
            generatedAggregations.add(this);
        } else {
            storedAggregations.add(this);
        }
        if (this.hasPerformanceOptions()) {
            performanceAggregations.add(this);
        }
        if (this.isNewObject() || !this.isNewObject() && !this.isAggregationTuningChanges()) {
            droppedAggregations.remove(this);
        }
    }

    public void tuningDrop() throws OLAPException {
        AggregationTable table = this.getAggregationTable();
        List aggregations = this.aggregationSet.getAggregations().getTheList();
        List addedAggregations = this.aggregationSet.getAddedAggregations().getTheList();
        List droppedAggregations = this.aggregationSet.getDroppedAggregations().getTheList();
        List storedAggregations = this.aggregationSet.getStoredAggregations().getTheList();
        List generatedAggregations = this.aggregationSet.getGeneratedAggregations().getTheList();
        List performanceAggregations = this.aggregationSet.getPerformanceAggregations().getTheList();
        aggregations.remove(this);
        addedAggregations.remove(this);
        storedAggregations.remove(this);
        generatedAggregations.remove(this);
        performanceAggregations.remove(this);
        if (table != null) {
            this.aggregationSet.getAggregationsByTable(table).getTheList().remove(this);
        }
        if (!droppedAggregations.contains(this) && !this.isNewObject()) {
            droppedAggregations.add(this);
        }
    }

    void addTuningLists() {
        List dropped = this.aggregationSet.getDroppedAggregations().getTheList();
        List added = this.aggregationSet.getAddedAggregations().getTheList();
        if (!dropped.contains(this)) {
            dropped.add(this);
        }
        if (!added.contains(this)) {
            added.add(this);
        }
    }

    void removeTuningLists() {
        List dropped = this.aggregationSet.getDroppedAggregations().getTheList();
        List added = this.aggregationSet.getAddedAggregations().getTheList();
        dropped.remove(this);
        added.remove(this);
    }

    public void setPerformanceOptionCompress(Boolean optionValue) throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (optionValue != null) {
            if (this.performanceOptionCompress == null) {
                if (this.optionSet == null) {
                    this.optionSet = this.owningCube.getOptionsSet();
                }
                this.performanceOptionCompress = new Option(this.optionSet, this);
                this.performanceOptionCompress.setName("COMPRESS");
                this.performanceOptionCompress.setDesc("COMPRESS");
                this.performanceOptionCompress.setPropertyName("COMPRESS");
                this.performanceOptionCompress.setPropertyRole("OLAPOption");
                this.performanceOptionCompress.setOwningType(OptionSet.OWNING_TYPE_BOOLEAN);
                this.performanceOptionCompress.setPropertyOption(true);
            }
            String value = "0";
            if (optionValue.booleanValue()) {
                value = "1";
            }
            this.performanceOptionCompress.setDefaultValue(value);
        } else if (this.performanceOptionCompress != null) {
            List objectOptions = this.optionSet.getOptions(this);
            objectOptions.remove(this.performanceOptionCompress);
            this.performanceOptionCompress = null;
        }
        this.compress = optionValue;
        if (this.aggregationSet.isAggregationTuning() && !this.isNewObject()) {
            if (this.isAggregationTuningChanges()) {
                this.addTuningLists();
            } else {
                this.removeTuningLists();
            }
        }
        this.resetPerformanceOptions();
        this.setUpChanges("setPerformanceOptionCompress", Boolean.class, optionValue);
    }

    public void setPerformanceOptionDatapath(String optionValue) throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (optionValue != null) {
            if (this.performanceOptionDatapath == null) {
                if (this.optionSet == null) {
                    this.optionSet = this.owningCube.getOptionsSet();
                }
                this.performanceOptionDatapath = new Option(this.optionSet, this);
                this.performanceOptionDatapath.setName("DATAPATH");
                this.performanceOptionDatapath.setDesc("DATAPATH");
                this.performanceOptionDatapath.setPropertyName("DATAPATH");
                this.performanceOptionDatapath.setPropertyRole("OLAPOption");
                this.performanceOptionDatapath.setOwningType(OptionSet.OWNING_TYPE_STRING);
                int metadataVersion = Workspace.getMetadataServerVersionNumber();
                if (metadataVersion >= 9200) {
                    this.performanceOptionDatapath.setPropertyOption(false);
                } else {
                    this.performanceOptionDatapath.setPropertyOption(true);
                }
            }
            this.performanceOptionDatapath.setDefaultValue(optionValue);
        } else if (this.performanceOptionDatapath != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionDatapath) >= 0) {
                objectOptions.remove(this.performanceOptionDatapath);
            }
            this.performanceOptionDatapath = null;
        }
        this.datapath = optionValue;
        if (this.aggregationSet.isAggregationTuning() && !this.isNewObject()) {
            if (this.isAggregationTuningChanges()) {
                this.addTuningLists();
            } else {
                this.removeTuningLists();
            }
        }
        this.resetPerformanceOptions();
        this.setUpChanges("setPerformanceOptionDatapath", String.class, optionValue);
    }

    public void setPerformanceOptionIndex(Boolean optionValue) throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (optionValue != null) {
            if (this.performanceOptionIndex == null) {
                if (this.optionSet == null) {
                    this.optionSet = this.owningCube.getOptionsSet();
                }
                this.performanceOptionIndex = new Option(this.optionSet, this);
                this.performanceOptionIndex.setName("INDEX");
                this.performanceOptionIndex.setDesc("INDEX");
                this.performanceOptionIndex.setPropertyName("INDEX");
                this.performanceOptionIndex.setPropertyRole("OLAPOption");
                this.performanceOptionIndex.setOwningType(OptionSet.OWNING_TYPE_BOOLEAN);
                this.performanceOptionIndex.setPropertyOption(true);
            }
            String value = "0";
            if (optionValue.booleanValue()) {
                value = "1";
            }
            this.performanceOptionIndex.setDefaultValue(value);
        } else if (this.performanceOptionIndex != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionIndex) >= 0) {
                objectOptions.remove(this.performanceOptionIndex);
            }
            this.performanceOptionIndex = null;
        }
        this.index = optionValue;
        if (this.aggregationSet.isAggregationTuning() && !this.isNewObject()) {
            if (this.isAggregationTuningChanges()) {
                this.addTuningLists();
            } else {
                this.removeTuningLists();
            }
        }
        this.resetPerformanceOptions();
        this.setUpChanges("setPerformanceOptionIndex", Boolean.class, optionValue);
    }

    public void setPerformanceOptionIndexpath(String optionValue) throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (optionValue != null) {
            if (this.performanceOptionIndexpath == null) {
                if (this.optionSet == null) {
                    this.optionSet = this.owningCube.getOptionsSet();
                }
                this.performanceOptionIndexpath = new Option(this.optionSet, this);
                this.performanceOptionIndexpath.setName("INDEXPATH");
                this.performanceOptionIndexpath.setDesc("INDEXPATH");
                this.performanceOptionIndexpath.setPropertyName("INDEXPATH");
                this.performanceOptionIndexpath.setPropertyRole("OLAPOption");
                this.performanceOptionIndexpath.setOwningType(OptionSet.OWNING_TYPE_STRING);
                int metadataVersion = Workspace.getMetadataServerVersionNumber();
                if (metadataVersion >= 9200) {
                    this.performanceOptionIndexpath.setPropertyOption(false);
                } else {
                    this.performanceOptionIndexpath.setPropertyOption(true);
                }
            }
            this.performanceOptionIndexpath.setDefaultValue(optionValue);
        } else if (this.performanceOptionIndexpath != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionIndexpath) >= 0) {
                objectOptions.remove(this.performanceOptionIndexpath);
            }
            this.performanceOptionIndexpath = null;
        }
        this.indexpath = optionValue;
        if (this.aggregationSet.isAggregationTuning() && !this.isNewObject()) {
            if (this.isAggregationTuningChanges()) {
                this.addTuningLists();
            } else {
                this.removeTuningLists();
            }
        }
        this.resetPerformanceOptions();
        this.setUpChanges("setPerformanceOptionIndexpath", String.class, optionValue);
    }

    public void setPerformanceOptionPartsize(Integer optionValue) throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (optionValue != null) {
            this.verifyPerformanceOptionPartsize(optionValue);
            if (this.performanceOptionPartsize == null) {
                if (this.optionSet == null) {
                    this.optionSet = this.owningCube.getOptionsSet();
                }
                this.performanceOptionPartsize = new Option(this.optionSet, this);
                this.performanceOptionPartsize.setName("PARTSIZE");
                this.performanceOptionPartsize.setDesc("PARTSIZE");
                this.performanceOptionPartsize.setPropertyName("PARTSIZE");
                this.performanceOptionPartsize.setPropertyRole("OLAPOption");
                this.performanceOptionPartsize.setOwningType(OptionSet.OWNING_TYPE_INTEGER);
                this.performanceOptionPartsize.setPropertyOption(true);
            }
            this.performanceOptionPartsize.setDefaultValue(optionValue.toString());
        } else if (this.performanceOptionPartsize != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionPartsize) >= 0) {
                objectOptions.remove(this.performanceOptionPartsize);
            }
            this.performanceOptionPartsize = null;
        }
        this.partsize = optionValue;
        if (this.aggregationSet.isAggregationTuning() && !this.isNewObject()) {
            if (this.isAggregationTuningChanges()) {
                this.addTuningLists();
            } else {
                this.removeTuningLists();
            }
        }
        this.resetPerformanceOptions();
        this.setUpChanges("setPerformanceOptionPartsize", Integer.class, optionValue);
    }

    public void setPerformanceOptionSegsize(Integer optionValue) throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (optionValue != null) {
            this.verifyPerformanceOptionSegsize(optionValue);
            if (this.performanceOptionSegsize == null) {
                if (this.optionSet == null) {
                    this.optionSet = this.owningCube.getOptionsSet();
                }
                this.performanceOptionSegsize = new Option(this.optionSet, this);
                this.performanceOptionSegsize.setName("SEGSIZE");
                this.performanceOptionSegsize.setDesc("SEGSIZE");
                this.performanceOptionSegsize.setPropertyName("SEGSIZE");
                this.performanceOptionSegsize.setPropertyRole("OLAPOption");
                this.performanceOptionSegsize.setOwningType(OptionSet.OWNING_TYPE_INTEGER);
                this.performanceOptionSegsize.setPropertyOption(true);
            }
            this.performanceOptionSegsize.setDefaultValue(optionValue.toString());
        } else if (this.performanceOptionSegsize != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.performanceOptionSegsize) >= 0) {
                objectOptions.remove(this.performanceOptionSegsize);
            }
            this.performanceOptionSegsize = null;
        }
        this.segsize = optionValue;
        if (this.aggregationSet.isAggregationTuning() && !this.isNewObject()) {
            if (this.isAggregationTuningChanges()) {
                this.addTuningLists();
            } else {
                this.removeTuningLists();
            }
        }
        this.resetPerformanceOptions();
        this.setUpChanges("setPerformanceOptionSegsize", Integer.class, optionValue);
    }

    private void resetPerformanceOptions() throws OLAPException {
        OLAPList performanceOptions = this.aggregationSet.getPerformanceAggregations();
        if (this.hasPerformanceOptions() & performanceOptions.indexOf(this) < 0) {
            performanceOptions.getTheList().add(this);
        } else if (!this.hasPerformanceOptions() & performanceOptions.indexOf(this) >= 0) {
            performanceOptions.getTheList().remove(this);
        }
    }

    void resetVerifiedLevels() {
        if (this.verifiedLevels == null) {
            this.verifiedLevels = new OLAPList(OLAPLevel.class);
            this.verifiedLevels.setParentObject(this);
        } else {
            this.verifiedLevels.getTheList().clear();
        }
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            this.verifiedLevels.getTheList().add(0, this.levels.get(i));
        }
    }

    void resetHierarchyLevels() throws OLAPException {
        if (this.hierarchies != null) {
            Object[] tempHierarchies = this.levelsByHierarchy.keySet().toArray();
            this.dimensionSet = this.owningCube.getDimensionSet();
            OLAPList dimensionHierarchies = this.dimensionSet.getHierarchies();
            for (int i = tempHierarchies.length - 1; i >= 0; --i) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)tempHierarchies[i];
                OLAPList tempLevels = (OLAPList)this.levelsByHierarchy.get(hierarchy);
                if (dimensionHierarchies.indexOf(hierarchy) < 0) {
                    if (this.levelsByHierarchy == null) continue;
                    if (tempLevels != null) {
                        tempLevels.getTheList().clear();
                        this.levelsByHierarchy.remove(tempLevels);
                        tempLevels = null;
                    }
                    this.levelsByHierarchy.remove(hierarchy);
                    continue;
                }
                this.getLevelsByHierarchy(hierarchy);
            }
        }
    }

    void setAggregationSet(AggregationSet inputAggregationSet) {
        this.aggregationSet = inputAggregationSet;
    }

    public void setCount(Integer inputCount) {
        this.count = inputCount;
    }

    @Override
    public void setDesc(String inputDesc) {
        this.verifyDeleted();
        this.verifyDropped();
        super.setDesc(inputDesc);
        this.setUpChanges("setDesc", String.class, inputDesc);
    }

    void setIsNway(boolean inputNway) throws OLAPException {
        if (inputNway) {
            OLAPList aggregations = this.aggregationSet.getAggregations();
            boolean found = false;
            OLAPAggregation aggregation = null;
            int i = 0;
            int size = aggregations.size();
            while (i < size & !found) {
                aggregation = (OLAPAggregation)aggregations.get(i);
                if (aggregation != this && aggregation.isNway()) {
                    found = true;
                }
                ++i;
            }
            if (found) {
                throw new OLAPException(bundle.formatString("OLAPAggregation.NwayAlreadyExists.fmt.txt", (Object)aggregation.getName()), 0);
            }
        }
        this.nway = inputNway;
        if (this.tableSet == null) {
            this.tableSet = this.owningCube.getTableSet();
        }
        if (inputNway && this.table == null && this.tableSet.isLoadClassicSAS()) {
            this.setAggregationTable(this.tableSet.getAggregationTable(this.tableSet.getLoadTable().getTable()));
        }
        this.verifiedName = true;
        this.verifiedDuplicated = true;
        this.verifiedDrillPath = true;
    }

    public void setTableOptions(String inputTableOptions) throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (this.optionSet == null) {
            this.optionSet = this.owningCube.getOptionsSet();
        }
        this.tableOption = this.optionSet.getOption(this, "AggregationTable_options", "OLAP Table Options");
        if (inputTableOptions != null & !ModelUtilities.isBlank(inputTableOptions)) {
            if (this.tableOption == null) {
                this.tableOption = new Option(this.optionSet, this);
                this.tableOption.setName("AggregationTable_options");
                this.tableOption.setDesc("AggregationTable_options");
                this.tableOption.setPropertyName("AggregationTable_options");
                this.tableOption.setPropertyRole("OLAP Table Options");
                this.tableOption.setOwningType(OptionSet.OWNING_TYPE_STRING);
            }
            this.tableOption.setPropertyOption(true);
            this.tableOption.setDefaultValue(inputTableOptions);
        } else if (this.tableOption != null) {
            List objectOptions = this.optionSet.getOptions(this);
            if (objectOptions.indexOf(this.tableOption) >= 0) {
                objectOptions.remove(this.tableOption);
            }
            this.tableOption = null;
        }
        if (this.tableOptions == null) {
            this.tableOptions = new HashMap();
        }
        this.tableOptions.put(this.table, inputTableOptions);
        this.changedTableOptions = true;
        this.setUpChanges("setTableOptions", String.class, inputTableOptions);
    }

    public void setTime(Double inputTime) {
        this.time = inputTime;
    }

    public void setType(String inputType) throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (inputType != null && !inputType.equals(MOLAP) && !inputType.equals(ROLAP)) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The input type must either be 'MOLAP' or 'ROLAP'.");
            }
            throw new IllegalArgumentException("Illegal argument is passed to the setType method.");
        }
        if (!this.isNewObject() & this.isNway()) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"Cannot set the type for the NWAY aggregation.");
            }
            throw new IllegalStateException("Illegal use of the setType method with the current state of the cube.");
        }
        if (inputType == null) {
            inputType = MOLAP;
        }
        if (!inputType.equalsIgnoreCase(this.getType())) {
            if (this.getType().equalsIgnoreCase(ROLAP) & inputType.equalsIgnoreCase(MOLAP)) {
                this.setAggregationTable(null);
                List generated = this.aggregationSet.getGeneratedAggregations().getTheList();
                if (!generated.contains(this)) {
                    this.aggregationSet.getGeneratedAggregations().getTheList().add(this);
                }
                this.aggregationSet.getStoredAggregations().getTheList().remove(this);
                if (this.table != null) {
                    this.aggregationSet.getAggregationsByTable(this.table).getTheList().remove(this);
                }
            } else if (this.getType().equalsIgnoreCase(MOLAP) & inputType.equalsIgnoreCase(ROLAP)) {
                if (this.performanceOptionCompress != null) {
                    this.setPerformanceOptionCompress(null);
                }
                if (this.performanceOptionDatapath != null) {
                    this.setPerformanceOptionDatapath(null);
                }
                if (this.performanceOptionIndex != null) {
                    this.setPerformanceOptionIndex(null);
                }
                if (this.performanceOptionIndexpath != null) {
                    this.setPerformanceOptionIndexpath(null);
                }
                if (this.performanceOptionPartsize != null) {
                    this.setPerformanceOptionPartsize(null);
                }
                if (this.performanceOptionSegsize != null) {
                    this.setPerformanceOptionSegsize(null);
                }
                this.aggregationSet.getPerformanceAggregations().getTheList().remove(this);
                this.aggregationSet.getGeneratedAggregations().getTheList().remove(this);
                List stored = this.aggregationSet.getStoredAggregations().getTheList();
                if (!stored.contains(this)) {
                    this.aggregationSet.getStoredAggregations().getTheList().add(this);
                }
            }
            this.type = inputType;
            this.setUpChanges("setType", String.class, inputType);
        }
    }

    void setVerifyLevels(boolean verify) {
        this.verifiedDrillPath = verify;
        this.verifiedDuplicated = verify;
    }

    private void updateCubeMetadata() throws OLAPException {
        try {
            Cube jomaCube = (Cube)this.owningCube.metadataObject;
            Aggregation aggregation = (Aggregation)this.metadataObject;
            AssociationList jomaAggregations = jomaCube.getAggregations(false);
            if (jomaAggregations.indexOf((Object)aggregation) < 0) {
                jomaAggregations.addElement((Object)aggregation);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    private void updateMetadataGetNwayLevels() throws RemoteException, MdException, OLAPException {
        Aggregation aggregation = (Aggregation)this.metadataObject;
        AssociationList aggregationLevels = aggregation.getLevels(false);
        if (aggregationLevels.isEmpty()) {
            if (this.levelsBackup == null) {
                this.levelsBackup = new OLAPList(OLAPLevel.class);
            }
            this.levelsBackup.clear();
        }
        if (this.levels == null || this.levels.isEmpty()) {
            OLAPList nwayLevels = this.aggregationSet.getNwayDrillPathFromDimensionSet();
            if (this.levels == null) {
                this.levels = nwayLevels;
            } else {
                this.levels = new OLAPList(OLAPLevel.class);
                for (int i = nwayLevels.size() - 1; i >= 0; --i) {
                    this.levels.add((OLAPLevel)nwayLevels.get(i));
                }
            }
        }
    }

    private void updateMolapLevelsMetadata() throws OLAPException {
        if (this.isNway()) {
            try {
                this.updateMetadataGetNwayLevels();
            }
            catch (MdException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
            }
        }
        Aggregation aggregation = (Aggregation)this.metadataObject;
        AssociationList aggregationLevels = null;
        try {
            aggregationLevels = aggregation.getLevels(false);
            if (this.levelsBackup != null && !this.levelsBackup.equals(this.levels)) {
                aggregationLevels.clear();
                for (int i = this.levels.size() - 1; i >= 0; --i) {
                    OLAPLevel level = (OLAPLevel)this.levels.get(i);
                    aggregationLevels.add(0, (Object)level.metadataObject);
                }
            }
            if (this.getType().equals(MOLAP)) {
                LoadTable loadTable;
                if (this.tableSet == null) {
                    this.tableSet = this.owningCube.getTableSet();
                }
                if ((loadTable = this.tableSet.getLoadTable()) != null) {
                    ClassifierMap loadMap = loadTable.getClassifierMap();
                    for (int i = aggregationLevels.size() - 1; i >= 0; --i) {
                        Level level = (Level)aggregationLevels.get(i);
                        AssociationList featureMaps = level.getTargetFeatureMaps();
                        if (featureMaps.size() <= 1) continue;
                        for (int j = featureMaps.size() - 1; j >= 0; --j) {
                            FeatureMap featureMap = (FeatureMap)featureMaps.get(j);
                            ClassifierMap map = featureMap.getAssociatedClassifierMap();
                            if (map == null || map.getTransformRole().equalsIgnoreCase("STARDIM") || map == loadMap || map.getTransformRole().equalsIgnoreCase("ESRI Map File")) continue;
                            MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)featureMap, "", bundle.getString("MdException.GenericError.txt"));
                        }
                    }
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), (Throwable)mdError, 12, "MdException in updateMolapLevelsMetadata.");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }

    @Override
    public void updateMetadata() throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (!this.isVerified()) {
            this.verifyName();
            this.verifyTable();
            this.verifyDrillPath();
            this.verifyDuplicated();
        }
        if (this.metadataObject == null) {
            this.metadataObject = (Aggregation)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "Aggregation", this.owningCube.getRepositoryShortFQID());
        }
        Aggregation aggregation = (Aggregation)this.metadataObject;
        super.updateMetadata();
        try {
            aggregation.setType(this.getType());
        }
        catch (RemoteException e) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
        }
        this.updateCubeMetadata();
        this.updateMolapLevelsMetadata();
        this.updateNwayMetadata();
        this.updateAggregationTable();
        this.updateRolapLevelsMetadata();
        this.updateOptionsMetadata();
        this.resetLevelsBackup();
    }

    @Override
    public void undo() {
        this.verifyDeleted();
        this.verifyDropped();
        if (!this.isNway()) {
            super.undo();
        }
    }

    private void updateAggregationTable() throws OLAPException {
        if (this.changedTable) {
            try {
                Aggregation aggregation = (Aggregation)this.metadataObject;
                AssociationList aggregationTables = null;
                aggregationTables = aggregation.getAggregationTables(false);
                aggregationTables.clear();
                if (this.getType().equals(ROLAP)) {
                    aggregationTables.addElement((Object)this.getAggregationTable().getTable());
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), (Throwable)mdError, 12, "MdException in OLAPAggregation.updateAggregationTable");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    private void updateNwayMetadata() {
        Aggregation aggregation = (Aggregation)this.metadataObject;
        int nwayMetadata = 0;
        if (this.isNway()) {
            nwayMetadata = 1;
        }
        try {
            aggregation.setNway(nwayMetadata);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void updateOptionsMetadata() throws OLAPException {
        if (this.optionSet != null) {
            try {
                CMetadata custom;
                Property property;
                int i;
                this.getPerformanceOptionCompress();
                this.getPerformanceOptionDatapath();
                this.getPerformanceOptionIndex();
                this.getPerformanceOptionIndexpath();
                this.getPerformanceOptionPartsize();
                this.getPerformanceOptionSegsize();
                List options = this.optionSet.getOptions(this);
                HashMap<String, Object> metadataOptions = new HashMap<String, Object>();
                AssociationList properties = this.metadataObject.getProperties(false);
                for (int i2 = properties.size() - 1; i2 >= 0; --i2) {
                    Property property2 = (Property)properties.get(i2);
                    if (!property2.getName().equalsIgnoreCase("NRACKS")) continue;
                    PropertyType propertyType = property2.getOwningType();
                    if (propertyType != null) {
                        propertyType.delete();
                    }
                    property2.delete();
                }
                AssociationList customs = this.metadataObject.getCustomAssociations(false);
                int size = options.size();
                for (i = 0; i < size; ++i) {
                    Option option = (Option)options.get(i);
                    option.updateMetadata();
                }
                size = properties.size();
                for (i = 0; i < size; ++i) {
                    Property property3 = (Property)properties.elementAt(i);
                    if (property3.getPropertyRole().equals("OLAP Table Options")) {
                        metadataOptions.put("OLAP Table Options", property3);
                        continue;
                    }
                    metadataOptions.put(property3.getPropertyName(), property3);
                }
                int metadataVersion = Workspace.getMetadataServerVersionNumber();
                if (metadataVersion >= 9200) {
                    int size2 = customs.size();
                    for (int i3 = 0; i3 < size2; ++i3) {
                        CustomAssociation custom2 = (CustomAssociation)customs.elementAt(i3);
                        metadataOptions.put(custom2.getPartnerName(), custom2);
                    }
                }
                if (this.isCompressChanged() && this.performanceOptionCompress == null && (property = (Property)metadataOptions.get("COMPRESS")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.formatString("MdException.GenericError.txt", (Object)"COMPRESS"));
                }
                if (this.isDatapathChanged() && this.performanceOptionDatapath == null && (custom = (CMetadata)metadataOptions.get("DATAPATH")) != null && custom.getName().equalsIgnoreCase("DATAPATH")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), custom, "<Templates><AssociatedObjects/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.isIndexChanged() && this.performanceOptionIndex == null && (property = (Property)metadataOptions.get("INDEX")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.formatString("MdException.GenericError.txt", (Object)"INDEX"));
                }
                if (this.isIndexpathChanged() && this.performanceOptionIndexpath == null && (custom = (CMetadata)metadataOptions.get("INDEXPATH")) != null && custom.getName().equalsIgnoreCase("INDEXPATH")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), custom, "<Templates><AssociatedObjects/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                if (this.isPartsizeChanged() && this.performanceOptionPartsize == null && (property = (Property)metadataOptions.get("PARTSIZE")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.formatString("MdException.GenericError.txt", (Object)"PARTSIZE"));
                }
                if (this.isSegsizeChanged() && this.performanceOptionSegsize == null && (property = (Property)metadataOptions.get("SEGSIZE")) != null && property.getPropertyRole().equals("OLAPOption")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.formatString("MdException.GenericError.txt", (Object)"SEGSIZE"));
                }
                if (this.changedTableOptions & this.tableOption == null && (property = (Property)metadataOptions.get("OLAP Table Options")) != null && property.getPropertyRole().equals("OLAP Table Options")) {
                    MetadataTemplate.deleteMetadata(this.owningCube.getObjectStore(), (CMetadata)property, "<Templates><StoredConfiguration/></Templates>", bundle.getString("MdException.GenericError.txt"));
                }
                int size3 = properties.size();
                for (int i4 = 0; i4 < size3; ++i4) {
                    Property property4 = (Property)properties.elementAt(i4);
                    PropertyType propertyType = property4.getOwningType();
                    if (propertyType == null) continue;
                    property4.setSQLType(propertyType.getSQLType());
                    propertyType.delete();
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    private List getFeatureMaps(Level levelObject) throws MdException, RemoteException {
        int i;
        ArrayList<Object> featureMaps = new ArrayList<Object>();
        AssociationList targetFeatureMaps = levelObject.getTargetFeatureMaps();
        AssociationList targetTransformations = levelObject.getTargetTransformations();
        for (i = targetFeatureMaps.size() - 1; i >= 0; --i) {
            featureMaps.add(targetFeatureMaps.get(i));
        }
        for (i = targetTransformations.size() - 1; i >= 0; --i) {
            featureMaps.add(targetTransformations.get(i));
        }
        return featureMaps;
    }

    private void updateRolapLevelsMetadata() throws OLAPException {
        try {
            if (this.isNway()) {
                this.updateMetadataGetNwayLevels();
            }
            if (this.getType().equals(ROLAP) & this.getAggregationTable() != null) {
                for (int i = this.getLevels().size() - 1; i >= 0; --i) {
                    OLAPLevel level = (OLAPLevel)this.levels.get(i);
                    Level jomaLevel = (Level)level.metadataObject;
                    List featureMaps = this.getFeatureMaps(jomaLevel);
                    AggregationTable aggregationTable = this.getAggregationTable();
                    ClassifierMap tableClassifierMap = aggregationTable.getClassifierMap();
                    boolean found = false;
                    FeatureMap featureMap = null;
                    PhysicalTable sourceTable = null;
                    int j = featureMaps.size() - 1;
                    while (j >= 0 & !found) {
                        featureMap = (FeatureMap)featureMaps.get(j);
                        ClassifierMap classifierMap = featureMap.getAssociatedClassifierMap();
                        if (classifierMap != null && classifierMap.equals((Object)tableClassifierMap)) {
                            AssociationList sources = classifierMap.getTransformationSources();
                            if (sources.isEmpty()) {
                                sources = classifierMap.getClassifierSources();
                            }
                            if (!sources.isEmpty()) {
                                sourceTable = (PhysicalTable)sources.elementAt(0);
                                found = aggregationTable.equals(sourceTable);
                            }
                        }
                        --j;
                    }
                    if (!found) {
                        featureMap = (FeatureMap)MetadataTemplate.createMetadata(this.owningCube.getObjectStore(), "FeatureMap", this.owningCube.getRepositoryShortFQID());
                        StringBuffer featureMapName = new StringBuffer(aggregationTable.getSASTableName());
                        featureMapName.append('_');
                        featureMapName.append(level.getName());
                        featureMapName.append("_FeatureMap");
                        featureMap.setName(featureMapName.toString());
                        featureMap.setTransformRole("ONETOONE");
                        if (tableClassifierMap == null) {
                            tableClassifierMap = aggregationTable.createClassifierMap();
                        }
                        featureMap.setAssociatedClassifierMap(tableClassifierMap);
                        String levelName = level.getName();
                        OLAPColumn column = aggregationTable.getColumn(levelName);
                        featureMap.getFeatureSources().addElement((Object)column.metadataObject);
                    }
                    AssociationList targetFeatureMaps = jomaLevel.getTargetFeatureMaps();
                    AssociationList targetTransformations = jomaLevel.getTargetTransformations();
                    targetFeatureMaps.remove((Object)featureMap);
                    targetTransformations.remove((Object)featureMap);
                    if (aggregationTable.isLoadTable()) {
                        targetFeatureMaps.add((Object)featureMap);
                        continue;
                    }
                    targetTransformations.add((Object)featureMap);
                    AssociationList featureSources = featureMap.getFeatureSources();
                    if (featureSources.isEmpty()) continue;
                    Object object = featureSources.get(0);
                    featureSources.clear();
                    AssociationList transformationSources = featureMap.getTransformationSources();
                    transformationSources.clear();
                    transformationSources.add(object);
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    public void verifyDrillPath() throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        this.aggregationSet.verifyDrillPath(this.getLevels(), this.name);
        this.verifiedDrillPath = true;
        if (this.verifiedDuplicated) {
            this.resetVerifiedLevels();
        }
    }

    public void verifyDuplicated() throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        this.aggregationSet.verifyDuplicated(this.getLevels(), this.name);
        this.verifiedDuplicated = true;
        if (this.verifiedDrillPath) {
            this.resetVerifiedLevels();
        }
    }

    public void verifyLevels() throws OLAPException {
        this.verifyDeleted();
        this.verifyDrillPath();
        this.verifyDuplicated();
    }

    public void verifyTable() throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (this.getType().equals(ROLAP) & this.table == null) {
            throw new OLAPException(bundle.formatString("OLAPAggregation.NoTable.fmt.txt", (Object)this.name), 0);
        }
    }

    private StringBuffer verifyTableMetadata() throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        StringBuffer errorMessage = new StringBuffer();
        Aggregation aggregation = (Aggregation)this.metadataObject;
        PhysicalTable jomaTable = null;
        try {
            if (aggregation.getType().equals(ROLAP)) {
                AssociationList jomaTables = aggregation.getAggregationTables(false);
                if (jomaTables.isEmpty()) {
                    errorMessage.append(bundle.formatString("OLAPAggregation.MissingAggregationTable.fmt.txt", (Object)aggregation.getName())).append("  ");
                } else {
                    jomaTable = (PhysicalTable)jomaTables.elementAt(0);
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        if (jomaTable != null) {
            try {
                SASLibrary sasLibrary = LibraryUtil.getLibrary(jomaTable, null);
                if (sasLibrary == null) {
                    errorMessage.append(bundle.formatString("OLAPAggregation.MissingAggregationTableLibref.fmt.txt", (Object)jomaTable.getName(), (Object)aggregation.getName())).append("  ");
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return errorMessage;
    }

    private List getSources(FeatureMap featureMap) throws MdException, RemoteException {
        int i;
        ArrayList<Object> sources = new ArrayList<Object>();
        AssociationList featureSources = featureMap.getFeatureSources();
        AssociationList transformationSources = featureMap.getTransformationSources();
        for (i = featureSources.size() - 1; i >= 0; --i) {
            sources.add(featureSources.get(i));
        }
        for (i = transformationSources.size() - 1; i >= 0; --i) {
            sources.add(transformationSources.get(i));
        }
        return sources;
    }

    private StringBuffer verifyAggregateTableLevelMetadata() throws OLAPException {
        StringBuffer errorMessage = new StringBuffer();
        this.getAggregationTable();
        LoadTable loadTable = this.owningCube.getTableSet().getLoadTable();
        if (this.table != null && !this.table.equals(loadTable)) {
            boolean validAggregationTable = true;
            OLAPLevel problemLevel = null;
            if (this.levels == null) {
                this.getLevels();
            }
            int i = this.levels.size() - 1;
            while (i >= 0 & validAggregationTable) {
                problemLevel = (OLAPLevel)this.levels.get(i);
                Level jomaLevel = (Level)problemLevel.metadataObject;
                List featureMaps = null;
                try {
                    featureMaps = this.getFeatureMaps(jomaLevel);
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                }
                if (!featureMaps.isEmpty()) {
                    validAggregationTable = false;
                    int j = featureMaps.size() - 1;
                    while (j >= 0 & !validAggregationTable) {
                        block22: {
                            FeatureMap featureMap = (FeatureMap)featureMaps.get(j);
                            ClassifierMap classifierMap = null;
                            try {
                                classifierMap = featureMap.getAssociatedClassifierMap();
                                if (classifierMap.getName().equals("Load Map")) break block22;
                                PhysicalTable jomaTable = null;
                                try {
                                    AssociationList transformationSources = classifierMap.getTransformationSources(false);
                                    if (!transformationSources.isEmpty()) {
                                        jomaTable = (PhysicalTable)transformationSources.get(0);
                                    }
                                    if (validAggregationTable = this.table.equals(jomaTable)) {
                                        List featureSources = this.getSources(featureMap);
                                        validAggregationTable = !featureSources.isEmpty();
                                    }
                                }
                                catch (MdException mdError) {
                                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                                }
                                catch (RemoteException re) {
                                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                                }
                            }
                            catch (MdException mdError) {
                                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                            }
                            catch (RemoteException re) {
                                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                            }
                        }
                        --j;
                    }
                }
                if (!validAggregationTable) {
                    StringBuffer libTable = new StringBuffer();
                    SASLibrary library = null;
                    try {
                        library = LibraryUtil.getLibrary((DataTable)this.table.getTable(), null);
                    }
                    catch (MdException mdError) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                    }
                    catch (RemoteException re) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                    }
                    libTable.append(library).append(".").append(this.table.getSASTableName());
                    try {
                        errorMessage.append(bundle.formatString("OLAPAggregation.LevelMissingColumnMetadata.fmt.txt", (Object)problemLevel.getName(), (Object)this.getName(), (Object)this.table.getTable().getName())).append("  ");
                    }
                    catch (RemoteException re) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                    }
                }
                --i;
            }
        }
        return errorMessage;
    }

    private List getFeatureMaps(Measure measureObject) throws MdException, RemoteException {
        int i;
        ArrayList<Object> featureMaps = new ArrayList<Object>();
        AssociationList targetFeatureMaps = measureObject.getTargetFeatureMaps();
        AssociationList targetTransformations = measureObject.getTargetTransformations();
        for (i = targetFeatureMaps.size() - 1; i >= 0; --i) {
            featureMaps.add(targetFeatureMaps.get(i));
        }
        for (i = targetTransformations.size() - 1; i >= 0; --i) {
            featureMaps.add(targetTransformations.get(i));
        }
        return featureMaps;
    }

    private StringBuffer verifyAggregateColumnMetadata() throws OLAPException {
        StringBuffer errorMessage = new StringBuffer();
        this.getAggregationTable();
        LoadTable loadTable = this.owningCube.getTableSet().getLoadTable();
        if (this.table != null && !this.table.equals(loadTable)) {
            ClassifierMap classifierMap = this.table.getClassifierMap();
            boolean validAggregationTable = true;
            OLAPMeasure problemMeasure = null;
            if (this.measureSet == null) {
                this.measureSet = this.owningCube.getMeasureSet();
            }
            OLAPList storedMeasures = this.measureSet.getStoredMeasures();
            int i = storedMeasures.size() - 1;
            while (i >= 0 & validAggregationTable) {
                problemMeasure = (OLAPMeasure)storedMeasures.get(i);
                Measure jomaMeasure = (Measure)problemMeasure.metadataObject;
                List featureMaps = null;
                try {
                    featureMaps = this.getFeatureMaps(jomaMeasure);
                }
                catch (MdException error) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                }
                if (featureMaps.isEmpty()) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), 0);
                }
                validAggregationTable = false;
                int j = featureMaps.size() - 1;
                while (j >= 0 & !validAggregationTable) {
                    FeatureMap featureMap = (FeatureMap)featureMaps.get(j);
                    ClassifierMap tempMap = null;
                    try {
                        tempMap = featureMap.getAssociatedClassifierMap();
                    }
                    catch (MdException error) {
                        throw new OLAPException("MdException.GenericError.txt", error, 12);
                    }
                    catch (RemoteException re) {
                        throw new OLAPException("MdException.GenericError.txt", re, 12);
                    }
                    if (tempMap != null && tempMap.equals((Object)classifierMap)) {
                        List sources = null;
                        try {
                            sources = this.getSources(featureMap);
                            validAggregationTable = !sources.isEmpty();
                        }
                        catch (MdException error) {
                            throw new OLAPException("MdException.GenericError.txt", error, 12);
                        }
                        catch (RemoteException re) {
                            throw new OLAPException("MdException.GenericError.txt", re, 12);
                        }
                    }
                    --j;
                }
                --i;
            }
            if (!validAggregationTable) {
                StringBuffer libTable = new StringBuffer();
                SASLibrary library = null;
                try {
                    library = LibraryUtil.getLibrary((DataTable)this.table.getTable(), null);
                    libTable.append(library).append(".").append(this.table.getTable().getName());
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                }
                errorMessage.append(bundle.formatString("OLAPMeasure.MeasureMissingColumnMetadata.fmt.txt", (Object)this.getName(), (Object)problemMeasure.getName(), (Object)libTable.toString())).append("  ");
            }
        }
        return errorMessage;
    }

    private void verifyDropped() {
        if (this.owningCube.physicallyExists()) {
            OLAPList droppedAggregations = this.aggregationSet.getDroppedAggregations();
            OLAPList addedAggregations = this.aggregationSet.getAddedAggregations();
            if (droppedAggregations.indexOf(this) >= 0 && addedAggregations.indexOf(this) < 0) {
                if (!ModelUtilities.isBlank(this.name)) {
                    throw new IllegalStateException(this.name + " is dropped.  Use its add() method to set back into the OLAP Cube.");
                }
                if (ModelUtilities.isBlank(this.name)) {
                    throw new IllegalStateException("The aggregation is dropped.  Use its add() method to set back into the OLAP Cube.");
                }
            }
        }
    }

    StringBuffer verifyMetadata() throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        StringBuffer errorMessage = new StringBuffer();
        if (this.metadataObject != null) {
            errorMessage.append(this.verifyTableMetadata());
            errorMessage.append(this.verifyAggregateTableLevelMetadata());
            errorMessage.append(this.verifyAggregateColumnMetadata());
            if (errorMessage.length() > 0) {
                this.setType(MOLAP);
                this.currentChanges = null;
                this.allChanges = null;
            }
        }
        return errorMessage;
    }

    @Override
    public void verifyName() throws OLAPException {
        this.verifyDeleted();
        this.verifyDropped();
        if (!this.isNway() && this.name != null && this.name.equalsIgnoreCase(bundle.getString("OLAPAggregation.DefaultNway.Name.txt"))) {
            throw new OLAPException(bundle.formatString("OLAPAggregation.DefaultAggregationName.fmt.txt", (Object)bundle.getString("OLAPAggregation.DefaultNway.Name.txt")), 0);
        }
        super.verifyName();
        this.aggregationSet.verifyUniqueName(this);
        this.verifiedName = true;
    }

    public void verifyPerformanceOptionPartsize(Integer optionValue) {
        this.verifyDeleted();
        this.verifyDropped();
        if (optionValue < 16) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)("(PARTSIZE) The number of aggregations to create in parallel must be " + Integer.toString(16) + " or more."));
            }
            throw new IllegalArgumentException(bundle.formatString("OLAPCube.PartSize.fmt.txt", (Object)"(PARTSIZE) ", (Object)Integer.toString(16)));
        }
    }

    public void verifyPerformanceOptionSegsize(Integer optionValue) {
        this.verifyDeleted();
        this.verifyDropped();
        if (optionValue < 1) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)("(SEGSIZE) The number of observations (in kilobytes) to include in the index component file segment must be " + Integer.toString(1) + " or more."));
            }
            throw new IllegalArgumentException(bundle.formatString("OLAPCube.SegSize.fmt.txt", (Object)"(SEGSIZE) ", (Object)Integer.toString(1)));
        }
    }
}

