/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.iom.SASIOMCommon.ISessionAdmin;
import com.sas.iom.SASIOMCommon.ISessionAdminHelper;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASMDX.ISession_1_1;
import com.sas.iom.SASMDX.ISession_1_1Helper;
import com.sas.iom.orb.UUIDConverter;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.designer.model.Session;
import com.sas.services.connection.ConnectionInterface;
import com.sas.workspace.WAdminResource;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Object;

public class MetadataQuery {
    private static WAdminResource bundle = new WAdminResource(MetadataQuery.class);
    private OlapServer server;
    private Session session;
    private UUID queryid;
    private String rowsetName;
    private String cubeNames;

    public MetadataQuery(OlapServer inServer, Session inSession, String inName, UUID uuid, String cubes) {
        this.server = inServer;
        this.session = inSession;
        this.rowsetName = inName;
        this.queryid = uuid;
        this.cubeNames = cubes;
    }

    public String getDisplayableId() {
        return UUIDConverter.uuidToString((UUID)this.queryid);
    }

    public String getType() {
        return this.rowsetName;
    }

    public String getCubeNames() {
        return this.cubeNames;
    }

    public void close() throws OLAPException {
        if (this.queryid != null) {
            if (!this.server.isConnected()) {
                throw new OLAPException(bundle.getString("OlapServer.NoConnectionError.txt"), 0);
            }
            try {
                ConnectionInterface connection = this.server.getConnection();
                Object obj = connection.getObject();
                ISessionAdmin sessionAdmin = ISessionAdminHelper.narrow((Object)obj);
                Object sobj = sessionAdmin.GetSession(this.session.getId());
                ISession_1_1 mdxSession = ISession_1_1Helper.narrow((Object)sobj);
                mdxSession.CloseResultSet(this.queryid);
            }
            catch (Exception e) {
                if (e instanceof COMM_FAILURE) {
                    this.server.disconnect();
                }
                throw new OLAPException(e.getLocalizedMessage(), e, 0);
            }
        }
    }
}

