/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.SharedDimension;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.OptionSet;
import com.sas.workspace.Workspace;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class LanguageSet {
    private Properties countries;
    private HashMap localeMap;
    private List selectedLocales;
    private AssociationList listOfPropertySets;
    private HashMap createdProperties;
    private PropertySet languagePropertySet;
    private MdObjectStore objectStore;
    private String shortFQID;
    private AbstractOLAPModel owningObject;

    LanguageSet(OLAPCube inOLAPCube) throws OLAPException {
        this.objectStore = inOLAPCube.getObjectStore();
        this.selectedLocales = new ArrayList();
        this.localeMap = new HashMap();
        this.createdProperties = new HashMap();
        this.owningObject = inOLAPCube;
        if (inOLAPCube.metadataObject != null) {
            try {
                Cube jomaCube = (Cube)inOLAPCube.metadataObject;
                this.listOfPropertySets = jomaCube.getPropertySets();
                this.setUpLanguageSet(this.listOfPropertySets);
            }
            catch (MdException mdError) {
                throw new OLAPException(mdError.getLocalizedMessage(), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    LanguageSet(OLAPSharedDimension inDim) throws OLAPException {
        this.objectStore = inDim.getObjectStore();
        this.selectedLocales = new ArrayList();
        this.localeMap = new HashMap();
        this.owningObject = inDim;
        if (inDim.metadataObject != null) {
            try {
                SharedDimension jomaDim = (SharedDimension)inDim.metadataObject;
                this.listOfPropertySets = jomaDim.getPropertySets();
                this.setUpLanguageSet(this.listOfPropertySets);
            }
            catch (MdException mdError) {
                throw new OLAPException(mdError.getLocalizedMessage(), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    void setUpLanguageSet(AssociationList listOfPropertySets) throws OLAPException {
        if (!listOfPropertySets.isEmpty()) {
            try {
                int iSize = listOfPropertySets.size();
                for (int i = 0; i < iSize; ++i) {
                    PropertySet propertySet = (PropertySet)listOfPropertySets.elementAt(i);
                    String name = propertySet.getName();
                    if (!name.equals("Languages")) continue;
                    this.languagePropertySet = propertySet;
                    AssociationList setProperties = propertySet.getSetProperties(true);
                    int jSize = setProperties.size();
                    for (int j = 0; j < jSize; ++j) {
                        Property language = (Property)setProperties.elementAt(j);
                        String locale = language.getDefaultValue().toUpperCase();
                        this.selectedLocales.add(locale);
                        this.createdProperties.put(locale, language);
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(mdError.getLocalizedMessage(), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    public Properties getCountries() throws OLAPException {
        if (this.countries == null) {
            this.countries = new Properties();
            try {
                Properties temp = new Properties();
                temp.load(this.getClass().getResourceAsStream("/com/sas/olapadmin/designer/model/UserDefinedTranslations.config"));
                for (String string : temp.keySet()) {
                    Locale locale = new Locale(string.substring(0, 2), string.substring(3, 5));
                    String countryName = locale.getDisplayName();
                    this.countries.setProperty(string.toUpperCase(), countryName);
                    this.localeMap.put(countryName, string.toUpperCase());
                }
            }
            catch (IOException ioError) {
                throw new OLAPException(ioError.getLocalizedMessage(), 0);
            }
        }
        return this.countries;
    }

    public String getCountry(String locale) {
        try {
            if (this.countries == null) {
                this.getCountries();
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return (String)this.countries.get(locale.toUpperCase());
    }

    public String getLocale(String country) {
        try {
            if (this.countries == null) {
                this.getCountries();
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return (String)this.localeMap.get(country);
    }

    public List getSelectedLocales() {
        return this.selectedLocales;
    }

    public boolean isCubeMLSDrillThruSupported() {
        boolean supported = this.isCubeMultipleLanguageSupported();
        try {
            if (supported & this.owningObject instanceof OLAPCube) {
                OLAPCube olapCube = (OLAPCube)this.owningObject;
                String defaultValue = olapCube.getDrillThruMemPref();
                supported = defaultValue != null && !ModelUtilities.isBlank(defaultValue);
            }
        }
        catch (OLAPException e) {
            supported = false;
        }
        return supported;
    }

    public boolean isCubeMultipleLanguageSupported() {
        boolean isMultipleLanguageSupported = false;
        if (!this.getSelectedLocales().isEmpty()) {
            isMultipleLanguageSupported = true;
        }
        return isMultipleLanguageSupported;
    }

    public boolean isSelectedLocale(String locale) {
        int isSelected = -1;
        isSelected = this.selectedLocales.indexOf(locale.toUpperCase());
        return isSelected >= 0;
    }

    public boolean isSupportedCountry(String country) {
        try {
            if (this.countries == null) {
                this.getCountries();
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return this.countries.containsValue(country);
    }

    public boolean isSupportedLocale(String locale) {
        try {
            if (this.countries == null) {
                this.getCountries();
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return this.countries.containsKey(locale.toUpperCase());
    }

    public void reset() {
        this.selectedLocales.clear();
    }

    public void updateMetadata() throws OLAPException {
        try {
            this.shortFQID = this.owningObject.getRepositoryShortFQID();
            if (this.selectedLocales.size() > 0) {
                String locale;
                int i;
                if (this.languagePropertySet == null) {
                    this.languagePropertySet = (PropertySet)MetadataTemplate.createMetadata(this.objectStore, "PropertySet", this.shortFQID);
                    this.languagePropertySet.setName("Languages");
                    this.languagePropertySet.setSetRole("OLAP UDT");
                    if (this.listOfPropertySets == null) {
                        this.listOfPropertySets = this.owningObject.metadataObject.getPropertySets();
                    }
                    this.listOfPropertySets.addElement((Object)this.languagePropertySet);
                }
                AssociationList setProperties = this.languagePropertySet.getSetProperties(false);
                for (i = setProperties.size() - 1; i >= 0; --i) {
                    Property language = (Property)setProperties.elementAt(i);
                    locale = language.getDefaultValue().toUpperCase();
                    if (this.selectedLocales.contains(locale)) continue;
                    MetadataTemplate.deleteMetadata(this.objectStore, (CMetadata)language, "<Templates><StoredConfiguration/></Templates>", "");
                }
                setProperties.clear();
                int size = this.selectedLocales.size();
                for (i = 0; i < size; ++i) {
                    locale = (String)this.selectedLocales.get(i);
                    Property language = (Property)this.createdProperties.get(locale);
                    if (language == null) {
                        language = (Property)MetadataTemplate.createMetadata(this.objectStore, "Property", this.shortFQID);
                        language.setName("UDT");
                        language.setDefaultValue(locale);
                        language.setPropertyName("UDT");
                        language.setPropertyRole("OLAP UDT");
                        language.setSQLType(OptionSet.OWNING_TYPE_STRING.intValue());
                    } else {
                        PropertyType propertyType = language.getOwningType();
                        if (propertyType != null) {
                            language.setSQLType(OptionSet.OWNING_TYPE_STRING.intValue());
                            propertyType.delete();
                        }
                    }
                    setProperties.addElement((Object)language);
                }
            } else if (this.languagePropertySet != null) {
                this.languagePropertySet.delete();
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(mdError.getLocalizedMessage(), mdError, 0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
    }
}

