/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SharedDimension;
import com.sas.metadata.remote.TableCollection;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.DimensionTable;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MLSCaptionTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.MetadataTemplate;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.util.Strings;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DimensionSet {
    static WAdminResource bundle = new WAdminResource(DimensionSet.class);
    private OLAPList dimensions;
    private OLAPList sharedDimensions;
    private OLAPList dimensionTables;
    private boolean dimensionChanged;
    OLAPList hierarchies;
    private OLAPCube cube;
    Map levels;
    private List hierarchyDeleteList;
    private List levelDeleteList;
    private List dimensionDeleteList;
    private List sharedDimensionDeleteList;
    Map metaLevelLevel;
    List levelNames;
    private List mapServers;
    private final String measures = "MEASURES";
    private final String SHAREDDIM = "SharedDimension";
    private final String DIMENSION = "Dimension";
    boolean resetAggregations;
    private final int maximumDimensionsHierarchiesPerCube = 128;
    private final int maximumLevelsPerCube = 256;
    private Map mapServiceColumns;
    private Map mapServices;
    public int allUpdateableDimensions;
    Map mappedLevels;
    Map mappedFactKeys;
    private OLAPList unmappedFactKeys;
    private OLAPList unmappedLevels;
    private Map existingCubeSharedDims;
    private HashMap mapOfSchemas;
    public final String FORMATYEAR = "YEAR4.";
    public final String FORMATQUARTER = "Q1.";
    public final String FORMATMONTH = "MONNAME9.";
    public final String FORMATWEEK = "WEEKV3";
    public final String FORMATDAY = "DAY.";
    public final String FORMATHOUR = "HOUR.";
    public final String FORMATMINUTE = "MINUTE.";
    public final String FORMATSECOND = "SECOND.";

    DimensionSet(OLAPCube olapCube) {
        this.cube = olapCube;
        this.existingCubeSharedDims = new HashMap();
    }

    DimensionSet() {
        this.existingCubeSharedDims = new HashMap();
    }

    public OLAPDimension getDimension(String dimensionName) throws OLAPException {
        OLAPDimension dimension = null;
        List all = this.getAllCubeDimensions();
        int i = all.size() - 1;
        while (i >= 0 & dimension == null) {
            dimension = (OLAPDimension)all.get(i);
            if (!dimension.getName().equalsIgnoreCase(dimensionName)) {
                dimension = null;
            }
            --i;
        }
        return dimension;
    }

    List getDimensionDeleteList() {
        if (this.dimensionDeleteList == null) {
            this.dimensionDeleteList = new ArrayList();
        }
        return this.dimensionDeleteList;
    }

    List getSharedDimensionDeleteList() {
        if (this.sharedDimensionDeleteList == null) {
            this.sharedDimensionDeleteList = new ArrayList();
        }
        return this.sharedDimensionDeleteList;
    }

    void clearMapTable() {
        if (this.mappedLevels != null) {
            this.mappedLevels.clear();
            this.mappedLevels = null;
        }
        if (this.mappedFactKeys != null) {
            this.mappedFactKeys.clear();
            this.mappedFactKeys = null;
        }
        if (this.unmappedLevels != null) {
            this.unmappedLevels.getTheList().clear();
            this.unmappedLevels = null;
        }
    }

    public OLAPDimension createOLAPDimension() throws OLAPException {
        AggregationSet aggregationSet = this.cube.getAggregationSet();
        aggregationSet.setResetLevels(true);
        OLAPDimension olapDimension = new OLAPDimension();
        olapDimension.setDimensionSet(this);
        olapDimension.setOwningCube(this.cube);
        this.verifyMaximumDimensionsPerCube();
        olapDimension.setOptionSet(this.cube.getOptionsSet());
        olapDimension.setTableSet(this.cube.getTableSet());
        olapDimension.setOptionSet(this.cube.getOptionsSet());
        this.getCubeDimensions().add(olapDimension);
        return olapDimension;
    }

    public OLAPDimension createOLAPDimension(Dimension metadataDimension) throws OLAPException {
        String tableOptions;
        String dimensionEmptyNum;
        String dimensionEmptyChar;
        OLAPDimension olapDimension = new OLAPDimension(metadataDimension);
        olapDimension.setDimensionSet(this);
        olapDimension.setOwningCube(this.cube);
        olapDimension.setTableSet(this.cube.getTableSet());
        olapDimension.setOptionSet(this.cube.getOptionsSet());
        String dimensionIgnoreEmpty = olapDimension.getIgnoreEmpty();
        if (dimensionIgnoreEmpty != null) {
            olapDimension.setUpChanges("setIgnoreEmpty", String.class, dimensionIgnoreEmpty);
        }
        if ((dimensionEmptyChar = olapDimension.getEmptyChar()) != null) {
            olapDimension.setUpChanges("setEmptyChar", String.class, dimensionEmptyChar);
        }
        if ((dimensionEmptyNum = olapDimension.getEmptyNum()) != null) {
            olapDimension.setUpChanges("setEmptyNum", String.class, dimensionEmptyNum);
        }
        String updateOption = olapDimension.getUpdateable();
        String cubeUpdateOption = this.cube.getUpdateableDimensions();
        if (updateOption != null && cubeUpdateOption != null && !cubeUpdateOption.equals("0")) {
            olapDimension.setUpChanges("setUpdateable", String.class, updateOption);
        }
        if ((tableOptions = olapDimension.getTableOptions()) != null) {
            olapDimension.setUpChanges("setTableOptions", String.class, tableOptions);
        }
        olapDimension.apply();
        return olapDimension;
    }

    List getHierarchyDeleteList() {
        if (this.hierarchyDeleteList == null) {
            this.hierarchyDeleteList = new ArrayList();
        }
        return this.hierarchyDeleteList;
    }

    List getLevelDeleteList() {
        if (this.levelDeleteList == null) {
            this.levelDeleteList = new ArrayList();
        }
        return this.levelDeleteList;
    }

    public OLAPList getTables() throws OLAPException {
        TableSet tableSet = this.cube.getTableSet();
        if (this.dimensionTables == null) {
            this.dimensionTables = new OLAPList(DimensionTable.class);
            try {
                List cubeClassifierMaps = tableSet.getClassifierMaps();
                for (int i = cubeClassifierMaps.size() - 1; i >= 0; --i) {
                    AssociationList transformationSources;
                    ClassifierMap classifierMap = (ClassifierMap)cubeClassifierMaps.get(i);
                    String transformRole = classifierMap.getTransformRole();
                    PhysicalTable dimensionTable = null;
                    if (!transformRole.equalsIgnoreCase("STARDIM") || (transformationSources = classifierMap.getTransformationSources()).isEmpty()) continue;
                    dimensionTable = (PhysicalTable)transformationSources.elementAt(0);
                    DimensionTable table = tableSet.getDimensionTable(dimensionTable);
                    this.dimensionTables.add(table);
                }
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return this.dimensionTables;
    }

    public String getTimeType(int inputType) {
        String time = "";
        switch (inputType) {
            case 1: {
                time = "STANDARD";
                break;
            }
            case 8192: {
                time = "STANDARD";
                break;
            }
            case 16: {
                time = "YEAR";
                break;
            }
            case 32: {
                time = "HALF_YEARS";
                break;
            }
            case 64: {
                time = "QUARTERS";
                break;
            }
            case 128: {
                time = "MONTHS";
                break;
            }
            case 256: {
                time = "WEEKS";
                break;
            }
            case 512: {
                time = "DAYS";
                break;
            }
            case 1024: {
                time = "HOURS";
                break;
            }
            case 2048: {
                time = "MINUTES";
                break;
            }
            case 4096: {
                time = "SECONDS";
            }
        }
        return time;
    }

    OLAPList getUnmappedFactKeys() throws OLAPException {
        if (this.mappedFactKeys != null && this.unmappedFactKeys == null) {
            this.unmappedFactKeys = new OLAPList(OLAPDimension.class);
            boolean starSchema = this.cube.getTableSet().isLoadStarSchema();
            List allDimensions = this.getAllCubeDimensions();
            for (int i = allDimensions.size() - 1; i >= 0; --i) {
                OLAPDimension dimension = (OLAPDimension)allDimensions.get(i);
                if (!starSchema) continue;
                OLAPColumn column = null;
                column = !dimension.isShared() ? dimension.getFactKey() : ((OLAPSharedDimension)dimension).getSharedDimensionFactKey(this.cube);
                if (column == null || this.mappedFactKeys.containsKey(dimension)) continue;
                this.unmappedFactKeys.add(dimension);
            }
            this.unmappedFactKeys.sort();
            this.unmappedFactKeys.setModifiable(false);
        }
        return this.unmappedFactKeys;
    }

    OLAPList getUnmappedLevels() throws OLAPException {
        if (this.mappedLevels != null && this.unmappedLevels == null) {
            this.unmappedLevels = new OLAPList(OLAPLevel.class);
            boolean starSchema = this.cube.getTableSet().isLoadStarSchema();
            for (int i = this.dimensions.size() - 1; i >= 0; --i) {
                OLAPDimension dimension = (OLAPDimension)this.dimensions.get(i);
                DimensionTable dimensionTable = null;
                if (starSchema) {
                    dimensionTable = dimension.getTable();
                }
                if (starSchema && (!starSchema || dimensionTable == null || !dimensionTable.isLoadTable())) continue;
                OLAPList dimensionLevels = dimension.getLevels();
                for (int j = dimensionLevels.size() - 1; j >= 0; --j) {
                    OLAPLevel level = (OLAPLevel)dimensionLevels.get(j);
                    if (this.mappedLevels.containsKey(level)) continue;
                    this.unmappedLevels.add(level);
                }
            }
            this.unmappedLevels.sort();
            this.unmappedLevels.setModifiable(false);
        }
        return this.unmappedLevels;
    }

    public boolean hasDimensionsChanged() {
        return this.dimensionChanged;
    }

    public boolean hasMLSCaptionTable() throws OLAPException {
        boolean foundMLSCaptionTable = false;
        this.getCubeDimensions();
        for (int i = this.dimensions.size() - 1; i >= 0 && !foundMLSCaptionTable; --i) {
            OLAPDimension dimension = (OLAPDimension)this.dimensions.get(i);
            MLSCaptionTable table = dimension.getMLSCaptionTable();
            if (table == null) continue;
            foundMLSCaptionTable = true;
        }
        return foundMLSCaptionTable;
    }

    boolean hasOneValidMappedLevel() throws OLAPException {
        OLAPDimension dimension;
        int i;
        boolean oneValidMappedLevel = true;
        ArrayList<Object> tempDimensions = new ArrayList<Object>();
        for (int i2 = this.dimensions.size() - 1; i2 >= 0; --i2) {
            tempDimensions.add(this.dimensions.get(i2));
        }
        TableSet tableSet = this.cube.getTableSet();
        if (this.mappedFactKeys != null && tableSet.isLoadStarSchema()) {
            oneValidMappedLevel = false;
            for (i = this.dimensions.size() - 1; i >= 0; --i) {
                dimension = (OLAPDimension)this.dimensions.get(i);
                Column column = (Column)this.mappedFactKeys.get(dimension);
                if (column != null) continue;
                tempDimensions.remove(dimension);
            }
        }
        oneValidMappedLevel = tempDimensions.size() > 0;
        try {
            if (this.mappedLevels != null && oneValidMappedLevel && !tableSet.isLoadStarSchema()) {
                oneValidMappedLevel = false;
                for (i = tempDimensions.size() - 1; i >= 0 && !oneValidMappedLevel; --i) {
                    dimension = (OLAPDimension)tempDimensions.get(i);
                    OLAPList dimensionLevels = dimension.getLevels();
                    for (int j = dimensionLevels.size() - 1; j >= 0 && !oneValidMappedLevel; --j) {
                        OLAPLevel level = (OLAPLevel)dimensionLevels.get(j);
                        Column column = (Column)this.mappedLevels.get(level);
                        oneValidMappedLevel = column != null;
                    }
                }
            }
        }
        catch (OLAPException error) {
            oneValidMappedLevel = false;
        }
        return oneValidMappedLevel;
    }

    Map getDrillOrder() throws OLAPException {
        HashMap drillOrder = new HashMap();
        OLAPLevel lagLevel = null;
        int iSize = this.getHierarchies().size();
        for (int i = 0; i < iSize; ++i) {
            OLAPHierarchy hierarchy = (OLAPHierarchy)this.hierarchies.get(i);
            OLAPList hierarchyLevels = hierarchy.getLevels();
            int jSize = hierarchyLevels.size();
            for (int j = 0; j < jSize; ++j) {
                List<OLAPLevel> levelOrder;
                OLAPLevel level = (OLAPLevel)hierarchyLevels.get(j);
                String levelName = level.getName();
                if (!drillOrder.containsKey(levelName)) {
                    levelOrder = new ArrayList();
                    if (j == 0) {
                        levelOrder.add(level);
                    } else {
                        levelOrder.add(lagLevel);
                    }
                    drillOrder.put(levelName, levelOrder);
                } else {
                    levelOrder = (List)drillOrder.get(levelName);
                    if (j == 0) {
                        levelOrder.add(level);
                    } else {
                        levelOrder.add(lagLevel);
                    }
                }
                lagLevel = level;
            }
        }
        return drillOrder;
    }

    public OLAPList getCubeDimensions() throws OLAPException {
        if (this.dimensions == null) {
            this.dimensions = new OLAPList(OLAPDimension.class);
            this.sharedDimensions = new OLAPList(OLAPSharedDimension.class);
            this.getExistingCubeDimensions();
            this.dimensions.allowUndoSetup = false;
            this.sharedDimensions.allowUndoSetup = false;
            AssociationList cubeDimensions = null;
            boolean isMeasure = false;
            if (this.cube != null && this.cube.metadataObject != null) {
                Cube jomaCube = (Cube)this.cube.metadataObject;
                try {
                    cubeDimensions = jomaCube.getDimensions(false);
                    int size = cubeDimensions.size();
                    for (int i = 0; i < size; ++i) {
                        Dimension dimension = (Dimension)cubeDimensions.elementAt(i);
                        String type = dimension.getCMetadataType();
                        isMeasure = dimension.getDimensionType().equals("MEASURES");
                        if (type.equalsIgnoreCase("Dimension") && !isMeasure) {
                            this.dimensions.add(this.createOLAPDimension(dimension));
                            continue;
                        }
                        if (!type.equalsIgnoreCase("SharedDimension")) continue;
                        OLAPSharedDimension olapDim = new OLAPSharedDimension((SharedDimension)dimension, this.cube);
                        this.sharedDimensions.add(olapDim);
                        this.existingCubeSharedDims.put(dimension, olapDim);
                    }
                    this.getHierarchies();
                    this.getLevels();
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
                }
            }
            this.dimensions.allowUndoSetup = true;
            this.sharedDimensions.allowUndoSetup = true;
        }
        return this.dimensions;
    }

    public List getAllCubeDimensions() throws OLAPException {
        ArrayList allDimensions = new ArrayList();
        this.getCubeDimensions();
        this.getSharedDimensions();
        allDimensions.addAll(this.dimensions);
        allDimensions.addAll(this.sharedDimensions);
        return allDimensions;
    }

    public StringBuffer generateCodeDefaultMembers() throws OLAPException {
        StringBuffer defaultMembers = new StringBuffer();
        this.getCubeDimensions();
        int size = this.dimensions.size();
        for (int i = 0; i < size; ++i) {
            OLAPDimension dim = (OLAPDimension)this.dimensions.get(i);
            OLAPList dimHiers = dim.getHierarchies();
            int sizeHiers = dimHiers.size();
            for (int t = 0; t < sizeHiers; ++t) {
                OLAPHierarchy hier = (OLAPHierarchy)dimHiers.get(t);
                String defaultMember = hier.getUserDefaultMember();
                if (defaultMember == null) continue;
                defaultMembers.append("   HIERARCHY ").append(hier.getName());
                defaultMembers.append(ModelUtilities.newline).append("    ");
                defaultMembers.append("     DEFAULT_MEMBER = ").append(Strings.quoteForSAS((String)defaultMember));
                defaultMembers.append(";");
                defaultMembers.append(ModelUtilities.newline);
            }
        }
        return defaultMembers;
    }

    public Map getAllSharedDimensions() throws OLAPException {
        if (this.mapOfSchemas == null) {
            this.mapOfSchemas = new HashMap();
            try {
                ArrayList<OLAPSharedDimension> allSharedDims = null;
                List allOLAPSchemas = ModelUtilities.getOLAPSchemas(this.cube.getObjectStore());
                int size = allOLAPSchemas.size();
                for (int i = 0; i < size; ++i) {
                    OLAPSchema schema = (OLAPSchema)allOLAPSchemas.get(i);
                    allSharedDims = new ArrayList<OLAPSharedDimension>();
                    this.mapOfSchemas.put(schema, allSharedDims);
                    AssociationList listOfDims = schema.getDimensions();
                    int sizeDims = listOfDims.size();
                    for (int t = 0; t < sizeDims; ++t) {
                        SharedDimension dim = (SharedDimension)listOfDims.get(t);
                        if (!this.existingCubeSharedDims.containsKey(dim)) {
                            OLAPSharedDimension newDim = new OLAPSharedDimension(dim, this.cube);
                            allSharedDims.add(newDim);
                            continue;
                        }
                        allSharedDims.add((OLAPSharedDimension)this.existingCubeSharedDims.get(dim));
                    }
                }
                ModelUtilities.sort(allSharedDims);
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        }
        return this.mapOfSchemas;
    }

    Map getExistingCubeDimensions() {
        if (this.existingCubeSharedDims == null) {
            this.existingCubeSharedDims = new HashMap();
        }
        return this.existingCubeSharedDims;
    }

    public OLAPList getSharedDimensions() throws OLAPException {
        try {
            if (this.sharedDimensions == null && this.cube != null) {
                this.sharedDimensions = new OLAPList(OLAPSharedDimension.class);
                this.sharedDimensions.allowUndoSetup = false;
                if (this.cube.metadataObject != null) {
                    Cube jomaCube = (Cube)this.cube.metadataObject;
                    MdObjectStore objectStore = this.cube.getObjectStore();
                    List listOfSharedDims = ModelUtilities.getCMetadataList("SharedDimension", objectStore);
                    int sizeDims = listOfSharedDims.size();
                    for (int t = 0; t < sizeDims; ++t) {
                        this.sharedDimensions.add(new OLAPSharedDimension((SharedDimension)listOfSharedDims.get(t), this.cube));
                    }
                }
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
        this.dimensions.allowUndoSetup = true;
        return this.sharedDimensions;
    }

    public Map getLevels() throws OLAPException {
        if (this.levels == null) {
            if (this.metaLevelLevel == null) {
                this.metaLevelLevel = new HashMap();
            }
            this.levels = new HashMap();
            if (this.levelNames == null) {
                this.levelNames = new ArrayList();
            }
            List allDimensions = this.getAllCubeDimensions();
            int iSize = allDimensions.size();
            for (int i = 0; i < iSize; ++i) {
                OLAPDimension dimension = (OLAPDimension)allDimensions.get(i);
                if (dimension.levels == null) {
                    dimension.levels = new OLAPList(OLAPLevel.class);
                    dimension.levels.setParentObject(dimension);
                }
                dimension.levels.allowUndoSetup = false;
                if (dimension.metadataObject != null && dimension.levels.isEmpty()) {
                    Dimension dimensionObject = (Dimension)dimension.metadataObject;
                    AssociationList dimensionLevels = null;
                    try {
                        dimensionLevels = dimensionObject.getLevels();
                        int size = dimensionLevels.size();
                        for (int t = 0; t < size; ++t) {
                            Level jomaLevel = (Level)dimensionLevels.elementAt(t);
                            OLAPLevel level = dimension.createOLAPLevel(jomaLevel);
                            dimension.levels.add(level);
                            this.metaLevelLevel.put(level.metadataObject, level);
                        }
                    }
                    catch (MdException mdError) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                }
                dimension.levels.allowUndoSetup = true;
            }
        }
        return this.levels;
    }

    public Map getLevels(OLAPSharedDimension dimension) throws OLAPException {
        if (dimension.levels == null) {
            if (this.metaLevelLevel == null) {
                this.metaLevelLevel = new HashMap();
            }
            dimension.levels = new OLAPList(OLAPLevel.class);
            dimension.levels.setParentObject(dimension);
            if (this.levels == null) {
                this.levels = new HashMap();
            }
            if (this.levelNames == null) {
                this.levelNames = new ArrayList();
            }
            dimension.levels.allowUndoSetup = false;
            if (dimension.metadataObject != null) {
                SharedDimension dimensionObject = (SharedDimension)dimension.metadataObject;
                this.existingCubeSharedDims.put(dimensionObject, dimension);
                AssociationList dimensionLevels = null;
                try {
                    dimensionLevels = dimensionObject.getLevels();
                    int size = dimensionLevels.size();
                    for (int t = 0; t < size; ++t) {
                        Level jomaLevel = (Level)dimensionLevels.elementAt(t);
                        OLAPLevel level = dimension.createOLAPLevel(jomaLevel);
                        dimension.levels.add(level);
                        this.metaLevelLevel.put(level.metadataObject, level);
                    }
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
            }
            dimension.levels.allowUndoSetup = true;
        }
        return this.levels;
    }

    public List getLevelNames() {
        return this.levelNames;
    }

    public List getLevelsByColumn(OLAPColumn olapColumn) throws OLAPException {
        this.getLevels();
        List levelsByColumn = (List)this.levels.get(olapColumn);
        return levelsByColumn;
    }

    public OLAPList getHierarchies() throws OLAPException {
        if (this.hierarchies == null) {
            this.hierarchies = new OLAPList(OLAPHierarchy.class);
            this.hierarchies.setModifiable(false);
            this.hierarchies.allowUndoSetup = false;
            List allDimensions = this.getAllCubeDimensions();
            int iSize = allDimensions.size();
            for (int i = 0; i < iSize; ++i) {
                OLAPDimension dimension = (OLAPDimension)allDimensions.get(i);
                if (dimension.hierarchies == null) {
                    dimension.hierarchies = new OLAPList(OLAPHierarchy.class);
                    dimension.hierarchies.setParentObject(dimension);
                }
                dimension.hierarchies.allowUndoSetup = false;
                if (dimension.metadataObject != null && dimension.hierarchies.isEmpty()) {
                    Dimension dimensionObject = (Dimension)dimension.metadataObject;
                    AssociationList dimensionHierarchies = null;
                    try {
                        dimensionHierarchies = dimensionObject.getHierarchies();
                    }
                    catch (MdException mdError) {
                        throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    int size = dimensionHierarchies.size();
                    for (int t = 0; t < size; ++t) {
                        Hierarchy jomahierarchy = (Hierarchy)dimensionHierarchies.elementAt(t);
                        OLAPHierarchy hierarchy = dimension.createOLAPHierarchy(jomahierarchy);
                        this.hierarchies.getTheList().add(hierarchy);
                        dimension.hierarchies.add(hierarchy);
                    }
                }
                dimension.hierarchies.allowUndoSetup = true;
            }
            this.hierarchies.allowUndoSetup = true;
        }
        return this.hierarchies;
    }

    public OLAPList getHierarchies(OLAPSharedDimension dimension) throws OLAPException {
        if (dimension.hierarchies == null) {
            dimension.hierarchies = new OLAPList(OLAPHierarchy.class);
            dimension.hierarchies.setParentObject(dimension);
            if (this.hierarchies == null) {
                this.hierarchies = new OLAPList(OLAPHierarchy.class);
                this.hierarchies.setModifiable(false);
            }
            this.hierarchies.allowUndoSetup = false;
            dimension.hierarchies.allowUndoSetup = false;
            if (dimension.metadataObject != null) {
                Dimension dimensionObject = (Dimension)dimension.metadataObject;
                AssociationList dimensionHierarchies = null;
                try {
                    dimensionHierarchies = dimensionObject.getHierarchies();
                }
                catch (MdException mdError) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                int size = dimensionHierarchies.size();
                for (int t = 0; t < size; ++t) {
                    Hierarchy jomahierarchy = (Hierarchy)dimensionHierarchies.elementAt(t);
                    OLAPHierarchy hierarchy = dimension.createOLAPHierarchy(jomahierarchy);
                    this.hierarchies.getTheList().add(hierarchy);
                    dimension.hierarchies.add(hierarchy);
                }
            }
            dimension.hierarchies.allowUndoSetup = true;
        }
        this.hierarchies.allowUndoSetup = true;
        return this.hierarchies;
    }

    public OLAPHierarchy getHierarchy(String inputName) throws OLAPException {
        OLAPHierarchy nameHierarchy = null;
        if (this.hierarchies == null) {
            this.getHierarchies();
        }
        int i = 0;
        int iSize = this.hierarchies.size();
        while (i < iSize & nameHierarchy == null) {
            OLAPHierarchy hierarchy = (OLAPHierarchy)this.hierarchies.get(i);
            if (hierarchy.getName().equalsIgnoreCase(inputName)) {
                nameHierarchy = hierarchy;
            }
            ++i;
        }
        return nameHierarchy;
    }

    public void UseSharedDimension(OLAPSharedDimension dimension) throws OLAPException {
        this.getHierarchies(dimension);
        this.getLevels(dimension);
        this.getSharedDimensionDeleteList();
        if (dimension.metadataObject != null && dimension.isWasDeleted()) {
            OLAPList dimensionLevels = dimension.getLevels();
            int size = dimensionLevels.size();
            for (int t = 0; t < size; ++t) {
                List<OLAPLevel> listOfLevels;
                OLAPLevel level = (OLAPLevel)dimensionLevels.get(t);
                if (level.metadataObject != null) {
                    this.metaLevelLevel.put(level.metadataObject, level);
                }
                this.getLevelNames().add(level.getName());
                OLAPColumn tempOlapColumn = level.getColumn();
                this.setDimensionChanged(true);
                if (tempOlapColumn != null) {
                    listOfLevels = (ArrayList<OLAPLevel>)this.levels.get(tempOlapColumn);
                    if (listOfLevels != null) {
                        listOfLevels.add(level);
                        continue;
                    }
                    listOfLevels = new ArrayList<OLAPLevel>();
                    listOfLevels.add(level);
                    this.levels.put(tempOlapColumn, listOfLevels);
                    continue;
                }
                listOfLevels = (List)this.levels.get(level.getName());
                if (listOfLevels != null) {
                    listOfLevels.add(level);
                    continue;
                }
                listOfLevels = new ArrayList();
                listOfLevels.add(level);
                this.levels.put(level.getName(), listOfLevels);
            }
            OLAPList hiers = dimension.getHierarchies();
            int size2 = hiers.size();
            for (int t = 0; t < size2; ++t) {
                this.hierarchies.getTheList().add(hiers.get(t));
            }
        }
    }

    public OLAPLevel getLevel(String name) throws OLAPException {
        OLAPLevel returnLevel = null;
        this.getLevels();
        Iterator i = this.levels.values().iterator();
        while (i.hasNext() & returnLevel == null) {
            List listOfLevels = (List)i.next();
            int t = 0;
            int size = listOfLevels.size();
            while (t < size & returnLevel == null) {
                OLAPLevel level = (OLAPLevel)listOfLevels.get(t);
                if (level.getName().equalsIgnoreCase(name)) {
                    returnLevel = level;
                }
                ++t;
            }
        }
        return returnLevel;
    }

    OLAPLevel getLevel(Level inputLevel) throws OLAPException {
        OLAPLevel returnLevel = null;
        this.getLevels();
        Iterator i = this.levels.values().iterator();
        while (i.hasNext() & returnLevel == null) {
            List listOfLevels = (List)i.next();
            int t = 0;
            int size = listOfLevels.size();
            while (t < size & returnLevel == null) {
                OLAPLevel level = (OLAPLevel)listOfLevels.get(t);
                if ((Level)level.metadataObject == inputLevel) {
                    returnLevel = level;
                }
                ++t;
            }
        }
        return returnLevel;
    }

    public String getProcSort(int displaySort_order) {
        String procsort = null;
        procsort = displaySort_order == 0 ? "ASCENDING" : (displaySort_order == 1 ? "DESCENDING" : (displaySort_order == 2 ? "ASCFORMATTED" : (displaySort_order == 3 ? "DESFORMATTED" : (displaySort_order == 4 ? "DSORDER" : "ASCENDING"))));
        return procsort;
    }

    public int getDisplaySort(String procSort_order) {
        int displaySort = 0;
        if (procSort_order.equals("ASCENDING")) {
            displaySort = 0;
        } else if (procSort_order.equals("DESCENDING")) {
            displaySort = 1;
        } else if (procSort_order.equals("ASCFORMATTED")) {
            displaySort = 2;
        } else if (procSort_order.equals("DESFORMATTED")) {
            displaySort = 3;
        } else if (procSort_order.equals("DSORDER")) {
            displaySort = 4;
        }
        return displaySort;
    }

    public List getMapServiceColumns(TableCollection inputTable) throws OLAPException {
        List listOfColumns = null;
        if (inputTable != null) {
            this.setMapServiceColumns(inputTable);
            listOfColumns = (List)this.mapServiceColumns.get(inputTable);
        }
        return listOfColumns;
    }

    public List getMapServers() throws OLAPException {
        if (this.mapServers == null) {
            try {
                OLAPCube olapCube = this.getOwningCube();
                MdObjectStore store = olapCube.getObjectStore();
                int flags = 8588;
                this.mapServers = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, olapCube.getRepositoryFQID(), "ServerComponent", flags, "<XMLSELECT search=\"@ClassIdentifier='04C6FD00-8B79-48ad-8477-7C87E2C5A0E1'\"/><Templates><ServerComponent><DataPackages/></ServerComponent><File><TableCollections/></File><TableCollection><Columns/></TableCollection><Column><Properties/></Column></Templates>");
            }
            catch (MdException oError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), 0);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.mapServers;
    }

    public List getMapServers(OLAPSharedDimension dimension) throws OLAPException {
        if (this.mapServers == null) {
            try {
                MdObjectStore store = dimension.getObjectStore();
                int flags = 8588;
                this.mapServers = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, dimension.getRepositoryFQID(), "ServerComponent", flags, "<XMLSELECT search=\"@ClassIdentifier='04C6FD00-8B79-48ad-8477-7C87E2C5A0E1'\"/><Templates><ServerComponent><DataPackages/></ServerComponent><File><TableCollections/></File><TableCollection><Columns/></TableCollection><Column><Properties/></Column></Templates>");
            }
            catch (MdException oError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), 0);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.mapServers;
    }

    public List getMapServices(ServerComponent server) throws OLAPException {
        List<Object> listOfServices = null;
        try {
            if (this.mapServices == null) {
                this.mapServices = new HashMap();
            }
            if (this.mapServices.containsKey(server)) {
                listOfServices = (List)this.mapServices.get(server);
            } else {
                listOfServices = new ArrayList();
                this.mapServices.put(server, listOfServices);
                AssociationList files = server.getDataPackages();
                for (int i = 0; i < files.size(); ++i) {
                    File physicalFile = (File)files.elementAt(i);
                    AssociationList collections = physicalFile.getTableCollections();
                    for (int j = 0; j < collections.size(); ++j) {
                        listOfServices.add(collections.elementAt(j));
                    }
                }
            }
        }
        catch (MdException e1) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), 0);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return listOfServices;
    }

    public OLAPCube getOwningCube() {
        return this.cube;
    }

    public void setDimensionChanged(boolean didIt) {
        this.dimensionChanged = didIt;
    }

    void setMapServiceColumns(TableCollection inputTable) throws OLAPException {
        if (this.mapServiceColumns == null) {
            this.mapServiceColumns = new HashMap();
        }
        if (inputTable != null && !this.mapServiceColumns.containsKey(inputTable)) {
            try {
                ArrayList<OLAPColumn> listOfColumns = new ArrayList<OLAPColumn>();
                this.mapServiceColumns.put(inputTable, listOfColumns);
                AssociationList columns = inputTable.getColumns();
                int size = columns.size();
                for (int i = 0; i < size; ++i) {
                    Column tableColumn = (Column)columns.get(i);
                    OLAPColumn column = new OLAPColumn(tableColumn);
                    listOfColumns.add(column);
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
    }

    void cleanseTables() throws OLAPException {
        if (this.dimensionTables == null) {
            this.getTables();
        }
        if (this.dimensions == null) {
            this.getCubeDimensions();
        }
        List javaTables = this.dimensionTables.getTheList();
        javaTables.clear();
        for (int i = this.dimensions.size() - 1; i >= 0; --i) {
            OLAPDimension dimension = (OLAPDimension)this.dimensions.get(i);
            DimensionTable table = dimension.getTable();
            if (javaTables.contains(table)) continue;
            javaTables.add(table);
        }
    }

    public StringBuffer generateCode() throws OLAPException {
        StringBuffer saveProcCode;
        OLAPDimension dimension;
        int i;
        StringBuffer allSaveProcCode = new StringBuffer();
        this.getSharedDimensions();
        int size = this.sharedDimensions.size();
        for (i = 0; i < size; ++i) {
            dimension = (OLAPSharedDimension)this.sharedDimensions.get(i);
            saveProcCode = ((OLAPSharedDimension)dimension).generateCode();
            if (i < size - 1) {
                saveProcCode.append(ModelUtilities.newline);
            }
            allSaveProcCode.append(saveProcCode);
        }
        this.getCubeDimensions();
        size = this.dimensions.size();
        for (i = 0; i < size; ++i) {
            dimension = (OLAPDimension)this.dimensions.get(i);
            saveProcCode = dimension.generateCode();
            if (i < size - 1) {
                saveProcCode.append(ModelUtilities.newline);
            }
            allSaveProcCode.append(saveProcCode);
        }
        return allSaveProcCode;
    }

    void mapFactKey(OLAPDimension inputDimension, Column inputColumn) {
        Column mappedColumn;
        if (this.mappedFactKeys == null) {
            this.mappedFactKeys = new HashMap();
        }
        if ((mappedColumn = (Column)this.mappedFactKeys.get(inputDimension)) != null && mappedColumn != inputColumn) {
            TableSet tableSet = this.cube.getTableSet();
            try {
                LoadTable loadTable = tableSet.getLoadTable();
                loadTable.setIsMapChanged(true);
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        this.mappedFactKeys.put(inputDimension, inputColumn);
        this.unmappedFactKeys.getTheList().remove(inputDimension);
    }

    void mapLevel(OLAPLevel inputLevel, Column inputColumn) {
        Column mappedColumn;
        if (this.mappedLevels == null) {
            this.mappedLevels = new HashMap();
        }
        if ((mappedColumn = (Column)this.mappedLevels.get(inputLevel)) != inputColumn) {
            TableSet tableSet = this.cube.getTableSet();
            try {
                LoadTable loadTable = tableSet.getLoadTable();
                loadTable.setIsMapChanged(true);
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        this.mappedLevels.put(inputLevel, inputColumn);
        this.unmappedLevels.getTheList().remove(inputLevel);
    }

    void mapTable(Map mappedTable) throws OLAPException {
        if (this.mappedLevels == null) {
            this.mappedLevels = new HashMap();
        }
        if (this.mappedFactKeys == null) {
            this.mappedFactKeys = new HashMap();
        }
        boolean starSchema = this.cube.getTableSet().isLoadStarSchema();
        List allDimensions = this.getAllCubeDimensions();
        for (int i = allDimensions.size() - 1; i >= 0; --i) {
            OLAPDimension dimension = (OLAPDimension)allDimensions.get(i);
            OLAPList dimensionLevels = dimension.getLevels();
            if (starSchema && !dimension.getTable().isLoadTable()) {
                OLAPColumn dimensionKey;
                Column newFactKey = null;
                OLAPColumn factKey = null;
                if (!dimension.isShared()) {
                    factKey = dimension.getFactKey();
                } else {
                    OLAPSharedDimension sharedDim = (OLAPSharedDimension)dimension;
                    factKey = sharedDim.getSharedDimensionFactKey(this.cube);
                }
                if (factKey == null && (dimensionKey = dimension.getDimensionKey()) != null) {
                    String columnName = dimensionKey.getSASColumnName().toUpperCase();
                    newFactKey = (Column)mappedTable.get(columnName);
                }
                if (factKey != null) {
                    String columnName = factKey.getSASColumnName().toUpperCase();
                    newFactKey = (Column)mappedTable.get(columnName);
                }
                if (newFactKey != null) {
                    this.mappedFactKeys.put(dimension, newFactKey);
                }
            }
            for (int j = dimensionLevels.size() - 1; j >= 0; --j) {
                DimensionTable table = null;
                if (starSchema) {
                    table = dimension.getTable();
                }
                if (starSchema && (!starSchema || table == null || !table.isLoadTable())) continue;
                OLAPLevel level = (OLAPLevel)dimensionLevels.get(j);
                OLAPColumn oldColumn = level.getColumn();
                String requiredColumnName = "";
                requiredColumnName = oldColumn != null ? oldColumn.getSASColumnName().toUpperCase() : level.getName().toUpperCase();
                Column newLevelColumn = (Column)mappedTable.get(requiredColumnName);
                if (newLevelColumn == null) continue;
                this.mappedLevels.put(level, newLevelColumn);
            }
        }
        if (starSchema) {
            this.getUnmappedFactKeys();
        }
        this.getUnmappedLevels();
    }

    public Column getMappedFactKey(OLAPDimension inputDimension) {
        Column mappedColumn = null;
        if (this.mappedFactKeys != null && inputDimension != null) {
            mappedColumn = (Column)this.mappedFactKeys.get(inputDimension);
        }
        return mappedColumn;
    }

    public Column getMappedLevel(OLAPLevel inputLevel) {
        Column mappedColumn = null;
        if (this.mappedLevels != null && inputLevel != null) {
            mappedColumn = (Column)this.mappedLevels.get(inputLevel);
        }
        return mappedColumn;
    }

    StringBuffer getMappedRatio() {
        StringBuffer message = new StringBuffer();
        TableSet tableSet = this.cube.getTableSet();
        boolean starSchema = true;
        try {
            starSchema = tableSet.isLoadStarSchema();
        }
        catch (OLAPException error) {
            starSchema = false;
        }
        StringBuffer factKeyMessage = this.getMappedRatioFactKey();
        if (factKeyMessage.length() > 0) {
            message.append("\n").append(factKeyMessage);
        }
        if (!starSchema) {
            StringBuffer levelMessage = this.getMappedRatioLevel();
            if (levelMessage.length() > 0) {
                levelMessage.append("\n");
            }
            message.append(levelMessage);
        } else if (factKeyMessage.length() > 0) {
            message.append("\n");
        }
        return message;
    }

    private StringBuffer getMappedRatioLevel() {
        int mappedSize;
        int totalSize;
        StringBuffer message = new StringBuffer();
        if (this.mappedLevels != null && (totalSize = (mappedSize = this.mappedLevels.size()) + this.unmappedLevels.size()) > 0) {
            message.append(bundle.formatString("OLAPDimension.MappedLevelRatio.fmt.txt", (Object)String.valueOf(mappedSize), (Object)String.valueOf(totalSize)));
        }
        return message;
    }

    private StringBuffer getMappedRatioFactKey() {
        int mappedSize;
        int totalSize;
        StringBuffer message = new StringBuffer();
        if (this.mappedFactKeys != null && (totalSize = (mappedSize = this.mappedFactKeys.size()) + this.unmappedFactKeys.size()) > 0) {
            message.append(bundle.formatString("OLAPDimension.MappedFactKeyRatio.fmt.txt", (Object)String.valueOf(mappedSize), (Object)String.valueOf(totalSize)));
        }
        return message;
    }

    int getMapTableSize() throws OLAPException {
        TableSet tableSet;
        int size = 0;
        if (this.mappedLevels != null) {
            size += this.mappedLevels.size();
        }
        if (this.mappedFactKeys != null) {
            size += this.mappedFactKeys.size();
        }
        if ((tableSet = this.cube.getTableSet()).isLoadStarSchema()) {
            for (int i = this.dimensions.size() - 1; i >= 0; --i) {
                OLAPDimension dimension = (OLAPDimension)this.dimensions.get(i);
                DimensionTable table = dimension.getTable();
                if (table.isLoadTable()) continue;
                OLAPList dimensionLevels = dimension.getLevels();
                size += dimensionLevels.size();
            }
        }
        return size;
    }

    public int getNumberOfLevels() throws OLAPException {
        this.getLevels();
        int sizeOfLevels = 0;
        for (List listOfLevels : this.levels.values()) {
            sizeOfLevels += listOfLevels.size();
        }
        return sizeOfLevels;
    }

    private void removeUnmappedFactKeyStructure() throws OLAPException {
        if (this.unmappedFactKeys != null && !this.unmappedFactKeys.isEmpty()) {
            List messageList = this.cube.getCubeMessage();
            AggregationSet aggregationSet = this.cube.getAggregationSet();
            aggregationSet.setResetLevels(true);
            for (int i = this.unmappedFactKeys.size() - 1; i >= 0; --i) {
                OLAPDimension dimension = (OLAPDimension)this.unmappedFactKeys.get(i);
                messageList.add(bundle.formatString("OLAPDimension.DimensionTable.Removed.fmt.txt", (Object)dimension.getName()));
                if (!dimension.isShared()) {
                    dimension.delete();
                } else {
                    OLAPSharedDimension sharedDim = (OLAPSharedDimension)dimension;
                    sharedDim.deleteFromCube();
                    sharedDim.setFactKey(null);
                }
                this.unmappedFactKeys.getTheList().remove(dimension);
            }
            messageList.add(bundle.getString("DimensionSet.Reset.Aggregations.txt"));
            aggregationSet.resetLevels();
        }
    }

    private void removeUnmappedLevelStructure() throws OLAPException {
        if (this.unmappedLevels != null && !this.unmappedLevels.isEmpty()) {
            List messageList = this.cube.getCubeMessage();
            AggregationSet aggregationSet = this.cube.getAggregationSet();
            aggregationSet.setResetLevels(true);
            TableSet tableSet = this.cube.getTableSet();
            LoadTable loadTable = tableSet.getLoadTable();
            PhysicalTable mappedTable = loadTable.getMappedTable();
            for (int i = this.unmappedLevels.size() - 1; i >= 0; --i) {
                OLAPLevel level = (OLAPLevel)this.unmappedLevels.get(i);
                OLAPDimension dimension = level.getDimension();
                try {
                    messageList.add(bundle.formatString("OLAPLevel.LevelRemoved.fmt.txt", (Object)level.getName(), (Object)mappedTable.getName(), (Object)dimension.getName()));
                }
                catch (RemoteException e) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), e, 12);
                }
                OLAPList dimensionLevels = dimension.getLevels();
                dimensionLevels.remove(level);
                if (dimension.getLevels().isEmpty()) {
                    messageList.add(bundle.formatString("OLAPDimension.DimensionRemoved.fmt.txt", (Object)dimension.getName()));
                    this.dimensions.remove(dimension);
                } else {
                    OLAPList dimensionHierarchies = dimension.getHierarchies();
                    for (int j = dimensionHierarchies.size() - 1; j >= 0; --j) {
                        OLAPHierarchy hierarchy = (OLAPHierarchy)dimensionHierarchies.get(j);
                        OLAPList hierarchyLevels = hierarchy.getLevels();
                        hierarchyLevels.getTheList().remove(level);
                        if (!hierarchyLevels.isEmpty()) continue;
                        messageList.add(bundle.formatString("OLAPHierarchy.HierarchyRemoved.fmt.txt", (Object)hierarchy.getName(), (Object)dimension.getName()));
                        dimensionHierarchies.getTheList().remove(hierarchy);
                        if (this.hierarchyDeleteList == null) {
                            this.getHierarchyDeleteList();
                        }
                        if (this.hierarchyDeleteList.indexOf(hierarchy) >= 0) continue;
                        this.hierarchyDeleteList.add(hierarchy);
                    }
                }
                this.unmappedLevels.getTheList().remove(level);
            }
            messageList.add(bundle.getString("DimensionSet.Reset.Aggregations.txt"));
            aggregationSet.resetLevels();
        }
    }

    void removeUnmappedStructure() throws OLAPException {
        this.removeUnmappedLevelStructure();
        this.removeUnmappedFactKeyStructure();
    }

    void resetDimensionKeys(LoadTable loadTable, PhysicalTable inputTable) throws OLAPException {
        TableSet tableSet = this.cube.getTableSet();
        if (tableSet.isLoadStarSchema()) {
            for (int i = this.dimensions.size() - 1; i >= 0; --i) {
                OLAPDimension dimension = (OLAPDimension)this.dimensions.get(i);
                dimension.resetKeyColumns(loadTable, inputTable);
            }
        }
    }

    public void reset() throws OLAPException {
        OLAPDimension dimension;
        int i;
        if (this.dimensions != null) {
            for (i = this.dimensions.size() - 1; i >= 0; --i) {
                dimension = (OLAPDimension)this.dimensions.get(i);
                dimension.delete();
            }
            this.dimensions.getTheList().clear();
        }
        if (this.sharedDimensions != null) {
            for (i = this.sharedDimensions.size() - 1; i >= 0; --i) {
                dimension = (OLAPSharedDimension)this.sharedDimensions.get(i);
                if (((OLAPSharedDimension)dimension).metadataObject == null) continue;
                this.getSharedDimensionDeleteList().add(dimension);
            }
            this.sharedDimensions.getTheList().clear();
        }
        if (this.dimensionTables != null) {
            this.dimensionTables.getTheList().clear();
        }
        if (this.hierarchies != null) {
            this.hierarchies.getTheList().clear();
        }
        if (this.levels != null) {
            this.levels.clear();
        }
        if (this.metaLevelLevel != null) {
            this.metaLevelLevel.clear();
        }
        if (this.levelNames != null) {
            this.levelNames.clear();
        }
    }

    public void resetSharedDimension(OLAPSharedDimension sharedDim) throws OLAPException {
        this.getLevels(sharedDim);
        this.getHierarchies(sharedDim);
        if (sharedDim.levels != null) {
            for (int i = sharedDim.levels.size() - 1; i >= 0; --i) {
                OLAPLevel level = (OLAPLevel)sharedDim.levels.get(i);
                level.delete();
            }
            sharedDim.levels.getTheList().clear();
        }
        if (sharedDim.hierarchies != null) {
            sharedDim.hierarchies.getTheList().clear();
        }
        if (this.hierarchies != null) {
            this.hierarchies.getTheList().clear();
        }
        sharedDim.setDefault(null);
        if (this.levels != null) {
            this.levels.clear();
        }
        if (this.metaLevelLevel != null) {
            this.metaLevelLevel.clear();
        }
        if (this.levelNames != null) {
            this.levelNames.clear();
        }
    }

    void setMapToStructure() throws OLAPException {
        OLAPColumn olapColumn;
        Column jomaColumn;
        TableSet tableSet = this.cube.getTableSet();
        LoadTable loadTable = tableSet.getLoadTable();
        for (int i = this.dimensions.size() - 1; i >= 0; --i) {
            OLAPDimension dimension = (OLAPDimension)this.dimensions.get(i);
            DimensionTable table = dimension.getTable();
            if (table.isLoadTable()) {
                table.setSources(loadTable.getTable());
            }
            if (this.mappedFactKeys != null && !this.mappedFactKeys.isEmpty() && (jomaColumn = (Column)this.mappedFactKeys.get(dimension)) != null) {
                olapColumn = loadTable.getColumn(jomaColumn);
                dimension.setFactKey(olapColumn);
            }
            if (this.mappedLevels == null) continue;
            OLAPList dimensionLevels = dimension.getLevels();
            for (int j = dimensionLevels.size() - 1; j >= 0; --j) {
                OLAPLevel level = (OLAPLevel)dimensionLevels.get(j);
                Column jomaColumn2 = (Column)this.mappedLevels.get(level);
                if (jomaColumn2 == null) continue;
                OLAPColumn olapColumn2 = loadTable.getColumn(jomaColumn2);
                level.setColumn(olapColumn2);
            }
        }
        for (int t = this.sharedDimensions.size() - 1; t >= 0; --t) {
            OLAPSharedDimension sharedDimension = (OLAPSharedDimension)this.sharedDimensions.get(t);
            SharedDimensionTable sharedTable = sharedDimension.getSharedDimensionTable();
            if (this.mappedFactKeys == null || this.mappedFactKeys.isEmpty() || (jomaColumn = (Column)this.mappedFactKeys.get(sharedDimension)) == null) continue;
            olapColumn = loadTable.getColumn(jomaColumn);
            sharedDimension.setFactKey(olapColumn);
        }
        if (this.mappedLevels != null) {
            this.mappedLevels.clear();
            this.mappedLevels = null;
        }
        if (this.unmappedLevels != null) {
            this.unmappedLevels.getTheList().clear();
            this.unmappedLevels = null;
        }
        if (this.mappedFactKeys != null) {
            this.mappedFactKeys.clear();
            this.mappedFactKeys = null;
        }
        if (this.unmappedFactKeys != null) {
            this.unmappedFactKeys.getTheList().clear();
            this.unmappedFactKeys = null;
        }
    }

    public void updateMetadata() throws OLAPException {
        try {
            int i;
            ArrayList<ClassifierMap> remainingClassifierMaps = new ArrayList<ClassifierMap>();
            this.getCubeDimensions();
            int size = this.dimensions.size();
            for (i = 0; i < size; ++i) {
                ClassifierMap classifierMap;
                OLAPDimension dimension = (OLAPDimension)this.dimensions.get(i);
                dimension.updateDimensionMetadata();
                DimensionTable table = dimension.getTable();
                if (table != null && (classifierMap = table.getClassifierMap()) != null && remainingClassifierMaps.indexOf(classifierMap) < 0) {
                    remainingClassifierMaps.add(classifierMap);
                }
                OLAPList dimensionLevels = dimension.getLevels();
                int sizeLevels = dimensionLevels.size();
                for (int t = 0; t < sizeLevels; ++t) {
                    OLAPLevel level = (OLAPLevel)dimensionLevels.get(t);
                    level.updateLevelMetadata();
                }
                OLAPList olapHierarchies = dimension.getHierarchies();
                int sizeHier = olapHierarchies.size();
                for (int h = 0; h < sizeHier; ++h) {
                    OLAPHierarchy hier = (OLAPHierarchy)olapHierarchies.get(h);
                    if (!hier.isMetadataUpdated() && !hier.isLevelsUpdated()) continue;
                    hier.updateHierarchyMetadata();
                }
                if (olapHierarchies.size() <= 1) continue;
                Hierarchy defaultHierarchy = (Hierarchy)dimension.getDefault().metadataObject;
                Dimension jomaDimension = (Dimension)dimension.metadataObject;
                AssociationList listOfHierarchies = jomaDimension.getHierarchies(false);
                int whereIsHierarchy = listOfHierarchies.indexOf((Object)defaultHierarchy);
                if (whereIsHierarchy <= 0) continue;
                listOfHierarchies.remove(whereIsHierarchy);
                listOfHierarchies.add(0, (Object)defaultHierarchy);
            }
            if (this.dimensionDeleteList != null) {
                size = this.dimensionDeleteList.size();
                for (i = 0; i < size; ++i) {
                    OLAPDimension olapDimension = (OLAPDimension)this.dimensionDeleteList.get(i);
                    Dimension jomaDimension = (Dimension)olapDimension.metadataObject;
                    MetadataTemplate.deleteMetadata(this.cube.getObjectStore(), (CMetadata)jomaDimension, "", "");
                }
            }
            if (this.levelDeleteList != null) {
                size = this.levelDeleteList.size();
                for (i = 0; i < size; ++i) {
                    OLAPLevel olapLevel = (OLAPLevel)this.levelDeleteList.get(i);
                    Level jomaLevel = (Level)olapLevel.metadataObject;
                    MetadataTemplate.deleteMetadata(this.cube.getObjectStore(), (CMetadata)jomaLevel, "", "");
                }
            }
            if (this.hierarchyDeleteList != null) {
                size = this.hierarchyDeleteList.size();
                for (i = 0; i < size; ++i) {
                    OLAPHierarchy olapHierarchy = (OLAPHierarchy)this.hierarchyDeleteList.get(i);
                    Hierarchy jomaHierarchy = (Hierarchy)olapHierarchy.metadataObject;
                    MetadataTemplate.deleteMetadata(this.cube.getObjectStore(), (CMetadata)jomaHierarchy, "", "");
                }
            }
            TableSet tableSet = this.cube.getTableSet();
            List classifierMaps = tableSet.getClassifierMaps();
            for (int i2 = classifierMaps.size() - 1; i2 >= 0; --i2) {
                ClassifierMap classifierMap = (ClassifierMap)classifierMaps.get(i2);
                if (remainingClassifierMaps.indexOf(classifierMap) >= 0) continue;
                String transformRole = classifierMap.getTransformRole();
                PhysicalTable dimensionTable = null;
                if (!transformRole.equalsIgnoreCase("STARDIM")) continue;
                AssociationList transformSources = classifierMap.getTransformationSources(false);
                if (!transformSources.isEmpty()) {
                    dimensionTable = (PhysicalTable)transformSources.elementAt(0);
                    DimensionTable table = tableSet.getDimensionTable(dimensionTable);
                    this.getTables().remove(table);
                }
                MetadataTemplate.deleteMetadata(this.cube.getObjectStore(), (CMetadata)classifierMap, "<Templates><SourceCode/><FeatureMaps/></Templates>", "");
            }
            this.updateSharedDimensionCubeMetadata();
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    public void updateSharedDimensionCubeMetadata() throws OLAPException {
        int i;
        int size;
        this.getSharedDimensions();
        if (!this.sharedDimensions.isEmpty()) {
            size = this.sharedDimensions.size();
            for (i = 0; i < size; ++i) {
                OLAPSharedDimension dimension = (OLAPSharedDimension)this.sharedDimensions.get(i);
                dimension.updateCubeMetadata();
            }
        }
        if (this.sharedDimensionDeleteList != null) {
            size = this.sharedDimensionDeleteList.size();
            for (i = 0; i < size; ++i) {
                OLAPSharedDimension olapDimension = (OLAPSharedDimension)this.sharedDimensionDeleteList.get(i);
                olapDimension.removeCubeMetadata();
            }
        }
    }

    public void verifyDimensions() throws OLAPException {
        List allDims = this.getAllCubeDimensions();
        if (allDims.isEmpty()) {
            throw new OLAPException(bundle.getString("DimensionSet.NoDimError.txt"), 0);
        }
    }

    public void verifyDimensionTableSelected() throws OLAPException {
        if (this.dimensionTables == null) {
            throw new OLAPException(bundle.getString("DimensionSet.DimensionTables.NoTableError.txt"), 0);
        }
        if (this.dimensionTables.isEmpty()) {
            throw new OLAPException(bundle.getString("DimensionSet.DimensionTables.NoTableError.txt"), 0);
        }
    }

    public void verifyMaximumLevelsPerCube() throws OLAPException {
        this.getLevels();
        int sizeOfLevels = this.getNumberOfLevels();
        if (sizeOfLevels + 1 > 256) {
            throw new OLAPException(bundle.getString("OLAPLevel.TooManyLevelsPerCube.txt"), 0);
        }
    }

    public void verifyMaximumDimensionsPerCube() throws OLAPException {
        List allDimensions = this.getAllCubeDimensions();
        if (allDimensions.size() + 1 > 128) {
            throw new OLAPException(bundle.getString("OLAPDimension.TooManyDimensionsPerCube.txt"), 0);
        }
    }

    public void verifyMaximumHierarchiesPerCube() throws OLAPException {
        this.getHierarchies();
        if (this.hierarchies.size() + 1 > 128) {
            throw new OLAPException(bundle.getString("OLAPHierarchy.TooManyHierarchiesPerCube.txt"), 0);
        }
    }

    public StringBuffer verifyMetadata() throws OLAPException {
        StringBuffer dimensionVerifyMessage = new StringBuffer();
        this.getCubeDimensions();
        OLAPDimension geoDimension = null;
        List allDimensions = this.getAllCubeDimensions();
        if (allDimensions.size() == 0) {
            dimensionVerifyMessage.append(bundle.getString("DimensionSet.NoDimensions.txt"));
        } else {
            String message;
            for (int i = allDimensions.size() - 1; i >= 0; --i) {
                OLAPDimension dimension = (OLAPDimension)allDimensions.get(i);
                if (dimension.isGeography()) {
                    geoDimension = dimension;
                }
                StringBuffer dimensionMessage = null;
                dimensionMessage = dimension.isShared() ? ((OLAPSharedDimension)dimension).verifyMetadata() : dimension.verifyMetadata();
                if (ModelUtilities.isBlank(dimensionMessage.toString())) continue;
                dimensionVerifyMessage.append(dimensionMessage);
            }
            this.getLevels();
            if (this.getNumberOfLevels() == 0) {
                dimensionVerifyMessage.append(bundle.getString("DimensionSet.NoLevels.txt"));
            }
            ArrayList<OLAPLevel> deletedLevels = new ArrayList<OLAPLevel>();
            Object[] allColumnLevels = this.levels.values().toArray();
            ArrayList notSortedLevels = new ArrayList();
            int size = allColumnLevels.length;
            for (int i = 0; i < size; ++i) {
                List newList = (List)allColumnLevels[i];
                int tsize = newList.size();
                for (int t = 0; t < tsize; ++t) {
                    notSortedLevels.add(newList.get(t));
                }
            }
            Object[] allLevels = notSortedLevels.toArray();
            Arrays.sort(allLevels);
            for (int i = allLevels.length - 1; i >= 0; --i) {
                OLAPLevel level = (OLAPLevel)allLevels[i];
                StringBuffer levelMessage = null;
                if (level.getDimension().isShared() || ModelUtilities.isBlank((levelMessage = level.verifyMetadata()).toString())) continue;
                dimensionVerifyMessage.append(levelMessage);
                deletedLevels.add(level);
            }
            if (geoDimension != null && !ModelUtilities.isBlank(message = geoDimension.verifyMapLayersExist())) {
                dimensionVerifyMessage.append(message);
            }
            if (this.resetAggregations) {
                dimensionVerifyMessage.append(bundle.getString("DimensionSet.Reset.Aggregations.txt"));
                AggregationSet aggregationSet = this.cube.getAggregationSet();
                aggregationSet.setResetLevels(true);
                aggregationSet.resetLevels();
            }
            if (this.hasDimensionsChanged()) {
                MeasureSet measureSet = this.getOwningCube().getMeasureSet();
                measureSet.synchNuniqueLevel();
                measureSet.synchNuniqueHierarchy();
            }
        }
        return dimensionVerifyMessage;
    }

    public void verifyLevelNameUnique(OLAPLevel inLevel) throws OLAPException {
        if (inLevel == null) {
            throw new IllegalStateException("The level parameter cannot be null.");
        }
        List listOfDimensions = this.getAllCubeDimensions();
        ArrayList listOfAllLevels = new ArrayList();
        String checkLevelName = inLevel.getName();
        int sizeDim = listOfDimensions.size();
        for (int t = 0; t < sizeDim; ++t) {
            OLAPDimension dimension = (OLAPDimension)listOfDimensions.get(t);
            OLAPList listOfDimLevels = dimension.getLevels();
            int size = listOfDimLevels.size();
            for (int i = 0; i < size; ++i) {
                listOfAllLevels.add(listOfDimLevels.get(i));
            }
        }
        int size = listOfAllLevels.size();
        for (int i = 0; i < size; ++i) {
            String nameOfLevel;
            OLAPLevel level = (OLAPLevel)listOfAllLevels.get(i);
            if (inLevel.equals(level) || !(nameOfLevel = level.getName()).equalsIgnoreCase(checkLevelName)) continue;
            throw new OLAPException(bundle.formatString("OLAPLevel.DuplicateLevelName.txt", (Object)nameOfLevel), 0);
        }
    }
}

