/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CalculatedMeasure;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.GlobalFormula;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class DefinedMemberSet {
    private static WAdminResource bundle = new WAdminResource(DefinedMemberSet.class);
    private List deleteList;
    private OLAPCube owningCube;
    private OLAPList definedMembers;
    private OLAPList calculatedMembers;
    private OLAPList calculatedMeasures;
    private OLAPList namedSets;
    private MeasureSet measureSet;

    public DefinedMemberSet(OLAPCube inputOwningCube) {
        this.owningCube = inputOwningCube;
    }

    public OLAPDefinedMember createOLAPDefinedMember() throws OLAPException {
        OLAPDefinedMember newMember = new OLAPDefinedMember(this);
        this.getDefinedMembers().add(newMember);
        return newMember;
    }

    private OLAPDefinedMember createOLAPDefinedMember(CalculatedMeasure measure) {
        return new OLAPDefinedMember(measure, this);
    }

    public OLAPDefinedMember createOLAPDefinedMember(GlobalFormula formula) {
        return new OLAPDefinedMember(formula, this);
    }

    public OLAPDefinedMember createOLAPDefinedMember(TextStore inStore) {
        return new OLAPDefinedMember(inStore, this);
    }

    public void delete(OLAPDefinedMember memberToDelete) throws OLAPException {
        if (memberToDelete.metadataObject != null) {
            this.getDeleteList().add(memberToDelete.metadataObject);
        }
        if (this.getDefinedMembers().contains(memberToDelete)) {
            this.definedMembers.remove(memberToDelete);
        }
    }

    public StringBuffer generateCode() throws OLAPException {
        StringBuffer alldefineMemberStatement = new StringBuffer();
        this.getDefinedMembers();
        int size = this.definedMembers.size();
        for (int i = 0; i < size; ++i) {
            OLAPDefinedMember member = (OLAPDefinedMember)this.definedMembers.get(i);
            alldefineMemberStatement.append(member.generateCode());
            alldefineMemberStatement.append(ModelUtilities.newline).append(ModelUtilities.newline);
        }
        return alldefineMemberStatement;
    }

    public OLAPList getCalculatedMeasures() throws OLAPException {
        if (this.calculatedMeasures == null) {
            this.calculatedMeasures = new OLAPList(OLAPDefinedMember.class);
            this.calculatedMeasures.setModifiable(false);
            this.getDefinedMembers();
            int size = this.definedMembers.size();
            for (int i = 0; i < size; ++i) {
                OLAPDefinedMember member = (OLAPDefinedMember)this.definedMembers.get(i);
                if (!member.getType().equals("Calculated Measure")) continue;
                this.calculatedMeasures.getTheList().add(member);
            }
        }
        return this.calculatedMeasures;
    }

    public OLAPList getCalculatedMembers() throws OLAPException {
        if (this.calculatedMembers == null) {
            this.calculatedMembers = new OLAPList(OLAPDefinedMember.class);
            this.calculatedMembers.setModifiable(false);
            this.getDefinedMembers();
            int size = this.definedMembers.size();
            for (int i = 0; i < size; ++i) {
                OLAPDefinedMember member = (OLAPDefinedMember)this.definedMembers.get(i);
                String type = member.getType();
                if (!type.equals("Calculated Measure") && !type.equals("Calculated Member")) continue;
                this.calculatedMembers.getTheList().add(member);
            }
        }
        return this.calculatedMembers;
    }

    public OLAPList getCalculatedMembersByDimension(OLAPDimension dimension) throws OLAPException {
        if (dimension == null) {
            return null;
        }
        OLAPList list = new OLAPList(OLAPDefinedMember.class);
        this.getCalculatedMembers();
        for (int i = 0; i < this.calculatedMembers.size(); ++i) {
            OLAPDefinedMember member = (OLAPDefinedMember)this.calculatedMembers.get(i);
            if (!dimension.equals(member.getDimension())) continue;
            list.add(member);
        }
        return list;
    }

    public OLAPDefinedMember getDefinedMember(String name) throws OLAPException {
        OLAPDefinedMember member = null;
        this.getDefinedMembers();
        int size = this.definedMembers.size();
        for (int i = 0; i < size && member == null; ++i) {
            member = (OLAPDefinedMember)this.definedMembers.get(i);
            if (member.getName().equals(name)) continue;
            member = null;
        }
        return member;
    }

    public OLAPList getDefinedMembers() throws OLAPException {
        if (this.definedMembers == null) {
            this.definedMembers = new OLAPList(OLAPDefinedMember.class);
            try {
                if (this.owningCube.metadataObject != null) {
                    Cube jomaCube = (Cube)this.owningCube.metadataObject;
                    AssociationList formulas = jomaCube.getFormulas(false);
                    int size = formulas.size();
                    for (int i = 0; i < size; ++i) {
                        GlobalFormula formula = (GlobalFormula)formulas.get(i);
                        this.definedMembers.getTheList().add(this.createOLAPDefinedMember(formula));
                    }
                    AssociationList measures = jomaCube.getMeasures(false);
                    int size2 = measures.size();
                    for (int i = 0; i < size2; ++i) {
                        Object measure = measures.get(i);
                        if (!(measure instanceof CalculatedMeasure)) continue;
                        this.definedMembers.getTheList().add(this.createOLAPDefinedMember((CalculatedMeasure)measure));
                    }
                    AssociationList jomaNotes = jomaCube.getNotes(false);
                    int size3 = jomaNotes.size();
                    for (int i = 0; i < size3; ++i) {
                        TextStore store = (TextStore)jomaNotes.elementAt(i);
                        String role = store.getTextRole();
                        if (!role.equals("Calculated Member") && !role.equals("Named Set")) continue;
                        this.definedMembers.getTheList().add(this.createOLAPDefinedMember(store));
                    }
                }
            }
            catch (MdException mdError) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return this.definedMembers;
    }

    List getDeleteList() {
        if (this.deleteList == null) {
            this.deleteList = new ArrayList();
        }
        return this.deleteList;
    }

    public String getMeasuresDimensionName() {
        String dimName = "";
        try {
            this.measureSet = this.owningCube.getMeasureSet();
            dimName = this.measureSet.getMeasuresDimensionName();
        }
        catch (OLAPException e) {
            dimName = "Measures";
        }
        return dimName;
    }

    public OLAPList getNamedSets() throws OLAPException {
        if (this.namedSets == null) {
            this.namedSets = new OLAPList(OLAPDefinedMember.class);
            this.namedSets.setModifiable(false);
            this.getDefinedMembers();
            int size = this.definedMembers.size();
            for (int i = 0; i < size; ++i) {
                OLAPDefinedMember member = (OLAPDefinedMember)this.definedMembers.get(i);
                if (!member.getType().equals("Named Set")) continue;
                this.namedSets.getTheList().add(member);
            }
        }
        return this.namedSets;
    }

    public OLAPCube getOwningCube() {
        return this.owningCube;
    }

    public void reset() throws OLAPException {
        this.getDefinedMembers();
        this.getDeleteList();
        int size = this.definedMembers.size();
        for (int i = 0; i < size; ++i) {
            OLAPDefinedMember member = (OLAPDefinedMember)this.definedMembers.get(i);
            if (member.isNewObject()) continue;
            this.deleteList.add(member.metadataObject);
        }
        this.definedMembers.clear();
        if (this.calculatedMeasures != null) {
            this.calculatedMeasures.getTheList().clear();
        }
        if (this.calculatedMembers != null) {
            this.calculatedMembers.getTheList().clear();
        }
        if (this.namedSets != null) {
            this.namedSets.getTheList().clear();
        }
    }

    void updateMetadata() throws OLAPException {
        int i;
        this.getDefinedMembers();
        int size = this.definedMembers.size();
        for (i = 0; i < size; ++i) {
            OLAPDefinedMember member = (OLAPDefinedMember)this.definedMembers.get(i);
            if (!member.isMetadataUpdated()) continue;
            member.updateMetadata();
        }
        this.getDeleteList();
        try {
            for (i = this.deleteList.size() - 1; i >= 0; --i) {
                Root metadataObject = (Root)this.deleteList.get(i);
                this.deleteList.remove(metadataObject);
                metadataObject.delete();
            }
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    void verifyUniqueName(OLAPDefinedMember member) throws OLAPException {
        block5: {
            block6: {
                String membername;
                block4: {
                    int i;
                    membername = member.getName().trim();
                    if (!member.getType().equals("Calculated Measure")) break block4;
                    this.measureSet = this.owningCube.getMeasureSet();
                    OLAPList measures = this.measureSet.getMeasures();
                    int size = measures.size();
                    for (i = 0; i < size; ++i) {
                        OLAPMeasure measure = (OLAPMeasure)measures.get(i);
                        if (!measure.getName().trim().equalsIgnoreCase(membername)) continue;
                        throw new OLAPException(bundle.getString("OLAPDefinedMember.DuplicateName.txt"), 0);
                    }
                    this.getCalculatedMeasures();
                    size = this.calculatedMeasures.size();
                    for (i = 0; i < size; ++i) {
                        OLAPDefinedMember calcMeasure = (OLAPDefinedMember)this.calculatedMeasures.get(i);
                        if (calcMeasure.equals(member) || !calcMeasure.getName().trim().equalsIgnoreCase(membername)) continue;
                        throw new OLAPException(bundle.getString("OLAPDefinedMember.DuplicateName.txt"), 0);
                    }
                    break block5;
                }
                if (!member.getType().equals("Named Set")) break block6;
                this.getNamedSets();
                int size = this.namedSets.size();
                for (int i = 0; i < size; ++i) {
                    OLAPDefinedMember set = (OLAPDefinedMember)this.namedSets.get(i);
                    if (set.equals(member) || !set.getName().trim().equalsIgnoreCase(membername)) continue;
                    throw new OLAPException(bundle.getString("OLAPDefinedMember.DuplicateName.txt"), 0);
                }
                break block5;
            }
            if (!member.getType().equals("Calculated Member")) break block5;
            this.getCalculatedMembers();
            int size = this.calculatedMembers.size();
            for (int i = 0; i < size; ++i) {
                OLAPDefinedMember calcmember = (OLAPDefinedMember)this.calculatedMembers.get(i);
                if (calcmember.equals(member) || !calcmember.getUniqueName().trim().equalsIgnoreCase(member.getUniqueName())) continue;
                throw new OLAPException(bundle.getString("OLAPDefinedMember.DuplicateName.txt"), 0);
            }
        }
    }

    public void synchDefinedMembers() throws OLAPException {
        OLAPList calcMbrs = this.getCalculatedMembers();
        OLAPList allHierarchies = this.owningCube.getDimensionSet().getHierarchies();
        for (int i = calcMbrs.size() - 1; i >= 0; --i) {
            OLAPDefinedMember mbr = (OLAPDefinedMember)calcMbrs.get(i);
            OLAPHierarchy owningHier = mbr.getParentHierarchy();
            if (owningHier == null || allHierarchies.contains(owningHier)) continue;
            mbr.delete();
        }
    }
}

