/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.codegen.ClassifierMapUtilityInterface;
import com.sas.codegen.CodegenRequest;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.AddDataModel;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.workspace.WAdminResource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;

public class CodeGeneration
implements ClassifierMapUtilityInterface {
    private static WAdminResource bundle = new WAdminResource(CodeGeneration.class);
    public static final int APPEND = 1;
    public static final int NOAPPEND = 0;

    public void executeUtility(CodegenRequest codegenRequest, ClassifierMap classifierMap) throws MdException, RemoteException {
        try {
            Cube cube = (Cube)classifierMap.getClassifierTargets(true).elementAt(0);
            OLAPCube olapCube = new OLAPCube(cube);
            int errorLevel = olapCube.getErrorLevel();
            String message = "";
            if (errorLevel == 1 || errorLevel == 2) {
                errorLevel = 0;
                message = olapCube.getCubeVerifyMessage().toString();
            } else {
                errorLevel = 2;
                message = bundle.formatString("OLAPCube.MetadataChanges.fmt.txt", (Object)cube.getName());
            }
            if (!ModelUtilities.isBlank(message)) {
                throw new MdException(message);
            }
            StringBuffer procOlap = olapCube.generateCodeExecuteUtility();
            codegenRequest.addSourceCode(procOlap.toString());
        }
        catch (OLAPException olapError) {
            String message = olapError.getLocalizedMessage();
            Throwable root = olapError.getCause();
            if (root instanceof MdException) {
                message = root.getLocalizedMessage();
            }
            throw new MdException(message);
        }
    }

    public static boolean saveFullProcCode(OLAPCube inputCube, String inputPath, int toAppend) throws OLAPException {
        OLAPCube olapCube = inputCube;
        try {
            File storeFileTo = new File(inputPath);
            FileWriter fileWriter = null;
            fileWriter = toAppend == 1 ? new FileWriter(storeFileTo, true) : new FileWriter(storeFileTo);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.newLine();
            writer.newLine();
            writer.write(ModelUtilities.generateBlockCommentStart(bundle.getString("CodeGeneration.DeleteCubeComment.txt")));
            writer.write(olapCube.generateCodeDelete(true).toString());
            writer.write(ModelUtilities.generateBlockCommentEnd());
            writer.write(olapCube.generateCodeLongForm().toString());
            writer.flush();
            writer.close();
            fileWriter.close();
        }
        catch (IOException error) {
            throw new OLAPException(error.getLocalizedMessage(), 0);
        }
        return true;
    }

    public static boolean saveShortProcCode(OLAPCube inputCube, String inputPath, int toAppend) throws OLAPException {
        OLAPCube olapCube = inputCube;
        try {
            File storeFileTo = new File(inputPath);
            FileWriter fileWriter = null;
            fileWriter = toAppend == 1 ? new FileWriter(storeFileTo, true) : new FileWriter(storeFileTo);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.write(ModelUtilities.newline);
            writer.write(ModelUtilities.newline);
            writer.write(ModelUtilities.generateBlockCommentStart(bundle.getString("CodeGeneration.DeleteCubeComment.txt")));
            writer.write(olapCube.generateCodeDeletePhysical(true).toString());
            writer.write(ModelUtilities.generateBlockCommentEnd());
            int flags = 0;
            flags = OLAPCube.setCodegenFlag(flags, 1, true);
            flags = OLAPCube.setCodegenFlag(flags, 2, true);
            flags = OLAPCube.setCodegenFlag(flags, 16, true);
            writer.write(olapCube.generateCodeShortForm(flags).toString());
            writer.flush();
            writer.close();
            fileWriter.close();
        }
        catch (IOException error) {
            throw new OLAPException(error.getLocalizedMessage(), 0);
        }
        return true;
    }

    public static boolean saveFullProcCodeSharedDim(OLAPSharedDimension inputDim, String inputPath, int toAppend) throws OLAPException {
        OLAPSharedDimension olapDim = inputDim;
        try {
            File storeFileTo = new File(inputPath);
            FileWriter fileWriter = null;
            fileWriter = toAppend == 1 ? new FileWriter(storeFileTo, true) : new FileWriter(storeFileTo);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.newLine();
            writer.newLine();
            writer.write(ModelUtilities.generateBlockCommentStart(bundle.getString("CodeGeneration.DeleteSharedDimensionComment.txt")));
            writer.write(olapDim.generateCodeDelete(true).toString());
            writer.write(ModelUtilities.generateBlockCommentEnd());
            writer.write(olapDim.generateCodeLongForm().toString());
            writer.flush();
            writer.close();
            fileWriter.close();
        }
        catch (IOException error) {
            throw new OLAPException(error.getLocalizedMessage(), 0);
        }
        return true;
    }

    public static boolean saveShortProcCodeSharedDim(OLAPSharedDimension inputDim, String inputPath, int toAppend) throws OLAPException {
        OLAPSharedDimension olapDim = inputDim;
        try {
            File storeFileTo = new File(inputPath);
            FileWriter fileWriter = null;
            fileWriter = toAppend == 1 ? new FileWriter(storeFileTo, true) : new FileWriter(storeFileTo);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.write(ModelUtilities.newline);
            writer.write(ModelUtilities.newline);
            writer.write(ModelUtilities.generateBlockCommentStart(bundle.getString("CodeGeneration.DeleteSharedDimensionComment.txt")));
            writer.write(olapDim.generateCodeDeletePhysical(true).toString());
            writer.write(ModelUtilities.generateBlockCommentEnd());
            int flags = 0;
            flags = OLAPCube.setCodegenFlag(flags, 1, false);
            flags = OLAPCube.setCodegenFlag(flags, 2, true);
            flags = OLAPCube.setCodegenFlag(flags, 16, true);
            writer.write(olapDim.generateCodeShortForm(flags).toString());
            writer.flush();
            writer.close();
            fileWriter.close();
        }
        catch (IOException error) {
            throw new OLAPException(error.getLocalizedMessage(), 0);
        }
        return true;
    }

    public static boolean saveAddDataProcCode(AddDataModel dataModel, String inputPath, int toAppend) throws OLAPException {
        try {
            File storeFileTo = new File(inputPath);
            FileWriter fileWriter = null;
            fileWriter = toAppend == 1 ? new FileWriter(storeFileTo, true) : new FileWriter(storeFileTo);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.newLine();
            writer.newLine();
            writer.write(dataModel.generateAddDataCode(false).toString());
            writer.newLine();
            writer.newLine();
            writer.write(dataModel.generateUpdateFormatSASCode().toString());
            writer.flush();
            writer.close();
            fileWriter.close();
        }
        catch (IOException error) {
            throw new OLAPException(error.getLocalizedMessage(), 0);
        }
        return true;
    }

    public static boolean saveAddDataSharedDimProcCode(AddDataModel dataModel, String inputPath, int toAppend) throws OLAPException {
        try {
            File storeFileTo = new File(inputPath);
            FileWriter fileWriter = null;
            fileWriter = toAppend == 1 ? new FileWriter(storeFileTo, true) : new FileWriter(storeFileTo);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.newLine();
            writer.newLine();
            writer.write(dataModel.generateCodeSharedUpdate(false).toString());
            writer.newLine();
            writer.newLine();
            writer.flush();
            writer.close();
            fileWriter.close();
        }
        catch (IOException error) {
            throw new OLAPException(error.getLocalizedMessage(), 0);
        }
        return true;
    }

    public static boolean saveCoalesceProcCode(OLAPCube olapCube, String inputPath, int toAppend) throws OLAPException {
        AggregationSet aggregationSet = olapCube.getAggregationSet();
        try {
            File storeFileTo = new File(inputPath);
            FileWriter fileWriter = null;
            fileWriter = toAppend == 1 ? new FileWriter(storeFileTo, true) : new FileWriter(storeFileTo);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.newLine();
            writer.newLine();
            writer.write(aggregationSet.generateCoalesceCode(true).toString());
            writer.flush();
            writer.close();
            fileWriter.close();
        }
        catch (IOException error) {
            throw new OLAPException(error.getLocalizedMessage(), 0);
        }
        return true;
    }
}

