/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.TableClassifierMap;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AggregationTable
extends TableClassifierMap {
    static final String TRANSFORM_ROLE = "AGGREGATE";
    private OLAPList tables;
    private Boolean validAggregateColumns;
    private OLAPList possibleLevels;

    AggregationTable(TableSet inputTableSet, PhysicalTable inputTable) throws OLAPException {
        this.table = inputTable;
        this.tableSet = inputTableSet;
        if (inputTable != null) {
            this.setSources(inputTable);
        }
    }

    void setMaps() throws OLAPException {
        try {
            Cube jomaCube = (Cube)this.tableSet.getOwningCube().metadataObject;
            AggregationSet aggregationSet = this.tableSet.getOwningCube().getAggregationSet();
            LoadTable loadTable = aggregationSet.getLoadTable();
            this.maps = loadTable != null && loadTable.equals(this) ? jomaCube.getTargetClassifierMaps(false) : jomaCube.getTargetTransformations(false);
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    void setSources(PhysicalTable inputTable) throws OLAPException {
        try {
            this.name = inputTable.getSASTableName();
            this.table = inputTable;
            this.tableSet.getTables().add(this);
            AggregationSet aggregationSet = this.tableSet.getOwningCube().getAggregationSet();
            LoadTable loadTable = aggregationSet.getLoadTable();
            if (loadTable == null) {
                if (Workspace.isDebug()) {
                    Workspace.getDefaultLogger().debug((Object)"There is no load table.");
                }
                throw new IllegalStateException("An invalid use of the AggregationTable was encountered.");
            }
            if (loadTable != null && loadTable.equals(this)) {
                this.sources = inputTable.getSourceClassifierMaps(false);
                this.setLoadTable(true);
                this.columns = loadTable.getColumns();
            } else {
                this.columns = null;
                this.getColumns();
                this.setLoadTable(false);
                this.sources = inputTable.getSourceTransformations(false);
            }
        }
        catch (MdException mdError) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), mdError, 12);
        }
        catch (RemoteException re) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
        }
    }

    @Override
    ClassifierMap createClassifierMap() throws OLAPException {
        if (!this.isLoadTable()) {
            super.createClassifierMap();
            try {
                this.classifierMap.setName(TRANSFORM_ROLE);
                this.classifierMap.setTransformRole(TRANSFORM_ROLE);
            }
            catch (RemoteException re) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), re, 12);
            }
        } else {
            LoadTable loadTable = this.tableSet.getLoadTable();
            this.classifierMap = loadTable.getClassifierMap();
            if (this.classifierMap == null) {
                this.classifierMap = loadTable.createClassifierMap();
            }
        }
        return this.classifierMap;
    }

    @Override
    ClassifierMap getClassifierMap() throws OLAPException {
        if (this.classifierMap == null) {
            if (this.maps == null) {
                this.setMaps();
            }
            super.getClassifierMap();
        }
        return this.classifierMap;
    }

    public OLAPList getPossibleLevels() throws OLAPException {
        if (this.possibleLevels == null) {
            this.possibleLevels = new OLAPList(OLAPLevel.class);
            this.possibleLevels.setParentObject(this);
        }
        if (this.possibleLevels.isEmpty()) {
            OLAPCube owningCube = this.tableSet.getOwningCube();
            DimensionSet dimensionSet = owningCube.getDimensionSet();
            Map levels = dimensionSet.getLevels();
            OLAPList listOfColumns = this.getColumns();
            Object[] tempLevels = levels.values().toArray();
            int size = tempLevels.length;
            for (int i = 0; i < size; ++i) {
                List listOfLevels = (List)tempLevels[i];
                int sizeLevels = listOfLevels.size();
                for (int s = 0; s < sizeLevels; ++s) {
                    OLAPLevel level = (OLAPLevel)listOfLevels.get(s);
                    OLAPColumn column = level.getColumn();
                    String columnName = column.getSASColumnName();
                    boolean found = false;
                    int t = 0;
                    int sizeColumns = listOfColumns.size();
                    while (t < sizeColumns & !found) {
                        OLAPColumn tableColumn = (OLAPColumn)listOfColumns.get(t);
                        if (tableColumn.getSASColumnName().equalsIgnoreCase(columnName)) {
                            this.possibleLevels.add(level);
                            found = true;
                        }
                        ++t;
                    }
                }
            }
        }
        this.possibleLevels.sort();
        return this.possibleLevels;
    }

    TableSet getTableSet() {
        return this.tableSet;
    }

    private boolean hasValidRolapAggregateColumns(LoadTable loadTable) throws OLAPException {
        boolean allAggregateColumns = true;
        if (!this.isLoadTable() && loadTable.getTable() != null) {
            AggregationTable loadAggregationTable = this.tableSet.getAggregationTable(loadTable.getTable());
            OLAPCube olapCube = this.tableSet.getOwningCube();
            MeasureSet measureSet = olapCube.getMeasureSet();
            OLAPList measures = measureSet.getStoredMeasures();
            int i = measures.size() - 1;
            while (i >= 0 & allAggregateColumns) {
                OLAPMeasure measure = (OLAPMeasure)measures.get(i);
                OLAPColumn column = measure.getAggregateColumn(loadAggregationTable);
                if (column != null) {
                    allAggregateColumns = this.getColumn(column.getSASColumnName()) != null;
                }
                --i;
            }
        }
        return allAggregateColumns;
    }

    private boolean hasValidMolapAggregateColumns() throws OLAPException {
        boolean allAggregateColumns = true;
        OLAPCube olapCube = this.tableSet.getOwningCube();
        AggregationSet aggregationSet = olapCube.getAggregationSet();
        MeasureSet measureSet = olapCube.getMeasureSet();
        OLAPList storedMeasures = measureSet.getStoredMeasures();
        int minimumNumberOfMatchingNumericColumns = storedMeasures.size();
        if (this.tables == null) {
            this.tables = aggregationSet.getTables();
        }
        if (this.tables.isEmpty()) {
            if (minimumNumberOfMatchingNumericColumns > 0) {
                allAggregateColumns = minimumNumberOfMatchingNumericColumns <= this.getAllNumericColumns().size();
            }
        } else if (!this.tables.isEmpty()) {
            OLAPColumn aggregateColumn;
            AggregationTable tempTable = null;
            ArrayList<OLAPColumn> mappedColumns = new ArrayList<OLAPColumn>();
            int i = this.tables.size() - 1;
            while (i >= 0 & tempTable == null) {
                tempTable = (AggregationTable)this.tables.get(i);
                if (tempTable.equals(this)) {
                    tempTable = null;
                } else if (minimumNumberOfMatchingNumericColumns == 0) {
                    minimumNumberOfMatchingNumericColumns = tempTable.getAllNumericColumns().size();
                } else if (!storedMeasures.isEmpty()) {
                    AggregationTable mappedTable = null;
                    for (int j = storedMeasures.size() - 1; j >= 0; --j) {
                        OLAPColumn aggregateColumn2;
                        OLAPMeasure mappedMeasure = (OLAPMeasure)storedMeasures.get(j);
                        int k = this.tables.size() - 1;
                        while (k >= 0 & mappedTable == null) {
                            mappedTable = (AggregationTable)this.tables.get(k);
                            if (!mappedTable.equals(this) && (aggregateColumn = mappedMeasure.getAggregateColumn(mappedTable)) == null) {
                                mappedTable = null;
                            }
                            --k;
                        }
                        if (mappedTable == null || (aggregateColumn2 = mappedMeasure.getAggregateColumn(mappedTable)) == null) continue;
                        mappedColumns.add(aggregateColumn2);
                    }
                }
                --i;
            }
            if (tempTable != null) {
                int i2;
                List numericColumns = this.getAllNumericColumns();
                int variableNumericColumnsSize = numericColumns.size();
                int matchingNumericColumns = 0;
                for (i2 = variableNumericColumnsSize - 1; i2 >= 0; --i2) {
                    OLAPColumn numericColumn = (OLAPColumn)numericColumns.get(i2);
                    aggregateColumn = tempTable.getColumn(numericColumn.getSASColumnName());
                    if (aggregateColumn == null) continue;
                    ++matchingNumericColumns;
                }
                allAggregateColumns = matchingNumericColumns >= minimumNumberOfMatchingNumericColumns;
                i2 = mappedColumns.size() - 1;
                while (i2 >= 0 & allAggregateColumns) {
                    OLAPColumn mappedColumn = (OLAPColumn)mappedColumns.get(i2);
                    OLAPColumn tableColumn = this.getColumn(mappedColumn.getSASColumnName());
                    allAggregateColumns = tableColumn != null;
                    --i2;
                }
            }
        }
        return allAggregateColumns;
    }

    private boolean hasAtLeastOneValidDrillOrder() throws OLAPException {
        boolean allAggregateColumns = false;
        DimensionSet dimensionSet = this.tableSet.getOwningCube().getDimensionSet();
        OLAPList hierarchies = dimensionSet.getHierarchies();
        for (int i = hierarchies.size() - 1; i >= 0 && !allAggregateColumns; --i) {
            OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(i);
            OLAPList levels = hierarchy.getLevels();
            if (levels.isEmpty()) continue;
            OLAPLevel level = (OLAPLevel)levels.get(0);
            OLAPColumn levelColumn = level.getColumn();
            OLAPColumn column = null;
            if (levelColumn != null) {
                column = this.getColumn(levelColumn.getSASColumnName());
            }
            allAggregateColumns = column != null;
        }
        return allAggregateColumns;
    }

    public boolean hasValidAggregateColumns() throws OLAPException {
        DimensionSet dimensionSet = this.getTableSet().getOwningCube().getDimensionSet();
        if (dimensionSet.hasDimensionsChanged() || this.validAggregateColumns == null) {
            boolean allAggregateColumns = true;
            LoadTable loadTable = this.tableSet.getLoadTable();
            if (this.tableSet.isLoadClassicSAS() && this.isLoadTable()) {
                this.validAggregateColumns = allAggregateColumns;
            } else {
                this.getColumns();
                if (loadTable != null & this.tableSet.isLoadClassicSAS()) {
                    allAggregateColumns = this.hasValidRolapAggregateColumns(loadTable);
                } else if (loadTable != null) {
                    allAggregateColumns = this.hasValidMolapAggregateColumns();
                }
                if (allAggregateColumns) {
                    allAggregateColumns = this.hasAtLeastOneValidDrillOrder();
                }
                this.validAggregateColumns = allAggregateColumns;
            }
        }
        return this.validAggregateColumns;
    }

    @Override
    public boolean isSimilar(PhysicalTable inputTable) throws OLAPException {
        if (Workspace.isDebug()) {
            Workspace.getDefaultLogger().debug((Object)"You must specify an OLAPAggregation to check if a table is similar to this aggregation table.  Use AggregationTable.isSimilar(OLAPAggregation, PhysicalTable) and pass in a valid OLAPAggregation object.");
        }
        throw new UnsupportedOperationException("An unsupported use of the isSimlar method was encountered.");
    }

    public boolean isSimilar(OLAPAggregation aggregation, PhysicalTable inputTable) throws OLAPException {
        boolean similar;
        if (aggregation == null) {
            if (Workspace.isDebug()) {
                Workspace.getDefaultLogger().debug((Object)"The OLAPAggregation parameter cannot be null, and must be an OLAPAggregation that has not beed deleted.");
            }
            throw new IllegalArgumentException("Illegal argument passed to the isSimilar method.");
        }
        boolean bl = similar = inputTable != null;
        if (similar) {
            OLAPList levels;
            similar = this.equals(inputTable);
            if (!similar) {
                similar = true;
            }
            if ((levels = aggregation.getLevels()).isEmpty()) {
                similar = super.isSimilar(inputTable);
            } else {
                similar = true;
                Map inputColumnMap = this.getColumnMap(inputTable);
                for (int i = levels.size() - 1; i >= 0 && similar; --i) {
                    OLAPLevel olapLevel = (OLAPLevel)levels.get(i);
                    OLAPColumn olapColumn = olapLevel.getColumn();
                    String olapColumnName = olapColumn.getSASColumnName().toUpperCase();
                    Column column = (Column)inputColumnMap.get(olapColumnName);
                    similar = column != null;
                }
                OLAPCube owningCube = this.tableSet.getOwningCube();
                MeasureSet measureSet = owningCube.getMeasureSet();
                OLAPList measures = measureSet.getStoredMeasures();
                for (int i = measures.size() - 1; i >= 0 && similar; --i) {
                    OLAPMeasure measure = (OLAPMeasure)measures.get(i);
                    OLAPColumn aggregateColumn = measure.getAggregateColumn(this);
                    if (aggregateColumn == null) continue;
                    String aggregateColumnName = aggregateColumn.getSASColumnName().toUpperCase();
                    Column inputAggregateColumn = (Column)inputColumnMap.get(aggregateColumnName);
                    similar = inputAggregateColumn != null;
                }
            }
        }
        return similar;
    }

    void resetPossibleLevels() throws OLAPException {
        if (this.possibleLevels != null) {
            this.possibleLevels.clear();
        }
        this.getPossibleLevels();
    }

    void setTable(PhysicalTable inputTable) {
    }

    void setValidAggregateColumns(Boolean inputValidAggregateColumns) {
        this.validAggregateColumns = inputValidAggregateColumns;
    }

    void updateMetadata() throws OLAPException {
        this.setMaps();
    }
}

