/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.model;

import com.sas.codegen.CodeGenUtil;
import com.sas.codegen.CodegenRequest;
import com.sas.codegen.PhysicalTableCG;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.SharedDimension;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.DimensionTable;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.ReachThruTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class AddDataModel {
    private static WAdminResource bundle = new WAdminResource(AddDataModel.class);
    private String placeCubeName;
    private String copyCubeName;
    public static final int UPDATE_IN_PLACE_ = 0;
    public static final int COPY_CUBE = 1;
    private OLAPSharedDimension sharedDim;
    private OLAPSchema placeOlapSchema;
    private OLAPSchema copyOlapSchema;
    private String updateTableName;
    private String drillTableOptions;
    private PhysicalTable updateTable;
    private String updateTableOptions;
    private String drillTableName;
    private PhysicalTable drillTable;
    private List updateableDimensions;
    private List nonUpdateableDimensions;
    private OLAPCube olapCube;
    private Tree folder;
    private boolean typeOfPlaceUpdate;
    private String handleMissingKeys;
    private TableSet tableSet;
    private boolean metadataRetrieved;
    private boolean drillTableChanged;
    private boolean isCube;
    private boolean isMLSDrillThru;

    public AddDataModel(OLAPCube inputOlapCube) throws OLAPException {
        this.olapCube = inputOlapCube;
        this.placeCubeName = this.olapCube.getName();
        this.copyOlapSchema = this.placeOlapSchema = this.olapCube.getAssociatedOLAPSchema();
        this.typeOfPlaceUpdate = true;
        this.olapCube.setAddData(true);
        this.isCube = true;
        LanguageSet languageSet = this.olapCube.getLanguageSet();
        this.isMLSDrillThru = languageSet.isCubeMLSDrillThruSupported();
    }

    public AddDataModel(OLAPSharedDimension inputDim) throws OLAPException {
        this.sharedDim = inputDim;
        this.placeCubeName = this.sharedDim.getName();
        this.copyOlapSchema = this.placeOlapSchema = this.sharedDim.getAssociatedOLAPSchema();
        this.typeOfPlaceUpdate = true;
        this.sharedDim.setAddData(true);
    }

    public StringBuffer generateAddDataCode(boolean submitCode) throws OLAPException {
        ReachThruTable original;
        StringBuffer formatSearchOptions;
        StringBuffer code = new StringBuffer();
        StringBuffer sasOptions = this.olapCube.generateCodeSasCode();
        if (!ModelUtilities.isBlank(sasOptions.toString())) {
            code.append(sasOptions);
        }
        if (!ModelUtilities.isBlank((formatSearchOptions = this.generateCodeFormatSearchOptions()).toString())) {
            code.append(formatSearchOptions);
        }
        this.tableSet = this.olapCube.getTableSet();
        try {
            if (submitCode) {
                code.append(this.getSubmitLibnameCode());
            } else {
                code.append(this.getDisplayLibnameCode());
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        StringBuffer tableName = new StringBuffer(this.getUpdateTableName());
        code.append(ModelUtilities.newline);
        code.append(this.olapCube.generateCodeProcOlapCubeEquals(this.olapCube.getFolder(), false));
        code.append(ModelUtilities.newline);
        boolean addData = false;
        if (!ModelUtilities.isBlank(tableName.toString())) {
            addData = true;
            String tableOptions = this.getUpdateTableOptions().trim();
            if (tableOptions.length() > 0) {
                StringBuffer tableOptionsBuffer = new StringBuffer(tableOptions);
                tableOptionsBuffer.insert(0, "(").append(")");
                tableName.append(tableOptionsBuffer);
            }
            code.append("   DATA                   = ").append(tableName);
            code.append(ModelUtilities.newline);
            code.append("   ADD_DATA");
            code.append(ModelUtilities.newline);
        }
        if (this.typeOfPlaceUpdate) {
            code.append("   UPDATE_INPLACE");
            code.append(ModelUtilities.newline);
        } else {
            if (!this.olapCube.getName().equalsIgnoreCase(this.getName())) {
                String pathURL = null;
                try {
                    MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
                    this.getFolder();
                    if (this.folder != null) {
                        pathURL = mdUtil.getObjectPath((MdObjectStore)this.folder.getObjectStore(), (PrimaryType)this.folder, false);
                    }
                }
                catch (MdException error) {
                    throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(re.getLocalizedMessage(), 12);
                }
                code.append("   OUTCUBE                = ").append("\"").append(pathURL).append("/").append(this.getName()).append("\"");
                code.append(ModelUtilities.newline);
            }
            if (!this.olapCube.getAssociatedOLAPSchema().equals((Object)this.getOLAPSchema())) {
                code.append("   OUTSCHEMA              = ").append("\"").append(this.getOLAPSchema()).append("\"");
                code.append(ModelUtilities.newline);
            }
        }
        PhysicalTable reachthruTable = this.getDrillTable();
        if (reachthruTable != null && this.drillTableChanged && !reachthruTable.equals((Object)(original = this.tableSet.getReachThruTable()))) {
            SASLibrary reachthruLibrary = null;
            try {
                reachthruLibrary = LibraryUtil.getLibrary((DataTable)reachthruTable, null);
                String reachThruLibRef = "";
                if (reachthruLibrary != null) {
                    reachThruLibRef = reachthruLibrary.getLibref();
                }
                StringBuffer reachThruOptions = new StringBuffer(this.getDrillTableOptions());
                StringBuffer reachThruMemPref = ModelUtilities.getSasName(reachthruTable.getSASTableName());
                if (!this.isMLSDrillThru) {
                    StringBuffer reachthruName = new StringBuffer();
                    reachthruName.append(reachThruLibRef).append(".").append(reachThruMemPref);
                    if (reachThruOptions.length() > 0) {
                        reachThruOptions.insert(0, "(").append(")");
                    }
                    reachthruName.append(reachThruOptions);
                    code.append("   DRILLTHROUGH_TABLE     = ").append(reachthruName);
                } else {
                    code.append("   DTMEMPREF              = ").append(reachThruMemPref).append(ModelUtilities.newline);
                    if (!ModelUtilities.isBlank(reachThruLibRef)) {
                        code.append("   DTLIBREF               = ").append(reachThruLibRef).append(ModelUtilities.newline);
                    }
                    if (!ModelUtilities.isBlank(reachThruOptions.toString())) {
                        code.append("   DTMEMPREFOPTS          = ").append("'").append(reachThruOptions).append("'");
                    }
                }
            }
            catch (MdException error) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            code.append(ModelUtilities.newline).append("   UPDATE_DISPLAY_NAMES");
            code.append(ModelUtilities.newline);
        }
        if (this.tableSet.isLoadStarSchema() && !this.getHandleMissingKeys().equals("ERROR")) {
            code.append("   IGNORE_MISSING_DIMKEYS = ").append(this.getHandleMissingKeys());
            code.append(ModelUtilities.newline);
        }
        code.append(this.generatePerformanceOptions());
        code.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        if (submitCode) {
            code.append(this.olapCube.generateCodeMetasrvStatement(this.olapCube.getAssociatedOLAPSchema(), false));
        } else {
            code.append(this.olapCube.generateCodeMetasrvStatement(this.olapCube.getAssociatedOLAPSchema(), true));
        }
        code.append(ModelUtilities.newline);
        boolean updateAll = true;
        boolean tableChanged = false;
        boolean tableOptionsExist = false;
        boolean isStar = this.tableSet.isLoadStarSchema();
        List listOfDimensions = this.getUpdateableDimensions();
        int size = listOfDimensions.size();
        for (int i = 0; i < size; ++i) {
            OLAPDimension dimension = (OLAPDimension)listOfDimensions.get(i);
            String dimensionUpdate = dimension.getUpdateOption();
            updateAll = isStar & addData ? dimensionUpdate != null && !dimensionUpdate.equals("MEMBERS") : (isStar ? dimensionUpdate != null && !dimensionUpdate.equals("OFF") : dimensionUpdate != null && !dimensionUpdate.equals("MEMBERS"));
            tableChanged = !dimension.getTable().equals(dimension.getAddDataTable());
            String dimTableOptions = dimension.getAddDataTableOptions().trim();
            boolean bl = tableOptionsExist = dimTableOptions.length() > 0;
            if (!updateAll && !tableChanged && !tableOptionsExist) continue;
            code.append("   DIMENSION ").append(ModelUtilities.getSasName(dimension.getName()));
            code.append(ModelUtilities.newline);
            if (tableChanged || tableOptionsExist) {
                StringBuffer dimTableName = tableChanged ? new StringBuffer(dimension.getAddDataTableName()) : new StringBuffer(ModelUtilities.generateTableName(dimension.getTable().getTable()));
                if (tableOptionsExist) {
                    StringBuffer tableOptionsBuffer = new StringBuffer(dimTableOptions);
                    tableOptionsBuffer.insert(0, "(").append(")");
                    dimTableName.append(tableOptionsBuffer);
                }
                code.append("      DIMTBL           = ").append(dimTableName);
                code.append(ModelUtilities.newline);
            }
            if (updateAll) {
                code.append("      UPDATE_DIMENSION = ").append(dimensionUpdate);
                code.append(ModelUtilities.newline);
            }
            code.append(";").append(ModelUtilities.newline).append(ModelUtilities.newline);
        }
        code.append("   RUN;");
        return code;
    }

    public StringBuffer generateCodeSharedUpdate(boolean submitCode) throws OLAPException {
        StringBuffer code = new StringBuffer();
        code.append("OPTIONS VALIDVARNAME=ANY;").append(ModelUtilities.newline);
        StringBuffer sasOptions = this.sharedDim.generateCodeSasCode();
        if (!ModelUtilities.isBlank(sasOptions.toString())) {
            code.append(sasOptions);
        }
        this.tableSet = this.sharedDim.getTableSet();
        try {
            if (submitCode) {
                code.append(this.getSubmitLibnameCode());
            } else {
                code.append(this.getDisplayLibnameCode());
            }
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        code.append(ModelUtilities.newline);
        code.append("PROC OLAP");
        code.append(ModelUtilities.getReconnectionString()).append(";").append(ModelUtilities.newline);
        if (submitCode) {
            code.append(this.sharedDim.generateCodeMetasrvStatement(this.placeOlapSchema, false));
        } else {
            code.append(this.sharedDim.generateCodeMetasrvStatement(this.placeOlapSchema, true));
        }
        code.append(ModelUtilities.newline);
        code.append(this.sharedDim.generateCodeProcOlapEquals(this.sharedDim.getFolder(), false));
        code.append(ModelUtilities.newline);
        code.append("      UPDATE_DIMENSION = ").append(this.sharedDim.getUpdateOption()).append(ModelUtilities.newline);
        String dimTableOptions = this.sharedDim.getAddDataTableOptions().trim();
        StringBuffer dimTableName = new StringBuffer(this.sharedDim.getAddDataTableName());
        if (!ModelUtilities.isBlank(dimTableOptions)) {
            StringBuffer tableOptionsBuffer = new StringBuffer(dimTableOptions);
            tableOptionsBuffer.insert(0, "(").append(")");
            dimTableName.append(tableOptionsBuffer);
        }
        code.append("      DIMTBL           = ").append(dimTableName).append(";").append(ModelUtilities.newline);
        code.append("   RUN;");
        return code;
    }

    private StringBuffer generatePerformanceOptions() throws OLAPException {
        Integer performanceOptionIndexSortSize;
        Integer performanceOptionMaxThreads;
        StringBuffer performanceCode = new StringBuffer();
        Integer performanceOptionConcurrent = this.olapCube.getPerformanceOptionConcurrent();
        if (performanceOptionConcurrent != null && this.olapCube.changedPerformanceConcurrent) {
            performanceCode.append("   CONCURRENT             = ").append(performanceOptionConcurrent).append(ModelUtilities.newline);
        }
        if ((performanceOptionMaxThreads = this.olapCube.getPerformanceOptionMaxThreads()) != null && this.olapCube.changedPerformanceMaxThreads) {
            performanceCode.append("   MAXTHREADS             = ").append(performanceOptionMaxThreads).append(ModelUtilities.newline);
        }
        if ((performanceOptionIndexSortSize = this.olapCube.getPerformanceOptionIndexSortSize()) != null && this.olapCube.changedPerformanceIndexSortSize) {
            performanceCode.append("   INDEXSORTSIZE          = ").append(performanceOptionIndexSortSize).append(ModelUtilities.newline);
        }
        return performanceCode;
    }

    public StringBuffer generateUpdateFormatSASCode() throws OLAPException, RemoteException {
        StringBuffer dataStep = new StringBuffer();
        OLAPSchema schema = this.getOLAPSchema();
        String schemaName = schema.getName();
        String cubeName = this.getName();
        String preSASCode = this.olapCube.getSASCode();
        String formatCode = this.olapCube.getFormatSearchOptions();
        boolean foundSAS = false;
        boolean foundFormatCode = false;
        if (!ModelUtilities.isBlank(preSASCode)) {
            foundSAS = true;
        }
        if (!ModelUtilities.isBlank(formatCode)) {
            foundFormatCode = true;
        }
        if (foundSAS || foundFormatCode) {
            String reposName = this.olapCube.getRepositoryName();
            String sasCode = this.getQuote(preSASCode);
            dataStep.append("options metarepository= '").append(reposName).append("';").append(ModelUtilities.newline);
            dataStep.append("data _null_;").append(ModelUtilities.newline);
            dataStep.append("length uri name  noteURI forURI sasURI $256;").append(ModelUtilities.newline);
            dataStep.append("found=0; ");
            dataStep.append("rc=1; ");
            dataStep.append("n=1; ");
            dataStep.append("uri=''; ");
            dataStep.append("name=''; ");
            dataStep.append("noteURI=''; ");
            dataStep.append("forURI=''; ");
            dataStep.append("sasURI=''; ");
            dataStep.append("foundSASCode=0; ");
            dataStep.append("foundFMT=0;").append(ModelUtilities.newline);
            dataStep.append("do while(rc > 0 & found = 0);").append(ModelUtilities.newline);
            dataStep.append("   rc=metadata_getnass(\"omsobj:OLAPSchema?@Name= '").append(schemaName).append("'\",'Cubes',n,uri);").append(ModelUtilities.newline);
            dataStep.append("   if rc > 0 then arc=metadata_getattr(uri,'Name',name);").append(ModelUtilities.newline);
            dataStep.append("   if name='").append(cubeName).append("' then found = 1;").append(ModelUtilities.newline);
            dataStep.append("   n=n+1;").append(ModelUtilities.newline);
            dataStep.append("end;").append(ModelUtilities.newline);
            dataStep.append("n=1; rc=1;").append(ModelUtilities.newline);
            dataStep.append("do while(rc > 0);").append(ModelUtilities.newline);
            dataStep.append("   rc=metadata_getnass(uri,'Notes',n,noteURI);").append(ModelUtilities.newline);
            dataStep.append("   if rc > 0 then arc=metadata_getattr(noteURI,'Name',name);").append(ModelUtilities.newline);
            dataStep.append("   if name = 'OLAPFMTSEARCH' then do;").append(ModelUtilities.newline);
            dataStep.append("      arc=metadata_setattr(noteURI,'StoredText','").append(formatCode).append("');").append(ModelUtilities.newline);
            dataStep.append("      foundFMT=1;").append(ModelUtilities.newline);
            dataStep.append("   end;").append(ModelUtilities.newline);
            dataStep.append("   if name = 'OLAPSASCode' then do;").append(ModelUtilities.newline);
            dataStep.append("      arc=metadata_setattr(noteURI,'StoredText','").append(sasCode).append("');").append(ModelUtilities.newline);
            dataStep.append("      foundSASCode=1;").append(ModelUtilities.newline);
            dataStep.append("   end;").append(ModelUtilities.newline);
            dataStep.append("   n=n+1;").append(ModelUtilities.newline);
            dataStep.append("end;").append(ModelUtilities.newline);
            if (foundSAS) {
                dataStep.append("if foundSASCode=0 then do;").append(ModelUtilities.newline);
                dataStep.append("   rc=metadata_newobj('TextStore',sasURI,'OLAPSASCode','',uri,'Notes');").append(ModelUtilities.newline);
                dataStep.append("   arc=metadata_setattr(sasURI,\"StoredText\",'").append(sasCode).append("');").append(ModelUtilities.newline);
                dataStep.append("   arc=metadata_setattr(sasURI,'TextRole','Olap SASCODE Description');").append(ModelUtilities.newline);
                dataStep.append("   arc=metadata_setattr(sasURI,'TextType','Plain Text');").append(ModelUtilities.newline);
                dataStep.append("end;").append(ModelUtilities.newline);
            }
            if (foundFormatCode) {
                dataStep.append("if foundFMT=0 then do;").append(ModelUtilities.newline);
                dataStep.append("   rc=metadata_newobj('TextStore',forURI,'OLAPFMTSEARCH','',uri,'Notes');").append(ModelUtilities.newline);
                dataStep.append("   arc=metadata_setattr(forURI,'StoredText','").append(formatCode).append("');").append(ModelUtilities.newline);
                dataStep.append("   arc=metadata_setattr(forURI,'TextRole','Olap FORMAT Description');").append(ModelUtilities.newline);
                dataStep.append("   arc=metadata_setattr(forURI,'TextType','Plain Text');").append(ModelUtilities.newline);
                dataStep.append("end;").append(ModelUtilities.newline);
            }
            dataStep.append("run;");
        }
        return dataStep;
    }

    String getSubmitLibnameCode() throws OLAPException, MdException, RemoteException {
        WsAppServer appserver = WsAppServer.createDefaultAppServer();
        CodegenRequest codegenRequest = null;
        String source = null;
        PhysicalTableCG tablecg = null;
        PhysicalTable updateTable = this.getUpdateTable();
        if (updateTable != null) {
            codegenRequest = new CodegenRequest((CMetadata)updateTable, appserver, 1, true);
            codegenRequest.genReturnCodeSetup();
            codegenRequest.m_serverID = appserver.getServerContext().getFQID();
            codegenRequest.setCurrentServer((DeployedComponent)appserver.getServerContext());
            tablecg = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)updateTable);
            tablecg.accessPath(codegenRequest);
        }
        if (this.isCube) {
            this.getDrillTable();
            if (this.drillTable != null) {
                if (codegenRequest == null) {
                    codegenRequest = new CodegenRequest((CMetadata)this.drillTable, appserver, 1, true);
                    codegenRequest.genReturnCodeSetup();
                    codegenRequest.m_serverID = appserver.getServerContext().getFQID();
                    codegenRequest.setCurrentServer((DeployedComponent)appserver.getServerContext());
                }
                tablecg = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)this.drillTable);
                tablecg.accessPath(codegenRequest);
            }
            if (this.tableSet.isLoadStarSchema()) {
                DimensionSet dimensionSet = this.olapCube.getDimensionSet();
                OLAPList listOfDimensions = dimensionSet.getCubeDimensions();
                int size = listOfDimensions.size();
                for (int i = 0; i < size; ++i) {
                    OLAPDimension dimension = (OLAPDimension)listOfDimensions.get(i);
                    PhysicalTable table = dimension.getAddDataTable();
                    if (codegenRequest == null) {
                        codegenRequest = new CodegenRequest((CMetadata)table, appserver, 1, true);
                        codegenRequest.genReturnCodeSetup();
                        codegenRequest.m_serverID = appserver.getServerContext().getFQID();
                        codegenRequest.setCurrentServer((DeployedComponent)appserver.getServerContext());
                    }
                    tablecg = (PhysicalTableCG)CodeGenUtil.getCodeGenClass((CMetadata)table);
                    tablecg.accessPath(codegenRequest);
                }
            }
        }
        if (codegenRequest != null) {
            codegenRequest.doCodegen();
            source = codegenRequest.getSource();
            codegenRequest.cleanupCodeGen();
        }
        if (appserver != null) {
            appserver.closeSASCodeSession();
        }
        return source;
    }

    StringBuffer getDisplayLibnameCode() throws OLAPException, MdException, RemoteException {
        SASLibrary library;
        ArrayList<SASLibrary> listOfLibnames = new ArrayList<SASLibrary>();
        StringBuffer libraryCode = new StringBuffer();
        PhysicalTable table = this.getUpdateTable();
        if (table != null) {
            library = LibraryUtil.getLibrary((DataTable)table, null);
            listOfLibnames.add(library);
            libraryCode.append(this.getDisplayLibnames(library));
            libraryCode.append(ModelUtilities.newline);
        }
        if (this.isCube) {
            this.getDrillTable();
            if (this.drillTable != null && !listOfLibnames.contains(library = LibraryUtil.getLibrary((DataTable)this.drillTable, null))) {
                listOfLibnames.add(library);
                libraryCode.append(this.getDisplayLibnames(library));
                libraryCode.append(ModelUtilities.newline);
            }
            if (this.tableSet.isLoadStarSchema()) {
                DimensionSet dimensionSet = this.olapCube.getDimensionSet();
                OLAPList listOfDimensions = dimensionSet.getCubeDimensions();
                int size = listOfDimensions.size();
                for (int i = 0; i < size; ++i) {
                    OLAPDimension dimension = (OLAPDimension)listOfDimensions.get(i);
                    PhysicalTable dimTable = dimension.getAddDataTable();
                    SASLibrary sasLibrary = LibraryUtil.getLibrary((DataTable)dimTable, null);
                    if (listOfLibnames.contains(sasLibrary)) continue;
                    libraryCode.append(this.getDisplayLibnames(sasLibrary));
                    libraryCode.append(ModelUtilities.newline);
                    listOfLibnames.add(sasLibrary);
                }
            }
        }
        return libraryCode;
    }

    private String generateName() {
        this.copyCubeName = this.placeCubeName.length() > 22 ? this.placeCubeName.substring(0, 22).trim() : this.olapCube.getName();
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Calendar calendar = dateFormat.getCalendar();
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(10);
        int minutes = calendar.get(12);
        StringBuffer generateName = new StringBuffer();
        generateName.append(this.copyCubeName).append(month).append(day).append(hour).append(minutes);
        this.copyCubeName = generateName.toString();
        return this.copyCubeName;
    }

    public PhysicalTable getDrillTable() throws OLAPException {
        if (this.drillTable == null && !this.metadataRetrieved) {
            TableSet tableSet = this.olapCube.getTableSet();
            ReachThruTable table = tableSet.getReachThruTable();
            if (table != null) {
                this.drillTable = table.getTable();
            }
            this.metadataRetrieved = true;
        }
        return this.drillTable;
    }

    public String getDrillTableOptions() {
        if (this.drillTableOptions == null) {
            return "";
        }
        return this.drillTableOptions;
    }

    public String getDrillTableName() throws OLAPException {
        if (this.drillTable == null) {
            this.getDrillTable();
        }
        if (this.drillTable != null) {
            this.drillTableName = ModelUtilities.generateTableName(this.drillTable);
        }
        if (this.drillTableName == null) {
            return "";
        }
        return this.drillTableName;
    }

    public String getHandleMissingKeys() {
        if (this.handleMissingKeys == null) {
            this.handleMissingKeys = "ERROR";
        }
        return this.handleMissingKeys;
    }

    public String getName() {
        if (this.typeOfPlaceUpdate) {
            return this.placeCubeName;
        }
        if (this.copyCubeName == null) {
            this.generateName();
        }
        return this.copyCubeName;
    }

    public OLAPCube getOLAPCube() {
        return this.olapCube;
    }

    public OLAPSharedDimension getOLAPSharedDimension() {
        return this.sharedDim;
    }

    public OLAPSchema getOLAPSchema() {
        if (this.typeOfPlaceUpdate) {
            return this.placeOlapSchema;
        }
        return this.copyOlapSchema;
    }

    public Tree getFolder() throws OLAPException {
        if (this.folder == null) {
            this.folder = this.olapCube.getFolder();
        }
        return this.folder;
    }

    public String getQuote(String input) {
        String quoted = null;
        quoted = input != null && input.indexOf("'") >= 0 ? input.replaceAll("'", "\"") : input;
        return quoted;
    }

    public int getTypeOfUpdate() {
        if (this.typeOfPlaceUpdate) {
            return 0;
        }
        return 1;
    }

    public String getUpdateTableName() throws OLAPException {
        if (this.updateTable == null) {
            return "";
        }
        this.updateTableName = ModelUtilities.generateTableName(this.updateTable);
        return this.updateTableName;
    }

    public List getNonUpdateableDimensions() throws OLAPException {
        if (this.nonUpdateableDimensions == null) {
            this.getUpdateableDimensions();
        }
        return this.nonUpdateableDimensions;
    }

    public List getUpdateableDimensions() throws OLAPException {
        if (this.updateableDimensions == null) {
            this.updateableDimensions = new ArrayList();
            this.nonUpdateableDimensions = new ArrayList();
            DimensionSet dimensionSet = this.olapCube.getDimensionSet();
            TableSet tableSet = this.olapCube.getTableSet();
            boolean isStar = tableSet.isLoadStarSchema();
            LoadTable factTable = tableSet.getLoadTable();
            OLAPList listOfDimensions = dimensionSet.getCubeDimensions();
            int size = listOfDimensions.size();
            for (int i = 0; i < size; ++i) {
                DimensionTable dimensionTable;
                OLAPDimension dimension = (OLAPDimension)listOfDimensions.get(i);
                if (isStar && (dimensionTable = dimension.getTable()) != null && factTable != null && dimensionTable.equals(factTable)) continue;
                if (dimension.isUpdateable()) {
                    this.updateableDimensions.add(dimension);
                    continue;
                }
                this.nonUpdateableDimensions.add(dimension);
            }
        }
        return this.updateableDimensions;
    }

    public PhysicalTable getUpdateTable() {
        return this.updateTable;
    }

    public String getUpdateTableOptions() {
        if (this.updateTableOptions == null) {
            return "";
        }
        return this.updateTableOptions;
    }

    public boolean isAddDataForCube() {
        return this.olapCube != null;
    }

    public boolean isMLS() throws OLAPException {
        boolean isLanguageSupported = false;
        if (this.olapCube != null) {
            LanguageSet languageSet = this.olapCube.getLanguageSet();
            isLanguageSupported = languageSet.isCubeMultipleLanguageSupported();
        }
        return isLanguageSupported;
    }

    public boolean isMLSDrillThruSupported() {
        return this.isMLSDrillThru;
    }

    public void setMLSDrillThruSupported(boolean newSetting) {
        this.isMLSDrillThru = newSetting;
    }

    public void setFolder(Tree inputFolder) {
        this.folder = inputFolder;
    }

    public void setHandleMissingKeys(String inputHandle) {
        this.handleMissingKeys = inputHandle;
    }

    public void setName(String inputName) {
        if (!this.typeOfPlaceUpdate) {
            this.copyCubeName = inputName;
        }
    }

    public void setOLAPSchema(OLAPSchema inputSchema) {
        if (!this.typeOfPlaceUpdate) {
            this.copyOlapSchema = inputSchema;
        }
    }

    public void setTypeOfUpdate(int inputTypeUpdate) {
        this.typeOfPlaceUpdate = inputTypeUpdate == 0;
    }

    void setUpdateTableName(String inputTable) {
        this.updateTableName = inputTable;
    }

    public void setUpdateTableOptions(String inputOptions) {
        this.updateTableOptions = inputOptions;
    }

    public void setUpdateTable(PhysicalTable inputTable) throws OLAPException {
        this.updateTable = inputTable;
        if (inputTable != null) {
            this.setUpdateTableName(ModelUtilities.generateTableName(this.updateTable));
        } else {
            this.setUpdateTableName(null);
        }
    }

    public void setDrillTable(PhysicalTable inputDrillTable) throws OLAPException {
        this.drillTable = inputDrillTable;
        this.setDrillTableName(ModelUtilities.generateTableName(this.drillTable));
        this.drillTableChanged = true;
    }

    public void setDrillTableOptions(String inputOptions) {
        this.drillTableOptions = inputOptions;
    }

    void setDrillTableName(String inputDrillTableName) {
        this.drillTableName = inputDrillTableName;
    }

    public void updateMetadata() throws OLAPException {
        if (this.isCube) {
            Cube cube = (Cube)this.olapCube.metadataObject;
            if (cube != null) {
                try {
                    this.olapCube.updateNotesMetadata();
                    cube.touch();
                    Job jobCube = ModelUtilities.getJobCube(cube);
                    if (jobCube != null) {
                        jobCube.touch();
                    }
                    cube.updateMetadataAll();
                }
                catch (MdException mdError) {
                    throw new OLAPException(mdError.getMessage(), mdError, 12);
                }
                catch (RemoteException re) {
                    throw new OLAPException(re.getMessage(), re, 12);
                }
            }
        } else {
            this.updateSharedDimensionMetadata();
        }
    }

    public void updateSharedDimensionMetadata() throws OLAPException {
        SharedDimension dim = (SharedDimension)this.sharedDim.metadataObject;
        if (this.sharedDim != null) {
            try {
                dim.touch();
                dim.updateMetadataAll();
            }
            catch (MdException mdError) {
                throw new OLAPException(mdError.getMessage(), mdError, 12);
            }
            catch (RemoteException re) {
                throw new OLAPException(re.getMessage(), re, 12);
            }
        }
    }

    public void verifyNameSchemaFolder() throws OLAPException {
        try {
            if (!this.typeOfPlaceUpdate) {
                this.getName();
                if (this.copyCubeName == null || this.copyCubeName.equalsIgnoreCase(this.olapCube.getName())) {
                    throw new OLAPException(bundle.getString("CubeUpdate.NameNeedsToChange.txt"), null, 0);
                }
                if (this.copyCubeName.length() > 32) {
                    throw new OLAPException(bundle.getString("Model.SASName.txt"), null, 0);
                }
                ModelUtilities.verifyPublicTypeName(this.copyCubeName);
                this.getOLAPSchema();
                if (this.copyOlapSchema == null) {
                    throw new OLAPException(bundle.getString("OLAPCube.NoSchemaSelected.txt"), null, 0);
                }
                if (!ModelUtilities.canWrite("OLAPSchema", (CMetadata)this.copyOlapSchema)) {
                    throw new OLAPException(bundle.formatString("OLAPcube.NoWriteSchema.fmt.txt", (Object)this.copyOlapSchema.getName()), 0);
                }
                boolean unique = ModelUtilities.isCubeNameUniqueToOLAPSchema(this.copyCubeName, this.getOLAPSchema());
                if (!unique) {
                    throw new OLAPException(bundle.getString("OLAPCube.CubenameUniqueToSchema.txt"), null, 0);
                }
                this.getFolder();
                if (this.folder == null) {
                    throw new OLAPException(bundle.getString("OLAPCube.NoFolder.txt"), 0);
                }
                if (!ModelUtilities.getPermissionFromId("WriteMemberMetadata", this.folder.getCMetadataType(), this.folder.getFQID())) {
                    throw new OLAPException(bundle.formatString("OLAPCube.NoWriteFolder.fmt.txt", (Object)this.folder.getName()), 0);
                }
                boolean uniqueFolder = ModelUtilities.isCubeNameUniqueToFolder(this.copyCubeName, this.folder);
                if (!uniqueFolder) {
                    throw new OLAPException(bundle.getString("OLAPCube.CubenameUniqueToFolder.txt"), null, 0);
                }
            }
        }
        catch (RemoteException e) {
            throw new OLAPException(e.getMessage(), e, 12);
        }
    }

    public void verifySource() throws OLAPException {
        this.tableSet = this.olapCube.getTableSet();
        boolean isDetail = this.tableSet.isLoadDetailTable();
        if (this.updateTable == null && isDetail) {
            throw new OLAPException(bundle.getString("CubeUpdate.NoSource.txt"), null, 0);
        }
        LoadTable originalTable = this.tableSet.getLoadTable();
        if (this.updateTable != null && !originalTable.isSimilar(this.updateTable)) {
            String updateTableName = ModelUtilities.generateTableName(this.updateTable);
            throw new OLAPException(bundle.formatString("CubeUpdate.PickAnotherTable.fmt.txt", (Object)updateTableName), 0);
        }
    }

    public void verifyDimensionSource(OLAPDimension dimension) throws OLAPException {
        PhysicalTable updateTable = dimension.getAddDataTable();
        if (updateTable == null) {
            throw new OLAPException(bundle.getString("CubeUpdate.NoSource.txt"), null, 0);
        }
        if (!dimension.isSimilar(updateTable)) {
            String originalTableName = null;
            originalTableName = this.isCube ? ModelUtilities.generateTableName(dimension.getTable().table) : ModelUtilities.generateTableName(this.sharedDim.getSharedDimensionTable().table);
            String currentTable = ModelUtilities.generateTableName(updateTable);
            throw new OLAPException(bundle.formatString("CubeUpdate.PickAnotherTableDim.fmt.txt", (Object)currentTable, (Object)dimension.getName(), (Object)originalTableName), 0);
        }
    }

    private StringBuffer getDisplayLibnames(SASLibrary sasLibrary) throws OLAPException {
        StringBuffer sasLibraryCode = new StringBuffer();
        try {
            sasLibraryCode.append(ModelUtilities.trim(LibraryUtil.getAccessPath((SASLibrary)sasLibrary).toString().replaceAll("\n", ModelUtilities.newline)));
        }
        catch (MdException error) {
            throw new OLAPException(bundle.getString("MdException.GenericError.txt"), error, 12);
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return sasLibraryCode;
    }

    StringBuffer generateCodeFormatSearchOptions() throws OLAPException {
        StringBuffer sasFormats = new StringBuffer();
        String formatSearchOptions = this.olapCube.getFormatSearchOptions();
        if (!ModelUtilities.isBlank(formatSearchOptions)) {
            sasFormats.append("OPTIONS FMTSEARCH = (").append(formatSearchOptions).append(");").append(ModelUtilities.newline).append(ModelUtilities.newline);
        }
        return sasFormats;
    }
}

