/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.visuals;

import com.sas.report.repository.RepositoryMessager;
import com.sas.report.repository.RepositoryResource;
import com.sas.report.repository.visuals.DuplicateNameException;
import com.sas.report.repository.visuals.GenericDialog;
import com.sas.report.repository.visuals.GenericTableAccess;
import com.sas.report.repository.visuals.IllegalNameException;
import com.sas.report.repository.visuals.IllegalOpenException;
import com.sas.report.repository.visuals.IllegalSaveException;
import com.sas.report.repository.visuals.ImageHandler;
import com.sas.report.repository.visuals.InvalidLocationException;
import com.sas.report.repository.visuals.InvalidSelectionException;
import com.sas.report.repository.visuals.NotFoundException;
import com.sas.report.repository.visuals.OpenSavePopup;
import com.sas.report.repository.visuals.SlashFileException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class OpenSaveDialog
extends GenericDialog {
    public Object fileStream;
    public String fileName;
    private static final String pgm = "OpenSaveDialog";
    public static final int OPEN = 0;
    public static final int SAVE = 1;
    public static final int SELECT = 2;
    public static final int LIST = 0;
    public static final int DETAIL = 1;
    private Vector choiceList;
    private Vector dirList;
    private RepositoryMessager messager;
    private static final String repsstr = RepositoryResource.getStringResource("repStr.txt");
    private static final String selerr1 = RepositoryResource.getStringResource("selerr1.txt");
    private static final String selerr2 = RepositoryResource.getStringResource("selerr2.txt");
    private static final String saveerr = RepositoryResource.getStringResource("saveerr.txt");
    private static final String selecterr = RepositoryResource.getStringResource("selecterr.txt");
    private static final String openerr = RepositoryResource.getStringResource("openerr.txt");
    private static final String saveerr2 = RepositoryResource.getStringResource("saveerr2.txt");
    private static final String selecterr2 = RepositoryResource.getStringResource("selecterr2.txt");
    private static final String openerr2 = RepositoryResource.getStringResource("openerr2.txt");
    private static final String duplicateErr = RepositoryResource.getStringResource("duplicateErr.txt");
    private static final String illegalErr = RepositoryResource.getStringResource("illegalErr.txt");
    private static final String replocerr = RepositoryResource.getStringResource("replocerr.txt");
    private static final String delerr2 = RepositoryResource.getStringResource("delerr2.txt");
    private static final String invalidViewSelection = RepositoryResource.getStringResource("OpenSaveDialoginvalidViewSelection.txt");
    private static final String fileNameEmpty = RepositoryResource.getStringResource("OpenSaveDialogfileNameEmpty.txt");
    private static final String errorStr = RepositoryResource.getStringResource("errorStr.txt");
    private static final String nullStr = RepositoryResource.getStringResource("nullFile.txt");
    private static final String verifyStr = RepositoryResource.getStringResource("verifyStr.txt");
    private static final String doesNotExist = RepositoryResource.getStringResource("doesNotExist.txt");
    private static final String _sstr = RepositoryResource.getStringResource("saveStr.txt");
    private static final String saveMnemonic = RepositoryResource.getStringResource("saveKeymnem.txt");
    private static final String _selstr = RepositoryResource.getStringResource("selectStr.txt");
    private static final String saveStr = "  " + _sstr + " ";
    private static final String _ostr = RepositoryResource.getStringResource("openStr.txt");
    private static final String openStr = "  " + _ostr + " ";
    private static final String selectStr = "  " + _selstr + " ";
    private static final String openMnemonic = RepositoryResource.getStringResource("openKeymnem.txt");
    private static final String selectMnemonic = RepositoryResource.getStringResource("selectKeymnem.txt");
    private static final String fileNameMne = RepositoryResource.getStringResource("OpenSaveDialogsaveFileMne.txt");
    private static final String fileTypeMne = RepositoryResource.getStringResource("OpenSaveDialogtypeChoiceMne.txt");
    private static final String choiceMne = RepositoryResource.getStringResource("OpenSaveDialogchoiceMne.txt");
    private static final String notThereYet = RepositoryResource.getStringResource("notThereYet.txt");
    private static final String notAvailable = RepositoryResource.getStringResource("notAvailable.txt");
    private static final String _fstr = RepositoryResource.getStringResource("OpenSaveDialogsaveFileString.txt");
    private static final String saveFileString = "   " + _fstr + "    ";
    private static final String errorURL = RepositoryResource.getStringResource("errorURL.txt");
    private static final String choiceString = RepositoryResource.getStringResource("OpenSaveDialogchoiceString.txt");
    private static final String _tstr = RepositoryResource.getStringResource("OpenSaveDialogtypeChoiceString.txt");
    private static final String typeChoiceString = "   " + _tstr + "       ";
    private static final String findToolText = RepositoryResource.getStringResource("OpenSaveDialogfindToolText.txt");
    private static final String cboxToolText = RepositoryResource.getStringResource("OpenSaveDialogcboxToolText.txt");
    private static final String backToolText = RepositoryResource.getStringResource("OpenSaveDialogbackToolText.txt");
    private static final String upOneLevelToolText = RepositoryResource.getStringResource("OpenSaveDialogupOneLevelToolText.txt");
    private static final String newFolderToolText = RepositoryResource.getStringResource("OpenSaveDialognewFolderToolText.txt");
    private static final String fileToolText = RepositoryResource.getStringResource("OpenSaveDialogfileToolText.txt");
    private static final String repToolText = RepositoryResource.getStringResource("OpenSaveDialogrepToolText.txt");
    private static final String typeToolText = RepositoryResource.getStringResource("OpenSaveDialogtypeToolText.txt");
    private static final String rrConnectErrorTitle = RepositoryResource.getStringResource("rrConnectErrorTitle.txt");
    private static final String rrConnectErrorMessage1 = RepositoryResource.getStringResource("rrConnectErrorMessage1.txt");
    private static final String fileStr = RepositoryResource.getStringResource("fileStr.txt");
    private static final String repStr = RepositoryResource.getStringResource("repStr.txt");
    private String dot = ".";
    private String sep = "/";
    private String sep2 = "\\";
    private static final String trstr = RepositoryResource.getStringResource("List.txt");
    private static final String dstr = RepositoryResource.getStringResource("Detail.txt");
    private String[] listTypeString = new String[]{trstr, dstr};
    private String folderStr = RepositoryResource.getStringResource("folderStr.txt");
    private static final String[] typeChoice = new String[]{RepositoryResource.getStringResource("XMLFStr.txt"), RepositoryResource.getStringResource("storeStr.txt"), RepositoryResource.getStringResource("IQStr.txt"), RepositoryResource.getStringResource("ERPFStr.txt"), RepositoryResource.getStringResource("ERFFStr.txt"), RepositoryResource.getStringResource("HTMLStr.txt"), RepositoryResource.getStringResource("PCKFStr.txt"), RepositoryResource.getStringResource("gifFStr.txt"), RepositoryResource.getStringResource("JPEGStr.txt"), RepositoryResource.getStringResource("PDFStr.txt"), RepositoryResource.getStringResource("TIFStr.txt"), RepositoryResource.getStringResource("allFStr.txt")};
    private static final String[] typeChoiceValue = new String[]{RepositoryResource.getStringResource("xmlType.txt"), RepositoryResource.getStringResource("storeType.txt"), RepositoryResource.getStringResource("iqType.txt"), RepositoryResource.getStringResource("erpType.txt"), RepositoryResource.getStringResource("erfType.txt"), RepositoryResource.getStringResource("htmlType.txt"), RepositoryResource.getStringResource("pckType.txt"), RepositoryResource.getStringResource("gifType.txt"), RepositoryResource.getStringResource("jpegType.txt"), RepositoryResource.getStringResource("pdfType.txt"), RepositoryResource.getStringResource("tifType.txt"), RepositoryResource.getStringResource("allFStr.txt")};
    private static final String[] typeChoiceExt = new String[]{"xml", "", "", "erp", "erf", "html", "", "gif", "jpeg", "pdf", "tif", "*"};
    private String dialogTypeString;
    private String dialogTypeMnemonic;
    private String userName;
    private String passWord;
    private String sessionId;
    private String folderSelected = null;
    private JPanel saveFilePanelTop;
    private JTextField fileNameField;
    private int change;
    private int indexInt;
    private int typeOfRep = 1;
    private int typeDialog;
    private boolean wasSuccess;
    private boolean isRepository;
    private ImageIcon listIcon;
    private ImageIcon go_toIcon;
    private ImageIcon findIcon;
    private ImageIcon openIcon;
    private ImageIcon helpIcon;
    private ImageIcon treeIcon;
    private ImageIcon detailIcon;
    private ImageIcon erpIcon;
    private ImageIcon newFolderIcon;
    private ImageIcon backIcon;
    private ImageIcon upOneLevelIcon;
    private ImageIcon[] images;
    private JMenuItem menuEntryProperty;
    private Vector repRootVector;
    private Object[] selectionListObject;
    private JComboBox repositoryChoices;
    private JPopupMenu popupMenu;
    private JTextField changeField;
    private JSplitPane splitPane;
    private JPanel selectPanel;
    private JPanel saveFilePanel;
    private JPanel choicePanel;
    private JPanel dialogPanel;
    private JPanel contentPaneSub;
    private JPanel subContentPane;
    private JScrollPane treePanel;
    private JScrollPane tablePanel1;
    private JScrollPane tablePanel2;
    private JComboBox typeChoices;
    private JComboBox viewTableChoice;
    private JButton backButton;
    private JButton upOneLevelButton;
    private JButton newFolderButton;
    private JButton actionButton;
    private MouseEvent treeEvent;
    private GenericTableAccess tableView;
    private OpenSavePopup popupForDialog;
    private boolean dontUpdateChoiceList;

    public OpenSaveDialog(Frame parent, String sessionId, int typeOfDialog, String titleOfDialog) {
        super(parent, sessionId);
        this.init(parent, typeOfDialog, titleOfDialog);
    }

    public OpenSaveDialog(Frame parent, String sessionId, int typeOfDialog) {
        super(parent, sessionId);
        this.init(parent, typeOfDialog, null);
    }

    public OpenSaveDialog(Frame parent, int typeOfDialog, String titleOfDialog) {
        super(parent);
        this.init(parent, typeOfDialog, titleOfDialog);
    }

    public OpenSaveDialog(Frame parent, int typeOfDialog) {
        super(parent);
        this.init(parent, typeOfDialog, null);
    }

    private void init(Frame parent, int typeOfDialog, String titleOfDialog) {
        ResourceBundle bundle = RepositoryResource.getResources();
        if (this.repositoryInfo == null) {
            String _okStr = RepositoryResource.getStringResource("cantOpenDialog.txt") + "        ";
            JLabel _errorLabel = new JLabel(_okStr);
            JButton _endButton = new JButton(RepositoryResource.getStringResource("ok.txt"));
            _endButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent okButtonEvent) {
                    OpenSaveDialog.this.onCancel();
                    OpenSaveDialog.this.dispose();
                }
            });
            ImageIcon warning = ImageHandler.getImageIcon(bundle, "Warning.image");
            _errorLabel.setIcon(warning);
            JPanel _bPane = new JPanel();
            _bPane.setLayout(new BoxLayout(_bPane, 0));
            _bPane.add(Box.createVerticalStrut(15));
            _bPane.add(_endButton);
            JPanel _endContentPane = new JPanel();
            _endContentPane.setLayout(new BoxLayout(_endContentPane, 1));
            _endContentPane.add(Box.createVerticalStrut(25));
            _endContentPane.add(_errorLabel);
            _endContentPane.add(Box.createVerticalStrut(15));
            _endContentPane.add(_bPane);
            _endButton.requestFocus();
            this.setContentPane(_endContentPane);
            this.pack();
            return;
        }
        this.messager = this.repositoryInfo.getMessager();
        this.listIcon = ImageHandler.getImageIcon(bundle, "list.image");
        this.findIcon = ImageHandler.getImageIcon(bundle, "find.image");
        this.openIcon = ImageHandler.getImageIcon(bundle, "open.image");
        this.helpIcon = ImageHandler.getImageIcon(bundle, "help.image");
        this.detailIcon = ImageHandler.getImageIcon(bundle, "detail.image");
        this.treeIcon = ImageHandler.getImageIcon(bundle, "tree.image");
        this.erpIcon = ImageHandler.getImageIcon(bundle, "erp.image");
        this.newFolderIcon = ImageHandler.getImageIcon(bundle, "newfolder.image");
        this.backIcon = ImageHandler.getImageIcon(bundle, "goback.image");
        this.upOneLevelIcon = ImageHandler.getImageIcon(bundle, "goup.image");
        JButton _findButton = new JButton(this.findIcon);
        _findButton.setPreferredSize(new Dimension(30, 30));
        this.backButton = new JButton(this.backIcon);
        this.newFolderButton = new JButton(this.newFolderIcon);
        this.upOneLevelButton = new JButton(this.upOneLevelIcon);
        this.backButton.setPreferredSize(new Dimension(30, 30));
        this.newFolderButton.setPreferredSize(new Dimension(30, 30));
        this.upOneLevelButton.setPreferredSize(new Dimension(30, 30));
        JToolBar _toolBar = new JToolBar();
        _toolBar.add(this.backButton);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent backEvent) {
                OpenSaveDialog.this.goBack();
            }
        });
        _toolBar.add(this.upOneLevelButton);
        this.upOneLevelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent upOneLevelEvent) {
                OpenSaveDialog.this.upOneLevel();
            }
        });
        _toolBar.addSeparator();
        this.images = new ImageIcon[this.listTypeString.length];
        for (int i = 0; i < this.listTypeString.length; ++i) {
            this.images[i] = i == 1 ? ImageHandler.getImageIcon(bundle, "list.image") : ImageHandler.getImageIcon(bundle, "detail.image");
            this.images[i].setDescription(this.listTypeString[i]);
        }
        this.viewTableChoice = new JComboBox<ImageIcon>(this.images);
        this.viewTableChoice.setEditable(false);
        this.viewTableChoice.setBackground(Color.lightGray);
        this.viewTableChoice.setBorder(BorderFactory.createRaisedBevelBorder());
        ComboCellRenderer renderer = new ComboCellRenderer();
        renderer.setPreferredSize(new Dimension(50, 23));
        this.viewTableChoice.setRenderer(renderer);
        this.viewTableChoice.setMaximumRowCount(3);
        this.viewTableChoice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent cboxEvent) {
                int sel = OpenSaveDialog.this.viewTableChoice.getSelectedIndex();
                try {
                    OpenSaveDialog.this.setTableView(sel, false);
                }
                catch (InvalidSelectionException invalidSelectionException) {
                    // empty catch block
                }
            }
        });
        _toolBar.add(this.newFolderButton);
        this.newFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent newFolderEvent) {
                OpenSaveDialog.this.newFolder();
            }
        });
        _toolBar.add(this.viewTableChoice);
        _toolBar.add(_findButton);
        _findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent findEvent) {
                OpenSaveDialog.this.findEntry();
            }
        });
        this.typeChoices = new JComboBox<String>(typeChoice);
        OpenSaveDialog.fixupJComboBox(this.typeChoices);
        int itemsInChoices = this.typeChoices.getItemCount();
        this.typeChoices.setSelectedIndex(itemsInChoices - 1);
        JLabel _typeChoiceLabel = new JLabel(typeChoiceString);
        this.setLabelMnemonic(_typeChoiceLabel, fileTypeMne);
        _typeChoiceLabel.setLabelFor(this.typeChoices);
        this.typeChoices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent menuTypeChoices) {
                OpenSaveDialog.this.setFilter();
            }
        });
        this.setResizable(false);
        this.typeDialog = typeOfDialog;
        if (typeOfDialog == 1) {
            this.dialogTypeString = saveStr;
            this.dialogTypeMnemonic = saveMnemonic;
        } else if (typeOfDialog == 2) {
            this.dialogTypeString = selectStr;
            this.dialogTypeMnemonic = selectMnemonic;
        } else {
            this.dialogTypeString = openStr;
            this.dialogTypeMnemonic = openMnemonic;
        }
        if (titleOfDialog == null) {
            titleOfDialog = this.dialogTypeString;
        }
        this.setTitle(titleOfDialog);
        this.fileNameField = new JTextField(20);
        JLabel _saveFileLabel = new JLabel(saveFileString);
        this.setLabelMnemonic(_saveFileLabel, fileNameMne);
        _saveFileLabel.setLabelFor(this.fileNameField);
        this.saveFilePanelTop = new JPanel(new BorderLayout());
        this.saveFilePanelTop.add((Component)_saveFileLabel, "West");
        this.saveFilePanelTop.add((Component)this.fileNameField, "Center");
        JPanel _saveFilePanelBottom = new JPanel(new BorderLayout());
        _saveFilePanelBottom.add((Component)_typeChoiceLabel, "West");
        _saveFilePanelBottom.add((Component)this.typeChoices, "Center");
        this.setGenericAction(this.dialogTypeString, this.dialogTypeMnemonic);
        this.actionButton = this.getStdButton();
        JButton _cancel = this.getCancelButton();
        this.actionButton.setDefaultCapable(true);
        JPanel _saveFileLeft = new JPanel();
        _saveFileLeft.setLayout(new BoxLayout(_saveFileLeft, 1));
        _saveFileLeft.add(this.saveFilePanelTop);
        _saveFileLeft.add(Box.createVerticalStrut(8));
        _saveFileLeft.add(_saveFilePanelBottom);
        JPanel _saveFileRight = new JPanel();
        _saveFileRight.setLayout(new BoxLayout(_saveFileRight, 1));
        _saveFileRight.add(this.actionButton);
        _saveFileRight.add(Box.createVerticalStrut(8));
        _saveFileRight.add(_cancel);
        JPanel _saveFilePanel1 = new JPanel(new BorderLayout());
        _saveFilePanel1.add((Component)_saveFileLeft, "West");
        _saveFilePanel1.add((Component)_saveFileRight, "East");
        JToggleButton _emptyButton = new JToggleButton("  ");
        _emptyButton.setBorder(BorderFactory.createEmptyBorder());
        this.saveFilePanel = new JPanel(new BorderLayout());
        this.saveFilePanel.add((Component)_saveFilePanel1, "South");
        this.saveFilePanel.add((Component)_emptyButton, "North");
        this.choiceList = new Vector();
        this.dirList = new Vector();
        this.choiceList.addElement(repsstr);
        this.dirList.addElement(repsstr);
        this.repositoryChoices = new JComboBox(this.choiceList);
        this.change = this.repositoryChoices.getSelectedIndex();
        OpenSaveDialog.fixupJComboBox(this.repositoryChoices);
        this.repositoryChoices.setPreferredSize(new Dimension(220, 23));
        this.dontUpdateChoiceList = false;
        this.repositoryChoices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent repositoryChoicesEvent) {
                JComboBox _cb = (JComboBox)repositoryChoicesEvent.getSource();
                if (!OpenSaveDialog.this.dontUpdateChoiceList) {
                    OpenSaveDialog.this.setRepoChoice(_cb);
                }
            }
        });
        _saveFileLabel.setToolTipText(fileToolText);
        _findButton.setToolTipText(findToolText);
        this.viewTableChoice.setToolTipText(cboxToolText);
        this.backButton.setToolTipText(backToolText);
        this.upOneLevelButton.setToolTipText(upOneLevelToolText);
        this.newFolderButton.setToolTipText(newFolderToolText);
        this.repositoryChoices.setToolTipText(repToolText);
        this.typeChoices.setToolTipText(typeToolText);
        JLabel _choiceLabel = new JLabel(choiceString);
        this.setLabelMnemonic(_choiceLabel, choiceMne);
        _choiceLabel.setLabelFor(this.repositoryChoices);
        this.choicePanel = new JPanel();
        GridBagConstraints _gridC = new GridBagConstraints();
        this.choicePanel.setLayout(new GridBagLayout());
        _gridC.gridx = 0;
        _gridC.anchor = 11;
        _gridC.gridy = 0;
        _gridC.gridwidth = 1;
        _gridC.gridheight = 1;
        _gridC.weightx = 100.0;
        _gridC.weighty = 100.0;
        this.choicePanel.add((Component)_choiceLabel, _gridC);
        _gridC.gridx = 7;
        _gridC.anchor = 11;
        this.choicePanel.add((Component)this.repositoryChoices, _gridC);
        _gridC.gridx = 8;
        _gridC.gridwidth = 4;
        _gridC.anchor = 13;
        _gridC.gridheight = 2;
        this.choicePanel.add((Component)_toolBar, _gridC);
        this.setTitle(titleOfDialog);
        this.tableView = new GenericTableAccess(this.repositoryInfo, this, 0);
        this.repositoryChoices.setSelectedIndex(0);
        this.popupForDialog = new OpenSavePopup(this.repositoryInfo, this.tableView, this);
        this.dialogPanel = new JPanel(new BorderLayout());
        JPopupMenu _overview = this.popupForDialog.getPopup(1);
        this.tableView.setOpenSavePopup(this.popupForDialog);
        this.tablePanel1 = this.tableView.getPanel();
        OpenSaveDialog.setScrollPane(this.tablePanel1);
        this.tablePanel1.add(_overview);
        this.tablePanel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    MouseEvent _tableMouseEvent = event;
                    OpenSaveDialog.this.tableView.showPopup(1, _tableMouseEvent);
                }
            }
        });
        this.tablePanel1.setPreferredSize(new Dimension(450, 200));
        this.tablePanel1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.subContentPane = new JPanel();
        this.subContentPane.setLayout(new BorderLayout());
        this.subContentPane.add((Component)this.saveFilePanel, "South");
        this.subContentPane.add((Component)this.tablePanel1, "North");
        this.contentPaneSub = new JPanel();
        this.contentPaneSub.setLayout(new BorderLayout());
        this.contentPaneSub.add((Component)this.subContentPane, "Center");
        this.fileNameField.requestFocus();
        this.dialogPanel.add((Component)this.contentPaneSub, "South");
        this.dialogPanel.add((Component)this.choicePanel, "North");
        this.setNavigators(false);
        this.fileNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent saveFileKeyEvent) {
                if (OpenSaveDialog.this.fileNameField.hasFocus()) {
                    String _value;
                    boolean _isRowSelected = OpenSaveDialog.this.tableView.isRowSelected();
                    if (saveFileKeyEvent.getKeyCode() == 127 && _isRowSelected) {
                        OpenSaveDialog.this.deleteEntry();
                    } else if (saveFileKeyEvent.getKeyCode() == 34) {
                        OpenSaveDialog.this.tableView.scroll("D");
                    } else if (saveFileKeyEvent.getKeyCode() == 33) {
                        OpenSaveDialog.this.tableView.scroll("U");
                    } else if (saveFileKeyEvent.getKeyCode() == 47) {
                        OpenSaveDialog.this.actionButton.setEnabled(true);
                    } else if (saveFileKeyEvent.getKeyCode() == 27) {
                        OpenSaveDialog.this.onCancel();
                        OpenSaveDialog.this.dispose();
                    } else if (saveFileKeyEvent.getKeyCode() == 10 && (_value = OpenSaveDialog.this.fileNameField.getText()).length() > 0) {
                        OpenSaveDialog.this.setBusyCursor(true);
                        if (_value.indexOf(OpenSaveDialog.this.sep2) != -1 || _value.indexOf(OpenSaveDialog.this.sep) != -1) {
                            try {
                                OpenSaveDialog.this.slashedFileName(_value);
                            }
                            catch (SlashFileException e) {
                                OpenSaveDialog.this.setBusyCursor(false);
                            }
                        } else {
                            OpenSaveDialog.this.onStdAction();
                        }
                        OpenSaveDialog.this.setBusyCursor(false);
                    }
                }
            }
        });
        this.setContentPane(this.dialogPanel);
        this.pack();
    }

    private void setFilter() {
        int typeChoiceSelected = this.typeChoices.getSelectedIndex();
        String extension = typeChoiceValue[typeChoiceSelected];
        this.repositoryInfo.setFilter(extension);
        this.setBusyCursor(true);
        String _selectedArea = this.repositoryInfo.getCurrentPathName();
        if (_selectedArea.equals("")) {
            _selectedArea = null;
        }
        if (_selectedArea == null) {
            this.setBusyCursor(false);
            return;
        }
        Vector _refreshTable = this.repositoryInfo.setCurrentLocation(_selectedArea);
        this.tableView.setTableData(_refreshTable);
        this.setBusyCursor(false);
    }

    private void deleteEntry() {
        this.setBusyCursor(true);
        Vector<String> fileNames = null;
        Vector<String> storeRows = null;
        boolean _isDeleteAll = false;
        boolean _isRowsSelected = this.tableView.isMultipleRowsSelected();
        if (_isRowsSelected) {
            fileNames = this.tableView.getTableSelections();
            storeRows = this.tableView.getTableRowsSelected();
        } else {
            fileNames = new Vector<String>();
            storeRows = new Vector<String>();
            String enteredFileName = this.tableView.getTableSelection();
            int _row = this.tableView.getTableRowSelection();
            fileNames.add(enteredFileName);
            String _i = null;
            _i = String.valueOf(_row);
            storeRows.add(_i);
        }
        Vector _toDelete = new Vector();
        for (int _rowI = 0; _rowI < storeRows.size(); ++_rowI) {
            boolean _isDel;
            String _stringValue = fileNames.get(_rowI).toString();
            String[] _argString = new String[]{_stringValue};
            String _message = RepositoryResource.getMessageString("areYouSureStr.txt", 1, _argString);
            Object[] options = new Object[]{RepositoryResource.getStringResource("delone.txt"), RepositoryResource.getStringResource("delall.txt"), RepositoryResource.getStringResource("delno.txt")};
            int _result = 0;
            if (!_isDeleteAll) {
                _result = JOptionPane.showOptionDialog(this, _message, verifyStr, -1, 2, null, options, options[0]);
            }
            _isDeleteAll = _isDel = this.setDeletion(_result, _stringValue, storeRows, _isDeleteAll, _toDelete, _argString, _rowI, options);
        }
        this.tableView.deleteEntry(_toDelete);
        this.refresh();
        this.setBusyCursor(false);
    }

    private void slashedFileName(String theName) throws SlashFileException {
        boolean _isAValid1;
        int _sla;
        String _repName;
        if (theName.equals("")) {
            return;
        }
        if (theName == null) {
            return;
        }
        String _repProto = null;
        String _fullSelName = theName;
        boolean _repositoryFound = false;
        boolean _repositoryOnly = false;
        boolean _noFrontSlash = false;
        String _firstPartOfName = theName;
        if (theName.indexOf(this.sep2) != -1) {
            theName = theName.replace('\\', '/');
        }
        if ((_repName = this.repositoryInfo.getPathURL()) == null) {
            _repName = this.repositoryInfo.getFullRepositoryName();
        }
        if ((_sla = theName.substring(1).indexOf("/")) != -1) {
            if (theName.substring(0, 1).equals("/")) {
                _firstPartOfName = theName.substring(1, _sla + 1);
            } else {
                _firstPartOfName = theName.substring(0, _sla + 1);
                _noFrontSlash = true;
            }
        } else if (theName.substring(0, 1).equals("/")) {
            _firstPartOfName = theName.substring(1);
        } else {
            _noFrontSlash = true;
        }
        Vector _listOfRepositories = this.repositoryInfo.getRepositories();
        if (_listOfRepositories == null) {
            this.messager.error(rrConnectErrorMessage1);
            throw new SlashFileException();
        }
        _repositoryFound = _listOfRepositories.contains(_firstPartOfName);
        _repProto = this.repositoryInfo.getRepositoryProtocol();
        if (_repName == null) {
            if (_repositoryFound) {
                _repName = _firstPartOfName;
            }
            if (_repName == null) {
                String[] _argString = new String[]{theName};
                String _message = RepositoryResource.getMessageString("replocerr.txt", 1, _argString);
                this.showErrDialog(_message, rrConnectErrorTitle);
                this.fileNameField.setCaretPosition(0);
                this.fileNameField.selectAll();
                this.setDefaultFocus();
                throw new SlashFileException();
            }
            String _repositoryTemp = _repName;
            _repName = _repProto + "//" + _repName;
            boolean _isAValidRepository = this.repositoryInfo.checkLocation(_repName + "/BIP Tree");
            if (!_isAValidRepository) {
                _repProto = "SRRP:";
                _repName = "SRRP://" + _repositoryTemp + "/";
                this.messager.error(RepositoryResource.getStringResource("OpenSaveDialogSRRPerror.txt"));
            }
        } else if (_repositoryFound && !(_isAValid1 = this.repositoryInfo.checkLocation(_repProto + "//" + _firstPartOfName + "/"))) {
            _repProto = "SRRP:";
            this.messager.error(RepositoryResource.getStringResource("OpenSaveDialogSRRPerror.txt"));
        }
        if (theName.indexOf(this.sep) != -1) {
            boolean _isAValid;
            if (!_noFrontSlash) {
                _fullSelName = _repositoryFound ? _repProto + "/" + theName : _repName + theName;
            } else if (_noFrontSlash) {
                _fullSelName = _repositoryFound ? _repProto + "//" + theName : _repName + "/" + theName;
            }
            if (theName.equals(this.sep)) {
                Vector _tv = new Vector();
                _tv = this.repositoryInfo.getRepositoryFolders();
                this.tableView.setTableData(_tv);
                this.setChoiceAtTop();
                return;
            }
            if (_fullSelName.endsWith("/")) {
                _fullSelName = _fullSelName.substring(0, _fullSelName.length() - 1);
            }
            if (_repositoryFound && !(_isAValid = this.repositoryInfo.checkLocation(_fullSelName))) {
                _fullSelName = _fullSelName + "/";
            }
            try {
                this.setCurrentLocation(_fullSelName);
            }
            catch (InvalidLocationException ex) {
                this.messager.error(rrConnectErrorMessage1);
                throw new SlashFileException();
            }
        }
    }

    private void getFullFileNameExt() {
        String _saveName = this.fileNameField.getText().trim();
        if ((_saveName = this.checkBlank(_saveName)).equals("")) {
            return;
        }
        String _type = "";
        String _typeStr = typeChoiceExt[0];
        if (this.typeDialog != 1) {
            Vector _types = this.repositoryInfo.getTypeData();
            int rowIndex = this.tableView.getTableRowSelection();
            if (rowIndex != -1) {
                _type = _types.get(rowIndex).toString();
            }
            if (_type.equals(RepositoryResource.getStringResource("gifType.txt"))) {
                _typeStr = typeChoiceExt[7];
            } else if (_type.equals(RepositoryResource.getStringResource("htmlType.txt"))) {
                _typeStr = typeChoiceExt[5];
            } else if (_type.equals(RepositoryResource.getStringResource("erpType.txt"))) {
                _typeStr = typeChoiceExt[3];
            } else if (_type.equals(RepositoryResource.getStringResource("erfType.txt"))) {
                _typeStr = typeChoiceExt[4];
            } else if (_type.equals(RepositoryResource.getStringResource("pdfType.txt"))) {
                _typeStr = typeChoiceExt[9];
            } else if (_type.equals(RepositoryResource.getStringResource("tifType.txt"))) {
                _typeStr = typeChoiceExt[10];
            } else if (_type.equals(RepositoryResource.getStringResource("pckType.txt"))) {
                _typeStr = typeChoiceExt[6];
            } else if (_type.equals(RepositoryResource.getStringResource("jpegType.txt"))) {
                _typeStr = typeChoiceExt[8];
            } else if (_type.equals(RepositoryResource.getStringResource("iqType.txt"))) {
                _typeStr = "";
            } else if (_type.equals(RepositoryResource.getStringResource("storeType.txt"))) {
                _typeStr = "";
            }
        } else {
            int _typeIndex = this.typeChoices.getSelectedIndex();
            _typeStr = typeChoiceExt[_typeIndex];
            if (_typeStr.equals("*")) {
                _typeStr = typeChoiceExt[0];
            }
            if (_typeIndex > typeChoiceExt.length - 1) {
                this.fileNameField.setText(_saveName);
                return;
            }
        }
        if (_saveName.indexOf(this.dot) == -1) {
            if (_typeStr.length() > 0) {
                this.fileNameField.setText(_saveName + this.dot + _typeStr);
            } else {
                this.fileNameField.setText(_saveName);
            }
        }
    }

    private void newFolder() {
        this.setBusyCursor(true);
        this.tableView.addFolder();
        this.refresh();
        this.setBusyCursor(false);
    }

    private void goBack() {
        int _sel = this.choiceList.size() - 2;
        if (_sel < 0) {
            _sel = 0;
        }
        Vector _tv = new Vector();
        String _Item = (String)this.dirList.get(_sel);
        if (_sel == 0) {
            _tv = this.repositoryInfo.getRepositoryFolders();
        } else {
            this.setBusyCursor(true);
            try {
                this.repositoryInfo.updateFolderData(_tv, _Item, true);
            }
            catch (Exception exc) {
                String[] _argString = new String[]{_Item};
                String _message = RepositoryResource.getMessageString("selerr1.txt", 1, _argString);
                this.showErrDialog(_message, selerr2);
            }
            this.setBusyCursor(false);
        }
        this.tableView.setTableData(_tv);
        int _end = this.choiceList.size() - 1;
        this.choiceList.removeElementAt(_end);
        this.dirList.removeElementAt(_end);
        this.dontUpdateChoiceList = true;
        this.repositoryChoices.setSelectedIndex(_end - 1);
        this.dontUpdateChoiceList = false;
        if (this.repositoryChoices.getSelectedIndex() == 0) {
            this.setNavigators(false);
        }
    }

    private void setRepoChoice(JComboBox cb) {
        if (cb.getSelectedIndex() != this.change) {
            int _sel = this.repositoryChoices.getSelectedIndex();
            if (_sel == -1) {
                return;
            }
            Vector _tv = new Vector();
            String _Item = (String)this.dirList.get(_sel);
            if (_sel == 0) {
                _tv = this.repositoryInfo.getRepositoryFolders();
            } else {
                this.setBusyCursor(true);
                try {
                    this.repositoryInfo.updateFolderData(_tv, _Item, true);
                }
                catch (Exception exc) {
                    String[] _argString = new String[]{_Item};
                    String _message = RepositoryResource.getMessageString("selerr1.txt", 1, _argString);
                    this.showErrDialog(_message, selerr2);
                }
                this.setBusyCursor(false);
            }
            this.tableView.setTableData(_tv);
            int _start = _sel + 1;
            int _end = this.choiceList.size();
            for (int i = _start; i < _end; ++i) {
                this.choiceList.removeElementAt(i);
                this.dirList.removeElementAt(i);
                --_end;
                --i;
            }
            this.change = _sel;
            cb.setSelectedIndex(_sel);
        }
        if (cb.getSelectedIndex() == 0) {
            this.setNavigators(false);
        }
    }

    private void upOneLevel() {
        String _item1;
        String _currentLocation = this.repositoryInfo.getCurrentLocation();
        String _check = _item1 = this.repositoryInfo.getPathURL();
        int _locationOfThere = this.dirList.indexOf(_check);
        String _parent = null;
        try {
            _parent = this.repositoryInfo.getParent();
        }
        catch (Exception ex) {
            _parent = null;
        }
        Vector _tv = new Vector();
        if (_parent == null) {
            _tv = this.repositoryInfo.getRepositoryFolders();
            this.setNavigators(false);
        } else {
            this.setBusyCursor(true);
            try {
                this.repositoryInfo.updateFolderData(_tv, _parent, true);
            }
            catch (Exception exc) {
                String[] _argString = new String[]{_parent};
                String _message = RepositoryResource.getMessageString("selerr1.txt", 1, _argString);
                this.showErrDialog(_message, selerr2);
            }
            this.setBusyCursor(false);
        }
        if (_locationOfThere != -1) {
            this.choiceList.removeElementAt(_locationOfThere);
            this.dirList.removeElementAt(_locationOfThere);
            if (this.repositoryInfo != null) {
                if (_item1 != null) {
                    String _item2 = this.repositoryInfo.getCurrentEntryName();
                    if (_item2 != null) {
                        if (_item2.equals("")) {
                            _item2 = _item1;
                        }
                        this.addFolder(_item2, _item1);
                        int _end = this.choiceList.size() - 1;
                        this.dontUpdateChoiceList = true;
                        this.repositoryChoices.setSelectedIndex(_end);
                        this.dontUpdateChoiceList = false;
                    }
                } else {
                    this.setChoiceAtTop();
                }
            } else {
                this.setChoiceAtTop();
            }
            if (this.repositoryChoices.getSelectedIndex() == 0) {
                this.setNavigators(false);
            }
        }
        this.tableView.setTableData(_tv);
    }

    public int getDialogType() {
        if (this.typeDialog == 0) {
            return 0;
        }
        if (this.typeDialog == 1) {
            return 1;
        }
        return 2;
    }

    protected void setNavigators(boolean isEnable) {
        this.backButton.setEnabled(isEnable);
        this.upOneLevelButton.setEnabled(isEnable);
        this.newFolderButton.setEnabled(isEnable);
        this.actionButton.setEnabled(isEnable);
    }

    @Override
    protected void addFolder(String newFolder, String folderLocation) {
        this.choiceList.addElement(newFolder);
        this.dirList.addElement(folderLocation);
        this.change = this.choiceList.size() - 1;
        int _sel = this.choiceList.size() - 1;
        this.repositoryChoices.setSelectedIndex(_sel);
        this.setNavigators(true);
    }

    protected void setChoiceType(int _select) {
        this.repositoryChoices.setSelectedIndex(_select);
    }

    public boolean isValidLocation(String location) {
        boolean _isValid = this.repositoryInfo.checkLocation(location);
        return _isValid;
    }

    public void setCurrentLocation(String location) throws InvalidLocationException {
        if (this.repositoryInfo == null) {
            this.messager.error(RepositoryResource.getStringResource("rrIsNull.txt"));
            throw new InvalidLocationException();
        }
        String _olddir = this.repositoryInfo.getCurrentPathName();
        Vector _dl = this.repositoryInfo.setCurrentLocation(location);
        String _colname = "";
        if (_dl.size() > 0) {
            Vector _top = (Vector)_dl.get(0);
            _colname = _top.get(0).toString();
        }
        if (_colname.equals(rrConnectErrorMessage1)) {
            if (_olddir != "") {
                _dl = this.repositoryInfo.setCurrentLocation(_olddir);
            }
            String[] _argString = new String[]{location};
            String _message = RepositoryResource.getMessageString("replocerr.txt", 1, _argString);
            this.showErrDialog(_message, rrConnectErrorTitle);
            this.fileNameField.setCaretPosition(0);
            this.fileNameField.selectAll();
            this.setDefaultFocus();
            throw new InvalidLocationException();
        }
        this.tableView.setTableData(_dl);
        String _item1 = this.repositoryInfo.getCurrentEntry().toString();
        String _item2 = this.repositoryInfo.getCurrentEntryName();
        if (_item2.equals("")) {
            _item2 = _item1;
        }
        this.addFolder(_item2, _item1);
        this.setNavigators(true);
    }

    @Override
    protected void finish() {
        this.setBusyCursor(true);
        boolean _wasCancelled = this.wasCancelled();
        boolean _canFinish = true;
        String _errorTitle = this.typeDialog == 1 ? saveerr : (this.typeDialog == 0 ? openerr : selecterr);
        if (!_wasCancelled) {
            this.fileName = this.getDefaultFocusText();
            this.fileName = this.checkBlank(this.fileName);
            int _hasExt = this.fileName.indexOf(this.dot);
            String _typeStr = this.typeLabels.get(0).toString();
            if (_hasExt == -1) {
                if (this.typeDialog == 1) {
                    int _typeIndex = this.typeChoices.getSelectedIndex();
                    _typeStr = this.typeLabels.get(_typeIndex).toString();
                } else {
                    Vector _types = this.repositoryInfo.getTypeData();
                    int rowIndex = this.tableView.getTableRowSelection();
                    _typeStr = _types.get(rowIndex).toString();
                }
            } else {
                _typeStr = this.fileName.substring(_hasExt + 1);
                int _place = this.typePointers.indexOf(_typeStr);
                if (_place != -1) {
                    _typeStr = this.typeLabels.get(_place).toString();
                } else if (this.typeDialog == 1) {
                    _typeStr = RepositoryResource.getStringResource("unsupportedType.txt");
                } else {
                    Vector _types = this.repositoryInfo.getTypeData();
                    int rowIndex = this.tableView.getTableRowSelection();
                    _typeStr = _types.get(rowIndex).toString();
                }
            }
            if (this.fileName.indexOf(this.sep) != -1) {
                String _location = this.fileName.substring(0, this.fileName.lastIndexOf(this.sep));
                String _fileSection = this.fileName.substring(this.fileName.lastIndexOf(this.sep) + 1);
                this.setBusyCursor(true);
                try {
                    this.slashedFileName(_location);
                }
                catch (SlashFileException ex) {
                    this.messager.error(rrConnectErrorMessage1);
                    _canFinish = false;
                    this.setBusyCursor(false);
                    return;
                }
                this.setBusyCursor(false);
                if (_fileSection != null) {
                    this.fileName = _fileSection;
                    this.setDefaultFocusText(this.fileName);
                } else {
                    _canFinish = false;
                    return;
                }
            }
            Object[] args = new Object[]{new String(this.fileName)};
            String[] _argString = new String[]{this.fileName};
            String _message = this.typeDialog == 1 ? RepositoryResource.getMessageString("saveerr2.txt", 1, _argString) : (this.typeDialog == 0 ? RepositoryResource.getMessageString("openerr2.txt", 1, _argString) : RepositoryResource.getMessageString("selecterr2.txt", 1, _argString));
            if (this.typeDialog == 2) {
                this.fileStream = null;
                if (!this.tableView.isRowSelected()) {
                    this.showErrDialog(_message, _errorTitle);
                    this.setDefaultFocusText("");
                    _canFinish = false;
                    this.setBusyCursor(false);
                    return;
                }
                String _tableValue = this.tableView.getTableValue();
                String _path = this.getCurrentLocation();
                this.folderSelected = _path + "/" + _tableValue;
                _canFinish = true;
            } else {
                try {
                    this.fileStream = this.repositoryInfo.accessFile(this.fileName, this.typeDialog, _typeStr);
                }
                catch (IllegalSaveException exc) {
                    this.showErrDialog(_message, _errorTitle);
                    this.setDefaultFocusText("");
                    _canFinish = false;
                    this.setBusyCursor(false);
                    return;
                }
                catch (IllegalOpenException exc) {
                    this.showErrDialog(_message, _errorTitle);
                    this.setDefaultFocusText("");
                    _canFinish = false;
                    this.setBusyCursor(false);
                    return;
                }
                catch (DuplicateNameException exc) {
                    _canFinish = false;
                    this.setDefaultFocusText("");
                    this.setBusyCursor(false);
                    return;
                }
                catch (IllegalNameException exc) {
                    this.showErrDialog(RepositoryResource.getMessageString("illegalErr.txt", 1, _argString), _errorTitle);
                    this.setDefaultFocusText("");
                    _canFinish = false;
                    this.setBusyCursor(false);
                    return;
                }
                catch (NotFoundException exc) {
                    this.showErrDialog(RepositoryResource.getMessageString("doesNotExist.txt", 1, _argString), _errorTitle);
                    _canFinish = false;
                    this.setDefaultFocusText("");
                    this.setBusyCursor(false);
                    return;
                }
                boolean _checkStreamForNull = true;
                if (this.typeDialog != 1) {
                    if (_typeStr.equals(RepositoryResource.getStringResource("iqType.txt"))) {
                        _checkStreamForNull = false;
                    } else if (_typeStr.equals(RepositoryResource.getStringResource("storeType.txt"))) {
                        _checkStreamForNull = false;
                    }
                }
                if (this.fileStream == null && _checkStreamForNull) {
                    this.showErrDialog(RepositoryResource.getMessageString("nullFile.txt", 1, _argString), _errorTitle);
                    _canFinish = false;
                    this.setDefaultFocusText("");
                    this.setBusyCursor(false);
                    return;
                }
            }
        } else {
            this.fileName = null;
            this.fileStream = null;
        }
        if (_canFinish) {
            if (this.repositoryInfo != null) {
                this.repositoryInfo.disconnect();
            }
            this.dispose();
        } else {
            this.setDefaultFocusText("");
        }
        this.setBusyCursor(false);
    }

    public Object getStream() {
        boolean _wasCancelled = this.wasCancelled();
        if (_wasCancelled) {
            return null;
        }
        return this.fileStream;
    }

    @Override
    protected void setDefaultFocus() {
        this.fileNameField.requestFocus();
    }

    public String getFolderSelected() {
        return this.folderSelected;
    }

    public void setFileName(String fileName) {
        this.setDefaultFocusText(fileName);
    }

    @Override
    protected void setDefaultFocusText(String textValue) {
        this.fileNameField.setText(textValue);
        this.fileNameField.selectAll();
        this.fileNameField.requestFocus();
    }

    @Override
    protected String getDefaultFocusText() {
        boolean _wasCancelled = this.wasCancelled();
        if (_wasCancelled) {
            return null;
        }
        this.getFullFileNameExt();
        String _fileNameSaved = this.fileNameField.getText();
        return _fileNameSaved;
    }

    public String getFullFileName() {
        boolean _wasCancelled = this.wasCancelled();
        if (_wasCancelled) {
            return null;
        }
        this.getFullFileNameExt();
        String _fileNameSaved = this.fileNameField.getText();
        String _path = this.getCurrentLocation();
        return _path + "/" + _fileNameSaved;
    }

    private void findEntry() {
        this.showErrDialog(notThereYet, notAvailable);
    }

    private String checkBlank(String textValue) {
        if (textValue.equals("/")) {
            textValue = "";
        }
        if (textValue.equals("\\")) {
            textValue = "";
        }
        return textValue;
    }

    private void setChoiceAtTop() {
        this.choiceList.clear();
        this.dirList.clear();
        this.choiceList.addElement(repsstr);
        this.dirList.addElement(repsstr);
        this.setNavigators(false);
        this.dontUpdateChoiceList = true;
        this.repositoryChoices.setSelectedIndex(0);
        this.dontUpdateChoiceList = false;
    }

    public int getTableView() {
        int sel = this.viewTableChoice.getSelectedIndex();
        if (sel == 0) {
            return 0;
        }
        return 1;
    }

    public void setTableView(int sel, boolean setOn) throws InvalidSelectionException {
        if (sel != 0 && sel != 1) {
            this.messager.error(invalidViewSelection);
            throw new InvalidSelectionException();
        }
        this.tableView.setTableView(sel);
        Dimension _area = this.subContentPane.getSize();
        this.subContentPane.revalidate();
        this.subContentPane.setPreferredSize(_area);
        if (setOn) {
            this.viewTableChoice.setSelectedIndex(sel);
        }
    }

    class ComboCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ImageIcon[] image;

        public ComboCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(Color.lightGray);
            ImageIcon icon = (ImageIcon)value;
            this.setText(icon.getDescription());
            this.setIcon(icon);
            return this;
        }
    }
}

