/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.visuals;

import com.sas.report.repository.RepositoryMessager;
import com.sas.report.repository.RepositoryResource;
import com.sas.report.repository.visuals.DuplicateNameException;
import com.sas.report.repository.visuals.GenericDialog;
import com.sas.report.repository.visuals.GenericRepositoryAccess;
import com.sas.report.repository.visuals.IllegalNameException;
import com.sas.report.repository.visuals.ImageHandler;
import com.sas.report.repository.visuals.InvalidNewFolderException;
import com.sas.report.repository.visuals.InvalidRenameException;
import com.sas.report.repository.visuals.OpenSavePopup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class GenericTableAccess {
    private static final String pgm = "GenericTableAccess";
    private static final String newFolderStr = RepositoryResource.getStringResource("newFolderStr.txt");
    public static final String folderStr = RepositoryResource.getStringResource("folderStr.txt");
    public static final String repStr = RepositoryResource.getStringResource("repStr.txt");
    private static final String nameStr = RepositoryResource.getStringResource("nameStr.txt");
    private static final String typeStr = RepositoryResource.getStringResource("typeStr.txt");
    private static final String selerr1 = RepositoryResource.getStringResource("selerr1.txt");
    private static final String typeerr = RepositoryResource.getStringResource("typeerr.txt");
    private static final String createdRef = "Creation Date";
    private static final String lastModRef = "Modified Date";
    private static final String nameRef = "name";
    private static final String descRef = "description";
    private static final String authorRef = "Author";
    public static final String rrConnectErrorMessage1 = RepositoryResource.getStringResource("rrConnectErrorMessage1.txt");
    private static final String selerr2 = RepositoryResource.getStringResource("selerr2.txt");
    private static final String renameerr1 = RepositoryResource.getStringResource("renameerr1.txt");
    private static final String renameerr2 = RepositoryResource.getStringResource("renameerr2.txt");
    private static final String errIllegal = RepositoryResource.getStringResource("illegalErr.txt");
    private static final String errDuplicate = RepositoryResource.getStringResource("duplicateErr.txt");
    private static final String correctIllegal = RepositoryResource.getStringResource("correctIllegal.txt");
    private static final String correctDup = RepositoryResource.getStringResource("correctDup.txt");
    private static final String typeRef = "type";
    private static final String newerr = RepositoryResource.getStringResource("newFoldererr.txt");
    private static final String invalidnew = RepositoryResource.getStringResource("invalidnew.txt");
    private static final String duplicatenew = RepositoryResource.getStringResource("duplicatenew.txt");
    private static final String changeExtension = RepositoryResource.getStringResource("changeExtension.txt");
    private static final String authorStr = RepositoryResource.getStringResource("authorStr.txt");
    private static final String createdStr = RepositoryResource.getStringResource("createdStr.txt");
    private static final String lastModStr = RepositoryResource.getStringResource("lastModStr.txt");
    private String dot = ".";
    private String newName;
    private String oldNameWithExtension;
    private String oldName;
    private String extension;
    public String nameToChange;
    public String nameToChangeCheck;
    private String userName = System.getProperty("user.name");
    public String altFolderName;
    private String currentSelection;
    private Vector currentSelections;
    public GenericRepositoryAccess repositoryInfo;
    private RepositoryMessager messager;
    private Component tableEditor;
    public TableCellEditor cellEditor;
    public GenericDialog dialog;
    private int numberOfColumns;
    private int selectedRow;
    private int selectedColumn;
    private int displayType;
    private int selectedNumberOfRows;
    private Vector selectedRows;
    private Object valueInCell;
    private Object[] selectionListObject;
    public JTextField changeName;
    private JScrollPane scroller;
    private JTable fileTable;
    private Vector tableHeadings = new Vector();
    private Vector tableData;
    private ImageIcon folderIcon;
    private EditableTableModel tableModel;
    private JTableHeader tableHeader;
    private TableColumnModel model;
    public boolean isRename;
    private boolean hasExtension;
    public boolean ignoreFocus = false;
    public MouseEvent tableMouseEvent;
    private JPopupMenu entryPopupMenu;
    private JPopupMenu folderPopupMenu;
    private JPopupMenu overviewPopupMenu;
    private JPopupMenu repositoryPopupMenu;
    private JPopupMenu iqPopupMenu;
    private OpenSavePopup tableOpenSavePopup;

    public GenericTableAccess(GenericRepositoryAccess repositoryInfo, GenericDialog dialog, int displayType) {
        this.initSet(repositoryInfo, dialog, displayType);
    }

    public void renameEntry(String oldName) {
        boolean _isRowSelected = this.isRowSelected();
        if (_isRowSelected) {
            this.isRename = true;
            this.tableModel.setRename(this.isRename);
            this.setRename(oldName, this.selectedRow, this.selectedColumn);
        }
    }

    public void setTableView(int displayType) {
        this.displayType = displayType;
        this.tableHeadings.clear();
        this.createTableHeadings();
        this.tableModel.setDataVector(this.tableData, this.tableHeadings);
        this.changeTable();
    }

    public JScrollPane getPanel() {
        return this.scroller;
    }

    public Vector getTableData() {
        return this.tableData;
    }

    public void setTableData(Vector tableData) {
        this.tableData = tableData;
        this.tableModel.setDataVector(tableData, this.tableHeadings);
        this.changeTable();
        this.dialog.setDefaultFocusText("");
        this.dialog.setDefaultFocus();
    }

    public String getTableSelection() {
        return this.currentSelection;
    }

    public Vector getTableSelections() {
        return this.currentSelections;
    }

    public JTable getTable() {
        return this.fileTable;
    }

    public boolean isRowSelected() {
        this.selectedRow = this.fileTable.getSelectedRow();
        return this.selectedRow != -1;
    }

    public boolean isMultipleRowsSelected() {
        return this.selectedRows.size() > 1;
    }

    public EditableTableModel getTableModel() {
        return this.tableModel;
    }

    public int getTableRowSelection() {
        return this.selectedRow;
    }

    public Vector getTableRowsSelected() {
        return this.selectedRows;
    }

    public void addFolder() {
        String _newFolder;
        boolean _continue = true;
        this.dialog.setBusyCursor(true);
        Date _today = new Date();
        Locale currentLocale = new Locale("us", "US");
        DateFormat timeFormatter = DateFormat.getTimeInstance(2, currentLocale);
        String _timeOut = timeFormatter.format(_today);
        String _fmtTimeOut = _timeOut.replace(':', '-');
        this.altFolderName = _newFolder = newFolderStr + _fmtTimeOut + this.userName;
        String[] _argString = new String[]{_newFolder};
        try {
            this.repositoryInfo.addFolder(_newFolder);
        }
        catch (InvalidNewFolderException exc) {
            this.dialog.showErrDialog(RepositoryResource.getMessageString("invalidnew.txt", 1, _argString), newerr);
            _continue = false;
        }
        catch (DuplicateNameException exc) {
            this.dialog.showErrDialog(RepositoryResource.getMessageString("duplicatenew.txt", 1, _argString), newerr);
            _continue = false;
        }
        if (_continue) {
            this.dialog.setBusyCursor(true);
            Vector<String> _rows = new Vector<String>();
            String _type = null;
            String _author = null;
            String _lastMod = null;
            String _created = null;
            Iterator m = this.repositoryInfo.getAttributes(_newFolder);
            while (m.hasNext()) {
                Map.Entry e = (Map.Entry)m.next();
                Object _n = e.getKey();
                Object _value = e.getValue();
                if (_value == null) continue;
                if (_n.toString().equals(typeRef)) {
                    _type = _value.toString();
                    continue;
                }
                if (_n.toString().equals(authorRef)) {
                    _author = _value.toString();
                    continue;
                }
                if (_n.toString().equals(lastModRef)) {
                    _lastMod = _value.toString();
                    continue;
                }
                if (!_n.toString().equals(createdRef)) continue;
                _created = _value.toString();
            }
            _rows.addElement(newFolderStr);
            if (_type == null) {
                _type = folderStr;
            }
            _rows.addElement(_type);
            _rows.addElement(_author);
            _rows.addElement(_created);
            _rows.addElement(_lastMod);
            this.tableData.add(_rows);
            Vector _types = this.repositoryInfo.getTypeData();
            _types.addElement(_type);
            this.repositoryInfo.setTypeData(_types);
            this.changeTable();
            this.fileTable.revalidate();
            this.isRename = true;
            this.tableModel.setRename(this.isRename);
            this.scroll("D");
            this.setRename(_newFolder, this.selectedRow, 0);
        }
        this.dialog.setBusyCursor(false);
    }

    public void scroll(String direction) {
        if (direction.equals("D")) {
            TableModel _tm = this.fileTable.getModel();
            int _noOfRows = _tm.getRowCount();
            this.selectedRow = _noOfRows - 1;
            Rectangle cellRect = this.fileTable.getCellRect(this.selectedRow, 0, false);
            if (cellRect != null) {
                this.fileTable.scrollRectToVisible(cellRect);
            }
        } else {
            this.scroller.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
    }

    public void deleteEntry(Vector itemsToDelete) {
        Vector _types = this.repositoryInfo.getTypeData();
        int end = this.tableData.size() - 1;
        for (int _rowI = 0; _rowI <= end; ++_rowI) {
            Vector _topLevel = (Vector)this.tableData.get(_rowI);
            Object _element = _topLevel.get(0);
            boolean _deleted = itemsToDelete.contains(_element);
            if (!_deleted) continue;
            this.tableData.remove(_rowI);
            _types.remove(_rowI);
            --end;
            --_rowI;
        }
        this.repositoryInfo.setTypeData(_types);
        this.tableModel.setDataVector(this.tableData, this.tableHeadings);
        this.changeTable();
        this.dialog.setDefaultFocusText("");
        this.dialog.setDefaultFocus();
    }

    public String getTableValue() {
        String _fileValue = this.valueInCell.toString();
        return _fileValue;
    }

    public int getTableColumnSelection() {
        return this.selectedColumn;
    }

    public void setOpenSavePopup(OpenSavePopup tableOpenSavePopup) {
        this.tableOpenSavePopup = tableOpenSavePopup;
        this.entryPopupMenu = tableOpenSavePopup.getPopup(0);
        this.overviewPopupMenu = tableOpenSavePopup.getPopup(1);
        this.repositoryPopupMenu = tableOpenSavePopup.getPopup(2);
        this.folderPopupMenu = tableOpenSavePopup.getPopup(3);
        this.iqPopupMenu = tableOpenSavePopup.getPopup(4);
        this.fileTable.add(this.overviewPopupMenu);
        this.fileTable.add(this.entryPopupMenu);
        this.fileTable.add(this.repositoryPopupMenu);
        this.fileTable.add(this.folderPopupMenu);
        this.fileTable.add(this.iqPopupMenu);
        this.fileTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                int _clicks = event.getClickCount();
                Point _point = event.getPoint();
                boolean _isRightMouseClick = SwingUtilities.isRightMouseButton(event);
                GenericTableAccess.this.tableMouseEvent = event;
                GenericTableAccess.this.setClick(_clicks, _point, _isRightMouseClick, GenericTableAccess.this.tableMouseEvent);
            }
        });
    }

    public void setClick(int clicks, Point point, boolean isRightMouseClick, MouseEvent tableMouseEvent) {
        String _colName = "";
        this.selectedRow = this.fileTable.getSelectedRow();
        this.selectedNumberOfRows = this.fileTable.getSelectedRowCount();
        this.selectedColumn = this.fileTable.getSelectedColumn();
        this.currentSelections.clear();
        this.selectedRows.clear();
        this.valueInCell = null;
        this.currentSelection = null;
        String _type = folderStr;
        if (this.selectedColumn > -1) {
            _colName = this.fileTable.getColumnName(this.selectedColumn);
            if (_colName != nameStr && this.selectedColumn == 0 && this.valueInCell != null) {
                _colName = nameStr;
            } else if (_colName != nameStr && this.selectedColumn == 0 && this.displayType == 0) {
                _colName = nameStr;
            }
        } else {
            _colName = nameStr;
        }
        int _pointRow = this.fileTable.rowAtPoint(point);
        if (_pointRow == -1) {
            this.selectedRow = -1;
        }
        if (this.selectedRow == -1) {
            if (clicks == 1) {
                this.showPopup(1, tableMouseEvent);
            }
            return;
        }
        if (this.selectedRow != _pointRow && isRightMouseClick && this.selectedNumberOfRows == 1) {
            if (clicks == 1) {
                this.showPopup(1, tableMouseEvent);
            }
            return;
        }
        boolean _outsideOfSelectedRows = true;
        if (this.selectedNumberOfRows > 1) {
            int[] _rowSelected = this.fileTable.getSelectedRows();
            int _row2 = this.selectedRow;
            for (int _row2 : _rowSelected) {
                if (_pointRow == _row2) {
                    _outsideOfSelectedRows = false;
                }
                String _valueOfRow = this.fileTable.getValueAt(_row2, 0).toString();
                String _rowNumber = null;
                _rowNumber = String.valueOf(_row2);
                this.currentSelections.addElement(_valueOfRow);
                this.selectedRows.addElement(_rowNumber);
            }
            this.valueInCell = this.fileTable.getValueAt(_row2, 0);
        } else {
            _outsideOfSelectedRows = false;
            this.valueInCell = this.fileTable.getValueAt(this.selectedRow, 0);
        }
        if (_outsideOfSelectedRows && isRightMouseClick && this.selectedNumberOfRows > 1) {
            if (clicks == 1) {
                this.showPopup(1, tableMouseEvent);
            }
            return;
        }
        this.currentSelection = this.valueInCell.toString();
        if (clicks > 1 && !isRightMouseClick) {
            this.getRR(this.selectedRow);
            this.selectedColumn = 0;
            String _nam = this.dialog.getDefaultFocusText();
            if (_nam.length() > 0) {
                this.dialog.finish();
            }
        } else if (clicks == 1) {
            Vector _types = this.repositoryInfo.getTypeData();
            String _sel = null;
            if (_colName.equals(nameStr)) {
                if (this.valueInCell != null) {
                    _sel = this.valueInCell.toString();
                    _type = _types.get(this.selectedRow).toString();
                }
                if (_sel == null) {
                    _type = folderStr;
                }
                if (_type == null) {
                    String[] _argString = new String[]{this.currentSelection};
                    String _message = RepositoryResource.getMessageString("selerr1.txt", 1, _argString);
                    this.dialog.showErrDialog(_message, selerr2);
                    this.dialog.setDefaultFocusText("");
                    this.dialog.setDefaultFocus();
                } else if (_type.equals(RepositoryResource.getStringResource("iqType.txt"))) {
                    this.dialog.setDefaultFocusText("");
                    this.dialog.setDefaultFocus();
                } else if (_type.equals(folderStr)) {
                    this.dialog.setDefaultFocusText("");
                    this.dialog.setDefaultFocus();
                } else if (_type.equals(repStr)) {
                    this.dialog.setDefaultFocusText("");
                    this.dialog.setDefaultFocus();
                } else {
                    this.dialog.setDefaultFocusText(_sel);
                }
            }
            if (isRightMouseClick) {
                boolean _isOnTop = this.repositoryInfo.isRepository();
                if (_isOnTop) {
                    this.showPopup(2, tableMouseEvent);
                } else if (_type.equals(RepositoryResource.getStringResource("iqType.txt"))) {
                    this.showPopup(4, tableMouseEvent);
                } else if (this.currentSelection == null) {
                    this.showPopup(1, tableMouseEvent);
                } else if (_colName.equals(nameStr)) {
                    if (_type == folderStr) {
                        this.showPopup(3, tableMouseEvent);
                    } else {
                        this.showPopup(0, tableMouseEvent);
                    }
                } else {
                    this.showPopup(1, tableMouseEvent);
                }
            }
        }
    }

    private void setRename(String nameChange, int row, int col) {
        this.dialog.setBusyCursor(true);
        this.nameToChangeCheck = "";
        this.extension = "";
        this.hasExtension = false;
        this.oldName = nameChange;
        this.oldNameWithExtension = nameChange;
        int _hasExt = this.oldName.indexOf(this.dot);
        if (this.oldName.trim().equals("")) {
            _hasExt = 0;
        }
        if (_hasExt > 0) {
            this.extension = this.oldName.substring(_hasExt + 1);
            this.oldName = this.oldName.substring(0, _hasExt + 1);
            this.hasExtension = true;
        }
        this.fileTable.editCellAt(row, col);
        this.tableEditor = this.fileTable.getEditorComponent();
        this.cellEditor = this.fileTable.getCellEditor();
        if (this.tableEditor != null) {
            this.tableEditor.requestFocus();
            if (this.tableEditor instanceof JTextField) {
                this.changeName = (JTextField)this.tableEditor;
                this.nameToChange = this.changeName.getText();
                int _hasEx = this.nameToChange.indexOf(this.dot);
                if (this.nameToChange.trim().equals("")) {
                    _hasEx = 0;
                }
                if (_hasEx > 0) {
                    this.nameToChange = this.nameToChange.substring(0, _hasEx);
                }
                this.changeName.setText(this.nameToChange);
                this.changeName.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent KeyE) {
                        if (KeyE.getKeyCode() == 10) {
                            GenericTableAccess.this.nameToChangeCheck = GenericTableAccess.this.changeName.getText();
                            if (GenericTableAccess.this.nameToChange.equals(GenericTableAccess.this.nameToChangeCheck)) {
                                if (GenericTableAccess.this.nameToChange.equals(RepositoryResource.getStringResource("newFolderStr.txt"))) {
                                    GenericTableAccess.this.updateTableColumn(GenericTableAccess.this.altFolderName);
                                }
                                GenericTableAccess.this.isRename = false;
                                GenericTableAccess.this.cellEditor.stopCellEditing();
                                GenericTableAccess.this.dialog.setDefaultFocusText("");
                                GenericTableAccess.this.dialog.setDefaultFocus();
                            } else {
                                GenericTableAccess.this.ignoreFocus = true;
                                GenericTableAccess.this.makeRename();
                                GenericTableAccess.this.ignoreFocus = false;
                                GenericTableAccess.this.nameToChangeCheck = GenericTableAccess.this.changeName.getText();
                                GenericTableAccess.this.nameToChange = GenericTableAccess.this.changeName.getText();
                            }
                        }
                    }
                });
                this.changeName.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent afe) {
                    }

                    @Override
                    public void focusLost(FocusEvent afe) {
                        GenericTableAccess.this.nameToChangeCheck = GenericTableAccess.this.changeName.getText();
                        if (GenericTableAccess.this.nameToChange.equals(GenericTableAccess.this.nameToChangeCheck)) {
                            if (GenericTableAccess.this.nameToChange.equals(RepositoryResource.getStringResource("newFolderStr.txt"))) {
                                GenericTableAccess.this.updateTableColumn(GenericTableAccess.this.altFolderName);
                            }
                            GenericTableAccess.this.isRename = false;
                            GenericTableAccess.this.cellEditor.stopCellEditing();
                            GenericTableAccess.this.dialog.setDefaultFocusText("");
                            GenericTableAccess.this.dialog.setDefaultFocus();
                            Vector _refreshTable = GenericTableAccess.this.getTableData();
                            for (int _it = 0; _it < _refreshTable.size(); ++_it) {
                                Vector _check = (Vector)_refreshTable.get(_it);
                                String _name = _check.get(0).toString();
                                if (!_name.equals(RepositoryResource.getStringResource("newFolderStr.txt"))) continue;
                                _check.set(0, GenericTableAccess.this.altFolderName);
                                _it = _refreshTable.size();
                                GenericTableAccess.this.setTableData(_refreshTable);
                            }
                        } else if (!GenericTableAccess.this.ignoreFocus) {
                            GenericTableAccess.this.makeRename();
                            GenericTableAccess.this.nameToChangeCheck = GenericTableAccess.this.changeName.getText();
                            GenericTableAccess.this.nameToChange = GenericTableAccess.this.changeName.getText();
                        }
                    }
                });
                this.changeName.setCaretPosition(0);
                this.changeName.selectAll();
            }
        }
        this.dialog.setBusyCursor(false);
    }

    public void makeRename() {
        this.dialog.setBusyCursor(true);
        this.newName = this.changeName.getText();
        String[] _argString = new String[]{this.newName};
        String _message = RepositoryResource.getMessageString("changeExtension.txt", 1, _argString);
        if (this.hasExtension) {
            int _hasExt2 = this.newName.indexOf(this.dot);
            if (_hasExt2 > 0) {
                int _result = this.dialog.showWarnDialog(_message);
                switch (_result) {
                    case 0: {
                        this.oldName = this.oldNameWithExtension;
                        try {
                            this.setRenameInRep();
                            break;
                        }
                        catch (Exception ex) {
                            this.handleRenameErr();
                            return;
                        }
                    }
                    case 1: {
                        this.oldName = this.oldNameWithExtension;
                        this.changeName.setText(this.oldName);
                        this.handleRenameErr();
                        return;
                    }
                }
            } else {
                this.oldName = this.oldNameWithExtension;
                this.newName = this.newName + this.dot + this.extension;
                try {
                    this.setRenameInRep();
                }
                catch (Exception ex) {
                    this.handleRenameErr();
                    return;
                }
            }
        } else {
            try {
                this.setRenameInRep();
            }
            catch (Exception ex) {
                this.handleRenameErr();
                return;
            }
        }
        this.isRename = false;
        this.tableModel.setRename(this.isRename);
        this.currentSelection = this.newName;
        this.cellEditor.stopCellEditing();
        this.dialog.setDefaultFocusText("");
        this.dialog.setDefaultFocus();
        this.updateTableColumn(this.newName);
        this.dialog.setBusyCursor(false);
    }

    private void handleRenameErr() {
        this.cellEditor.stopCellEditing();
        this.isRename = false;
        this.tableModel.setRename(this.isRename);
        this.dialog.setDefaultFocusText("");
        this.dialog.setDefaultFocus();
        this.dialog.setBusyCursor(false);
    }

    private void setRenameInRep() throws Exception {
        String[] _argString = new String[]{this.newName};
        String _message = RepositoryResource.getMessageString("correctIllegal.txt", 1, _argString);
        if (this.newName.trim().length() == 0) {
            try {
                this.correctNameErr(this.oldName, _message, renameerr2);
            }
            catch (Exception exc) {
                this.changeName.setText(this.oldName);
                throw new Exception();
            }
            this.changeName.setText(this.newName);
        }
        try {
            this.repositoryInfo.renameEntry(this.oldName, this.newName);
        }
        catch (InvalidRenameException ex) {
            this.dialog.showErrDialog(RepositoryResource.getMessageString("renameerr1.txt", 1, _argString), renameerr2);
            throw new Exception();
        }
        catch (IllegalNameException ex) {
            try {
                this.correctNameErr(this.oldName, _message, renameerr2);
            }
            catch (Exception exc) {
                this.changeName.setText(this.oldName);
                throw new Exception();
            }
            this.changeName.setText(this.newName);
        }
        catch (DuplicateNameException exc) {
            boolean loop = true;
            while (loop) {
                loop = false;
                try {
                    loop = this.correctNameErr(this.oldName, RepositoryResource.getMessageString("correctDup.txt", 1, _argString), renameerr2);
                }
                catch (Exception ex) {
                    this.newName = this.oldName;
                    this.changeName.setText(this.oldName);
                    throw new Exception();
                }
            }
        }
    }

    private boolean correctNameErr(String toRename, String errorMessage, String errorTitle) throws Exception {
        String text = this.dialog.showErrInputDialog(errorMessage, errorTitle);
        if (text == null) {
            throw new Exception();
        }
        boolean loop = false;
        try {
            this.repositoryInfo.renameEntry(toRename, text);
        }
        catch (InvalidRenameException ex) {
            throw new Exception();
        }
        catch (IllegalNameException ex) {
            loop = true;
        }
        catch (DuplicateNameException ex) {
            loop = true;
        }
        this.newName = text;
        this.changeName.setText(text);
        return loop;
    }

    private void initSet(GenericRepositoryAccess repositoryInfo, GenericDialog dialog, int displayType) {
        this.repositoryInfo = repositoryInfo;
        this.displayType = displayType;
        this.dialog = dialog;
        this.messager = repositoryInfo.getMessager();
        this.currentSelections = new Vector();
        this.selectedRows = new Vector();
        this.tableData = repositoryInfo.getRepositoryFolders();
        this.createTableHeadings();
        this.tableModel = new EditableTableModel(this.tableData, this.tableHeadings);
        this.tableModel.setDataVector(this.tableData, this.tableHeadings);
        this.fileTable = new JTable(this.tableModel);
        this.isRename = false;
        this.fileTable.setShowGrid(false);
        this.fileTable.setBackground(Color.white);
        this.model = this.fileTable.getColumnModel();
        this.tableHeader = this.fileTable.getTableHeader();
        this.changeTable();
        this.scroller = new JScrollPane();
        this.scroller.setViewportView(this.fileTable);
        this.scroller.getViewport().setBackground(Color.white);
        this.tableHeader.setReorderingAllowed(false);
        int hPolicy = 30;
        int vPolicy = 20;
        this.scroller.setVerticalScrollBarPolicy(vPolicy);
        this.scroller.setHorizontalScrollBarPolicy(hPolicy);
        this.fileTable.setAutoResizeMode(0);
    }

    public void updateTableColumn(String newValue) {
        if (this.selectedRow > -1) {
            Object _dataRow = this.tableData.get(this.selectedRow);
            Vector _updatedRow = (Vector)_dataRow;
            _updatedRow.set(0, newValue);
            this.tableData.set(this.selectedRow, _updatedRow);
        }
    }

    private void changeTable() {
        this.model = this.fileTable.getColumnModel();
        this.numberOfColumns = this.model.getColumnCount();
        if (this.displayType == 0) {
            for (int i = 1; i < this.numberOfColumns; ++i) {
                TableColumn _c = this.model.getColumn(i);
                this.model.removeColumn(_c);
                --this.numberOfColumns;
                --i;
            }
            TableColumn _c = this.model.getColumn(0);
            _c.setPreferredWidth(450);
            this.fileTable.setTableHeader(null);
            this.fileTable.addNotify();
        } else {
            this.fileTable.setTableHeader(this.tableHeader);
            this.fileTable.addNotify();
            TableColumn _c0 = this.model.getColumn(0);
            _c0.setPreferredWidth(200);
            TableColumn _c1 = this.model.getColumn(1);
            _c1.setPreferredWidth(100);
            TableColumn _c2 = this.model.getColumn(2);
            _c2.setPreferredWidth(50);
            TableColumn _c3 = this.model.getColumn(3);
            _c3.setPreferredWidth(150);
            TableColumn _c4 = this.model.getColumn(4);
            _c4.setPreferredWidth(150);
        }
        TableColumn _imageColumn = this.model.getColumn(0);
        _imageColumn.setCellRenderer(new TableRender());
    }

    private void getRR(int rowIndex) {
        Vector _types = this.repositoryInfo.getTypeData();
        if (!this.isRename) {
            this.repositoryInfo.setEntryIndex(rowIndex);
            this.currentSelection = this.valueInCell.toString();
            String _type = _types.get(rowIndex).toString();
            if (_type == null) {
                String[] _argString = new String[]{this.currentSelection};
                String _message = RepositoryResource.getMessageString("typeerr.txt", 1, _argString);
                this.dialog.showErrDialog(_message, selerr2);
                this.dialog.setDefaultFocusText("");
                this.dialog.setDefaultFocus();
            } else if (_type.equals(RepositoryResource.getStringResource("iqType.txt"))) {
                this.dialog.setDefaultFocusText("");
                this.dialog.setDefaultFocus();
            } else if (_type.equals(folderStr)) {
                this.updateTableData(this.currentSelection);
            } else if (_type.equals(repStr)) {
                this.updateTableData(this.currentSelection);
            } else {
                this.dialog.setDefaultFocusText(this.currentSelection);
            }
        }
    }

    public void updateTableData(String currentSelection) {
        String _item1;
        this.dialog.setBusyCursor(true);
        try {
            this.repositoryInfo.updateFolderData(this.tableData, currentSelection, false);
        }
        catch (Exception exc) {
            this.messager.error(exc.getMessage());
            String[] _argString = new String[]{currentSelection};
            String _message = RepositoryResource.getMessageString("selerr1.txt", 1, _argString);
            this.dialog.showErrDialog(_message, selerr2);
        }
        this.tableModel.setDataVector(this.tableData, this.tableHeadings);
        this.changeTable();
        this.dialog.setBusyCursor(false);
        this.dialog.setDefaultFocusText("");
        this.dialog.setDefaultFocus();
        if (this.repositoryInfo != null && (_item1 = this.repositoryInfo.getPathURL()) != null) {
            String _item2 = this.repositoryInfo.getCurrentEntryName();
            if (_item2 == null) {
                _item2 = _item1;
            } else if (_item2.equals("")) {
                _item2 = _item1;
            }
            this.dialog.addFolder(_item2, _item1);
        }
    }

    public void showPopup(int typeOfSelection, MouseEvent tableMouseEvent) {
        boolean isMultiple = this.isMultipleRowsSelected();
        if (typeOfSelection == 2) {
            this.repositoryPopupMenu.show(tableMouseEvent.getComponent(), tableMouseEvent.getX(), tableMouseEvent.getY());
        } else if (typeOfSelection == 0) {
            boolean _isCopyCutOn = this.tableOpenSavePopup.isCopyCutOn();
            this.tableOpenSavePopup.setCutCopyPasteItems(_isCopyCutOn, typeOfSelection, false);
            this.tableOpenSavePopup.setPropRenameItems(isMultiple, typeOfSelection);
            this.entryPopupMenu.show(tableMouseEvent.getComponent(), tableMouseEvent.getX(), tableMouseEvent.getY());
        } else if (typeOfSelection == 3) {
            this.tableOpenSavePopup.setCutCopyPasteItems(false, typeOfSelection, true);
            this.tableOpenSavePopup.setCutCopyPasteItems(false, typeOfSelection, false);
            this.tableOpenSavePopup.setPropRenameItems(isMultiple, typeOfSelection);
            this.folderPopupMenu.show(tableMouseEvent.getComponent(), tableMouseEvent.getX(), tableMouseEvent.getY());
        } else if (typeOfSelection == 4) {
            boolean _isCopyCutOn = this.tableOpenSavePopup.isCopyCutOn();
            this.tableOpenSavePopup.setCutCopyPasteItems(_isCopyCutOn, typeOfSelection, false);
            this.iqPopupMenu.show(tableMouseEvent.getComponent(), tableMouseEvent.getX(), tableMouseEvent.getY());
        } else {
            boolean _isCopyCutOn = this.tableOpenSavePopup.isCopyCutOn();
            this.tableOpenSavePopup.setCutCopyPasteItems(_isCopyCutOn, typeOfSelection, false);
            this.overviewPopupMenu.show(tableMouseEvent.getComponent(), tableMouseEvent.getX(), tableMouseEvent.getY());
        }
    }

    private void createTableHeadings() {
        if (this.displayType == 0) {
            this.tableHeadings.add("");
        } else {
            this.tableHeadings.add(nameStr);
        }
        this.tableHeadings.add(typeStr);
        this.tableHeadings.add(authorStr);
        this.tableHeadings.add(createdStr);
        this.tableHeadings.add(lastModStr);
    }

    public class EditableTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 8211405054508344052L;
        boolean isRename = false;
        private Vector dataVector;
        private Vector headingVector;
        int[] indexes;

        public EditableTableModel(Vector dataVector, Vector headingVector) {
            this.dataVector = dataVector;
            this.headingVector = headingVector;
        }

        public boolean CellEditable(int row, int col) {
            return this.isRename;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return this.isRename;
        }

        public void setRename(boolean isRename) {
            this.isRename = isRename;
        }
    }

    public class TableRender
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1815323769071995956L;
        private String errorURL = RepositoryResource.getStringResource("errorURL.txt");
        private ImageIcon folderIcon;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 0) {
                ImageIcon _image;
                Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel label = (JLabel)comp;
                if (value != null && (_image = this.getImageIcon(value.toString(), row)) != null) {
                    label.setIcon(_image);
                }
            }
            String dot = ".";
            int indexInt = -1;
            String _result = "";
            if (value != null) {
                indexInt = value.toString().indexOf(dot);
                _result = value.toString();
            }
            if (indexInt != -1) {
                _result = _result.substring(0, indexInt);
            }
            this.setText(value == null ? "" : _result);
            return this;
        }

        private ImageIcon getImageIcon(String _stringValue, int typeRow) {
            Vector _types = GenericTableAccess.this.repositoryInfo.getTypeData();
            String _type = "";
            ImageIcon retValue = null;
            ResourceBundle bundle = RepositoryResource.getResources();
            if (_types.size() != 0) {
                _type = (String)_types.get(typeRow);
            }
            if ((retValue = _stringValue.equals(rrConnectErrorMessage1) ? ImageHandler.getImageIcon(bundle, "bad.image") : (_type.equals(RepositoryResource.getStringResource("gifType.txt")) ? ImageHandler.getImageIcon(bundle, "gif.image") : (_type.equals(RepositoryResource.getStringResource("htmlType.txt")) ? ImageHandler.getImageIcon(bundle, "html.image") : (_type.equals(RepositoryResource.getStringResource("erpType.txt")) ? ImageHandler.getImageIcon(bundle, "erp.image") : (_type.equals(RepositoryResource.getStringResource("erfType.txt")) ? ImageHandler.getImageIcon(bundle, "gif.image") : (_type.equals(RepositoryResource.getStringResource("xmlType.txt")) ? ImageHandler.getImageIcon(bundle, "xml.image") : (_type.equals(RepositoryResource.getStringResource("pdfType.txt")) ? ImageHandler.getImageIcon(bundle, "pdf.image") : (_type.equals(RepositoryResource.getStringResource("tifType.txt")) ? ImageHandler.getImageIcon(bundle, "tif.image") : (_type.equals(RepositoryResource.getStringResource("pckType.txt")) ? ImageHandler.getImageIcon(bundle, "pck.image") : (_type.equals(RepositoryResource.getStringResource("jpegType.txt")) ? ImageHandler.getImageIcon(bundle, "jpeg.image") : (_type.equals(RepositoryResource.getStringResource("iqType.txt")) ? ImageHandler.getImageIcon(bundle, "iq.image") : (_type.equals(RepositoryResource.getStringResource("storeType.txt")) ? ImageHandler.getImageIcon(bundle, "stored.image") : (_type.equals(repStr) ? ImageHandler.getImageIcon(bundle, "repos.image") : (_type.equals(folderStr) ? ImageHandler.getImageIcon(bundle, "folder.image") : (_stringValue.endsWith("xml") ? ImageHandler.getImageIcon(bundle, "erp.image") : ImageHandler.getImageIcon(bundle, "new.image")))))))))))))))) == null) {
                System.out.println(this.errorURL);
            }
            return retValue;
        }
    }
}

