/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.sasxprrp;

import com.sas.report.config.MetadataSourceDef;
import com.sas.report.config.StartPFS;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryFactory;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.SBIPURL;
import com.sas.report.repository.UtilReportReposService;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.commons.webservice.omrclient.DAVCredentialsHelper;
import com.sas.svcs.reportrepository.client.RepositoryFactoryServiceInterface;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;

public class XXHelper {
    public static final String OWNER = "owner";
    public static final String AUTHOR = "Author";
    public static final String USERIDS = "userids";
    public static final String LAST_MODIFIED = "Modified Date";
    public static final String COMMENTS = "Comments";
    public static final String CREATION_DATE = "Creation Date";
    public static final String DESCRIPTION = "description";
    public static final String NAME = "name";
    public static final String LOCATION = "location";
    public static final String REFERENCE_DATE = "Reference Date";
    public static final String TYPE = "type";
    public static final String KEYWORDS = "keywords";
    public static final String LOCALE = "locale";
    public static final String AUTHOR_CURRENT_USER = "##CURRENT USER##";
    MetadataSourceDef _srcDef;
    SessionContextInterface _session;
    RepositoryFactoryServiceInterface _factory;
    EntryInterface _entry;
    InputStream _inStream = null;
    OutputStream _outStream = null;
    Repository _rr = null;

    private Repository getRepositoryAdapter(UserContextInterface userContext, PathUrl pathUrl) throws RemoteException, ServiceException {
        if (pathUrl == null || pathUrl.getServer().length() == 0) {
            return null;
        }
        String reposName = this._srcDef.getRepositoryDefName();
        int ptr = reposName.indexOf(64);
        if (ptr != -1) {
            reposName = reposName.substring(0, ptr);
        }
        return UtilReportReposService.getRepositoryAdapter(null, userContext, reposName);
    }

    public SessionContextInterface connect(String host, String port, String userid, String passwd, String repositoryName) throws InitializationException, ServiceException, MalformedURLException, IOException, RepositoryException {
        this._srcDef = StartPFS.getMetadataSourceDef((String)host, (String)port, (String)repositoryName);
        String pfsSoftwareComponent = StartPFS.getDefaultSoftwareComponentName();
        this._session = StartPFS.openConnection((MetadataSourceDef)this._srcDef, (String)pfsSoftwareComponent, (String)userid, (String)passwd);
        return this._session;
    }

    public InputStream openEntryToRead(String url, String cacheName, String cacheEntryName) throws RepositoryException, RemoteException, ServiceException {
        this.openEntry(url, true, cacheName, cacheEntryName);
        return this._inStream;
    }

    public OutputStream openEntryToWrite(String url, String cacheName, String cacheEntryName) throws RepositoryException, RemoteException, ServiceException {
        this.openEntry(url, false, cacheName, cacheEntryName);
        return this._outStream;
    }

    public void openEntry(String url, boolean read, String cacheName, String cacheEntryName) throws RepositoryException {
        String path = null;
        try {
            SBIPURL sbip = new SBIPURL(url);
            path = sbip.getFile();
        }
        catch (IllegalArgumentException iae) {
            path = url;
        }
        if (this._rr == null) {
            try {
                boolean securedUserCredentialsAccessible;
                boolean bl = securedUserCredentialsAccessible = OMRID.securedUserAvailable() || !DAVCredentialsHelper.credentialsSecured((UserContextInterface)this._session.getUserContext());
                if (securedUserCredentialsAccessible) {
                    RepositoryFactory myRepositoryFactory = new RepositoryFactory(this._session);
                    if (myRepositoryFactory == null) {
                        throw new RuntimeException("Unable to create RepositoryFactory object.");
                    }
                    this._rr = myRepositoryFactory.getReportRepository(new PathUrl(url));
                    if (this._rr == null) {
                        throw new RuntimeException("getReportRepository(\"" + url + "\") returned null.  This often indicates that no root folders configured for content storage exist in this repository.");
                    }
                } else {
                    this._rr = this.getRepositoryAdapter(this._session.getUserContext(), new PathUrl(url));
                }
            }
            catch (RemoteException e) {
                throw new RepositoryException(e, null);
            }
            catch (ServiceException e) {
                throw new RepositoryException(e, null);
            }
            catch (IllegalStateException e) {
                throw new RepositoryException(e, null);
            }
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        int lastDelim = path.lastIndexOf(47);
        String filename = path.substring(lastDelim + 1);
        int startIndex = 0;
        path = path.substring(startIndex, lastDelim);
        DirectoryInterface leaf = this._rr.getDirectory(path);
        try {
            this._entry = leaf.getEntry(filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (read) {
            if (this._entry != null) {
                boolean empty = this._entry.isEmpty();
                if (empty) {
                    return;
                }
                this._inStream = this._entry.getInputStream();
            }
        } else if (cacheName != null && cacheEntryName != null && cacheName.length() > 0 && cacheEntryName.length() > 0) {
            CacheSetInterface cacheSet = this._entry.getCacheSetInterface();
            CacheInterface cache = cacheSet.get(cacheName);
            if (cache == null && (cache = cacheSet.create(cacheName)) == null) {
                return;
            }
            CacheItemInterface cacheItem = cache.create(cacheEntryName);
            if (cacheItem != null) {
                this._outStream = cacheItem.getOutputStream();
            }
        } else {
            if (this._entry != null) {
                this._entry.delete();
            }
            this._entry = leaf.createEntry(filename);
            this._entry.setAttribute(TYPE, "Document File");
            this._outStream = this._entry.getOutputStream();
        }
    }

    public void closeEntry() throws IOException {
        if (this._inStream != null) {
            this._inStream.close();
            this._inStream = null;
        }
        if (this._outStream != null) {
            this._outStream.close();
            this._outStream = null;
        }
    }

    public int read(InputStream stream, byte[] data) throws RepositoryIOException {
        return this._entry.read(stream, data);
    }

    public int write(OutputStream stream, byte[] data, int len) throws RepositoryIOException {
        return this._entry.write(stream, data, len);
    }

    public void setEntryAttribute(String attribute, String value) throws RepositoryException {
        this._entry.setAttribute(attribute, value);
    }

    public void closeRepository() {
        if (this._rr != null) {
            this._rr.close();
            this._rr = null;
        }
    }
}

