/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.adapter;

import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.OMRID;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryMessager;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.RepositoryUserInformation;
import com.sas.report.repository.UrlChangeCode;
import com.sas.report.repository.adapter.DirectoryInterfaceServiceAdapter;
import com.sas.report.repository.adapter.EntryInterfaceServiceAdapter;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.svcs.reportrepository.client.CacheItemServiceInterface;
import com.sas.svcs.reportrepository.client.CacheServiceInterface;
import com.sas.svcs.reportrepository.client.CacheSetServiceInterface;
import com.sas.svcs.reportrepository.client.DirectoryServiceInterface;
import com.sas.svcs.reportrepository.client.EntryServiceInterface;
import com.sas.svcs.reportrepository.client.ImportedEntryServiceInterface;
import com.sas.svcs.reportrepository.client.RepositoryServiceInterface;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryNotFoundExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.SecurityExceptionHolder;
import java.io.FilenameFilter;
import java.rmi.RemoteException;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RepositoryServiceAdapter
extends Repository {
    private static final Logger logger = LogManager.getLogger(RepositoryServiceAdapter.class);
    protected String reposName;
    protected ServerInterface server;
    protected RepositoryServiceInterface reposService;
    protected EntryServiceInterface entryService;
    protected ImportedEntryServiceInterface importedEntryService;
    protected DirectoryServiceInterface dirService;
    protected CacheSetServiceInterface cacheSetService;
    protected CacheServiceInterface cacheService;
    protected CacheItemServiceInterface cacheItemService;

    public RepositoryServiceAdapter(RepositoryServiceInterface reposService, EntryServiceInterface entryService, ImportedEntryServiceInterface importedEntryService, DirectoryServiceInterface dirService, CacheSetServiceInterface cacheSetService, CacheServiceInterface cacheService, CacheItemServiceInterface cacheItemService, String reposName, ServerInterface server) {
        this.reposName = reposName;
        this.server = server;
        this.reposService = reposService;
        this.entryService = entryService;
        this.importedEntryService = importedEntryService;
        this.dirService = dirService;
        this.cacheSetService = cacheSetService;
        this.cacheService = cacheService;
        this.cacheItemService = cacheItemService;
    }

    @Override
    public String getName() {
        return this.reposService.getName(this.reposName);
    }

    @Override
    public String toString() {
        return this.reposService.getName(this.reposName);
    }

    @Override
    public String getRepositoryId() {
        return this.reposService.getRepositoryId(this.reposName);
    }

    @Override
    public void close() {
        this.reposService.close(this.reposName);
    }

    @Override
    public AgingPolicy getAgingPolicyForEntryType(String entryType) throws IllegalStateException, RepositoryNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAgingPolicyForEntryType(String entryType, AgingPolicy agingPolicy) throws IllegalStateException, RepositoryNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRootDirectory() throws IllegalStateException, RepositoryNotFoundException {
        try {
            return this.reposService.getRootDirectory(this.reposName);
        }
        catch (IllegalStateException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public String getHomeDirectory() throws IllegalStateException, RepositoryNotFoundException {
        try {
            return this.reposService.getHomeDirectory(this.reposName);
        }
        catch (IllegalStateException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public String getUsersDirectory() throws IllegalStateException, RepositoryNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectoryInterface getDirectory(String name) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            String retDirPathUrl = this.reposService.getDirectoryFromName(this.reposName, name);
            return new DirectoryInterfaceServiceAdapter(this.dirService, this.entryService, this.importedEntryService, this.cacheSetService, this.cacheService, this.cacheItemService, retDirPathUrl, this.server, null);
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public DirectoryInterface getDirectory(PathUrl dirPathUrl) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            String retDirPathUrl = this.reposService.getDirectory(this.reposName, dirPathUrl.toString());
            return new DirectoryInterfaceServiceAdapter(this.dirService, this.entryService, this.importedEntryService, this.cacheSetService, this.cacheService, this.cacheItemService, retDirPathUrl, this.server, null);
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public DirectoryInterface getDirectory(FolderInterface fi, PathUrl dirPathUrl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryInterface getEntry(PathUrl entryPathUrl) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            String retEntryPathUrl = this.reposService.getEntry(this.reposName, entryPathUrl.toString());
            return new EntryInterfaceServiceAdapter(this.entryService, this.importedEntryService, this.dirService, this.cacheSetService, this.cacheService, this.cacheItemService, retEntryPathUrl, this.server, null);
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public boolean hasReportRepositoryService() {
        return this.reposService.hasReportRepositoryService(this.reposName);
    }

    @Override
    public RepositoryMessager getRepositoryMessager() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepositoryUserInformation getUserInformationProvider() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getMetadataObject() {
        try {
            if (this.server != null) {
                RootFolderInterface rootFolder = this.server.getRootFolder();
                for (FolderInterface folder : rootFolder.getSubfolders()) {
                    RepositoryInterface ri = folder.getRepository();
                    if (!(ri instanceof OMIRepositoryInterface) || !ri.getISName().equals(this.reposName)) continue;
                    return ri;
                }
            }
            return null;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DirectoryInterface ensurePath(PathUrl dirPathUrl) throws RepositoryException {
        try {
            String dirPath = dirPathUrl != null ? dirPathUrl.toString() : null;
            String retDirPathUrl = this.reposService.ensurePath(this.reposName, dirPath);
            return new DirectoryInterfaceServiceAdapter(this.dirService, this.entryService, this.importedEntryService, this.cacheSetService, this.cacheService, this.cacheItemService, retDirPathUrl, this.server, null);
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void ensureRepositoryContentExists() throws IllegalArgumentException, RepositoryException {
        try {
            this.reposService.ensureRepositoryContentExists(this.reposName);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void ensureRepositoryContentExists(String rootFolderName) throws IllegalArgumentException, RepositoryException {
        try {
            this.reposService.ensureRepositoryContentExists(this.reposName, rootFolderName);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void refreshPathUrl(PathUrl oldPathUrl, UrlChangeCode changeType) throws RepositoryException {
        try {
            this.reposService.refreshPathUrl(this.reposName, oldPathUrl.toString(), changeType.toString());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public Iterator getSearchResults() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSearchDone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void search(boolean isSynchronous) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFilter(FilenameFilter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLevel(int level) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPackageToSearch(String pathName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setScope(int scope) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSearch(String searchPattern) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSearchItemLimit(long entries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSearchTimeLimit(long milliseconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTotalSearchItemLimit(long entries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OMRID getOMRID() {
        Repository _repos = null;
        try {
            _repos = (Repository)this.server.getRepository(this.reposName);
        }
        catch (ServiceException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        return _repos.getOMRID();
    }
}

