/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.adapter;

import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.Transformation;
import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.ImportedEntryInterface;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.adapter.BaseMetadataAdapter;
import com.sas.report.repository.adapter.CacheSetInterfaceServiceAdapter;
import com.sas.report.repository.adapter.DirectoryInterfaceServiceAdapter;
import com.sas.report.repository.adapter.UtilAttrValueConverter;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.svcs.reportrepository.client.CacheItemServiceInterface;
import com.sas.svcs.reportrepository.client.CacheServiceInterface;
import com.sas.svcs.reportrepository.client.CacheSetServiceInterface;
import com.sas.svcs.reportrepository.client.DirectoryServiceInterface;
import com.sas.svcs.reportrepository.client.EntryServiceInterface;
import com.sas.svcs.reportrepository.client.ImportedEntryServiceInterface;
import com.sas.svcs.reportrepository.client.domain.AttributeEntryType;
import com.sas.svcs.reportrepository.client.domain.AttributesType;
import com.sas.svcs.reportrepository.client.domain.IllegalArgumentExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.ObjectFactory;
import com.sas.svcs.reportrepository.client.domain.RepositoryDuplicateNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryIOExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryIllegalNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryLockedExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryNotFoundExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.SecurityExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.ServiceExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.UnsupportedOperationExceptionHolder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntryInterfaceServiceAdapter
extends BaseMetadataAdapter
implements EntryInterface,
ImportedEntryInterface {
    private static final Logger logger = LogManager.getLogger(EntryInterfaceServiceAdapter.class);
    protected EntryServiceInterface entryService;
    protected ImportedEntryServiceInterface importedEntryService;
    protected DirectoryServiceInterface dirService;
    protected CacheSetServiceInterface cacheSetService;
    protected CacheServiceInterface cacheService;
    protected CacheItemServiceInterface cacheItemService;

    public EntryInterfaceServiceAdapter(EntryServiceInterface entryService, ImportedEntryServiceInterface importedEntryService, DirectoryServiceInterface dirService, CacheSetServiceInterface cacheSetService, CacheServiceInterface cacheService, CacheItemServiceInterface cacheItemService, String entryPathUrl, ServerInterface server, MetadataInterface smartObj) {
        super(entryPathUrl, server, smartObj);
        this.entryService = entryService;
        this.importedEntryService = importedEntryService;
        this.dirService = dirService;
        this.cacheSetService = cacheSetService;
        this.cacheService = cacheService;
        this.cacheItemService = cacheItemService;
    }

    @Override
    public void addKeyword(String keyword) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addKeyword(String keyword, String keywordDescription) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addKeywords(List keywords) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void age(long generationIncrement) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canRead() throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canWrite() throws SecurityException {
        MetadataInterface mdObj = (MetadataInterface)this.getMetadataObject();
        try {
            boolean retVal = mdObj.isAuthorized("WriteMetadata");
            return retVal;
        }
        catch (ServiceException e) {
            logger.error("OMREntryError.notrans", (Throwable)e);
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
        catch (RemoteException e) {
            logger.error("OMREntryError.notrans", (Throwable)e);
            throw (SecurityException)new SecurityException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public void copyTo(EntryInterface entry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyWithoutCaches(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryInterface createEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryInterface createEntry(String entryName, AgingPolicy agePolicy) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryInterface createEntry(Object entryMetadataObject) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(long generation) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean entryExists(String entryName) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        try {
            return this.entryService.entryExists(this.pathUrl, entryName);
        }
        catch (RepositoryIllegalNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIllegalNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public AgingPolicy getAgingPolicy() throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getApplicationData(String applicationDataName) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheSetInterface getCacheSetInterface() throws RepositoryException {
        return new CacheSetInterfaceServiceAdapter(this.cacheSetService, this.cacheService, this.cacheItemService, this.pathUrl);
    }

    @Override
    public EntryInterface getEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryInterface getEntry(String entryName, long generation) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryInterface getGeneration(long generation) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator getKeywords() throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PathUrl getLocationUrl() throws RepositoryException {
        return new PathUrl(this.pathUrl);
    }

    @Override
    public OutputStream getOutputStream(final boolean deleteCaches) throws SecurityException, RepositoryIOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                try {
                    EntryInterfaceServiceAdapter.this.entryService.setContentWithOption(EntryInterfaceServiceAdapter.this.pathUrl, this.toByteArray(), deleteCaches);
                }
                catch (RepositoryIOExceptionHolder e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e.getExceptionType().getMessage());
                }
                catch (SecurityExceptionHolder e) {
                    logger.error((Object)e);
                    throw new RuntimeException(e.getExceptionType().getMessage());
                }
            }
        };
    }

    @Override
    public String getParent() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDirectory() {
        return this.entryService.isDirectory(this.pathUrl);
    }

    @Override
    public boolean isKeyword(String keyword) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveTo(EntryInterface entry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllKeywords() throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeKeyword(String keyword) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void renameTo(String newContentName) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.entryService.renameTo(this.pathUrl, newContentName);
            PathUrl pathUrlObj = new PathUrl(this.pathUrl);
            pathUrlObj.setName(newContentName);
            this.pathUrl = pathUrlObj.toString();
            this.resetMetadataObject();
            EntryInterfaceServiceAdapter.fireModifiedEvents(this);
        }
        catch (RepositoryIllegalNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIllegalNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryDuplicateNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryDuplicateNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
        catch (IllegalArgumentExceptionHolder e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void setAgingPolicy(AgingPolicy agingPolicy) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setApplicationData(String applicationDataName, String value) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setApplicationData(String applicationDataName, String value, boolean transientData, boolean updateTimestamps) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKeyword(String keyword, String keywordDescription) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKeyword(String keyword) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKeywords(List keywords) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close(OutputStream stream) throws RepositoryIOException {
        try {
            stream.close();
        }
        catch (IOException e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
    }

    @Override
    public void delete() throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            HashMap<String, String> objectMap = null;
            MdFactory mdFactory = null;
            MetadataInterface mi = (MetadataInterface)this.getMetadataObject();
            if (mi != null) {
                Transformation trans = (Transformation)mi.getRepositoryEntity();
                objectMap = new HashMap<String, String>(1);
                objectMap.put(trans.getId(), trans.getCMetadataType());
                mdFactory = trans.getObjectStore().getFactory();
            }
            this.entryService.delete(this.pathUrl);
            if (objectMap != null && mdFactory != null) {
                mdFactory.fireMdObjectsDeleted(new MdFactoryEvent(mdFactory, objectMap));
            }
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
        catch (RemoteException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteContent() throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.entryService.deleteContent(this.pathUrl);
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public Object getAttribute(String attribName) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            Object attrValue = this.entryService.getAttribute(this.pathUrl, attribName);
            return UtilAttrValueConverter.convertFromServiceAttrValue(attrValue, true);
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public Iterator getAttributes() throws RepositoryException, SecurityException {
        try {
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            List attrs = this.entryService.getAttributes(this.pathUrl);
            for (AttributeEntryType attr : attrs) {
                String attrName = attr.getAttrName();
                Object attrValue = attr.getAttrValue();
                attrValue = UtilAttrValueConverter.convertFromServiceAttrValue(attrValue, true);
                attrMap.put(attrName, attrValue);
            }
            return attrMap.entrySet().iterator();
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public String getContentLocation() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getInputStream() throws RepositoryIOException, SecurityException {
        try {
            byte[] contents = this.entryService.getContent(this.pathUrl);
            return new ByteArrayInputStream(contents);
        }
        catch (RepositoryIOExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIOException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public String getName() {
        return this.entryService.getName(this.pathUrl);
    }

    @Override
    public OutputStream getOutputStream() throws SecurityException, RepositoryIOException {
        if (this.canWrite()) {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    try {
                        EntryInterfaceServiceAdapter.this.entryService.setContent(EntryInterfaceServiceAdapter.this.pathUrl, this.toByteArray());
                    }
                    catch (RepositoryIOExceptionHolder e) {
                        logger.error((Object)e);
                        throw new RuntimeException(e.getExceptionType().getMessage());
                    }
                    catch (SecurityExceptionHolder e) {
                        logger.error((Object)e);
                        throw new RuntimeException(e.getExceptionType().getMessage());
                    }
                }
            };
        }
        throw new RuntimeException("Operation failed. No WRITEMETADATA authority.");
    }

    @Override
    public EntryInterface getParentEntry() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            String retDirPathUrl = this.entryService.getParentEntry(this.pathUrl);
            return new DirectoryInterfaceServiceAdapter(this.dirService, this.entryService, this.importedEntryService, this.cacheSetService, this.cacheService, this.cacheItemService, retDirPathUrl, this.server, null);
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public long getSizeOfContent() throws UnsupportedOperationException, RepositoryException {
        try {
            return this.entryService.getSizeOfContent(this.pathUrl);
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (UnsupportedOperationExceptionHolder e) {
            logger.error((Object)e);
            throw new UnsupportedOperationException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        try {
            return this.entryService.isEmpty(this.pathUrl);
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public int read(InputStream stream, byte[] data) throws RepositoryIOException {
        try {
            return stream.read(data);
        }
        catch (IOException e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            attributeValue = UtilAttrValueConverter.convertToServiceAttrValue(attributeName, attributeValue, this.pathUrl);
            this.entryService.setAttribute(this.pathUrl, attributeName, attributeValue);
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
        catch (IllegalArgumentExceptionHolder e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void setAttributes(Map attributes) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            AttributesType attrsService = new ObjectFactory().createAttributesType();
            for (Map.Entry entry : attributes.entrySet()) {
                String attrName = (String)entry.getKey();
                Object attrValue = entry.getValue();
                attrValue = UtilAttrValueConverter.convertToServiceAttrValue(attrName, attrValue, this.pathUrl);
                AttributeEntryType attrService = new ObjectFactory().createAttributeEntryType();
                attrService.setAttrName(attrName);
                attrService.setAttrValue(attrValue);
                attrsService.getAttributeEntry().add(attrService);
            }
            this.entryService.setAttributes(this.pathUrl, attrsService);
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
        catch (IllegalArgumentExceptionHolder e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public int write(OutputStream stream, byte[] data, int len) throws RepositoryIOException {
        try {
            stream.write(data, 0, len);
        }
        catch (IOException e) {
            throw new RepositoryIOException(e, e.getMessage());
        }
        return len;
    }

    @Override
    public void deleteTransientData() throws RepositoryException, RemoteException, ServiceException {
        try {
            this.importedEntryService.deleteTransientData(this.pathUrl);
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (ServiceExceptionHolder e) {
            logger.error((Object)e);
            throw new ServiceException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public String toString() {
        if (this.pathUrl != null) {
            return this.pathUrl;
        }
        return super.toString();
    }
}

