/*
 * Decompiled with CFR 0.152.
 */
package com.sas.report.repository.adapter;

import com.sas.report.repository.AgingPolicy;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInstantiatorInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RepositoryCreateException;
import com.sas.report.repository.RepositoryDeleteException;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryFilter;
import com.sas.report.repository.RepositoryIOException;
import com.sas.report.repository.RepositoryIllegalNameException;
import com.sas.report.repository.RepositoryLockedException;
import com.sas.report.repository.RepositoryMetadataFilter;
import com.sas.report.repository.RepositoryNotDirectoryException;
import com.sas.report.repository.RepositoryNotFoundException;
import com.sas.report.repository.SortOrder;
import com.sas.report.repository.adapter.BaseMetadataAdapter;
import com.sas.report.repository.adapter.EntryInterfaceServiceAdapter;
import com.sas.report.repository.adapter.UtilAttrValueConverter;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.svcs.reportrepository.client.CacheItemServiceInterface;
import com.sas.svcs.reportrepository.client.CacheServiceInterface;
import com.sas.svcs.reportrepository.client.CacheSetServiceInterface;
import com.sas.svcs.reportrepository.client.DirectoryServiceInterface;
import com.sas.svcs.reportrepository.client.EntryServiceInterface;
import com.sas.svcs.reportrepository.client.ImportedEntryServiceInterface;
import com.sas.svcs.reportrepository.client.domain.AttributeEntryType;
import com.sas.svcs.reportrepository.client.domain.AttributesType;
import com.sas.svcs.reportrepository.client.domain.IllegalArgumentExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.ObjectFactory;
import com.sas.svcs.reportrepository.client.domain.RepositoryCreateExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryDeleteExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryDuplicateNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryIllegalNameExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryLockedExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryNotDirectoryExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.RepositoryNotFoundExceptionHolder;
import com.sas.svcs.reportrepository.client.domain.SecurityExceptionHolder;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirectoryInterfaceServiceAdapter
extends BaseMetadataAdapter
implements DirectoryInterface {
    private static final Logger logger = LogManager.getLogger(DirectoryInterfaceServiceAdapter.class);
    protected DirectoryServiceInterface dirService;
    protected EntryServiceInterface entryService;
    protected ImportedEntryServiceInterface importedEntryService;
    protected CacheSetServiceInterface cacheSetService;
    protected CacheServiceInterface cacheService;
    protected CacheItemServiceInterface cacheItemService;

    public DirectoryInterfaceServiceAdapter(DirectoryServiceInterface dirService, EntryServiceInterface entryService, ImportedEntryServiceInterface importedEntryService, CacheSetServiceInterface cacheSetService, CacheServiceInterface cacheService, CacheItemServiceInterface cacheItemService, String dirPathUrl, ServerInterface server, MetadataInterface smartObj) {
        super(dirPathUrl, server, smartObj);
        this.dirService = dirService;
        this.entryService = entryService;
        this.importedEntryService = importedEntryService;
        this.cacheSetService = cacheSetService;
        this.cacheService = cacheService;
        this.cacheItemService = cacheItemService;
    }

    @Override
    public DirectoryInterface createDirectory(String directoryName) throws RepositoryCreateException, RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        try {
            String retDirPathUrl = this.dirService.createDirectory(this.pathUrl, directoryName);
            return new DirectoryInterfaceServiceAdapter(this.dirService, this.entryService, this.importedEntryService, this.cacheSetService, this.cacheService, this.cacheItemService, retDirPathUrl, this.server, null);
        }
        catch (RepositoryCreateExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryCreateException(e.getExceptionType().getMessage());
        }
        catch (RepositoryIllegalNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIllegalNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryDuplicateNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryDuplicateNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
        catch (IllegalArgumentExceptionHolder e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void delete(RepositoryMetadataFilter filter) throws RepositoryDeleteException, RepositoryException {
        if (filter == null) {
            try {
                this.dirService.deleteWithNoFilter(this.pathUrl);
            }
            catch (RepositoryDeleteExceptionHolder e) {
                logger.error((Object)e);
                throw new RepositoryDeleteException(e.getExceptionType().getMessage());
            }
            catch (RepositoryExceptionHolder e) {
                logger.error((Object)e);
                throw new RepositoryException(e.getExceptionType().getMessage());
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public DirectoryInterface ensurePath(PathUrl dirPathUrl) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DirectoryInterface getDirectory(String name) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            String retDirPathUrl = this.dirService.getDirectory(this.pathUrl, name);
            return new DirectoryInterfaceServiceAdapter(this.dirService, this.entryService, this.importedEntryService, this.cacheSetService, this.cacheService, this.cacheItemService, retDirPathUrl, this.server, null);
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public String[] list() throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void list(List directoryV) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] list(RepositoryFilter filter) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void list(List directoryV, RepositoryFilter filter, SortOrder order) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List listDirs(RepositoryFilter filter, SortOrder order) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List listFiles(RepositoryFilter filter, SortOrder order) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryInterface createEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        try {
            String retEntryPathUrl = this.dirService.createEntry(this.pathUrl, entryName);
            EntryInterfaceServiceAdapter ei = new EntryInterfaceServiceAdapter(this.entryService, this.importedEntryService, this.dirService, this.cacheSetService, this.cacheService, this.cacheItemService, retEntryPathUrl, this.server, null);
            DirectoryInterfaceServiceAdapter.fireCreatedEvents(ei);
            return ei;
        }
        catch (RepositoryIllegalNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIllegalNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryNotDirectoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotDirectoryException(e.getExceptionType().getMessage());
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryDuplicateNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryDuplicateNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
        catch (IllegalArgumentExceptionHolder e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public boolean entryExists(String entryName) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        try {
            return this.dirService.entryExists(this.pathUrl, entryName);
        }
        catch (RepositoryIllegalNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIllegalNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public EntryInterface getEntry(String entryName) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            String retEntryPathUrl = this.dirService.getEntry(this.pathUrl, entryName);
            return new EntryInterfaceServiceAdapter(this.entryService, this.importedEntryService, this.dirService, this.cacheSetService, this.cacheService, this.cacheItemService, retEntryPathUrl, this.server, null);
        }
        catch (RepositoryIllegalNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIllegalNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void renameTo(String newContentName) throws RepositoryIllegalNameException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.dirService.renameTo(this.pathUrl, newContentName);
            PathUrl pathUrlObj = new PathUrl(this.pathUrl);
            pathUrlObj.setName(newContentName);
            this.pathUrl = pathUrlObj.toString();
        }
        catch (RepositoryIllegalNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIllegalNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryDuplicateNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryDuplicateNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
        catch (IllegalArgumentExceptionHolder e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void moveTo(EntryInterface entry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.dirService.moveTo(this.pathUrl, entry.getLocationUrl().toString());
        }
        catch (RepositoryIllegalNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIllegalNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryDuplicateNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryDuplicateNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void delete() throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            this.dirService.delete(this.pathUrl);
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public String getName() {
        return this.dirService.getName(this.pathUrl);
    }

    @Override
    public boolean isDirectory() {
        return this.dirService.isDirectory(this.pathUrl);
    }

    @Override
    public void addKeyword(String keyword) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addKeyword(String keyword, String keywordDescription) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addKeywords(List keywords) throws RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void age(long generationIncrement) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canRead() throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canWrite() throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyTo(EntryInterface entry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copyWithoutCaches(EntryInterface destEntry) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryDuplicateNameException, RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryInterface createEntry(String entryName, AgingPolicy agePolicy) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryInterface createEntry(Object entryMetadataObject) throws RepositoryIllegalNameException, RepositoryNotDirectoryException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(long generation) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AgingPolicy getAgingPolicy() throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getApplicationData(String applicationDataName) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheSetInterface getCacheSetInterface() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryInterface getEntry(String entryName, long generation) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryInterface getGeneration(long generation) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator getKeywords() throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PathUrl getLocationUrl() throws RepositoryException {
        return new PathUrl(this.pathUrl);
    }

    @Override
    public OutputStream getOutputStream(boolean deleteCaches) throws SecurityException, RepositoryIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getParent() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isKeyword(String keyword) throws RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllKeywords() throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeKeyword(String keyword) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAgingPolicy(AgingPolicy agingPolicy) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setApplicationData(String applicationDataName, String value) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setApplicationData(String applicationDataName, String value, boolean transientData, boolean updateTimestamps) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKeyword(String keyword, String keywordDescription) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKeyword(String keyword) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKeywords(List keywords) throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close(OutputStream stream) throws RepositoryIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteContent() throws RepositoryLockedException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getAttribute(String attribName) throws RepositoryNotFoundException, RepositoryException, SecurityException {
        try {
            Object attrValue = this.entryService.getAttribute(this.pathUrl, attribName);
            return UtilAttrValueConverter.convertFromServiceAttrValue(attrValue, true);
        }
        catch (RepositoryNotFoundExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotFoundException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public Iterator getAttributes() throws RepositoryException, SecurityException {
        try {
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            List attrs = this.entryService.getAttributes(this.pathUrl);
            for (AttributeEntryType attr : attrs) {
                String attrName = attr.getAttrName();
                Object attrValue = attr.getAttrValue();
                attrValue = UtilAttrValueConverter.convertFromServiceAttrValue(attrValue, true);
                attrMap.put(attrName, attrValue);
            }
            return attrMap.entrySet().iterator();
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public String getContentLocation() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getInputStream() throws RepositoryIOException, SecurityException {
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws SecurityException, RepositoryIOException {
        return null;
    }

    @Override
    public EntryInterface getParentEntry() throws RepositoryNotFoundException, RepositoryException, SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSizeOfContent() throws UnsupportedOperationException, RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(InputStream stream, byte[] data) throws RepositoryIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            attributeValue = UtilAttrValueConverter.convertToServiceAttrValue(attributeName, attributeValue, this.pathUrl);
            this.entryService.setAttribute(this.pathUrl, attributeName, attributeValue);
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
        catch (IllegalArgumentExceptionHolder e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public void setAttributes(Map attributes) throws RepositoryLockedException, RepositoryException, SecurityException {
        try {
            AttributesType attrsService = new ObjectFactory().createAttributesType();
            for (Map.Entry entry : attributes.entrySet()) {
                String attrName = (String)entry.getKey();
                Object attrValue = entry.getValue();
                attrValue = UtilAttrValueConverter.convertToServiceAttrValue(attrName, attrValue, this.pathUrl);
                AttributeEntryType attrService = new ObjectFactory().createAttributeEntryType();
                attrService.setAttrName(attrName);
                attrService.setAttrValue(attrValue);
                attrsService.getAttributeEntry().add(attrService);
            }
            this.entryService.setAttributes(this.pathUrl, attrsService);
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
        catch (IllegalArgumentExceptionHolder e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public int write(OutputStream stream, byte[] data, int len) throws RepositoryIOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        if (this.pathUrl != null) {
            return this.pathUrl;
        }
        return super.toString();
    }

    @Override
    public EntryInterface createEntry(String entryName, EntryInstantiatorInterface ei) throws RepositoryCreateException, RepositoryIllegalNameException, RepositoryLockedException, RepositoryDuplicateNameException, RepositoryException, SecurityException {
        try {
            String retEntryPathUrl = this.dirService.createEntry(this.pathUrl, entryName);
            EntryInterfaceServiceAdapter entryi = new EntryInterfaceServiceAdapter(this.entryService, this.importedEntryService, this.dirService, this.cacheSetService, this.cacheService, this.cacheItemService, retEntryPathUrl, this.server, null);
            DirectoryInterfaceServiceAdapter.fireCreatedEvents(entryi);
            return entryi;
        }
        catch (RepositoryIllegalNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryIllegalNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryNotDirectoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryNotDirectoryException(e.getExceptionType().getMessage());
        }
        catch (RepositoryLockedExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryLockedException(e.getExceptionType().getMessage());
        }
        catch (RepositoryDuplicateNameExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryDuplicateNameException(e.getExceptionType().getMessage());
        }
        catch (RepositoryExceptionHolder e) {
            logger.error((Object)e);
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
        catch (SecurityExceptionHolder e) {
            logger.error((Object)e);
            throw new SecurityException(e.getExceptionType().getMessage());
        }
        catch (IllegalArgumentExceptionHolder e) {
            logger.error((Object)e);
            throw new IllegalArgumentException(e.getExceptionType().getMessage());
        }
    }

    @Override
    public EntryInterface getEntry(String entryName, EntryInstantiatorInterface ei) throws RepositoryIllegalNameException, RepositoryNotFoundException, RepositoryException, SecurityException {
        return null;
    }

    @Override
    public boolean entryExists(String entryName, EntryInstantiatorInterface ei) throws RepositoryIllegalNameException, RepositoryException, SecurityException {
        return false;
    }
}

